/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import generic.test.AbstractGenericTest;
import generic.test.AbstractGuiTest;
import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.cmd.disassemble.ArmDisassembleCommand;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.equate.SetEquateCmd;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.label.AddLabelCmd;
import ghidra.app.cmd.label.CreateNamespacesCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.docking.settings.Settings;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.ProgramAddressFactory;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.bookmark.BookmarkDBManager;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.references.ReferenceDBManager;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharsetSettingsDefinition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.util.IntPropertyMap;
import ghidra.program.model.util.ObjectPropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.test.AbstractGhidraHeadedIntegrationTest;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.NumericUtilities;
import ghidra.util.Saveable;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import utility.function.ExceptionalCallback;

public class ProgramBuilder {
    public static final String _ARM = "ARM:LE:32:v7";
    public static final String _AARCH64 = "AARCH64:LE:64:v8A";
    public static final String _X86 = "x86:LE:32:default";
    public static final String _X86_16_REAL_MODE = "x86:LE:16:Real Mode";
    public static final String _X64 = "x86:LE:64:default";
    public static final String _8051 = "8051:BE:16:default";
    public static final String _SPARC64 = "sparc:BE:64:default";
    public static final String _MIPS = "MIPS:BE:32:default";
    public static final String _MIPS_6432 = "MIPS:BE:64:64-32addr";
    public static final String _PPC_32 = "PowerPC:BE:32:default";
    public static final String _PPC_6432 = "PowerPC:BE:64:64-32addr";
    public static final String _PPC_64 = "PowerPC:BE:64:default";
    public static final String _TOY_BE = "Toy:BE:32:default";
    public static final String _TOY_BE_POSITIVE = "Toy:BE:32:posStack";
    public static final String _TOY_LE = "Toy:LE:32:default";
    public static final String _TOY_WORDSIZE2_BE = "Toy:BE:32:wordSize2";
    public static final String _TOY_WORDSIZE2_LE = "Toy:LE:32:wordSize2";
    public static final String _TOY64_BE = "Toy:BE:64:default";
    public static final String _TOY64_LE = "Toy:LE:64:default";
    public static final String _TOY = "Toy:BE:32:default";
    protected static final String _TOY_LANGUAGE_PREFIX = "Toy:";
    private static final Map<String, Language> LANGUAGE_CACHE = new HashMap<String, Language>();
    private ProgramDB program;
    private int transactionID;
    private int transactionCount = 0;

    public ProgramBuilder() throws Exception {
        this("Test Program", "Toy:BE:32:default");
    }

    public ProgramBuilder(String name, String languageName) throws Exception {
        this(name, languageName, null, null);
    }

    public ProgramBuilder(String name, String languageName, Object consumer) throws Exception {
        this(name, languageName, null, consumer);
    }

    public ProgramBuilder(String name, String languageName, String compilerSpecID, Object consumer) throws Exception {
        Language language = ProgramBuilder.getLanguage(languageName);
        CompilerSpec compilerSpec = compilerSpecID == null ? language.getDefaultCompilerSpec() : language.getCompilerSpecByID(new CompilerSpecID(compilerSpecID));
        this.program = new ProgramDB(name, language, compilerSpec, consumer == null ? this : consumer);
        this.setAnalyzed();
        this.program.setTemporary(true);
    }

    public ProgramBuilder(String name, Language language) throws Exception {
        CompilerSpec compilerSpec = language.getDefaultCompilerSpec();
        this.program = new ProgramDB(name, language, compilerSpec, (Object)this);
        this.setAnalyzed();
        this.program.setTemporary(true);
    }

    public void analyze() {
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager((Program)this.program);
        this.tx(() -> {
            mgr.reAnalyzeAll(this.program.getMemory().getLoadedAndInitializedAddressSet());
            mgr.startAnalysis(TaskMonitor.DUMMY, false);
        });
        PluginTool analysisTool = mgr.getAnalysisTool();
        if (analysisTool != null) {
            AbstractGhidraHeadedIntegrationTest.waitForBusyTool(analysisTool);
        }
    }

    public ProgramDB getProgram() {
        this.program.flushEvents();
        return this.program;
    }

    public Language getLanguage() {
        return this.program.getLanguage();
    }

    public CompilerSpec getCompilerSpec() {
        return this.program.getCompilerSpec();
    }

    public Register getRegister(String regName) {
        return this.program.getRegister(regName);
    }

    public Address addr(long offset) {
        ProgramAddressFactory addressFactory = this.program.getAddressFactory();
        return addressFactory.getDefaultAddressSpace().getAddress(offset);
    }

    public Address addr(String addressString) {
        ProgramAddressFactory addressFactory = this.program.getAddressFactory();
        Address addr = addressFactory.getAddress(addressString);
        if (addr == null) {
            throw new IllegalArgumentException("Failed to parse address string: " + addressString);
        }
        return addr;
    }

    public void dispose() {
        if (this.program.isUsedBy((Object)this)) {
            this.flushEvents();
            this.program.release((Object)this);
        }
    }

    private void flushEvents() {
        this.program.flushEvents();
        if (!SystemUtilities.isInHeadlessMode()) {
            AbstractGuiTest.waitForSwing();
        }
    }

    public void setName(String name) {
        this.tx(() -> this.program.setName(name));
    }

    public void withTransaction(Runnable r) {
        this.tx(() -> r.run());
    }

    protected void startTransaction() {
        if (this.transactionCount++ == 0) {
            this.transactionID = this.program.startTransaction("Test Transaction");
        }
    }

    protected void endTransaction() {
        this.endTransaction(true);
    }

    protected void endTransaction(boolean commit) {
        if (--this.transactionCount == 0) {
            this.program.endTransaction(this.transactionID, true);
        }
    }

    private static Language getLanguage(String languageId) throws LanguageNotFoundException {
        Language language = LANGUAGE_CACHE.get(languageId);
        if (language == null) {
            language = DefaultLanguageService.getLanguageService().getLanguage(new LanguageID(languageId));
            LANGUAGE_CACHE.put(languageId, language);
        }
        return language;
    }

    public void setRecordChanges(boolean enabled) {
        AbstractGenericTest.setInstanceField((String)"recordChanges", (Object)this.program, (Object)enabled);
    }

    public void setAnalyzed() {
        GhidraProgramUtilities.markProgramAnalyzed((Program)this.program);
    }

    public MemoryBlock createMemory(String name, String address, int size) {
        return this.createMemory(name, address, size, null);
    }

    public MemoryBlock createMemory(String name, String address, int size, String comment) {
        return this.createMemory(name, address, size, comment, (byte)0);
    }

    public MemoryBlock createMemory(String name, String address, FileBytes fileBytes, int size) {
        return this.tx(() -> {
            Address startAddress = this.addr(address);
            MemoryMapDB memory = this.program.getMemory();
            return memory.createInitializedBlock(name, startAddress, fileBytes, 0L, (long)size, false);
        });
    }

    public MemoryBlock createMemory(String name, String address, int size, String comment, byte initialValue) {
        return this.tx(() -> {
            Address startAddress = this.addr(address);
            MemoryMapDB memory = this.program.getMemory();
            MemoryBlock block = memory.createInitializedBlock(name, startAddress, (long)size, initialValue, TaskMonitor.DUMMY, false);
            block.setComment(comment);
            return block;
        });
    }

    public MemoryBlock createUninitializedMemory(String name, String address, int size) {
        return this.tx(() -> {
            Address startAddress = this.addr(address);
            MemoryMapDB memory = this.program.getMemory();
            return memory.createUninitializedBlock(name, startAddress, (long)size, false);
        });
    }

    public MemoryBlock createOverlayMemory(String name, String address, int size) {
        return this.tx(() -> this.program.getMemory().createInitializedBlock(name, this.addr(address), (long)size, (byte)0, TaskMonitor.DUMMY, true));
    }

    public void setBytes(String address, String byteString) throws Exception {
        byte[] bytes = NumericUtilities.convertStringToBytes((String)byteString);
        this.setBytes(address, bytes, false);
    }

    public void setBytes(String address, String byteString, boolean disassemble) throws Exception {
        byte[] bytes = NumericUtilities.convertStringToBytes((String)byteString);
        this.setBytes(address, bytes, disassemble);
    }

    public void setBytes(String stringAddress, byte[] bytes) throws Exception {
        this.setBytes(stringAddress, bytes, false);
    }

    public void setBytes(String stringAddress, byte[] bytes, boolean disassemble) throws Exception {
        Address address = this.addr(stringAddress);
        this.tx(() -> {
            MemoryBlock block = this.program.getMemory().getBlock(address);
            if (block == null) {
                this.createMemory("Block_" + stringAddress.toString().replace(':', '_'), stringAddress, bytes.length);
            }
            MemoryMapDB memory = this.program.getMemory();
            memory.setBytes(address, bytes);
        });
        if (disassemble) {
            this.disassemble(stringAddress, bytes.length);
        }
    }

    public void setString(String address, String string) throws Exception {
        byte[] bytes = string.getBytes();
        this.setBytes(address, bytes);
    }

    public void setShort(String address, short value) throws Exception {
        DataConverter converter = this.getDataConverter();
        byte[] bytes = converter.getBytes(value);
        this.setBytes(address, bytes);
    }

    public void setInt(String address, int value) throws Exception {
        DataConverter converter = this.getDataConverter();
        byte[] bytes = converter.getBytes(value);
        this.setBytes(address, bytes);
    }

    public void setLong(String address, long value) throws Exception {
        DataConverter converter = this.getDataConverter();
        byte[] bytes = converter.getBytes(value);
        this.setBytes(address, bytes);
    }

    public void putAddress(String address, String pointerAddress) throws Exception {
        Address pointer = this.addr(pointerAddress);
        long offset = pointer.getOffset();
        int pointerSize = pointer.getAddressSpace().getPointerSize();
        switch (pointerSize) {
            case 2: {
                this.setShort(address, (short)offset);
                break;
            }
            case 4: {
                this.setInt(address, (int)offset);
                break;
            }
            default: {
                this.setLong(address, offset);
            }
        }
    }

    private DataConverter getDataConverter() {
        boolean bigEndian = this.program.getMemory().isBigEndian();
        return bigEndian ? BigEndianDataConverter.INSTANCE : LittleEndianDataConverter.INSTANCE;
    }

    public void setRead(MemoryBlock block, boolean r) {
        this.tx(() -> block.setRead(r));
    }

    public void setWrite(MemoryBlock block, boolean w) {
        this.tx(() -> block.setWrite(w));
    }

    public void setExecute(MemoryBlock block, boolean e) {
        this.tx(() -> block.setExecute(e));
    }

    public void disassemble(String addressString, int length) {
        this.disassemble(addressString, length, true);
    }

    public void disassemble(String addressString, int length, boolean followFlows) {
        this.tx(() -> {
            Address address = this.addr(addressString);
            AddressSet addresses = new AddressSet(address, address.add((long)(length - 1)));
            DisassembleCommand cmd = new DisassembleCommand((AddressSetView)addresses, (AddressSetView)addresses, followFlows);
            cmd.applyTo((DomainObject)this.program);
            AutoAnalysisManager.getAnalysisManager((Program)this.program).startAnalysis(TaskMonitor.DUMMY, false);
        });
    }

    public void disassemble(AddressSetView set) {
        this.tx(() -> {
            DisassembleCommand cmd = new DisassembleCommand(set, set, true);
            cmd.applyTo((DomainObject)this.program);
            AutoAnalysisManager.getAnalysisManager((Program)this.program).startAnalysis(TaskMonitor.DUMMY, false);
        });
    }

    public void disassemble(AddressSetView set, boolean followFlows) {
        this.tx(() -> {
            DisassembleCommand cmd = new DisassembleCommand(set, set, followFlows);
            cmd.applyTo((DomainObject)this.program);
            AutoAnalysisManager.getAnalysisManager((Program)this.program).startAnalysis(TaskMonitor.DUMMY, false);
        });
    }

    public void disassembleArm(String addressString, int length, boolean thumb) {
        this.tx(() -> {
            Address address = this.addr(addressString);
            ArmDisassembleCommand cmd = new ArmDisassembleCommand(address, (AddressSetView)new AddressSet(address, address.add((long)(length - 1))), true);
            cmd.applyTo((DomainObject)this.program);
            AutoAnalysisManager.getAnalysisManager((Program)this.program).startAnalysis(TaskMonitor.DUMMY, false);
        });
    }

    public void clearCodeUnits(String startAddressString, String endAddressString, boolean clearContext) throws Exception {
        this.tx(() -> {
            Address startAddress = this.addr(startAddressString);
            Address endAddress = this.addr(endAddressString);
            Listing listing = this.program.getListing();
            listing.clearCodeUnits(startAddress, endAddress, clearContext);
        });
    }

    public Symbol createLabel(String addressString, String name) {
        return this.tx(() -> {
            Address address = this.addr(addressString);
            AddLabelCmd cmd = new AddLabelCmd(address, name, SourceType.USER_DEFINED);
            cmd.applyTo((Program)this.program);
            return cmd.getSymbol();
        });
    }

    public Symbol createLabel(String addressString, String name, String namespace) {
        return this.tx(() -> {
            Address address = this.addr(addressString);
            Namespace ns = this.getNamespace(namespace, address);
            AddLabelCmd cmd = new AddLabelCmd(address, name, ns, SourceType.USER_DEFINED);
            cmd.applyTo((Program)this.program);
            return cmd.getSymbol();
        });
    }

    public Function createFunction(String addressString) {
        return this.tx(() -> {
            Address address = this.addr(addressString);
            CreateFunctionCmd cmd = new CreateFunctionCmd(address);
            cmd.applyTo((DomainObject)this.program);
            return cmd.getFunction();
        });
    }

    public void addFunctionVariable(Function f, Variable v) throws Exception {
        this.tx(() -> f.addLocalVariable(v, SourceType.USER_DEFINED));
    }

    public Function createEmptyFunction(String name, String address, int size, DataType returnType, Parameter ... params) throws Exception, OverlappingFunctionException {
        return this.createEmptyFunction(name, null, null, false, address, size, returnType, params);
    }

    public Function createEmptyFunction(String name, String address, int size, DataType returnType, boolean varargs, boolean inline, boolean noReturn, Parameter ... params) throws Exception {
        return this.tx(() -> {
            Function fun = this.createEmptyFunction(name, null, null, false, address, size, returnType, params);
            fun.setVarArgs(varargs);
            fun.setInline(inline);
            fun.setNoReturn(noReturn);
            return fun;
        });
    }

    public Function createEmptyFunction(String name, String namespace, String address, int bodySize, DataType returnType, Parameter ... params) throws Exception {
        return this.createEmptyFunction(name, namespace, null, false, address, bodySize, returnType, params);
    }

    public Function createEmptyFunction(String name, String namespace, String callingConventionName, boolean customStorage, String address, int bodySize, DataType returnType, Parameter ... params) throws Exception {
        return this.tx(() -> {
            Address entryPoint = this.addr(address);
            Address endAddress = entryPoint.add((long)(bodySize - 1));
            AddressSet body = new AddressSet(entryPoint, endAddress);
            FunctionManagerDB functionManager = this.program.getFunctionManager();
            Function function = null;
            if (namespace == null) {
                function = functionManager.createFunction(name, entryPoint, (AddressSetView)body, SourceType.USER_DEFINED);
            } else {
                Namespace ns = this.getNamespace(namespace);
                function = functionManager.createFunction(name, ns, entryPoint, (AddressSetView)body, SourceType.USER_DEFINED);
            }
            Parameter[] myParams = params;
            if (myParams == null) {
                myParams = new Parameter[]{};
            }
            ReturnParameterImpl returnVar = returnType != null ? new ReturnParameterImpl(returnType, (Program)this.program) : function.getReturn();
            function.updateFunction(callingConventionName, (Variable)returnVar, customStorage ? Function.FunctionUpdateType.CUSTOM_STORAGE : Function.FunctionUpdateType.DYNAMIC_STORAGE_FORMAL_PARAMS, false, SourceType.USER_DEFINED, (Variable[])myParams);
            return function;
        });
    }

    public Function createEmptyFunction(String name, String namespace, String callingConventionName, String address, int size, DataType returnType, DataType ... paramTypes) throws Exception {
        ParameterImpl[] params = new ParameterImpl[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            params[i] = new ParameterImpl(null, paramTypes[i], (Program)this.program);
        }
        return this.createEmptyFunction(name, namespace, callingConventionName, false, address, size, returnType, (Parameter[])params);
    }

    public void deleteFunction(String address) throws Exception {
        this.tx(() -> {
            Address entryPoint = this.addr(address);
            FunctionManagerDB functionManager = this.program.getFunctionManager();
            functionManager.removeFunction(entryPoint);
        });
    }

    public Library createLibrary(String libraryName) throws DuplicateNameException, InvalidInputException {
        return this.createLibrary(libraryName, SourceType.USER_DEFINED);
    }

    public Library createLibrary(String libraryName, SourceType type) throws DuplicateNameException, InvalidInputException {
        SymbolManager symbolTable = this.program.getSymbolTable();
        return symbolTable.createExternalLibrary(libraryName, type);
    }

    public Namespace createNamespace(String namespace) {
        return this.createNamespace(namespace, SourceType.USER_DEFINED);
    }

    public Namespace getNamespace(String namespace) {
        if (namespace == null) {
            return null;
        }
        try {
            return NamespaceUtils.createNamespaceHierarchy((String)namespace, null, (Program)this.program, (SourceType)SourceType.USER_DEFINED);
        }
        catch (InvalidInputException e) {
            throw new RuntimeException(e);
        }
    }

    public Namespace getNamespace(String namespace, Address address) {
        if (namespace == null) {
            return null;
        }
        try {
            return NamespaceUtils.createNamespaceHierarchy((String)namespace, null, (Program)this.program, (Address)address, (SourceType)SourceType.USER_DEFINED);
        }
        catch (InvalidInputException e) {
            throw new RuntimeException(e);
        }
    }

    public Namespace createNamespace(String namespace, SourceType type) {
        return this.createNamespace(namespace, null, type);
    }

    public Namespace createNamespace(String namespace, String parentNamespace, SourceType type) {
        return this.tx(() -> {
            Namespace ns = this.getNamespace(parentNamespace);
            CreateNamespacesCmd cmd = new CreateNamespacesCmd(namespace, ns, type);
            cmd.applyTo((Program)this.program);
            return cmd.getNamespace();
        });
    }

    public GhidraClass createClassNamespace(String name, String parentNamespace, SourceType type) throws Exception {
        return this.tx(() -> {
            Namespace ns = this.getNamespace(parentNamespace);
            SymbolManager symbolTable = this.program.getSymbolTable();
            GhidraClass c = symbolTable.createClass(ns, name, SourceType.USER_DEFINED);
            return c;
        });
    }

    public void applyFixedLengthDataType(String addressString, DataType dt, int length) {
        this.tx(() -> DataUtilities.createData((Program)this.program, (Address)this.addr(addressString), (DataType)dt, (int)length, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA));
    }

    public void applyDataType(String addressString, DataType dt) {
        this.applyDataType(addressString, dt, 1);
    }

    public void applyDataType(String addressString, DataType dt, int n) {
        this.tx(() -> {
            Address address = this.addr(addressString);
            for (int i = 0; i < n; ++i) {
                CreateDataCmd cmd = new CreateDataCmd(address, true, dt);
                if (!cmd.applyTo((Program)this.program)) {
                    throw new AssertException("Could not apply data at address " + String.valueOf(address) + ". " + cmd.getStatusMsg());
                }
                address = address.add((long)dt.getLength());
            }
        });
    }

    public void applyStringDataType(String addressString, AbstractStringDataType dt, int n) {
        this.tx(() -> {
            Address address = this.addr(addressString);
            int previousDataLength = 0;
            for (int i = 0; i < n; ++i) {
                address = address.addNoWrap((long)previousDataLength);
                Data newStringInstance = DataUtilities.createData((Program)this.program, (Address)address, (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_SINGLE_DATA);
                previousDataLength = newStringInstance.getLength();
            }
        });
    }

    public void deleteReference(Reference reference) {
        this.tx(() -> {
            ReferenceDBManager refMgr = this.program.getReferenceManager();
            refMgr.delete(reference);
        });
    }

    public Reference createMemoryReadReference(String fromAddress, String toAddress) {
        return this.createMemoryReference(fromAddress, toAddress, RefType.READ, SourceType.USER_DEFINED);
    }

    public Reference createMemoryCallReference(String fromAddress, String toAddress) {
        return this.createMemoryReference(fromAddress, toAddress, (RefType)RefType.UNCONDITIONAL_CALL, SourceType.USER_DEFINED);
    }

    public Reference createMemoryJumpReference(String fromAddress, String toAddress) {
        return this.createMemoryReference(fromAddress, toAddress, (RefType)RefType.UNCONDITIONAL_JUMP, SourceType.USER_DEFINED);
    }

    public Reference createMemoryReference(String fromAddress, String toAddress, RefType refType, SourceType sourceType) {
        return this.createMemoryReference(fromAddress, toAddress, refType, sourceType, 0);
    }

    public Reference createMemoryReference(String fromAddress, String toAddress, RefType refType, SourceType sourceType, int opIndex) {
        return this.tx(() -> {
            ReferenceDBManager refManager = this.program.getReferenceManager();
            Reference ref = refManager.addMemoryReference(this.addr(fromAddress), this.addr(toAddress), refType, sourceType, opIndex);
            return ref;
        });
    }

    public Reference createOffsetMemReference(String fromAddress, String toAddress, int offset, RefType refType, SourceType sourceType, int opIndex) {
        return this.tx(() -> {
            ReferenceDBManager refManager = this.program.getReferenceManager();
            Reference ref = refManager.addOffsetMemReference(this.addr(fromAddress), this.addr(toAddress), false, (long)offset, refType, sourceType, opIndex);
            return ref;
        });
    }

    public Reference createStackReference(String fromAddress, RefType refType, int stackOffset, SourceType sourceType, int opIndex) {
        return this.tx(() -> {
            ReferenceDBManager refManager = this.program.getReferenceManager();
            Reference ref = refManager.addStackReference(this.addr(fromAddress), opIndex, stackOffset, refType, sourceType);
            return ref;
        });
    }

    public Reference createRegisterReference(String fromAddress, String registerName, int opIndex) {
        return this.createRegisterReference(fromAddress, RefType.DATA, registerName, SourceType.USER_DEFINED, opIndex);
    }

    public Reference createRegisterReference(String fromAddress, RefType refType, String registerName, SourceType sourceType, int opIndex) {
        return this.tx(() -> {
            ReferenceDBManager refManager = this.program.getReferenceManager();
            Register register = this.program.getRegister(registerName);
            Reference ref = refManager.addRegisterReference(this.addr(fromAddress), opIndex, register, refType, sourceType);
            return ref;
        });
    }

    public Symbol createEntryPoint(String addressString, String name) {
        return this.tx(() -> {
            SymbolManager symbolTable = this.program.getSymbolTable();
            symbolTable.addExternalEntryPoint(this.addr(addressString));
            Symbol[] symbols = symbolTable.getSymbols(this.addr(addressString));
            symbols[0].setName(name, SourceType.ANALYSIS);
            return symbols[0];
        });
    }

    public Bookmark createBookmark(String address, String bookmarkType, String category, String comment) {
        return this.tx(() -> {
            BookmarkDBManager bookMgr = this.program.getBookmarkManager();
            Address addr = this.addr(address);
            Bookmark bm = bookMgr.setBookmark(addr, bookmarkType, category, comment);
            return bm;
        });
    }

    public void createEncodedString(String address, String string, Charset encoding, boolean nullTerminate) throws Exception {
        byte[] bytes = string.getBytes(encoding);
        if (encoding == StandardCharsets.US_ASCII || encoding == StandardCharsets.UTF_8) {
            if (nullTerminate) {
                bytes = Arrays.copyOf(bytes, bytes.length + 1);
            }
            this.setBytes(address, bytes);
            this.applyDataType(address, (DataType)new StringDataType(), 1);
        } else if (encoding == StandardCharsets.UTF_16BE || encoding == StandardCharsets.UTF_16LE) {
            if (nullTerminate) {
                bytes = Arrays.copyOf(bytes, bytes.length + 2);
                this.setBytes(address, bytes);
                this.applyDataType(address, (DataType)new TerminatedUnicodeDataType(), 1);
            } else {
                this.setBytes(address, bytes);
            }
        } else {
            this.setBytes(address, bytes);
        }
    }

    public Data createString(String address, String string, Charset charset, boolean nullTerminate, DataType dataType) throws Exception {
        if (nullTerminate) {
            string = (String)string + "\u0000";
        }
        byte[] bytes = ((String)string).getBytes(charset);
        return this.createString(address, bytes, charset, dataType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data createString(String address, byte[] stringBytes, Charset charset, DataType dataType) throws Exception {
        Address addr = this.addr(address);
        this.setBytes(address, stringBytes);
        if (dataType != null) {
            this.startTransaction();
            try {
                Data data = DataUtilities.createData((Program)this.program, (Address)addr, (DataType)dataType, (int)stringBytes.length, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
                CharsetSettingsDefinition.CHARSET.setCharset((Settings)data, charset.name());
                Data data2 = data;
                return data2;
            }
            finally {
                this.endTransaction();
            }
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        this.tx(() -> {
            Options options = this.program.getOptions("Program Information");
            options.putObject(name, value);
        });
    }

    public void setAnalysisEnabled(String name, boolean enabled) {
        this.tx(() -> {
            Options options = this.program.getOptions("Analyzers");
            options.setBoolean(name, enabled);
        });
    }

    public void addDataType(DataType dt) {
        this.tx(() -> {
            ProgramDataTypeManager dtm = this.program.getDataTypeManager();
            dtm.addDataType(dt, DataTypeConflictHandler.REPLACE_HANDLER);
        });
    }

    public void addCategory(CategoryPath path) {
        this.tx(() -> {
            ProgramDataTypeManager dtm = this.program.getDataTypeManager();
            dtm.createCategory(path);
        });
    }

    public void createProgramTree(String treeName) throws Exception {
        this.tx(() -> this.program.getListing().createRootModule(treeName));
    }

    public void createFragment(String treeName, String modulePath, String fragmentName, String startAddr, String endAddr) throws Exception {
        this.tx(() -> {
            ProgramModule module = this.getOrCreateModule(treeName, modulePath);
            ProgramFragment fragment = module.createFragment(fragmentName);
            fragment.move(this.addr(startAddr), this.addr(endAddr));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramModule getOrCreateModule(String treeName, String modulePath) throws Exception {
        ProgramModule m;
        this.startTransaction();
        try {
            ProgramModule rootModule = this.program.getListing().getRootModule(treeName);
            if (modulePath == null || modulePath.length() == 0) {
                ProgramModule programModule = rootModule;
                return programModule;
            }
            String[] modules = modulePath.split("\\.");
            m = rootModule;
            for (String moduleName : modules) {
                m = this.getOrCreateChildModule(m, moduleName);
            }
        }
        finally {
            this.endTransaction();
        }
        return m;
    }

    private ProgramModule getOrCreateChildModule(ProgramModule m, String moduleName) throws Exception {
        Group[] children;
        for (Group group : children = m.getChildren()) {
            if (!group.getName().equals(moduleName)) continue;
            return (ProgramModule)group;
        }
        return m.createModule(moduleName);
    }

    public Equate createEquate(String address, String name, long value, int opIndex) {
        return this.tx(() -> {
            SetEquateCmd cmd = new SetEquateCmd(name, this.addr(address), opIndex, value);
            cmd.applyTo((Program)this.program);
            return cmd.getEquate();
        });
    }

    @Deprecated(forRemoval=true, since="11.4")
    public void createComment(String address, String comment, int commentType) {
        this.createComment(address, comment, CommentType.valueOf((int)commentType));
    }

    public void createComment(String address, String comment, CommentType commentType) {
        this.tx(() -> {
            Listing listing = this.program.getListing();
            listing.setComment(this.addr(address), commentType, comment);
        });
    }

    public void createFunctionComment(String entryPointAddress, String comment) {
        this.tx(() -> {
            FunctionManagerDB functionManager = this.program.getFunctionManager();
            Address addr = this.addr(entryPointAddress);
            Function function = functionManager.getFunctionAt(addr);
            function.setComment(comment);
        });
    }

    public void setFallthrough(String from, String to) {
        this.tx(() -> {
            Listing listing = this.program.getListing();
            Instruction inst = listing.getInstructionAt(this.addr(from));
            inst.setFallThrough(this.addr(to));
        });
    }

    public void createExternalLibraries(String ... libraryNames) throws Exception {
        this.tx(() -> {
            SymbolManager symbolTable = this.program.getSymbolTable();
            for (String libraryName : libraryNames) {
                symbolTable.createExternalLibrary(libraryName, SourceType.IMPORTED);
            }
        });
    }

    public void bindExternalLibrary(String libraryName, String pathname) throws Exception {
        this.tx(() -> this.program.getExternalManager().setExternalPath(libraryName, pathname, true));
    }

    public void createExternalReference(String fromAddress, String libraryName, String externalLabel, int opIndex) throws Exception {
        this.createExternalReference(fromAddress, libraryName, externalLabel, null, opIndex, RefType.DATA, SourceType.IMPORTED);
    }

    public void createExternalReference(String fromAddress, String libraryName, String externalLabel, String extAddress, int opIndex) throws Exception {
        this.createExternalReference(fromAddress, libraryName, externalLabel, extAddress, opIndex, RefType.DATA, SourceType.IMPORTED);
    }

    public void createExternalReference(String fromAddress, String libraryName, String externalLabel, String extAddress, int opIndex, RefType refType, SourceType sourceType) throws Exception {
        this.tx(() -> {
            ReferenceDBManager refMgr = this.program.getReferenceManager();
            Address eAddress = extAddress == null ? null : this.addr(extAddress);
            SymbolManager symTable = this.program.getSymbolTable();
            ExternalManagerDB extMgr = this.program.getExternalManager();
            Library namespace = extMgr.addExternalLibraryName(libraryName, sourceType);
            String myExternalLabel = externalLabel;
            if (myExternalLabel != null && myExternalLabel.indexOf("::") > 0) {
                SymbolPath symPath = new SymbolPath(myExternalLabel);
                myExternalLabel = symPath.getName();
                namespace = NamespaceUtils.createNamespaceHierarchy((String)symPath.getParentPath(), (Namespace)namespace, (Program)this.program, null, (SourceType)sourceType);
            }
            Reference ref = refMgr.addExternalReference(this.addr(fromAddress), libraryName, myExternalLabel, eAddress, sourceType, opIndex, refType);
            if (!(namespace instanceof Library)) {
                Symbol s = symTable.getSymbol(ref);
                s.setNamespace((Namespace)namespace);
            }
        });
    }

    public ExternalLocation createExternalFunction(String extAddress, String libName, String functionName) throws Exception {
        return this.tx(() -> {
            ExternalManagerDB em = this.program.getExternalManager();
            Address eAddress = extAddress == null ? null : this.addr(extAddress);
            return em.addExtFunction(libName, functionName, eAddress, SourceType.IMPORTED);
        });
    }

    public ExternalLocation createExternalFunction(String extAddress, String libName, String functionName, String originalName) throws Exception {
        return this.tx(() -> {
            ExternalManagerDB em = this.program.getExternalManager();
            Address eAddress = extAddress == null ? null : this.addr(extAddress);
            ExternalLocation extLoc = em.addExtFunction("<EXTERNAL>", originalName, eAddress, SourceType.IMPORTED);
            Library lib = em.addExternalLibraryName(libName, SourceType.IMPORTED);
            extLoc.setName((Namespace)lib, functionName, SourceType.IMPORTED);
            return extLoc;
        });
    }

    public void createLocalVariable(Function function, String name, DataType dt, int stackOffset) throws Exception {
        this.tx(() -> {
            LocalVariableImpl variable = new LocalVariableImpl(name, dt, stackOffset, (Program)this.program);
            function.addLocalVariable((Variable)variable, SourceType.USER_DEFINED);
        });
    }

    public void setRegisterValue(String registerName, String startAddress, String endAddress, long value) throws Exception {
        this.tx(() -> {
            Register register = this.program.getRegister(registerName);
            ProgramContext programContext = this.program.getProgramContext();
            programContext.setValue(register, this.addr(startAddress), this.addr(endAddress), BigInteger.valueOf(value));
        });
    }

    public void setIntProperty(String address, String propertyName, int value) throws Exception {
        this.tx(() -> {
            PropertyMapManager pm = this.program.getUsrPropertyManager();
            IntPropertyMap propertyMap = pm.getIntPropertyMap(propertyName);
            if (propertyMap == null) {
                propertyMap = pm.createIntPropertyMap(propertyName);
            }
            propertyMap.add(this.addr(address), value);
        });
    }

    public void setStringProperty(String address, String propertyName, String value) throws Exception {
        this.tx(() -> {
            PropertyMapManager pm = this.program.getUsrPropertyManager();
            StringPropertyMap propertyMap = pm.getStringPropertyMap(propertyName);
            if (propertyMap == null) {
                propertyMap = pm.createStringPropertyMap(propertyName);
            }
            propertyMap.add(this.addr(address), value);
        });
    }

    public void setObjectProperty(String address, String propertyName, Saveable value) throws Exception {
        this.tx(() -> {
            PropertyMapManager pm = this.program.getUsrPropertyManager();
            ObjectPropertyMap propertyMap = pm.getObjectPropertyMap(propertyName);
            if (propertyMap == null) {
                propertyMap = pm.createObjectPropertyMap(propertyName, value.getClass());
            }
            propertyMap.add(this.addr(address), (Object)value);
        });
    }

    public void setChanged(boolean changed) {
        this.program.setChanged(changed);
    }

    public FileBytes createFileBytes(int size) throws Exception {
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = (byte)i;
        }
        return this.tx(() -> {
            FileBytes fileBytes = this.program.getMemory().createFileBytes("test", 0L, (long)size, (InputStream)new ByteArrayInputStream(bytes), TaskMonitor.DUMMY);
            return fileBytes;
        });
    }

    public <E extends Exception> void tx(ExceptionalCallback<E> c) {
        this.startTransaction();
        boolean commit = true;
        try {
            c.call();
        }
        catch (Exception e) {
            commit = false;
            throw new AssertException((Throwable)e);
        }
        finally {
            this.endTransaction(commit);
        }
    }

    public <R, E extends Exception> R tx(ExceptionalSupplier<R, E> s) {
        this.startTransaction();
        boolean commit = true;
        try {
            R r = s.get();
            return r;
        }
        catch (Exception e) {
            commit = false;
            throw new AssertException((Throwable)e);
        }
        finally {
            this.endTransaction(commit);
        }
    }

    public static interface ExceptionalSupplier<R, E extends Exception> {
        public R get() throws E;
    }
}

