/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.RecordTranslator;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.data.PointerDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class PointerDBAdapterV1
extends PointerDBAdapter {
    static final int VERSION = 1;
    static final int V1_PTR_DT_ID_COL = 0;
    static final int V1_PTR_CATEGORY_COL = 1;
    private Table table;

    PointerDBAdapterV1(DBHandle handle) throws VersionException {
        this.table = handle.getTable("Pointers");
        if (this.table == null) {
            throw new VersionException("Missing Table: Pointers");
        }
        int versionNumber = this.table.getSchema().getVersion();
        if (versionNumber != 1) {
            throw new VersionException("Expected version 1 for table Pointers but got " + versionNumber);
        }
    }

    public DBRecord translateRecord(DBRecord oldRec) {
        if (oldRec == null) {
            return null;
        }
        DBRecord rec = PointerDBAdapter.SCHEMA.createRecord(oldRec.getKey());
        rec.setLongValue(0, oldRec.getLongValue(0));
        rec.setLongValue(1, oldRec.getLongValue(1));
        rec.setByteValue(2, (byte)-1);
        return rec;
    }

    @Override
    DBRecord createRecord(long dataTypeID, long categoryID, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    DBRecord getRecord(long pointerID) throws IOException {
        return this.translateRecord(this.table.getRecord(pointerID));
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.table.iterator(), (RecordTranslator)this);
    }

    @Override
    boolean removeRecord(long pointerID) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void updateRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Field[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 1);
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Pointers");
    }

    @Override
    public int getRecordCount() {
        return this.table.getRecordCount();
    }
}

