/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.parallel;

import generic.concurrent.QCallback;
import generic.concurrent.QResult;
import ghidra.app.util.DecompilerConcurrentQ;
import ghidra.program.model.listing.Function;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ChunkingParallelDecompiler<R> {
    private DecompilerConcurrentQ<Function, R> queue;

    ChunkingParallelDecompiler(QCallback<Function, R> callback, TaskMonitor monitor) {
        this.queue = new DecompilerConcurrentQ<Function, R>(callback, "Parallel Decompiler", monitor);
    }

    public List<R> decompileFunctions(List<Function> functions) throws InterruptedException, Exception {
        this.queue.addAll(functions);
        Collection<QResult<Function, R>> qResults = this.queue.waitForResults();
        ArrayList<Object> results = new ArrayList<Object>();
        for (QResult<Function, R> qResult : qResults) {
            results.add(qResult.getResult());
        }
        return results;
    }

    public void dispose() {
        this.queue.dispose();
    }
}

