**Note:** This file is automatically generated. Please see the [developer
documentation](doc/development/changelog.md) for instructions on adding your own
entry.

## 18.6.2 (2025-12-10)

### Fixed (3 changes)

- [Handle 429s during github LFS import](https://gitlab.com/gitlab-org/security/gitlab/-/commit/de982c5ce9f7cb3d68b487aef4d5770d1ae32fed)
- [Fix partition missing error in project_daily_statistics backfill](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a9a2a6f278f822d1fb73336a55696fcf94dca055)
- [Update diff note representation](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2ad30bf915c8adf50c1ddb56441a61a7a48a9279)

### Changed (2 changes)

- [Fix: Restore branch protection check in cache_suffix_for](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c30a088a7d553805e9c4e7afda52c563c47eb8e6)
- [Ensure LFS imports work correctly with nil revisions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b32e678fe2ddecefd70a9a9823753847a09c20cf)

### Security (10 changes)

- [Hide private project name to unauthorized users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7060745b8ada531cc1445df9afc9fef3d3aef24a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5550))
- [Reflected External Path Injection in Swagger UI at /-/sandbox/swagger via...](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d9abe4b48fa7afd2cfc278b1dbb28e7c83ae9c59) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5568))
- [Apply requestBodyUploader to commit creation endpoints](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3bd577e0ee92c19cb9e48d370e215eae6458ebdc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5581))
- [Fix "Total 2FA Bypass for Users"](https://gitlab.com/gitlab-org/security/gitlab/-/commit/887505e8fcfa67bd4f483b68bbdf541e6c1139fc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5573))
- [Add strict validations for dismissal path input](https://gitlab.com/gitlab-org/security/gitlab/-/commit/39a07480e84bf59c161c618e8f2f6d637905596a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5585))
- [Fix merge request delete modal not escaping title](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9fba70dae46e2330d0ff509c6a708c5dd3bd627d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5570))
- [Correct text/HTML confusion in AbstractReferenceFilter#object_link_text](https://gitlab.com/gitlab-org/security/gitlab/-/commit/437d7e5696f19a3780a50c5a778bb8e0afc086dc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5546))
- [Fixes the logical bug present in the complexity_multiplier method](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2648233caf6d0d58a28c32678d0058c53d0e9a6c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5529))
- [Require correct permissions to access frameworks](https://gitlab.com/gitlab-org/security/gitlab/-/commit/daecb53efb85e3f5a77872f66916aca49971b2c0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5540))
- [Stop preserving various exif tags](https://gitlab.com/gitlab-org/security/gitlab/-/commit/83c482c7395eb687001daa4e7a2856acd30cef82) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5532))

## 18.6.1 (2025-11-25)

### Fixed (3 changes)

- [Fix /admin/sidekiq not loading CSS assets in Cloud Native GitLab](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ccf15957c87ce3fe5dd6e5ed83bd59c9ea81c876)
- [Fix BackfillTimelogsNamespace finalization order](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4460d317e1c5b8a76406d09d0cfad0f1b56b1b48)
- [Fix custom role approvers lookup for inherited users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/743ff5eb22638654df2598fa054243606d301cac) **GitLab Enterprise Edition**

### Security (5 changes)

- [Override organization of signup users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5a175db6ae54ee6430a1c87b0e1bc83b5469b257) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5520))
- [Redact vulnerability references when Security and Compliance is disabled](https://gitlab.com/gitlab-org/security/gitlab/-/commit/293e3c4cba406b32ee96e6a625f6168ec7b54ee8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5508))
- [Use Gitlab::Json.safe_parse to prevent parsing of large JSON objects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/124790eb84c20cd00b8e05c06f7d514b75bcd3b0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5495))
- [Limit JSON parsing depth, size, and elements in HTTParty](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c83315f5257169a6dce0eb04eb14dc4894915a6e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5504))
- [Add protection suffix to cache depending on role](https://gitlab.com/gitlab-org/security/gitlab/-/commit/44f7d7162660a5dbe506dac85acb7eb47a1ef6a6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5483))

## 18.6.0 (2025-11-19)

### Added (194 changes)

- [Remove bulk_edit_security_attributes feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1a9bc7c9b9ae3e7a3b373d68f20b40f732da294f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212651)) **GitLab Enterprise Edition**
- [Document `approvedTools` configuration field for MCP clients](https://gitlab.com/gitlab-org/gitlab/-/commit/0fb581dd5e4c31df67ff87d9356141249895be84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212064))
- [Enable foundational_duo_planner feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/7c9310df52d1db2f88be4bb76d871249b5e9e086) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212958))
- [Track times the API to refresh token status is used](https://gitlab.com/gitlab-org/gitlab/-/commit/f29bca989fd2e1aaad2561f7e5c9d330c28f06e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209253)) **GitLab Enterprise Edition**
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/df8d70ed1ec05057709e04cfdf376952d9e628d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212893))
- [Add onboarding error for composite identity](https://gitlab.com/gitlab-org/gitlab/-/commit/d589b8afea41eb8192a90991d6868c5c0ba780e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212618)) **GitLab Enterprise Edition**
- [Allow to filter code suggestions by IDE names](https://gitlab.com/gitlab-org/gitlab/-/commit/31ad60116426ee7d52ec6ff91f936ec4984e8516) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212302)) **GitLab Enterprise Edition**
- [Add metric for active context queue sizes](https://gitlab.com/gitlab-org/gitlab/-/commit/e9b54344f71207be41f5c912337af691dd642414) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212365)) **GitLab Enterprise Edition**
- [PackagesFinder support search by exact name](https://gitlab.com/gitlab-org/gitlab/-/commit/8b682db63ff40a67439249610ba4b18c8156fea1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212615))
- [Add copy ID actions to group and project lists](https://gitlab.com/gitlab-org/gitlab/-/commit/903b3ef6c42f99dfc59d148e0ac3f7b63c2be503) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211512))
- [FF duo_foundational_agents_availability default enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/c9845d5e3fe4a88e0fdad33f9a6e7c641a23cab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212744)) **GitLab Enterprise Edition**
- [Rename graphql queries for maven virtual registries](https://gitlab.com/gitlab-org/gitlab/-/commit/cc408b4ac95d964398c997556360dba8153a4a36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212037))
- [Add agent platform sessions materialized view to clickhouse](https://gitlab.com/gitlab-org/gitlab/-/commit/15a7d3a5f101acc3ba2cb1e3af634235c28c97d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210808))
- [Remove security_attribute_inventory_filters flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1a5026ba8b2ee7255f76262d9831827269ad75b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212653)) **GitLab Enterprise Edition**
- [Add organization isolation for personal snippets](https://gitlab.com/gitlab-org/gitlab/-/commit/c7a6a0e09d68ed033c1cfd820e3858905e9c56d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210630))
- [Backfill missing empty projects records in inventory filters table](https://gitlab.com/gitlab-org/gitlab/-/commit/0a21f5b0286b07420ae85e287b7322d3aad46711) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210976)) **GitLab Enterprise Edition**
- [Support default scope for search](https://gitlab.com/gitlab-org/gitlab/-/commit/1f2e5bd791457565925025cd20b80d757f92ab95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212481))
- [Add security scan profiles table](https://gitlab.com/gitlab-org/gitlab/-/commit/a2ac9c35477778f324fb2c40a02f4d44e8b9bcee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211336))
- [Add composite identity to token revoke service](https://gitlab.com/gitlab-org/gitlab/-/commit/f483c4b8555557568e9e228aaf5a7cd9fa51da87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212564)) **GitLab Enterprise Edition**
- [Use last_verified_at instead of updated_at in Token Status UI](https://gitlab.com/gitlab-org/gitlab/-/commit/2cebc060fb65ea9a82e025c28e7f891c791e7d29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212352)) **GitLab Enterprise Edition**
- [Track when validity check enabled status becomes disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/7d616e453c79e05394f20e3f80227f5553e9852c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212208)) **GitLab Enterprise Edition**
- [Add Jest test map reporter for coverage-based test mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/0a0e467d4c74407676962667f6cdf18594c1e4d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211965))
- [Persist license_scanning violations for policy dismissals](https://gitlab.com/gitlab-org/gitlab/-/commit/850cea05ebd97796f7402207d6d170cf45d9e8c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210792)) **GitLab Enterprise Edition**
- [Raise error when OpenBao API response includes warnings](https://gitlab.com/gitlab-org/gitlab/-/commit/7959cce472a894c37447d03d8979655b8b945df7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211310)) **GitLab Enterprise Edition**
- [Add active arg to user contributed projects resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/2c70c7340a4612964fe570a5ba2df321cab88033) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212156))
- [Filter soft deleted attributes in bulk operations](https://gitlab.com/gitlab-org/gitlab/-/commit/e95df8971e77d1aacff93e00debab7e59b44c678) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211783)) **GitLab Enterprise Edition**
- [Add reference keyword to CI service definition](https://gitlab.com/gitlab-org/gitlab/-/commit/b088d0430740e7a1e573a9d05cfea97922b755fc) by @gmicouin ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204716))
- [Backend support for foundational agents settings](https://gitlab.com/gitlab-org/gitlab/-/commit/bc14c494a4a5e9942332ed62d4e2e7b66a70cf47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212111)) **GitLab Enterprise Edition**
- [Introduce WorkItems::TypesFilter](https://gitlab.com/gitlab-org/gitlab/-/commit/5752931abb3c75fb3e66eefb8f7a99960f6e4ef8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211586))
- [Add GraphQL fields for namespace link paths and permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/81bf19b8efdd9fcea758bc6465bed8799ff4b230) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211051)) **GitLab Enterprise Edition**
- [Update Service account subscription check to include Gold subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/c3426e9cd7636aef5614480cd39bb74dfb8dc048) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210923)) **GitLab Enterprise Edition**
- [Add X-Checksum-SHA256 header to Generic Package downloads](https://gitlab.com/gitlab-org/gitlab/-/commit/96f7cc62b455c6e6a27c1dac6b44fddc7e9661be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210599))
- [Release partial scans](https://gitlab.com/gitlab-org/gitlab/-/commit/4344e0c8a31f005a9ccf0dceddf8e9ede53d1478) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207616)) **GitLab Enterprise Edition**
- [Add vulnerability_anti_flip_guards table](https://gitlab.com/gitlab-org/gitlab/-/commit/9fb412b0079d9bfa5926f0820b66c73fb6ee78e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210846)) **GitLab Enterprise Edition**
- [Enable security_policy_approval_warn_mode by default](https://gitlab.com/gitlab-org/gitlab/-/commit/f6fc9242599b7395b0a98f53ed6b53918483a150) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207587)) **GitLab Enterprise Edition**
- [Add attributes related filters support](https://gitlab.com/gitlab-org/gitlab/-/commit/6002dd164308d73965613cd09a24cdf8fbe88a64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211221)) **GitLab Enterprise Edition**
- [Add security scan profiles table](https://gitlab.com/gitlab-org/gitlab/-/commit/e4982992e4664d654f923ebdb103769d5d77154e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211250))
- [Add GraphQL endpoint for code review events counts](https://gitlab.com/gitlab-org/gitlab/-/commit/6cbacd29d848bd1d06be8172aaccfc868c07537b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210721)) **GitLab Enterprise Edition**
- [Preparing bigint indexes for `deployment_merge_requests` table](https://gitlab.com/gitlab-org/gitlab/-/commit/bd14b49fdba9d3cdc6520f40cbc151d06a1bccb4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212147))
- [Show loading skeletion when refreshing lifecycles](https://gitlab.com/gitlab-org/gitlab/-/commit/255c4c25368c961edf3907e5049ee32bad1b41e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210646)) **GitLab Enterprise Edition**
- [Add API endpoint to transfer group to organization](https://gitlab.com/gitlab-org/gitlab/-/commit/912f81ec9c20cd219721348d3caa210b6cd943c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210812))
- [Step-up auth: Group protection (final integration and testing) [4/4]](https://gitlab.com/gitlab-org/gitlab/-/commit/480ef4e856ccc0f293b5006c54aea6b6b9d431b5) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199800))
- [Address feedback for bulk update attributes MR](https://gitlab.com/gitlab-org/gitlab/-/commit/7a3ae1af54b73e0ab3f0bd277d12f0d5a76d3a5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212065)) **GitLab Enterprise Edition**
- [Add `includeMetrics` filter to `AiImpactTable` visualization](https://gitlab.com/gitlab-org/gitlab/-/commit/5b9a0b84bdd1f316485bf79bfc80d4d802fe6770) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211959)) **GitLab Enterprise Edition**
- [Add cop to avoid user organization](https://gitlab.com/gitlab-org/gitlab/-/commit/8a999bcb900b9fa855d7d1faf94512059c4c71ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211618))
- [Remove comment feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bda4fce7f6e90417a3b99c0b119a5104bb1ff481) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211946)) **GitLab Enterprise Edition**
- [Load email otp fallback footer component as fallback](https://gitlab.com/gitlab-org/gitlab/-/commit/edde04b9621c96b744bcdfc3bd6a68db4ef07ed8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211701))
- [Unlink fork relationships when archiving group](https://gitlab.com/gitlab-org/gitlab/-/commit/5f2fdfd3a61ffdc63352ddb1a53b0b96e3ca254d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210049))
- [Enable CI interpolation to use component context data](https://gitlab.com/gitlab-org/gitlab/-/commit/8ea953d5b102f93331e64784e0561a6cdfe33a03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211905))
- [Move call tool MCP into EE](https://gitlab.com/gitlab-org/gitlab/-/commit/aff7ca45e65ab0b7257892c407379e3c8b704ae5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208373)) **GitLab Enterprise Edition**
- [Add organization_id to account email links](https://gitlab.com/gitlab-org/gitlab/-/commit/c88813a2f8112113fb221301dd57651777d6ca39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209346))
- [UX for Account Beneficiaries](https://gitlab.com/gitlab-org/gitlab/-/commit/fb57e6b6f754c5ce4c8a056eeddc6ef113d7e559) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209492)) **GitLab Enterprise Edition**
- [Add license_occurrence_uuids to security_policy_dismissals](https://gitlab.com/gitlab-org/gitlab/-/commit/44ee5e9fb33704ebea04af6835df8a242e5c2826) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209938))
- [Add function `posix_quote` to quote input parameters](https://gitlab.com/gitlab-org/gitlab/-/commit/712d97183f9bdeadd6ca287223d4c94d955a51fa) by @pmhahn ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203992))
- [Bulk replace attributes for groups and projects](https://gitlab.com/gitlab-org/gitlab/-/commit/be0de09e5c75b037690c086ced1f933c1f3cd5d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210713)) **GitLab Enterprise Edition**
- [Add Duo Agent Platform composite identity docs](https://gitlab.com/gitlab-org/gitlab/-/commit/de450192a18b56e1f926a54f77a038632c5005d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208646)) **GitLab Enterprise Edition**
- [Modify risk scores finder to group by projects](https://gitlab.com/gitlab-org/gitlab/-/commit/9b7bce4315bf7f117f69a1cd07f635f2fdc305c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211044)) **GitLab Enterprise Edition**
- [Add "No data" tooltips to SDLC metrics displaying "-"](https://gitlab.com/gitlab-org/gitlab/-/commit/5d65b23bf2a674b1887b9e715f37739dd9985174) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210170)) **GitLab Enterprise Edition**
- [Set uploaded video dimensions in markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/178beda1c882afe725e171f9fdb96c49fefcdb6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211067))
- [Add claim records core logic](https://gitlab.com/gitlab-org/gitlab/-/commit/0ff7870fbf3d35ffd474f2594734b7d5834cd939) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211568))
- [Always show spinner when streaming Rapid Diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/b85f587239bd3f30b91c2e9967a5c97155849336) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211167))
- [Add test-coverage:export job to export coverage metrics to ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/b4ebee37733300e2377c80e06e4903d35b56d317) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210608))
- [Chore make sure to add spec changes](https://gitlab.com/gitlab-org/gitlab/-/commit/e39108bf94158f9d091e253d54d531f09fd70a2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208373)) **GitLab Enterprise Edition**
- [Add MCP telemetry tracking events](https://gitlab.com/gitlab-org/gitlab/-/commit/31fbeaffb7f29678a80c4ce3e202f53dfc7b1003) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208373)) **GitLab Enterprise Edition**
- [Extend work item create mutation to accept optional createSource param](https://gitlab.com/gitlab-org/gitlab/-/commit/dffe5f04546df0543c2022eb6591dc4e4fac98cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211309))
- [Add epss filter for vulnerability attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/65dad2adea6e3ae046c65063e8a2763d2ca15868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209038)) **GitLab Enterprise Edition**
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/dbe16fa047482ca2e700e7515e3ce413193a9dce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211179))
- [Add agent_platform_session_resumed event](https://gitlab.com/gitlab-org/gitlab/-/commit/1d7c4e1457c0d69cbdeb7cf9a0c7336184881f75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211414)) **GitLab Enterprise Edition**
- [Add validityCheck to policy query](https://gitlab.com/gitlab-org/gitlab/-/commit/599f7f76da72aa40f787f1249e9e383c23159634) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211242)) **GitLab Enterprise Edition**
- [Add UNIQUE index with sharding column to ci_runner_machines](https://gitlab.com/gitlab-org/gitlab/-/commit/0122cb20caee92ca627037d6f9d6aa747adc898b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211246))
- [Use exclusive lease for project secret operations](https://gitlab.com/gitlab-org/gitlab/-/commit/e7cefa2735d159709db2e84d4979aa9fec18901c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210315)) **GitLab Enterprise Edition**
- [Add local cache entry table and model to Maven virtual registries](https://gitlab.com/gitlab-org/gitlab/-/commit/bc5cc7283cabfa069a822da9c0e780102cc678f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207117)) **GitLab Enterprise Edition**
- [Add run_command to Fix Pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/9760fd273b405e0f47d41795b1f0ad2e147214d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211378)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/9054fdd147eb846a14d81bf272458e020c6b67de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211376))
- [Add internal event tracking for secret detection token verification](https://gitlab.com/gitlab-org/gitlab/-/commit/5af29e6e70af76dd6141709987d540466fdc7c75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210840)) **GitLab Enterprise Edition**
- [Add for_merge_requests scope to PolicyDismissal](https://gitlab.com/gitlab-org/gitlab/-/commit/10d7a0d8b33fe4cc9b9d5502daf7be83c5840fd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210764)) **GitLab Enterprise Edition**
- [Add plan_name_uid column to plans table](https://gitlab.com/gitlab-org/gitlab/-/commit/9ccd103724a717bd30852c987fe055648b462f9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206006))
- [Add claim records core logic](https://gitlab.com/gitlab-org/gitlab/-/commit/0cce1bfd66b0d04c8f7e9c20f491a1e148613308) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210472))
- [Release custom project badges as beta feature](https://gitlab.com/gitlab-org/gitlab/-/commit/bc717d7683cff6384b08714c5cac662aa0cfd7b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209744))
- [docs: Add AWS hosted AI Gateway configuration section](https://gitlab.com/gitlab-org/gitlab/-/commit/dd3329ef3a1611c46d8ec848a26b3865f5a91148) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211144))
- [Remove create_group_level_work_items feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d963897520e960f5a5215276928c104e64024418) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210506))
- [Allow guests to manage epic parent links in UI](https://gitlab.com/gitlab-org/gitlab/-/commit/17e644ceb49cf2e56a2f93180b20c6b09ee375ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210663))
- [Add service accounts to item consumers](https://gitlab.com/gitlab-org/gitlab/-/commit/663510b94f3375cf1507ec8505b0199466f02bb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210297)) **GitLab Enterprise Edition**
- [Drop instance_integrations table](https://gitlab.com/gitlab-org/gitlab/-/commit/ba90aaefba3a4b3f93e0e1fd5225be1191fc5b0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209906))
- [Add rate limiting to projects members all API](https://gitlab.com/gitlab-org/gitlab/-/commit/2da119bdd24c8a054ad4f3e0a573482a66c7c64e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211239))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/df7e16340a442532075264b80c70887555c5ce69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211180))
- [Add uploaded image limits for markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/4efaa45a821bac6afed1137ad0bda3fe0042de33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211055))
- [Add query parameters to bulk checksum endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/9ea095dd1020d5bf05f7407ec06af434004e9796) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210690)) **GitLab Enterprise Edition**
- [Bulk add/remove attributes for groups and projects](https://gitlab.com/gitlab-org/gitlab/-/commit/2ba8225aa23c877bc4c2bd8dee6ef3ad7a7f4aa3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210470)) **GitLab Enterprise Edition**
- [Adds BackgroundOperation scheduler](https://gitlab.com/gitlab-org/gitlab/-/commit/a85a448fe346f918f17db422a1be2b044564dea2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208928))
- [Add ai_resolution_enabled GraphQL field](https://gitlab.com/gitlab-org/gitlab/-/commit/e90bb18af3c6c0237635350c7782689e103f2284) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210782)) **GitLab Enterprise Edition**
- [Add issue traversal_id indexes concurrently](https://gitlab.com/gitlab-org/gitlab/-/commit/a7bd6209add8a3710ec819f099a1c1d51fedde92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209439))
- [Use GitLab as Web IDE Extension Host server](https://gitlab.com/gitlab-org/gitlab/-/commit/520b8b940cbc6a4f02e7e66491a8ca359151411e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209284))
- [Add SCIP artifact type support for Code Intelligence](https://gitlab.com/gitlab-org/gitlab/-/commit/6798fd2b4fac4f5bebefbd6e11d1b3cebcc2de9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209032))
- [Allow sorting and filtering pipelines for pipeline schedule](https://gitlab.com/gitlab-org/gitlab/-/commit/4aea5d3dd5d264c2a577427e73fa822e8f3d124c) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207036))
- [Add migration to backfill solution to vulnerabilities from findings](https://gitlab.com/gitlab-org/gitlab/-/commit/d83777f416fc637d671e6cbbf90fccd6e95c2174) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210572))
- [Improve index coverage on inventory filters](https://gitlab.com/gitlab-org/gitlab/-/commit/7317022a28f4dcf347bb1436f4668ef59fd051d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210420)) **GitLab Enterprise Edition**
- [Add Fix pipeline button to MR pipeline widget](https://gitlab.com/gitlab-org/gitlab/-/commit/53782b0296504fd1962f74f58e14a7d4500143f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204201)) **GitLab Enterprise Edition**
- [Add ui_chat_log column to checkpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/fcbadeed07dea0b06e1fd3d4ac7524b42f34ad2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210056))
- [Add collapse expand section to settings page](https://gitlab.com/gitlab-org/gitlab/-/commit/fe8f63e63b7fb665aeeae0edcdb863c8ad9be14b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208902))
- [Add group level archive support in analyzer statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/65ded87bd0563a15796158ac934d077a41df67d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209808)) **GitLab Enterprise Edition**
- [Block security settings changes on archived projects](https://gitlab.com/gitlab-org/gitlab/-/commit/0e722bab730dbe51125c0c36eb4aee5b1286211a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209925)) **GitLab Enterprise Edition**
- [Add /ship quick action for merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/cad788be030bc073221833cdfb5e641d20ccf3fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78998)) **GitLab Enterprise Edition**
- [Improve image attachment in markdown editor](https://gitlab.com/gitlab-org/gitlab/-/commit/12427741120a09bda6749e9732ca61b9bbb82e69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210676))
- [Add webhook notifications for merge request re-request review](https://gitlab.com/gitlab-org/gitlab/-/commit/4464137ea1aeb330a2b03806ab9172b1d8448653) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205274))
- [Add vulnerabilities risk score finder](https://gitlab.com/gitlab-org/gitlab/-/commit/3104df95760071c0b8476718f106f91495a782c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209324)) **GitLab Enterprise Edition**
- [Scope down project_export_jobs unique index](https://gitlab.com/gitlab-org/gitlab/-/commit/5e3d795ca9215e0040119d51179ac3bb9126542c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210534))
- [Add BBM BackfillPackagesProtectionRules](https://gitlab.com/gitlab-org/gitlab/-/commit/b0128dac712e08df9e86957adeb67ff3c35b3af1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207742))
- [Create project_push_rules table](https://gitlab.com/gitlab-org/gitlab/-/commit/7fb2eb14db87ab9b849a9c4daadaf94685d9a801) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208490)) **GitLab Enterprise Edition**
- [Audit project push rules comprehensively](https://gitlab.com/gitlab-org/gitlab/-/commit/cbf33139c42acc837f24d0e046fee3248780f90f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932)) **GitLab Enterprise Edition**
- [Refactor work items data layer for GraphQL migration](https://gitlab.com/gitlab-org/gitlab/-/commit/d88752610faeb4baa6d87cf6b510f348ec75ba6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210704)) **GitLab Enterprise Edition**
- [Add archived badge to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/bcbf56dbd48a6f43841ab10bf24ff560bf5a2f33) by @thenourhan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210076))
- [Add policy_violations to VulnerabilityType](https://gitlab.com/gitlab-org/gitlab/-/commit/ee21b9fe415e5be37662128179db7c8f19f89b96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210018)) **GitLab Enterprise Edition**
- [Add policy violations to vulnerability graph api](https://gitlab.com/gitlab-org/gitlab/-/commit/d595349b2ac2db86a3feaa265201ca6fdf67e0eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207947)) **GitLab Enterprise Edition**
- [Add BillingUrlBuilderService for subscription upgrade URLs](https://gitlab.com/gitlab-org/gitlab/-/commit/cda2c6d2bf8ebfdeb0ce2e917cb0f3f8cd0f0317) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207630)) **GitLab Enterprise Edition**
- [Add AI side panel feature spec](https://gitlab.com/gitlab-org/gitlab/-/commit/3ec3ccb9bbade4dc763333ee9cf358dee69ad8f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209930)) **GitLab Enterprise Edition**
- [Schedule updated_at index for root namespaces on issues](https://gitlab.com/gitlab-org/gitlab/-/commit/8a20f15f76311fea972bb2298bb8fd587b3ccb09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210477))
- [Add missing packages associations to User model](https://gitlab.com/gitlab-org/gitlab/-/commit/6d47af1c858b6f8f224f1af0115563c96714c4d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209668))
- [Add Sidekiq worker for group transfer to organization](https://gitlab.com/gitlab-org/gitlab/-/commit/3b9fd499a2e8e3650c15647b0cdd4550ef399dad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209420))
- [Add licenses to security_policy_dismissals](https://gitlab.com/gitlab-org/gitlab/-/commit/06c4f4451a9ebc73d03139513f642b761f165517) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210284))
- [Unify vulnerability attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/6e918d3b756c532f5505c98c7377cafe883cbc81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209804)) **GitLab Enterprise Edition**
- [Use correct cursor pattern](https://gitlab.com/gitlab-org/gitlab/-/commit/8046306502fc9d8967c6ce1ac682454daf642fd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209683)) **GitLab Enterprise Edition**
- [Exclude archived projects when filtering in security inventory](https://gitlab.com/gitlab-org/gitlab/-/commit/f6f25fe9d66a49291792cda860d739bd0d5b3a45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210221)) **GitLab Enterprise Edition**
- [Add audit event streaming for secrets manager](https://gitlab.com/gitlab-org/gitlab/-/commit/a9fd3bcf213b202eafc303de3757bdb67eed348c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205780)) **GitLab Enterprise Edition**
- [Support quote reply shortcut ('r') in merge request diff discussions](https://gitlab.com/gitlab-org/gitlab/-/commit/d17ea38ecac946c99df24d828e70aa725e5e4dc4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209872))
- [Add logic to OutstandingLease](https://gitlab.com/gitlab-org/gitlab/-/commit/24818f68dd2d8e32346fc02214e1575fe006edfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209749))
- [Add counts to `Code Suggestions acceptance rate by language` tooltips](https://gitlab.com/gitlab-org/gitlab/-/commit/da8472d6fdaaa11ce0aac2dec0dd2ac52221018f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209334)) **GitLab Enterprise Edition**
- [Add audit events for categories and attributes changes](https://gitlab.com/gitlab-org/gitlab/-/commit/29902e03d77380a79592f1888131eb9e0ebd3a4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118)) **GitLab Enterprise Edition**
- [Fix "Work Items" duplication from sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/56db36b974e016edb6ff50d3d17a829cd35871fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209466))
- [Add organization_id to authentication_events](https://gitlab.com/gitlab-org/gitlab/-/commit/5372cb8412033c365bc8a7c30cb9bf3d6f4c9531) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207471))
- [Add feature groups for AI usage events](https://gitlab.com/gitlab-org/gitlab/-/commit/347b555e724d4a3033ce4e5ee2925d100b0ccc03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209772)) **GitLab Enterprise Edition**
- [Add checksumming endpoint to data_management API](https://gitlab.com/gitlab-org/gitlab/-/commit/3ebd6b1c124a751a12cc6b9673e3eda2c4156e68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208832)) **GitLab Enterprise Edition**
- [Prompt user to select targets for multiple rows](https://gitlab.com/gitlab-org/gitlab/-/commit/601a046ea91843b4e6ed852bb09454ecf7ef7375) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209192))
- [Remove ci_matrix_expressions feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d883f3f097f13904a453f2042ffbc7ae6f76e0e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209773))
- [Add OpenAPI document-level keys](https://gitlab.com/gitlab-org/gitlab/-/commit/42ab8dbf314c8a7a16941cad6e714058b6350841) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208812))
- [Add vulnerability dropdown actions](https://gitlab.com/gitlab-org/gitlab/-/commit/eb4e1c89382612e7152f21300c220773f034c5a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204419)) **GitLab Enterprise Edition**
- [Introduces image preview overlay](https://gitlab.com/gitlab-org/gitlab/-/commit/66ea3bee6875701fc87ee4026fe89a2d71169949) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209145))
- [Add Partner API health and rate limiting metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/cd52adb573a9ef96206bb928fa8e48ddbbca94b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208292))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/a74395a80323735c7cdb1cf506afbfdc0e2a98a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209406))
- [Add kev filter to security scan rule](https://gitlab.com/gitlab-org/gitlab/-/commit/18ee5f5c10db1ec47434763e4ead4190fa5c1fff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208814)) **GitLab Enterprise Edition**
- [Add `PATCH /groups/:id/enterprise_users/:user_id` API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/ecf507c8bb0407108ab52c0833cb6a4938820302) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199248)) **GitLab Enterprise Edition**
- [Adds Claim Service to TS client](https://gitlab.com/gitlab-org/gitlab/-/commit/02d52f465ee3e643dcdb494a263bedde1e62a5d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209638))
- [Add paginated endpoint for runner projects](https://gitlab.com/gitlab-org/gitlab/-/commit/13d0ccdf96f830d4d0d52d80fd31cbf749d402cd) by @official.harshith1 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207910))
- [Update traversal ids when moving project or group](https://gitlab.com/gitlab-org/gitlab/-/commit/389ad53f3d233c995f5167dd81f6dcce6969dc6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207434)) **GitLab Enterprise Edition**
- [Create global tag registry for OpenAPI](https://gitlab.com/gitlab-org/gitlab/-/commit/3fdbf0613017f1e1ab93253f95b912882754fea7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208995))
- [Display virtual registry id in the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/e60b385c41cacebbd131313ebdc56a4185437515) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209583))
- [Roll up weights from tasks to issues](https://gitlab.com/gitlab-org/gitlab/-/commit/3c4911b41cef1c5f9af085de6b51848ae62dec2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209245)) **GitLab Enterprise Edition**
- [Foundational agent query namespace project IDs](https://gitlab.com/gitlab-org/gitlab/-/commit/58031769e101150fe598d5cf49b6b7702ef89055) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209134)) **GitLab Enterprise Edition**
- [Add is_self_archived field to Group/Project GraphQL types](https://gitlab.com/gitlab-org/gitlab/-/commit/243f249689a8e9f2dab358d54ee991421e86ad52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208502))
- [Web IDE extension host domain application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/f8c4d4efe4b0fab96b730468bf581b9ea6818dd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208978))
- [Finalize backfilling taversal_ids on issues](https://gitlab.com/gitlab-org/gitlab/-/commit/f966244a85d0c36db49a8387578ad5385de4229f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209442))
- [Remove instance_integration_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/773b9097271cb3ee186074544fbf273985e583b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207676))
- [Add partner token verification framework for secret detection](https://gitlab.com/gitlab-org/gitlab/-/commit/7f39342a3968e54da5844213ef3e916678eba500) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207069)) **GitLab Enterprise Edition**
- [Step-up auth: Add parent group inheritance for namespace settings](https://gitlab.com/gitlab-org/gitlab/-/commit/1df94455955ff5832e1ec715466afaacf6b5906e) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199628))
- [Disable SSH Keys for Enterprise users](https://gitlab.com/gitlab-org/gitlab/-/commit/611c0bfec4f3c7d0e569ae4acf25243f5e6ab02a) by @WYarde ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205020)) **GitLab Enterprise Edition**
- [Add sharding key documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/c0fc5a5d526445c03c3296feef12fa17cd28a4fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209209))
- [Search comments of merge requests during Advanced Search](https://gitlab.com/gitlab-org/gitlab/-/commit/6bcc73d8761e7fed00e7e0fe1e1b5c43b0e22c44) by @joe-snyder ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206377)) **GitLab Enterprise Edition**
- [Fix mcp scope permission for gitlab search api](https://gitlab.com/gitlab-org/gitlab/-/commit/a0cacd93e62ec7edd9e55cab541bd933f7dea636) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208869))
- [Add organization_id when SSH keys are created](https://gitlab.com/gitlab-org/gitlab/-/commit/a7b43d050f56f29266838f572afa67e3c0f616db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209177))
- [Add coverage in feature specs for agent sessions](https://gitlab.com/gitlab-org/gitlab/-/commit/6d0692123b46ef08815e361446be1fe269c60a3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209278)) **GitLab Enterprise Edition**
- [Add logo to Datadog integration](https://gitlab.com/gitlab-org/gitlab/-/commit/eb997c912be3cdf82c1ceaa8d9bb0604c7a4235f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207099))
- [Use `webPath` in work items list app](https://gitlab.com/gitlab-org/gitlab/-/commit/d6224d00eda86c2b36f2d50bbb44b6faebdda87a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208896))
- [Automatically adds projects as consumers to flows after creation](https://gitlab.com/gitlab-org/gitlab/-/commit/35773deeb292656ff3f4d7907184087b4f5a40c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208452)) **GitLab Enterprise Edition**
- [Add duoUsedCount metric to AI Impact dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/2fca7e6bab48e7b63747044da8ddf88a39419979) by @official.harshith1 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207562)) **GitLab Enterprise Edition**
- [Step-up auth: Add frontend and UX auth helper for namespace scope [3/4]](https://gitlab.com/gitlab-org/gitlab/-/commit/4e50f6cd025df248dda0d1e315cd8ee1597d9ad7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209016))
- [Step-up auth: Add frontend and UX auth helper for namespace scope [3/4]](https://gitlab.com/gitlab-org/gitlab/-/commit/d1f9bdd5a4e552ecded8d842388c46208f8a2e53) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207665))
- [Add hasDesignManagementFeature GraphQL field](https://gitlab.com/gitlab-org/gitlab/-/commit/b61d83cfb01c49045d00055edba11bd63d39737d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208834))
- [Allows agents to be auto-added to projects](https://gitlab.com/gitlab-org/gitlab/-/commit/35edd0f826a3a93f486292ec78e376fa77953ae9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207672))
- [Add internal event tracking for secret detection token verifications](https://gitlab.com/gitlab-org/gitlab/-/commit/919ae0f4a7d9416c4489282b89eaa940ba005f40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208599)) **GitLab Enterprise Edition**
- [Adds policy_violations to vulnerability reference](https://gitlab.com/gitlab-org/gitlab/-/commit/3689b88e4a730f7783428f36de6f79f52e1c272e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207638)) **GitLab Enterprise Edition**
- [Destroy user_project_member_roles when a user is removed from a group](https://gitlab.com/gitlab-org/gitlab/-/commit/f13014c1edcb56b665976f392213a1f5830233be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208576))
- [Track times refresh token status button clicked](https://gitlab.com/gitlab-org/gitlab/-/commit/bb7ef97154342bf2ad4d386fc5ec843aff404189) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208574)) **GitLab Enterprise Edition**
- [Finalize backfilling work_item_transitions](https://gitlab.com/gitlab-org/gitlab/-/commit/5c84bb372a9d15939338b3427b06961b3b3b3e46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208963))
- [Introduce `work_item_tasks_on_boards` for tasks on boards](https://gitlab.com/gitlab-org/gitlab/-/commit/4396571e1a0bf731d277d060d9eab29732ebd5bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209068))
- [Add mavenUpstreamRegistries field to group query](https://gitlab.com/gitlab-org/gitlab/-/commit/83dad3cf352a6b2a30c00c2fc064eaab23337e7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205320))
- [Expose previous blame information in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/4a96b434ef0d4eb9aaf82afcafaf6d305e3b5ef6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208844))
- [Fetches list of foundational agents](https://gitlab.com/gitlab-org/gitlab/-/commit/e7d2fb508760ab7d907bca02951f7db20f3643d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208778)) **GitLab Enterprise Edition**
- [Added support for template based ids in project update mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/f41837b85fe661ff85ca162bce12f41bb2309c60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208675)) **GitLab Enterprise Edition**
- [Adds aiFoundationalChatAgents grapqhl query](https://gitlab.com/gitlab-org/gitlab/-/commit/84d4bf56f7fbcd84f263a2da0a4c0ab49a241498) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208774))
- [Some reports from child pipelines will now be shown on MR Widget](https://gitlab.com/gitlab-org/gitlab/-/commit/dc2d252aff0f19ebe2077a7bd6db7fcdd71d76ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208387))
- [Rollout code_suggestions_context feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/154bed605b9aee3a3cbf12ba23fb66330ad19de0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208645)) **GitLab Enterprise Edition**
- [Create project_push_rules table](https://gitlab.com/gitlab-org/gitlab/-/commit/12d56958b29cba53aa3506bfff3b18d5157f8a34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208153)) **GitLab Enterprise Edition**
- [Add support for closedBefore closedAfter in merge request GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/cb75c8d88f9e09ff0ba27ed694dd977c3fb01a8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205236))
- [Schedule namespace_traversal_ids indexes](https://gitlab.com/gitlab-org/gitlab/-/commit/7f4475c86bdc9d715a20f93552bdd452f6cd9c6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207641))
- [Removed mr_dashboard_drafts_toggle feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/87a0c87ab2ac816e33bf72dbf3cb8070ba0fbeef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208938))
- [Follow batching job documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/6ef498b026ca817469519ed8682c7844c5b1c7e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206339)) **GitLab Enterprise Edition**
- [Add execute cleanup policy service for virtual registry](https://gitlab.com/gitlab-org/gitlab/-/commit/a5e1a017877efc24af4081d9f915cc165294f580) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204548)) **GitLab Enterprise Edition**
- [Add current_job Resource Group API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/94f285d469da7df4001b474d3f7e63d57b5eb33b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205797))
- [Add organization_id column to keys table](https://gitlab.com/gitlab-org/gitlab/-/commit/ca73b2bf1d6cfef8056b59be9cdb5948380ec0eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208105))
- [Add Fix pipeline button to pipeline details page](https://gitlab.com/gitlab-org/gitlab/-/commit/add6821ecc5f59c64e02a89431a29bf58b8620d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203855)) **GitLab Enterprise Edition**
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/f1be1ce977bb22d7a2d63acc9405ff766e632fca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208565))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/0c7984d40f740db79219f386f53743ce6408c856) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208563))
- [Handle ReferenceUpdateError in UserCommitFiles operation](https://gitlab.com/gitlab-org/gitlab/-/commit/dbcb1b8ebcbab2789258be227919b601d95e9aee) by @edith007 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205151))
- [Enable agentic chat context inclusion for everyone](https://gitlab.com/gitlab-org/gitlab/-/commit/6c92cc96909b1bd8d0f31a98f28f591e879b7537) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208481)) **GitLab Enterprise Edition**

### Fixed (224 changes)

- [Show curUser first if not on page 1](https://gitlab.com/gitlab-org/gitlab/-/commit/eb9dceaa06bea627c05c386ed68f93d72dcb7929) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212199))
- [Update PruneExpiredExportJobsService](https://gitlab.com/gitlab-org/gitlab/-/commit/56821fdefb59d26f850ebe15bbb8eec460adbe9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212816))
- [Fix: Details view not working in side panel navigation](https://gitlab.com/gitlab-org/gitlab/-/commit/a319a0e5c75da58b872aa0cb93afb3e547d90451) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212311)) **GitLab Enterprise Edition**
- [Hide Self-Hosted model selection from non-enterprise users](https://gitlab.com/gitlab-org/gitlab/-/commit/b52d747c2ac61570d7ae001c49efadde6b9a5b22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212294)) **GitLab Enterprise Edition**
- [Fix SBOM scan result file cleanup by using created_at timestamp](https://gitlab.com/gitlab-org/gitlab/-/commit/1d4fb75f0aab096618883ce57a0fe9f77ceff986) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212535)) **GitLab Enterprise Edition**
- [Resolve database constraint violation in Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/90e59bf3e95dc6548e556f84e59f905a877b8326) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190089)) **GitLab Enterprise Edition**
- [Relax blobs complexity in favor of limiting data](https://gitlab.com/gitlab-org/gitlab/-/commit/ad540e9a82c93da115e10770d700a4760c92484d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212456))
- [Revert "Support nested variables expention in rules:if"](https://gitlab.com/gitlab-org/gitlab/-/commit/d7b23acf7287cfd148a2f17609bb48cf7b394d0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212803))
- [Fix search in commits](https://gitlab.com/gitlab-org/gitlab/-/commit/6d1dbfceadadd57f1fefd9042310d2593afbb1ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212788))
- [Update Epic Swimlanes styles to adapt to Project Studio](https://gitlab.com/gitlab-org/gitlab/-/commit/2b6efc4605f89397e3b783d7af87a5a3a3712747) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212569)) **GitLab Enterprise Edition**
- [Fix Infinite scroller not loading commits](https://gitlab.com/gitlab-org/gitlab/-/commit/c615683e7b5049a54710431e5b6742603bd69854) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212764))
- [Use only ci_namespace_mirrors for finished pipeline ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/5f0529689811b5abe7164ae6a89badc7dd7b1399) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212273))
- [Fixes incorrect value being passed to application settings](https://gitlab.com/gitlab-org/gitlab/-/commit/f57e6b83378e2469778faee3c893f1bb2e43e886) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212775)) **GitLab Enterprise Edition**
- [Fix flaky N+1 query test in work_item color widget spec](https://gitlab.com/gitlab-org/gitlab/-/commit/8d0b59ea66005c548aafa51b173893ec7b33fa44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212041))
- [Prevent a possible NoMethodError on a nil commit count](https://gitlab.com/gitlab-org/gitlab/-/commit/4ebfca385ae0829db1beccf0d0d63cd6bf9b99f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210440))
- [Reduce complexity multiplier for the vulnerability report](https://gitlab.com/gitlab-org/gitlab/-/commit/a5806495917523170097d4f939ec898b6cf424b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212655)) **GitLab Enterprise Edition**
- [Use built-in clipboard button in breadcrumbs](https://gitlab.com/gitlab-org/gitlab/-/commit/7abe012bb14faeddfd55abee34f4c03dc7433b8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211624))
- [Fix global search page regex toggle button state](https://gitlab.com/gitlab-org/gitlab/-/commit/5420e83469cfb3d210b9203350745b4b1ddb1641) by @therealrinku ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211885))
- [Fix Gitaly N+1 in project jobs API](https://gitlab.com/gitlab-org/gitlab/-/commit/cc838db812a0327b88b3dd04cb7a79098e835a1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212660))
- [Move group_security_configuration_path to helper](https://gitlab.com/gitlab-org/gitlab/-/commit/d7cc36242be026e7b994e6296ae69b2ef28bebdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212316)) **GitLab Enterprise Edition**
- [Render background for Duo in-app trials](https://gitlab.com/gitlab-org/gitlab/-/commit/dfcc8ae60c95c3f8a122a38b5698ad47e09ca5f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212641)) **GitLab Enterprise Edition**
- [Remove time conversion](https://gitlab.com/gitlab-org/gitlab/-/commit/817ab47c2a04cf98d068d9cb9e650ffd48432fa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212174))
- [Disable comment submission while file upload is in progress](https://gitlab.com/gitlab-org/gitlab/-/commit/ad2bb36673073733341acc19df3f01744200e687) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212628))
- [Set only the text of the badge, without removing wrappers](https://gitlab.com/gitlab-org/gitlab/-/commit/68dc26a11cdb608bf8ce579a084f0cc98243c16a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212484))
- [Add wildcard support to cache](https://gitlab.com/gitlab-org/gitlab/-/commit/fff6b8a084130697c49945551b15613a9decb47d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211424))
- [Add Elasticsearch routing for GLQL/Work Items Advanced Search](https://gitlab.com/gitlab-org/gitlab/-/commit/059386f0c563729512b6c6edc68f1ecf4425f859) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212591)) **GitLab Enterprise Edition**
- [Fix initially-selected project in work item creation flow](https://gitlab.com/gitlab-org/gitlab/-/commit/1ef9d287a3acaffa701a766ad559a9dfe700aa43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212599))
- [Fix commits appearance when filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/8dc2d9166704e2d517f513e0f9ae1d597d1943d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212597))
- [Fix label page redirecting to first page everytime label is promoted](https://gitlab.com/gitlab-org/gitlab/-/commit/d06919b9a0fbbe0f85a660cdb4f6d5770e77fd22) by @therealrinku ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211379))
- [Fix SlackIntegration alias conflicts with parent paths](https://gitlab.com/gitlab-org/gitlab/-/commit/a083f7a05403987d7ef4aa59f5467cc0e0d8b57e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210868))
- [Hide Restore this version button on wiki if user has no permission](https://gitlab.com/gitlab-org/gitlab/-/commit/739e9d11091a9648ed0498494be2c2c6673c3b59) by @therealrinku ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212536))
- [Fix vulnerability_reads updates when feature flag is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/a568a9e432528564e2a99123804c159d232d2ca7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212263)) **GitLab Enterprise Edition**
- [Add top anchor to allow panel scroll on sticky header click](https://gitlab.com/gitlab-org/gitlab/-/commit/5af20f8c96d4d1b5aafa6f0465bda2520b2fef5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211738))
- [Fix wrong diff when linking to added or removed line](https://gitlab.com/gitlab-org/gitlab/-/commit/bad0f9dc420450ffb5f090f87f293c4463fd32f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212527))
- [Gracefully handle bad SSH keys in SSH key validator](https://gitlab.com/gitlab-org/gitlab/-/commit/470ccfe3dd519b0bd67ac1a705e2bfc8a215557b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212483))
- [Fixes issues with default namespace being nil](https://gitlab.com/gitlab-org/gitlab/-/commit/19d2803da9c340998832a9487d90559e839d56f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212457)) **GitLab Enterprise Edition**
- [Correct merged widget tooltip display format](https://gitlab.com/gitlab-org/gitlab/-/commit/529be52fb2b65c7c341b86c47e6fae1c47a0ff4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211831))
- [Fix MR approver list with composite identity filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/4649c53fb9e97819c486872405a91282e5f14920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212439))
- [Fetches foundational chat agents on chat history](https://gitlab.com/gitlab-org/gitlab/-/commit/e9888c1e971238511508c1316f620c237309f002) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212288)) **GitLab Enterprise Edition**
- [Backend changes to fix foundational agents in history](https://gitlab.com/gitlab-org/gitlab/-/commit/e42bb777b7eeb7f0e44aaec9bff98da7873305c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212241)) **GitLab Enterprise Edition**
- [Prevent WIP limit dropdown autoclosing](https://gitlab.com/gitlab-org/gitlab/-/commit/41c447686995d40bee79b0fe4ec4ad736c75ff06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211944)) **GitLab Enterprise Edition**
- [Fix keyboard shortcuts with icon-only sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/7ee7cb4f6bc3823fffb1287ef8aca061c055988d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212375))
- [Do not create pipeline for tags if no target commit exists](https://gitlab.com/gitlab-org/gitlab/-/commit/6db401e1450b3263acde64648def14b5e61067eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211813))
- [Adding footer to compliance framework dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/91dcba02c81067266e3b2f63e2aeb27698129454) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212139)) **GitLab Enterprise Edition**
- [Fix pipeline cancelable state](https://gitlab.com/gitlab-org/gitlab/-/commit/85b42a08f9150b23255f5700d400690b06f9e265) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211949))
- [Adjust overflow for panel container in print styles](https://gitlab.com/gitlab-org/gitlab/-/commit/cf8c340747bef3e280e7bb5371db791332a5d728) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212286))
- [Render missing HEAD message for tags which do not reference a commit](https://gitlab.com/gitlab-org/gitlab/-/commit/6fb6f5aa1076ec65390a247147449af51dbd6d9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211923))
- [Fix NoMethodError when tag has nil dereferenced_target](https://gitlab.com/gitlab-org/gitlab/-/commit/aed0d1fc3fad8b42b09c1f035111ddfd055d1ffb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211766))
- [Fix bulk attributes replace edge case](https://gitlab.com/gitlab-org/gitlab/-/commit/4784540da0de7c8fbaece7583f5f3bac2a70a9c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211917)) **GitLab Enterprise Edition**
- [Hide GitLab managed/vendored models for CLI feature setting](https://gitlab.com/gitlab-org/gitlab/-/commit/f9a643b3d7b7a76d48fa53591a20d673a3ae81f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210823)) **GitLab Enterprise Edition**
- [Fix width of loading sidebar to avoid layout jump](https://gitlab.com/gitlab-org/gitlab/-/commit/8643fed992415cf02e2edd311c6632ff8b2b1beb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212235))
- [Skip invalid pipelines when processing finished sync events](https://gitlab.com/gitlab-org/gitlab/-/commit/3c6edbe7564f4f96b43cbc0c59b74a52f556f97a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211906))
- [Send fully qualified ref names when creating tags and branches](https://gitlab.com/gitlab-org/gitlab/-/commit/1360edcd0dc5fed5e503a6b835a7cbbe56e851cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212107))
- [Fix work item creation modal error](https://gitlab.com/gitlab-org/gitlab/-/commit/33ffa03d76b73b4c6d99ac00961a3fcb26751247) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212103))
- [Implement to_param on Integrations::Prometheus](https://gitlab.com/gitlab-org/gitlab/-/commit/96242a86967c51939829fe71cca312c1d82cf7fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212095))
- [Do not scroll for active nav item inside flyout menu](https://gitlab.com/gitlab-org/gitlab/-/commit/0d934a980342d171cbc1844263b0597c2384a3cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212096))
- [Do not render GitLab Duo settings when user cannot admin_project](https://gitlab.com/gitlab-org/gitlab/-/commit/c1ce918a2432bc9211f3bfdd6f1deee47dfdcf95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211900)) **GitLab Enterprise Edition**
- [Fix status parameter in work item list counts](https://gitlab.com/gitlab-org/gitlab/-/commit/e394c6f98b143532177d3e20e495298920f62835) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211860))
- [Remove noisy Workhorse log line](https://gitlab.com/gitlab-org/gitlab/-/commit/240df4ccbb7dd5094a3e56ce6941cae917a40891) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211999))
- [Readd index_projects_on_lower_name if necessary](https://gitlab.com/gitlab-org/gitlab/-/commit/909e4dea0597710242c487387d81ea590cf099be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211961))
- [Bring user model selection to all pages where agentic chat exists](https://gitlab.com/gitlab-org/gitlab/-/commit/250bbc1026876a5d9fc921cb23670a248c0deb9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211901)) **GitLab Enterprise Edition**
- [Updates policies so foundational agents can be used in groups](https://gitlab.com/gitlab-org/gitlab/-/commit/12c328d091f2a6b5492628599a195e8eb5b3d79b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211842)) **GitLab Enterprise Edition**
- [Render correct pipeline statuses for tags](https://gitlab.com/gitlab-org/gitlab/-/commit/92124b5d3e6b333659f9818ab61a881b7ac8ec6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210033))
- [Fix work item created toast message](https://gitlab.com/gitlab-org/gitlab/-/commit/c9c4ccb8fa70cf6d38028ef9be8665882b3f1732) by @therealrinku ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211709))
- [Reindex Elastic/Zoekt to fix archived value](https://gitlab.com/gitlab-org/gitlab/-/commit/edc40506e02bc82faf7643bb78e103228631bfa6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211447)) **GitLab Enterprise Edition**
- [Add container and target for datepicker to be fully visible](https://gitlab.com/gitlab-org/gitlab/-/commit/e3a8cfe8c6d7f4e1a389065421d5b789d62e7c30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211915))
- [Fixes pipeline editor job visualisation graph](https://gitlab.com/gitlab-org/gitlab/-/commit/80b5675d9e47e1b982f4fa789931ed419428405f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209340))
- [Set page header tab index to 0 to prevent a11y violations](https://gitlab.com/gitlab-org/gitlab/-/commit/ea5791d29800682fbd956bf51bfafa3a5f93f4f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211873))
- [Bypass transitionend event when transition duration is zero](https://gitlab.com/gitlab-org/gitlab/-/commit/cd6a8900887a5b98b8d5c455606845fa99024088) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211893))
- [Remove FF: analyzer_namespace_status_query_optimization](https://gitlab.com/gitlab-org/gitlab/-/commit/6030a7e42380969f6732128969454aeaa77bd8ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211580)) **GitLab Enterprise Edition**
- [Fix TypeError in issues with malformed :not param](https://gitlab.com/gitlab-org/gitlab/-/commit/16bb9c962878a82e80b98b27b2acb0653db39712) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211869))
- [Add nil check for orphaned schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/0ac0a0d913a1e121d9d0c35abef3dced8f48a8d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211846))
- [Fix NoMethodError when current_user is nil](https://gitlab.com/gitlab-org/gitlab/-/commit/a23e6af1b3919e5f43cd61044f3625b5b25b9f33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211847))
- [Use "Previous" not "Prev" for pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/9516ad169e5f43225e0615074afecbe76c78e911) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211843))
- [Force work items actions to be right-aligned](https://gitlab.com/gitlab-org/gitlab/-/commit/ec829100d3942470f7a024a1fd10484b6348da3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211799))
- [Fix polling after a widget is unmounted](https://gitlab.com/gitlab-org/gitlab/-/commit/e8b198349a692d56f72a4a28851d7d3e8ca1bc51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211384))
- [Export all CI/CD project settings](https://gitlab.com/gitlab-org/gitlab/-/commit/467837e4c18df15703efcad8f0f6b70a097705cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208465))
- [Check placeholder empty rule before upateRules](https://gitlab.com/gitlab-org/gitlab/-/commit/dfcab84b704e6f478213de6deb3bc3ad42b2d72e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211477)) **GitLab Enterprise Edition**
- [Expose project_studio_enabled in gon for anonymous users](https://gitlab.com/gitlab-org/gitlab/-/commit/4e8e81c3830c7f6ce855f165778528ef1d0d12d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211712))
- [Fix custom fields link in sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/f291bf8fc0b45fa87ab31c0e4aa1f9e356e97d7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211685))
- [Fix: adjust agent sessions search tokens for prod values](https://gitlab.com/gitlab-org/gitlab/-/commit/7fe96bf2d43cebe39b940396a36eac3ffd97ed73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211642)) **GitLab Enterprise Edition**
- [Refactor project delete modal](https://gitlab.com/gitlab-org/gitlab/-/commit/b8490b7c2742fe68f650a38bbca966803934ac2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211123))
- [Render correct pipeline statuses for branches](https://gitlab.com/gitlab-org/gitlab/-/commit/0cff52d648998f734af187f91c06debd2efad9f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210152))
- [Exclude archived groups in security inventory](https://gitlab.com/gitlab-org/gitlab/-/commit/1c416c07849c7ed5771aa1563e18ff7c557cbc8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211299)) **GitLab Enterprise Edition**
- [Fix model selection for work_item_reader tool](https://gitlab.com/gitlab-org/gitlab/-/commit/ea78e258322c34b99d4174660c73b42b588dc3a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211606)) **GitLab Enterprise Edition**
- [Add status overlay favicons for pipeline page](https://gitlab.com/gitlab-org/gitlab/-/commit/3054660b26fce5c0a4e1805f182bdd0fbb9c75b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211282))
- [Fix viewed files to automatically expand](https://gitlab.com/gitlab-org/gitlab/-/commit/174b21564d5f5a653f03e732ba180f3852506dbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211599))
- [Adding footer to groups dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/90c8d1f4512d3e419437c9c5e933b0574fa6406a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210759)) **GitLab Enterprise Edition**
- [Fix MR widget status border radius when warning is present](https://gitlab.com/gitlab-org/gitlab/-/commit/effd233b9b07270d7a2a5052315adb12b9ec2a62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211413))
- [Restrict admin_cicd_variables policy](https://gitlab.com/gitlab-org/gitlab/-/commit/1fb842bd435041f57d1ba0b941d12560838e76dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211276))
- [Fix broken 'Show file contents' button in Rapid Diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/94d58e831fc6a2fcba3a721234ed17d635125bd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211380))
- [Adjust panel styles for persistent header/footer messages](https://gitlab.com/gitlab-org/gitlab/-/commit/86adaf7f411199a7b6eeea97b6594cd6c27e3cc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211552))
- [Fix MCP tool array params to include required 'items' property](https://gitlab.com/gitlab-org/gitlab/-/commit/7973ffd006010340b7e17d7b8174944a21ad988d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211286)) **GitLab Enterprise Edition**
- [Fix Draft Notes API to create resolvable discussions and clarify docs](https://gitlab.com/gitlab-org/gitlab/-/commit/2bbf4f7fa07c970c656685c181c9febb04aef1c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210553))
- [Update add_on_name under subscription versioning](https://gitlab.com/gitlab-org/gitlab/-/commit/8aff294dbc61e38bec5c1218e2bf296f31f6a270) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211050))
- [Check scope properly on application recreation](https://gitlab.com/gitlab-org/gitlab/-/commit/b4c734af35983d21e47df29a12db06171282e0cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211290)) **GitLab Enterprise Edition**
- [Fix agentConfig reset when reselecting same custom agent](https://gitlab.com/gitlab-org/gitlab/-/commit/ac4dc458d0180da7fff1e506acaaf8257bbbff12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211427)) **GitLab Enterprise Edition**
- [Fix matrix expressions not working with spec header](https://gitlab.com/gitlab-org/gitlab/-/commit/17e977ca192da85121b20a95620d6971a69e86ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211422))
- [Fix lazy_ref_exists? to handle non-ASCII branch names](https://gitlab.com/gitlab-org/gitlab/-/commit/91d7054e1e8fdd3b82048e0707762e674f9f63eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211394))
- [Fix the Planningservice bug when there is a single node available](https://gitlab.com/gitlab-org/gitlab/-/commit/27ff84f7d57e8348ffd081e64da72b17286ea725) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210884)) **GitLab Enterprise Edition**
- [Fix background migration when Ghost user is missing](https://gitlab.com/gitlab-org/gitlab/-/commit/56c5f81e50404af5d74a49f2feec9f8331c8a5ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211366))
- [Fix flaky test: use fresh merge request per context](https://gitlab.com/gitlab-org/gitlab/-/commit/dd785d8a093e5f8238e7e17e5978ae53169b4758) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211363))
- [Downgrade Zeitwerk to 2.6.18](https://gitlab.com/gitlab-org/gitlab/-/commit/12a510f62f77930dfc3baf29a64f9e1bf1487b3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209895))
- [Persist toggle text when searching](https://gitlab.com/gitlab-org/gitlab/-/commit/9500b868bb9f7d08f4724a763d9e13d7c2acfb25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211280))
- [Improve DOM element detection in profile account page](https://gitlab.com/gitlab-org/gitlab/-/commit/4132b4d7abc0662f4103a9ef2c2cecdb4af82646) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210762))
- [Use original filename for opened temp files](https://gitlab.com/gitlab-org/gitlab/-/commit/9f75c690caf2f854f0d630a933ab810204ded3ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210489))
- [Fix NoMethodError when current_user is nil in MR subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/7666cdc892c48b043dfe1fc5d50b011d4eb8f404) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211262))
- [Remove page layout from empty state when streaming Rapid Diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/2fc64d74f4602525e65202341196c286a0e0c223) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211236))
- [Allow Legacy FIPS instances to Upgrade Oauth secerets](https://gitlab.com/gitlab-org/gitlab/-/commit/28f67fefdfe4c075f3fe4554c5747f8faaf1f86a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211027))
- [Fix test failure by adjusting dates to match partition range](https://gitlab.com/gitlab-org/gitlab/-/commit/31bfc38b399d5c1ad4487073733dd88980ee93ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211190))
- [Show "Status" widget information when changing "issue" to "epic"](https://gitlab.com/gitlab-org/gitlab/-/commit/4f52414387f3f43df7d85f0169d0a0b1018db924) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211177))
- [Rename a few more misnamed CI indexes](https://gitlab.com/gitlab-org/gitlab/-/commit/736c8560467f959f5b953b5a06d1d6efdd0c6854) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211164))
- [Fix unsubscribe links for epics](https://gitlab.com/gitlab-org/gitlab/-/commit/feae8ba3a5dd35174305762c639e64af68f48fd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211122)) **GitLab Enterprise Edition**
- [Fix framework associated projects](https://gitlab.com/gitlab-org/gitlab/-/commit/20b682e3bf66378a760bf8d1678bf35b574f0f9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211131)) **GitLab Enterprise Edition**
- [Modify ai_workflows check for MR API mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/ff22e7ce94278740dd26ac9977e325e0c8e25b74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211038))
- [Fix validation message UI](https://gitlab.com/gitlab-org/gitlab/-/commit/aaba5f235517cc612d437597fa6493848f0e7bda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211039))
- [Delete failed reindexing indexes created over 30 days ago](https://gitlab.com/gitlab-org/gitlab/-/commit/890ae08ed485c48725d424537c51e7fded7bd47b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210872)) **GitLab Enterprise Edition**
- [Fix ArgumentError in audit events for personal snippet comments](https://gitlab.com/gitlab-org/gitlab/-/commit/0536ad2a1d084e2360f8a493fe088cde9cdbc1bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211032)) **GitLab Enterprise Edition**
- [Update access token expiration webhooks ui](https://gitlab.com/gitlab-org/gitlab/-/commit/ccf2e54d3db36de28996be14a4d415b34660317d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211004)) **GitLab Enterprise Edition**
- [Fix infinite redirect loop in Gitea importer](https://gitlab.com/gitlab-org/gitlab/-/commit/058bf760ca60a88846516f06cfe579ed9d626a3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205106))
- [Treat events with push action as project event](https://gitlab.com/gitlab-org/gitlab/-/commit/be24ab9d67bdda452334df01afc21b9ac144e50e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209428))
- [Fix JS error when item.owner is null](https://gitlab.com/gitlab-org/gitlab/-/commit/2cba45c6d8b740b7b77dae648e30de129994947d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210602))
- [Fix rendering old invalid labels records](https://gitlab.com/gitlab-org/gitlab/-/commit/726d25ae6bfb7ef7a8d47f320d55d84eb23499c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210951))
- [Support Jira Cloud and Server issue fetching](https://gitlab.com/gitlab-org/gitlab/-/commit/253a334eeda23a9525d1af9b5dd817d1de1e4863) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208859)) **GitLab Enterprise Edition**
- [Add max width to code blocks to prevent overflow](https://gitlab.com/gitlab-org/gitlab/-/commit/58064b83c0d437db7d1b847064a57834c2e993a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210739))
- [Remove extra margin](https://gitlab.com/gitlab-org/gitlab/-/commit/90a8d6eea6b6f5f292e0de9f1093050f8bbfe0e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210892))
- [Fix vulnerabilities popover not showing](https://gitlab.com/gitlab-org/gitlab/-/commit/e2d7c35dcc870c28340307fa1be43d7f31afd853) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210869)) **GitLab Enterprise Edition**
- [Hide Sign-up button when not allowed in Project Studio](https://gitlab.com/gitlab-org/gitlab/-/commit/2a18b6ffc433d59b2207999d8158b454c6e699f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210857))
- [Prevent error when deleting personal snippet notes](https://gitlab.com/gitlab-org/gitlab/-/commit/edbeccd2e7b47108a3fef2a185cf220437bbecbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210836)) **GitLab Enterprise Edition**
- [Fix Tool Coverage data update when all projects are archived](https://gitlab.com/gitlab-org/gitlab/-/commit/c126d3438186a11d9a7074812d6437e5f574683e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210078)) **GitLab Enterprise Edition**
- [Allow Minimal Access group access for LDAP group links API](https://gitlab.com/gitlab-org/gitlab/-/commit/ccfa8429280558c6d0a3b1bc1c48cfeebd569283) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209644)) **GitLab Enterprise Edition**
- [Do not give upgrade url for non persisted groups](https://gitlab.com/gitlab-org/gitlab/-/commit/575a7be8a31300859c496501ffffce1c44d4cee7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210723)) **GitLab Enterprise Edition**
- [Fix type for dismiss modal](https://gitlab.com/gitlab-org/gitlab/-/commit/2339ef881bd5bd573dac308edef557c232f48bb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210772)) **GitLab Enterprise Edition**
- [Subscribe to GroupArchivedEvent for Elastic](https://gitlab.com/gitlab-org/gitlab/-/commit/bf53ef34d8a0185389576e17f387dae335b4b94c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208980))
- [Fix owner role in MR approval policy bypass settings](https://gitlab.com/gitlab-org/gitlab/-/commit/5158f1cf4c3be8eea17378da6b3100836ddb9ca9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209552)) **GitLab Enterprise Edition**
- [Update pipeline status after individual job rerun](https://gitlab.com/gitlab-org/gitlab/-/commit/aac7e1ac105929d53dd3d9cc508da4395210ccdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209634)) **GitLab Enterprise Edition**
- [Fix epic unlink quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/fab9e844fb307dcca6140f07369d1e30275fe889) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210541)) **GitLab Enterprise Edition**
- [Add wildcard support to cache](https://gitlab.com/gitlab-org/gitlab/-/commit/079cbd6776e0e9896845cb681d8dfeac82cb45c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209633))
- [Fix PKCE validation blocking MCP token refresh](https://gitlab.com/gitlab-org/gitlab/-/commit/68f2fb3b8782ade42fa7b1cf89d72130083fb35d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209820))
- [Adding footer to group projects dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/e4cf7ed9761c9d0fbc1cad2e35e3dddb1fba373a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210598)) **GitLab Enterprise Edition**
- [Fix error when displaying milestones with releases](https://gitlab.com/gitlab-org/gitlab/-/commit/aba3b0c8f43ea289a3dd370e5b4e79e74b1850d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210552))
- [Fix vulnerability comment loading state](https://gitlab.com/gitlab-org/gitlab/-/commit/f0ba6b336073fd71b1de6aee5c5154b3330a5b74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210539)) **GitLab Enterprise Edition**
- [Expose comment_on_event_enabled field for Jira](https://gitlab.com/gitlab-org/gitlab/-/commit/4c1443f401fd835e688403f9613bda9bb4be7450) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210108))
- [Fix WorkItem preload_indexing_data missing unified association labels](https://gitlab.com/gitlab-org/gitlab/-/commit/79afd792fc1b3a7c559c0cb595b5f1b34d10a953) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210099)) **GitLab Enterprise Edition**
- [Catch branch creation errors](https://gitlab.com/gitlab-org/gitlab/-/commit/b38835e627667353be4cfe802c43a797378922b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208648)) **GitLab Enterprise Edition**
- [Add `ai_features` scope to personal access token API](https://gitlab.com/gitlab-org/gitlab/-/commit/7a81c3b87f33b68ff0909342e5570c235976ccce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210494))
- [Fix manual ordering on group work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/9f32394cfcf81e6091b8f771899693483e6b3c67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209484))
- [Add deleted Geo migration back](https://gitlab.com/gitlab-org/gitlab/-/commit/d9bc7ca159294c352e8121b37e5148babe304b7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210413)) **GitLab Enterprise Edition**
- [LDAP sync security key support](https://gitlab.com/gitlab-org/gitlab/-/commit/37064f97767521ebb73572d0420eddd9863b0774) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210373)) **GitLab Enterprise Edition**
- [Use correct connection while checking the partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/be4fe1ab03652e0636af46ad5e533bd8a54b7985) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210367)) **GitLab Enterprise Edition**
- [Fix vulnerability report group (and instance) level filters](https://gitlab.com/gitlab-org/gitlab/-/commit/6d61572a81cabf67f9e4a9238fbaabad0109f19b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210337)) **GitLab Enterprise Edition**
- [Fix AmbiguousColumn error in orderable concern](https://gitlab.com/gitlab-org/gitlab/-/commit/5c97cf40532d6eed1dff63b73fcb6dbcad2dbdff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210167)) **GitLab Enterprise Edition**
- [Fix bug in state filters](https://gitlab.com/gitlab-org/gitlab/-/commit/bd6780637e6a42156d0a3694fe9545b76d81ae7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209918)) **GitLab Enterprise Edition**
- [Improve stage icons alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/bd6de42a0deffd628a6c39cfc106a423acfe5d03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209615))
- [Chat UI correctly loads foundational agent chat](https://gitlab.com/gitlab-org/gitlab/-/commit/3a7124872e94fa38512eb96e5ecfa9faeccc3a57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210301)) **GitLab Enterprise Edition**
- [Fix gfm reference for namespaces with the same path](https://gitlab.com/gitlab-org/gitlab/-/commit/63d87670c9777627ed483623665a610ad9d0917d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209321)) **GitLab Enterprise Edition**
- [Adds `simple-copy-button` component to fix copying in Safari](https://gitlab.com/gitlab-org/gitlab/-/commit/bf1e89e8b502ab27edce664cb4edd52b6919f98f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209139))
- [Fix the zoekt filters caching](https://gitlab.com/gitlab-org/gitlab/-/commit/20a01b6bc9104358239e07defd60aca332ef7eb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209798)) **GitLab Enterprise Edition**
- [Fix GLQL code block disappearing after dismissing alert](https://gitlab.com/gitlab-org/gitlab/-/commit/04e3f2787f2176ca0aa49cb49f62b59c4792e710) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210084))
- [Fix GraphQL permission error for remote Flows](https://gitlab.com/gitlab-org/gitlab/-/commit/96ab1d651a4a69c39fdb3252188da96d175445f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210067)) **GitLab Enterprise Edition**
- [Fix Gitlab::Graphql::OffsetPaginatedRelation#preload](https://gitlab.com/gitlab-org/gitlab/-/commit/53d12fde9e0a2e88928d0e9f1af54c0c4a931261) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210014))
- [Exclude `Duo features usage` metric from VSD metrics tables](https://gitlab.com/gitlab-org/gitlab/-/commit/095f3050e22f3e9225cd1ed7b67edffd6bd9a547) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210010)) **GitLab Enterprise Edition**
- [Fix GLQL rendering in Duo agentic chat](https://gitlab.com/gitlab-org/gitlab/-/commit/5d1c07c4ebd893c95a83c1dbc504363d464e4893) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209488))
- [Fix automate/agents path when not logged in](https://gitlab.com/gitlab-org/gitlab/-/commit/b6b9d5808344ab9d6dfd016e0459adbb1246f0de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209453)) **GitLab Enterprise Edition**
- [Normalize VulnerabilityScanning::Advisory urls](https://gitlab.com/gitlab-org/gitlab/-/commit/c5f134325fa08527a8c09627084b98e20c413e50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208953)) **GitLab Enterprise Edition**
- [Ensure WorkItem label changes trigger Advanced Search updates](https://gitlab.com/gitlab-org/gitlab/-/commit/e3318658b383220b7d692b058d5db5be5a470a4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209618)) **GitLab Enterprise Edition**
- [Do not limit rules:changes: to MR diff limit](https://gitlab.com/gitlab-org/gitlab/-/commit/d7d71696d37396238b4354427e07f4a80c971d03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199608))
- [Fix checksum_state presentation in the REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/46cdcdafaffcd4f9865b3cab7448104c411c983b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209437)) **GitLab Enterprise Edition**
- [Enable create jira issue for finding from security widget by default](https://gitlab.com/gitlab-org/gitlab/-/commit/3930bc7b711401e3e81bb48490ca08eb3a8df363) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209887)) **GitLab Enterprise Edition**
- [Fix mapping for non-persisted current statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/c68e7782e1455aa8c1946068e8a23e0e7668a55e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209736)) **GitLab Enterprise Edition**
- [Fix Credentials inventory revoked filter](https://gitlab.com/gitlab-org/gitlab/-/commit/29a11a20a3be3a02e44efc1662ec8fa105676e3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209536)) **GitLab Enterprise Edition**
- [Fix pagination issue with the pods list](https://gitlab.com/gitlab-org/gitlab/-/commit/acbdfa86a51d0690dd37887cc9d02e3c7aae808a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209814))
- [Fix missing gitaly_context forward in BranchPushService](https://gitlab.com/gitlab-org/gitlab/-/commit/4c8cb9bd0befff6a0e8127dbef6286ae7df72f76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208161))
- [Use aria-label for links only](https://gitlab.com/gitlab-org/gitlab/-/commit/6b23653a052dc0ba9476b9a2f76f700d220d696c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204199))
- [Fix approval rules webhook payload showing ActiveRecord proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/914ad72c446134be9090269e78f40e545d01b36e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209194))
- [Call CommitIndexerWorker when an empty project is created](https://gitlab.com/gitlab-org/gitlab/-/commit/b40bd9ce57ef59c9284d05df6f713c78cabf3faf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207806)) **GitLab Enterprise Edition**
- [Fix API error logger when current_user is not set](https://gitlab.com/gitlab-org/gitlab/-/commit/8edf9eaaab551a5954d27b15b82d912cd773540c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209774))
- [Fix alignment labels and overflow in pipeline table on smaller screens](https://gitlab.com/gitlab-org/gitlab/-/commit/8cda89de9ce9b2cd6791ddaf51b7220fd7e7832b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209464))
- [Remove archive_group feature flag from policies](https://gitlab.com/gitlab-org/gitlab/-/commit/edd7b041dcbb0e2b0996b5ea617247364eec40cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208631))
- [Add explicit attribute on enums on proj. c. violations](https://gitlab.com/gitlab-org/gitlab/-/commit/40380c670513066184379069d648bdc653365404) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209676)) **GitLab Enterprise Edition**
- [Add new badge for unpublished resources on FE](https://gitlab.com/gitlab-org/gitlab/-/commit/0797af0713ddcc896b37c5ae02b2da8f7df3578d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208657))
- [Fix: Duo Flows Setting Disabled shows checkbox](https://gitlab.com/gitlab-org/gitlab/-/commit/2075934464c4051c3efef73b998115f03428fae2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209725)) **GitLab Enterprise Edition**
- [Support template-based ids in existing attribute related mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/4a5e8f824f151532965c058c1b497e68d368abf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209156)) **GitLab Enterprise Edition**
- [Do not show empty page when the work items query is loading](https://gitlab.com/gitlab-org/gitlab/-/commit/f24eca21d16d7490d9189ca098bdd47a4285c65b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209688))
- [Resolve bug with keyless signing in child pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/d653cb69001ef8dcd6e1e07747ac0f54a063e0dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208180))
- [Improve accessibility of scrolling by reducing movement](https://gitlab.com/gitlab-org/gitlab/-/commit/82ee653a3a2eb1a4be165a14f65aeb431b8732bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209476))
- [Update tooltip for stages of "Allow failure" jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/8bd8f568838c33a079b4ff26e2444da0e4d197a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209639))
- [Fix the group archived for zoekt](https://gitlab.com/gitlab-org/gitlab/-/commit/abbdecacd93e0808acdd56ee44b5c45616230448) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208776)) **GitLab Enterprise Edition**
- [Improve MR analytics dashboard table responsiveness](https://gitlab.com/gitlab-org/gitlab/-/commit/8bd50ddb8ce2e5c41b9979d2c29d7540159f4711) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209339)) **GitLab Enterprise Edition**
- [Fix password validation exception for FIPS](https://gitlab.com/gitlab-org/gitlab/-/commit/afd3d3481244e3fad772e05124542b6d07407f65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208736))
- [Fix Events API Project target_type filtering for NULL values](https://gitlab.com/gitlab-org/gitlab/-/commit/99daf9e116b6143cf684c70580ee1e20b7ff97e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206175))
- [Show message when design management is not enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/59ebe6641a1ee6ccb970a1a1e9ca700429e3970b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209438))
- [Show warning and redirect if sign-up is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/78c8ac3b5009b03a1a7a98e0f0a9441cf7c95cc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208944))
- [Add "New pipeline" button for external config](https://gitlab.com/gitlab-org/gitlab/-/commit/902e204f3bf520f852c7f2ef03139f250731c26f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209318))
- [Support custom domains in Jira Connect CSP frame-ancestors](https://gitlab.com/gitlab-org/gitlab/-/commit/f388bf987e6138260c49ad65e9de0cb8ab00c5a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203037))
- [DuoAgenticChat: Handle null active thread](https://gitlab.com/gitlab-org/gitlab/-/commit/842144b35160ae07367fedb134d6586259717602) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209389))
- [Update GitLab UI with more accessible GlTokenSelector](https://gitlab.com/gitlab-org/gitlab/-/commit/a2fdd35ba0a9b6fc863a05c7a16a93207e3a53d8) ([merge request](https://gitlab.com/gitlab-org/gitlab-services/design.gitlab.com/-/issues/2215)) **GitLab Enterprise Edition**
- [Web Agentic Chat: fix calling workflowGoal on undefined](https://gitlab.com/gitlab-org/gitlab/-/commit/4777a5f1e1009ded42b3e4341273a134b344a639) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209315))
- [Fix AI Panel incorrectly evaluating agenticAvailable string](https://gitlab.com/gitlab-org/gitlab/-/commit/3b41a690d95896807c033a28f4526146e7da12c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209306)) **GitLab Enterprise Edition**
- [Add new badge for unpublished resources](https://gitlab.com/gitlab-org/gitlab/-/commit/b169087f2a90d01f957bea550014db0ea069db6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208654))
- [Suppress noisy GraphQL deprecation errors for complexity](https://gitlab.com/gitlab-org/gitlab/-/commit/ae316ade26e2c6f4d3677740e0c6e3e08b6604a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209293))
- [Remove support for license name](https://gitlab.com/gitlab-org/gitlab/-/commit/c5d95919eed96bc0521e577baf5dfbd5e4b3b0c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209007)) **GitLab Enterprise Edition**
- [Fix status fallback to use lifecycle-aware default](https://gitlab.com/gitlab-org/gitlab/-/commit/2cf2e8e83ce769b45da22d4e79c649d642688da7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208414)) **GitLab Enterprise Edition**
- [Downgrade redis-rb gem to v5.4.0](https://gitlab.com/gitlab-org/gitlab/-/commit/bdb7f9241caacbe7bf55720a1e4ea8f8e058b182) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209191))
- [Delay loading of countries until hand raise lead modal opens](https://gitlab.com/gitlab-org/gitlab/-/commit/4ed66f6ee0765702f2b9e890ca8594acec8e97d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209150)) **GitLab Enterprise Edition**
- [Fix race condition in merge request metrics creation during import](https://gitlab.com/gitlab-org/gitlab/-/commit/51371443cc8eeb01f8f5d683c886a5f7a970ce23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208695))
- [Cleanup feature flag maven_packages_unauthorized_with_public_registries'](https://gitlab.com/gitlab-org/gitlab/-/commit/d7d4fdefa11f2be09afb270301498dd4ad4e0dce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209110))
- [Fix keyboard focus order](https://gitlab.com/gitlab-org/gitlab/-/commit/28e678e7d6de5eb3e5734496b889432f61e45d17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208749))
- [Skip SPP scan when payloads are empty](https://gitlab.com/gitlab-org/gitlab/-/commit/e47783d341d5bcea5ceaea2be44d6e88fa5d7201) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208248)) **GitLab Enterprise Edition**
- [Hide invite banner if invitations are prevented](https://gitlab.com/gitlab-org/gitlab/-/commit/2f7744ad6757f7050337f68ad70524b59ee9de18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208493))
- [Fix Incidents sticky header title text for long titles](https://gitlab.com/gitlab-org/gitlab/-/commit/bfadbe40a466b20b55395ea6295d16c1222ffbfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208907))
- [Set http_continue_timeout to nil for s3 client](https://gitlab.com/gitlab-org/gitlab/-/commit/430eccbb309320c542abaa09762bf73aee957607) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208851))
- [Fix connection pool errors when health check is running](https://gitlab.com/gitlab-org/gitlab/-/commit/e8be888b786b28644ad9279abba1a801a07af0e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208836))
- [Fix sorting for parallel jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/c21e7087b7443855de6ca7ee99901a477d1e88ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208796))
- [api: Fix 500 error when updating user with empty organization](https://gitlab.com/gitlab-org/gitlab/-/commit/ab021c41f34285d0377936459036f6fc67e2cd26) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208783))
- [Add scheduled fields to pipeline details query](https://gitlab.com/gitlab-org/gitlab/-/commit/5b7c3a353ffdc04c27a858f4e3975c10d6e42551) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208279))
- [Filter out group-level rules from details page](https://gitlab.com/gitlab-org/gitlab/-/commit/e6721b8307224ff1e2cdce8a0cda41a4653378af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208771))
- [Add explicit type for policy_type](https://gitlab.com/gitlab-org/gitlab/-/commit/aa4360a0a62fdc4d584aaeb80cd5f4594d106d52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207292)) **GitLab Enterprise Edition**
- [Fix Tool Coverage data update when all projects are archived](https://gitlab.com/gitlab-org/gitlab/-/commit/86135053c0422caf5aa28ff4398e62526fc4e94b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208741)) **GitLab Enterprise Edition**
- [Fix: Update order to UPDATED_DESC for agent sessions](https://gitlab.com/gitlab-org/gitlab/-/commit/3f28f65184a1408dad895046ad1a684d90a441c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208660)) **GitLab Enterprise Edition**
- [Fix secret detection scans for scheduled SEP](https://gitlab.com/gitlab-org/gitlab/-/commit/d1bdf890e709ab7d2888d1276abc9b2222b0c931) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205744)) **GitLab Enterprise Edition**
- [fix: Issues with `to_redacted_sql` method in clickhouse](https://gitlab.com/gitlab-org/gitlab/-/commit/5ce4f945320e19442209d9e01df8cce23944639e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208590))
- [Update ConfigurationPurgeWorker to nullify PAT](https://gitlab.com/gitlab-org/gitlab/-/commit/2c4fb6e758b6d71ec82fed153aece5723afb4ac3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208381))
- [Fix: Ensure commit dates are interpreted in UTC for history requests](https://gitlab.com/gitlab-org/gitlab/-/commit/7a21ed34f00c3e0ae92a747462f3de22297179e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202612))

### Changed (238 changes)

- [Preserve selected Duo Chat conversation when reopening overlay](https://gitlab.com/gitlab-org/gitlab/-/commit/eded0c79a275779acc2bfbeccd21f04a57aec561) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212620)) **GitLab Enterprise Edition**
- [Update url for composite identity error](https://gitlab.com/gitlab-org/gitlab/-/commit/7bf9e2fd78b95f873e92f8d79e4ec353d9ae2bc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212965)) **GitLab Enterprise Edition**
- [Always show page size selector on vulnerability report](https://gitlab.com/gitlab-org/gitlab/-/commit/debb21179ce5e15f93692c24b0a3d9e9f20015c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212889)) **GitLab Enterprise Edition**
- [Exclude page size 100 from vulnerability report with certain ffs](https://gitlab.com/gitlab-org/gitlab/-/commit/a24d1907af10a2d961a6f9eb9e79693466f2dd09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212945)) **GitLab Enterprise Edition**
- [Simplify finished pipeline sync events ingestion query](https://gitlab.com/gitlab-org/gitlab/-/commit/e25427a3fe2e3e68d2f1bbad7232a52daacc5a44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212944))
- [Remove ai_catalog_item_project_curation ff](https://gitlab.com/gitlab-org/gitlab/-/commit/b128d33a75465ea5f5001226390ca737bfc62ba2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212361))
- [Minor updates to ActiveContext code indexing](https://gitlab.com/gitlab-org/gitlab/-/commit/a861b5821caa04c5043afd83333a52a3501a8c6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212766)) **GitLab Enterprise Edition**
- [GraphQL: Remove deprecation of runner setup instructions fields](https://gitlab.com/gitlab-org/gitlab/-/commit/95c1744526ff3b68bbcc409bf2878711e61fde66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212212))
- [Feat: Update alerts in workflow actions to toasts](https://gitlab.com/gitlab-org/gitlab/-/commit/2f847ccca090a74a966a331546997c585d9b7dd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211788)) **GitLab Enterprise Edition**
- [Refactor merge request create service to only write v1 or v2 rules](https://gitlab.com/gitlab-org/gitlab/-/commit/246cb35637d57aa7eb5b0af5ded37da906ee55a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210114)) **GitLab Enterprise Edition**
- [Only show sidebar tier-badge for private non-user namespaced groups](https://gitlab.com/gitlab-org/gitlab/-/commit/d4b644d7ace4f4dc2af4cded72be7585914d57b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212300)) **GitLab Enterprise Edition**
- [Show expired link page on missing sent_notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/5280118a6cb59c2c3034ce3b04a4422f8d5dddbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212505))
- [Allow GitLab Duo to read wiki pages](https://gitlab.com/gitlab-org/gitlab/-/commit/9eb2e41e030e775d5069e4ca4299b16f8de399f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211298))
- [Fix Security Dashboard project count mismatchfor subgroups](https://gitlab.com/gitlab-org/gitlab/-/commit/3921ed43214787ec3be3517118860de751a0ec10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212617)) **GitLab Enterprise Edition**
- [Set organization_id for oauth_applications](https://gitlab.com/gitlab-org/gitlab/-/commit/a8cc65be65b603628598a8b07700fe528669455e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211716))
- [Update agent_platform_claude_code FF default on](https://gitlab.com/gitlab-org/gitlab/-/commit/5a846057126323e1a381d132a5a29d3db42813fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212765)) **GitLab Enterprise Edition**
- [Remove unused finding token status fields on vulnerability report](https://gitlab.com/gitlab-org/gitlab/-/commit/68495971a490a8b55cccda26874a46823c91c9eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212762)) **GitLab Enterprise Edition**
- [Skip deprecated feature tests in Vue 3](https://gitlab.com/gitlab-org/gitlab/-/commit/754e3c6253afcbea252773125e89da3fb3f5cd93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212292))
- [Enable foundational_security_agent feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/29b2de8a27e2b5364884efde174e2cadd8a08ed9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212675))
- [Fix failed login audit events for existing users](https://gitlab.com/gitlab-org/gitlab/-/commit/8c1320dbfa31be4f416c6aaf86548cb6879f318f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212310)) **GitLab Enterprise Edition**
- [Update DB traffic capture config](https://gitlab.com/gitlab-org/gitlab/-/commit/937e401ef40bdad8c355808aaa01423705f0c18e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212610))
- [Assign all imported contributions to personal namespace owner](https://gitlab.com/gitlab-org/gitlab/-/commit/2ed6ead7339f019cb762ffb0db68368cef01ea9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211626))
- [Added new feature flag for generic GitLab API tool](https://gitlab.com/gitlab-org/gitlab/-/commit/6863d43bd256ccf55271703c46a48308b2acef68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212082)) **GitLab Enterprise Edition**
- [Update border radius of trial widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ea37a6cd35e642b30ce2652cb2152667f71b540e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212602)) **GitLab Enterprise Edition**
- [Rename feature to posix_escape](https://gitlab.com/gitlab-org/gitlab/-/commit/fb5cc516ec049e32da4fe8d63dbb5c6613b9be4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212570))
- [Add warning message when SPP errors](https://gitlab.com/gitlab-org/gitlab/-/commit/6bde8467e86c87b11dc9c71e6aaad453829c6e0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211006)) **GitLab Enterprise Edition**
- [Expand MR security pipeline comparison to check last 10 commits](https://gitlab.com/gitlab-org/gitlab/-/commit/7244e9178044e9a6fab246bb80e6b68004db945d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207751)) **GitLab Enterprise Edition**
- [Set destroy_fork_network_on_group_archive true](https://gitlab.com/gitlab-org/gitlab/-/commit/008d13cb8c459aabcd32826a71eb7ad2ea5802b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212510))
- [Shard `abuse_events` table](https://gitlab.com/gitlab-org/gitlab/-/commit/fb1d936193ef725b57d9f6ffadb7348b8bbad9c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211827))
- [Fix icon hover color in search filters](https://gitlab.com/gitlab-org/gitlab/-/commit/38c58a305c0e910762f44080106d03da3cdda546) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212434))
- [Enable `custom_webhook_template_serialization` feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/0789b7e43cb1852e7f290fb4f5547dab8d76df54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212407))
- [Add error handing to all api endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/a28677fe3d3220514819444e4ba14da83de88be1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211265))
- [Set `import_rescue_query_canceled` enable by default](https://gitlab.com/gitlab-org/gitlab/-/commit/8a1df9f2f91977d095b3df978ff96f9c1f2cd71c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212394))
- [Unify the "New related item" for all work item three dots menu](https://gitlab.com/gitlab-org/gitlab/-/commit/8ab0c485d476be9c4a3ad10941f50a8d886a4ccc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212329))
- [Require space around title emojis](https://gitlab.com/gitlab-org/gitlab/-/commit/a671d6a26485ca3e9b281788f37a7895dd48ba55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211780))
- [Set risk_score related columns in statistics tables to ignore](https://gitlab.com/gitlab-org/gitlab/-/commit/936b3d9754a425de283a4075ab52349dfc62407c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210415)) **GitLab Enterprise Edition**
- [Always return RateLimit-* headers for all requests](https://gitlab.com/gitlab-org/gitlab/-/commit/ff1024373338748bb23bdb6cc85ade8eecb571d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209485))
- [Index p_ci_finished_pipeline_ch_sync_events on pipeline_id](https://gitlab.com/gitlab-org/gitlab/-/commit/61e0fd786f6068a314c93bd12fcd0bd5f3e33e75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212295))
- [Set zoekt load balancer FF to default enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/a098eaba52e753214db05aaa63cf1d04f83efa52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210746)) **GitLab Enterprise Edition**
- [Remove dora_metrics_dashboard feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/03d31a177c375ace1956fcc34280ca8a3c8b08a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211196))
- [Reduce timeout for async index testing to 30s](https://gitlab.com/gitlab-org/gitlab/-/commit/2e82753eafe2f396a9b52bf053537c692098035b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212254))
- [Fix root_path check & project parsing in SM audits](https://gitlab.com/gitlab-org/gitlab/-/commit/05ca5d7039112e56a7aa9041e7edbeddaec27037) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211789)) **GitLab Enterprise Edition**
- [Remove log_refresh_service_duration feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1dafec392073b55c3285eaf6f46d1a5f75498642) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212198))
- [Add endpoint to set zoekt number of replica override](https://gitlab.com/gitlab-org/gitlab/-/commit/8ed036227e3cc665a859f50bca156ab5500c0bcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210755)) **GitLab Enterprise Edition**
- [Update vulnerability report docs](https://gitlab.com/gitlab-org/gitlab/-/commit/c94e4c0c3749a63672587fc52bc7ea38017701f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210993)) **GitLab Enterprise Edition**
- [Add organization_id to user_agent_details table](https://gitlab.com/gitlab-org/gitlab/-/commit/67fb9934b117c355767adae63622e46c3be1a030) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211645))
- [Remove excess zoekt replicas](https://gitlab.com/gitlab-org/gitlab/-/commit/6c7b87ee13940bbceac67555320577b7485649ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210508)) **GitLab Enterprise Edition**
- [Remove feature flag fix pipeline button](https://gitlab.com/gitlab-org/gitlab/-/commit/d3babe1876fbacdbd68c4e0626d6b8056472d69d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212056)) **GitLab Enterprise Edition**
- [Rename files if necessary after remote to local artifact migration](https://gitlab.com/gitlab-org/gitlab/-/commit/6f3db9d6507e66ba1e64ea1b0e3d3dd56b88c0ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208964))
- [Remove show_icon arg in alert component](https://gitlab.com/gitlab-org/gitlab/-/commit/25175443935ea28db9c93c1a2dcb8497b289ae1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211798))
- [Enable read_and_write_group_push_rules feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/71110eb4ae2b032b6d445eb30950c9c0168c8139) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212115))
- [Add countable interface ro compliance frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/b2a9cdf778bb2287097a74934145145da980a53a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212101)) **GitLab Enterprise Edition**
- [Enable policy_violations_es_filter by default](https://gitlab.com/gitlab-org/gitlab/-/commit/3794401077e5e8b39959a24d8a9fdee5c333c68f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210960)) **GitLab Enterprise Edition**
- [Shows DAP welcome modal for users with Studio enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/47479e630c644516a1bb8915b1ad64b88b51f250) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212080))
- [Remove obsolete project limit code from Zoekt SelectionService](https://gitlab.com/gitlab-org/gitlab/-/commit/4d46f9d1abf982ff5f2db104a82bb52de6acd2ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212059)) **GitLab Enterprise Edition**
- [FF rollout truncate commit message in CI env var](https://gitlab.com/gitlab-org/gitlab/-/commit/6d1c47358f87122f4ff8516c8a5a14701d2b2457) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212058))
- [Minor updates to the MarkRepositoryAsReadyEvent](https://gitlab.com/gitlab-org/gitlab/-/commit/92279f18013a2a47c95c832289ff4993dfcd707f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212040)) **GitLab Enterprise Edition**
- [Add logging for company step skip validation](https://gitlab.com/gitlab-org/gitlab/-/commit/9d18bf9380a361a419dc7c82527fb9996286c8b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211980)) **GitLab Enterprise Edition**
- [Extend scope selector with exclusion of personal projects](https://gitlab.com/gitlab-org/gitlab/-/commit/584c0364cc4349e661d6cf638472a0d28b45ec52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211432)) **GitLab Enterprise Edition**
- [Remove the user_billing_pricing_information experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/470f60532e7c9f9a514bada23c0ee507652f1c5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210705)) **GitLab Enterprise Edition**
- [Replace BranchesFinder names filtering with RefsFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/ba8146e136b78e3d5eb7bcd6f3f6488c317bee93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211102))
- [Improve edit branch rules and squash options error handling](https://gitlab.com/gitlab-org/gitlab/-/commit/de4ac97615991bc892dcbcd6876056aee94c04fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211128)) **GitLab Enterprise Edition**
- [Enable requiring API authentication for GET CI Lint endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/b199555d296b08b4c41877b21fcdce48214f6762) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211902))
- [Disable AI features in sidepanel when duo_features_enabled is off](https://gitlab.com/gitlab-org/gitlab/-/commit/0d199f8a5f91dc1762b779e32c2e0075ae3cbc54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211030)) **GitLab Enterprise Edition**
- [Return 204 for long polling requests during Workhorse shutdown](https://gitlab.com/gitlab-org/gitlab/-/commit/4d4f216286cef2b96076b54589b2440644824a31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211872))
- [Enable split_refresh_worker_web_hooks feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/f998c97e2316909a7ea5328b65bf2037cb4f1461) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211874))
- [Wrap all relevant wiki pages in a layout partial](https://gitlab.com/gitlab-org/gitlab/-/commit/a55326f4f21e804a9b7d2685939af650483c1014) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211743))
- [Disable the new UI for anonymous users](https://gitlab.com/gitlab-org/gitlab/-/commit/7df33790dbc9c196ae667525f43fb10742dd463d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211794))
- [Lock wiki sidebar on left side](https://gitlab.com/gitlab-org/gitlab/-/commit/47fdb8c2c9f38a91514d7d6f2d98fd7384a60cd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211364))
- [Disable Workhorse Rails skip interval in readiness check by default](https://gitlab.com/gitlab-org/gitlab/-/commit/9e32a70d420295909f3e227e63709778be75dd72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211818))
- [Remove fixed width from model dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/07918aa3c79b56f46cb3f26996a08925bcf42b70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211631)) **GitLab Enterprise Edition**
- [Remove abuse report notes from GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/d5891d7f8e90df87f1c264aca454a6eac53c2f00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211500))
- [Correct grammar errors](https://gitlab.com/gitlab-org/gitlab/-/commit/9b87b37f5fee2c27807e76acded7c01746918c4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211667)) **GitLab Enterprise Edition**
- [docs: Add Default option for branch-level squash settings](https://gitlab.com/gitlab-org/gitlab/-/commit/907606e98aa579f5b2e7aab32c20ce4aae88a348) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211670))
- [Default enable read_organization_push_rules](https://gitlab.com/gitlab-org/gitlab/-/commit/86adea6364fd45ea5d721f1e0881765b1fcf6448) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211782))
- [Add persistant tier badge to sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/65f821935a6e0996688e46eb44d0b29af9a2128b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209574)) **GitLab Enterprise Edition**
- [Enable the new UI for all .com users](https://gitlab.com/gitlab-org/gitlab/-/commit/fc5843a56795f8909a7aabfd7f23bcb22503d5e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211301))
- [Updating Core UI text](https://gitlab.com/gitlab-org/gitlab/-/commit/0d73a8e469093e51ec2818f24978910feedfc0f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210973))
- [Move email issue link to dropdown menu](https://gitlab.com/gitlab-org/gitlab/-/commit/9e022dd34a9a6e7c9b0922c75350b0715e3c28b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210382))
- [Move after commit_hook to state_machine](https://gitlab.com/gitlab-org/gitlab/-/commit/8ba0c850b374d9c7fd8de5fc134026efa0d49852) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211617))
- [Ensure mcp_server is accessible with premium plan](https://gitlab.com/gitlab-org/gitlab/-/commit/5dae1227c35df316aee85ad345af9e1f0c47363d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211588)) **GitLab Enterprise Edition**
- [Subscribe CreateWarnModeApprovalAuditEventsWorker to ApprovedEvent](https://gitlab.com/gitlab-org/gitlab/-/commit/22b7aaccbcbac8263f45db059d370c6208be84c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211372)) **GitLab Enterprise Edition**
- [Update Code Embeddings ad-hoc indexing eligibility check](https://gitlab.com/gitlab-org/gitlab/-/commit/48b60c01a427115e399b0c59127853b3ce36d370) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211531)) **GitLab Enterprise Edition**
- [Remove def delete_compliance_requirements_controls](https://gitlab.com/gitlab-org/gitlab/-/commit/b69b90376b6cc30d5fbfd7476dac35f9c5d4ec68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211459)) **GitLab Enterprise Edition**
- [Replace archived delegation with hierarchical check](https://gitlab.com/gitlab-org/gitlab/-/commit/9709fd6b985bb79712f6188f1c6dda8e964790d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211206))
- [Set autofocus on header items on page load](https://gitlab.com/gitlab-org/gitlab/-/commit/e415af521ff71dac01eaf46d4936334dbb938942) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211561))
- [Make compliance project archival compatible with group archive](https://gitlab.com/gitlab-org/gitlab/-/commit/c164e5fc772b0169aa622390716c3c13b579fdbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211557)) **GitLab Enterprise Edition**
- [Hide feedback widget for offline instances](https://gitlab.com/gitlab-org/gitlab/-/commit/899ef552ff5d6d1b8ff2072fa6c89d45fc0324b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210797))
- [Recreate warn-mode audit events when project settings change](https://gitlab.com/gitlab-org/gitlab/-/commit/7068c8894c8c09682a27e3083bdfde5a3f59bbf6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210848)) **GitLab Enterprise Edition**
- [Add destroy issue permission to the planner role](https://gitlab.com/gitlab-org/gitlab/-/commit/488ed79b3625e8e6cd1eac9f5b0b2e2d000cb9e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207869))
- [Remove haml inconless alerts](https://gitlab.com/gitlab-org/gitlab/-/commit/ec5dbfe18a2e010a760998393f75185d6f903252) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211476))
- [Remove preview group headin from new UI toggle](https://gitlab.com/gitlab-org/gitlab/-/commit/1d1ad612c9fdb090aa48ffd218f0b8b02942c35d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210982))
- [Add ai_workflows scope to Branch API](https://gitlab.com/gitlab-org/gitlab/-/commit/ae8f707a741d6331bc0bcab95fb18328a8a19378) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210870)) **GitLab Enterprise Edition**
- [Remove instances of deprecated 'issues' icon in EE](https://gitlab.com/gitlab-org/gitlab/-/commit/a68acdcfbc60958b49ee96b396332656453d7c36) by @webmekanic ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208316)) **GitLab Enterprise Edition**
- [Add organization_id to oauth_applications table](https://gitlab.com/gitlab-org/gitlab/-/commit/4b3f037a497758d79c9dc1de62d53bd9bc5ef0f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211224))
- [Use files count from commit stats rpc for commit rapid diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/7f1e5f0a0d1e9a4b224b8d698579b54e18cc60ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209475))
- [Add warn mode approval audit events worker](https://gitlab.com/gitlab-org/gitlab/-/commit/772eb906da696343e27376fd30067780557306bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211248)) **GitLab Enterprise Edition**
- [Small updates to adhoc indexing](https://gitlab.com/gitlab-org/gitlab/-/commit/10f71399643d96049b3206c04e0227383ae3e1fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211257)) **GitLab Enterprise Edition**
- [Add ES migration to backfill vulnerability risk_score field](https://gitlab.com/gitlab-org/gitlab/-/commit/0756de47859f25205e79695ca1339198cb9b86fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210023)) **GitLab Enterprise Edition**
- [Add number_of_replicas to zoekt enabled namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/cb971af4285470df5312417ae11a233e8eac28e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210380)) **GitLab Enterprise Edition**
- [Release GLQL Advanced Search integration](https://gitlab.com/gitlab-org/gitlab/-/commit/253471acda0f6233f6e79ad34e7dad4aca6f07fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210854))
- [Bump vulnerabilty index schema version for risk score](https://gitlab.com/gitlab-org/gitlab/-/commit/b8d0bb94f3aab67d4a95e86e079fde97d11c4d49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211168)) **GitLab Enterprise Edition**
- [Update group/project restore card styling](https://gitlab.com/gitlab-org/gitlab/-/commit/6252671b59af77ebc44bbdd4c036035796bf856d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211130))
- [Feat: preserve session details in agents side panel](https://gitlab.com/gitlab-org/gitlab/-/commit/2a89e69e49071a3627166ad1d1f14476edb0e298) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210383))
- [Add optional domain parameter to /pages/domains admin API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/fadd662e1a7ef4a6ef69ce1837154be2181b2112) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211151))
- [Set gutter to be 8px below lg breakpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/77b4cd44a68f60682d51598b9d9a55071074eaa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210934))
- [Add root_group to Project GraphQL type](https://gitlab.com/gitlab-org/gitlab/-/commit/b58ecdcfb24bcfdd4e4b502270d71785fec8fb1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211223))
- [Allow inherited groups as Code Owners](https://gitlab.com/gitlab-org/gitlab/-/commit/bc741b93d383c319b5858174b88ed668b02898ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211268)) **GitLab Enterprise Edition**
- [Update gitlab-secret_detection gem to 0.38.0](https://gitlab.com/gitlab-org/gitlab/-/commit/0ce1b569ce0222dc62ca64caf4e5b6790624bd13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211238))
- [Disable batching of Snowplow events](https://gitlab.com/gitlab-org/gitlab/-/commit/3e114aa1c858141f1adbdf5ca9ca3ca474ffcf72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210474))
- [Adjust border and emoji button on homepage banner](https://gitlab.com/gitlab-org/gitlab/-/commit/87204bc569b455c4b36acc99a2da4876c7d78416) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208188))
- [Create warn mode approval audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/b4d4cbebc3902cebe242f6d654a8ec71d2780c0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210351)) **GitLab Enterprise Edition**
- [Add organization_id to deploy_keys](https://gitlab.com/gitlab-org/gitlab/-/commit/afc9b70632d1e0a6d74beb5e0ceecf9224cce4b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209317))
- [Add exclusion type map to project security exclusion model](https://gitlab.com/gitlab-org/gitlab/-/commit/fbe4da3ecc0762fc8ef01a2aaee79535b072bc26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210386)) **GitLab Enterprise Edition**
- [Remove duo_side_rail feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/aeaa519c25bec5f34edfa4e712d12e9d0c2a7e90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211015)) **GitLab Enterprise Edition**
- [Update ghost user calls to per-organization model](https://gitlab.com/gitlab-org/gitlab/-/commit/d02eeff397d68fca67a407eacd323d339e26a3c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206415))
- [MCP semantic_code_search: Update handling for no code embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/828cb08ea016ecb4aa66d83c11c81a7e7354331d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210426)) **GitLab Enterprise Edition**
- [UI and text changes on welcome to new UI modal](https://gitlab.com/gitlab-org/gitlab/-/commit/b38c4252f82d67a4562cdef7ca23fde20f8fccb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210557))
- [Sort elements in compliance report](https://gitlab.com/gitlab-org/gitlab/-/commit/57f6db65ec31ed61f35614782f160b6264920fdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210887)) **GitLab Enterprise Edition**
- [Instance Configuration: Add rate limits for pipeline creation](https://gitlab.com/gitlab-org/gitlab/-/commit/42206e5ff8a50837e4479e61b9a2ef2bda8e127f) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209894))
- [Remove runner registration token deprecations](https://gitlab.com/gitlab-org/gitlab/-/commit/ac5a7f7a0cee289779b516b0481b9f6ee6b673b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210841))
- [Improve display error message for access tokens UI](https://gitlab.com/gitlab-org/gitlab/-/commit/04b0f4248c52bda663ed67934973770e879deafb) by @onasser ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200209))
- [Account for warn-mode policies in MR widget](https://gitlab.com/gitlab-org/gitlab/-/commit/4b41d1958cbb9f9fa215cbc70145b5069746c5d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210168)) **GitLab Enterprise Edition**
- [Added Import::Offline::Export model and associations](https://gitlab.com/gitlab-org/gitlab/-/commit/464212888ecfb67a57871e9ba5ec6da680bfb7cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209344))
- [Render milestone as a link on the MR analytics dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/18151e677a09cf8caa0e635795ca0c5ef1e2175c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210544)) **GitLab Enterprise Edition**
- [Ensure redacted links do not re-escape their inner HTML](https://gitlab.com/gitlab-org/gitlab/-/commit/808c8bc19a45990e6b680579891484ec717c7a2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207397))
- [Restyle the user item count widgets](https://gitlab.com/gitlab-org/gitlab/-/commit/643a73149ae6b698013c0665fe90c91dec520b25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210158))
- [Return pipeline from cancel mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/683be68f4b7d231fab694ad8af7eacd119fd8ef3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210736))
- [Move verification_status_widget out of `work_items_alpha`](https://gitlab.com/gitlab-org/gitlab/-/commit/ca0ba62465f48fb803fa8922e77e242b772d900f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210801)) **GitLab Enterprise Edition**
- [Remove the importer_user_mapping_allow_bypass_of_confirmation FF](https://gitlab.com/gitlab-org/gitlab/-/commit/39b3792c1ee681e4394e78a4231bbba1af281579) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209561))
- [Drop cached_route_lookups feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d962772d7a67ded529221f09471939bf07f77ccd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210774))
- [Cleanup the group fields component](https://gitlab.com/gitlab-org/gitlab/-/commit/586049d1c47409d4b9d7aaf59433d35e46969417) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210771)) **GitLab Enterprise Edition**
- [Remove duo core widget from self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/6de328d40bd0164ea0e525aa188c749012b52272) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210564)) **GitLab Enterprise Edition**
- [Rename shared examples from issue template](https://gitlab.com/gitlab-org/gitlab/-/commit/f6ef8ae0995a0a0c4c6dd599825702eca04791e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209789)) **GitLab Enterprise Edition**
- [Refactor group deletion HAML templates and adjust styling](https://gitlab.com/gitlab-org/gitlab/-/commit/f10d4dbea9cebe08e80cff2f970d5555e0a8df89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210379))
- [Resolve Chain of Custody report inconsistencies](https://gitlab.com/gitlab-org/gitlab/-/commit/ea699af4b5a790f333a1bd7a020f0bb32c7bdcf9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207771)) **GitLab Enterprise Edition**
- [Remove disabled usage on GlPaginate](https://gitlab.com/gitlab-org/gitlab/-/commit/78ca60f7c420a4c23efd06218e08d232d35c015b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210407))
- [Remove no-icon option on alerts](https://gitlab.com/gitlab-org/gitlab/-/commit/ea1ae8c0f843841e91777d6790c8adab45b27f53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210169)) **GitLab Enterprise Edition**
- [Add Project Path and Host to Flow Trigger Runs](https://gitlab.com/gitlab-org/gitlab/-/commit/1daec89dba51502889e5e7e2944b49597cfa131b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210523)) **GitLab Enterprise Edition**
- [Feat: adjust sessions activity dropdown labeling](https://gitlab.com/gitlab-org/gitlab/-/commit/c1fafa312f0903092ca090f3ce2a1a7fdf88bb77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210398)) **GitLab Enterprise Edition**
- [Remove use_user_group_member_roles feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f7bd7b6e5f35ad15a0fd2030951a00b6f7ececa8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208593)) **GitLab Enterprise Edition**
- [Skip challenge req on phone/cc verification when Arkose is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/00832c9403603d5cb8009f2ffa12702ef3aa4b05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210263)) **GitLab Enterprise Edition**
- [Remove minimum project setting for traversal id search](https://gitlab.com/gitlab-org/gitlab/-/commit/a208ef1087bc84100f7a7e6ec2558351fb062b75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209862)) **GitLab Enterprise Edition**
- [Remove runner registration token deprecations](https://gitlab.com/gitlab-org/gitlab/-/commit/0abd799570b35d35bfd59a7535cde60dab917a54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210321))
- [Truncate long titles in chat header](https://gitlab.com/gitlab-org/gitlab/-/commit/9ce4406f7af6f9de63fdc3f5a512b2c7fb8e577f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210311)) **GitLab Enterprise Edition**
- [Account for `policy_scope` in approval setting override audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/52bd85d0676c371075857294532fbda40f935f57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209914)) **GitLab Enterprise Edition**
- [Control access to MCP with beta features setting](https://gitlab.com/gitlab-org/gitlab/-/commit/a5416eec0d12325908ce1ba34df7e2bf730d3467) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209782)) **GitLab Enterprise Edition**
- [Set destroy_fork_network_on_archive true](https://gitlab.com/gitlab-org/gitlab/-/commit/e2048b08ccd1dbb153477f17ab3f80e0e1307c68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210235))
- [Move mirroring utility classes to EE directory](https://gitlab.com/gitlab-org/gitlab/-/commit/b6d3f0e4cf8f5785780f2e7fcff94a892dc3d5ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210229)) **GitLab Enterprise Edition**
- [Remove 'include_csp_frameworks' Feature Flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7d7f691c89a1940c76a22a8c9c957db9c598cd03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210020)) **GitLab Enterprise Edition**
- [Update availability check for semantic_code_search MCP tool](https://gitlab.com/gitlab-org/gitlab/-/commit/e4d1b8d2384a98945f2a6b1cae4429ad73eb651c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210070)) **GitLab Enterprise Edition**
- [Change index on Attestation IID to be unique](https://gitlab.com/gitlab-org/gitlab/-/commit/126013cb6cde0a73e12f996d6d000d6db5b53e01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209332))
- [Require API authentication for GET CI Lint endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/71b1f04caf96af5bab87602650e5abb59aced19c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209764))
- [Add description success response](https://gitlab.com/gitlab-org/gitlab/-/commit/6af23c8c5b4ce0d89a29f65724c87016369ce98c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209136))
- [Remove the whats_new_featured_carousel ff](https://gitlab.com/gitlab-org/gitlab/-/commit/96a055e53772f4f08b5e057b0acba3ed38c670b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209521))
- [Create audit events for more restrictive warn-mode approval settings](https://gitlab.com/gitlab-org/gitlab/-/commit/dd5dc5bdb6062da8e03d4e1a9bdc86ee3cb56b18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208969)) **GitLab Enterprise Edition**
- [Remove usages of `abuse_trust_scores` code](https://gitlab.com/gitlab-org/gitlab/-/commit/b2877d1427a01744ece44e05f83da8e7b3423844) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209372))
- [Remove the streamlined_first_product_experience FF](https://gitlab.com/gitlab-org/gitlab/-/commit/f561b6b22d5b95302dd77877a3d67456b4457beb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209520)) **GitLab Enterprise Edition**
- [Bump version of Cloud Connector](https://gitlab.com/gitlab-org/gitlab/-/commit/59922e9f173e04f0e6b3063bc7b93de2fb0b09a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209962))
- [Add chat mode switching for drawer and embedded panel](https://gitlab.com/gitlab-org/gitlab/-/commit/e6858335f9d463600a108381b84521d68c61b06a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209358)) **GitLab Enterprise Edition**
- [Clean up Credentials inventory implementation after optimizations](https://gitlab.com/gitlab-org/gitlab/-/commit/36b52d3ba512ce2c8ed21eb76a436c7deafc4d11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209392)) **GitLab Enterprise Edition**
- [Remove ff for long_pipeline_lock_ttl](https://gitlab.com/gitlab-org/gitlab/-/commit/f1bebfbd179d5e08896c3da018c06e8290c8dc7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209900))
- [Remove ff for include generated ref commits in changelog](https://gitlab.com/gitlab-org/gitlab/-/commit/45a086ee515b9b39d434cf1a3a73a2383b714a00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209896))
- [Make work_item_type_custom_lifecycles constraint more strict](https://gitlab.com/gitlab-org/gitlab/-/commit/4d2d47f35c28894e3551060a8295b3f64d7a9afa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206774))
- [Update Group SAML SSO settings page to specify SAML Identifier](https://gitlab.com/gitlab-org/gitlab/-/commit/880cd8fe233bd9afdf8a73969f50ca495c19b4f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209863)) **GitLab Enterprise Edition**
- [Add ability to filter agent session pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/f583e1a5d8fedd689caa7d6473b75dde458293ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209832))
- [Reorder wiki sidebar items](https://gitlab.com/gitlab-org/gitlab/-/commit/dffcef487e5ad9fa03dcaf352a50497dba77a6fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209264))
- [Add risk score recalculation to the vulnerabilities archival restore](https://gitlab.com/gitlab-org/gitlab/-/commit/0899e837adecfccc720d1c5b7f7509862dec55d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209812)) **GitLab Enterprise Edition**
- [Correct block traversal](https://gitlab.com/gitlab-org/gitlab/-/commit/9e00531832ab55fed2f76a8a9bca80db9fce5cc1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209706))
- [Skip LostNodeEvent when all search nodes are lost](https://gitlab.com/gitlab-org/gitlab/-/commit/c25bb53555dd39e911de98cc5ac2082030426a64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209617)) **GitLab Enterprise Edition**
- [Prevent namespace creation on enabled BSO and user limit](https://gitlab.com/gitlab-org/gitlab/-/commit/74fbdf686870a883fe375b9dc73f7ff340201301) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205896)) **GitLab Enterprise Edition**
- [Add table headers for maven virtual registries list view](https://gitlab.com/gitlab-org/gitlab/-/commit/1106c81f54ea92848db929931342ebcdc0645c58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209081))
- [Feat: Update naming of Agent Sessions to Sessions](https://gitlab.com/gitlab-org/gitlab/-/commit/86fa8168877238c914d4b3afcebf1d93cdc465d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209368)) **GitLab Enterprise Edition**
- [Refactor: Migrate MR Widget Suggest Pipeline to UserCalloutDismisser](https://gitlab.com/gitlab-org/gitlab/-/commit/ef7c8f0cc1595bed6ef8d102e5d1c2efdd29c6f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208522))
- [Update PACKAGE_MANAGERS_FROM_TRIVY_PKG_TYPE mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/f40810b7b2ff697885cf635a204b144c38cd4d8e) by @alexandre.laroche.exfo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208939))
- [Remove roles column from users table](https://gitlab.com/gitlab-org/gitlab/-/commit/b00eed5bbf612016c23dbed8ad78c5ac47169c74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201015))
- [Update video attachment styling](https://gitlab.com/gitlab-org/gitlab/-/commit/bbb236551858aa842a744780b0bf906082ba0d72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208395))
- [Bump gitlab-pages version and update related docs](https://gitlab.com/gitlab-org/gitlab/-/commit/28d3c70787adc4a87f4067d8ad5741e6216d7436) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209446))
- [Add restricted access check for SAML on Gitlab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/e349d29726ac116f0600887958f138e3b40952ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207118))
- [Add object format to repository init instructions for new repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/0824369bd78f369d36c50a7f7e4d417c3b185d2a) by @AaronDewes ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205825))
- [Show current user first in reviewers dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/6d3ca91e451afb1bc82f22b9870e53764b28d696) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209541))
- [Added project/group hooks and webhook events to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/069a130e98b3af25050c7c73f1513b5f0363b089) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205757))
- [Refactor and adjust styling on group/project list actions](https://gitlab.com/gitlab-org/gitlab/-/commit/9f635f3c49d593234b6b67913c67bfca42cf5b29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209171))
- [Fix single quotes in job log links](https://gitlab.com/gitlab-org/gitlab/-/commit/be0941f0c64d292e73a6d90e650ebae62e9da0d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209490))
- [Fix SBOM ingestion race condition](https://gitlab.com/gitlab-org/gitlab/-/commit/31882a5181646eef76fdd57fa1c0423a7146974f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209123)) **GitLab Enterprise Edition**
- [Remove feature flag when reading from detached table for Composer API](https://gitlab.com/gitlab-org/gitlab/-/commit/03fa42594152254ea2694a1e7b2b8ef1dbe84f2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209467))
- [Add `publish_review` param to approve API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/fe2c6538f7ce60b8ec5f77d31775d6fc28c1e320) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208487))
- [Add risk score  population to the Vulnerabilities ES reference class](https://gitlab.com/gitlab-org/gitlab/-/commit/bc6ff17600fc118184ae4321f5e18cc387e485c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207585)) **GitLab Enterprise Edition**
- [Adds ExactlyOnePresentValidator class and tests](https://gitlab.com/gitlab-org/gitlab/-/commit/40a40821f10f1316d4bbddeb628c5379427bc82f) by @jotolo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208350))
- [Fix markdown vuln in agent sessions for .com](https://gitlab.com/gitlab-org/gitlab/-/commit/1084334c5313aa088914176f30675e24aa389907) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209322)) **GitLab Enterprise Edition**
- [Update secure files docs with updated glab CLI commands](https://gitlab.com/gitlab-org/gitlab/-/commit/ba32dffd4489b5d318490f9841e155f9a44f97c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209009))
- [Add secrets_manager_scope claim for SecrtsMgr Auth](https://gitlab.com/gitlab-org/gitlab/-/commit/e0b26948621dbd4f8598276b58cbd8bd570c9811) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208766)) **GitLab Enterprise Edition**
- [Finalize BackfillRolledUpWeightForWorkItems migration](https://gitlab.com/gitlab-org/gitlab/-/commit/cf65786f30bd2038dee4f896a9e5ddbfa51f173a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207459))
- [Adjust legacy onboarding experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/0e76fbbb9cb83844626617451dedeefd338e53b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209175)) **GitLab Enterprise Edition**
- [Remove project count limit for zoekt indexing](https://gitlab.com/gitlab-org/gitlab/-/commit/8f14d7ffd0f6c0bf831a483c831fcb8fb5e636b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205137)) **GitLab Enterprise Edition**
- [Add include_projects query parameter to GET /api/v4/runners/:id](https://gitlab.com/gitlab-org/gitlab/-/commit/c039d8faed72b9148f235e484625f2bc7d900c0c) by @adirn26 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208298))
- [Move wiki sidebar to the left](https://gitlab.com/gitlab-org/gitlab/-/commit/15dda48db41b079fe13dd7ded7aaabe14ddf9347) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207262))
- [Feat: Make agent session details clickable](https://gitlab.com/gitlab-org/gitlab/-/commit/79ab5c3f90c5517dc52d7954d12c02e92c5ad551) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208707)) **GitLab Enterprise Edition**
- [Add methods for isolation status to Namespace and Organization models](https://gitlab.com/gitlab-org/gitlab/-/commit/916edd56789c80779168046e7bd505b4dac1df7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208320))
- [Update vulnerability and counts on group archived](https://gitlab.com/gitlab-org/gitlab/-/commit/41c92cadd975cb982a969b4c1512a57413ad5b87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208313)) **GitLab Enterprise Edition**
- [Default OAuth scope to `mcp` for dynamic client registration](https://gitlab.com/gitlab-org/gitlab/-/commit/eb0844930f153182b9f4189fe0cd6cba569b5e3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208967))
- [Ensure Statuses::Finder returns array types](https://gitlab.com/gitlab-org/gitlab/-/commit/4c250f31ee066f6210116066db31a2a8dde7cbbd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208906)) **GitLab Enterprise Edition**
- [Update gitlab-secret_detection gem to 0.36.0](https://gitlab.com/gitlab-org/gitlab/-/commit/6f366fc1cc63a64194fa58e77dd23c6a69eb487f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208618))
- [Rename duo workflow events graphql fields](https://gitlab.com/gitlab-org/gitlab/-/commit/4fe06f4745661719a9e83171846b1ed88277fb32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208852)) **GitLab Enterprise Edition**
- [Move ExternalIssueReferenceFilter to post-processing](https://gitlab.com/gitlab-org/gitlab/-/commit/e50b915475414734a70b9848236bb4d99c23b159) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208028))
- [Follow-up changes to 2FA enablement and disablement](https://gitlab.com/gitlab-org/gitlab/-/commit/7deb8f43c5eff39dbb6ebad018f7ac05c913bb15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208401))
- [Fix query for finding existing Jira issues for vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/d23916081f2e06070916c7eea71ae3c909471a94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209061)) **GitLab Enterprise Edition**
- [Account for enforced policies in policy approval setting overrides](https://gitlab.com/gitlab-org/gitlab/-/commit/e21e68726495dfeea3005490c886fd41ddf060f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208764)) **GitLab Enterprise Edition**
- [Document that feature flag is disabled by default](https://gitlab.com/gitlab-org/gitlab/-/commit/faf9006ed6135c66f01bce3f04e15e5b4443cf93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209021))
- [Remove template_labels_scoped_by_org feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dc75309ee8c906f984e663cb51698072537b7ff8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209000))
- [Remove ignore column from gpg signature model](https://gitlab.com/gitlab-org/gitlab/-/commit/508456a53c3f5567b7b7b2d4b859e7688343e374) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208958))
- [Change uniqueness validation for vregs container cache entries](https://gitlab.com/gitlab-org/gitlab/-/commit/c965e566d4f16425e13dd7430fc969373c2a91b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208637)) **GitLab Enterprise Edition**
- [Update policy bot comment for warn mode `any_merge_request` rules](https://gitlab.com/gitlab-org/gitlab/-/commit/82df2386e1326ba8239388122f8b3c4c448a87b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208624)) **GitLab Enterprise Edition**
- [Remove author_email ignore column from ssh_signature model](https://gitlab.com/gitlab-org/gitlab/-/commit/e2797940ca116e490ddde3fb7313971b1b7101a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208956))
- [Update policy bot comment for warn mode `scan_finding` violations](https://gitlab.com/gitlab-org/gitlab/-/commit/5a1da7928164f4c467ad61b1520d07f58d56b89d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208346)) **GitLab Enterprise Edition**
- [Remove feature flag for conan packages duplicates cleanup policy](https://gitlab.com/gitlab-org/gitlab/-/commit/89fb011ddb720a68136d3920b133e49f1a8daa69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208919))
- [Make policy push checks respect warn mode policies](https://gitlab.com/gitlab-org/gitlab/-/commit/4650cd8ef3708dbd32791101d3e90aeef4e4c868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208129)) **GitLab Enterprise Edition**
- [Allow use of `**` emphasis with Chinese/Japanese/Korean text in Markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/5f5587a539e6f1befd604873db95f0c884df4d19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208734))
- [Add tracking to work item CRUD component collapse/expand actions](https://gitlab.com/gitlab-org/gitlab/-/commit/2fa8903c585c7ee72c85fc5f924135c18309db52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203002))
- [Update group empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/9c2e93818038627bf0821564b8a3a1f2b8808e84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208519))
- [Security attributes - disable feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/db859c237b8bf0421a9b9abbd1c29a52dd477b08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208823))
- [Document discrepancies between security widget and bot comment](https://gitlab.com/gitlab-org/gitlab/-/commit/33d0fad1856b8c1a1014fbb1be182ff0db2497a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208499))
- [Update wording for prefill PEP variables](https://gitlab.com/gitlab-org/gitlab/-/commit/2632ef50e16e5bb3b53cbb8c0de9f9aef8288333) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208629))
- [Release check allowed visbility for user namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/db278d0541f5491a285617eb69d61fb535d59380) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208808))
- [Update project and token used in test CI](https://gitlab.com/gitlab-org/gitlab/-/commit/d06622ef0ca1c1d0ed808a55f769f1f1d5dee8af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208349))
- [Remove FlushStaleCounterIncrementsWorker jobs from queue](https://gitlab.com/gitlab-org/gitlab/-/commit/52378e9fd55de223d012397314412e8152c784bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200993))
- [Update unique index i_duo_workflows_events_on_correlation_id for cells](https://gitlab.com/gitlab-org/gitlab/-/commit/12c60603de4413ddc6b9c70ee624bbcea34fecd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208594))
- [Refactor code for UpdateAiDetectionService](https://gitlab.com/gitlab-org/gitlab/-/commit/3c7c19608c95318978041ad1cc26d5363aca7cda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208670)) **GitLab Enterprise Edition**
- [Protected packages: Allow standalone wildcard in protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/d9ed4a6ceea448f42b214114ea3fd735e036df7d) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207280))
- [Change unique index for object_storage_key for helm metadata cache](https://gitlab.com/gitlab-org/gitlab/-/commit/370b801a980db1a8ca8e884f6c57669690f2adca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208642))
- [Update premium group billing page to have Duo wording](https://gitlab.com/gitlab-org/gitlab/-/commit/39351247a859a0c83a319fd242fe3ddaab82df07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208334)) **GitLab Enterprise Edition**
- [Support disabled deletion section in group/project settings](https://gitlab.com/gitlab-org/gitlab/-/commit/a7a6cdfa37ce2d4e88a3fbeb99ba121cf11dd6b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205563))
- [Update AWS SDK for Workhorse and disable AWS checksums by default](https://gitlab.com/gitlab-org/gitlab/-/commit/92279b0aa6a11c57b5b3eec2831079bb8f2daceb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208573))
- [Check granular permission for admin users](https://gitlab.com/gitlab-org/gitlab/-/commit/6acc883660c48ba07c514e934232d65f1c1f6970) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208231))
- [Cleanup feature flag additional_oidc_discovery_claims](https://gitlab.com/gitlab-org/gitlab/-/commit/bbd467e35337c4c4a3c1ea52bc040b53a64ea2b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208446))
- [Update dependency auto-deploy-image to v2.133.0](https://gitlab.com/gitlab-org/gitlab/-/commit/aad7cce2f9048ddf0bd114b6cb4902d8bd8d8f00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208419))
- [Add restricted access check for SCIM on Gitlab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/f13c3f655f624aad2dafb9054b40a2524ce167e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206932))
- [Add tooltip for anchor button if CI/CD is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/d48528122613f3b0c1908eefe34b2f5a5d1af3d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208139))

### Removed (35 changes)

- [Remove installable_only argument in GroupPackagesFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/71b3e234b84f6eb636880ea6c964862798cad80b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212605))
- [Remove unneeded index with org id from ci_runner_machines](https://gitlab.com/gitlab-org/gitlab/-/commit/ba7a00bc9517076a03338976c332a0dab0597fa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212232))
- [Remove unused system_access_instance_microsoft_applications tables](https://gitlab.com/gitlab-org/gitlab/-/commit/20e1598bcee96541825f9dfc4cd5911e703fc2e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206058))
- [Remove `work_items_alpha` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3cdf9b8b95b9369d5c8526d01de4800b570e3ab4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210999)) **GitLab Enterprise Edition**
- [Remove x509 records with NULL project_id before adding constraints](https://gitlab.com/gitlab-org/gitlab/-/commit/7c5c4fc1d50bbfbf0e4b8e5134217bfcb1526ee0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210875))
- [Delete oauth_dynamic_client_registration ff](https://gitlab.com/gitlab-org/gitlab/-/commit/5aaa07b3bd5dae928902724ea091f072f67d0ca4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211418))
- [Remove work_item_status_mvc2 feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e48d23925e4e5a1f0d1ed92c5d07cfb26e699d68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210642))
- [Remove `consolidate_mr_analytics_in_shared_dashboards` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/86477a2c9822ccde3218f15dc6e996a35ca0a2bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210775)) **GitLab Enterprise Edition**
- [Cleanup gitea_user_mapping feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/39629da444834e3c81ac61b8c7945704ec204a95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211143))
- [Remove the mcp_server feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e9f1b46a3b73fbf25260b80af6a5f07461af7ade) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211200))
- [Remove `work_items_beta`  feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fd4b63cee1f1887269453607470ad490614c4a0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210444))
- [Delete the `search_project_confidentiality_use_traversal_ids` feature fl](https://gitlab.com/gitlab-org/gitlab/-/commit/e9cca13936f615c80ce1596ff0e4c0ee552b5f08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210561))
- [Delete the `search_group_confidentiality_use_traversal_ids` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b0195bab3efc6dc197b59b0b36c8b88293c63b9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210563))
- [Drop foreign key on security_trainings.provider_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b869b5865770de2a820785907a6b812da0e4265d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209949))
- [Remove personal_access_tokens indexes added by MR 193375](https://gitlab.com/gitlab-org/gitlab/-/commit/af8331f0d9c17650875261df0850f6d21bc7bffd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209471))
- [Remove project_dependencies_graphql FF](https://gitlab.com/gitlab-org/gitlab/-/commit/4f470a8b04e84c8c7c62b23a211e24e9fbdd50e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206379)) **GitLab Enterprise Edition**
- [Remove unused GraphQL endpoint and ff](https://gitlab.com/gitlab-org/gitlab/-/commit/e64249936fe996c56fa3bf4001818944dc7918e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209014))
- [Remove GraphQL mutation to create Abuse Report Note](https://gitlab.com/gitlab-org/gitlab/-/commit/b73a99cfae94881d6e54f3647ee5a2b83c20c2b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209538))
- [Removes the temporary code and tests validating the new fields setup](https://gitlab.com/gitlab-org/gitlab/-/commit/4cf3d6735b8ccc8e3baa7a59a083e31e292c2c09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209102))
- [Clean up FF deprecate_approver_and_approver_group](https://gitlab.com/gitlab-org/gitlab/-/commit/4c54ec0ee0a330d7d41802bed4a846520f2cd771) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209727))
- [Delete the `search_work_item_queries_notes` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5c31875fcdfa5ee6116c7941748ca72db0da25e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209347))
- [Drop namespace_deletion_schedules table](https://gitlab.com/gitlab-org/gitlab/-/commit/59ab07b022fde1f393aab872097847f8a747e411) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209010))
- [Delete the `search_notes_use_membership_filter` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/71cabf9c116f36b11d7b2181d3bda2d0e98f6e53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209341))
- [Delete code from finalized BBM to backfill software license](https://gitlab.com/gitlab-org/gitlab/-/commit/935a9a0ecfe5972312c69637518ed646299258e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207690))
- [Remove product analytics usage GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/cd199c5292b3246085e7c0331c9f9baa208ac9f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208748)) **GitLab Enterprise Edition**
- [Remove backend code gated by `abuse_report_labels`](https://gitlab.com/gitlab-org/gitlab/-/commit/b7f15a90acc7b33979d7f2d50abbf468ce60ba99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205292))
- [Remove log_refresh_token_hash feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d0a47b6b95d691d6e801e3f340049ac2dd123bdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208855))
- [Remove support for license name](https://gitlab.com/gitlab-org/gitlab/-/commit/4594f6b194a42832fdf705ee4dfcc09fa21d86f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207757))
- [Revert "Introduce admin_runners flag"](https://gitlab.com/gitlab-org/gitlab/-/commit/1cdcaa80fe27dab2f0a9fdd73e292fbcfe782b47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208816))
- [Delete work_item_childer_iteration_change FF](https://gitlab.com/gitlab-org/gitlab/-/commit/4e92a2dbaa2f6e217c9bbd929afe2e6e78373877) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208621))
- [Drop temporary bigint indexes from merge_request_diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/2568b0737502ff0eefac4081b5b2a3a60b827f18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208569))
- [FF cleanup for ci_validate_config_options](https://gitlab.com/gitlab-org/gitlab/-/commit/4dfbb80d411b3c4537182dede22bd3a12339dd4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208503))
- [Delete the `search_scroll_api_increase_throughput` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/25eec9faa460efaa07057f5824b9e35cc14146bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208181))
- [removal: FF covered_experience_create_merge_request](https://gitlab.com/gitlab-org/gitlab/-/commit/dec6939273be0e5557c8f7dd279b6d1663674760) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208354))
- [Remove product_analytics_usage_quota_annual_data feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/11eb6ecc59d639e564539d9014adc32f8c1b5c73) by @official.harshith1 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207918))

### Security (17 changes)

- [Prevent Duo Chat from reading confidential resources](https://gitlab.com/gitlab-org/gitlab/-/commit/4441179483ccfc238681b49418a524d53dbe60f6)
- [Encode protected branch names in API requests](https://gitlab.com/gitlab-org/gitlab/-/commit/205d7dcc7027e80a0e6796a673884f77792199ef)
- [Hide related branches when repository is private](https://gitlab.com/gitlab-org/gitlab/-/commit/922a6e081456b26052b9d7330fb1f758356ff454)
- [Security fix package api pipeline details](https://gitlab.com/gitlab-org/gitlab/-/commit/4acfdd18c5aa05939a2930f65e67bc87ac3d59d3)
- [Update KAS version](https://gitlab.com/gitlab-org/gitlab/-/commit/9d9d9654895191241ad6ae6ae5fddfde3df0a456)
- [Fix unauth workflow deletion by service accounts](https://gitlab.com/gitlab-org/gitlab/-/commit/8606ef4c9136ef72ec305bc8a2e0b8439b26c462)
- [Update to gitlab-glfm-markdown 0.0.38](https://gitlab.com/gitlab-org/gitlab/-/commit/362b9b665401e4f2bbeb1713c5b9eb41c96cc925)
- [Prevent GraphQL subscriptions from blocked users](https://gitlab.com/gitlab-org/gitlab/-/commit/9efdb7d28f7a3718367babbe91f8a0c6cc193e8a)
- [Group enforced pages access control should restrict non-members](https://gitlab.com/gitlab-org/gitlab/-/commit/5d13c253d59e9777ec8b182cf13e28494bf3cdad)
- [Add docs for smartcard hardening recommendations](https://gitlab.com/gitlab-org/gitlab/-/commit/7b3b79adbe0d20bdc1bb2ff55cb7a17d708e8c0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210798))
- [Track pull mirror updates using gitaly_context](https://gitlab.com/gitlab-org/gitlab/-/commit/aa119ee4549f3cffdda61ae795f4a79e1aab2c49)
- [Reject quick actions for ai_workflows scope](https://gitlab.com/gitlab-org/gitlab/-/commit/e3400bb1e2194c379d4ac443278c4c3157b9049c)
- [Limit depth, size and total elements when parsing JSON string](https://gitlab.com/gitlab-org/gitlab/-/commit/0b5604a74932d01fb9f7e421a57872825916ff07)
- [Limit JSON request payload for /-/collect_events](https://gitlab.com/gitlab-org/gitlab/-/commit/857eb101355e6659adfb53888fb43d9d2fea87df)
- [Non-group members can be added to projects even though the "Users cannot be...](https://gitlab.com/gitlab-org/gitlab/-/commit/d08571b691ada69d91807e2a8ec0b371bff267ad)
- [Ensure NPM upload cannot exceed plan limit](https://gitlab.com/gitlab-org/gitlab/-/commit/5a2d5c3e846a39e1890c59e3d15c528b89e2a2a1)
- [Use CE policy for runner ability check](https://gitlab.com/gitlab-org/gitlab/-/commit/4c985e24e4fbf1fe26030d5e30955e20ae1ce83c)

### Performance (9 changes)

- [Optimize permission checks in CI build policies by removing jailbreak](https://gitlab.com/gitlab-org/gitlab/-/commit/6ba49b67c65e3f3eb18d716ab3e950e14d3c9af4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210691))
- [Modify to a DatabaseMetric for performance improvement](https://gitlab.com/gitlab-org/gitlab/-/commit/0d0fb3839786e40f61bf6fe6a91a2893cd923c36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210013))
- [Add post-deployment migration to update partitioning threshold to 500GB](https://gitlab.com/gitlab-org/gitlab/-/commit/84f086d3dc217284507a34ca5f217c194c84ab50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211114))
- [Cache results of HasUserType#redacted_name in RequestStore](https://gitlab.com/gitlab-org/gitlab/-/commit/33ceb79787806c7a7b31959cd6d6c5030db5f0d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210765))
- [Reduce cached SQL queries in `/api/v4/internal/pages` endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/5c11c9eeae8dd7e2807b9ba2ed7b0352793ce793) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209885))
- [Apply content visibility within a large diff in Rapid Diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/708359ad6e805f881879ac25416c07855990ffd9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209497))
- [Enable and remove FF disable_ci_partition_pruning](https://gitlab.com/gitlab-org/gitlab/-/commit/3ffeee1d8fac91ab1534abb41d355610e0dee85b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209440))
- [Improve pipeline creation performance by caching stages attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/ab692e7143e05ed47dbc26afc086daf69a8f01ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209316))
- [Ci::BuildNames partitions will be truncated to last 2 partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/3f3ef8db804cc302ee64dea5446440c699e80e85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208389))

### Other (212 changes)

- [Step-up auth: Extend test coverage for application controllers](https://gitlab.com/gitlab-org/gitlab/-/commit/75b4c5228740e51cb1bf9d9e96e828abb9373dbc) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209803))
- [Remove active_context_saas_initial_indexing_namespace feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/970b38119dd3684bba69107dd9c43e46b61507d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212807))
- [Replace project_daily_statistics_table with partitioins](https://gitlab.com/gitlab-org/gitlab/-/commit/e551e7e5590353062faef1c453995c6abcc9420e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211916))
- [Revert "Merge branch 'chore/add-secondary-store-for-trace-chunks-redis' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/399bac0f99bf0766fae2c631a5a9a06f013123f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212723))
- [Shard abuse_report_events](https://gitlab.com/gitlab-org/gitlab/-/commit/4c0484b4a3a1f4c2c807a3a5e0c28c7e6d3ba5a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211578))
- [Remove MarkAdminBotRunnersAsHosted BBM and related code](https://gitlab.com/gitlab-org/gitlab/-/commit/2018516d2f56c23b426e3bd8429a7d107d8b7a62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207795))
- [docs: Clarify artifacts:public behavior with job tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/cd29b30606cf74d750dd473c71707467ce72de21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212274))
- [Create PORO classes for MR approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/eddac50364e8adb7c3402d5c80dfce595f4777d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209363)) **GitLab Enterprise Edition**
- [Mark 20250528090312 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/5e0225abe3f1831f7fe271d38701fdec5249136e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209378)) **GitLab Enterprise Edition**
- [Fully shard redirect_routes](https://gitlab.com/gitlab-org/gitlab/-/commit/57b97f1ea29316fc4a8db8bed2ad12a9ee1e0330) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211260))
- [Sync translations from crowdin (2025-11-13)](https://gitlab.com/gitlab-org/gitlab/-/commit/3513df699c1b7d270ffa0648db437ed09985fa29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212582))
- [Dismiss DAP modal when in project studio](https://gitlab.com/gitlab-org/gitlab/-/commit/fc3446a265fea7a1a3d7776199231e9113632500) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212578))
- [Add constraint and validation to web_hooks and system hook](https://gitlab.com/gitlab-org/gitlab/-/commit/752ed31bd804b33946a909056ee683cb68ab31a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208747))
- [Add FF to eagerly resume jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/78e19a321fceedc62a5ac04a12d2e1d990c9cc4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212233))
- [Fetch exact counts for total risk score](https://gitlab.com/gitlab-org/gitlab/-/commit/68a40663087aa652747cf4cdc0a82b1b99ccf724) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212391)) **GitLab Enterprise Edition**
- [Filter out invalid language tags](https://gitlab.com/gitlab-org/gitlab/-/commit/d96d34997c327801d052b5fae0653b2cedc319e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210518))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/4e31153f61b927957d278afe775174d203e94e35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212360))
- [Add validation to prevent blank deployment parameters](https://gitlab.com/gitlab-org/gitlab/-/commit/048afa2983dda8284a4518230d6afc9c10818f2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211567))
- [Change policy dismissals security_findings_uuids NOT null](https://gitlab.com/gitlab-org/gitlab/-/commit/99e58248d1fe0474a9e0af9ece07b985327b400a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210279))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/331835f106306af70f4273a902376dba2b6ab360) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212033))
- [Remove invalid web hook records](https://gitlab.com/gitlab-org/gitlab/-/commit/3d43920db23afad6c664f9a043a13550318e3c92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211666))
- [Quarantine spec until we fix it for Project Studio](https://gitlab.com/gitlab-org/gitlab/-/commit/43560a99e1f89e84e7a69c87d67694fd50c1c70b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212268))
- [Finalize OAuth Access Tokens and Grants BBMs](https://gitlab.com/gitlab-org/gitlab/-/commit/c09e3c9bc1847d81b7368e98d14031699168f684) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211207))
- [Finalize authentication events BBM](https://gitlab.com/gitlab-org/gitlab/-/commit/f97822e5bb3e3d4e01a1c4e1ac3c061200d59ee8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210795))
- [Add database index](https://gitlab.com/gitlab-org/gitlab/-/commit/02a37dcf1ecac9fe6ad57a23907db1e55f7d2e91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211048))
- [Delete orphaned clusters and add sharding key not null constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/b3f689a998abed76d37df7e2eac5a5556aa90976) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207166))
- [Dismiss DAP welcome banner when new UI is enabled in rspecs](https://gitlab.com/gitlab-org/gitlab/-/commit/72f771772c2b8709b5f3ac8b2fda7b21d700932d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212110))
- [Dedicated LFK Cleanup worker for CI Pipelines and Builds](https://gitlab.com/gitlab-org/gitlab/-/commit/c8b57bff293e296a5d03408ce66e49e74d72e992) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211395))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/4e89649c34ac37ef391b4a88efdea755bde4f86c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212075))
- [Create background migration to backfill job definitions](https://gitlab.com/gitlab-org/gitlab/-/commit/fa706e30715ea212e6574022cda8e9e919f06a4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208674))
- [Remove concurrency_limit_current_limit_from_redis FF](https://gitlab.com/gitlab-org/gitlab/-/commit/cf81e34c7147fbfe77e4f7d3b6f1725571adda78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211804))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1994dcdb8972222a5a68ee9f8ca225175bb7f636) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212006))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/b8a1db92aa79418dad6ed17bacbbcfda4f9bd0c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212007))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/738ac9de52b9883e9d46a3cd1643bacfcda348a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212009))
- [Update database migration guidelines for dropping tables](https://gitlab.com/gitlab-org/gitlab/-/commit/b97cccaf516c94776113668ba9519b8012f701e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211914))
- [Remove sidekiq_concurrency_limit_middleware_v2 feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ef0ce3ae79c95e89481c172542e5b4c90a6b2672) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211285))
- [Active Context: Add migrations to update Code collection partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/b580e2a8a120ef64e14282aca66006aae713d2b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211082)) **GitLab Enterprise Edition**
- [Finalize BBM RecalculateTwoFactorEnforcementOnUsers](https://gitlab.com/gitlab-org/gitlab/-/commit/e3de6b8210c5a373ce9eb06573e224eed8da9c33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211333))
- [Final steps on notes table sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/38174659eb325c2df1981de99c076425cff15c82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211834))
- [Remove use_max_concurrency_limit_percentage_as_default_limit FF](https://gitlab.com/gitlab-org/gitlab/-/commit/d1c7836cc03cbce5054b9434acdd8a1b694fc1b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211775))
- [Set value for diff_note_positions.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b19f098c01745f6b618c1ac8cbe4ced37634f46a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210117))
- [Initialize conversion of issue_metrics id to bigint](https://gitlab.com/gitlab-org/gitlab/-/commit/6b352618a23714b68d690ed1c99cd5a71db41d19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210896))
- [Sync translations from crowdin (2025-11-06)](https://gitlab.com/gitlab-org/gitlab/-/commit/8cb7cc63c9860e60163ba9345bf700f41151d44e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211748))
- [Fix flaky test ee/spec/requests/api/graphql/ai/catalog/item_spec.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/8e133a9648da6cfceafa35ac3194de85868ddbd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211697))
- [Add NOT NULL constraint for `project_id` in x509 tables](https://gitlab.com/gitlab-org/gitlab/-/commit/04ec3b835291cb6171549602fe98721da22e9f92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207072))
- [Active Context: Remove code repository records](https://gitlab.com/gitlab-org/gitlab/-/commit/0ad1f5b6466457757fe3770898ce1bf7f771eb52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211049))
- [Fully shard push_event_payloads](https://gitlab.com/gitlab-org/gitlab/-/commit/dad4b0b7b1178b1121668b55b30a7d231256e54e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211254))
- [Backfill sharding key on note_diff_files table](https://gitlab.com/gitlab-org/gitlab/-/commit/894eee36ed10dc69206baffedcec82e3f5748510) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210110))
- [Add active ultimate trial upgrade link for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/e7f4b621a85c8081ef19abce286e0e4d210cada7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211240)) **GitLab Enterprise Edition**
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/af5e2e9d5e6353361995beeb53ca93945a033588) by @gnautTheSaturnian ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208174))
- [Shard abuse_uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/7f66b1e37062fa7598aa7d520b7a0e4ac38dda39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210550))
- [Backfill sharding key to service hook type web hooks](https://gitlab.com/gitlab-org/gitlab/-/commit/1d69d181f8e1bc8346fa806380d3768b50c3b0aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210621))
- [Fix instance bbm for mishandled nil verification token](https://gitlab.com/gitlab-org/gitlab/-/commit/7715eaf3e9ee194a1e692b0fe5af1134d28e8a9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210375)) **GitLab Enterprise Edition**
- [Enable partition pruning for token queries](https://gitlab.com/gitlab-org/gitlab/-/commit/f2235bcb6863e3c42f21c8f27a41bead18d4577e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211425))
- [Fully shard todos](https://gitlab.com/gitlab-org/gitlab/-/commit/9c65e1f6f3fd98455c8ee13f57c06bc4ceeba1b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211275))
- [Add missing aria-label attribute](https://gitlab.com/gitlab-org/gitlab/-/commit/73742bc401770ec8d2a22785fc7e99184cf0af06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210268))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4f7751d7ef1b5a65ddae834c79c1d3df0653fe7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211351))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/0049558e4633494228fcdc426fd5a42c6b0d85a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211349))
- [Finalize bulk import config cleanup migration](https://gitlab.com/gitlab-org/gitlab/-/commit/d4acdfb5b5a479101269eb6badfd8ab3bcee8ce6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210977))
- [Prepare identities table to be fully sharded](https://gitlab.com/gitlab-org/gitlab/-/commit/6ca3bfc8fe1867b0e3a9f56ca8f97375a4c9f6ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209796))
- [Ensure suggestions sharding key is set at the application level](https://gitlab.com/gitlab-org/gitlab/-/commit/2e622a9ea896b3880fea75764a43132f47d3991e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210092))
- [Fully shard protected_branch_access_levels](https://gitlab.com/gitlab-org/gitlab/-/commit/6b7269b9e658fdf59ab952fe497f8d21f8c2ec43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211271))
- [Fully shard merge_request_cleanup_schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/11d94416c41b00ab734ddc2680accf396b75ee42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211266))
- [Delete issues_list_create_modal feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/12c65e34367804fc0f2c1cbdde3131f4988583f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211070))
- [Fully shard bulk_import_trackers](https://gitlab.com/gitlab-org/gitlab/-/commit/644ef4d97068cbb11c4bdca987f5b18d9ddda84b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211249))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/05eef62ed82c6663d66b0cad17095286669fb3ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211231))
- [api: Add organization field validation tests](https://gitlab.com/gitlab-org/gitlab/-/commit/8372bd0dc3fe56ca82015c477e10a61330becef1) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208940))
- [Use Project Studio UI based on cookie value for logged out users](https://gitlab.com/gitlab-org/gitlab/-/commit/ae59cf95db32bb748dc174d409f2091b52567a0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210847))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/3478959b804e6018996a2840801442326412c4ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202501))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6dd905d9111e5871af49afaa2dfdfcf002de3355) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210211))
- [Each LFK Parent record should be processed by one worker only](https://gitlab.com/gitlab-org/gitlab/-/commit/38bab001ef50e05bff03d5131e12da6792fbd6c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211113))
- [Add ultimate trial link to user menu on gitlab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/528c374d83a53d3456e1fe0aae0781b1d4073cf9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210790)) **GitLab Enterprise Edition**
- [Add explicit logging for CI include component fetching](https://gitlab.com/gitlab-org/gitlab/-/commit/6f3e6590ca8953d2067d976907dd6286532bb671) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/211026))
- [Finalize BBM for project_daily_statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/70281f62cdf1dc7e7f787841d50ef2115e2e9aa1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210631))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/d43c6d7e109f6318a76b1a6b61795aa43f143bd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210431))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1892ec7bf2ea3370654fa2bafa418445c2aeb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210636))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8b26c3a1c2f77b90af0827235dd684e74c5c01dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210635))
- [Prepare to fully shard todos](https://gitlab.com/gitlab-org/gitlab/-/commit/97ca3e6552b629a32c51d176dfa66da032787774) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209494))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/2f0d57822e88eeef20631ef8a1ced7deaacd371d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208634))
- [Remove the FF elastic_group_archived_event](https://gitlab.com/gitlab-org/gitlab/-/commit/d4aed9cdb78806c536cd19eab0bcf8bf87630176) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210877)) **GitLab Enterprise Edition**
- [Backfill missing namespace_details from namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/c12199483c9fb7919d7795b6da8008202b4f7477) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210305))
- [Add rate limit info to web hook troubleshooting](https://gitlab.com/gitlab-org/gitlab/-/commit/92bff013c38ca8fbebf5e910a3fce1ac445c88e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210800))
- [Add security finders to rubocop exclusions](https://gitlab.com/gitlab-org/gitlab/-/commit/ce2c37e687cb5ad0b89b070be51c71a232663b60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210838)) **GitLab Enterprise Edition**
- [Fix super sidebar selector & adapt rspecs for project studio](https://gitlab.com/gitlab-org/gitlab/-/commit/4f5d9a67c8cc1be24bc1f600fdfe0344656af9cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210825))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/580e105b197f8aaddd48e15db7d24d7f5330de0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210638))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/fa7ac0bd08d165a7ba453a55d5f68e758a84e63b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210633))
- [Schedule backfill of system_note_metadata.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/f4c447ca15af3450ce71377de746067166b8fe50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209714))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/55e692f839dbf081da4a85baa80839870b30d0f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199512))
- [Fix spec failure when Project Studio is enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/5a9bce55b8dab247bacf2183720fdecd385c2382) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210666))
- [Add self managed trial widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ba50fda9506d1f96bcff9ec08a64fe3165da0442) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209831)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/9a6b6de719a67c9ddb357883650d99d943e57259) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210634))
- [Remove vulnerability_finding_risk_score feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b74fb638afe8c9a5ad56e09aff10226f21a34f2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210686)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint on ci_runner_taggings.tag_name](https://gitlab.com/gitlab-org/gitlab/-/commit/6ab2355f76311ea538b092bd3aa7e1e2aa6efe29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208165))
- [Finalize BBM BackfillUserGroupMemberRoles](https://gitlab.com/gitlab-org/gitlab/-/commit/36e25ea134067e263caaf8e62ae1b9892c69352b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209722))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/7df44959a3ac07b7c8758b24d6d6e679a92ac84e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210433))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f6c1239f8e4e3d9c404f0bad71bd16bcfa694ee9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210432))
- [Change sharding_key docs location](https://gitlab.com/gitlab-org/gitlab/-/commit/d8b8f01567ed28f0b72d9b4bfd135306337007e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209689))
- [Finalize BBM BackfillX509TablesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/041d58f7306d36238480557fc076f169af2c2291) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207068))
- [Add sharding key to service hook](https://gitlab.com/gitlab-org/gitlab/-/commit/4dd1ac2623fdb631e32f705712bbb398cdd45d3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210184))
- [Fix spec failure when Project Studio is enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/10e18c0c2f75b834bc9aca1a817a7c632334bc4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210342))
- [Sync translations from crowdin (2025-10-28)](https://gitlab.com/gitlab-org/gitlab/-/commit/bfc1571d7cfdbbeadf7ddbe7bd6225c89f6f6090) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210480))
- [Delete issues_list_drawer and epics_list_drawer feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/14550ed156e2f0594242c85c107991575edbdd5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209768))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/9e28122c09515e763f6e72ad2259d96147be6ed6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210204))
- [Finalize BBM MarkPackagesHelmMetadataCachesPendingDestruction](https://gitlab.com/gitlab-org/gitlab/-/commit/97039d32af0524bebe2e51ce6db7f90f8a454816) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210201))
- [Active Context: Add AdHocIndexingWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/58170b37fb80517f5e99089974fc25639dc6d9be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209647)) **GitLab Enterprise Edition**
- [Remove committer_email feature flag checks](https://gitlab.com/gitlab-org/gitlab/-/commit/8a2dc902c240938b08f6fa5ff2983618190cd053) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210389))
- [Add feature categories to groups controller specs](https://gitlab.com/gitlab-org/gitlab/-/commit/96d0ecf2fffea8271bf4c560f5a116bbfc15a6bb) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208653))
- [Skip color-contrast rule](https://gitlab.com/gitlab-org/gitlab/-/commit/d3c878085d29e68c8873af6a4753ef90cf502cc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210294))
- [Run test-storybook on setup changes](https://gitlab.com/gitlab-org/gitlab/-/commit/77bfe5a3738d494264eb7a51feb4bd10e41aa49b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210287))
- [Add missing props in the story and docs](https://gitlab.com/gitlab-org/gitlab/-/commit/126587a5c3e98e8823369f6092039892dd128fc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210281))
- [Update page scroll helpers to work with Paneled View](https://gitlab.com/gitlab-org/gitlab/-/commit/67ef03d0cde6cb0377619c8cdbcc15093b35bbf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210075))
- [Validate check_organization_id_nullness constraint checks](https://gitlab.com/gitlab-org/gitlab/-/commit/dadc26c7834f1c4d626597e33b22bcfee962b3e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207894))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/64fe0fe9e9eda852ac321e0b48100b9377bb7f15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210213))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f8df80a4091443383d10b3c44e0aa07c359d0ccc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210212))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/96bff4f7dbf5fb0da19a44a59800fe4320ddde81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210231))
- [Finalize BBM ResetDuoRemoteFlowsEnabledFalseValues](https://gitlab.com/gitlab-org/gitlab/-/commit/be92c8d716008167b7ee63f481363dde5a8aaee8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210202))
- [Finalize BBM FixOutOfRangeEpicDates](https://gitlab.com/gitlab-org/gitlab/-/commit/7335c6630c9ae1e16ed69decb26f9f5262547baa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210200))
- [Finalize BackfillTagNameOnCiRunnerTaggings migration](https://gitlab.com/gitlab-org/gitlab/-/commit/cef9eb3ceeeb4147f3d09384e216f2854997bde7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207897))
- [Add premium discover page for ultimate trials to self managed](https://gitlab.com/gitlab-org/gitlab/-/commit/862ea06bbcf992d6b51c9339d71d4860a26036fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208863)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1b1376d4a867dc1be5f435e47bd602150278c460) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210138))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/b8dda4d967679118acdf53cfdaa56d86b6911a15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210135))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/5ad622f2a9c85bcd02c9c7e41cb60ae56bb71154) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210131))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/27ed52a82d5ff2dc723ba6324dd99c699b27a481) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210128))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/d396f845b0b5a2cb22b1507364e21ebe056535dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210125))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/63d10bbdf689e2f150ebad0cbf883a44149385cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210124))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/9e5ccc3c91956e34da173c7173bedbece639d6eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208411))
- [Finalize BBM BackfillAnalyzerProjectStatusesFromProjectSecuritySettings](https://gitlab.com/gitlab-org/gitlab/-/commit/cf4b4e3e822126f4b9707270c3b4eea52aaba7d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205141))
- [Migrate abuse_report_uploads to gitlab_main_org schema](https://gitlab.com/gitlab-org/gitlab/-/commit/3767790d6dad12387213c6af72f2ccc5dcc9d7f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208899))
- [Backfill namespace_details from namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/465d16c43b6e7a03ca0d2ca5c52ed34578effb64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209801))
- [Remove async_pipeline_creation_on_push feature flag tests](https://gitlab.com/gitlab-org/gitlab/-/commit/fad2bf649b2cf2f5e9fd9ef553f08945279396cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210001))
- [Mark 20250702131958 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/c3685127f69654c0eb31f0d9ab5c99b8b34d94f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209384)) **GitLab Enterprise Edition**
- [Mark 20250606204649 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/34b1bb2383aea14e7aab270020bb031492008375) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209381)) **GitLab Enterprise Edition**
- [Add diff_note_positions sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/e4e7489862dcb94bb8d249f177742178e3337219) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207822))
- [Fully shard ci_build_needs](https://gitlab.com/gitlab-org/gitlab/-/commit/94ce16f409dde24c7f04d057fe2ccee825c44e11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208173))
- [Add NOT NULL (NOT VALID) constraint on appearance_uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/4b8ed5bf680a2f498db519bf472e710cc58fac28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209290))
- [Finalize BBM BackfillSecurityInventoryFilters](https://gitlab.com/gitlab-org/gitlab/-/commit/1013871564ff9ee16fa65c5ac4d3479d2524ab42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209053))
- [Finalize BBM BackfillUserGroupMemberRolesForGroupLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/ff693a37fb388d58355ae7c8fdd693cb470d1a90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209867))
- [Post review follow-up for preload_latest_diff_commit tests](https://gitlab.com/gitlab-org/gitlab/-/commit/b0141b42f850cbd6079e205be1227d1ff94284d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209064))
- [Remove tmp index on events target_type for projects](https://gitlab.com/gitlab-org/gitlab/-/commit/0a8db504ce15da0a67f7f87c12851cfe9c63880d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209664))
- [Remove `self_managed_scim_group_sync` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7a4b5228afe0ac71a1f028344b29bac5e0aecdd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209718))
- [Sync risk_score to elasticsearch](https://gitlab.com/gitlab-org/gitlab/-/commit/f742f14f06b1af15b7b3e8fbd3b58a7b8ba17926) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209304)) **GitLab Enterprise Edition**
- [Mark 20250623160142 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/39377370d08b238bb457dd104b402a7a85a6a86b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209383)) **GitLab Enterprise Edition**
- [Mark 20250522073150 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/ee96b2bb9121bdd881ea0d61c5ca3c318d97f8e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209376)) **GitLab Enterprise Edition**
- [Prepare to fully shard merge_request_cleanup_schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/b3f0748d543d59215f63d959e357eb091c2e0618) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209477))
- [Set default value for prop injections](https://gitlab.com/gitlab-org/gitlab/-/commit/858c4d8fa56d39845b76af71b32c78dae01dd89c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209780))
- [Mark 20250516124136 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/431a3838295e64fa724f647eda98a9d698413c44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209375)) **GitLab Enterprise Edition**
- [Mark 20250605120024 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/2a4be24fac6afa8ac69012cd06dc39e9440b6c55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209380)) **GitLab Enterprise Edition**
- [Remove stop_writing_builds_metadata feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/45943ac4844205b4adb8d4ebdd795f9767f059be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208324))
- [Add NOT NULL for sharding key on bulk_import_trackers](https://gitlab.com/gitlab-org/gitlab/-/commit/ed128f347aff07adaf1fe6545689a60f7bb628fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188587))
- [Migrate audit_events_instance_amazon_s3_configurations](https://gitlab.com/gitlab-org/gitlab/-/commit/4c7ae5ddd416a74a071c828747fa9f01d6e479fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208897))
- [Finalize BBM DeleteOrphanedSecurityPolicyBotUsers](https://gitlab.com/gitlab-org/gitlab/-/commit/de873a99df445da47b8eb3a12d49e8d687d0e7b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209220))
- [Finalize fix p_sent_notifications design related records BBM](https://gitlab.com/gitlab-org/gitlab/-/commit/732d05e89a229224679f100218d2a0a5bc167af5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209028))
- [Adding a test to show the need for an API type fix](https://gitlab.com/gitlab-org/gitlab/-/commit/a783ab6bc5d514284873a76e454eb902d9f8bb28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206292))
- [Add audit event streaming destination tables to repair_index](https://gitlab.com/gitlab-org/gitlab/-/commit/1b4ea51bb9ef54ef72c339f70734f15444211f22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208384))
- [Add and validate label_links sharding key constraints](https://gitlab.com/gitlab-org/gitlab/-/commit/054842c15babfbded12497316786a202f1c5515a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209553))
- [Mark 20250527100819 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/b74fb1328399d0a77ee980488f137a31624fdd63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209377)) **GitLab Enterprise Edition**
- [Finalize BBM ResetAutoDuoCodeReviewFalseValues](https://gitlab.com/gitlab-org/gitlab/-/commit/8146b389cc81df87f166290c21fbacbfc12212b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209222))
- [Migrate `authentication_event_archived_records` from `gitlab_main`](https://gitlab.com/gitlab-org/gitlab/-/commit/0f60cb27dd8ef073235b674e49697407476c89bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208900))
- [Mark 20250529160735 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/d5c43fe710ad0a8b20f1a20ea7c5e87a4a162540) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209379)) **GitLab Enterprise Edition**
- [Finalize BBM BackfillGroupPushRulesFromPushRulesWithIds](https://gitlab.com/gitlab-org/gitlab/-/commit/b0a520a2bbd4a428374ad14b126e2f184d054e0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209045))
- [Add not null constraint to deploy token project_id and group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/8a36af8cd39c37af84b6bd48db4f651795e7ea4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206820))
- [Remove delete_expired_trigger_tokens FF](https://gitlab.com/gitlab-org/gitlab/-/commit/56d4383609b56560d5c0e7cfe5325f05cd96615c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208613))
- [Mark 20250611135718 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/6b3cb611f828b4a4f451baad90247bf93d56dd80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209382)) **GitLab Enterprise Edition**
- [Prepare to fully shard push_event_payloads](https://gitlab.com/gitlab-org/gitlab/-/commit/9dbea9f97556d3671f36e63998af02815c78cf9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209463))
- [Add NOT NULL to redirect_routes](https://gitlab.com/gitlab-org/gitlab/-/commit/5b4ef9d8bc04c2010fb1800478fd7c706d771ec4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197966))
- [Skip link-in-text-block rule](https://gitlab.com/gitlab-org/gitlab/-/commit/0c52ab0f71dd513e7d4051203681b468a2da6cf5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209459))
- [Add note_diff_files sync index and FK for shrding key](https://gitlab.com/gitlab-org/gitlab/-/commit/4a896823cd35adb6c05c53c7fc695f4a09a16864) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209277))
- [Fully shard badges](https://gitlab.com/gitlab-org/gitlab/-/commit/3b97da9b5c7e2534d356ab93c87ce207b6c6bf1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208328))
- [Finalize notes table sharding key backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/1a79f5fee9c25300bfe1158c022ad48a6de337b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209336))
- [Add NOT NULL constraint for notes table sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/827d25f189cff9698f100f808c5bbf0a92ea065d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209351))
- [Remove security policy bypass feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/a2942c7e8ba3e9a1ed725048405d9f21d6e0876b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208508)) **GitLab Enterprise Edition**
- [Finalize BackfillJiraTrackerDataShardingKey BBM](https://gitlab.com/gitlab-org/gitlab/-/commit/e2f5813066647216047e0f7b6356c5bf89d4a168) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207635))
- [Step-up auth: Add basic OIDC expiration validation](https://gitlab.com/gitlab-org/gitlab/-/commit/ae5b930cdef2aae2c4596275bd52231def415cdd) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200566))
- [Finalize subscriptions table sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/8686f9def626c09ae13fcd38eaa0bc321844c4ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209030))
- [Finalise BackfillDesignManagementRepositoriesProjectNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/b88f276d0a6ebd0b7322bfb044b911127bbdf563) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208589))
- [Finalize BBM BackfillClustersShardingKey](https://gitlab.com/gitlab-org/gitlab/-/commit/70edf3d19b0a999ede344d230a78076f029292be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209044))
- [Move FF from EE to CE](https://gitlab.com/gitlab-org/gitlab/-/commit/42e5683d896cf1fed50024793cf3616128e95d6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209217))
- [Ignore organization_id on system_note_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/2ac454f48dabd17c0daa43e38905a167cd86f64b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209205))
- [Add MRAP bypass_events association to user model](https://gitlab.com/gitlab-org/gitlab/-/commit/d097f70930116f7f122191ab2f9736cc9857a294) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208649)) **GitLab Enterprise Edition**
- [Add note_metadata sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/8b90d9bc852fd5d73e6305f9ba5cc98bf959d641) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208652))
- [Add last_queried_at column to code_repositories table](https://gitlab.com/gitlab-org/gitlab/-/commit/d7874208f92452d71679b863137c1a639495884c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208817))
- [Update security_policy_dismissals policy_id FK](https://gitlab.com/gitlab-org/gitlab/-/commit/8abf60c2fc8eb8c62f18a74a2e4e38be396745bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207580))
- [Final steps for resource_label_events sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/84872a2a357b83529459ee5917d6fddefbe0e7a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202311))
- [Finalize BBM BackfillPipelineSdAndCsAnalyzerProjectStatuses](https://gitlab.com/gitlab-org/gitlab/-/commit/3104b0a97b82c50e595c54343b8f6c7b6a0b0f71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203409))
- [Calculate risk scores for all findings during ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/3ca4fd3b4c1cd03f9cc049ccfdbbff8e7e993616) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208650)) **GitLab Enterprise Edition**
- [Adds resolver for FoundationalChatAgentsType](https://gitlab.com/gitlab-org/gitlab/-/commit/498154653d99a1b34803201315c17daf5c901ec4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209034)) **GitLab Enterprise Edition**
- [Finalize BBM ClearResolvedAtForNonResolvedVulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/a44d9a4dc0e36e9600f64cb6dbb24f9c091409e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209055))
- [Finalize BBM BackfillTagNameOnCiRunnerTaggings](https://gitlab.com/gitlab-org/gitlab/-/commit/809d624546054872c7b7d1aa8af548a2d68bb1c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209052))
- [Finalize BBM MigrateCiTriggersTokenToTokenEncrypted](https://gitlab.com/gitlab-org/gitlab/-/commit/d9e9f76185c6be01f349ac46c479a7739c1fa057) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209051))
- [Finalize BBM BackfillSentNotificationsAfterPartition](https://gitlab.com/gitlab-org/gitlab/-/commit/547d0590b345a7ca64562875360db369b9f8a08e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209049))
- [Remove trigger_token_expiration FF](https://gitlab.com/gitlab-org/gitlab/-/commit/e5deedd5e59229a4a82eb90acdc2eb0196f47b41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208610))
- [Adding a test to show the need for an API type fix](https://gitlab.com/gitlab-org/gitlab/-/commit/876f95ad817287ca28f24a762eec2042e016eb5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208052))
- [Delete desired config generator version column](https://gitlab.com/gitlab-org/gitlab/-/commit/3234ec02f9e2fcd9792b081f648a9be33523b83d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208833)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch work items to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/82a7c27f806bd5e580d5b3ec64ab840664675b43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208935)) **GitLab Enterprise Edition**
- [Vue 3 spec fix](https://gitlab.com/gitlab-org/gitlab/-/commit/86b93c327bf62d4ea152164a733e4d2a09abbbce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208966))
- [Updating Topology Service Client Gem to 5ccb2bb](https://gitlab.com/gitlab-org/gitlab/-/commit/a72439112e89ff9a24306dcc48cee95da297936e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208993))
- [Cleanup duo_pro_trial_single_form feature flag and code](https://gitlab.com/gitlab-org/gitlab/-/commit/7d14c3a288b77ab94229a1cb4659be5b02e2ef38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207475)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-10-15)](https://gitlab.com/gitlab-org/gitlab/-/commit/4423fd056e1503ad375fd4e373ee29bc9f41cb2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208942))
- [Add commit_user_mentions sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/a1f1e3a4e0502ccf0ec601d94cf184704733586e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208639))
- [Finalize BackfillWorkspaceAgentkStates](https://gitlab.com/gitlab-org/gitlab/-/commit/4c4d44d3f0d46ad01976f470f45d2f1dd99e0797) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208926)) **GitLab Enterprise Edition**
- [Move `oauth_applications` to `gitlab_main_org` schema](https://gitlab.com/gitlab-org/gitlab/-/commit/c2af2a08cffbc175fa4191a3c3030b55408aa1a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206129))
- [Default enable FF: audit_events_fix_streaming_filters](https://gitlab.com/gitlab-org/gitlab/-/commit/be88331842cdc67fccdb1a9abdf7123e7a0264c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207498)) **GitLab Enterprise Edition**
- [Add suggestions sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/dbe0eaba00db128005dda83f5ce481696cadb1d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207836))
- [Finalize BBM BackfillComplianceFrameworkSecurityPolicyId](https://gitlab.com/gitlab-org/gitlab/-/commit/a0a6d1a13f67bacfbcfa82c859f104ac2962a6e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202537))
- [Backfill organization ids on webhooks](https://gitlab.com/gitlab-org/gitlab/-/commit/92c2c702f670ce35b4c947ab0b4051afc8d4ee21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208098))
- [Remove resolve_pipeline_schedule_race_conditions FF](https://gitlab.com/gitlab-org/gitlab/-/commit/e4fdd64a9d4c8338a9401c0a16f68da1d9c31cea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208616))
- [Sync translations from crowdin (2025-10-13)](https://gitlab.com/gitlab-org/gitlab/-/commit/7bc81df7ed0ad35d89240e59d6842060092a2a7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208588))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/79617ef317f9b473684ff179aef94d7f5c1132a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205311))
- [Fix invalid deploy tokens on staging](https://gitlab.com/gitlab-org/gitlab/-/commit/af4c0afcf46deaef190324f25b266126b1863802) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206777))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/ea0dbba113b9dbc671b6db6fc4185cbbb6c856ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205312))
- [Finalize BBM DeleteExpiredVulnerabilityExports](https://gitlab.com/gitlab-org/gitlab/-/commit/7a36276fe0a36b9e1a3080f25a66258e6ffa667b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203408))
- [Finalize BBM RemoveOrphanedVulnerabilityNotesBatchedMigration](https://gitlab.com/gitlab-org/gitlab/-/commit/017bb7f2ba173211a05137f575a0ba8e83d0ee55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197721))

## 18.5.2 (2025-11-11)

### Fixed (10 changes)

- [Fix test failure by adjusting dates to match partition range](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7a43d4b3eed4e6730269fc18e78459ec711c913a)
- [Fix background migration when Ghost user is missing](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2d51659333e0ba46b24ba208f7e1ea6e31817ea1)
- [Downgrade Zeitwerk to 2.6.18](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b620e65bb65b810fe62d962ada488ec924ffe271)
- [Allow Legacy FIPS instances to Upgrade Oauth secerets](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1baa80bb05b379a516b2a3971f34e1ad9078fae7)
- [Call CommitIndexerWorker when an empty project is created](https://gitlab.com/gitlab-org/security/gitlab/-/commit/38160fe77749b90d33d0cd484e8c788ea0a8b5dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207806)) **GitLab Enterprise Edition**
- [Fix the zoekt filters caching](https://gitlab.com/gitlab-org/security/gitlab/-/commit/63be8de02b236411b9d18176f37dc5c68a009251) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209798)) **GitLab Enterprise Edition**
- [Web Agentic Chat: fix calling workflowGoal on undefined](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ebfa262932b64f78b31e7282e1f62db0cb9d7936) **GitLab Enterprise Edition**
- [Add deleted Geo migration back](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cf8c43b60180ab370b6c42a22eeea643daf8a97d) **GitLab Enterprise Edition**
- [Fix password validation exception for FIPS](https://gitlab.com/gitlab-org/security/gitlab/-/commit/463c5aec8f33c3e9094fc5f47e831b3a97436741)
- [Fix admin_project_member policy SAML projects user namespaces](https://gitlab.com/gitlab-org/security/gitlab/-/commit/38414b0e0222f9d4cc58f090668121cd1409b383) **GitLab Enterprise Edition**

### Security (8 changes)

- [Security fix package api pipeline details](https://gitlab.com/gitlab-org/security/gitlab/-/commit/68646fa1ebff4180ee1fcc438f12a151bbf766c0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5424))
- [Group enforced pages access control should restrict non-members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8264a0d7c6a1b401aeee164e99727e446c3f2a2b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5440))
- [Update to gitlab-glfm-markdown 0.0.38](https://gitlab.com/gitlab-org/security/gitlab/-/commit/81de1960f41aecfd105644c11ab3c969a88ed8ad) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5461))
- [Encode protected branch names in API requests](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1aeb7601fe42c19b10c8d2a9408bf9ae88814935) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5456))
- [Prevent GraphQL subscriptions from blocked users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/42843be77904596c58dd3168f408929432e0a3ed) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5430))
- [Prevent Duo Chat from reading confidential resources](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e2a92aab1af9f57cf37175728888779bd0cab419) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5437))
- [Hide related branches when repository is private](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7957c6aaa3dda67c4ce7b236f0de1c19c34f8b47) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5434))
- [Fix unauth workflow deletion by service accounts](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e0892bf9d036c9a0fb6cc9e8d7579a8988741233) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5422))

### Performance (1 change)

- [Reduce cached SQL queries in `/api/v4/internal/pages` endpoint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/80df8f741cc94ad7900893fb6a129c772f6c8a56)

### Other (1 change)

- [Fix instance bbm for mishandled nil verification token](https://gitlab.com/gitlab-org/security/gitlab/-/commit/927b92e009d39b4e31ad75f3a94818f04a00d4a1) **GitLab Enterprise Edition**

## 18.5.1 (2025-10-21)

### Fixed (2 changes)

- [Fix connection pool errors when health check is running](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7852a9fa8c852ff2a949ea8f4ea46026418fc1dd)
- [Downgrade redis-rb gem to v5.4.0](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c5c44135b4ac722173fc343718828d0cce06fa53)

### Security (7 changes)

- [Non-group members can be added to projects even though the "Users cannot be...](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bcfba9217f7f7f49791fd6d0810757b6faab8236) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5433))
- [Ensure NPM upload cannot exceed plan limit](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a863e7d2cd55e6e0ec7c583cfb83ee5b2292c1eb) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5427))
- [Limit JSON request payload for /-/collect_events](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2c0995e8c27b0c71aff275bc53d15ecc375dcb5c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5403))
- [Track pull mirror updates using gitaly_context](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d702910abf4e2c45f0bf34ec0cd2ca4845ed4a0d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5410))
- [Reject quick actions for ai_workflows scope](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b1a7d090f334e2f584097746e85b4d0b3b32512e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5409))
- [Use CE policy for runner ability check](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8ccd23988915716dfd7682b3b2e2339f049c136a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5413))
- [Limit depth, size and total elements when parsing JSON string](https://gitlab.com/gitlab-org/security/gitlab/-/commit/137c1b88a25e5b00025fc43ad3609ab021d83222) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5406))

## 18.5.0 (2025-10-15)

### Added (178 changes)

- [Migrate WorkItemBulkMove to use shared projects query](https://gitlab.com/gitlab-org/gitlab/-/commit/39709cf894c4fb83605e78c413ece1190807f34e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208583))
- [Add risk score ingestion task pipeline report and CVS ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/63192ed63a5cb93db6742426f016c675b5b8f665) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207437)) **GitLab Enterprise Edition**
- [Add download route for Attestations](https://gitlab.com/gitlab-org/gitlab/-/commit/e74511d404b9fec7e057b7a0f8cc44f14a334eea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207917))
- [Persist and surface prefilled variables from PEP](https://gitlab.com/gitlab-org/gitlab/-/commit/8e55da7ee05f61cdefebda0c0bab26ba2462ab26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207861)) **GitLab Enterprise Edition**
- [Rollout security_inventory_filtering feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b2e09eff8ac25285c43365a5ef5e69dbf0286855) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208460)) **GitLab Enterprise Edition**
- [Security attributes - enable feature flags and add docs](https://gitlab.com/gitlab-org/gitlab/-/commit/90aff6e3b4479a67f6d0f9be3fedc0f8ab0d7c70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208386)) **GitLab Enterprise Edition**
- [Queueing Background operations](https://gitlab.com/gitlab-org/gitlab/-/commit/63b75906077e2de7ca62596862da218c232254f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207241))
- [Add clear upstream cache functionality to Maven upstreams list](https://gitlab.com/gitlab-org/gitlab/-/commit/679eca47bc1ec730f19a07387e3029387850cb33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208049))
- [Prevent connection check if no url is provided](https://gitlab.com/gitlab-org/gitlab/-/commit/d6d0d242d8eac7ad7a0536e1f5965b785ec6114c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204582))
- [Added header integration](https://gitlab.com/gitlab-org/gitlab/-/commit/048f3cf67596be9f2bf585258686b986ba675040) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207129)) **GitLab Enterprise Edition**
- [Add model metadata to geo helper](https://gitlab.com/gitlab-org/gitlab/-/commit/c8df63a4ecc81c5a5e09b03580dd92f03992fc74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207281)) **GitLab Enterprise Edition**
- [Add `Code generation volume trends` chart](https://gitlab.com/gitlab-org/gitlab/-/commit/fa95a0a6f9c859c936d5d321cf26a77d0c2687a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207924)) **GitLab Enterprise Edition**
- [Add latest flag loading to graphql request](https://gitlab.com/gitlab-org/gitlab/-/commit/1db1019632745dbac43c54ebece739002b210ceb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207477)) **GitLab Enterprise Edition**
- [Extend runner job metadata with user and project context](https://gitlab.com/gitlab-org/gitlab/-/commit/45011605485b3be4cbcc51b8cc1f83d3bdb1f1e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206700))
- [Enable `work_item_status_mvc2` by default](https://gitlab.com/gitlab-org/gitlab/-/commit/4ea2ef271211ee178dd22abe7af3fea8976fcc9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207570))
- [Add experiment to manage stage inject strategy](https://gitlab.com/gitlab-org/gitlab/-/commit/5dd577cdd04afcac229de009b17bd266007bb3fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207175)) **GitLab Enterprise Edition**
- [Add API endpoint to store SAST FP detection results](https://gitlab.com/gitlab-org/gitlab/-/commit/61ba69ff61ccc813e68b82e0141eaa345f1ab628) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207592)) **GitLab Enterprise Edition**
- [Drop invalid rows from security_trainings table](https://gitlab.com/gitlab-org/gitlab/-/commit/116bf61794b6b1939d72f539ef9ac3a26ab36376) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207080))
- [Requeue security inventory filters backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/53a9e2e6977f81cf3fee6c14d9273723efdf5f0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208111)) **GitLab Enterprise Edition**
- [Add state counts for planning views work items](https://gitlab.com/gitlab-org/gitlab/-/commit/35cac81a2e9351633937f994923a902d526b8f08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207598)) **GitLab Enterprise Edition**
- [Add default reference to custom status mappings](https://gitlab.com/gitlab-org/gitlab/-/commit/585bae92cc5948e7792dc4ca6cabe569f578b532) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208039))
- [Add composite identity OAuth token authentication for GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/3142218aedaa0ab3503393453901558f48275569) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208089)) **GitLab Enterprise Edition**
- [Enable partial scans by default](https://gitlab.com/gitlab-org/gitlab/-/commit/4309365048ffec52d47e7693b8c86adb23b10469) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208252)) **GitLab Enterprise Edition**
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/ee4ccf5137b7ba55c83a7d8e3457acd32d0c5504) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204109))
- [Use template-based IDs for default categories and attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/423fbc8484f54bf4fea4a946666d05d2515de04d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206910)) **GitLab Enterprise Edition**
- [Add multi-select support for filter tokens in work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/0818ec2f78746bd4cef2ddb696d35bf4b4cc64db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207636))
- [Add token_status support to vulnerabilities GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/c4b17beb99e26df692d1782c5c267d88cfa844cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205482)) **GitLab Enterprise Edition**
- [Tracks the number of tokens sent to UpdateTokenStatusService](https://gitlab.com/gitlab-org/gitlab/-/commit/51c995226c637aa02ed8e7a59d169760d616fe5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207996)) **GitLab Enterprise Edition**
- [Add default reference to custom status mappings](https://gitlab.com/gitlab-org/gitlab/-/commit/5c72e70221a047f8b3ff5728ebef42c92b4fb985) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207735))
- [Add human-only project_action_human_users metric](https://gitlab.com/gitlab-org/gitlab/-/commit/292bb5170de8af8ee47fc84b7c9e2649ebc16b47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207260))
- [feat(ci): Support custom badges](https://gitlab.com/gitlab-org/gitlab/-/commit/b08cc1b5d2813f9a94a9a9b2f4ecf38c0ea44900) by @barton.tomas ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180832))
- [Allow Gitlab.com admins to create groups via the api](https://gitlab.com/gitlab-org/gitlab/-/commit/5494ebd47312d86b005152639406e35bc002e42a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206117)) **GitLab Enterprise Edition**
- [Default enable ui_for_virtual_registries feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fe52a956e486487ef7404ec0422784fc29d88949) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208245))
- [Enable the Merge request analytics dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/2bbfd65772ac9286252c636df159b90dc7dd7d39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207758)) **GitLab Enterprise Edition**
- [Allow webhook rate limit configuration via REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/f7c2b2604b60775065e2c142ee8587bb904f5dd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207677))
- [Default enable dora_metrics_dashboard feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/83e8d47abbd0baad218452dfd28e461e57ea58a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208236)) **GitLab Enterprise Edition**
- [Updated all badges to be beta for validity checks](https://gitlab.com/gitlab-org/gitlab/-/commit/1b3d4249234d51facc46dee2308f067a1d3dd43c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206929)) **GitLab Enterprise Edition**
- [Add partner token verification framework for secret detection](https://gitlab.com/gitlab-org/gitlab/-/commit/ab35faebd007bcba50896ccf7cbc3cfd577aa632) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206905)) **GitLab Enterprise Edition**
- [Add des detail linter](https://gitlab.com/gitlab-org/gitlab/-/commit/330278045e85527a1a8e5b68ba9feb0a466b363c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207338))
- [Add `Code suggestions acceptance rate by language` chart](https://gitlab.com/gitlab-org/gitlab/-/commit/0fb4a2d1808ed0453230e73522d255315aa9d195) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207492)) **GitLab Enterprise Edition**
- [Enable service and bot account reassignment in import user mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/e002990993f4cff91828af38ac0f02be9d94514f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208155))
- [Add organization_id to pool_repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/6e24e824492a0af7f6d85c564702f1bf2af5e7c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206779))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/ada57c0ae35069d5783cded3988a29c3a53266bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207878))
- [Add support for _index.md files as repository landing pages](https://gitlab.com/gitlab-org/gitlab/-/commit/a66cace64b43987d810231dfc2ba054c11978b37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206533))
- [Add reading of bypass statuses to MR widget](https://gitlab.com/gitlab-org/gitlab/-/commit/e0843d7659c7209dd268f24f9472eca0b03ff553) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207337)) **GitLab Enterprise Edition**
- [Add scoped_web_path field to Organization GraphQL type](https://gitlab.com/gitlab-org/gitlab/-/commit/4cd893a06f120934491ed458e7c346d3d7b87f7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206101))
- [Update mergeability checks for security policy bypass](https://gitlab.com/gitlab-org/gitlab/-/commit/536cb86424340ac8e76904ada2f4ea3c50484c5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207426)) **GitLab Enterprise Edition**
- [Add graphql for vulnerability flags](https://gitlab.com/gitlab-org/gitlab/-/commit/fa7cde50bd39a9f8e2e2b3c73c6f7a1945446575) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205994)) **GitLab Enterprise Edition**
- [Exclude count headers from pagination headers](https://gitlab.com/gitlab-org/gitlab/-/commit/80ca0cf765d496dc6b145b738a27ec5328b40a67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207484))
- [Finish skip email OTP user workflow](https://gitlab.com/gitlab-org/gitlab/-/commit/5fce94313d6f992dc99ad4cba0f9200300b9cd2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204982))
- [Ensure selectable models on dropdown are sorted](https://gitlab.com/gitlab-org/gitlab/-/commit/64efe2125c30b8cf0190e36673f4671109c09225) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207709)) **GitLab Enterprise Edition**
- [Add file upload capability to Attestation model](https://gitlab.com/gitlab-org/gitlab/-/commit/28156e620a1e041dabd3a5fb57f48d90db1ad6eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204998))
- [Chunk bulk edit operations to prevent timeouts](https://gitlab.com/gitlab-org/gitlab/-/commit/6e4d4cb98bfa2ed918c9aae875ce56b49eec1733) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206880))
- [Add GroupInheritancePopover to branch rules list](https://gitlab.com/gitlab-org/gitlab/-/commit/bfbce5bd5e1f6318898edb378cee6a1a50fbd47f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207123))
- [Step-up auth: Add OIDC backend support for namespace scope [1/3]](https://gitlab.com/gitlab-org/gitlab/-/commit/035d9a8f7916f26f3902c6e681873863a97ab8c3) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204102))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/a3e7423e9a1dc515a4335958c155d789464321cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207566))
- [Add policy violations field to Vulnerabilities ES index](https://gitlab.com/gitlab-org/gitlab/-/commit/ba3c47bc42871d87f197afa11f818a4da324a1c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207560)) **GitLab Enterprise Edition**
- [Add new scopes and index for PolicyDismissal](https://gitlab.com/gitlab-org/gitlab/-/commit/1539b03604f32d7adfe25ecf0e84f04e4050d504) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207531)) **GitLab Enterprise Edition**
- [Add internal ID support for attestations](https://gitlab.com/gitlab-org/gitlab/-/commit/c09e2323b4d1c412c21f0522d41295485c00d569) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206787))
- [Add support for allow_immediate_namespaces_deletion setting in admin](https://gitlab.com/gitlab-org/gitlab/-/commit/f5b5fc565cbbf8ad651a977f83e254f7ac7fbde0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205556))
- [Add migration to backfill token_status in vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/f15707dce45acf4b57282e942b11c26edf27d6e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207065)) **GitLab Enterprise Edition**
- [Add migration to recalculate user's 2FA enforcement](https://gitlab.com/gitlab-org/gitlab/-/commit/92b46fc5cc45a653e5e8ba8ad7d4940a2d59d843) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205407))
- [Add index on vulnerability_identifiers](https://gitlab.com/gitlab-org/gitlab/-/commit/a9195c57940da4f05a11cb7a0f6fd5ee705bf52d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207422)) **GitLab Enterprise Edition**
- [Create risk score calculation service](https://gitlab.com/gitlab-org/gitlab/-/commit/3b1f1beb83a1ee4bb80a93d5f15db3ab5e29fb2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205664)) **GitLab Enterprise Edition**
- [Add parent foreign keys to merge_requests_merge_data table](https://gitlab.com/gitlab-org/gitlab/-/commit/49d4ac4fb4b6f42382d98e7f85334e2061194e6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205992))
- [Add image lightbox](https://gitlab.com/gitlab-org/gitlab/-/commit/9e662b9cd0ee37ab9b027828269c0080ce55c95d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203609))
- [Added real chat into the project studio panel](https://gitlab.com/gitlab-org/gitlab/-/commit/cdc11988aa029ee55a33d416e268b64795202c18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206881)) **GitLab Enterprise Edition**
- [Add UI components for external control ping configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/6407d05cb3340251b99d11fb4de5cb12457b326d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205463)) **GitLab Enterprise Edition**
- [Support service and bot account reassignment in import user mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/06cdf612b02c85142d8b542340276135149e20fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206601))
- [Set concurrency limit of evidence worker](https://gitlab.com/gitlab-org/gitlab/-/commit/81f6b13276be7b8ee8cc10c737c4db251b854284) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207218))
- [Support filtering by status name across namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/00ef60e74e845fea97089ecba3cf659149e6eec6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205323)) **GitLab Enterprise Edition**
- [Add project_id columns and foreign keys to x509 tables](https://gitlab.com/gitlab-org/gitlab/-/commit/d35842901733a41fde3f9f5edc7e0a34db81f4a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206542))
- [Add Postman token verification client for secret detection](https://gitlab.com/gitlab-org/gitlab/-/commit/6d20374f5224cb9004edc4256a9d19af56b7c0d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206335)) **GitLab Enterprise Edition**
- [Add bypass_settings to merge request graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/d03ca01ce165f94b27fc7cea9c8926551a3000d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206449)) **GitLab Enterprise Edition**
- [Unlink MR and vulnerability mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/895e9fb8d2ac7b6134a488229a329a65bc2453f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206585)) **GitLab Enterprise Edition**
- [Add metrics to both gemnasium and the new DS](https://gitlab.com/gitlab-org/gitlab/-/commit/c2eb97125a79010f37ccc5592c17c8a7e4c17f0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206995))
- [Add events for the new DS analyzer](https://gitlab.com/gitlab-org/gitlab/-/commit/b5ac845f1514d50dce11e1dc8dd4f3d70340c0d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206296)) **GitLab Enterprise Edition**
- [Add runner jobs API rate limit](https://gitlab.com/gitlab-org/gitlab/-/commit/ce6eef57f47c18bf575a3fbeb568e413613a4a32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206712))
- [Audit external status on users](https://gitlab.com/gitlab-org/gitlab/-/commit/8b1dfa60d9166b0068e115709214008abfe87bad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207107)) **GitLab Enterprise Edition**
- [Add detected_at column to vulnerability_occurrences table](https://gitlab.com/gitlab-org/gitlab/-/commit/b58066a648ea43f04599ee656448d293a4867972) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207096))
- [Introduce legacy namespace field for managed resources](https://gitlab.com/gitlab-org/gitlab/-/commit/f2dffd093e51e45660108ca3b93493a5d33c27c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206244))
- [Add mutation for policy exceptions](https://gitlab.com/gitlab-org/gitlab/-/commit/1d96915ba435d74bf9d2ce66d15e4b9418453256) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206578)) **GitLab Enterprise Edition**
- [Persist toggle of advanced editor](https://gitlab.com/gitlab-org/gitlab/-/commit/ef318afa69e1dbd163dfda10442305b8d21e2080) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205952)) **GitLab Enterprise Edition**
- [Modify organization_push_rules sync triggers](https://gitlab.com/gitlab-org/gitlab/-/commit/48411814a02885fb272fa9ffa307fc348190f8b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205721))
- [Add status mapping support to work item sorting](https://gitlab.com/gitlab-org/gitlab/-/commit/ae024c26cb5652283dec20f78dfd2f5bac033652) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205985)) **GitLab Enterprise Edition**
- [Ensure all REST endpoints have tags](https://gitlab.com/gitlab-org/gitlab/-/commit/7f668c4828c8ca2361446db13bac11da36d27c79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205708))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/fd0d3dcf54d462eab5c26c457a132f98858166a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207047))
- [Add streaming audit events for notes](https://gitlab.com/gitlab-org/gitlab/-/commit/f3a548b3bb2e80d2fa37c1bd9ff7b294c811fa64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206489)) **GitLab Enterprise Edition**
- [Add partner token verification Sidekiq worker](https://gitlab.com/gitlab-org/gitlab/-/commit/675e8ab6c9a7f405923c8d12bc7e88c56a5ffd6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206211))
- [Enable reference expansion in release descriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/9ef0e81605724ac2f5ea3cbf7e625f1a1bf06fa6) by @digitalmoksha ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206957))
- [Enable traversal_ids update by default](https://gitlab.com/gitlab-org/gitlab/-/commit/f0f79471a071ee477d8127b2a7b7f2b92bd04280) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206737))
- [Add support for work item counts per status](https://gitlab.com/gitlab-org/gitlab/-/commit/822516e6fef3638d4ae8ffedf16b3194160214dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206655)) **GitLab Enterprise Edition**
- [Add risk_score field to vulnerability index](https://gitlab.com/gitlab-org/gitlab/-/commit/a16f9f6dd6faa075b7adb4ddb95008f7ffd8f1f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206657)) **GitLab Enterprise Edition**
- [Retry job if runner does not acknowledge it in a timely fashion](https://gitlab.com/gitlab-org/gitlab/-/commit/880d407681f14a65e4540ffef56a1d0ef2606409) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206034))
- [feat: Changelog message](https://gitlab.com/gitlab-org/gitlab/-/commit/76ab943b83399177df3237524d6ed6ff24413561) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201344))
- [Filter by status with mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/4ec31ca48ec98edf36798abb60cc62439f87e6aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206354)) **GitLab Enterprise Edition**
- [Add warning on project/group with invalid policy.yml file](https://gitlab.com/gitlab-org/gitlab/-/commit/96150d2a5fbd4f8740088f87a0f138a63f9fcdff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206109)) **GitLab Enterprise Edition**
- [Add param desc check](https://gitlab.com/gitlab-org/gitlab/-/commit/0fca0802ae70a5c07a08484826654815d110648f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206279))
- [Add autocomplete for `[issue:` and `[work_item:`](https://gitlab.com/gitlab-org/gitlab/-/commit/3e9bdcf5e99e6c8728389167bfd20619c03885eb) by @digitalmoksha ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206297))
- [Add policy advanced editor to user preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/1b9ffbc2e96ec5a7148ac1c5aaa6842da0d8103d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205762)) **GitLab Enterprise Edition**
- [MCP: add create_merge_request tool section with example](https://gitlab.com/gitlab-org/gitlab/-/commit/d5b119cf0296a3fc2689bb798cabae36347f3274) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206097)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/0a8c24d553eaccc0d2290fdd6c4676e03fc04ed1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206643))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/def5291af79b894eec74db8c87eb96991d08aeb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206626))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/bd13ad6ae5c068b059e68066ae7ab697e06956e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206625))
- [Add Authz::UserProjectMemberRole model](https://gitlab.com/gitlab-org/gitlab/-/commit/c0f972c892459d1fe4e6c98f041ac7c164083d42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205810)) **GitLab Enterprise Edition**
- [FindingTokenStatus API integration for MR and Pipeline Security](https://gitlab.com/gitlab-org/gitlab/-/commit/c14cf988898c75937628f2b39f0bdf64c16d2178) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203947)) **GitLab Enterprise Edition**
- [Adds implementation of attach to work item type mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/e85c21abc71d80eb9fb4a6e08e6ae933d453bde5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205712)) **GitLab Enterprise Edition**
- [Adds ES synchronization for Vulnerabilities::Finding](https://gitlab.com/gitlab-org/gitlab/-/commit/b8f8475bab4b1c08e418a688c14a48bff629134f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205922)) **GitLab Enterprise Edition**
- [Add `titleFormatter` enum for analytics dashboard chart tooltips](https://gitlab.com/gitlab-org/gitlab/-/commit/c866b893f87f8d1b35fbd818aca39d734caeb353) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206436)) **GitLab Enterprise Edition**
- [Add runner jobs API rate limit](https://gitlab.com/gitlab-org/gitlab/-/commit/e30c626cc36a79fb614974c7829ab17a643c402f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206026))
- [Step-up auth: Add REST API support for Groups endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/d1d7c60befa09a16ba6824205b8d52b1304a0e06) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203429))
- [Feat: disable manual issue reordering during rebalancing operations](https://gitlab.com/gitlab-org/gitlab/-/commit/4a2f94d85575c9028442c87811e435a27bc37261) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205341))
- [Remove check_f02a3f53bf not null constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/5cd5c93faf57e1337623e9b4145e66a44172c1e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206512))
- [Add event publishing to members update service](https://gitlab.com/gitlab-org/gitlab/-/commit/906a090ef32d60d3d623a18da1ccfd199348b57b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205121))
- [Add option to search through subgroups in Inventory](https://gitlab.com/gitlab-org/gitlab/-/commit/7b1701a97ad636b5041ffedeb0e8b9443cc01511) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206469)) **GitLab Enterprise Edition**
- [Add file upload capability to SupplyChain::Attestation model](https://gitlab.com/gitlab-org/gitlab/-/commit/bb4c56da274810ebdd9c02f7c3d94fe570d758ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205317))
- [Introduce `ignoreRevs` argument to GraphQL `blame` query](https://gitlab.com/gitlab-org/gitlab/-/commit/30db2c11124c325f04f1f46f3aaba104c90d4b3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205868))
- [Fix invalid CI/CD YAML when creating projects with SAST and SD enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/e8fe921ccae29f0d11a62c7ae881c76eba060abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206003))
- [Add filter on record identifiers to the API](https://gitlab.com/gitlab-org/gitlab/-/commit/0d5ab59708fcdeba8697ce70d2c50cbb352e8ac1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205353)) **GitLab Enterprise Edition**
- [Add remove_partitioned_foreign_key helper method](https://gitlab.com/gitlab-org/gitlab/-/commit/17bf0d13f4cc2276531bde46ac44f29422531c58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205330))
- [Broaden scope of allowed pipelines for Fix pipeline button](https://gitlab.com/gitlab-org/gitlab/-/commit/c63ef25a84505846364789fd567de636d002e748) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205884)) **GitLab Enterprise Edition**
- [Add mutation to bypass security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/684512b3006542661724fb155c127593a4b554c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205601)) **GitLab Enterprise Edition**
- [Protected packages: Add deletion protection to GraphQL package mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/4a049d4e35f215e31247cca18284d9d1be904646) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202199))
- [Add root_namespace_id in virtual_domain.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/a95e145ed2d7aeb4a168771a8597a3466b39c7e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205243))
- [Add execute cleanup policy service for virtual registry](https://gitlab.com/gitlab-org/gitlab/-/commit/30456fffa5d441bc0fa8dde7bcbac18e6d897f85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205440)) **GitLab Enterprise Edition**
- [Add source_branch to Convert pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/c1a501affba55ceea7b00d80c864436cd8225754) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206166)) **GitLab Enterprise Edition**
- [Add events for Gemnasium](https://gitlab.com/gitlab-org/gitlab/-/commit/f5ebb66bb834c7977e2a1f4c1a73fac6b982a0f4) by @YashaRise ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202596)) **GitLab Enterprise Edition**
- [Add Block Seat Overages (BSO) check for groups via LDAP](https://gitlab.com/gitlab-org/gitlab/-/commit/107adc15c063638b00e633f834c181ebec62a694) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202425)) **GitLab Enterprise Edition**
- [Add GCP client for partner token verification](https://gitlab.com/gitlab-org/gitlab/-/commit/74ad514990732ce22f349afd9105950b20650c43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205848)) **GitLab Enterprise Edition**
- [Allow group owners to undo the keep as placeholder user operation](https://gitlab.com/gitlab-org/gitlab/-/commit/de0888e186e4f3234054a4b8eeffff039970714b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204283))
- [Add the allow_immediate_namespaces_deletion application settings](https://gitlab.com/gitlab-org/gitlab/-/commit/4e8ec857ab9733920034c456795d19959ad42399) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205554))
- [Add status filter to issues dashboard list](https://gitlab.com/gitlab-org/gitlab/-/commit/a17b79509855bdee18d0b036769c91a313734fc4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204905))
- [Implement the mutation to set group validity checks](https://gitlab.com/gitlab-org/gitlab/-/commit/de0ca3ce0df461786124224aa0f9f4f01e35f054) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205822)) **GitLab Enterprise Edition**
- [Implement the worker to set group validity checks](https://gitlab.com/gitlab-org/gitlab/-/commit/81f88158842e2eb4d8c7ca0ad4fb25cddd30a6e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205707)) **GitLab Enterprise Edition**
- [Implement deleting work item lifecycles](https://gitlab.com/gitlab-org/gitlab/-/commit/4dbad04c7849bf7fd6ea51fe469e3a309b69b9f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205792)) **GitLab Enterprise Edition**
- [Retry job if runner does not acknowledge it in a timely fashion](https://gitlab.com/gitlab-org/gitlab/-/commit/e7d4ed5e93206d58b1b300a31591afbd335f1152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204709))
- [Use security_report_time_window logic for pipeline comparison](https://gitlab.com/gitlab-org/gitlab/-/commit/74745d6b3577e664be1ac8ef26e476d4920785f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204522)) **GitLab Enterprise Edition**
- [Removing FF notify_pipeline_schedule_owner_unavailable](https://gitlab.com/gitlab-org/gitlab/-/commit/d1e24c82f79beffa3d7fedc52da2d40c3a3df220) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205937))
- [Add last_verified_at to token status tables](https://gitlab.com/gitlab-org/gitlab/-/commit/a0effb9885c063d9b2b08fdf0b51e2ef946b29e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205531)) **GitLab Enterprise Edition**
- [Add tag_name column to ci_runner_taggings table](https://gitlab.com/gitlab-org/gitlab/-/commit/30c81880e554b95d90d899415e0e86cfed7cbf38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205101))
- [Backfill integrations and validate not null constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/8326af19a95789d3d1231a5e8e7db5021d186ab3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204744))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/b3d774e19a0ba3cf4282dbd4ebe03b7cebb2198b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205787))
- [Add token status population to the Vulnerabilities ES reference class](https://gitlab.com/gitlab-org/gitlab/-/commit/b4a84bc6b82851a6010fb4d05ac8603997a5d635) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204042)) **GitLab Enterprise Edition**
- [Remove project violations feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d2c90d4b710d1e446162d6f3fa9560ebed824f2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205755)) **GitLab Enterprise Edition**
- [Implement the service to set group valitity checks](https://gitlab.com/gitlab-org/gitlab/-/commit/03371c7aa607ce27908ba5041ff9ce6e081091e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205405)) **GitLab Enterprise Edition**
- [Adds mapping in lifecycle mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/7965f6ec59b4c34742c85a14da354d5f0eca69c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204899)) **GitLab Enterprise Edition**
- [Support 2-phase commit of pending jobs in `PUT /jobs/:id`](https://gitlab.com/gitlab-org/gitlab/-/commit/dd9f088b908b1a850f6bd80b8fd08e07b49ac909) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204265))
- [Add migration alert to Merge request analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/762641f3a50d11136b483722898ffee9f82e9d9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205108)) **GitLab Enterprise Edition**
- [Add runner jobs API rate limit](https://gitlab.com/gitlab-org/gitlab/-/commit/018424ae9b3139ba73baf744ca065d487a723cd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204751))
- [Added integration of duo side-rail](https://gitlab.com/gitlab-org/gitlab/-/commit/d33059607d8568d664ff1a64e41a64af6a9af8a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204655)) **GitLab Enterprise Edition**
- [Add group transferred event handler workers](https://gitlab.com/gitlab-org/gitlab/-/commit/b58ddb80014effe5d9b8f86b3505dbb74b96ba0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203755)) **GitLab Enterprise Edition**
- [Add tag_name column to ci_runner_taggings table](https://gitlab.com/gitlab-org/gitlab/-/commit/3c44de18955a4ae7064b672ec350562d531a603e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205435))
- [Add mode selector for bypass options](https://gitlab.com/gitlab-org/gitlab/-/commit/6ca910f75035b35d73d7d779baeb2e7504ab3f9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204043)) **GitLab Enterprise Edition**
- [Sort work items by status](https://gitlab.com/gitlab-org/gitlab/-/commit/2ac46f835fe11d8f6c15e50bb264ebcf282b16b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199860)) **GitLab Enterprise Edition**
- [Add lastRepositoryCheckFailed filter in Admin Area > Projects dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/d931eed3dc0906c51e3e29fdad4c59761446d6bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204306))
- [Enforce max 20 attributes to a project limit](https://gitlab.com/gitlab-org/gitlab/-/commit/cc7c507f494fa42faab4fdb6502c6e6920927d16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205494)) **GitLab Enterprise Edition**
- [Add duo_default_namespace_id to user_preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/cdfa77c3c794d6f2a834e1f06fd45ed8f55f9463) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204649)) **GitLab Enterprise Edition**
- [Background migration CLI](https://gitlab.com/gitlab-org/gitlab/-/commit/7ed1f393b76c9c9cbe5eaaed304d21ec650a8e28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191722))
- [Geo Replicables: Reverify all failed registries](https://gitlab.com/gitlab-org/gitlab/-/commit/020cc1254a25904a5043681e9af8987eab7e2773) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204574)) **GitLab Enterprise Edition**
- [Add microdata to group and project list items](https://gitlab.com/gitlab-org/gitlab/-/commit/42a3f26dbb9398d7c51f0697880fbd08207cc74e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205250))
- [Add ping_enabled field support for external controls](https://gitlab.com/gitlab-org/gitlab/-/commit/5a3a8b98506c537c80ee906b55e6ed4508257927) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204286)) **GitLab Enterprise Edition**
- [Add virtual registries cleanup policies model and DB table](https://gitlab.com/gitlab-org/gitlab/-/commit/2787bf705b582dab9ff63b96665a8b814387e40d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203532)) **GitLab Enterprise Edition**
- [Allow querying work item allowed statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/f446ec95dd9ec96228862a30d60f3406ede6d02f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204652)) **GitLab Enterprise Edition**
- [Use new CloudConnector UnitPrimitive API in UserAuthorizable](https://gitlab.com/gitlab-org/gitlab/-/commit/91e60c3ddfd7a5b9a0a32e29705de5b178b93753) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204861))
- [Add versions GitLAb PATs to validity checks](https://gitlab.com/gitlab-org/gitlab/-/commit/72ca451318f89f1ae1c687e4d8d2a18db13fc85c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205325)) **GitLab Enterprise Edition**
- [Remove compliance violations report FF](https://gitlab.com/gitlab-org/gitlab/-/commit/136647bd73b4d5af16de10ee0aa7b573107061b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205296)) **GitLab Enterprise Edition**
- [Filter ai usage by users and events on GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/ee6e39439ff2e7d57858f759fda5584cadabdb96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204901)) **GitLab Enterprise Edition**
- [Introduce realtime pipeline schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/d1a193f81cb964b10086b2b859f436abe36df62d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204732))
- [Add AuthenticationEventArchivedRecord table](https://gitlab.com/gitlab-org/gitlab/-/commit/cd290044797327a09cea8566ff4fb0381879eea9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202447))
- [Adds a new table to hold archived OauthAccessToken records](https://gitlab.com/gitlab-org/gitlab/-/commit/60c3aab3d0715b224db10e96a518e20d302e2c73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197692))
- [Create work_item_descriptions table partitioned by namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/529ff60a5a2d2f885bfd76bf6bd7b6a034bd65c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204810))
- [Add jira_connect_installations sharding_key](https://gitlab.com/gitlab-org/gitlab/-/commit/f254cd3d2d17053a54b7859774c62c5a473015eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204228))
- [Show non-default target branch in MR dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/98600d03ac9e4b0b56653495a2420bb448227be1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203751))
- [Add support for Replicated ClickHouse DB engine](https://gitlab.com/gitlab-org/gitlab/-/commit/63d735084433885adb4d1943d0894ed95a0ff18c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203800))
- [Backfill namespace_traversal_ids on issues table](https://gitlab.com/gitlab-org/gitlab/-/commit/fb58e5f6558244f007a94b82d0bcf77b963d293c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204846))
- [Add webhook trigger for system-initiated approval resets](https://gitlab.com/gitlab-org/gitlab/-/commit/561f3adf76f8c135899d50b91e749e5d5d434041) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197850)) **GitLab Enterprise Edition**
- [Clean up duo_workflow_work_item_tools flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d3c19c7de1fad3ba028de2384c87a986377187b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204826)) **GitLab Enterprise Edition**
- [Add support for Duo Context Exclusion](https://gitlab.com/gitlab-org/gitlab/-/commit/4569a04491748e5af6dc075a88e0b3486596310f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204708)) **GitLab Enterprise Edition**

### Fixed (137 changes)

- [Show whitespace message when there's nothing to show](https://gitlab.com/gitlab-org/gitlab/-/commit/32b14b8595803077549d7b1dbb00c3c459a0792f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207868))
- [Scan should be ready if pipeline is manual](https://gitlab.com/gitlab-org/gitlab/-/commit/a1665b036b9ddd3e908eb31b07e671f38ccd9559) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208491)) **GitLab Enterprise Edition**
- [Fix Duo Chat blocked state after viewing deleted agent](https://gitlab.com/gitlab-org/gitlab/-/commit/f7d87b3fbb9b34ff79c56d76c5e9a3481842e5f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208256)) **GitLab Enterprise Edition**
- [Fix non-nullable errors field for vulnerability archive mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/2cd8c0a4426a75e15bdecbb3a899ab31ae87824a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208469)) **GitLab Enterprise Edition**
- [Remove border radius for diff comments](https://gitlab.com/gitlab-org/gitlab/-/commit/82e2cc1287535e9b844d579cfa251d7d852c7179) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208361))
- [Fix layout of AI panel](https://gitlab.com/gitlab-org/gitlab/-/commit/36470c215b4b170685464aec30ed581d2acc3498) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208145)) **GitLab Enterprise Edition**
- [Update infinite scrolling data loader to work with paneled view](https://gitlab.com/gitlab-org/gitlab/-/commit/6b4cbd65fe338d074174e4bc52e3d5d630abe115) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208221))
- [Fix MergeRequestsFinder commit filtering for generated ref commit shas](https://gitlab.com/gitlab-org/gitlab/-/commit/7cb304c712ba60b3a383ca043515079150d6bc5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206264))
- [Fix flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/3c0c45f90c69854c8f0de0169ac32495135dce28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208306))
- [Ensure skiplink is first focusable element](https://gitlab.com/gitlab-org/gitlab/-/commit/21645807a3b0bbdb1af68b8847338a85d5d7e93a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208203))
- [Add float fields to DedicatedMonthlyUsageType](https://gitlab.com/gitlab-org/gitlab/-/commit/bd86026d2fb82592c31e909aed2095b1f0479c38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207340))
- [Fix panel query for work item attributes wrapper](https://gitlab.com/gitlab-org/gitlab/-/commit/a316972e8b5209813eb9fda0f2cbfb9fb4463b01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208148))
- [Fix inventory filters table not being updated](https://gitlab.com/gitlab-org/gitlab/-/commit/c466708a3f4b61f3b2a311ae3433d973e26ed773) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208074)) **GitLab Enterprise Edition**
- [Allow removal of status unused in a lifecycle](https://gitlab.com/gitlab-org/gitlab/-/commit/42a77d4e8436b3a5dcf0c57fb80350a939ce930c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208054)) **GitLab Enterprise Edition**
- [Do not show weight warning in create work item view](https://gitlab.com/gitlab-org/gitlab/-/commit/5a5629513c337d058ee1a5e776b2f7de75095c45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208032))
- [Show deploy button for manual job](https://gitlab.com/gitlab-org/gitlab/-/commit/67b35569d063742c178f5a993e74b63bb3df8d08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207439))
- [Prevent inline LaTeX from overflowing parent](https://gitlab.com/gitlab-org/gitlab/-/commit/7433ee4a9dd929883f097c8618e30f272022325b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207962))
- [Fix invalid status after work item type conversion](https://gitlab.com/gitlab-org/gitlab/-/commit/b2ee329c3750312706bd8584a0541b912cbd96ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207583))
- [Do not use small text size for board items or child items](https://gitlab.com/gitlab-org/gitlab/-/commit/ae3bcf902ca596f1b0e9b675c6addecb51ac4b8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207929))
- [Fix file page alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/42e7c5d6d51013e1ba37128e0441d109a09f113d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207733))
- [Do not use gl-text-sm on agentic chat panel](https://gitlab.com/gitlab-org/gitlab/-/commit/d58c80e6a2e9e883c2ccfe29fa8f3b4fbb5c3731) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207923)) **GitLab Enterprise Edition**
- [Revert discarded database pool check in load balancer](https://gitlab.com/gitlab-org/gitlab/-/commit/a04a7fca923a76e53c0c3b854da2151aee7c4fde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207900))
- [Fixes scrolling to the correct job line](https://gitlab.com/gitlab-org/gitlab/-/commit/04c58bb789a089189e8fd4272db18b20baddbea5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207808))
- [Prevent session creation for sessionless users](https://gitlab.com/gitlab-org/gitlab/-/commit/39c4bcbd536ff301895d91b6732d4cf0568e3fdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207792))
- [Update Jira integration to use token-based pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/012d655aeb36286ba03c80a108a390ae6e4c40b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206815)) **GitLab Enterprise Edition**
- [Allow maintainers to fetch secrets permissions list](https://gitlab.com/gitlab-org/gitlab/-/commit/0d422ab82fa359f60da7aa29f498341b5d230525) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207042)) **GitLab Enterprise Edition**
- [Fix project import: ensure epics are linked by IID instead of title](https://gitlab.com/gitlab-org/gitlab/-/commit/c2235316b0c89f5878dbcf3643564063b1772b26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206850)) **GitLab Enterprise Edition**
- [Fix custom agent config persisting when switching to default agent](https://gitlab.com/gitlab-org/gitlab/-/commit/a093f1b8b042bcbb17945b5efc4a7e7a7f12c20b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207639)) **GitLab Enterprise Edition**
- [Handle non-utf8 user agents](https://gitlab.com/gitlab-org/gitlab/-/commit/2b45e96b4549ac19597d7add23afd84988fc2a86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207561))
- [Remove duplicate components from SBoM export](https://gitlab.com/gitlab-org/gitlab/-/commit/4573200a9f5c07f3d50c3c8b7a059e318aceabb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207465)) **GitLab Enterprise Edition**
- [Pass correct GraphQL variable when expanding a group](https://gitlab.com/gitlab-org/gitlab/-/commit/68b22ab2cf7a7b5d406278144a68028994838871) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207675))
- [Ensure stage job names are left-aligned](https://gitlab.com/gitlab-org/gitlab/-/commit/33ce46a1f03f1c825c1504010985b4392a26222a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207356))
- [Fix push from CI with LFS](https://gitlab.com/gitlab-org/gitlab/-/commit/18c682a944825322fec8335afe272a8651f0efed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206555))
- [Fix status counts when lifecycles share statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/aad8038c9598cff13431ddfe8ce803f53e0bffdd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207567)) **GitLab Enterprise Edition**
- [Fix styling of duo agent activity log items](https://gitlab.com/gitlab-org/gitlab/-/commit/fa4da28799c36546fc578463e0a1234f2518a6d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207499)) **GitLab Enterprise Edition**
- [Fix the create work item group path for parent](https://gitlab.com/gitlab-org/gitlab/-/commit/70b050ca17be010766a7ba552f51dcdf96ae6487) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207489))
- [Only apply container query in container-and-media if in project studio](https://gitlab.com/gitlab-org/gitlab/-/commit/d4d166956c0075d3b6108e0edaf3e0efbc13c111) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207146))
- [Fix border radii of Rich Text Editor code block bubble menu](https://gitlab.com/gitlab-org/gitlab/-/commit/cfd8198577798957baea70f5d7f2df7f9b0f6256) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207130))
- [Fix work item mobile alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/925352c7b46074efbbc765ffea11b7d695e1ed3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207126))
- [Add include_archived support to Advanced Search work items finder](https://gitlab.com/gitlab-org/gitlab/-/commit/5f86a4bca1945096c7620671f45150cd277fe48c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207406)) **GitLab Enterprise Edition**
- [Fix user popover tooltip tail](https://gitlab.com/gitlab-org/gitlab/-/commit/693a7adc7b89f769db6d738334e17c782659d582) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207456))
- [Fix legacy pipeline table borders](https://gitlab.com/gitlab-org/gitlab/-/commit/bbd49d7b1050e230fdf0be99d92e5210997d3c4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207449))
- [Fix height of work item bulk edit sidebar in panel view](https://gitlab.com/gitlab-org/gitlab/-/commit/c57efcd1452edf2bb2e0ae62c41fad3705bb3b3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207121))
- [Use inset focus for left nav flyout menu items](https://gitlab.com/gitlab-org/gitlab/-/commit/83edc4292f01fda18d173182350c440766fdffbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207324))
- [Fix json validation for elasticsearch_aws_role_arn](https://gitlab.com/gitlab-org/gitlab/-/commit/fc3779eebbdbd628f4e9806372a0ef809d214ac3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207310)) **GitLab Enterprise Edition**
- [Remove non Saas instances from calling CDOT for trial duration](https://gitlab.com/gitlab-org/gitlab/-/commit/5bc8a65dcb3350e7787443eb01fabceb660ed3a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207113)) **GitLab Enterprise Edition**
- [Fix the undefined method id for nil:NilClass in WorkItem](https://gitlab.com/gitlab-org/gitlab/-/commit/48b181f9e5ee520ab39a22a58c29698344562c73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207246))
- [Prevent duplicate project export jobs for same user/project](https://gitlab.com/gitlab-org/gitlab/-/commit/5cef730712ac7bbfdc558fa1acf77ed907b97a31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206684))
- [Adjust height of AI panel when on small screen](https://gitlab.com/gitlab-org/gitlab/-/commit/0ede231713a7557a42b9dcebecfe70e030d4d6f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207178))
- [Hide archived projects from Security Inventory](https://gitlab.com/gitlab-org/gitlab/-/commit/53092e4d73a75da168ee378ddb8b5578bc99c55e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206703)) **GitLab Enterprise Edition**
- [Edge case: make sure thead-only table has bottom border](https://gitlab.com/gitlab-org/gitlab/-/commit/ce9b8c00b1f31f53c41508ce03570c1be8d04d5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207168))
- [Fix the advanced search related metric events](https://gitlab.com/gitlab-org/gitlab/-/commit/1e75708d915702abd808015b093f0edaac7d5ea0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205836)) **GitLab Enterprise Edition**
- [Add time scope to component usage count](https://gitlab.com/gitlab-org/gitlab/-/commit/d5bac541b194adac1d5cab7aef32489879c90a54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206080))
- [Use semantic background color for runner fleet date picker container](https://gitlab.com/gitlab-org/gitlab/-/commit/76a4b4a31435130b47d312d994ab59cab474ecfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207159)) **GitLab Enterprise Edition**
- [Fix pipeline table top borders](https://gitlab.com/gitlab-org/gitlab/-/commit/cbc3d85ca83a87c75b860069c37f9f97a0fe8875) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207156))
- [Fix agent selection bug in duo agentic chat](https://gitlab.com/gitlab-org/gitlab/-/commit/a0cf85fdec5ba6bb8aaa88cdf2c91c4191a87b6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206580)) **GitLab Enterprise Edition**
- [Allow Minimum Access for Saml Group Links API](https://gitlab.com/gitlab-org/gitlab/-/commit/b363d80e78a06cc2710682b6ca0ab00cbaf8d6ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205467)) **GitLab Enterprise Edition**
- [Fix wiki inaccessible when deleting and creating group](https://gitlab.com/gitlab-org/gitlab/-/commit/5f86e54c8b8577cdfe2107ed899a9e493d41e519) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206012))
- [Fix column widths when "fix with duo" pipeline button present](https://gitlab.com/gitlab-org/gitlab/-/commit/703c078b2fe54a6d4e3a55e7b4a6e46f385457de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205935))
- [Return Retry-After header when rate limit is hit](https://gitlab.com/gitlab-org/gitlab/-/commit/ddb3964d2c2161f6b297c742d0fde23af17e3418) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206603))
- [Sort diff file tree entries by key instead of full path](https://gitlab.com/gitlab-org/gitlab/-/commit/35bda43cc4edd64f7d8dbe88192ab29fba19134b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206804))
- [Fix top calculations for paneled view](https://gitlab.com/gitlab-org/gitlab/-/commit/e9ae85cec3b4b71860ba57e027bc612158e5cf28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206978))
- [Remove sort direction tooltip on mouseout](https://gitlab.com/gitlab-org/gitlab/-/commit/661ba0e8048675d2b8c17fef0990ad4685ae2b47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206956))
- [Fix zoekt search for API when elasticsearch is disable](https://gitlab.com/gitlab-org/gitlab/-/commit/fc465bd3c605aaa77995ee8670eac20ca44d4626) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206519))
- [Make CI component inputs table responsive](https://gitlab.com/gitlab-org/gitlab/-/commit/d573970a74dcd2bdbb18f8c414b69e4224ff916f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206730))
- [Add ability to exclude personal projects from policy scope](https://gitlab.com/gitlab-org/gitlab/-/commit/c69f66be3067ce5689fd6b69696991d2136349dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206441)) **GitLab Enterprise Edition**
- [Fix agent selection bug in duo agentic chat](https://gitlab.com/gitlab-org/gitlab/-/commit/003189e93270448c3d7e674103c72f48ea9d4aab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206518)) **GitLab Enterprise Edition**
- [Update the copy text for making default status](https://gitlab.com/gitlab-org/gitlab/-/commit/95793871dd0c81824b38a368217da6db156ab91e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206823))
- [Do not update project.last_activity_at when events are imported](https://gitlab.com/gitlab-org/gitlab/-/commit/65622dab4aeb3994c965fab1c096cacfa1724d02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206105))
- [Enable SHA256 encryption for ActiveRecord](https://gitlab.com/gitlab-org/gitlab/-/commit/3aaf51bd30030b5a81e37b8b98f6876d81a1a0c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206770))
- [Fix position strategy of RTE bubble menus in project studio](https://gitlab.com/gitlab-org/gitlab/-/commit/810bb559ee320961a4f950b34a96f2e0df889d51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206750))
- [Fix sidebar on the deployment page](https://gitlab.com/gitlab-org/gitlab/-/commit/eb26d1546943fa586a8b0e9f2733aa8e18af6f5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206565))
- [Fix CI_MERGE_REQUEST_DIFF_BASE_SHA not updating on branch change](https://gitlab.com/gitlab-org/gitlab/-/commit/cea580773c8de2fb3a823f2e42b9916449da0501) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205670))
- [Ensure design detail overlaps AI panel](https://gitlab.com/gitlab-org/gitlab/-/commit/b09ee6dca6a31fe60781fdb46815cef70f8bc2cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206596))
- [Fix todos page sticky header](https://gitlab.com/gitlab-org/gitlab/-/commit/c6c6e9258c25449f3ff4112223d35561e17ae4b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206590))
- [Fix user dates that do not have detailed times](https://gitlab.com/gitlab-org/gitlab/-/commit/f699b4450711c64f86e57df1d3e22538008e0a9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206108))
- [Remove todo tooltip after click](https://gitlab.com/gitlab-org/gitlab/-/commit/a14c57262de20e449a3ed9c249d7c994964b4b09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206576))
- [Fix the exception when search_type is not a valid option](https://gitlab.com/gitlab-org/gitlab/-/commit/7eb1b6d5940301f466d88e12bd925e819c9de025) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205974/diffs))
- [Enable Delete source branch when creating policy MR](https://gitlab.com/gitlab-org/gitlab/-/commit/8387fec92909c45d47e8e88416deec888c1b8deb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206517)) **GitLab Enterprise Edition**
- [Trigger webhook events for dismissed findings in MR](https://gitlab.com/gitlab-org/gitlab/-/commit/0d442cea719ff2d23132ec3d7c2f5af5bcca467d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206511)) **GitLab Enterprise Edition**
- [Fix buttons on fork modal](https://gitlab.com/gitlab-org/gitlab/-/commit/5e3e9f152a8ea8da21ec8fdf3215adf29d3080e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206443))
- [Keep viewport query for keyboard shortcut column count](https://gitlab.com/gitlab-org/gitlab/-/commit/22f30f7c21332151827a10107e7e466c84bf9f28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206440))
- [Fix reassignment dropdown in CE](https://gitlab.com/gitlab-org/gitlab/-/commit/c345a3070ad296bbfd922e19ec23bbb1faf6fad3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205426))
- [Fix unidiff parameter caching in merge request versions API](https://gitlab.com/gitlab-org/gitlab/-/commit/79c489e82db6f8ac0ae27c0ed666ee98359fc467) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206399))
- [Fix: Add full width to sessions container](https://gitlab.com/gitlab-org/gitlab/-/commit/ee4e30d2cf038e376aae362c3075e2b5581d6330) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206392)) **GitLab Enterprise Edition**
- [Fix sizing and centering of user status emoji in top bar and home](https://gitlab.com/gitlab-org/gitlab/-/commit/af34922f3ba667d29f7dad043267e189781bfe8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205887))
- [Replace correct mixin for licensed feature](https://gitlab.com/gitlab-org/gitlab/-/commit/6b432c086581ae0f2a0c7ccd2315b6dc805747ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206388))
- [Improves terms page](https://gitlab.com/gitlab-org/gitlab/-/commit/9bc99183660bbe735a141a05dff1c86657ab20d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206237))
- [Make sure destination is persisted before passing on](https://gitlab.com/gitlab-org/gitlab/-/commit/e7f988804777be2638657a80052f83c498143305) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206214)) **GitLab Enterprise Edition**
- [Hide group-level prevent-invitation setting for SM](https://gitlab.com/gitlab-org/gitlab/-/commit/3c22789c33019d931d3255d87ee0e2ede0f1b00d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206165)) **GitLab Enterprise Edition**
- [Improve performance of compliance framework dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/3bb5ee1005ccd39e667def9f42263e961152e1e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206153)) **GitLab Enterprise Edition**
- [Fixed z-index for duo-chat-layout](https://gitlab.com/gitlab-org/gitlab/-/commit/c07d27b511165a129a11358f4ea54f7764767fe0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206027)) **GitLab Enterprise Edition**
- [fix: Allow project maintainers to read runners in the Project Settings](https://gitlab.com/gitlab-org/gitlab/-/commit/ec33e0c3e5cc5da392dad11a1bcebc75f2ceecea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205835))
- [Remove gap under tabs on MR creation page](https://gitlab.com/gitlab-org/gitlab/-/commit/04e83fd027898183f532d649754b268e44e6a7a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206088))
- [Fix background colors for work item "drawer" view](https://gitlab.com/gitlab-org/gitlab/-/commit/719874e7f7503c1b4acdeeffd5a7ac9543b5293e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206084))
- [Fix incorrect top value for breadcrumbs on new namespace pages](https://gitlab.com/gitlab-org/gitlab/-/commit/b8cea26985c50a7fa48e585e1be56e9041815d18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206079))
- [Fix scrollbar background for dropdowns](https://gitlab.com/gitlab-org/gitlab/-/commit/db389e1cfe08c2c70614a3db639c89c8403227af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206077))
- [Fix margins on pinned section flyout](https://gitlab.com/gitlab-org/gitlab/-/commit/82c9d1ab1be53bc211c6d02a58e9cde0f324c196) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206071))
- [Do not use GlLabel for "None" and "Any" in label token](https://gitlab.com/gitlab-org/gitlab/-/commit/2dc94a1d39ea48bdc6df8fbd0eb740610d5f8188) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206054))
- [Do not use container queries for design details fullscreen modal](https://gitlab.com/gitlab-org/gitlab/-/commit/38b969827474f43bca2ae683b9d8598dc21cfc8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205936))
- [Set organization_id on update of JiraConnectInstallation](https://gitlab.com/gitlab-org/gitlab/-/commit/cb0976b8d64c9eb9109c1c63e4110f34d0e12226) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206009))
- [Added safety chaining to pipeline helper](https://gitlab.com/gitlab-org/gitlab/-/commit/075ec77cdfe48ca720ed50d8849237ace320143f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205982)) **GitLab Enterprise Edition**
- [Fix sticky header of Vulnerability list](https://gitlab.com/gitlab-org/gitlab/-/commit/cfe4b8222f746acedd0596cdffdf55e2972f7da5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205949))
- [Fix black edge on MR comment thread corners](https://gitlab.com/gitlab-org/gitlab/-/commit/c3bfd730cac6b06122af2a01ac5e2da747d5eae2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205947))
- [Fix radii of MR thread nav buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/ed396297cbe392532474b4394620d737e6899fb7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205942))
- [Use isUnsafeLink for xcode protocol](https://gitlab.com/gitlab-org/gitlab/-/commit/adad779dd145697d6bb9c426060f73cb23b578f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205891))
- [Improve test configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/fbbad9189ea68894e68437b24d89adcea83bec37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205898)) **GitLab Enterprise Edition**
- [Fixes full screen toggle not working for boards in new UI](https://gitlab.com/gitlab-org/gitlab/-/commit/9420996c039b2354d16b2523b466ebfe9653a0db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205475))
- [Fix border radii on emoji picker buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/c3226df1ff3dfc227a0a12508b0385938186aa0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205894))
- [Fix secret push protection IndexError during tree traversal](https://gitlab.com/gitlab-org/gitlab/-/commit/878386dc11bfda7db7348c070ef0829e99e884ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205823)) **GitLab Enterprise Edition**
- [Fix a11y featured card focus indicator vis](https://gitlab.com/gitlab-org/gitlab/-/commit/c2ce6973604b5efdd235f6daed0630eac6330e84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204913))
- [Fix: no implicit conversion of String into Array](https://gitlab.com/gitlab-org/gitlab/-/commit/9a6f09fef9d55d36b9cf83e0188956e3aac49a41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205840)) **GitLab Enterprise Edition**
- [Add the vue router to the epic boards](https://gitlab.com/gitlab-org/gitlab/-/commit/0eb33f5e16de86ce2db81b2370227af2d10ee4f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205815))
- [Revert "Merge branch 'tbulva-duo-rail-old-layout' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/1b1b1d59dee0a6de3c263a08280db1c634c54d99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205758))
- [Fix: hide pagination in agent sessions](https://gitlab.com/gitlab-org/gitlab/-/commit/deb7619b5f1fa2ec2f5e2089799551a380db5479) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205304))
- [Make boards full bleed inside panels](https://gitlab.com/gitlab-org/gitlab/-/commit/03cabcb251706fc504811caad032ef702ef4500d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205738))
- [Fix Create Group and Import form error messages](https://gitlab.com/gitlab-org/gitlab/-/commit/8108937484922ab32311e385666050abb3e38704) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204414)) **GitLab Enterprise Edition**
- [Fix CORS config for /oauth/token/info](https://gitlab.com/gitlab-org/gitlab/-/commit/dafb7dabf3c8f3b981c3edceee3b8678ed66acee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205665))
- [Fix reverification error](https://gitlab.com/gitlab-org/gitlab/-/commit/17e0fc04e7968ec3dbd1fb53d5ebfec0b9c40293) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205710)) **GitLab Enterprise Edition**
- [Fix sticky position of Job page troubleshoot bar](https://gitlab.com/gitlab-org/gitlab/-/commit/a3267018b6a46bc55e09a8abeda103a8a8bdb554) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204944))
- [Fix Admin button URL on Geo secondary](https://gitlab.com/gitlab-org/gitlab/-/commit/cdd2e84533647ed5d4061dc1c0b419e57b4b0627) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202809))
- [Display correct code owners when viewing a tree](https://gitlab.com/gitlab-org/gitlab/-/commit/ecc9f730dd72d05a8c2e9efb9074c6c055dae51e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205537)) **GitLab Enterprise Edition**
- [Remove group-level checks for Agentic Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/a1c065257cbde1b15a6f953c884b340545989549) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204817)) **GitLab Enterprise Edition**
- [Fix Import CSV in work items list empty project](https://gitlab.com/gitlab-org/gitlab/-/commit/9dbe30328c77c2f05ec07948cf0e4185597ad179) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205217))
- [Fix perform_async symbol parameter](https://gitlab.com/gitlab-org/gitlab/-/commit/cc56c65900648bd2c22789bf8c2f968b96ade449) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205394)) **GitLab Enterprise Edition**
- [Allow elastic client adapter to be set](https://gitlab.com/gitlab-org/gitlab/-/commit/4e3347a8798f477cd477f59821b0d9bb6a2a2664) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204437)) **GitLab Enterprise Edition**
- [Show private group in approval rules](https://gitlab.com/gitlab-org/gitlab/-/commit/cdf94e9fededcca617702d9f492002e652c59eea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203738)) **GitLab Enterprise Edition**
- [Ensure rounded-full buttons do not get set to rounded-r-lg](https://gitlab.com/gitlab-org/gitlab/-/commit/b2d3003cf6abc65d875d3e68d02b0a0f990f7dd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205287))
- [Fix Whats New a11y tab scrolling](https://gitlab.com/gitlab-org/gitlab/-/commit/c2efa903b5273f44853ec4c847650433d9a2b553) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204939))
- [Fix cache for no_active_sso_session](https://gitlab.com/gitlab-org/gitlab/-/commit/8eac0fd5d7712c9174b839d98492b6db49c6972a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205226))
- [Sync MR approval policy approvals after pipeline completes](https://gitlab.com/gitlab-org/gitlab/-/commit/908bf1055aa7bc93a6ef13c92525e1ea67cff01c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204358)) **GitLab Enterprise Edition**
- [Optimize HandleMalformedStrings middleware for CPU and memory](https://gitlab.com/gitlab-org/gitlab/-/commit/07b55bb3b52118037ffa7630f8ff22062270cd16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205171))
- [Set sharding key when missing on note markdown cache update](https://gitlab.com/gitlab-org/gitlab/-/commit/b9e9e98b832f65d6f61f356cd92ca1fd44d04a46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205125))
- [Fix protected branch selector "all protected branches" label](https://gitlab.com/gitlab-org/gitlab/-/commit/db5ee34b857a465eb4c83ac082a07798c5ab0ca9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205119)) **GitLab Enterprise Edition**
- [Improve performance of framework selection box](https://gitlab.com/gitlab-org/gitlab/-/commit/4e77af992ea02c4fa05e22f2fec3954663541d9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205057)) **GitLab Enterprise Edition**
- [Return empty result instead of 400 when search is empty for autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/a585dcaec775bb43d91cb49efc6ad20565f7b3a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205096))
- [Fix error when applying scanner suggestion](https://gitlab.com/gitlab-org/gitlab/-/commit/d7a6c3a198e4d142731d22a68885218b6fc729b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205124)) **GitLab Enterprise Edition**

### Changed (178 changes)

- [Fix bug in UserJWT CEL policy for Secrets Manager](https://gitlab.com/gitlab-org/gitlab/-/commit/bc70d9aabdbd019fe39bb0cc0c397b0814f1303b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204174)) **GitLab Enterprise Edition**
- [Add virtual registry setting toggle and call graphql query and mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/17f115e69e1221f4b63fee28c8270315226cbb76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203628)) **GitLab Enterprise Edition**
- [Show six months of data on the Value Streams Dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/d69250edf6030b7bdd0227d2fd68fcb4ef440b27) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206417)) **GitLab Enterprise Edition**
- [Update docs for GitLab managed keys for codex](https://gitlab.com/gitlab-org/gitlab/-/commit/f59d3f94d86edb31145a6529c6502c890a26e9de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208558)) **GitLab Enterprise Edition**
- [Feat: add search to agent sessions](https://gitlab.com/gitlab-org/gitlab/-/commit/6799e01936243e9299f54deb9bd669006e7c26e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206267)) **GitLab Enterprise Edition**
- [Add legacy onboarding experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/f06785a850bb5a1d0036e1470644d2b43fa17e27) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207352)) **GitLab Enterprise Edition**
- [Add documentation for warn more policy](https://gitlab.com/gitlab-org/gitlab/-/commit/f76882dc9ef66f051dbb79c2d17e232726f4b837) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208200))
- [Use committer_email to check for commits](https://gitlab.com/gitlab-org/gitlab/-/commit/9238bfe336b9b00ef6cacaebb4170a5e7da6792a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206371))
- [Add new pipeline type fields](https://gitlab.com/gitlab-org/gitlab/-/commit/005fff7b6a326caf671b3e9e58f270fd0e505979) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207476))
- [Adjust issue empty state action buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/e661c45d13f4dbc5f8480f28a9950663884364fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207127))
- [Update maven virtual registry entry link text](https://gitlab.com/gitlab-org/gitlab/-/commit/92263254a6a5db7244e91115a801aeeeecf168e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208456))
- [Increase duo flow expiration time](https://gitlab.com/gitlab-org/gitlab/-/commit/5160d3b052a4ba60d25da1dba6b6f0a4e4b1d6c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208440)) **GitLab Enterprise Edition**
- [Adding UUID to vulnerabilities table](https://gitlab.com/gitlab-org/gitlab/-/commit/a8187cc794c900a18aaec6374f6afc0877141b46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207103)) **GitLab Enterprise Edition**
- [Note warn-mode approval setting overrides in bot comment](https://gitlab.com/gitlab-org/gitlab/-/commit/84881f94a4bf79cc1f7d004a120f2de970062e9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208075)) **GitLab Enterprise Edition**
- [Show Duo Chat outside of project/group context](https://gitlab.com/gitlab-org/gitlab/-/commit/c7f35c5fb2ff23d07d75860249db602a67754239) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208061)) **GitLab Enterprise Edition**
- [Set secret push protection enabled to true for public projects](https://gitlab.com/gitlab-org/gitlab/-/commit/832bc072b15122fb991d5fb2144c411ac16d7283) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207017))
- [Show Duo Chat outside of project/group context](https://gitlab.com/gitlab-org/gitlab/-/commit/5947ae9bde3070b31b516e31b42ad4c969a52549) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207242)) **GitLab Enterprise Edition**
- [Update UI text for changing vuln severity](https://gitlab.com/gitlab-org/gitlab/-/commit/af35c49b01870f013bf05cabcbb3cc95f68febbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208420)) **GitLab Enterprise Edition**
- [Remove duo_chat_dynamic_dimension feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3aa37de18d9c9fe97334a402a803784923a3b25f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204809)) **GitLab Enterprise Edition**
- [Enable mirroring_lfs_optimization FF](https://gitlab.com/gitlab-org/gitlab/-/commit/00e63c772ee1fea69d15c77d27b67c854e8e5559) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208234))
- [Enable ai_duo_agent_fix_pipeline_button feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/fdd2cf1550f975b6b67abf31c7058530ceef28c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205086)) **GitLab Enterprise Edition**
- [Add ids argument to graphql query](https://gitlab.com/gitlab-org/gitlab/-/commit/23a0a158e6e975e4ee7eccc3480390af86518f79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208215)) **GitLab Enterprise Edition**
- [Add feature flag to disable minimum project checks for traversal ids](https://gitlab.com/gitlab-org/gitlab/-/commit/d0c9bb1f4a3df62ea0eedb58ebb211a0d41f0be2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208205)) **GitLab Enterprise Edition**
- [Provide ExpectedOldOID to UserRevert request](https://gitlab.com/gitlab-org/gitlab/-/commit/5828a72f02013310b3bb4a1e0d9c258175f3d3ea) by @edith007 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202811))
- [Update param desc linter](https://gitlab.com/gitlab-org/gitlab/-/commit/43badba129ed5ff2c56c247f1bf2ab828c83118f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208206))
- [Add loading of users](https://gitlab.com/gitlab-org/gitlab/-/commit/ee82b7df52ad3e6e24489d755a49b1b168fe8abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208130)) **GitLab Enterprise Edition**
- [api/pipeline: Expose `archived` field through the API](https://gitlab.com/gitlab-org/gitlab/-/commit/fcf18483b701bdf47a11f4089fd1a3438263b50f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207633))
- [Add ids argument to graphql query](https://gitlab.com/gitlab-org/gitlab/-/commit/c78328eabceb6dc254a6cd122f32dd693fac0c80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207452)) **GitLab Enterprise Edition**
- [Add CI OIDC claims to discovery endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/73ea30c28bdce5a5ec42109dc52cbf73e481f76c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207847))
- [Improve group overview tabbed lists](https://gitlab.com/gitlab-org/gitlab/-/commit/c9baff348d1f505337388815b702e3c068a554be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208044))
- [Adjust aws documentations for the oidc advice](https://gitlab.com/gitlab-org/gitlab/-/commit/f6fa71d6739c17f326662e5c36b56bf4840a3cea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207708))
- [Remove security_inventory_dashboard feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6fc44432f79a350f2d732c2f67f9d8138e491e7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204984)) **GitLab Enterprise Edition**
- [Sync MR approvals after dismissing finding for MR](https://gitlab.com/gitlab-org/gitlab/-/commit/4f2b92dab18924291ace7a7a726d9c2f7166e813) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206043)) **GitLab Enterprise Edition**
- [Clean up :ai_catalog_agent_tools feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8420841996018b70bd53e71a10a9a3d60ac89758) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208225)) **GitLab Enterprise Edition**
- [Remove feature flag to hide no longer detected vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/16e41e0a475e17e09fd258376759cd2ec0b0e9ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208218)) **GitLab Enterprise Edition**
- [Group custom role permissions by category](https://gitlab.com/gitlab-org/gitlab/-/commit/8004b60316542f8764099664788ce42e93a249a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205303)) **GitLab Enterprise Edition**
- [Refine styling of the search bar](https://gitlab.com/gitlab-org/gitlab/-/commit/0499a577247283f57521d7fcd3baab5f8f9f32af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204389))
- [Add refresh token logging](https://gitlab.com/gitlab-org/gitlab/-/commit/2f28b7adf918d2c4d272ba05b494c404bf564def) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207331))
- [Update fix_pipeline to v1 definition](https://gitlab.com/gitlab-org/gitlab/-/commit/64023e7434cb7abf2989a432a52160a8742a76b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208079)) **GitLab Enterprise Edition**
- [Add v2 of Dependency Scanning template](https://gitlab.com/gitlab-org/gitlab/-/commit/f074e67075d5b74791d5c6c75e32753952c4f3f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193526))
- [Merge additional properties and identifiers for Snowplow](https://gitlab.com/gitlab-org/gitlab/-/commit/0a056e9dec277c4e6db766dadb90b967f3d4e785) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208043))
- [Update virtual registry gates to check that virtual registry setting is enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/39e8b726e2423b0fbe2c0ddaca9420ae94f1b678) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204305)) **GitLab Enterprise Edition**
- [Cleanup webauthn feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dfca6ed3aa133df90301085c05c15e65ff77169b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206800))
- [Add Duo Agent Platform settings to self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/92c7e5d236f6b9a6a576b766c371a7ccde981d5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207860)) **GitLab Enterprise Edition**
- [Change the name of Duo service account](https://gitlab.com/gitlab-org/gitlab/-/commit/0fdf265e6e6ac0e7452d8446065c6af5243f710c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207853)) **GitLab Enterprise Edition**
- [Split pipeline logic from MergeRequests::RefreshService](https://gitlab.com/gitlab-org/gitlab/-/commit/611adf93eb9b3642789668204824881ee7e27f04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203431))
- [Adds client timeout to Topology Service Client](https://gitlab.com/gitlab-org/gitlab/-/commit/4f587ef83722aab63be971c31c2a15ad259c6cf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206893))
- [Fix Web IDE language server in Firefox](https://gitlab.com/gitlab-org/gitlab/-/commit/ad4236996d0dc49deb03e25f6afd7ba256e26735) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207803))
- [Fix duo chat panel positioning](https://gitlab.com/gitlab-org/gitlab/-/commit/9541415452c4c63f882fce9a110471a2426d9327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207767)) **GitLab Enterprise Edition**
- [Track GitLab token verification with last_verified_at](https://gitlab.com/gitlab-org/gitlab/-/commit/402bed9d8d66731fe5791fce250f5cb0b129ef3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207670)) **GitLab Enterprise Edition**
- [Add v2 of Dependency Scanning template](https://gitlab.com/gitlab-org/gitlab/-/commit/cca1225b8ec97a354c663c27ca389cc40d6bf445) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201175))
- [Update dependency auto-deploy-image to v2.132.0](https://gitlab.com/gitlab-org/gitlab/-/commit/bb7b82d13b7a0db0596505e65d42c24372a8fa75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207754))
- [BlobViewer::Markup includes commit_id as :ref in Banzai context](https://gitlab.com/gitlab-org/gitlab/-/commit/fed88ee57ab7d2bc5a946809838e1078c6d4e4a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206664))
- [Traversal id search only for groups with large amount of projects](https://gitlab.com/gitlab-org/gitlab/-/commit/6e62caf907e5e74e8af264d382c45a7ba7c6de9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205395)) **GitLab Enterprise Edition**
- [Fix date format consistency in Chain of Custody Report](https://gitlab.com/gitlab-org/gitlab/-/commit/3906f7469a1068cec0af70e503db9fe47379d57b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207201)) **GitLab Enterprise Edition**
- [Resolve text overcrowding in compliance dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/068ea5abe37e23bd2d8c2e77013bce68be2f2ca0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207571)) **GitLab Enterprise Edition**
- [Extend notifications and audit events for OTP and WebAuthn disablement](https://gitlab.com/gitlab-org/gitlab/-/commit/491c4e85c59b44a55d581e394eb5dd9569e659ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206605)) **GitLab Enterprise Edition**
- [Increasing the concurrency of Ci::DeleteObjectsWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/07036177525e24c0cd5eb0a1de57df9a75e10c82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207715))
- [Refactor pipeline composite identity check](https://gitlab.com/gitlab-org/gitlab/-/commit/19af513854caf5477f39ccc7735cd916fdd8c587) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207686))
- [Add missing aria labels](https://gitlab.com/gitlab-org/gitlab/-/commit/5a45c2c2edb531f6f1dbfa782641b90cdc755918) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207097)) **GitLab Enterprise Edition**
- [Revert user tooltips displaying counts](https://gitlab.com/gitlab-org/gitlab/-/commit/510a696f4980f38bb2e2e6d0ec7414080f0ee89c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207101))
- [Only track CSP configuration policy sync state](https://gitlab.com/gitlab-org/gitlab/-/commit/5f3aeb4ce3777ff23f51b5bce4c4c05feed985cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206516)) **GitLab Enterprise Edition**
- [Remove web_ide_language_server feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e69997bd41f94c2b3769efc1992cb05cb50df56a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207606))
- [Update sign up / sign in page headers](https://gitlab.com/gitlab-org/gitlab/-/commit/026a79f70c7bef35ebefa772df9d42a8b4f45126) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206783)) **GitLab Enterprise Edition**
- [Fix Geo Warning](https://gitlab.com/gitlab-org/gitlab/-/commit/fc0e4314e2879bd032243ae82d9bee832151a253) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207277))
- [Update to modern docs URLs](https://gitlab.com/gitlab-org/gitlab/-/commit/60707255b350d2bc9c8f0c6655f47b3f14c8f321) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207379))
- [Optimize component typeahead queries](https://gitlab.com/gitlab-org/gitlab/-/commit/92e62663e1eb11dfdb81e649645a132dbbe3534e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206283)) **GitLab Enterprise Edition**
- [Group billing page redesign](https://gitlab.com/gitlab-org/gitlab/-/commit/df8e2f13dd76b10dbe8b0fe3218f920166c51d7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206487)) **GitLab Enterprise Edition**
- [Subsribe project tracked refs creation to ProjectCreatedEvent](https://gitlab.com/gitlab-org/gitlab/-/commit/ffd5f964d8020fb0f3e4ca9a73cf8d4afaf348bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206604)) **GitLab Enterprise Edition**
- [Remove FF read_from_new_ci_destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/699bea95fd56c41ef7541893619007c72938b9d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206763))
- [Add new_uuid to vulnerability_occurrences](https://gitlab.com/gitlab-org/gitlab/-/commit/29a2947fb44ecf1c44fd539a095b96bbbf94ba76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207273)) **GitLab Enterprise Edition**
- [Move preview inputs action to the right](https://gitlab.com/gitlab-org/gitlab/-/commit/3cf01f5ce4c5c65e7fcb46c09bb1508e56204857) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206841))
- [Remove redundant additional_context](https://gitlab.com/gitlab-org/gitlab/-/commit/ac7bd6cf7b3c53dd6d37c27c0cd0d9ea58ed9d22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206337)) **GitLab Enterprise Edition**
- [Retry bigint column swaps on merge_request_diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/0bc178cff98d29894e30cdabd8d300794d6aa79d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204798))
- [Disable approval setting override in warn mode](https://gitlab.com/gitlab-org/gitlab/-/commit/8feaa48df38555b7a75e153cc0a7903aaf56dc56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206758)) **GitLab Enterprise Edition**
- [Create new Geo verification state table for CiPipelineArtifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/d347d0d5bfe12e5b2b5f9e4c64c2b242f848d2d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182266)) **GitLab Enterprise Edition**
- [Improve issue empty state to help new user](https://gitlab.com/gitlab-org/gitlab/-/commit/1d57523c623fdcd0138e7adcd1978201c54e60fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205399))
- [Remove unknown licenses from sbom dependency list export](https://gitlab.com/gitlab-org/gitlab/-/commit/b5d4e5c1cb78b1bcc01184c68702afc1687f1d3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206598)) **GitLab Enterprise Edition**
- [Run prepared async statements synchronously](https://gitlab.com/gitlab-org/gitlab/-/commit/1cec6aa58b6d130e95762acbf3ecdc3f6f750bf5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202112))
- [Change additional_context to new category](https://gitlab.com/gitlab-org/gitlab/-/commit/15b6a1566f22eff85fd6d98c0aadcb1f771b791d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206338)) **GitLab Enterprise Edition**
- [rules/rule/changes: Use changed paths](https://gitlab.com/gitlab-org/gitlab/-/commit/0ea8daa2466d6477ff1c738087134711d58814ff) by @johnwparent ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199608))
- [Only show admin shortcut when authorized to visit](https://gitlab.com/gitlab-org/gitlab/-/commit/d4e63708fb5757a8a5c28922830024c23e309fd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206754))
- [Remove feature flag  new_security_dashboard_vulnerabilities_per_severity](https://gitlab.com/gitlab-org/gitlab/-/commit/64e74295cf7ca48277244fe47a24903577755a22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207140)) **GitLab Enterprise Edition**
- [Default enable admin_groups_vue feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fe14114e64dae6e37303eb162ba06f8968d1dfa1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206990))
- [Update SPDX license list to 3.27.0](https://gitlab.com/gitlab-org/gitlab/-/commit/dde10339365a702d788da18168ac2bf3c4756f80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207181))
- [Hide widget collapse tooltips on mouseout](https://gitlab.com/gitlab-org/gitlab/-/commit/351bc2642fbbbbe7e5f322cefb2fd24a75c38b2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206954))
- [Reducing vulnerability export batch size to 100](https://gitlab.com/gitlab-org/gitlab/-/commit/0d3cb99b2f2c66d8786f90acc62b1597ee4e86e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207081)) **GitLab Enterprise Edition**
- [Switching security_bot to use for_organization](https://gitlab.com/gitlab-org/gitlab/-/commit/5c8ea66c76b3c84d7b899ea3c7973f9cdb038625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203218))
- [Make bitbucket server page mobile responsive](https://gitlab.com/gitlab-org/gitlab/-/commit/de386c79f2493366ca590ff693eb1bfb3139eb93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206661))
- [Set reverse_lock_order: true to avoid deadlock](https://gitlab.com/gitlab-org/gitlab/-/commit/6ba66730a9f76c46786130a0ff5d9225cfcc6d9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206877))
- [Remove autoresize prop from registry breadcrumbs](https://gitlab.com/gitlab-org/gitlab/-/commit/fd4cf897cc75452e7ffbd9efd03300ee50890a98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207001))
- [Use the same terms for creating a new item across all Automate pages](https://gitlab.com/gitlab-org/gitlab/-/commit/c3abb5ea6e434e174e2afeff449271f534054067) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206846)) **GitLab Enterprise Edition**
- [Adjust gutter logic for smaller viewports and alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/8c0492fa49afd63378543f8f20c8aa2b9d4a887d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206955))
- [Enhance navigation sidebar flyout to support pen/stylus pointer](https://gitlab.com/gitlab-org/gitlab/-/commit/d88117cdcac0d23bf88178aef88460289686306d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206179))
- [Add organization_id to admin_roles table](https://gitlab.com/gitlab-org/gitlab/-/commit/54bca8ef2e398eb6da06d1402664691666715321) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206073))
- [Remove ci_improved_destroy_old_pipelines_worker feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/608c00fd8097db7338a0ab3d01570c824762face) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206868))
- [Update copy on merge request empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/e697292a5092670a85e205937e0045cef9153458) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206581))
- [Update Rouge to 4.6.1](https://gitlab.com/gitlab-org/gitlab/-/commit/ea9a7a2763c9a3e17e7e2d6855a39efda7fb9b62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206839))
- [Flag `ai_catalog_agent_tools` default enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/aaddf9fad5c0a0dba6636582991244aedc41dd1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206141)) **GitLab Enterprise Edition**
- [Default search_notes_use_membership_filter to true](https://gitlab.com/gitlab-org/gitlab/-/commit/2b76a1d67e1f80813e860b7dd1ee36e0d4cf0ad2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206799)) **GitLab Enterprise Edition**
- [Write CI job data to new database destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/589a644d99624231d7489c82b345b8570ecb8632) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206759))
- [Added accessible labels to issue board icons](https://gitlab.com/gitlab-org/gitlab/-/commit/b4fa7773f92e0884c462ff8c58e31068fc4d679d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200533))
- [Writing to new static security training column](https://gitlab.com/gitlab-org/gitlab/-/commit/83553bb743e656f1e866bf9afb45dd42d462c1b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204534)) **GitLab Enterprise Edition**
- [Hide hamburger menu tooltip](https://gitlab.com/gitlab-org/gitlab/-/commit/08309c97eaa652fdfe839bb608d8138a343caed6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206720))
- [Update dependency auto-build-image to v4.12.1](https://gitlab.com/gitlab-org/gitlab/-/commit/db2977845bb1dc6a5516a142230d691ddf1f9ee9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206670))
- [Return 0 approvals required for dismissed rules](https://gitlab.com/gitlab-org/gitlab/-/commit/9dbef856096044a3e484f01af6147ce50e2f0fd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206648)) **GitLab Enterprise Edition**
- [Add uniqueness validation for object_storage_key for npm metadata cache](https://gitlab.com/gitlab-org/gitlab/-/commit/43b968896063ec714b6569ac09fe6ce07c67eb86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206155))
- [Remove diff expansion background colors](https://gitlab.com/gitlab-org/gitlab/-/commit/b53fd1310f255eafccfc1875edade8ec9f5fb9ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206439))
- [Increase the border radius of the flyout menu](https://gitlab.com/gitlab-org/gitlab/-/commit/1b3c2ed79158426f0154805ac270a171ad076d69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206245))
- [Update conversion items styling inside user menu](https://gitlab.com/gitlab-org/gitlab/-/commit/cb75f58efd612254bf02d97c2ed7aef95d5cb2e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206215))
- [Support configuring Duo Flows in triggers on Backend](https://gitlab.com/gitlab-org/gitlab/-/commit/e61f733b55920baba1112772689e9324063beeee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206014)) **GitLab Enterprise Edition**
- [Change uniqueness validation for vregs entries](https://gitlab.com/gitlab-org/gitlab/-/commit/07bf56cb9d053f621975cc1a3e00f66bfbc3729f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205808))
- [Update graphql descriptions to use backticks when needed](https://gitlab.com/gitlab-org/gitlab/-/commit/cfd39e86e064e3c43a9bd9e3c797f594c57324eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206476))
- [Update Duo usage table metric descriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/756628518170036a926c9feb818ebce27d430b6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206143)) **GitLab Enterprise Edition**
- [Add `securityPoliciesSyncStatus` GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/18440eb64078f3295efe2367aee4f91d82678f67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202375)) **GitLab Enterprise Edition**
- [Update code suggestions single tile definition](https://gitlab.com/gitlab-org/gitlab/-/commit/e1984c3ce3f9e573e1325daaa6c318cfdc73417d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204838)) **GitLab Enterprise Edition**
- [Adjust "Run pipeline" responsive behavior](https://gitlab.com/gitlab-org/gitlab/-/commit/8191879d454aa39bdda16b88ca750ac388fcda92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206382))
- [Feat: Add excludeTypes to graphql in user agent sessions](https://gitlab.com/gitlab-org/gitlab/-/commit/6130199896fa4bfb2a204f3c93d77124cc749f4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206252)) **GitLab Enterprise Edition**
- [Update error on branch creation failure](https://gitlab.com/gitlab-org/gitlab/-/commit/11e45cde7bcc6a1060d21a01c99ce7fa54bf1201) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204873))
- [Disable chat when agent is deleted in Duo Agentic Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/9b4d934520377efc3d85a55d6e2643b203d85542) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206320)) **GitLab Enterprise Edition**
- [Remove unused author email column from gpg signatures table](https://gitlab.com/gitlab-org/gitlab/-/commit/15f35cf815b7f4cb00d94c35a9b7f2c76022adbd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205561))
- [Remove read_admin_groups feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e0c16726de03d666a7638256c7057d431a2bc32b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205800))
- [Hide flows from Global Search when flag disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/824c8a04423cd4725e949fa73ad30db3e67d97d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206142)) **GitLab Enterprise Edition**
- [Feat: UX improvements for agent sessions](https://gitlab.com/gitlab-org/gitlab/-/commit/fe358bab058161afe6dd803ffb0b3a362c93bf3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206068)) **GitLab Enterprise Edition**
- [Hide no longer detected vulnerabilities on the dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/9bbfc6a88dfa49804f8ee56752ea342b84d27410) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206275)) **GitLab Enterprise Edition**
- [Add tooltips in help center](https://gitlab.com/gitlab-org/gitlab/-/commit/8c7134213e43d6fb4d7075ae1da863cda07854ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206254))
- [Set max width on search bar](https://gitlab.com/gitlab-org/gitlab/-/commit/3421c7a72c31d914bb607a42298f2ef62f66ce75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206249))
- [Remove documentation links from search admin UI](https://gitlab.com/gitlab-org/gitlab/-/commit/bb5a10f312195d3a6b48dfc769897222cf48aefc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205143)) **GitLab Enterprise Edition**
- [Remove database counter logging from mergeability framework](https://gitlab.com/gitlab-org/gitlab/-/commit/4e3a622dd207a88e0527bd9602002474c02cb903) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206178))
- [Update work items widget](https://gitlab.com/gitlab-org/gitlab/-/commit/6a300f74a0cf092fd11c18c1f80fcd32d0a5837f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205584))
- [Remove FF for group packages finder refactor](https://gitlab.com/gitlab-org/gitlab/-/commit/f7278f920e0bdbb0a4022560d917a0fe43438b96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206162))
- [Improve title copy for user status form emoji picker](https://gitlab.com/gitlab-org/gitlab/-/commit/87ffdeb056f5476fcf8893eeb2dcccc282f7706a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206086))
- [Project zoekt search only uses one node](https://gitlab.com/gitlab-org/gitlab/-/commit/4363bf30e9dbd9699c7085a7274f093073bac1be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204877)) **GitLab Enterprise Edition**
- [Expose the original severity in response from Vulnerabilities API](https://gitlab.com/gitlab-org/gitlab/-/commit/827122d9dab6fd813644ec0b258e234292261035) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203312)) **GitLab Enterprise Edition**
- [Add skip_verification_for_now route, action and specs](https://gitlab.com/gitlab-org/gitlab/-/commit/e94d3bb5bb5d6e0eaaa8d434e5b9fa3823e73737) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205447))
- [Update AiMetrics codeSuggestions fields](https://gitlab.com/gitlab-org/gitlab/-/commit/b5538367e4b803e5d06df93535feb884c7054fa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205725)) **GitLab Enterprise Edition**
- [Add structured tracking to project repo actions](https://gitlab.com/gitlab-org/gitlab/-/commit/4e128b7abf374967b2262fbe89d636cf72c6ec90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201841))
- [Remove import in progress alert from get started page](https://gitlab.com/gitlab-org/gitlab/-/commit/f2297e4ddfd5a8ab869511bd2abad9e234c88d7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205959)) **GitLab Enterprise Edition**
- [Add user_enable_two_factor email notifications and audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/898863a42f897204f5776b2bcc69139f993026c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204794)) **GitLab Enterprise Edition**
- [Update docs for unsupported package in dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/65663593312aef32e3a46af186633af95fde3c84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206005))
- [Change uniqueness validation for NuGet symbols](https://gitlab.com/gitlab-org/gitlab/-/commit/6e58e2da8b8ef9f822a7bb4a78a98ffa8b90cdaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205983))
- [Add AI false positive tracking fields to v11y_flags](https://gitlab.com/gitlab-org/gitlab/-/commit/8b17f48cf4c99a4c440c650730b377ba7c96e0d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205444)) **GitLab Enterprise Edition**
- [Remove custom_ability_read_admin_projects feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c25ca70a7466c6579bd5d8e346a92af99cf10f4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205794))
- [feature: Create new Geo verification state table for PackageFile](https://gitlab.com/gitlab-org/gitlab/-/commit/1fa411c87b79b119d15b7fef80c7e238a4432216) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200875)) **GitLab Enterprise Edition**
- [Validate label_links target and label on import](https://gitlab.com/gitlab-org/gitlab/-/commit/2c0b1e9bbdd889a560ec9775b67dccbad35fd61e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203740))
- [Remove active vulnerabilities feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f86bff16bf0ccad2c13f90e959bb664ff0ff9caf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205449)) **GitLab Enterprise Edition**
- [Remove author email column from the ssh signatures table](https://gitlab.com/gitlab-org/gitlab/-/commit/a33585c68d5728b61cbf314f07dcd7d1e388f442) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205564))
- [Table prep security_trainings for static data](https://gitlab.com/gitlab-org/gitlab/-/commit/7919e46ced2e9b71c9e0113bb533d8f0a78cbf52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204205))
- [Remove highlight in query for notes](https://gitlab.com/gitlab-org/gitlab/-/commit/f0c135b34f907f648be123bd9f853c3ad00b8cab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205474)) **GitLab Enterprise Edition**
- [Respect user color mode on error pages](https://gitlab.com/gitlab-org/gitlab/-/commit/60795571f9d100dbfb55f51c4265a96710a52b20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203768))
- [Make Ci::DestroyOldPipelinesWorker better churn over the pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/2cedf33ed110a244e2ea3de18bcc70253632ea67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204039))
- [Refine UI text and alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/4624032ef341bce5bdb5396a8a965fa662fb4167) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205088))
- [Drop trailers column](https://gitlab.com/gitlab-org/gitlab/-/commit/e4b5ed42e5f10e536fa9e4988277e678ade201e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205853))
- [Remove runtime schema validation error from CDX SBoM report export](https://gitlab.com/gitlab-org/gitlab/-/commit/c3649732e6083e5418c4ee5a379097e2e8c42e1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204912)) **GitLab Enterprise Edition**
- [Fix fluid/fixed layout classes for MR diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/8f460d408baab73a13d63c44512b79ab4d52a623) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205128))
- [Add support for container specific poststart events](https://gitlab.com/gitlab-org/gitlab/-/commit/7b925338e75a968a88a1c1d0b846311802d09ac3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198027)) **GitLab Enterprise Edition**
- [Improve conan packages search](https://gitlab.com/gitlab-org/gitlab/-/commit/a1f8ac4e1240248adf1c82e4277ea7b967b3d3f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205694))
- [Update route for the Duo and SDLC trend dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/8c03ab85f38beeb5f565c21a69d6f5921f787853) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205092)) **GitLab Enterprise Edition**
- [Add vulnerability_metric table for risk score](https://gitlab.com/gitlab-org/gitlab/-/commit/6065ecea88bb0c32a06439bfe8a577c48b56019f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204460)) **GitLab Enterprise Edition**
- [Restrict pipeline variables not break trigger API](https://gitlab.com/gitlab-org/gitlab/-/commit/da6d75a2a1d34ebd60c0c7d4554cfc72e1b9b7d2) by @ssavrim ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204230))
- [Hide add comment button on diff view when user has no write permission](https://gitlab.com/gitlab-org/gitlab/-/commit/37cefbc0b1106cdedeeb1345c49f77af165dfc0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205492))
- [Use relative URLs in activity widget](https://gitlab.com/gitlab-org/gitlab/-/commit/5a794ec6813146cf92f6bad7f3ab06210fed6a68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205437))
- [Remove home_organization from user_preferences table](https://gitlab.com/gitlab-org/gitlab/-/commit/313aa2d73222dc460b8a7f0eed4c757e7842092b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197394))
- [Return success when status update target already matches](https://gitlab.com/gitlab-org/gitlab/-/commit/6ce2b174734a1a639f21e9ac8c32a46bdb26ef67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205412)) **GitLab Enterprise Edition**
- [feat: Add cargo DB schema and specs](https://gitlab.com/gitlab-org/gitlab/-/commit/4b05a2b6b2b1df0fece40ba2ca51586626c0de60) by @kiran-4444 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197846))
- [Change workspaces agent config dns_zone default to empty string](https://gitlab.com/gitlab-org/gitlab/-/commit/bdd55889500ffc44e5b0c0cfd7d305d7ffc367de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205164))
- [Remove promo language from the discover page](https://gitlab.com/gitlab-org/gitlab/-/commit/42bf874facc4cd8fce78b447c9e1080772803b3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205346)) **GitLab Enterprise Edition**
- [Update combined list ff](https://gitlab.com/gitlab-org/gitlab/-/commit/868b032156e3cf9464cc13ff426d18ce0dd6d06a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205356)) **GitLab Enterprise Edition**
- [Update UI copy on pipeline editor empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/a590b5211bd52156722750279055fc28e18dd8da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204926))
- [Use regex in zoekt metadata queries](https://gitlab.com/gitlab-org/gitlab/-/commit/3a7140f6b54fee7e80bf9a96b9d995933c05c4f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205245)) **GitLab Enterprise Edition**
- [Remove progress and completion display in learn gitlab and get started](https://gitlab.com/gitlab-org/gitlab/-/commit/4dfeaaeff1acb5c5422d02543900f1caaf6b5287) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204065)) **GitLab Enterprise Edition**
- [Remove OAuth SHA512 feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/77fe74e1bd4cd733868bd52a31d87235db0e8fcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203655))
- [Add warning alert for composite_identity_forbidden](https://gitlab.com/gitlab-org/gitlab/-/commit/91ee6224ea8f7c46715597b4338af9b40017c365) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205095))
- [Update gitlab_secret-detection gem to v0.34.0](https://gitlab.com/gitlab-org/gitlab/-/commit/2f9a09129d8c21e0055a2f153d10dc8dd51a6aed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205036))
- [Improve compliance text grammar](https://gitlab.com/gitlab-org/gitlab/-/commit/eb2657a84fee2df74613854997ab90d6bacac15e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204801)) **GitLab Enterprise Edition**
- [Remove vulnerability_namespace_adjustment_worker feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d2df116ed38f45235051c9565de6afe417e045ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204987)) **GitLab Enterprise Edition**
- [Remove post_pipeline_analyzer_status_updates feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fd9970de466a6c001fed75ebe76f9584113cdcd9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204986)) **GitLab Enterprise Edition**
- [Remove vulnerability_namespace_statistics_diff_aggregation feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9344e285a111cbb8dbb9850a0844c80261a2d36f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204726)) **GitLab Enterprise Edition**

### Deprecated (2 changes)

- [Deprecate graphql fields for removed integration](https://gitlab.com/gitlab-org/gitlab/-/commit/73aeff956482c21df2faa13ced21dcdb8d664091) by @syasonik ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200709))
- [Deprecate graphql fields for removed integration](https://gitlab.com/gitlab-org/gitlab/-/commit/2fdcac40fd16c22792a85c2129488ade7ef039d2) by @syasonik ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200694))

### Removed (24 changes)

- [Remove protected branches in project settings](https://gitlab.com/gitlab-org/gitlab/-/commit/67db098e10cb478da0edb91811f66ad1318931bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199324))
- [Delete the `search_schema_migration_scroll_api` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c1220061d3f8044dca146afa71d137e4cda1c60e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208118))
- [Remove secondary read-only banner on archived diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/ec85981ae69bef8658e95ba580da57812cb3403e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206502))
- [Delete the `show_container_registry_tag_signatures` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/798b605c86476c87c3294623391470a1fdf95acf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206686))
- [Remove singleton column from security_policy_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/8dd08370a6aec757be9c35f27eddb101f5f8b048) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196403)) **GitLab Enterprise Edition**
- [Drop note_uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/0f9794140cfeca2c406f9a3d8da31084f334c060) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206764))
- [The API endpoint for revoking admin tokens is now permanently enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/2589bf59d34a9fda69ccedefa642c04fc00b6db2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207169))
- [Clean up old MCP server implementation](https://gitlab.com/gitlab-org/gitlab/-/commit/268daa92b754b14809e00144ff7ade3886e290fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206882))
- [Removing unused dap_side_panel feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3a366907c6f126d03b091c9f706ecaf6c9b4b6f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206964))
- [Remove FF references](https://gitlab.com/gitlab-org/gitlab/-/commit/c7d3f5555f2f1c5dba30916aa677a296e5e3f969) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205003))
- [Remove disable_ropc_for_new_applications flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1e0c77de21379da09b5f4dd999ba61e23aca3aa2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205939))
- [Cleanup Geo feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/0a37ecdb2017b6a2efe836933d92e8fc67fa085c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206118)) **GitLab Enterprise Edition**
- [Remove disable_ropc_for_new_applications flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e8421b47f849434bccd573842e6d63cefba37993) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205938))
- [Remove secondary read-only banners on merge requests overview tab](https://gitlab.com/gitlab-org/gitlab/-/commit/3cd165d95e401c2cda85d6e34b6b47be5e2f540e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205375))
- [Delete the `populate_and_use_build_names_table` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/da9bf6158beec213fc8b795d7aa498fb8fe3320e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205037))
- [Remove software_license model](https://gitlab.com/gitlab-org/gitlab/-/commit/56e15b060d661b59295e777393f369c0ca45da7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205241)) **GitLab Enterprise Edition**
- [Remove routable_cluster_agent_token feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c2c371b504104682fcf7f4993ead3acb3bbddc78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205990))
- [Remove jobs for obsolete AiUsageBackfillWorkers](https://gitlab.com/gitlab-org/gitlab/-/commit/9a874154b2586f3d0f3a96659498b3e048f2617b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205679)) **GitLab Enterprise Edition**
- [Remove secondary read-only banners on work items](https://gitlab.com/gitlab-org/gitlab/-/commit/a17ef5ee085483fc219d12fabb651eb99738c18f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205352))
- [Remove read-only banners on wikis](https://gitlab.com/gitlab-org/gitlab/-/commit/157a03a722d2803cea25fe3b086da175eacd0e25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205342))
- [Remove old approach to storing AI usage events](https://gitlab.com/gitlab-org/gitlab/-/commit/681a9e97b5047e1ba386e7977bafca7b23330298) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202228)) **GitLab Enterprise Edition**
- [Delete the `skip_committer_email_check` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3e06cd99032333537d16f3a2c73e8c7d967f86d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205033))
- [Remove unused code in for license_compliance_spec](https://gitlab.com/gitlab-org/gitlab/-/commit/2b60ec712a82aa96c5faa6fec75f281af43ad463) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204766)) **GitLab Enterprise Edition**
- [Don't separate user permissions from maven packages finder](https://gitlab.com/gitlab-org/gitlab/-/commit/62f3cce5d0de5ea38b3c7cd5b778ed2dae6e99e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204498))

### Security (25 changes)

- [Some mutations have read_api scope](https://gitlab.com/gitlab-org/gitlab/-/commit/4a1db0c0056cdf3f7ceb0f35e0a344e21acc2511)
- [Reject irrelevant 1xx responses](https://gitlab.com/gitlab-org/gitlab/-/commit/f978de547519e0c03c05db051d7566f28dde3b80)
- [Restrict manual variables to explicit guests in internal projects](https://gitlab.com/gitlab-org/gitlab/-/commit/2dfe8c36e7b9ddc3a64084eca2e6ba12d991d97b)
- [Adjust complexity for blob data fields](https://gitlab.com/gitlab-org/gitlab/-/commit/f57fdaa9dd883959d6759f22c0dd50a13d5bb773)
- [Log JSON bytesize as well](https://gitlab.com/gitlab-org/gitlab/-/commit/ae109de7665a8afa52cea975c1f8c653de12981f)
- [Add more documentation around JSON validation middleware](https://gitlab.com/gitlab-org/gitlab/-/commit/6a13f8a8a364a3c922cfa8d407059321386d5a93)
- [Increase JSON validation limits on NPM endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/78f436c15a5731bea0820974c01bb4028d71c37c)
- [Add the rate limit in BlobSearch GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/a9834dc5bd0de4d102165e399c1795d8cc9539fe)
- [Escape text for wrapNodes utility](https://gitlab.com/gitlab-org/gitlab/-/commit/bcb8c0a7f46ae4f982a978e40ed147bfd35ad4c3)
- [Add limit to array fields in WorkItems API](https://gitlab.com/gitlab-org/gitlab/-/commit/8dc8141fc43eddede8c8bdd07e1a266d834bdfc0) by @afrnz
- [Addresses logical bug in the GraphQL base resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/81d556ba3872f7ff8704b63e8b217b9a55d695b7)
- [Prevent role assignment for custom roles in projects](https://gitlab.com/gitlab-org/gitlab/-/commit/c7e9dfeb58997acc3df2e30f2496e69b83d7dc6e)
- [Removes password field from maven upstream GraphQL type](https://gitlab.com/gitlab-org/gitlab/-/commit/2b9dc66b0ae4702bb5285a30db0eb728b44370bf)
- [Only owners can invite groups](https://gitlab.com/gitlab-org/gitlab/-/commit/5a48a460a8040cc2f403608e9167ae9aa9a00da3)
- [Fix Identical Project Names via Move Issue Drop Down leads to Confusion](https://gitlab.com/gitlab-org/gitlab/-/commit/d77b162a62fe466aa96c8902564cdf06732d4e87)
- [Limit String => Integer conversions](https://gitlab.com/gitlab-org/gitlab/-/commit/11c051e364d189ba6735d9aaba38e3bef8cac69a)
- [Fix Workhorse error handling in body uploader](https://gitlab.com/gitlab-org/gitlab/-/commit/b1ad457b761a69dad1f5aab5c80a557c3ecb44c6)
- [Fix Terraform state local path](https://gitlab.com/gitlab-org/gitlab/-/commit/e6e040f80038780c14e3b841b82e3045511ec6e4)
- [Enforce limits on all NPM bulk endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/264c71e0286a0c76e76bd2b64265e6e09db72915)
- [Ensure upload Terraform state file cannot exceed application limit](https://gitlab.com/gitlab-org/gitlab/-/commit/124d3851f30df856293c132a920f8811391cb6c8)
- [Enforce JSON validation limits by default](https://gitlab.com/gitlab-org/gitlab/-/commit/92ee80807a20eefd6524b30169b57735eaaa51d0)
- [Add ability to enable a global override to disable JSON validation](https://gitlab.com/gitlab-org/gitlab/-/commit/216872af904782f61dade2b9d22241c8c2504f69)
- [Log JSON streaming validator metadata in API and controller logs](https://gitlab.com/gitlab-org/gitlab/-/commit/1b07f7a2509efb057bf58c913063f8150cf31419)
- [Introduce route-specific JSON payload limiting](https://gitlab.com/gitlab-org/gitlab/-/commit/a04b304bc53600cedf5a4b049005f8550062fe3e)
- [Add JSON input streaming validator middleware](https://gitlab.com/gitlab-org/gitlab/-/commit/4ac90fb14a019542d2f0d86cfe65c54294582680)

### Performance (8 changes)

- [Add partial index on oauth_access_grants for cleanup worker](https://gitlab.com/gitlab-org/gitlab/-/commit/fb62a2c6a7d997a7e3be29da66ca29d729ba94a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207876))
- [Add OAuth access grant archival worker for data retention](https://gitlab.com/gitlab-org/gitlab/-/commit/26feb47f78a79254a5d5005c558ec835d5b412bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207837))
- [Add composite index on oauth_access_tokens for cleanup worker](https://gitlab.com/gitlab-org/gitlab/-/commit/c976322caa95929e1954fcab23ded2fb536c071b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207474))
- [Add OAuth access token archival worker for data retention](https://gitlab.com/gitlab-org/gitlab/-/commit/6113e7635da12c9bab4482085a12ea8e9a390b8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202767))
- [Graceful degradation for unauthenticated routes](https://gitlab.com/gitlab-org/gitlab/-/commit/3e318e89ad9ce3510db65b517d668ab6e0759b98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206365))
- [Ensure logs tree ref_type is uppercase](https://gitlab.com/gitlab-org/gitlab/-/commit/b39cf6a93dcd640d720447b919af8c6172fa3a3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206184))
- [Use empty tree ID instead of blank string on force push indexing](https://gitlab.com/gitlab-org/gitlab/-/commit/cbd46587601a7d8a5be2380309a7b95bf0821ae0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206114)) **GitLab Enterprise Edition**
- [Remove packages subquery when fetching package files](https://gitlab.com/gitlab-org/gitlab/-/commit/e49d9b11e95560107e564b049e983ea6450b0a99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205423))

### Other (117 changes)

- [Remove approval_policy_time_window feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9a08400473a59dd4dfa7b7e83023a8648e344eec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208113)) **GitLab Enterprise Edition**
- [Add note_diff_files sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/adee5c68b71029d06cc4307d405af34ad75ae5d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207801))
- [Revert "Merge branch 'jm-add-ff-to-disable-zoekt-large-project-checks' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/55abb18868881b2df6c2114860becb2cbc5df859) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208430))
- [Prepare ASYNC FK validation on todos#organization_id](https://gitlab.com/gitlab-org/gitlab/-/commit/08abbc80980fc851b22d11062d71e0817ebdd2fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208310))
- [Remove enable_invalid_scope_error feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5d4a9dc69a1e8cc4171fa1ad50eb62c6cd2ccfb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208259))
- [Add system_note_metadata sync indexes and FK](https://gitlab.com/gitlab-org/gitlab/-/commit/5e6816fa34322fa468d722bfc5173b7f337a8279) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207743))
- [Add broadcast messages](https://gitlab.com/gitlab-org/gitlab/-/commit/1f39c80b6571c0ca028da01ca56468ca5b037358) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205715))
- [Drop abuse_report_assignees table](https://gitlab.com/gitlab-org/gitlab/-/commit/7910db6aaeb3d186d8ab6bc06059e998685fd72a) by @jarka ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207614))
- [Add organization_id to spam_logs table](https://gitlab.com/gitlab-org/gitlab/-/commit/e00bba850fd4e0897451fef667fa89c94b777c01) by @jarka ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207058))
- [Clean subscriptions.user_id for sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/721261b533d45506464393cbe3868bf8a96e8855) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207503))
- [Backfill label_links sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/be0520b2adb83cb0f9649de728a87aea02e15c7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206448))
- [Remove bulk_import_failures from wip list in spec](https://gitlab.com/gitlab-org/gitlab/-/commit/f7b2379e23cf8ab566a342b1c646b827bf72f92f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208031))
- [Set sharding key on todos](https://gitlab.com/gitlab-org/gitlab/-/commit/98bce3ff9dfd5a6427e0c139e38646714d7490b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204559))
- [Add default value to workspace.desired_config_generator_version](https://gitlab.com/gitlab-org/gitlab/-/commit/1c8e2efecde3229528bb4076f5df10849f820fe7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206001)) **GitLab Enterprise Edition**
- [Backfill member_roles organization_id](https://gitlab.com/gitlab-org/gitlab/-/commit/5460cada33bdbe64e06aa71d39413bbbd0ec783f) by @jarka ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207050))
- [Aggregate ai events counts with background worker](https://gitlab.com/gitlab-org/gitlab/-/commit/2328ce481521e65a2421e6836ece20f057cc9bd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206984)) **GitLab Enterprise Edition**
- [Updating Topology Service Client Gem to e0a35bc](https://gitlab.com/gitlab-org/gitlab/-/commit/6acfa324ca63c99cfad13b51f033e9b06a49f924) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207443))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/83efd564feabbb31a378e629f99fe3e55e672be6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203190))
- [Remove seat assignments group links create or update seats worker](https://gitlab.com/gitlab-org/gitlab/-/commit/e013853d8d9e6c3f9f2acb15a07c21674df71beb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207712)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/92a11f7273726de4f9c34bd5cb817fd3874ef552) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205313))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/94e10d9a2dcfb1ae607b2034a35014edadc378ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207637))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/5b809477a8ce286c0ed65fb556c1485516e1d084) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207378))
- [Remove `tailwind_container_queries` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e6bbb6f42deef15a7648b56254f15fb8bde23583) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207466))
- [Finalize BBM BackfillAnalyzerProjectStatuses](https://gitlab.com/gitlab-org/gitlab/-/commit/fa92f8bfe666c520e4baff41d1b99b85ca3d017f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203407))
- [Remove `NOT NULL` from `p_ci_job_definitions.updated_at`](https://gitlab.com/gitlab-org/gitlab/-/commit/573ddcae7ac58a668955163293aba34f4fcbca38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206488))
- [Cleanup enforce_runners_request_limit feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/65340018075d0a256f3c6c38c3cd99e290478a01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207451))
- [Add associations and validations](https://gitlab.com/gitlab-org/gitlab/-/commit/964b85d4fed3c91860e317a384d84847ffd7e179) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206728))
- [Sync translations from crowdin (2025-10-03)](https://gitlab.com/gitlab-org/gitlab/-/commit/c3a51d2aa7c39d8b8b90086b727a7c3f80120e35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207431))
- [Add batched background migration to backfill X.509 tables project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/7e30786807a523b647ece0fa62a30c297cacd00c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206669))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1b1923aed8d15c1c24102b4ddc33007a73813aac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207375))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2f48d1e9b68a3530d52b9bb0b7f797d5e115ed36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207374))
- [Enable project studio by default for GitLab team members](https://gitlab.com/gitlab-org/gitlab/-/commit/6a4866b1eae4db115b76c374d3cc7e3f67c3dfcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207341))
- [Clean up Feature Flag for force-push checking](https://gitlab.com/gitlab-org/gitlab/-/commit/51529a0ce5ce75f203656e6a7a315dfb9b9f3599) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207371)) **GitLab Enterprise Edition**
- [Pin `vite` to version `7.1.7`](https://gitlab.com/gitlab-org/gitlab/-/commit/46dafa14ed0f16778a44746285efce038b375684) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207343))
- [Update badges with multicolumn sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/f05faa8bc0d77596d38f9c80bdacc98af6c430af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204916))
- [Create table for aggregated ai events](https://gitlab.com/gitlab-org/gitlab/-/commit/d5986590b668ef936eb6cf71534ea9fc88a1a50d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205716))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/c63055720c92edcf175e0894373e7a5ea092cce8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207303))
- [Drop parent not null constraint from notes](https://gitlab.com/gitlab-org/gitlab/-/commit/aa01050a9d9f1cd92234dce507c0ab9f94ff5472) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207143))
- [Remove alert about introduction of branch rules editing](https://gitlab.com/gitlab-org/gitlab/-/commit/552fd5b5f0383b2458ddc5eee18ec1cb89a36ad2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207138))
- [Update UI link for compare revisions](https://gitlab.com/gitlab-org/gitlab/-/commit/ec09022c2f1c72eacc6a39955df6547e4dcda456) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206896))
- [Remove track_user_group_member_roles_accuracy feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8dea2c39672c85941dc1bb993ad9973e6c9c7548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205804)) **GitLab Enterprise Edition**
- [Use listbox for hand raise leads country and state](https://gitlab.com/gitlab-org/gitlab/-/commit/f2d7de616e07dc12eaf4b311deddfc1a76006c98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197702)) **GitLab Enterprise Edition**
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/84b007cb5fc8ffe8b9b48e77842f0b6e18d31c28) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207009))
- [Finalize design management designs fix backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/7028157f1973b59f41a2f1278cc61d4ed0bc1dac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205951))
- [Remove unused legacy epic app](https://gitlab.com/gitlab-org/gitlab/-/commit/19ecd8086d4fc19cac662e8034d6b45650d700ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206966)) **GitLab Enterprise Edition**
- [Drop parent constraints from notes_archived table](https://gitlab.com/gitlab-org/gitlab/-/commit/9d246bfc24e1781270c14f18037abe2eb2992bc0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206970))
- [Replace usage of GlBreakpointInstance with PanelBreakpointInstance](https://gitlab.com/gitlab-org/gitlab/-/commit/b080d661a5028c4610247a7721b90ad214799f4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206959))
- [Remove DeleteOrphanedGroups BBM and related files](https://gitlab.com/gitlab-org/gitlab/-/commit/ec6fdda2fc407d03a1ca1d78ce0591df3992c4e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206865))
- [Set aubse_report reporter as not null](https://gitlab.com/gitlab-org/gitlab/-/commit/d27d9cc6f335f19c16dcd3905e36d7d58f002612) by @jarka ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206095))
- [Feature flag ff_oauth_redirect_to_sso_login Cleanup](https://gitlab.com/gitlab-org/gitlab/-/commit/00abbf626b55e8bff6b5b67db2fb72fc6574a2c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206861))
- [Delete orphan redirect route rows](https://gitlab.com/gitlab-org/gitlab/-/commit/22696d161f1a48eb1f8841327f035f1bd3e40b54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204393))
- [Update Notes content to use Container Queries](https://gitlab.com/gitlab-org/gitlab/-/commit/aa985f3eaee81296588232ac2ea20884a297ae9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206573))
- [Remove environment_attributes_from_job_environment feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9f01bfe9f6fdc1731923f7762828358b9bf8a18c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206621))
- [Fix 20 rubocop violations for InternalAffairs/LocationExpression](https://gitlab.com/gitlab-org/gitlab/-/commit/f3e91f3a9efed5510fdb4fbf4261322c39ac02fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200143))
- [Do not import Ci::BuildMetadata records](https://gitlab.com/gitlab-org/gitlab/-/commit/ce823c0bcd19386fa6d0e421b72ae9f43c38b1c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206328))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/16a488abda06678d0439ffb3cbdc2c008c564f04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206465))
- [Add organization_id to web_hooks table](https://gitlab.com/gitlab-org/gitlab/-/commit/c9ba1c0a448925645830ae4a1e6c2863901944cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204343))
- [Add organization_id to member_roles table](https://gitlab.com/gitlab-org/gitlab/-/commit/993f7d08ea8744e5eb20951770c7da66bdd5ec34) by @jarka ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206023))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c3f4df5c51dbfd21dbe4ec4146bcd3b90cdf7903) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206303))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/23945f084795f9637c2e6dfb75986867ad563e35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206301))
- [Fixes MR sticky header actions positioning on scroll](https://gitlab.com/gitlab-org/gitlab/-/commit/dc3bcb22998f8b814777b258d61a62fa41827a93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206257))
- [Create RefSearchForm component](https://gitlab.com/gitlab-org/gitlab/-/commit/939581916282900f22696dc8c0095b6f1cf22c57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193034))
- [Cleanup duo_enterprise_trial_single_form feature flag and code](https://gitlab.com/gitlab-org/gitlab/-/commit/fc9734ddc72e4b39955aefec3e1cdeddc9be89ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204061)) **GitLab Enterprise Edition**
- [Migrate Merge Request page to use Container Queries](https://gitlab.com/gitlab-org/gitlab/-/commit/b95fee322c0da20bfd51b2d203d298f55e009198) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204934))
- [Add system_note_metadata sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/fd435e44607d1ad7fb578aa5fb0736bce966adef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205639))
- [Use Media Query classes when Work Item is opened in GlDrawer](https://gitlab.com/gitlab-org/gitlab/-/commit/4738ae3fe88cfc111b3ad1711db31767d9784b6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206202))
- [Remove ensure_consistent_editing_rule feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9cebf3010f4b82b63be04f4a01bc70eae71f4b0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206159))
- [Move `x509_...` tables to `gitlab_main_org`](https://gitlab.com/gitlab-org/gitlab/-/commit/a907b6646b0af504f527953d0073532437e53463) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206127))
- [refactor(spec): Only check for validated NOT NULL constraints](https://gitlab.com/gitlab-org/gitlab/-/commit/faafe02c1fd5b74701becab7774b92784b698895) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202867))
- [Archive `vulnerability_reads` records like others](https://gitlab.com/gitlab-org/gitlab/-/commit/48cbb7c94dfa5af3f9f38ee919b6462e0dfbd123) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205911))
- [Migrates component to use Tailwind Container Queries](https://gitlab.com/gitlab-org/gitlab/-/commit/cb7fd563e70dbdef43029950d3df2727230035aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205918))
- [Clean up hotspot_duo_chat_during_trial experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/e4cf2ddea8898d4dbfcd530345e53c72a0328914) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205929)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/4ef54559b56d00a7eece7ca9b67be1812b11d628) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205776))
- [Finalize BBM FixStringConfigHashesInstanceStreamingDestinations](https://gitlab.com/gitlab-org/gitlab/-/commit/71d8d960deddf95938f85520526a78000983c96f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204600))
- [Remove ff for audit events consolidation](https://gitlab.com/gitlab-org/gitlab/-/commit/139b5b428b676d86a8fb2a4c7e0d2ac48cb8de62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203704)) **GitLab Enterprise Edition**
- [Extract Gitlab::Database::Batch::Optimizer](https://gitlab.com/gitlab-org/gitlab/-/commit/bc4882838f458f42fe6c83f164c795862f92ad0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204173))
- [Add missing steps on notes.organization_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/6ca2519913d323d4a0a4b0bf1916ac94da8ebf2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205909))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/523776051f85a4384d390116f418f512066806d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205852))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f17f6561d2e5ccf993ecb847dcb917d5b73b42bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205314))
- [Mark desired_config_generator_version ignore for deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/2a79e84412a1d92bb938fbdb80ed99e2cb6c8d3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205613)) **GitLab Enterprise Edition**
- [Finalize BBM BackfillPipelineExecutionPoliciesMetadata](https://gitlab.com/gitlab-org/gitlab/-/commit/dab1da4b43ebbcf13c04a0dc5e6562fd482da70d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204602))
- [Remove redundant validation](https://gitlab.com/gitlab-org/gitlab/-/commit/f8996e2fef8f7719ace76d5eff1f61a990971f97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203989))
- [Add sharding key trigger on bulk_import_trackers](https://gitlab.com/gitlab-org/gitlab/-/commit/ea3255c4a8c54fbb4dd96aa0488ac5cc68d1a2c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202296))
- [FF stub cleanup and schema relaxation with backward cmp](https://gitlab.com/gitlab-org/gitlab/-/commit/a1d33273a4ce20c9ede31784e6210ff23694cf34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205430)) **GitLab Enterprise Edition**
- [Remove persisted_job_environment_relationship feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e459afefdddcbe444335fc960e69e35cf2775663) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205136))
- [Add spec for instance-level SlackIntegration alias duplication](https://gitlab.com/gitlab-org/gitlab/-/commit/3a61743e5e7c68efa91a8de520202e8a73d4ae53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205586))
- [Adding docs for grouped URLs variable](https://gitlab.com/gitlab-org/gitlab/-/commit/b86a58eda48bcf48f85d9a1cb8c061bd8da65d37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205207))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/c02d75dea5c6854fe20a2ef241fe5eed7775ff7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205525))
- [Set sharding key for abuse_report_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/ecf177e4fbacc03930295f7e5b4ef5a83df0b3ac) by @jarka ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205505))
- [Remove `admin_projects_vue` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b2b5aa5df76f594065a4e8d2c7792164ff33071a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205497))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/375955f38ec918a12afaafa256d6191b94bbb949) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205479))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/447e3f41ba6370ab1bf3e77b0022464e308b55bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205315))
- [Finalize BBM BackfillEpicsWorkItemParentLinkId](https://gitlab.com/gitlab-org/gitlab/-/commit/f2554cc99c53d7d6a25d49bf5591811f694e4edf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205468))
- [Finalize BBM FixStringConfigHashesGroupStreamingDestinations](https://gitlab.com/gitlab-org/gitlab/-/commit/7fcf35dd044bb7fa136bb4f5ad5f8f10dee14660) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204434))
- [Ignore and drop (in PDM) name from ci_runner_taggings](https://gitlab.com/gitlab-org/gitlab/-/commit/3b905ab4fc703119a9e480b2b25f9fe9faede33b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205443))
- [Drop sharding_key_id columns on runner tables](https://gitlab.com/gitlab-org/gitlab/-/commit/72dd2fb5d15e72fbb7d021dc27af68fa1c730873) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205275))
- [Remove abuse_report_populate_organization FF](https://gitlab.com/gitlab-org/gitlab/-/commit/14cbcb191aa899b28965263744c04a0caca51b66) by @jarka ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205396))
- [Part 3 of FF stub cleanup and schema relaxation](https://gitlab.com/gitlab-org/gitlab/-/commit/d15a96152a511fa15bb7944a88f164e9a109c097) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204556))
- [Finalize BBM BackfillPlaceholderUsersDetailsFromSourceUsers](https://gitlab.com/gitlab-org/gitlab/-/commit/e734c456d9e76b157a2e6d2ccc9e4cad4e0b0dde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204953))
- [Add name column to ci_runner_taggings table](https://gitlab.com/gitlab-org/gitlab/-/commit/ab59adc1d0ae7f0c613e3e7b554e0d233638e9c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205053))
- [Move `deploy_tokens` to `gitlab_main_org` schema](https://gitlab.com/gitlab-org/gitlab/-/commit/0834ebfc771ef986b3be592d430275427790964e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205324))
- [refactor(maven): Check user permission in Maven::CreatePackageService](https://gitlab.com/gitlab-org/gitlab/-/commit/286fdfeecd157747422d193c55817fe3eadcfbe4) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193284))
- [Finalize BBM BackfillEpicIssuesWorkItemParentLinkId](https://gitlab.com/gitlab-org/gitlab/-/commit/8af76164a8a2aadb5f095c8b7471173f4780c3c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205298))
- [Finalize BBM FixNonExistingTimelogUsers](https://gitlab.com/gitlab-org/gitlab/-/commit/1d02e572bc05d25d1ee988df54d31ffc52bfa286) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205140))
- [Add organization_id to abuse_report_assignees table](https://gitlab.com/gitlab-org/gitlab/-/commit/ad6b2807fe7bae34049ef99d6562a817571ce9d9) by @jarka ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202295))
- [Remove bitbucket_server_notes_separate_worker feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b7d6f0bed0c8f03795d4702077f66d49227849ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204914))
- [Finalize BBM UpdateRequireDpopForManageApiEndpointsToFalse](https://gitlab.com/gitlab-org/gitlab/-/commit/7cc46e79b6a3c8c4ddb0b9db26188b1ee244bf13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204601))
- [Stop invoking SyncFindingsToApprovalRulesWorker from StoreScansWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/dec5f902fa4c66574deabb46e08768ebf8d6c7e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204396)) **GitLab Enterprise Edition**
- [Replace glFeatures with glLicensedFeatures for Remote Development](https://gitlab.com/gitlab-org/gitlab/-/commit/ad2ca17b96e96cf851af7b3bea67b2daf22599d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204696))
- [Sync translations from crowdin (2025-09-16)](https://gitlab.com/gitlab-org/gitlab/-/commit/cab1da5c8bff657cc420ffa02dd98e3a3b53bacb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205166))
- [Replace glFeatures with glLicensedFeatures for Runner Upgrade Management](https://gitlab.com/gitlab-org/gitlab/-/commit/0445eb69eb3997b91dfc12b2642ce4445dd80bcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204661)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/78428f6b08fe2e28e8512186995ffdce0fe74822) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204966))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c0d5ec70757b6783eb45b71da61b0ac3d0a2baac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204972))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/7f3db2eacf77f4d57f2225f202eae3aad65d819e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204796))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/505585ad714f2af919f53a2c8f5c3a9c577abad9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204086))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/9b431513405bf1d72c77a0c544d3f7f5e6041568) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202165))
- [Remove all references to the skip_committer_email_check](https://gitlab.com/gitlab-org/gitlab/-/commit/ed8314ccb8527799595effa96bdbf2c66ba10548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203920))

## 18.4.4 (2025-11-11)

### Fixed (8 changes)

- [Fix redirect loop in Gitea rate limit](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5f35b80394c0087045e107b1f869e2233bd79c58)
- [Call CommitIndexerWorker when an empty project is created](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0820ebf2dd78fbf7c8a1ee6b8823420efa7fc513) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210754)) **GitLab Enterprise Edition**
- [Fix the zoekt filters caching](https://gitlab.com/gitlab-org/security/gitlab/-/commit/937c58de0a4f255b7c24718554d767ee9995ada9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210729)) **GitLab Enterprise Edition**
- [Add deleted Geo migration back](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cc4e0ba0cfff0b77cdf9299ddf22cab4826e3d60) **GitLab Enterprise Edition**
- [Fix password validation exception for FIPS](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cbf2e95b1bacbe065468056005eb57dc344e90e9)
- [Fix admin_project_member policy SAML projects user namespace](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9941d04d25f7e84c803eb8536f2917380255ec86) **GitLab Enterprise Edition**
- [Update dependency openssl to v3.3.2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/32f12a05c36c7ff3da988c09b788dc5d2db0d4cf)
- [Update rexml to v3.4.4](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6cb67ca08413958b919e33b8f75e45cbb9869f66)

### Changed (1 change)

- [Remove OAuth SHA512 feature flag](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7ee2fa60ce2450f0197d58b66ea4dbacb82d48b3)

### Security (8 changes)

- [Security fix package api pipeline details](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5006e3cfe6e484106b37d2446a545dd80d8a1491) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5425))
- [Group enforced pages access control should restrict non-members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/46dc5208a53e3436e6ccd74658951e02121c3de2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5441))
- [Update to gitlab-glfm-markdown 0.0.38](https://gitlab.com/gitlab-org/security/gitlab/-/commit/445a597d1c4bc0b7a4b59e07892f8988a690101e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5462))
- [Encode protected branch names in API requests](https://gitlab.com/gitlab-org/security/gitlab/-/commit/559a768974e47805a90222f8ca2aaa17b13276a7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5457))
- [Prevent GraphQL subscriptions from blocked users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/159f8ee5fd2f5d49debee461b39e3c93dbcbb3b1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5431))
- [Prevent Duo Chat from reading confidential resources](https://gitlab.com/gitlab-org/security/gitlab/-/commit/be737dee7e06fcca930e4eb34cabcbca903b316c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5379))
- [Hide related branches when repository is private](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ba92c18d0200a5f7423a61f151b604d2a46497bb) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5435))
- [Fix unauth workflow deletion by service accounts](https://gitlab.com/gitlab-org/security/gitlab/-/commit/31a7406caa596bf1f13271372f683f21b70c3293) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5421))

### Performance (1 change)

- [Reduce cached SQL queries in `/api/v4/internal/pages` endpoint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/54969f5503e0ebdf4cbe275e9f884cd44bbd44e3)

### Other (1 change)

- [Fix instance bbm for mishandled nil verification token](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8059aa66884fabdb4d37657361dc7f6c9ee38023) **GitLab Enterprise Edition**

## 18.4.3 (2025-10-21)

### Fixed (5 changes)

- [Fix connection pool errors when health check is running](https://gitlab.com/gitlab-org/security/gitlab/-/commit/53f5d29c93ea36cd6f1f6f8c4ccb4a144a53a239)
- [Downgrade redis-rb gem to v5.4.0](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3fb24f782beb8708fc8e156e3cd8d5ec38f2613b)
- [Fix zoekt search for API when elasticsearch is disable](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5945f19d1b94d2882faf8c889917f64490db28e5) ([merge request](https://gitilab.com/gitlab-org/gitlab/-/merge_requests/208124))
- [Fix the undefined method id for nil:NilClass in WorkItem](https://gitlab.com/gitlab-org/security/gitlab/-/commit/400938e318bc34ce3bc90f1ff9c3bd21c8ddb868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208091))
- [Revert discarded database pool check in load balancer](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2c146b05834027cd1fb1dd97f010d108149d33a9)

### Security (7 changes)

- [Non-group members can be added to projects even though the "Users cannot be...](https://gitlab.com/gitlab-org/security/gitlab/-/commit/446dfa32a5d7e8eb4d110caa50db12aefe58dfc0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5418))
- [Ensure NPM upload cannot exceed plan limit](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cfff507e924eaab1b0210dd9e3627a0d8dcba8d6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5428))
- [Limit JSON request payload for /-/collect_events](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4622a9f0386af48b95613eb2740a15293c5df16a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5404))
- [Track pull mirror updates using gitaly_context](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9eb4714f71edb96a9d7d30a05634d5e6bceeca96) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5411))
- [Reject quick actions for ai_workflows scope](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7ef35ff4d114144ccd635413e89a5b694d6aa17e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5372))
- [Use CE policy for runner ability check](https://gitlab.com/gitlab-org/security/gitlab/-/commit/602a6154b75570c966fe752df0d92eca78954121) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5414))
- [Limit depth, size and total elements when parsing JSON string](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f9d6ed837944160e227aae9a227e7ad3373b8006) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5407))

## 18.4.2 (2025-10-08)

### Added (1 change)

- [Remove check_f02a3f53bf not null constraint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8286ade8d801ab80891f81defc627839a4d86e20)

### Fixed (3 changes)

- [Prevent session creation for sessionless users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f88c1242f0a8e5e9f13a187755568d0545f69305)
- [Remove non Saas instances from calling CDOT for trial duration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6ba5b24afb192c042cf67be4bb85c0dc306db143) **GitLab Enterprise Edition**
- [Transfer start and due dates data upon work item move or clone](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9025e065d671143b547126269c775d52102b9775)

### Security (5 changes)

- [Log JSON bytesize as well](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b6b5c289d3183019524e5604c25f431cf45682c2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5388))
- [Adjust complexity for blob data fields](https://gitlab.com/gitlab-org/security/gitlab/-/commit/49554246af3e45202ca7c32e0a0273f13421eb8a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5384))
- [Some mutations have read_api scope](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5714b2f3c9411e709d6abcb0896b34a208798d1b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5370))
- [Reject irrelevant 1xx responses](https://gitlab.com/gitlab-org/security/gitlab/-/commit/390f4fddbb5a778dbd52a9647bf22ab52ee8478e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5332))
- [Restrict manual variables to explicit guests in internal projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/446b25ac5e3e9c02c49f26a1da31ba108c0bdd23) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5366))

## 18.4.1 (2025-09-25)

### Fixed (2 changes)

- [Use isUnsafeLink for xcode protocol](https://gitlab.com/gitlab-org/security/gitlab/-/commit/199dbffae5d6ed7063d73b557b3b1d9d06d88968)
- [Optimize HandleMalformedStrings middleware for CPU and memory](https://gitlab.com/gitlab-org/security/gitlab/-/commit/98da626e12117aff71d135ff2c9ca543a2e8b313)

### Security (10 changes)

- [Add JSON input streaming validator middleware](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e5df969d80cc69a5c3dc0fee932047f08c65a0c1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5349))
- [Addresses logical bug in the GraphQL base resolver](https://gitlab.com/gitlab-org/security/gitlab/-/commit/48ac9ce9606c742ca94056b94da1d8ea641e8977) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5313))
- [Escape text for wrapNodes utility](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4eb2db6fddf376e187e759871ccc1f5aed1b93d7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5326))
- [Add the rate limit in BlobSearch GraphQL](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5d8dda684434da9b5f3e6aee195241cacea04cb5) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5335))
- [Fix Identical Project Names via Move Issue Drop Down leads to Confusion](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5e84e7e063bb04404be193f7df4e8ae871716275) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5327))
- [Prevent role assignment for custom roles in projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c377c525426063425a076c6cfcba86d9fa35638b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5337))
- [Only owners can invite groups](https://gitlab.com/gitlab-org/security/gitlab/-/commit/068d6e200bf2ac6eaa2e68d2ef349228376d7539) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5334))
- [Add limit to array fields in WorkItems API](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a7c51c9588bc2f8a87a57d85f871f2332c8bb312) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5325))
- [Limit String => Integer conversions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e2db8dad6d85dffbb9ca30bc8ecb42146b6a12d3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5324))
- [Removes password field from maven upstream GraphQL type](https://gitlab.com/gitlab-org/security/gitlab/-/commit/27a5700b6152d22b08735480d7d118c77dee58de) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5330))

## 18.4.0 (2025-09-17)

### Added (149 changes)

- [Handle IP ranges in the IP validation](https://gitlab.com/gitlab-org/gitlab/-/commit/fb82ac4e01c36c208307dc15180586ba17913aee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204334))
- [Fix breadcrumb navigation for work items in project issues](https://gitlab.com/gitlab-org/gitlab/-/commit/6c29ffc76a5af702752ec93a618b681c60432d32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204335))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/96a61fd4c42ac455e7ae4223db503b2cd0c6144a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205000))
- [Backfill vulnerabiltiy es index with resolved_at, dimissed_at fields](https://gitlab.com/gitlab-org/gitlab/-/commit/35b6a5aba3086344ef52f370f11a54679f0b0ce6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204587)) **GitLab Enterprise Edition**
- [Add “Reformat table” to More options menu in PTE](https://gitlab.com/gitlab-org/gitlab/-/commit/89db5d606ef408cd66b591fd1af77c95a49f1931) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201392))
- [Add agent selection dropdown for agentic chat](https://gitlab.com/gitlab-org/gitlab/-/commit/a68f6f4f05eb1c7773ca18bbae68ee29f8157755) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204075)) **GitLab Enterprise Edition**
- [Add webPath and editPath to group and project GraphQL types](https://gitlab.com/gitlab-org/gitlab/-/commit/682783046b849e9259d96faac16429c2baa91dab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203935))
- [Active Context: Add API endpoints to support chatops commands](https://gitlab.com/gitlab-org/gitlab/-/commit/8af8d9bac26e2df99f09a18956fcb13cf4a80d7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204027)) **GitLab Enterprise Edition**
- [Backfill vulnerabiltiy es index with resolved_at, dimissed_at fields](https://gitlab.com/gitlab-org/gitlab/-/commit/a1a4b8e625ba34e2f148690872ba077e79d4e82a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204012)) **GitLab Enterprise Edition**
- [Add source branch and additional_context to Fix pipeline button](https://gitlab.com/gitlab-org/gitlab/-/commit/76cd1ae393d7903d009504ab1c7c6a41a232dd8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204642)) **GitLab Enterprise Edition**
- [Resolve status by mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/b698844cf40100ec1982c746ef83be128f931fad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204229)) **GitLab Enterprise Edition**
- [Use new import by url UI when feature flag enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/78013637dff0568786f6510ad5b4f1832f6de534) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201202))
- [Geo Replicables: Resync all failed registries](https://gitlab.com/gitlab-org/gitlab/-/commit/f5045c92c4070724560e0df69eec87c9c5d6f75a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204282)) **GitLab Enterprise Edition**
- [Add validity status field to the Vulnerabilties ES index](https://gitlab.com/gitlab-org/gitlab/-/commit/8feed6fa92c3b71a6833e1a8dddb2de5997e7e91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203119)) **GitLab Enterprise Edition**
- [Add project to attributes update service](https://gitlab.com/gitlab-org/gitlab/-/commit/59b7b15136356b1cad0cc5a0cd4a14d21b7e32bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203149)) **GitLab Enterprise Edition**
- [UI for display token status on Pipeline > Security Details Page](https://gitlab.com/gitlab-org/gitlab/-/commit/c8aa159ef71c724eb8ca1828e4c279b81280c7af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203782)) **GitLab Enterprise Edition**
- [Add GraphQL mutation to undo keep as placeholder](https://gitlab.com/gitlab-org/gitlab/-/commit/9b3e61b4242ea1cf2430f10fc2de515b405fef7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204272))
- [Include approved_at timestamp in approvals API response](https://gitlab.com/gitlab-org/gitlab/-/commit/bffe907f00459321c11398dd7edfa1d25c9e9420) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204605))
- [Add security report time window to MR approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/18d0ddd7d9954db5e3ec4faf523c9b9d6326b2b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204521)) **GitLab Enterprise Edition**
- [Create the lease_outstanding table](https://gitlab.com/gitlab-org/gitlab/-/commit/a163d57cbcf2ba341b37a74586913ca5e0df8ae2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203567))
- [Add name filter to workItemAllowedStatuses field](https://gitlab.com/gitlab-org/gitlab/-/commit/bb6de20f26a078150b50c7a6a4e1bd7caf2cb71c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204616)) **GitLab Enterprise Edition**
- [Add instance namespace filters for streaming audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/740e3256d9b8b6e6821ea4e7fd2711b1b2c8e392) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197028)) **GitLab Enterprise Edition**
- [Add spdx or custom_license constraint to software_license_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/cb2bc472504fb96077925930fd85d28999b6b81c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201975))
- [Add category create and update mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/0a269169c0ede40bb089c61a24d81e3520369c0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202652)) **GitLab Enterprise Edition**
- [Add link to time report](https://gitlab.com/gitlab-org/gitlab/-/commit/8f3387ded72d58c39535ff38e785532c4d68bef5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203906))
- [Add DuoAgentPlatformFeatureSettingsService to support DAP](https://gitlab.com/gitlab-org/gitlab/-/commit/030661bc05d71a999cc00ad4b00de74d2823a9a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204349)) **GitLab Enterprise Edition**
- [Track SPP scan executed metric](https://gitlab.com/gitlab-org/gitlab/-/commit/3bec428f117e0ba0966b8cbaf977eb13737d894a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203679)) **GitLab Enterprise Edition**
- [Add DuoAgentPlatformFeatureSettingsService to support DAP](https://gitlab.com/gitlab-org/gitlab/-/commit/fa7a4d53a655d8c0ce6c0dc2dfa6223e43e3c7c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204266)) **GitLab Enterprise Edition**
- [Track SPP scan passed metric](https://gitlab.com/gitlab-org/gitlab/-/commit/831853908622a4c6f67b8c103138bd0188a43824) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203698)) **GitLab Enterprise Edition**
- [Decorates update query with gitlab model info](https://gitlab.com/gitlab-org/gitlab/-/commit/dead782e127bb926e56c3a7a702735c97fc00613) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204373)) **GitLab Enterprise Edition**
- [Add date range validation to work item status mappings](https://gitlab.com/gitlab-org/gitlab/-/commit/dce4044e8b0614c04b404208b476447947c60b70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203961))
- [Add GraphQL endpoint to query model info for Agentic Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/bcc492c3c66c456e82541071f796826c6f117c70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204252)) **GitLab Enterprise Edition**
- [Add STATUS_ASC and STATUS_DESC to IssueSort enum](https://gitlab.com/gitlab-org/gitlab/-/commit/098559a9760199f1bc9a6e59f506309cacef8661) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204322)) **GitLab Enterprise Edition**
- [Updates feature setting query to return gitlab model data](https://gitlab.com/gitlab-org/gitlab/-/commit/58cbd5f38402478e39f47bbc7fd621acb67cecf3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204026)) **GitLab Enterprise Edition**
- [Remove feature flag workspaces_shallow_clone_project](https://gitlab.com/gitlab-org/gitlab/-/commit/c6b23392e6ce0824b0d204942975c79f130c8664) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204280))
- [Add ai_catalog_item_version_id to DAP Workflow API](https://gitlab.com/gitlab-org/gitlab/-/commit/b52b3ab10d1a9062b7959b49e018fae6f38ba803) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204483)) **GitLab Enterprise Edition**
- [Expose workItemAllowedStatuses field on QueryType](https://gitlab.com/gitlab-org/gitlab/-/commit/21838074352534685226bc9a7518142344b61189) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204480)) **GitLab Enterprise Edition**
- [Bring back reverted MergeRequests::MergeData](https://gitlab.com/gitlab-org/gitlab/-/commit/f447c2a0eaaf8600f617fc08cb5f710788fbd304) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203780))
- [Add migration to backfill user_group_member_roles for invited groups](https://gitlab.com/gitlab-org/gitlab/-/commit/091782d49ef3f6e141a2a62483b0ff3f17a3701a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201710))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/a4b2002d1bf15835269d5175c219d2a7a9f8291e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204111))
- [Include resolved_at, dismissed_at to vulnerability es reference](https://gitlab.com/gitlab-org/gitlab/-/commit/c41a615dfab3cc527489e4163e7949767cec552a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204002)) **GitLab Enterprise Edition**
- [Adds files_content keyword](https://gitlab.com/gitlab-org/gitlab/-/commit/5aa84f0269189271511a74dcb8286d0aa87aae1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203233))
- [Add duo_remote_flows_enabled cascading setting](https://gitlab.com/gitlab-org/gitlab/-/commit/ecd21504b44b156212d24e447a043b926c84325e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202745)) **GitLab Enterprise Edition**
- [Add project.repository.commits query to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/6fe78c1ea7c9d28be5f4da538b7508491c8e0443) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203752))
- [Expose host keys for push mirrors](https://gitlab.com/gitlab-org/gitlab/-/commit/9867da1b7787385620bf62964fc5b509bb4acd60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203435))
- [Track SPP push blocked secrets found metric](https://gitlab.com/gitlab-org/gitlab/-/commit/45dfe06e7f4f8d57b9f6b47f8f0442a8683322bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203806)) **GitLab Enterprise Edition**
- [Add organization_id to abuse_events table](https://gitlab.com/gitlab-org/gitlab/-/commit/08bd586489f06ec4aaea2ac36a68c6aee944ac5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202021))
- [Add foreign_key to duo_workflows_workflows](https://gitlab.com/gitlab-org/gitlab/-/commit/7eee8f2fb1691428da06a288966a7caeb0a21ef4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204021))
- [Show and delete discussion note](https://gitlab.com/gitlab-org/gitlab/-/commit/7dc6b675c81d6e0a7b6f04b79721b35efee79010) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201994)) **GitLab Enterprise Edition**
- [Track number of project that enabled Validity Checks](https://gitlab.com/gitlab-org/gitlab/-/commit/4a88fb154f0ac01ec8becf53377ce5122ff40ec9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204150)) **GitLab Enterprise Edition**
- [Add security_policy_dismissals table](https://gitlab.com/gitlab-org/gitlab/-/commit/30cb70aaff9c60c26ec71d3202ecc1b08fccadba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202431))
- [Geo: Add db tables for project repos replication v2](https://gitlab.com/gitlab-org/gitlab/-/commit/7d12260ebbf9ee94569bfb7d41100a3255ba41fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202587)) **GitLab Enterprise Edition**
- [Adds mock implementation of missing lifecycle mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/467cf98473902ccaf26167e947640ac01c9bf03f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204247))
- [Add template type column to security attributes table](https://gitlab.com/gitlab-org/gitlab/-/commit/a1054c09c61a5df50ba862230bf9d9a6d95265b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204098))
- [Add RSS and calendar paths to HAML and namespace link paths GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/4969c183a71564495aee5520edc57ad952644f47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203804))
- [Add DAP for namespace model selection](https://gitlab.com/gitlab-org/gitlab/-/commit/920363b3db93a6d84f62f70d93a0e52833beb80c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203917)) **GitLab Enterprise Edition**
- [Add CREATED_AT and UPDATED_AT as sort options](https://gitlab.com/gitlab-org/gitlab/-/commit/062631267a229005d526a8282b16047e4124e596) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204046))
- [Add ability to disable Service Ping generation completely](https://gitlab.com/gitlab-org/gitlab/-/commit/24b7a7b6bac966a8e176fc0abee2df3d42caedaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201835))
- [Add skeleton loader while waiting for comment templates GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/d814ba5e6ae413ccd411a40d00de5dc33e98d08c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204099))
- [Add more abilities to prevent when archived group](https://gitlab.com/gitlab-org/gitlab/-/commit/a28537adb9d7acf1440c2030d13507a8fb262d2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202908))
- [Adds support for instance feature setting](https://gitlab.com/gitlab-org/gitlab/-/commit/515fa722ddbdc93fdebde5fe3160cae576a8bc33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203498)) **GitLab Enterprise Edition**
- [Support `last_repository_check_failed` parameter on Projects GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/12e5697914ab9f004d6dbc14624bf35ccbb1a792) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203618))
- [Add Fix pipeline with Duo button](https://gitlab.com/gitlab-org/gitlab/-/commit/eef2e7677da58e70456eb3bc8a80606a906b478b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203685)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/a5a5eb56fc0802ca7dc90a0117adb7df5f702c28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203973))
- [Recreate merge_request_diff_files_99208b8fac partition table](https://gitlab.com/gitlab-org/gitlab/-/commit/2de62db398654d828004554ceaa07fb72960470b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199297))
- [Add pipeline id to auto-resolve note](https://gitlab.com/gitlab-org/gitlab/-/commit/e4f7ced31d17aec12105554f3f3516683d15bf7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203758)) **GitLab Enterprise Edition**
- [Add reviews_for_me scope to merge requests API](https://gitlab.com/gitlab-org/gitlab/-/commit/2c9ca37390bc11d69150da68757cdfe60a62c6ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203131))
- [Add sharding key not null constraint on issue_tracker_data](https://gitlab.com/gitlab-org/gitlab/-/commit/364a475a02f26879b5ed25a84a9587ff6e5c29fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202189))
- [Send a audit event when scheduled sep policy can not be enforced](https://gitlab.com/gitlab-org/gitlab/-/commit/ea592928b33eb259264213cd05d8b00e732ca50c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201822)) **GitLab Enterprise Edition**
- [Add feature flag for Duo Agent fix pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/2fe45606d48af74eb87a358a4fd26be919c41243) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203796)) **GitLab Enterprise Edition**
- [Introduces mutation for instance model selection](https://gitlab.com/gitlab-org/gitlab/-/commit/39571ae16ba999409e62deed337a0bb7f35331e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203797)) **GitLab Enterprise Edition**
- [Include resolved_at, dismissed_at fields to vulnerability index](https://gitlab.com/gitlab-org/gitlab/-/commit/a99653c8dff884aadc6a879a5946e22399ff5b8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202397)) **GitLab Enterprise Edition**
- [Add :admin_groups GraphQL endpoint for /admin/groups page](https://gitlab.com/gitlab-org/gitlab/-/commit/4e471abf758b82aeb17044ca3696dc2d4bde5ad8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202896))
- [Link merge request to vulnerability](https://gitlab.com/gitlab-org/gitlab/-/commit/a04fea76cf4bf019b0265017642b73419d469f05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202437)) **GitLab Enterprise Edition**
- [Instance level model selection Base](https://gitlab.com/gitlab-org/gitlab/-/commit/84568a7e90bde18021f9122ffbe34556a0456cdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203395)) **GitLab Enterprise Edition**
- [Update dummy data for project grouping](https://gitlab.com/gitlab-org/gitlab/-/commit/472e1590cb3bc5e44096fe839d82a7a05c1e4573) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203023)) **GitLab Enterprise Edition**
- [Add uuidv7 support for to Gitlab::Utils gem](https://gitlab.com/gitlab-org/gitlab/-/commit/acd2da49d4f5e20c50197959431b5bca75380316) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203358))
- [Add Compare link to submodule diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/29e11f03e18423f1939d4169d31d905f5d3714bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203095))
- [Add database migration for ping_enabled column](https://gitlab.com/gitlab-org/gitlab/-/commit/8df0f93333ed9ecd95498c31b7efa7a0e758e297) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203613)) **GitLab Enterprise Edition**
- [Cleanup evaluate_compliance_controls feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3a4c226a83875c7bd4aaa064c81dcbf00bd9ae8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203639)) **GitLab Enterprise Edition**
- [Calculate plan limits based on active destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/8d0401323fb8457802674b623ac56f0f6102785b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197506)) **GitLab Enterprise Edition**
- [Add the Pipeline Metrics table to AI Impact](https://gitlab.com/gitlab-org/gitlab/-/commit/578e6bfd4b848ff9fea44ccb2e036e2e55b53836) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200584)) **GitLab Enterprise Edition**
- [Add status to milestone detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/4b3aabf4d5d1feb836f042c6931dcaf53276465a) by @poojaghanghas479 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197602))
- [Adds work_item_custom_status_mapping table and model](https://gitlab.com/gitlab-org/gitlab/-/commit/7a7fd5deb3c1539dc3b08db1fbb3a8032d3f181e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203127))
- [Add revoke_token endpoint for ai_workflows scope](https://gitlab.com/gitlab-org/gitlab/-/commit/c22f61c65fa47b07ee7400dbbacfe15af65fdddf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202774)) **GitLab Enterprise Edition**
- [Extend policy bypass checker with users, roles and groups](https://gitlab.com/gitlab-org/gitlab/-/commit/99571c48618ceed91395000e455415e0eaad7e9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201001)) **GitLab Enterprise Edition**
- [Update triggers and add batch background migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/b64b23b3650ed694840ae0f3a03ef8c33cdd7361) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202696))
- [Add MergeRequests::MergeData and create table](https://gitlab.com/gitlab-org/gitlab/-/commit/84c9d6db31cf5420635e62a3d75a82bf7c0d3b0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202323))
- [Add support for case-sensitive search for conan packages](https://gitlab.com/gitlab-org/gitlab/-/commit/766a5842dac1a0461e835caa48ae86b167f8d610) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202940))
- [Add target project claims to CI ID Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/9a4d79822802442c883c8f63ba0648d0ee46efe1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202241))
- [Add details in schema checker inconsistency object](https://gitlab.com/gitlab-org/gitlab/-/commit/2ad29d1ffd2ff24627bb1fa244aee4a20bb803f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202719))
- [Vulnerability merge_requests field](https://gitlab.com/gitlab-org/gitlab/-/commit/543b12208dbcc3ca4668d0ca44be394e49fff1fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202428)) **GitLab Enterprise Edition**
- [Add extensible reference for [epic:](https://gitlab.com/gitlab-org/gitlab/-/commit/97f5e7bb91f0a956526b990a83b299192e7a95f5) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201665))
- [Mask message in logs](https://gitlab.com/gitlab-org/gitlab/-/commit/4c5ea911d6dd77e9be10147aa6fc1ebd3ba553ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203237))
- [Add resource group default process mode to project](https://gitlab.com/gitlab-org/gitlab/-/commit/88319b4d3812e9b5863d40c763a53f5077c2d88b) by @n.h.long.9697 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196144))
- [Adds lifecycle and status templates](https://gitlab.com/gitlab-org/gitlab/-/commit/67f86226570ec99065047a817fff86a77b5c1d2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202046)) **GitLab Enterprise Edition**
- [Add project filtering based on security inventory fields](https://gitlab.com/gitlab-org/gitlab/-/commit/2e9a82907b74152393aafae6b0995ed34d2ca93a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200907)) **GitLab Enterprise Edition**
- [Add category create and update mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/260f1eb656638b2957e4827a847adf9de4bd7d89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202132)) **GitLab Enterprise Edition**
- [Step-up auth: Add database mode and setting in UI](https://gitlab.com/gitlab-org/gitlab/-/commit/ffbd9fe6b58ffcf5877b836125b0e8b862fce758) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199423))
- [Create CI Job Definition relations when pipeline creation](https://gitlab.com/gitlab-org/gitlab/-/commit/6a6d10c6ec221fea5df35c76e256ca1dd24f6c73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202196))
- [Enable opting-out managed resources in environment options](https://gitlab.com/gitlab-org/gitlab/-/commit/4e6dd3eb82897d87f51824f288fe01b3e2ab1c9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200750))
- [Add tables for granular scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/279c14a3bc4da264de22f57090702f2b5502e8a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201810))
- [Allow excluding group-level work items in finder](https://gitlab.com/gitlab-org/gitlab/-/commit/46f1ac4ab4d5d19d5b64959c008f7576ba8676d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202916)) **GitLab Enterprise Edition**
- [Add metrics for ai catalog items and flow consumers](https://gitlab.com/gitlab-org/gitlab/-/commit/d5ba5f930bbf62d0328277473635b58a97a834ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202202))
- [Add GraphQL query for shared groups](https://gitlab.com/gitlab-org/gitlab/-/commit/60fded61ece1f6ed08ed36438fb6aa620753a5a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201708))
- [Add raw_source_code_extract to security_finding_token_statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/4aef3b631eb5a3a833bb03207d6d08ca30d3ecc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202906))
- [Add checksum endpoint to data management API](https://gitlab.com/gitlab-org/gitlab/-/commit/3c70b2c0cd4f347af97fd43a37de91b8f6e780d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202626)) **GitLab Enterprise Edition**
- [Add owned pipeline schedules section to user account page](https://gitlab.com/gitlab-org/gitlab/-/commit/8e28e2edcf2316f58d2c3ad7aa425c8e31e00c88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200128))
- [Add alert messages for GitLab Duo with Amazon Q trials](https://gitlab.com/gitlab-org/gitlab/-/commit/016faf151f880d803450e47ed8210afedd0b71e2) by @clotman ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191338)) **GitLab Enterprise Edition**
- [Add GraphQL support to sorting by storage_size](https://gitlab.com/gitlab-org/gitlab/-/commit/6148f7ef2dcb2f4df89870ec4d72aee648518aa2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194655))
- [Create model to store metadata for SLSA provenance attestations](https://gitlab.com/gitlab-org/gitlab/-/commit/3dd204309dbeec84ac57707ea1093d75e5dd0551) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198687))
- [Introduce SbomScan model and Uploader for DS using SBOM](https://gitlab.com/gitlab-org/gitlab/-/commit/9590f35d9fb05ed3a1037f1de452706de5dd8d32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195058)) **GitLab Enterprise Edition**
- [Adds create lifecycle mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/3c36ffcf5ed9aff4d90561cc21bfe80804220f0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201501)) **GitLab Enterprise Edition**
- [Backfill work_item_transitions table](https://gitlab.com/gitlab-org/gitlab/-/commit/8115f5668ae7214532e0b91ce03525c64c20fa19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202077))
- [Re-queue BackfillUserGroupMemberRoles](https://gitlab.com/gitlab-org/gitlab/-/commit/2452c6cddd09909a5090c81077b1fefe9a208155) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202181)) **GitLab Enterprise Edition**
- [Send correlation ID to SDS](https://gitlab.com/gitlab-org/gitlab/-/commit/bb1b30aeca8e4dadb1a52d8ac41346e15ea09e81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202334)) **GitLab Enterprise Edition**
- [Add "Email a new work item to this project"](https://gitlab.com/gitlab-org/gitlab/-/commit/b83a07f28f2068dc58b83675e6edae30b43808d1) by @n.h.long.9697 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201679))
- [Notify users about placeholder reassignment bypass](https://gitlab.com/gitlab-org/gitlab/-/commit/9ec955c934d0608cb65602c47a707bff6e97b59e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202679))
- [Add category create and update mutations](https://gitlab.com/gitlab-org/gitlab/-/commit/022400d516259637ac4d5d1492587d198190102c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201979)) **GitLab Enterprise Edition**
- [Add export CSV to work items UI](https://gitlab.com/gitlab-org/gitlab/-/commit/f021ff84ee74ea1b575ca48417e08c6f0a80e16c) by @n.h.long.9697 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200893))
- [Add advanced editor toggle and banner](https://gitlab.com/gitlab-org/gitlab/-/commit/a424e819d7a203e9e27c81cb3a4e9dd8519a0281) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201926)) **GitLab Enterprise Edition**
- [bkd: Disallow immediate deletion behind :disallow_immediate_deletion FF](https://gitlab.com/gitlab-org/gitlab/-/commit/ac6e49928fa0d1ac5d90ff7c92b0a5bf1a406384) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201957))
- [Add support for cyclonedx based dependency scanning](https://gitlab.com/gitlab-org/gitlab/-/commit/6250a856dadb22e9454f67d5b3d49fe3a39c22b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201034)) **GitLab Enterprise Edition**
- [Add RSS feed and calendar subscription to work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/e615501ccb04b1fea0411cb157f908ec98054837) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202053))
- [feat: Add manual reordering support to work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/0bf9c522bbadd370e1f780d57a2e6b38db22a606) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201754))
- [Allow granting approval permissions for Planner role](https://gitlab.com/gitlab-org/gitlab/-/commit/977d74cd5388f824cdfa550f9fc75c8dce7e7887) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200230)) **GitLab Enterprise Edition**
- [Add seat type on members added event to seat assignments](https://gitlab.com/gitlab-org/gitlab/-/commit/c0ded99c321aecb7f113f2987d1e535d971a27dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198594)) **GitLab Enterprise Edition**
- [Add branch selector for pipeline simulation](https://gitlab.com/gitlab-org/gitlab/-/commit/0fe0b72cdae15de1904117ea9b2c2592da263842) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200714))
- [Super topbar: Add logged out header items](https://gitlab.com/gitlab-org/gitlab/-/commit/804b8630e0cadc7ff4232063f2bee7e5c7446209) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202054))
- [Clone job inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/27b7fc6b4daaf6e7dc29a7a1aa9c5bf87f354df8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201778))
- [Extend Ai::UsageEventsFinder filtering with event name](https://gitlab.com/gitlab-org/gitlab/-/commit/1a2c9f910d4fabae262f42ac8a16cc40d590979c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202221)) **GitLab Enterprise Edition**
- [Migrate root_cause_analysis_users_count metric to new data source](https://gitlab.com/gitlab-org/gitlab/-/commit/64406057a0903c95c8768de424dde2276f0b4e06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201464)) **GitLab Enterprise Edition**
- [Add sharding key not null constraint on zentao_tracker_data](https://gitlab.com/gitlab-org/gitlab/-/commit/16540d5ad863be0a078992a3324e1d40626ff2a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202081))
- [Prepare indexes for merge_requests bigint conversion](https://gitlab.com/gitlab-org/gitlab/-/commit/d1cbee66e1316937adbd9bbd375b5ac025c77f0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196224))
- [Backfill security_inventory_filters table with initial data](https://gitlab.com/gitlab-org/gitlab/-/commit/e20e0aad55b69a7fa3b433fe1c969603791825eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199878)) **GitLab Enterprise Edition**
- [Log AuditEventService Initialization](https://gitlab.com/gitlab-org/gitlab/-/commit/639243a62c735dafacbb47b8baf4c5dddba4e481) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200775))
- [Add AI catalog latest_version (denormalize)](https://gitlab.com/gitlab-org/gitlab/-/commit/ed2379331bb8ef66377f9b9a428085fab6d5ab85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199849))
- [Expose work_item_id for legacy epics](https://gitlab.com/gitlab-org/gitlab/-/commit/0e63eab5b0cb2249d4ff9f9d7b521077c278643e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201938)) **GitLab Enterprise Edition**
- [Update instance audit event tables for schema](https://gitlab.com/gitlab-org/gitlab/-/commit/7acb556056ea7c1170aca5b0dc88e229387c4f60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201836))
- [Add GraphQL query for shared projects](https://gitlab.com/gitlab-org/gitlab/-/commit/3f32d591a77b43562419f486247361b59768650b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201823))
- [Add releases_path and project_import_jira_path to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/29e2180446627334007376a71d889b65c76d63f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201275)) **GitLab Enterprise Edition**
- [Add columns to p_ci_builds](https://gitlab.com/gitlab-org/gitlab/-/commit/6451fe0d9efd655da695023d9b92753f2740092c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198249))
- [Add SkippedIndexes view components](https://gitlab.com/gitlab-org/gitlab/-/commit/b700f391a6832369f16c0d804c19445a30e1aec9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201753))
- [Remove user_cache_group_member_roles FF](https://gitlab.com/gitlab-org/gitlab/-/commit/64d9cb19c06a81b6283121de31d31eb887a4bde7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201879)) **GitLab Enterprise Edition**
- [Add not null constraint on integrations table](https://gitlab.com/gitlab-org/gitlab/-/commit/39be4ef015308148264b650491e60bb7a6c146b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201468))
- [Add quick archive option to project dashboards](https://gitlab.com/gitlab-org/gitlab/-/commit/442f9750dd953c29dabf3c1e12899825af608f81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201847))
- [Add migration to backfill user_group_member_roles for direct membership](https://gitlab.com/gitlab-org/gitlab/-/commit/77bdd387d86fd3217e5ab2f35cfd2304ea0218a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200163)) **GitLab Enterprise Edition**
- [Geo Replicables - Support filtering by verification status](https://gitlab.com/gitlab-org/gitlab/-/commit/84494c53df4be290146d36bdec304d2fd1cc9346) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201633)) **GitLab Enterprise Edition**
- [Remove `update_external_diff_storage` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a2db4e455360fb7b271184d92c6456a9af2e3802) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201450))

### Fixed (148 changes)

- [Fix showing import button on empty issue list page](https://gitlab.com/gitlab-org/gitlab/-/commit/98c31370b1f98e8390f04dff8d32542df65b4ee1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204863))
- [Propagate recreating SlackIntegration records to descendant integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/326d2d90cfeba7bb3d350ef9c1eaf7fccff02453) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202671))
- [Catch NoMethodError when resolving url for labels](https://gitlab.com/gitlab-org/gitlab/-/commit/c5780a1dc52f896c3df2ffe2569e6764e23c981e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204554))
- [Add additional check for Duo action availability](https://gitlab.com/gitlab-org/gitlab/-/commit/bc5036382e156820d6d2ff1bfb5ce5e3442c5a76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204849)) **GitLab Enterprise Edition**
- [Fix ref name for pipeline types](https://gitlab.com/gitlab-org/gitlab/-/commit/f63261917e1efdfa8f42638bc4cd15ca19e337dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204910)) **GitLab Enterprise Edition**
- [Move thread_ts/parent_ts fields from timestamps to uuids](https://gitlab.com/gitlab-org/gitlab/-/commit/1708ae358d77f53409d759d20d3bfc0d60df64f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200487))
- [Fixes not fetching instance level setting](https://gitlab.com/gitlab-org/gitlab/-/commit/a62cb7cac3b1a8c8ff5a239bb381ffaf4ebe7453) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204839)) **GitLab Enterprise Edition**
- [Fix additional_context param to remote flows](https://gitlab.com/gitlab-org/gitlab/-/commit/3a1752718c1b33b7909a396bdd85519d95663c21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204788)) **GitLab Enterprise Edition**
- [Fix border radius for file comment header](https://gitlab.com/gitlab-org/gitlab/-/commit/66611d3166c95b63ae6b04bfbc66d5b70de79609) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204769))
- [Fix separator on new issue split button](https://gitlab.com/gitlab-org/gitlab/-/commit/b7b1117fb8bb840b9551d7b788a89763dadf1b8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204593))
- [Ensure text editor overlaps confidentiality warnings](https://gitlab.com/gitlab-org/gitlab/-/commit/37be9240d89c283a3e8552e9ac256072e07911de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204759))
- [Fix sidebar color picker input layout](https://gitlab.com/gitlab-org/gitlab/-/commit/0ff104875854cb71d7c58e0d8c8a3a1a20c0f0a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204604))
- [Fix pipeline jobs width](https://gitlab.com/gitlab-org/gitlab/-/commit/1aa9bddb5a1041ba3569453078a1325558e3cfc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200612))
- [Do not trim deployment filename in geo secondary](https://gitlab.com/gitlab-org/gitlab/-/commit/79f7b58ffaea476a1c0b08b5fbcba2758527b8c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202004)) **GitLab Enterprise Edition**
- [Fix work item sidebar height](https://gitlab.com/gitlab-org/gitlab/-/commit/d49ae5d0e7fd02d586fa0d3ced884c834d3d36ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204599))
- [Exclude other report types from scan readiness check](https://gitlab.com/gitlab-org/gitlab/-/commit/c44815fe1bee37be595ee6f3e7ce29e13469565a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204595)) **GitLab Enterprise Edition**
- [Fix FK error for DumpWriteBufferCronWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/2a22e7407a70ebdc74cde0358066c21c7c19b887) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204355)) **GitLab Enterprise Edition**
- [Open newly created Jira issue for vulnerability in same tab](https://gitlab.com/gitlab-org/gitlab/-/commit/c6448ea65126696588cb1545b0056fccd65b3456) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204526)) **GitLab Enterprise Edition**
- [Fix new project team activities not showing up in activity page](https://gitlab.com/gitlab-org/gitlab/-/commit/6a40ccabcb8647c864d69bafcfbe7594e474d99d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204509))
- [Fix ArgumentError for commits with invalid timezone offsets](https://gitlab.com/gitlab-org/gitlab/-/commit/b69753162e7109ec52a195a896b9bdcbed34a2f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204489))
- [Fix: Hide Automate pages and nav when disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/3ada528721646bc0205dd52526376c7d733006c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204425)) **GitLab Enterprise Edition**
- [Add limit to terraform state name](https://gitlab.com/gitlab-org/gitlab/-/commit/f15286d81f2b90376f8e1fb9ed752ff1d9d6e986) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203850))
- [Fix flaky test 737870](https://gitlab.com/gitlab-org/gitlab/-/commit/782a113aeeefafa9a353e6075d9de3b6caf3768e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203387))
- [Fix SlackIntegration duplicate bug when inheriting from parent](https://gitlab.com/gitlab-org/gitlab/-/commit/7b5c7eefe8b0cd986df1170bc1036e6d12320b89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203590))
- [Fix rounding on job log search input](https://gitlab.com/gitlab-org/gitlab/-/commit/b88958e5e5e43fc9e3315090ec14a065a4b9d053) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204381))
- [Remove duplicates from variable options](https://gitlab.com/gitlab-org/gitlab/-/commit/5fc213198cae652d91cf17d453e87b1707d494e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204377))
- [Fix member_role_policy ACL template for Openbao](https://gitlab.com/gitlab-org/gitlab/-/commit/f1919be04cb8aae8d05428f3ce16b45811a1b719) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202484)) **GitLab Enterprise Edition**
- [Set fixed-height on sticky header to prevent layout thrashing](https://gitlab.com/gitlab-org/gitlab/-/commit/4b4aa1144f5607d01cf8fc9786c46d4c294d1879) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203314))
- [Readd index_on_users_name_lower if necessary](https://gitlab.com/gitlab-org/gitlab/-/commit/871e6e126621a58c7ee907ebd324c8cdb0b0ab85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204067))
- [Fix audit event streaming to AWS S3 from new tables](https://gitlab.com/gitlab-org/gitlab/-/commit/07f8ae714e048c7375c0ac30cf924b811fc5de2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203507)) **GitLab Enterprise Edition**
- [Fixes mutation to update feature settings](https://gitlab.com/gitlab-org/gitlab/-/commit/377fc5e7ef1fe3948db932d32d4f14474324344b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204204)) **GitLab Enterprise Edition**
- [Add ci runner tags to dast site validation](https://gitlab.com/gitlab-org/gitlab/-/commit/8de10eb654bf408b96de7a65a997517d7d00b90e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202248)) **GitLab Enterprise Edition**
- [Avoid using discarded connection pools in load balancer](https://gitlab.com/gitlab-org/gitlab/-/commit/4ad8d32e0c5f07788370fb53d9ce245e153adbfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203779))
- [Fix border diff border radii in panels](https://gitlab.com/gitlab-org/gitlab/-/commit/5e8ad1c4435449ca49821ba2c46b03beadc568c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203721))
- [Prevent fetching expanded diff lines in linked file](https://gitlab.com/gitlab-org/gitlab/-/commit/ac9f202c4d541dd53e3bf745019c5faab76ce9a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204248))
- [Fix Linked file not being on top of the list](https://gitlab.com/gitlab-org/gitlab/-/commit/9c3836c7cd83ddecdb321ba393ad81bcb50cd7ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204244))
- [Fix security widget polling indefinitely when there are sboms](https://gitlab.com/gitlab-org/gitlab/-/commit/60160c63ed2f387998964eb87bd60d45cc9e2314) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204076)) **GitLab Enterprise Edition**
- [Replace window resize listener with resize observer](https://gitlab.com/gitlab-org/gitlab/-/commit/828afb79b021dbef1c1988381a09bf193fd2c37d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204219))
- [Fix NoMethodError when deleting merged branches via API](https://gitlab.com/gitlab-org/gitlab/-/commit/8545a3aab1e4dfcd5fed91dcdcce80e0081f278b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204159))
- [Fix TypeError: no implicit conversion of nil into String for Changelog](https://gitlab.com/gitlab-org/gitlab/-/commit/9702b3a2d5a33848b5959c6115866e251ed66cf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204152))
- [Allow auditor user to view feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/4cc52a05b704cfbd1a55656e01805fb0ffa56301) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203741)) **GitLab Enterprise Edition**
- [Fixes border radii of search box](https://gitlab.com/gitlab-org/gitlab/-/commit/fbc3f07320a9c3e7e4b70a864941e686e738f3de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204038))
- [Fix work item modal footer](https://gitlab.com/gitlab-org/gitlab/-/commit/97c719b19765c72757ff08206a01886522646d8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204041))
- [Fix search admin page error when ES server returns forbidden](https://gitlab.com/gitlab-org/gitlab/-/commit/96c66614cf2f7961ef261ccf204969c8d0845c4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204022)) **GitLab Enterprise Edition**
- [On job archival allow cleanup while preventing updates](https://gitlab.com/gitlab-org/gitlab/-/commit/9f90af6851d7f731a22c18519aac669d44da1261) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203315))
- [When work item is in a panel, treat it like a drawer container](https://gitlab.com/gitlab-org/gitlab/-/commit/43eda51030b11804983275f43058b7f7f2ef83a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203729))
- [Skip unchanged renamed files in secrets check](https://gitlab.com/gitlab-org/gitlab/-/commit/4e27ba48005572b4365b45fd8ab8ca6ab9ad41a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203036)) **GitLab Enterprise Edition**
- [Fix archive design on the work items detail](https://gitlab.com/gitlab-org/gitlab/-/commit/fd683495913aa1887fe38bfa7b65a314c2345130) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203949))
- [Update gitlab-shell to v14.45.2 to allow ED25519 for FIPS](https://gitlab.com/gitlab-org/gitlab/-/commit/434700feca8a004b1c4863bb9823c1f2aedaee0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203930))
- [Use StrongMemoize for memoizing state of Prometheus metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/048e4edee3e75aa8db7b11188f9851ecfaff7ac3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203888))
- [Fix environment terminal layout](https://gitlab.com/gitlab-org/gitlab/-/commit/ff5b31f99fa894846a21f167a0313ea56ee8cd44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203903))
- [Fix new namespace page breadcrumbs when project studio is enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/a29894602e5d59156c2d16ad1438ac97c021f660) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203727))
- [Lower exclusive lease log level for PAT usage update](https://gitlab.com/gitlab-org/gitlab/-/commit/e7a146f5792120c9300a7a5da7848a195db74df1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203980))
- [Fix MRs to not allow resolving all threads for Reporters](https://gitlab.com/gitlab-org/gitlab/-/commit/59457290364e9f398d697454627e8a91a0bc30a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200649))
- [Refactor branch graph to support keyboard focus and events](https://gitlab.com/gitlab-org/gitlab/-/commit/75393ab61feb828159c1f6851dfa7004ca6d41a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203014))
- [Internal projects cannot be cloned with job token](https://gitlab.com/gitlab-org/gitlab/-/commit/226d2e16c8c98fed620fd9376ea0c64b3f532199) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197620))
- [Encode tag name in release API](https://gitlab.com/gitlab-org/gitlab/-/commit/45661caa694dc1022d96d306390fd5c386570100) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203742))
- [Trigger webhook for auto-resolved vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/2c58b6265593a58387b34d71f0df33aef7543b35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202357)) **GitLab Enterprise Edition**
- [Provide the correct line range when opening the comment editor](https://gitlab.com/gitlab-org/gitlab/-/commit/8c29ed739c70f1f5ccc069bb44a1da928d21c883) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202711))
- [Add iteration and label lists to group issue boards](https://gitlab.com/gitlab-org/gitlab/-/commit/aad999c15e01dc85739e9a740ca04a7a160fd47b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202374))
- [Restore admin job count](https://gitlab.com/gitlab-org/gitlab/-/commit/81e5cbb2c36c876f840c32c8396bce8c18619008) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203699))
- [Fix Encoding::UndefinedConversionError in RemoteService](https://gitlab.com/gitlab-org/gitlab/-/commit/6e575866f6b385ce52f7e973ab190f16fe88ed5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203684))
- [Update work item dates widget to use localized format](https://gitlab.com/gitlab-org/gitlab/-/commit/b1bcc344b4a9e9bb08c86ea8a86472e55cc5c333) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203555))
- [Destroy pipelines before destrying merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/7dbf2971a41b388774dbfdf654747605dbaf308c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203232))
- [Fix pipeline duration display when equal to 0](https://gitlab.com/gitlab-org/gitlab/-/commit/b789ad3180a2b6e8da7653729dbaa9440c947ea9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203423))
- [Rewrite all corrupted tokens before saving in `reset_encrypted_tokens`](https://gitlab.com/gitlab-org/gitlab/-/commit/40c4ade44ef0c0fc0c525c4e8de84e645299dde0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203283))
- [Explicitly define the MR and Issue create button text](https://gitlab.com/gitlab-org/gitlab/-/commit/31a3c332bd5b87704f84f258b35b53fc6b59b703) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203195))
- [Pass the correct lines to the reply box for multi-line comments](https://gitlab.com/gitlab-org/gitlab/-/commit/b8a76e184a50a8d8554bf440b3a38b36f46e6680) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202464))
- [Make FileLocationType.endLine nullable](https://gitlab.com/gitlab-org/gitlab/-/commit/f102c6c6b05408c0beea63b2c1c504edb7e01231) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203307)) **GitLab Enterprise Edition**
- [Assign project target_type to newly created project events](https://gitlab.com/gitlab-org/gitlab/-/commit/cb1cb6e808b774d094d363866e52c63aef3310c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203046))
- [Fix orphaned job artifacts deletion order](https://gitlab.com/gitlab-org/gitlab/-/commit/f37a38001e1c1465b858e3ee6ffac7b2cfcbadf6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203494))
- [Do not set relative_position with the Epic ID](https://gitlab.com/gitlab-org/gitlab/-/commit/382010dc7055b5046bdfab9b4d0bbc621298ad01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203436)) **GitLab Enterprise Edition**
- [Preserve the exact string representation of the URI](https://gitlab.com/gitlab-org/gitlab/-/commit/dc1497fe2521dfc1d1673344f26380a84d792f0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203157)) **GitLab Enterprise Edition**
- [Cleanup feature flag for ordering by semver in Terraform modules](https://gitlab.com/gitlab-org/gitlab/-/commit/24bb4b17bad11726c5ffa84bfbb063ca5db790a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203438))
- [Fix branches autocomplete paths in the merge request list app](https://gitlab.com/gitlab-org/gitlab/-/commit/479ed098156189c3618dbd2cdb59d03ba31311c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203417))
- [Fix nil error in Gitlab:Auth:IpRateLimiter](https://gitlab.com/gitlab-org/gitlab/-/commit/f37595feba6674e29ef68645669e43b8919ca9cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203381))
- [Fix License Compliance widget link for MRs with deleted source project](https://gitlab.com/gitlab-org/gitlab/-/commit/bb0bc47c6c02245944d6d1e0fd6ade74d0662435) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202910)) **GitLab Enterprise Edition**
- [Fix sbom ingestion for single cs cyclonedx reports](https://gitlab.com/gitlab-org/gitlab/-/commit/a61c9651ceeca689516d6b8e90d9f676e81eb20d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202789)) **GitLab Enterprise Edition**
- [Rescue NoMethodError when organization id is not available](https://gitlab.com/gitlab-org/gitlab/-/commit/2a8e1493b9d2d022380b72284ebe50446e336255) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203295)) **GitLab Enterprise Edition**
- [Fix namespace filters for external streaming destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/af3726e87e1e0e888dccf07543f5026bb8d41138) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198000)) **GitLab Enterprise Edition**
- [Fix user avatar for Duo Agentic Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/70da8e17a4b3e6a23f4d8faf4187b0c654ea621e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203277)) **GitLab Enterprise Edition**
- [Fix scrim styles for code blocks in Duo chat](https://gitlab.com/gitlab-org/gitlab/-/commit/3895ea91aec5f197ae0b72c9543bcaf4415aa7b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203136)) **GitLab Enterprise Edition**
- [Fix encoding of patterns in Gitaly `list_refs` calls](https://gitlab.com/gitlab-org/gitlab/-/commit/0916cf5a3373120c0c4f892c9d53fe0376468618) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203261))
- [Fix encoding error in DetectRepositoryLanguagesWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/c31a3a748f26c9752e30444709944273289d4230) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203264))
- [Fix LdapAllAddOnSeatSyncWorker removing seats when no groups configured](https://gitlab.com/gitlab-org/gitlab/-/commit/c6c4c71fd8a654a11bd1b580237437e34b2c6b32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202779)) **GitLab Enterprise Edition**
- [Fix alignment status cell on vulnerability report](https://gitlab.com/gitlab-org/gitlab/-/commit/5a09d06d18a97704298cf26ee0af7c2f3a2808ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203224)) **GitLab Enterprise Edition**
- [Add group-level indicator to branch protection](https://gitlab.com/gitlab-org/gitlab/-/commit/f032405d00a262c73870b3e106e8bb1d8694c0aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202058)) **GitLab Enterprise Edition**
- [Fix Duo chat's behavior when window is vertically resized](https://gitlab.com/gitlab-org/gitlab/-/commit/2f99b701051b7b1459a9747c4439aa82b6f8f7f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203022)) **GitLab Enterprise Edition**
- [Fix only_allow_merge_if_pipeline_succeeds for security policy projects](https://gitlab.com/gitlab-org/gitlab/-/commit/fff274f7a24f05575ff763bb288aa95ae6909d35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201948)) **GitLab Enterprise Edition**
- [Hide "Create merge request" option when merge requests are disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/9d4757c4e7f31151191af11c0ed0fa4f3cd9a68c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202272))
- [Handle false exception](https://gitlab.com/gitlab-org/gitlab/-/commit/dc093a5ba45c9c1e4c32fa63ded6ab9c34bc506f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203060)) **GitLab Enterprise Edition**
- [Fix referencing group work items](https://gitlab.com/gitlab-org/gitlab/-/commit/83f55dc059906ecd7a3afd4cfd1d8b192e13179a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203066)) **GitLab Enterprise Edition**
- [Remove unused indexes from members table](https://gitlab.com/gitlab-org/gitlab/-/commit/f61b12289013f85812c2da3c081c30e018ec2ba0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202871))
- [Fix style of todo items](https://gitlab.com/gitlab-org/gitlab/-/commit/1d362aa411bd1ea20c40f68bfca98cc8eb12ffc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203012))
- [Fix webauthn authentication in Firefox](https://gitlab.com/gitlab-org/gitlab/-/commit/32bf29f43a45d5be2a2b6493212c16f8228bc673) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202988))
- [Reimplement the refreshCurrentPage JS functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/25d8e458b76129f3a4d3ed274cf4386d989f180e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202971))
- [Fix shared group access for advanced code search](https://gitlab.com/gitlab-org/gitlab/-/commit/f5c5b794fd5469db423ec129f8e7d0462a0cd08a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202403)) **GitLab Enterprise Edition**
- [Fix: unhandled exception Gitlab::Git::InvalidPageToken](https://gitlab.com/gitlab-org/gitlab/-/commit/2d099e66f0b62e3cc05a28adc452c4e7e08de03c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202894))
- [Fix parent dropdown being empty in modal view](https://gitlab.com/gitlab-org/gitlab/-/commit/a8851e55baafc1cc64dfdd51d0b3aef5890e4ca4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202849))
- [Update gitlab-shell to v14.45.0](https://gitlab.com/gitlab-org/gitlab/-/commit/039714c321982248df7320840e1219665e4ba31e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202825))
- [Normalize package_name for dependency scanning](https://gitlab.com/gitlab-org/gitlab/-/commit/e2796c70d15940df722d348a85ffd30a7259810a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202145)) **GitLab Enterprise Edition**
- [Fix json format requests where ref is in path](https://gitlab.com/gitlab-org/gitlab/-/commit/5813a24cae1885d1aa2e7e46c9d4355785a7effe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202104))
- [Fix maintainers of group runner groups not able to see jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/a6e285328123fe933bdde641680a8202f5621b8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202246))
- [Add alt text descriptions to branch graph and avatar](https://gitlab.com/gitlab-org/gitlab/-/commit/57d575c6db442eb1d870bdbad101f3464c306a2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202138))
- [Refetch pipeline findings when dismissing from modal](https://gitlab.com/gitlab-org/gitlab/-/commit/c6819b8b682cc761cc620fc78a925a0eeb312a57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202254)) **GitLab Enterprise Edition**
- [Properly close the stream in Rapid Diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/6af0b5fe8a94472b21357699971bb88e18f7e07a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202099))
- [Only create ToC for headings with links](https://gitlab.com/gitlab-org/gitlab/-/commit/e31a1a09bd4a4d485da9097e5d90845a157ea1b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201954))
- [Release page: Fix release assets field alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/2e1fb8669699977482d43cea90b04e877b6d723b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202730))
- [Fix server error when using securityScanners type](https://gitlab.com/gitlab-org/gitlab/-/commit/0da4f2c648a72f2f4af57e18d6ab7c74c93e7c7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202691)) **GitLab Enterprise Edition**
- [Fix incorrect import for `glLicensedFeaturesMixin`](https://gitlab.com/gitlab-org/gitlab/-/commit/feaba632592f838d10d488ac047735fe7b3c2376) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202686)) **GitLab Enterprise Edition**
- [Fix webhook event logic in RemoveApprovalService](https://gitlab.com/gitlab-org/gitlab/-/commit/7ff8b8d8b07280fa236d49b3a361c7650eda981c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200263)) **GitLab Enterprise Edition**
- [Fix redundant subscription calls](https://gitlab.com/gitlab-org/gitlab/-/commit/9f7f04839efa4c4d56fd81ac88e3b25af127d109) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202433))
- [Fix trusted proxies regression when hostname is specified](https://gitlab.com/gitlab-org/gitlab/-/commit/f5291e0c987a0be7910375c43caca568a40f83a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202653))
- [Auto-resolve vulnerabilities that are already no longer detected](https://gitlab.com/gitlab-org/gitlab/-/commit/b5525dabe7f6503545c106fd16834a8776041789) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202655)) **GitLab Enterprise Edition**
- [Fix: Atom feed broken when supplying ref_type](https://gitlab.com/gitlab-org/gitlab/-/commit/8e068926102436c11f502f9f5f340d572b93befe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202602))
- [Fix moving epics to a new group](https://gitlab.com/gitlab-org/gitlab/-/commit/d078c265070fb9125a8459bd7deb2a213f842f76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202603)) **GitLab Enterprise Edition**
- [Fix 404 handling for invalid blob references in snippets](https://gitlab.com/gitlab-org/gitlab/-/commit/deb2e26665e9c75218b2b620699af911e24cd8a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202574))
- [Fix parent web url in create work item view](https://gitlab.com/gitlab-org/gitlab/-/commit/b84bb5700b7eff0dfde573d0fdd0d8f0ca8dcba5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202007))
- [Fix `<mark>` styling in Rich Text Editor](https://gitlab.com/gitlab-org/gitlab/-/commit/7145eda04c6cf9353a644b30a4c3c4b7228be872) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202444))
- [Fix the rendering when content is empty](https://gitlab.com/gitlab-org/gitlab/-/commit/1dd9a541f4d280f6393525dd2e56a43df3e7f8ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202049))
- [Set OAuth access token class to OauthAccessToken](https://gitlab.com/gitlab-org/gitlab/-/commit/5b3fd927f72840579cb127528ce12196f8dcde0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202322))
- [Bulk sidebar: Fix border bleeding into layout when collapsed](https://gitlab.com/gitlab-org/gitlab/-/commit/e0c16aa7991c6e55cb13cf98f728e6b7bbbd190b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202367))
- [Fix text syling of security scores](https://gitlab.com/gitlab-org/gitlab/-/commit/c63dbc3d6e1cea690befa9b98f8c188e1edee3a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202349)) **GitLab Enterprise Edition**
- [Remove optimized_snippet_search_query feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3c3b084910c8886a9d766d454666ddee7c9cbcb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202348))
- [Fix positioning of work item sticky alerts](https://gitlab.com/gitlab-org/gitlab/-/commit/889f95a66a2ca036dc09bc1369f663d72f278e8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201367))
- [Remove confidentiality toast on error](https://gitlab.com/gitlab-org/gitlab/-/commit/a93fdac049e9c17d564d9d13d597bc0d61a31e6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202312))
- [Fix feature flags list](https://gitlab.com/gitlab-org/gitlab/-/commit/69065c308f0679b9692aef85f728ad6382059178) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202301))
- [Update stop environment button](https://gitlab.com/gitlab-org/gitlab/-/commit/c4179d08d342c366758df6448659d725022dd6d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202244))
- [Fix ES sync with deleted vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/d39a4cb52b5b4d0923a8d844a6fc1edd5a823214) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200615)) **GitLab Enterprise Edition**
- [Provide unique labels for FF actions](https://gitlab.com/gitlab-org/gitlab/-/commit/da4a75bf697b62847c5d08d305fbcc6926a21204) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202264))
- [fix: Show correct error message when container is deletion protected](https://gitlab.com/gitlab-org/gitlab/-/commit/9f81e5a7c652016f5f9280bbcdfd403d80b84729) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199920))
- [Fix incorrect SAST php exists rule](https://gitlab.com/gitlab-org/gitlab/-/commit/ee3f91e65a8e04bdc256391bf15b562bba17a711) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200262)) **GitLab Enterprise Edition**
- [Update page title for environment show page](https://gitlab.com/gitlab-org/gitlab/-/commit/be4b40780a794761dd07e266d10e1be74dceee7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202149))
- [Set new_threshold for group_destroy_worker](https://gitlab.com/gitlab-org/gitlab/-/commit/e0090b7aae0722b732fb0982c9ab3b207abce835) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202125))
- [Fix rollup computation from hierarchy widget](https://gitlab.com/gitlab-org/gitlab/-/commit/4802c9f44ecdb7d7e7937877b861a627955d00a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202119)) **GitLab Enterprise Edition**
- [Add ORDER BY to vulnerability namespace statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/0f77e88b2041347b6a24e9eb2a09d0634444faa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200556)) **GitLab Enterprise Edition**
- [Fix more bugs in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/2aea2ab3601dc4419df8e9ac8a6d13da5a7f45ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202050))
- [Update software_licenses_policies with non-spdx identifiers](https://gitlab.com/gitlab-org/gitlab/-/commit/62457ca181bd75598b7c7203cce772dd879815ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195704)) **GitLab Enterprise Edition**
- [Fix /status quick action autocomplete for plain text editors](https://gitlab.com/gitlab-org/gitlab/-/commit/f3d1951531e48f9f510b8286c390773b95560214) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201959))
- [Fix Gemfile.next for gitlab-activerecord](https://gitlab.com/gitlab-org/gitlab/-/commit/07e08b3be609bb64d55d1a144ab8821cbd87b3db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201913))
- [Update authorization check for project runner show page](https://gitlab.com/gitlab-org/gitlab/-/commit/21c70d911b923be6ea37071164112b555430082e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198692))
- [Fix X.509 certificate creation with blank or invalid email addresses](https://gitlab.com/gitlab-org/gitlab/-/commit/fbe74fd31768d61fc0ad87ecb5d41c868abcc738) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201887))
- [Ignore silent_mode in clickhouse http calls](https://gitlab.com/gitlab-org/gitlab/-/commit/f67098c00ac050708a68b083dffd8090f02f2492) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201447))
- [Show full timestamp for deployment widget](https://gitlab.com/gitlab-org/gitlab/-/commit/676dd5dcf92be4f55b367c503207912bc9d56236) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201746))
- [Fix HTML decoding in related issues error message](https://gitlab.com/gitlab-org/gitlab/-/commit/aa903b41830a7b7e31b63642dd9a62d02f69d7cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201826))
- [Ensure only projects from same org can be assigned to the runner](https://gitlab.com/gitlab-org/gitlab/-/commit/ca04bf790cde9d42f7fb9d24dcab505ffa1bf281) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201355))
- [Move repeated test to a shared example](https://gitlab.com/gitlab-org/gitlab/-/commit/2fda6ec0d9e063ef6a9062f869319e352d789045) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200989)) **GitLab Enterprise Edition**
- [Fix cache invalidation for the diffs_batch.json endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/ed956d0ed281afdf10de0853f17d0eed9205e122) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201028))

### Changed (191 changes)

- [Revert "Merge branch...](https://gitlab.com/gitlab-org/gitlab/-/commit/bbf3d1ccc2cdb191c767b3883ed6e0b43b0ccc74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205007))
- [Show only active vulnerabilities on the dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/a734b7996decffd960f394f7da8ae53757d1ed0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204049)) **GitLab Enterprise Edition**
- [Update order of zoekt query conditions](https://gitlab.com/gitlab-org/gitlab/-/commit/fc8c3f5da1f4721e1956dad6470cb9ab4be1183d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204978)) **GitLab Enterprise Edition**
- [Improve placeholder bypass confirmation error handling](https://gitlab.com/gitlab-org/gitlab/-/commit/e194db7ce5f9d84dced3455cbe9263d877f1df69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203177))
- [Fix: Agentic Chat can be used when Chat model selected](https://gitlab.com/gitlab-org/gitlab/-/commit/c49b84a46080accd48a4963169870b7e47e08655) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204757)) **GitLab Enterprise Edition**
- [Balance zoekt nodes by query load](https://gitlab.com/gitlab-org/gitlab/-/commit/dea7fe9920c4b6184ece3025ad5420d2df2710ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204780)) **GitLab Enterprise Edition**
- [Improve compliance framework status drawer for passed controls](https://gitlab.com/gitlab-org/gitlab/-/commit/899a11cdb5624fb8c9a846722f3566cfd9bb9d0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204246)) **GitLab Enterprise Edition**
- [Add variant prop to DuoWorkflowAction](https://gitlab.com/gitlab-org/gitlab/-/commit/c4f77089040a6fa64f464f5356ff366f822e21a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204886)) **GitLab Enterprise Edition**
- [Replace JWT user auth with CEL](https://gitlab.com/gitlab-org/gitlab/-/commit/4d8be9168e60a055256081fec353b433f8160b98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203172)) **GitLab Enterprise Edition**
- [Feat: Enhance policy dismissals with types and comments](https://gitlab.com/gitlab-org/gitlab/-/commit/de66f71262aa1628fe64c656cd0236c38531e15f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204596))
- [Keep archive settings button on loading state after archiving](https://gitlab.com/gitlab-org/gitlab/-/commit/dc5a336d974aabe2cadde073f8cf3c871e6c270c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204621))
- [Change root cause analysis button position](https://gitlab.com/gitlab-org/gitlab/-/commit/84143c06c68c0717ef2b9f4c62dc6b0cec95b591) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204827))
- [Upgrade Gitaly Gem to 18.4.0.pre.rc1](https://gitlab.com/gitlab-org/gitlab/-/commit/e4f09e656a19986bb8e0b835e603cc70196d5371) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204189))
- [Simplify Duo Workflow Action component](https://gitlab.com/gitlab-org/gitlab/-/commit/6aa82ac25506457830c3e6a4008bf5ef486d1ea4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203837)) **GitLab Enterprise Edition**
- [Add workspaces proxy enabled db options](https://gitlab.com/gitlab-org/gitlab/-/commit/d200e32b86ddd13dea67021fab75753bcbf64e21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204471))
- [Add word break to framework report policy column](https://gitlab.com/gitlab-org/gitlab/-/commit/4429a7fc13b384696572399210edcf5bdf2ed819) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204790)) **GitLab Enterprise Edition**
- [Migrate find_file interface to container queries](https://gitlab.com/gitlab-org/gitlab/-/commit/89618d31036f6fa81e0f25f17d65fd72faaa499d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204733))
- [Migrate commit file view to container queries](https://gitlab.com/gitlab-org/gitlab/-/commit/374a6454ecb4d39447beb6b509f7b75192504c7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204727))
- [Add widget for branch push event](https://gitlab.com/gitlab-org/gitlab/-/commit/2e9472e02d37d6f7f7a2b06512955198ef4b6642) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202434))
- [Enable workingDir for poststart commands](https://gitlab.com/gitlab-org/gitlab/-/commit/c2e3baff232011ec8f9a25d6a2e929e1cd91dfd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203029)) **GitLab Enterprise Edition**
- [Rename `AI Impact analytics` to `GitLab Duo and SDLC trends`](https://gitlab.com/gitlab-org/gitlab/-/commit/68ce7507b16dcc4bafd6e59d7da910cb0e82d105) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204400)) **GitLab Enterprise Edition**
- [Add shortcuts to AI catalog in global search](https://gitlab.com/gitlab-org/gitlab/-/commit/2ef270bab8fc2b349f0d077d81d176366e079430) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202778))
- [Fixes issues with FetchModelDefinitionsService](https://gitlab.com/gitlab-org/gitlab/-/commit/9bd6bb7511b69c5f791e5da2386c165a5cc5dc33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204584)) **GitLab Enterprise Edition**
- [Add user status into tooltip](https://gitlab.com/gitlab-org/gitlab/-/commit/301d338c8dc88fc0b93bd6c8b9dc6266319fd530) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203859))
- [Refactor TrialDurationService to use Rails.cache](https://gitlab.com/gitlab-org/gitlab/-/commit/1aaf093b2375087680a1e0b496fe58e01eadeb9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204014)) **GitLab Enterprise Edition**
- [Replace icon and text for navigation sidebar toggle](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1d33d0a9c577548e7c4e59dd8d0734ac0deb76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204416))
- [Add NOT NULL constraint for identities -> user_id](https://gitlab.com/gitlab-org/gitlab/-/commit/7df2b6385883194ebd4e5d6eb1889251b07ed2c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202814))
- [Put adding x-gitlab-base-url header behind an FF](https://gitlab.com/gitlab-org/gitlab/-/commit/0547d18fc0687c98b8c5444aa72a006e5f4e957b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204647)) **GitLab Enterprise Edition**
- [Disable policy edit menu](https://gitlab.com/gitlab-org/gitlab/-/commit/ab323c0cf6df0840a01adb9aa104a2da806f06dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203589)) **GitLab Enterprise Edition**
- [Update what's new featured carousel cards](https://gitlab.com/gitlab-org/gitlab/-/commit/0715b13228673b885dabf821d832f64a6ab30c2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204291))
- [IaC control check the right artifact and job](https://gitlab.com/gitlab-org/gitlab/-/commit/2b801d52e42620b89801a1e5325971fadb2aad44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202863)) **GitLab Enterprise Edition**
- [Migrate project settings to container queries](https://gitlab.com/gitlab-org/gitlab/-/commit/f71d2d5391f0714b301343635649b4d2d147c982) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204553))
- [Adds GCP bucket config for SQL traffic replay](https://gitlab.com/gitlab-org/gitlab/-/commit/d9d7e3ad4d23396d9b05f42846715431841c21b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202140))
- [Updates default for SM/Dedicated model selection](https://gitlab.com/gitlab-org/gitlab/-/commit/0d92aea71ca205f726fe9a519cd8e7e667c08434) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204546)) **GitLab Enterprise Edition**
- [Adjust agent privileges for fix pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/800285bf25c47288c1a729d1d7f2fbc7450ec01d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204469)) **GitLab Enterprise Edition**
- [Set integrations sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/903deb33548abe182fe6eb931f5ee0de1d3490c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203677))
- [Swap bigint columns on merge_request_diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/ff28e66a367eb90f25215516d353a3d18ef3ebb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201471))
- [Clean up old topic indexes for supporting organizations](https://gitlab.com/gitlab-org/gitlab/-/commit/4ac6d82584e82acbde99649e222cdfb7377f7085) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203691))
- [Rename and reorder AI impact analytics metric tables](https://gitlab.com/gitlab-org/gitlab/-/commit/4986cd44a8346228e01671a464cae276a8181425) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204236)) **GitLab Enterprise Edition**
- [Change newest_first default source filter behavior](https://gitlab.com/gitlab-org/gitlab/-/commit/df8beaa424a719786ac50efb8b9eddf3dec2f6e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203021))
- [GitLab managed keys for Claude CLI (Third Party Agents)](https://gitlab.com/gitlab-org/gitlab/-/commit/4c19af16392f813042312eb635baeda8317400de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202752)) **GitLab Enterprise Edition**
- [Add advanced search to search admin UI titles](https://gitlab.com/gitlab-org/gitlab/-/commit/1168322ef148bff2086039b496413d8355959c83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204258)) **GitLab Enterprise Edition**
- [Improve Media Bubble Menu accessible labels](https://gitlab.com/gitlab-org/gitlab/-/commit/14b8706f863789143267f64f2e6865b6f57d529b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204268))
- [Improve spacing in custom fields](https://gitlab.com/gitlab-org/gitlab/-/commit/37afaac5b1f16b74a69be218b1b3fd0f6a1b2b06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204374))
- [Update UX of Fix pipeline button](https://gitlab.com/gitlab-org/gitlab/-/commit/65c2f9f55e9fe7bcc12de8ce49ec9b054715ceca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204324)) **GitLab Enterprise Edition**
- [Modify DB schemas for Geo support for Packages::Nuget::Symbol](https://gitlab.com/gitlab-org/gitlab/-/commit/6d4bc6d520463a4750acf1b006044b98f79c4bf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203221)) **GitLab Enterprise Edition**
- [Remove empty dependencies rule](https://gitlab.com/gitlab-org/gitlab/-/commit/ad92f1c59cf065f539387231c09154ea58e0cc44) by @YashaRise ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202525))
- [Add popover for file tree browser discoverability](https://gitlab.com/gitlab-org/gitlab/-/commit/544876b9bfe95d74a1f6efa285774168de7752a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202647))
- [Fully rollout (remove) feature flag for cloudflare for Duo Workflow](https://gitlab.com/gitlab-org/gitlab/-/commit/23b5e53fe0f5ebc4a41fd0f75cc1418fdad89a68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203179))
- [Allow copying session ID in agentic chat](https://gitlab.com/gitlab-org/gitlab/-/commit/14e3b26770159b1d2f9eea69cc1cc1f49133a6de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203854)) **GitLab Enterprise Edition**
- [Rename composer package class](https://gitlab.com/gitlab-org/gitlab/-/commit/bca0c1be1dea27308985349371c2ff5089db732e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195745))
- [Duo Chat: Map "directory" category to repository FF](https://gitlab.com/gitlab-org/gitlab/-/commit/ec4c6528ab79ad58b1e6c09180cf1bde0fc22125) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203612)) **GitLab Enterprise Edition**
- [Document git fetch changes](https://gitlab.com/gitlab-org/gitlab/-/commit/400b8103476f51a83f4d6558723b1b9603ee482a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204008))
- [Add Rails 7.1 as default configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/897e32773fc6040a544544585cb55b901ca9e775) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203744))
- [Check manual variables setting on pipeline page](https://gitlab.com/gitlab-org/gitlab/-/commit/c74115b62f86256da9e144681c58559e970b5ce7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204267))
- [Direct Transfer should respect group membership lock](https://gitlab.com/gitlab-org/gitlab/-/commit/2b81b111df371c79c7fab1be146ea769309c8ecb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202059)) **GitLab Enterprise Edition**
- [Add ability to find scoped user by primary user and invert identity](https://gitlab.com/gitlab-org/gitlab/-/commit/054d3504fd069cb15136378cef8e9a6ba3c0ca0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204010))
- [Geo Replicables - Sentence casing](https://gitlab.com/gitlab-org/gitlab/-/commit/e485ef4c029720a2eb475674d45aae30d5ebe3d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203711)) **GitLab Enterprise Edition**
- [Limit ConcurrencyLimitSampler to current queue workers](https://gitlab.com/gitlab-org/gitlab/-/commit/020f36edf8bb117e613f06e998ba2ae4da99c508) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204196))
- [Expose the clear_status_at field in the GraphQL UserStatusType](https://gitlab.com/gitlab-org/gitlab/-/commit/54f4f5aa82ce6e526fdb8d12c169b5bd73c1efed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203853))
- [Remember active thread in agentic chat](https://gitlab.com/gitlab-org/gitlab/-/commit/36cd1558afa6a9ff4978b686e933ca9a66d73849) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203653)) **GitLab Enterprise Edition**
- [Add internal API endpoint for workspace authorize user access](https://gitlab.com/gitlab-org/gitlab/-/commit/8d902eb2ae52bb8f1b1e0574de04085aea61e62d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203350)) **GitLab Enterprise Edition**
- [Include namespace data for CSP framework identification](https://gitlab.com/gitlab-org/gitlab/-/commit/a222ae5656c6a2971299809c88f10a7b284c16d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203604)) **GitLab Enterprise Edition**
- [Use strong_memoize for tag_names and branch_names](https://gitlab.com/gitlab-org/gitlab/-/commit/ac6b3562c15ae012a048010abf506042e614669d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200286))
- [Geo Replicables - Improve bulk action modals](https://gitlab.com/gitlab-org/gitlab/-/commit/3bc9213de35f50dc985c40d74ed0c61568a3124f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203880)) **GitLab Enterprise Edition**
- [Feat: Add ai legal disclaimer to new agent session and new flow trigger pages](https://gitlab.com/gitlab-org/gitlab/-/commit/254c51cdd26e8423d45d5c4a7d50a44205a8f109) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203712)) **GitLab Enterprise Edition**
- [Set max-height on textarea](https://gitlab.com/gitlab-org/gitlab/-/commit/152e09e14dcd3ee0f72e9fd1bba3ad22b0d1416d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204068))
- [Update duo workflow service client](https://gitlab.com/gitlab-org/gitlab/-/commit/97340b33591596e045f44447adfc12521bc869db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203644)) **GitLab Enterprise Edition**
- [Update gitlab.yml example file](https://gitlab.com/gitlab-org/gitlab/-/commit/7c1354ce7f55969603256733d068f37ecbb1c975) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204023))
- [Updates user preferences for Project Studio](https://gitlab.com/gitlab-org/gitlab/-/commit/e77b729f415d224c32397df852a44142b0526d08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203827))
- [Update audit event tables sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/95f7b5540956ada69609499c4c103cc1ce2c497b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202547))
- [Migrate ghost records migrate audit events to Auditor](https://gitlab.com/gitlab-org/gitlab/-/commit/c533a11d780a1cc23fa065d11fe3324c79298761) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203756)) **GitLab Enterprise Edition**
- [Bump devfile gem to '0.4.8'](https://gitlab.com/gitlab-org/gitlab/-/commit/6f34b9bde3c41e91fce4701c1de16c9b36754da7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203939)) **GitLab Enterprise Edition**
- [Add internal API endpoint for agentw info](https://gitlab.com/gitlab-org/gitlab/-/commit/fa8c3877c0cc2bd2821dd74df76519f4de7d40b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203349)) **GitLab Enterprise Edition**
- [Add index on zoekt repositories for schema checks](https://gitlab.com/gitlab-org/gitlab/-/commit/5478e18e7e62354d66477d24d59fe08c9878e46e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203749))
- [Remove extra spacing from template](https://gitlab.com/gitlab-org/gitlab/-/commit/c79b116101814b0bc056f9df50f11ba59696cdba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203922))
- [Fix CSS for Admin area user projects page](https://gitlab.com/gitlab-org/gitlab/-/commit/e1e21e5138929a1480d5eeec037de1c0b677e960) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203915))
- [Remove ci_restrict_cookie_auth_linting feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5e77e4fca25b97baa26a55fd34c07ed3a65d0c39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203863))
- [Add support for Workspaces OAuth app](https://gitlab.com/gitlab-org/gitlab/-/commit/251bb3ad5221d7c76cec0735a039b198479f5164) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194652)) **GitLab Enterprise Edition**
- [Clarify retention policy for job names](https://gitlab.com/gitlab-org/gitlab/-/commit/b7fd05838251259abf8c36035cb3abd568b6dfb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203410))
- [Remove optimize_merge_requests_banned_users_query FF](https://gitlab.com/gitlab-org/gitlab/-/commit/c9e5ac5397fdfff3128f1f54208a646742c80c9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203785))
- [Added token status verification to Pipeline Security Report](https://gitlab.com/gitlab-org/gitlab/-/commit/6690108181d275a6bdf34e03efcda8376cad0b28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202819)) **GitLab Enterprise Edition**
- [Move self-hosted Duo Code Review to generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/0d37df45d4e6fd1958f40945b05a7197f57cc6f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201323)) **GitLab Enterprise Edition**
- [Track merge request approval policy sync state](https://gitlab.com/gitlab-org/gitlab/-/commit/9f7aeca53b7bda072cd167880e47a597e3f091c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201782)) **GitLab Enterprise Edition**
- [Prevent transfers involving archived groups and projects](https://gitlab.com/gitlab-org/gitlab/-/commit/ce7442c8124a31717e62319dbec0344bb6fc98d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203476))
- [Update project archive settings UI](https://gitlab.com/gitlab-org/gitlab/-/commit/fef30749950860144312a9a8d54800c67b973374) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203187))
- [Remove feature flag, use partitioned reply_key format](https://gitlab.com/gitlab-org/gitlab/-/commit/c167eefed5701fb116346ed4649cf9bbc70dd79d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203593))
- [Migrate GlCard to Crud: Admin area user projects page](https://gitlab.com/gitlab-org/gitlab/-/commit/8d854f5645bc3becc5e77803af54815512ef8c02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203185)) **GitLab Enterprise Edition**
- [Geo Replicables: Sortable list](https://gitlab.com/gitlab-org/gitlab/-/commit/8d1bad8a09d99f121970a58b61a7d03ec9efacbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202274)) **GitLab Enterprise Edition**
- [Remove feature flag for async project authorizations update](https://gitlab.com/gitlab-org/gitlab/-/commit/cb8f1fbac481b4fe20aaf5e926e7cd83c192bc85) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203574))
- [Compliance framework piping proper errors to UI](https://gitlab.com/gitlab-org/gitlab/-/commit/8ffed06ede5ea9e5115a88ca14b493a73c9f48b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203181)) **GitLab Enterprise Edition**
- [Parity with plain text / rich text editor toolbars](https://gitlab.com/gitlab-org/gitlab/-/commit/a13efd79694ca6f63d84811678caaec9aa4e7395) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201521))
- [Add policies for null authors on audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/47f969d9538dd590b768a3eb338ce34f463619e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196672)) **GitLab Enterprise Edition**
- [Remove `/cc` quick action](https://gitlab.com/gitlab-org/gitlab/-/commit/6b3d4dbf71ce6a745e2d1f691fccb75c96171ef6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201043))
- [Move membership update audit event to Auditor](https://gitlab.com/gitlab-org/gitlab/-/commit/b84f7c8e27e4b700620910086cc2148ee6b63417) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202160)) **GitLab Enterprise Edition**
- [Add granular column to PersonalAccessToken](https://gitlab.com/gitlab-org/gitlab/-/commit/61ede38eb94a2f415ca596123e4fd413b45efc52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203508))
- [Remove feature flag for packages finder refactor](https://gitlab.com/gitlab-org/gitlab/-/commit/7d42f0ec39feb1786e393eb5f05e2070db3d2fd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203482))
- [Indicate plan on groups page](https://gitlab.com/gitlab-org/gitlab/-/commit/a55326731999362c46960ec568baa57ddf484f0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202341)) **GitLab Enterprise Edition**
- [Remove pipe character from doorkeeper](https://gitlab.com/gitlab-org/gitlab/-/commit/39c2e893cf942c36e82040b9d59989231fe946a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203035))
- [Pass correct context to agent platform ai events](https://gitlab.com/gitlab-org/gitlab/-/commit/749fced22df8b2fb5f45c8a8fe9d9b4d73c917ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203238)) **GitLab Enterprise Edition**
- [Generate a user-friendly name for workspaces](https://gitlab.com/gitlab-org/gitlab/-/commit/c6f71ab5d1c6ff33ae0f9007c10ae331415b2442) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202750)) **GitLab Enterprise Edition**
- [Create a workflow session when trigger invoked](https://gitlab.com/gitlab-org/gitlab/-/commit/f3463f20a3ef8620d44cede05d8e2383adce366f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203331)) **GitLab Enterprise Edition**
- [Added Direct Access endpoint for Third Party Agents](https://gitlab.com/gitlab-org/gitlab/-/commit/20c588771e411ee2797356a2260a8ca842a7e0a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202453)) **GitLab Enterprise Edition**
- [Add read status tracking in whats new](https://gitlab.com/gitlab-org/gitlab/-/commit/0b6e7525cc0457f376e3d37d1097e6be49faf2ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201798))
- [Geo Replicables: Search by ID](https://gitlab.com/gitlab-org/gitlab/-/commit/3b6734ab0ca26c2ca914c0acc0f0beb463c5ab1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202804)) **GitLab Enterprise Edition**
- [Drop 2 unneeded sequences showing up in database diagnostics page](https://gitlab.com/gitlab-org/gitlab/-/commit/4710ff80cee8a42a09df2a782ab0d82e10da191e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203299))
- [Reduce vulnerability finding modal outer padding](https://gitlab.com/gitlab-org/gitlab/-/commit/6240b871f9da6f60d6dacf8ec2bbdf10e9c637c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203296)) **GitLab Enterprise Edition**
- [Add zoekt feature class to check minimum schema versions](https://gitlab.com/gitlab-org/gitlab/-/commit/c261187f5441a012c30924e9582618aafc61cc9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203130)) **GitLab Enterprise Edition**
- [Feat: update visuals of agent sessions list page](https://gitlab.com/gitlab-org/gitlab/-/commit/a898d1d09dbf1c6c63f23102a6b4919d07689631) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202823)) **GitLab Enterprise Edition**
- [Move homepage feedback link to sidebar widget](https://gitlab.com/gitlab-org/gitlab/-/commit/9ad42b592dbd598fcd7d217db0d599c69b13c4f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201813))
- [Sort quick action suggestions alphabetically](https://gitlab.com/gitlab-org/gitlab/-/commit/3f2bec19cd1c0ded3d2266d4e7ef82b359da010e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200734))
- [Update Oauth application secret hashing strategies](https://gitlab.com/gitlab-org/gitlab/-/commit/387459884830bd7b23f155490b92303904f34389) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202186))
- [Bump zoekt to 1.4.3](https://gitlab.com/gitlab-org/gitlab/-/commit/8ed4190f3b5855756b583400cbd0042cef150c5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203253)) **GitLab Enterprise Edition**
- [Migrate refresh to use shared FF](https://gitlab.com/gitlab-org/gitlab/-/commit/69d75dbb0f1f32c9e45f1a20ad077a7ad6416312) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203241)) **GitLab Enterprise Edition**
- [Preserve sort params on tag deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/35d98606f1a3dfe0569c5e510e58f46005b96398) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202061))
- [Make single-file editor and pipeline editor fill more vertical space](https://gitlab.com/gitlab-org/gitlab/-/commit/174790a10d63e393049b927a17a966d966b4d3ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197840))
- [Update gitlab secrets manager payload to runner](https://gitlab.com/gitlab-org/gitlab/-/commit/e0a260c7cff0a60256f1095aaaab2b4e8527d1bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201671)) **GitLab Enterprise Edition**
- [Remove feature flag for packages versions refactoring](https://gitlab.com/gitlab-org/gitlab/-/commit/fb923a48645bafe63abb34fbebdb2b560f787315) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203204))
- [Add link to project settings for controls](https://gitlab.com/gitlab-org/gitlab/-/commit/4f5a9e2ee86abb6588e4a5d2d9a9b94a868a7e29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203034)) **GitLab Enterprise Edition**
- [Add Rails 7.1 as default configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/bb5267e02c870de75449c7b59a4ec821ae295aa3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197647))
- [Update email style for vulnerabilities and dependencies export](https://gitlab.com/gitlab-org/gitlab/-/commit/a45ce24578ec97c2f0c2a4166cd22c5658f27788) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198953)) **GitLab Enterprise Edition**
- [Gate zoekt traversal ID search based on scope](https://gitlab.com/gitlab-org/gitlab/-/commit/e84ffbd772d25c1f03ce007dd3832fed647f1997) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203016)) **GitLab Enterprise Edition**
- [Add support for composite primary keys](https://gitlab.com/gitlab-org/gitlab/-/commit/937b4fc4aab281e5bb581c251cb37c73463c3941) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200783)) **GitLab Enterprise Edition**
- [Allow agent user access sharing across top level groups](https://gitlab.com/gitlab-org/gitlab/-/commit/d48faca1853163ecb7f1a327e668c0e9c835f5ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202853))
- [Update fog-google to v1.25.0 and excon to v1.3.0](https://gitlab.com/gitlab-org/gitlab/-/commit/5992706f86847efbc53922da9fea01e8e5f75424) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189373))
- [Remove feature flag for create package service](https://gitlab.com/gitlab-org/gitlab/-/commit/304abcfab9fcae92897bf641a915b4310df7d10b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202718))
- [Geo Replicables: SPA and Pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/5f048371879fb8594307eb4c699897e158fe5da6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201956)) **GitLab Enterprise Edition**
- [Remove Sentry error logging for streaming configurations](https://gitlab.com/gitlab-org/gitlab/-/commit/964ddb54c1eac18c5caab3499e0e021fba06d3f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202324)) **GitLab Enterprise Edition**
- [Update admin Duo UI](https://gitlab.com/gitlab-org/gitlab/-/commit/edd754bbfd9db43fc85f93f5f874a421c4bf5b56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202820))
- [Remove zoekt_ast_search_payload feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/72369dc90d8f4d5a657413e6ff745655d7972c99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202070)) **GitLab Enterprise Edition**
- [Use precalculated zoekt counts when available](https://gitlab.com/gitlab-org/gitlab/-/commit/5bb5defb9d2203c90935b218680a1611b51cf41a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202791)) **GitLab Enterprise Edition**
- [Introduce a maintainer artifact_access_level](https://gitlab.com/gitlab-org/gitlab/-/commit/8e8ee5c63b95fc870d50e970aff8fc079dc37c2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201918))
- [Always create indexing tasks for empty zoekt repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/40c533d1af37a919185f30e7bb8ca7516e0e4880) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202792)) **GitLab Enterprise Edition**
- [Release filtered search v2](https://gitlab.com/gitlab-org/gitlab/-/commit/37b3e8addc6e27cfa30d7582887fb61de916b4a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194723)) **GitLab Enterprise Edition**
- [ftd: Disallow immediate deletion behind :disallow_immediate_deletion FF](https://gitlab.com/gitlab-org/gitlab/-/commit/f1c12edaf7e9191a9c45d917f08fb62392fe1477) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202040))
- [Improve error message for security panel](https://gitlab.com/gitlab-org/gitlab/-/commit/9e5e283e8fb92bba125db47d44aa647ab8e5ae01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201578)) **GitLab Enterprise Edition**
- [Convert muted badges to neutral](https://gitlab.com/gitlab-org/gitlab/-/commit/5cc3125d4830fe6392523282f2b4d6d8d829d49f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202102))
- [Add character validation for custom status names](https://gitlab.com/gitlab-org/gitlab/-/commit/201e77250657b0260e97b7f2a935521e0232cbb4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200297)) **GitLab Enterprise Edition**
- [Remove source_filter_pipelines feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f00ac07ab3e96ad3edc33975a851d11527263462) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202661))
- [Fix pagination counts for zoekt search results](https://gitlab.com/gitlab-org/gitlab/-/commit/9ae925e8d53a8894443372d76abc33babff585b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202291)) **GitLab Enterprise Edition**
- [Allow searching by iid and sort results](https://gitlab.com/gitlab-org/gitlab/-/commit/b3da6d4e35d9dadfc9e9b85313ae405eaa528a6c) by @afrnz ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202220))
- [Rename x-gitlab-self-hosted-models-metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/8c2b9800c4b730afb5d632329b1598d116878a72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202617)) **GitLab Enterprise Edition**
- [Chgange Feature flag name](https://gitlab.com/gitlab-org/gitlab/-/commit/d00a1737d7efded0d3d9605af13038d8c93e3c0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202598)) **GitLab Enterprise Edition**
- [Migrate admin_bot to per-organization internal user](https://gitlab.com/gitlab-org/gitlab/-/commit/bd175a500890e08ce902c29ee032d1bb2280d638) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193109))
- [Add maxLength validations for SBoM license name ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/66f70b345177327e1157a8fdd29c24b523910459) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202152)) **GitLab Enterprise Edition**
- [Remove feature flag for packages tags finder](https://gitlab.com/gitlab-org/gitlab/-/commit/5c12bb22697b62a31ba9bfe4573407addfe89a6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201792))
- [Use async pipeline creation on git push by default](https://gitlab.com/gitlab-org/gitlab/-/commit/595c7ae3f0860a19a5792f269ca8ebc965a30c30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202408))
- [Update archived status logic to consider parent groups](https://gitlab.com/gitlab-org/gitlab/-/commit/a3ba7cf8a1ffcce18a6116021b7aa3fe933222ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201087))
- [Remove the feature flag allow_push_repository_for_job_token](https://gitlab.com/gitlab-org/gitlab/-/commit/3d374830c6d6156d661e2b3ebb6f661392713c61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201950))
- [Add `securityPoliciesSyncUpdated` GraphQL subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/f4001e2101d19ba4fe0a4a4a16f9b79f963071fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201777)) **GitLab Enterprise Edition**
- [Remove FF SPP raw info feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3d7faa1bd9fc391196533af90a229c17f028b1e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/issues/558983)) **GitLab Enterprise Edition**
- [Add fallback for missing control titles](https://gitlab.com/gitlab-org/gitlab/-/commit/f9796d65a8b5dfdaf06e372983e8a52536a77795) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202320)) **GitLab Enterprise Edition**
- [Convert HierarchyRestriction to rely on system defined static data](https://gitlab.com/gitlab-org/gitlab/-/commit/2d76c523c91233c75892dbd7d0226e671d896fc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200898))
- [Member changes check and notify](https://gitlab.com/gitlab-org/gitlab/-/commit/e47e0b593442858f9ba520c9e946e614c0fffa0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195067))
- [Show user Minimal Access groups in Admin area](https://gitlab.com/gitlab-org/gitlab/-/commit/198b829b5d50bee5062adab548119396abf285db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201852)) **GitLab Enterprise Edition**
- [Update What's New featured cards design](https://gitlab.com/gitlab-org/gitlab/-/commit/7820e1bbfee3a6023eb3e7088d9c3a6faa916332) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200082))
- [Add usage source to keep-around reference rake task report](https://gitlab.com/gitlab-org/gitlab/-/commit/0a88e2959e80e2ba28aa74d822e3fde1372ca628) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191591))
- [Dependency Graph creation with path caching](https://gitlab.com/gitlab-org/gitlab/-/commit/c1805cbeee5a1888dc62455226bf75f8400d44e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201607)) **GitLab Enterprise Edition**
- [Makes ci-enforce-throttle-pipelines-creatoin-override an ops flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a72154564cee53e9b349305866e12c97157b58ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202098))
- [Super topbar responsive behavior](https://gitlab.com/gitlab-org/gitlab/-/commit/5642ab9bad7e738da0f296992ce8012f96dfdce7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202069))
- [Remove migrate_user_access_tokens_ui](https://gitlab.com/gitlab-org/gitlab/-/commit/b5a293ff9d7d1b4cf306d1e2a154187d2d19bea3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195257))
- [Use subtle text styling consistently on vulnerability report](https://gitlab.com/gitlab-org/gitlab/-/commit/f72c02b4e9f92a2592fd8e818e3fe2fdea778e11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202105)) **GitLab Enterprise Edition**
- [Maven Virtual Registry: Not allow duplicated upstreams](https://gitlab.com/gitlab-org/gitlab/-/commit/6dd3536a46958308a055591624ed40bd2e6e81da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197821))
- [Remove feature flag for statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/5a9aceef2e96c2de71ea68c088efb4d064866542) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202182))
- [Include issued token details in /oauth/token logs](https://gitlab.com/gitlab-org/gitlab/-/commit/0b4e5d9c67031021f7de1fd5e623386615fdc3f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201668))
- [Remove FF secret_detection_filter_deleted_files](https://gitlab.com/gitlab-org/gitlab/-/commit/016b3350e319400396724efd4f46dce4fab08058) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/issues/560722)) **GitLab Enterprise Edition**
- [Move group project delete to group level](https://gitlab.com/gitlab-org/gitlab/-/commit/1e04e4adb04c5e2893313237fdbc9e04b61d919b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199672)) **GitLab Enterprise Edition**
- [Convert GLQL Finder to a more generic Advanced Finder](https://gitlab.com/gitlab-org/gitlab/-/commit/2112e5835fddd20ee64dfcd61578bdcde603e9e1) by @afrnz ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201477)) **GitLab Enterprise Edition**
- [Add faster SHA512 token hashing for Doorkeeper](https://gitlab.com/gitlab-org/gitlab/-/commit/2d7c16ceb04a362c3756f6e60ebcfa7c0fbda778) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200029))
- [Fix spacing for severity badge and validity check](https://gitlab.com/gitlab-org/gitlab/-/commit/e8ab284be11027407afd565881226cf8f922be78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202110)) **GitLab Enterprise Edition**
- [Handle indexing projects with no repos more gracefully](https://gitlab.com/gitlab-org/gitlab/-/commit/0dea761e00974aea2f0ecdc1080c1a2c5f661d84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201774)) **GitLab Enterprise Edition**
- [Fix bug where project search set search_level to group](https://gitlab.com/gitlab-org/gitlab/-/commit/5ba5213590968bb85fd803b03847fe62e4c8e31b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202080)) **GitLab Enterprise Edition**
- [Improve test flakiness](https://gitlab.com/gitlab-org/gitlab/-/commit/0e0d827ee741d0129b47cdb9d7e9856cdb460527) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201170)) **GitLab Enterprise Edition**
- [Update Customer Portal link accessible label](https://gitlab.com/gitlab-org/gitlab/-/commit/a11a59fb480cfc761fba6c9ccb8d6e831cb4335c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201541)) **GitLab Enterprise Edition**
- [Expose show_diff_preview_in_email on the api](https://gitlab.com/gitlab-org/gitlab/-/commit/19a26c91f7c25ab4566834294c97d4936d22c434) by @danilobuerger ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197552))
- [Geo Replicables - Show results count in list](https://gitlab.com/gitlab-org/gitlab/-/commit/28dada0c3a17e4b0f3f07e1207b4739ea94705f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201009)) **GitLab Enterprise Edition**
- [Fix JQL fuzzy search for Jira vulnerability issues](https://gitlab.com/gitlab-org/gitlab/-/commit/5d23f51afc7a4270ebcf4bf64fc6efec14d067e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201672)) **GitLab Enterprise Edition**
- [Use plain text button in Duo batch update settings](https://gitlab.com/gitlab-org/gitlab/-/commit/50069521c257c76e877ce5326a728b46ac28ae2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201542))
- [Return empty response when no targets are available](https://gitlab.com/gitlab-org/gitlab/-/commit/039821cbc933ecd92b4952a6405f40887286e024) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201947)) **GitLab Enterprise Edition**
- [Add SHA512 hashing fallback Oauth application secrets](https://gitlab.com/gitlab-org/gitlab/-/commit/89b648f35498af2227830be7f5a4727857829812) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200852))
- [Remove duo_workflow_workhorse feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e2876a1cf93947243141c48e4888f59ea2323638) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198487))
- [Remove `security_policies_group_transfer_sync` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/294e3aad727d0e89493abe35cb9417aac9b4f7ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201892)) **GitLab Enterprise Edition**
- [Remove "disable_widget_responses" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/013ca49f02ad7aa082bae876ae3b4c7bef3acc3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185989))
- [Remove bbm_retry_sidekiq_shutdown_exception feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/25e5e128d31bbc48c7d305363ea2fecf5d914081) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201850))
- [Add custom Web IDE favicon for better tab identification](https://gitlab.com/gitlab-org/gitlab/-/commit/40374bd0425f8fe51cb31baab21a9e3cc4ca5031) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201282))
- [Fix trailing dot in autocomplete search](https://gitlab.com/gitlab-org/gitlab/-/commit/62490e64764f6d389584dc4088a5b4eecabc8474) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201816))
- [Keyboard shortcuts modal: Make search bar span full width](https://gitlab.com/gitlab-org/gitlab/-/commit/19e3ecc4eeb94241f079cce64a6455ba0fa068fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201759))
- [Add help popover for users with no access to projects](https://gitlab.com/gitlab-org/gitlab/-/commit/3304a0fcbb9334f451694a78d1f54c29df1dd001) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201457))
- [Update product_group for Vault usage metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/73dcf664ff53d5221420d20d7226fa7d95efcf7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201669)) **GitLab Enterprise Edition**
- [GitHub import should respect group limits when importing projects](https://gitlab.com/gitlab-org/gitlab/-/commit/76da0ac127abf23103bf7ddaae656d46173c116e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201623)) **GitLab Enterprise Edition**
- [Allows boards filtered by epic to show child issues](https://gitlab.com/gitlab-org/gitlab/-/commit/05d9118328b0fc610fc47357606497f9f599f215) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198718))

### Deprecated (2 changes)

- [Expose package_registry_access_level in project API endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/e526192e875cfd654e86b8b1e009e2c4c1513a5a) by @nejc ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170122))
- [api: Disallow immediate deletion behind :disallow_immediate_deletion FF](https://gitlab.com/gitlab-org/gitlab/-/commit/cee06d1fec0f97f69fce998a484cdf61641e51f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201957))

### Removed (29 changes)

- [Remove software_license factory from create_service_spec](https://gitlab.com/gitlab-org/gitlab/-/commit/ac4c8ffd84172b08df3d92de030b023968a5150d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204770)) **GitLab Enterprise Edition**
- [Remove cron for ImportSoftwareLicensesWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/dfc87ef47e3687e6a032650249a736166398ad0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204588)) **GitLab Enterprise Edition**
- [Add post deployment migration to delete orphaned user_group_member_roles](https://gitlab.com/gitlab-org/gitlab/-/commit/a8c46e889c149333d215d34ade4322ac8b166b81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204163))
- [Remove bulk_import_importer_user_mapping feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dda2d591d875dc878fa2003ec01aee6e117ba436) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204216))
- [Cleanup git_authenticated_http_limit feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8f5c1bdffb1645cd003de448972430426d33900a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203105))
- [Removed FF restrict_sso_login_for_pipl_compliance](https://gitlab.com/gitlab-org/gitlab/-/commit/ace0502d86403c7dc6494830476e5a5fbf39e5f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204346))
- [Remove deprecated Search::IndexCurationWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/179a714e6c13e686144e06ae49c2545a30131230) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204057)) **GitLab Enterprise Edition**
- [Remove deployment frequency forecasting experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/cca6dfb818662211131595bffc1eb2dca7ad0e2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203478)) **GitLab Enterprise Edition**
- [Remove SoftwareLicense ref from license violation spec](https://gitlab.com/gitlab-org/gitlab/-/commit/3243e8ba2efa2c27c38977271a531916028d2144) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204250)) **GitLab Enterprise Edition**
- [Remove SoftwareLicense ref from pm license factory](https://gitlab.com/gitlab-org/gitlab/-/commit/7725e84a4036c30357946d20c57cb10015d46a8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204221)) **GitLab Enterprise Edition**
- [Remove SoftwareLicense ref from managed license spec](https://gitlab.com/gitlab-org/gitlab/-/commit/d512be1eadf7eddf281e84b4a3172bb6a7a2e92d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204192)) **GitLab Enterprise Edition**
- [Remove legacy issue promote service](https://gitlab.com/gitlab-org/gitlab/-/commit/915e70fa6ea6da11e0453346e2e7e05a8bf57337) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202783)) **GitLab Enterprise Edition**
- [Drop unused non partitioned duo_workflows_checkpoints table](https://gitlab.com/gitlab-org/gitlab/-/commit/17543d199c680d30eb7d21d26a331f8d26c4a165) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203421))
- [Removing GitLab Duo admin banners](https://gitlab.com/gitlab-org/gitlab/-/commit/0a2ca72f629f0a3b76d0fe1dc607de744e6745d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202983))
- [Delete the `service_desk_custom_email_reply` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f5fa47acadef0716ef4f5246fa219058e258de49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202586))
- [Delete the `add_organization_to_diff_commit_users` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/66d6158fc439f7131288a974b873fce63f489085) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202591))
- [Remove sprint_id and related index and foreign_key from merge_requests](https://gitlab.com/gitlab-org/gitlab/-/commit/12877140d1a87781d9264d6e60a7a819877bbac6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202698))
- [Remove `explore_dependencies` feature flag and page](https://gitlab.com/gitlab-org/gitlab/-/commit/3ba716cd87d68dd5413dec0a4463d37c0614d581) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202240))
- [Remove old background migration worker](https://gitlab.com/gitlab-org/gitlab/-/commit/433765dea41d8a13eb5fdb5cdfecde44f2dd825c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202354))
- [Reduce super sidebar themes](https://gitlab.com/gitlab-org/gitlab/-/commit/07fc466fd04e2ca73610d95892391ccedea9a1d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200475))
- [Remove BackgroundMigrationJob](https://gitlab.com/gitlab-org/gitlab/-/commit/ebcc54c7337ee5954b8564028036f48ecfaf9a61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202025))
- [Remove feature flag and logging code](https://gitlab.com/gitlab-org/gitlab/-/commit/5ccba2134676669ac25dcd7bc8914a51583d9fe3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202120))
- [Remove unified_ai_events_graphql feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d0afd8b1b1146bb2a3279b292f3aefd7ed1dab6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202197)) **GitLab Enterprise Edition**
- [Remove parent_id arg on BulkUpdate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/2d066d36116e45866b3f811d68683da07a217684) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202155))
- [Remove work_item_status_feature_flag FF](https://gitlab.com/gitlab-org/gitlab/-/commit/f76ee765753af004b0b47689f1b2163a2ac7ed98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201566))
- [Remove ignore rules for pre_receive_secret_detection](https://gitlab.com/gitlab-org/gitlab/-/commit/c4dc127726c782656e4823d1af6d172c80b09aa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200640))
- [Remove avoid_exposing_member_is_using_seat FF](https://gitlab.com/gitlab-org/gitlab/-/commit/e814bd0b2e74711af70ac85035f76e30cfd6bd24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201722)) **GitLab Enterprise Edition**
- [Drop work_items_related_link_restrictions table](https://gitlab.com/gitlab-org/gitlab/-/commit/5e572f6fa274e8a99459e9aff9a656e2f6867ad6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200707))
- [Delete the `member_expiring_email_notification` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f920e7254832a5de0947325b27ffa1cfcab032ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201732))

### Security (12 changes)

- [Deny project invitations on SAML lock](https://gitlab.com/gitlab-org/gitlab/-/commit/3237c2932bf5e46035cc2f377f0a96e9f2a7d397) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203447)) **GitLab Enterprise Edition**
- [Introduce limit for closed issues](https://gitlab.com/gitlab-org/gitlab/-/commit/2a34fb6dd183d6abd2568934034042a59373b496)
- [Add file size limit for blob editing](https://gitlab.com/gitlab-org/gitlab/-/commit/206c80e60f6b2e2326fb1edba9799a0b3a29becc)
- [Fix DoS via large SAML Response](https://gitlab.com/gitlab-org/gitlab/-/commit/2940ed09a2b17925574b63e63c4d8e5ddb8f68e2)
- [Add limit to deploy token name](https://gitlab.com/gitlab-org/gitlab/-/commit/f55739ada891e50e67f7bc59a7626f3f2e8b642e)
- [Fix webhook custom header validation](https://gitlab.com/gitlab-org/gitlab/-/commit/2fbae78a93122f5674e90ce40c2ed32961dfcaa5)
- [Show runner maintenance note only to runner maintainers](https://gitlab.com/gitlab-org/gitlab/-/commit/00cc23a68e37a8e67822ba2cb68ec643003fb228)
- [Update GitLab Workspaces Proxy version](https://gitlab.com/gitlab-org/gitlab/-/commit/52119c7d42e56c42d849e25c1ef39cc737d9c722) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203848))
- [Fix tag/branch ambiguity in raw file display](https://gitlab.com/gitlab-org/gitlab/-/commit/014c0adf30161507fcc3e528b18952da7af9c9bf)
- [Add authentication check for manual variables via new policy](https://gitlab.com/gitlab-org/gitlab/-/commit/bc1a7ab637631457e5d95b5bc0236d2f78b62eb8)
- [Adjust snippet blob query complexity to mitigate potential DoS attack](https://gitlab.com/gitlab-org/gitlab/-/commit/7f68fef736d27609d965793b08cedbf2f27b9e44)
- [Gitea import rate limiting](https://gitlab.com/gitlab-org/gitlab/-/commit/d3d5f8e5ca2c9d443ea6851628e5e20d02af877d)

### Performance (2 changes)

- [Add index bulk imports on status](https://gitlab.com/gitlab-org/gitlab/-/commit/a01af6785cadc339e71d9385c7385b3a1cdb30fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203561))
- [Optimize snippet fetching by ID in Snippets API](https://gitlab.com/gitlab-org/gitlab/-/commit/9d3a3037054751e457aeb916718a5f832b8c7e6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201906))

### Other (142 changes)

- [Finalize audit event streaming BBMs](https://gitlab.com/gitlab-org/gitlab/-/commit/2301e80816ee86e06c96e51e459ac6395ac9a23c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201972)) **GitLab Enterprise Edition**
- [Optimize workspace names](https://gitlab.com/gitlab-org/gitlab/-/commit/beb2cbe96b57970673bd882f3ab4df64f2fbb1b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204625)) **GitLab Enterprise Edition**
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/a2eaf24db336a5c6e147f8ffcac0a5933dff61c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205051))
- [Removing FF stubbings part 2](https://gitlab.com/gitlab-org/gitlab/-/commit/fcc648d423b15584fcefddea2db2c976c943facf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203424)) **GitLab Enterprise Edition**
- [Add todos#organization_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2501a46ea1da60b9ecfec00ba57ae43dc2230e42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204713))
- [Move audit_events_streaming_http_instance_namespace_filters](https://gitlab.com/gitlab-org/gitlab/-/commit/036ea02e7a56bb46457be2217693a6f6cfc121c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201253))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/97b6a6be8ae272acea3375a7d2dcba05eca6cde6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204964))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/35c1e5a6e4084564e9fb3cb6830b2f27178e9caa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204963))
- [Add tracking for Value Stream Analytics views](https://gitlab.com/gitlab-org/gitlab/-/commit/953f505e66bca408634733f46f947b9627f13674) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204438)) **GitLab Enterprise Edition**
- [Finalize BBM DeleteTwitterIdentities](https://gitlab.com/gitlab-org/gitlab/-/commit/c0820e7c464ec55573b7df17f5f03ad4f13d4f9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203943))
- [Add not null constraint on notes sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/fb877cfebd3a62bef978a73c477dbf692c9d14c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204773))
- [Migrate Project sub-pages to use Container Queries](https://gitlab.com/gitlab-org/gitlab/-/commit/668781c8ac609694a85a6077a402133aba3f0270) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204756))
- [Migrates Work Items components to use Container Query](https://gitlab.com/gitlab-org/gitlab/-/commit/012ffcfa3d8e17d63da24d1f4afdf0c76f44f016) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204743))
- [Update GitLab Duo group permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/d2636d5a8eaeaf4d6d67bcd63b5dddb82c86ce6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200337))
- [Use job.update_timeout_state instead of metadata.update_timeout_state](https://gitlab.com/gitlab-org/gitlab/-/commit/16c2ee58643d4ba472fbaff90fc7a9681a00de62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204607))
- [Migrate Plan integration settings to Container Queries](https://gitlab.com/gitlab-org/gitlab/-/commit/82f245f5e245a12a3a35023cf9ce15a275b82752) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204535))
- [Clean up old bulk import configs](https://gitlab.com/gitlab-org/gitlab/-/commit/40f86c7eb10de14c15fd724bfc931a6c8b4c63f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203551))
- [Migrate Pages dashboard to Container Queries](https://gitlab.com/gitlab-org/gitlab/-/commit/188e1cedd1c389b3fcc8b140ed823fc7ca53021b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204407))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/7b4bd408496283edc3c0b4afe997a89821d75196) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202466))
- [Finalize BBM BackfillProtectedBranchPushAccessLevelsFields](https://gitlab.com/gitlab-org/gitlab/-/commit/fc946e484a4d218ab93149c209c1544cc9c75282) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203399))
- [Remove 'ff_require_saml_auth_to_approve' feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f0939853d18ae60a2a4976436a79b2c9d548d4f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144319))
- [Add wiki pages to reference filters framework](https://gitlab.com/gitlab-org/gitlab/-/commit/97a54dacfd541014730d43de4efc1a1f1edcd73d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201915))
- [Move ai_settings table back to gitlab_main schema](https://gitlab.com/gitlab-org/gitlab/-/commit/d22b4324ec805cfcd5c03a2df0a82e149ed00dbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199170))
- [Drop group_deploy_keys & group_deploy_keys_groups](https://gitlab.com/gitlab-org/gitlab/-/commit/d29bc0b21fc9c579a0d03811ba9792c546a41163) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203576))
- [Prepare tmp_idx_events_where_project_target_type_missing database index](https://gitlab.com/gitlab-org/gitlab/-/commit/7bd4d063792ccc220dfa2d2931a012e5cafa011d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203765))
- [Migrate Blob viewer to Container Queries](https://gitlab.com/gitlab-org/gitlab/-/commit/9cb6a51da936621cdaf39ac27db1167139c6675c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204289))
- [Cleanup duo_workflow_prompt_registry FF](https://gitlab.com/gitlab-org/gitlab/-/commit/23b368abc3ff51cf7db2067892e2d806d7e47297) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204278)) **GitLab Enterprise Edition**
- [Remove duo_code_review_prompt_updates feature flag for DCR](https://gitlab.com/gitlab-org/gitlab/-/commit/9290f5cb2a63f7d22bb82724ed61adb8c3795444) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204217)) **GitLab Enterprise Edition**
- [Migrate Repository to Container Queries](https://gitlab.com/gitlab-org/gitlab/-/commit/7e6380e25fc025334bef4b47e270fe3218539623) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204051))
- [Add sharding key to label_links table](https://gitlab.com/gitlab-org/gitlab/-/commit/876e28b9952693f5ff722227548b218d8a500448) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203748))
- [Revert "Merge branch '553409-process-commit-worker-defer-on-db-health-signal' into 'master' "](https://gitlab.com/gitlab-org/gitlab/-/commit/d35a41f9e22d31d400265f1707cd16cfd00501d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204243))
- [Fix Amazon Q UUID mismatch error handling](https://gitlab.com/gitlab-org/gitlab/-/commit/7d684a40d91862ff9e4460927b3f643c5e975d30) by @wubenso ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201391)) **GitLab Enterprise Edition**
- [Add organization_id to abuse_report_user_mentions table](https://gitlab.com/gitlab-org/gitlab/-/commit/0c739da7f4a06caf7f31983f51db9fcb470d6a33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202365))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/cc77eb9c2f96ddcda1e7c29dc93c9990b72d6c1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204198))
- [Apply proper variables precedence](https://gitlab.com/gitlab-org/gitlab/-/commit/f780e3a43476b56f417e7a3ea8affe004b18cea4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203379))
- [Fixing renaming FKs by adding with_lock_retries](https://gitlab.com/gitlab-org/gitlab/-/commit/1b9cd1481dc9ef81b5ca72b9664b1e8962544d0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204162))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1e154c8aebb8316c3f166fabcb35db7dda80e38e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201565))
- [Add not null constraint to deploy token project_id and group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/cbd0f680bc49db57a07ffe437f14e1d79f4ed1da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202543))
- [Mark 20250422181959 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/00095c7848c066b36b84c09ca079bcebe8ab2bf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201687)) **GitLab Enterprise Edition**
- [Create gitlab_main_jh schema and move jihu-specific tables](https://gitlab.com/gitlab-org/gitlab/-/commit/33709ecdd72cec891992509d9720572fb9491c18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200910))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/3115609c1de72561f960c2873351f785b245b90f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202009))
- [Finalize BBM BackfillMergeRequestDiffDetailsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/90216106de4ccda0b556873185f7985429a96f73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196952))
- [Finalize BBM BackfillCiJobArtifactStatesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/8e9abac1df416b34e6e4feaa219f253821ce30e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181724))
- [Remove failed_pipelines_audit_events feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e9bc865d71359c332f8fc73692c126687f64cdb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203923)) **GitLab Enterprise Edition**
- [Migrate Wiki & User Notification Preferences to CQ](https://gitlab.com/gitlab-org/gitlab/-/commit/0693faace918b717a215fd3761359f768222cd9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203730))
- [Update whats new navigation item render logic](https://gitlab.com/gitlab-org/gitlab/-/commit/93de84354317b0d3dc4a615f149a6c5df1f0bac0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203565))
- [Backfill workspace_agentk_states for all workspaces](https://gitlab.com/gitlab-org/gitlab/-/commit/851603cbc178f2b0108c38b6b34d08d9430dfff9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199102)) **GitLab Enterprise Edition**
- [Remove a temporary fix for breadcrumbs](https://gitlab.com/gitlab-org/gitlab/-/commit/a7d5b00d905907c68e675233d1ec4d696adfd20b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203869))
- [Expose downloads_count and downloaded_at of Maven cache entries in APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/6bfbfce3b91b0cff73cff0d56dce1876abded637) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201790)) **GitLab Enterprise Edition**
- [Add `proj_by_name_stage` to `ci_finished_builds` ch table](https://gitlab.com/gitlab-org/gitlab/-/commit/9633bde447594ee70e3800103ab711bd6d0a2d0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202891))
- [Drop redundant unique index on merge_request_diff_commit_users](https://gitlab.com/gitlab-org/gitlab/-/commit/3ece0bc336e6faea2119aae51eba1417d7dbd25e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202578))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/64e776be051b74bf7f39ac8724217c91d492b79f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203461))
- [Clean up vulnerabilities_pdf_export FF](https://gitlab.com/gitlab-org/gitlab/-/commit/9147fa61046383328acbeba8433142cdb98106ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196744)) **GitLab Enterprise Edition**
- [Updating Topology Service Client Gem to b1f6261](https://gitlab.com/gitlab-org/gitlab/-/commit/12272f648a84ca636f47a726d02a423743ba0760) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203767))
- [Mark 20250410164648 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/2f2e644d078586b41c2ee4df49f270682b48ca09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201686)) **GitLab Enterprise Edition**
- [Add organization_id to abuse_report_labels table](https://gitlab.com/gitlab-org/gitlab/-/commit/c9e6cfb78fe030fc6450b2c780124c6f38f4dd4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202281))
- [Save deleted records into backup tables while archiving vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/0525afcf038aa4e11a62a50ce9447590d1926849) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203222))
- [Migrate Projects List, Issue Analytics, & Custom Emojis list to CQ](https://gitlab.com/gitlab-org/gitlab/-/commit/01a3d0485a7750683e952088c75cb4ec67c0d029) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203572))
- [Replace glFeatures with glLicensedFeatures](https://gitlab.com/gitlab-org/gitlab/-/commit/f4643b325ea4c1c8458b27ade0013e1d8cfe112e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203562)) **GitLab Enterprise Edition**
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/5904deb627bc57fb77f119432891e8c3389d056f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203386))
- [Validate NOT NULL ci_sources_pipelines#project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/8051ebc11c93eb8dafc518f4dc0a77ee76e13b80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202641))
- [Validate FK merge_request_cleanup_schedules#project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/8ccfe8b7168858042e803b5c00cd7500ab819a93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203272))
- [Validate FK push_event_payloads#project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/90436d1d5fc403f119e2066b31599e18130981b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203265))
- [Validate FK approval_merge_request_rules_users#project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/58dc62dd56dd530422661dccffa8ebb5d3948243) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202646))
- [Requeue BackfillMergeRequestCleanupSchedulesProjectId BBM](https://gitlab.com/gitlab-org/gitlab/-/commit/dbb85ee4314d227de4a20a1467e1fc2a568e089e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198596))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f5f7226987e749ba3d937a5da762a40fdeb82f08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202861))
- [Finalize migration BackfillPackagesComposerPackagesTable](https://gitlab.com/gitlab-org/gitlab/-/commit/72bc06e1f58934cfce341c696c0bf9e0f0dadb02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203363))
- [Docs: Update schema for historical_data](https://gitlab.com/gitlab-org/gitlab/-/commit/0ca0677508370c54468399865ce4103efd79cbd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199961))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/eed26db94eec9a1badfa7fd95ad54701ae971625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203320))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/fb74e9708175066d6cd0afd2e1bc8b06776925d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203326))
- [Finalize BBM BackfillDuoCoreForExistingSubscription](https://gitlab.com/gitlab-org/gitlab/-/commit/0794fcd361785505696bd8921d61cf39e350e4aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202538))
- [Migrate Iterations, Timelogs, Labels, & CRM pages to CQ](https://gitlab.com/gitlab-org/gitlab/-/commit/fc7166229e3161be37b4e305d81d7aab62f75311) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203297))
- [Remove the feature flag work_items_list_parent_filter](https://gitlab.com/gitlab-org/gitlab/-/commit/8037777bcfea47a5b40ce9b2c338fb2a6fcb479b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203240))
- [Removed FF stubs for execution_policy_name and pre_succeeds](https://gitlab.com/gitlab-org/gitlab/-/commit/6ca332bf5c2f6742b7cc2a299e1c9e1c53afca7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203244)) **GitLab Enterprise Edition**
- [Migrate Boards page and components to Container Queries](https://gitlab.com/gitlab-org/gitlab/-/commit/f99a81fb6051004c96bb599273f70009e59840ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203164))
- [Store downstream errors in their own table](https://gitlab.com/gitlab-org/gitlab/-/commit/ec27daf89a6fb5b200ff3be9bf5c9ad62c65eea7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203065))
- [Update docs reference](https://gitlab.com/gitlab-org/gitlab/-/commit/23d3b7fb6783d192b53f108d2732b78caaccad75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203231))
- [Add GraphQL formatter for nested_groups_projects_list.vue](https://gitlab.com/gitlab-org/gitlab/-/commit/ca88f3667aa5cdb1e01405201bebb03700754b34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202684))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/462cdc704cbb0563bc0601e5d40ad6aca10886d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203192))
- [Migrate Roadmap page and components to Container Queries](https://gitlab.com/gitlab-org/gitlab/-/commit/a4afa62776fa42a0a00e5df154b36395bcd66590) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203005)) **GitLab Enterprise Edition**
- [Add merge_request branch exception bypass event](https://gitlab.com/gitlab-org/gitlab/-/commit/7da5e4b905c6bd82f11e4e19ee4453d5600ebcfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202917)) **GitLab Enterprise Edition**
- [Remove auto_close_issues_stop_using_commit_author FF](https://gitlab.com/gitlab-org/gitlab/-/commit/4e1a4a87ea8ff30eeb422b3764ee2e3660d8170c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200244))
- [Clean up `duo_rca_usage_rate` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2e7bd4bb2560538a20389c05b59bafa3d00bcde2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203121)) **GitLab Enterprise Edition**
- [Migrate Test Case show & Requirements list to Container Queries](https://gitlab.com/gitlab-org/gitlab/-/commit/b0470765240baaf6fa990a28aeef444fd234f1be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202841))
- [Sync translations from crowdin (2025-08-27)](https://gitlab.com/gitlab-org/gitlab/-/commit/06ed308ea8368397a6c8d4916804c9d5539753b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202912))
- [Notify and deactivate](https://gitlab.com/gitlab-org/gitlab/-/commit/aae68fb55d69d6c7322bb1da10a1cd5197f5cd9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199908))
- [Remove `token` column from `ci_runners` table](https://gitlab.com/gitlab-org/gitlab/-/commit/3d41504242c89a9a2df5d5316557e83bc333a477) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202720))
- [Migrate Issues list page and components to Container Queries](https://gitlab.com/gitlab-org/gitlab/-/commit/4f6328e04040e874111f2a7cc7b845066d43f75b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201660))
- [Always use new token issuing flow](https://gitlab.com/gitlab-org/gitlab/-/commit/8dafcdff5504f197620db268f76f41cd9937ef72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202794)) **GitLab Enterprise Edition**
- [Finalize BackfillIssueTrackerDataShardingKey migration](https://gitlab.com/gitlab-org/gitlab/-/commit/94764bc5760c62d09b05b2c94e0310a7e2ffcaa6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202751))
- [Remove `admin_projects_vue` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ee79b077284e2ff2add406cf3e5e79a0b1cfbafe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201851))
- [Rename indices on ci_runner_taggings partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/dedfca67a3da8d826a667c263c8c07fde329d4f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202734))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/571e031fe1ca3fa24b8af5313ce2b7f785490a68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202331))
- [Remove old feature flags for DCR](https://gitlab.com/gitlab-org/gitlab/-/commit/88e8813ced6f743f0981eae4ff5560f4e5a70e41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202262)) **GitLab Enterprise Edition**
- [Initialize conversion of deployment_merge_requests to bigint](https://gitlab.com/gitlab-org/gitlab/-/commit/122e8dbd5684c20e23180d5697139d84b032a237) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195237))
- [Rename indices on ci_runner_machines partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/3c24791356cd27f352deece5e25bfaa1fa853809) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202282))
- [Remove skipped_pipelines_audit_events feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/04ea9336563c305c7243d4115de40f6414934047) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202666)) **GitLab Enterprise Edition**
- [Mark 20250505125045 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/504426ed701d3fb30356ea46cb938801b1fe47e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201690)) **GitLab Enterprise Edition**
- [Int range partitioning documentation for new tables](https://gitlab.com/gitlab-org/gitlab/-/commit/7a8f9282713733f7b724a95498795039b0e073d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202528))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/107f5e9afa1c37f36d894ac0530fa043bafd6aad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202607))
- [Remove temp index on packages_packages for installable terraform modules](https://gitlab.com/gitlab-org/gitlab/-/commit/6b013cffb7c91ef2df2766d384300850891ab705) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202041))
- [Sync translations from crowdin (2025-08-23)](https://gitlab.com/gitlab-org/gitlab/-/commit/2d66c825a7b7db206962193590dbdd9d813f80ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202485))
- [Rename indices on ci_runners partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/a78e9dff346dc4fc7f1e9661f7ab885e458c00a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202279))
- [Document missing runner permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/7a5b5294c89aa6c807e4f70c9552ea9843381bbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202185))
- [Step-up auth: Fix indentation and order of documentation section](https://gitlab.com/gitlab-org/gitlab/-/commit/364929c5799b2b7ddc8245bedc0669c242e64552) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202372))
- [Remove an extra call to zoekt](https://gitlab.com/gitlab-org/gitlab/-/commit/e3696ef348f0537136144386a48352fd02e906c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202350)) **GitLab Enterprise Edition**
- [Add enhanced add code task to get started](https://gitlab.com/gitlab-org/gitlab/-/commit/e58280602fdf0cbc3754447c8bb361b7302d1a7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200553)) **GitLab Enterprise Edition**
- [Remove ci_enforce_throttle_pipelines_creation](https://gitlab.com/gitlab-org/gitlab/-/commit/188a30d8fdf42ca6374f6d77c52c328d22f013c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202083))
- [Synchronously validate foreign keys for organization_users](https://gitlab.com/gitlab-org/gitlab/-/commit/0c7400a1c079205f1213d26c8285a5348c28e12c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201734))
- [Remove redundant license check in issues settings](https://gitlab.com/gitlab-org/gitlab/-/commit/fdc43b1056afca3ce437a5035cab8271153e62d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202321)) **GitLab Enterprise Edition**
- [Add organization_id to abuse_report_events table](https://gitlab.com/gitlab-org/gitlab/-/commit/d9deaef56994e1e91a861dfda31e50fc913602d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202284))
- [Removes Legacy BM helpers, cops and their references](https://gitlab.com/gitlab-org/gitlab/-/commit/4883249fe50563eea35d31695d0b6d725f4569a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201898))
- [Remove FF - optimize_ci_owned_project_runners_query.yml](https://gitlab.com/gitlab-org/gitlab/-/commit/165965a99d1f74af0f40c81b75bd172db70e71bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202036))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/91760bd935b3ca8ae558fcf112bad9bb1532d535) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202166))
- [Remove bridge code for auto-disabling](https://gitlab.com/gitlab-org/gitlab/-/commit/bbab06fc53f854522f88e59a99bb68738e753eca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201904))
- [Add validation logs](https://gitlab.com/gitlab-org/gitlab/-/commit/5097aad760b2d5cec261422dbb1c717c3fd823b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201891))
- [Table p_sent_notifications table shares sequence](https://gitlab.com/gitlab-org/gitlab/-/commit/45d0626be1f8e162df5a401a6ed06c93013051e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202147))
- [Removes prometheus_alert_id column on alerts table](https://gitlab.com/gitlab-org/gitlab/-/commit/55ecf621c4a75ffe8be453fbe37329aee8b39e9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201647))
- [Store/read from job_artifacts table for exposed artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/ab36803bd0d65ab588fd7540fd3b26965e07f487) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202094))
- [Step-up auth: Custom org-specific documentation links for failed step-up](https://gitlab.com/gitlab-org/gitlab/-/commit/a0f233fb1e39cd6e6a4ee29d0f8b66bc040c8d6d) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200996))
- [Add job messages model to store error messages](https://gitlab.com/gitlab-org/gitlab/-/commit/5cca73141b1ebbad5198d450438d68c291163ab8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201775))
- [ParallelProjectExportWorker should mark interrupted exports as failed](https://gitlab.com/gitlab-org/gitlab/-/commit/b9127be4e4306a8479787e7b60256d05788c720f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201766))
- [Mark 20250429164908 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/6ffb2420aaa8e0a535c5bdde67dc7c5f65e72895) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201689)) **GitLab Enterprise Edition**
- [Requeue BackfillJiraTrackerDataShardingKey migration](https://gitlab.com/gitlab-org/gitlab/-/commit/a6215a5c85fa905b2f74f82ba31c289bbbab93c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197199))
- [Remove the ci_glab_for_release FF](https://gitlab.com/gitlab-org/gitlab/-/commit/19ff9ce4e20e28be2ec1efe3c72a92069862df6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200307))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/145004a73d36dbf98eef906d3e95abc8a309a6f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201221))
- [Add config_options schema validation with feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/97ec03d674b9242d352bfa2c33812e6dd6f7f70e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195467))
- [Add index on merge_request_cleanup_schedules#project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/fe3f66a9e602c8d7f10f6391e9afc155d71a7818) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201825))
- [Remove software_license_id from software_license_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/ef0a2fe23663bbba33157f11dc07d8f9065ed548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199948))
- [Mark 20250423184327 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/dc485eb10f85e2e78945a00cc26757b65116bc08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201688)) **GitLab Enterprise Edition**
- [Consolidate org creation FF into org switching](https://gitlab.com/gitlab-org/gitlab/-/commit/5d4d001e88a22d9e76618f4432ceb370b4d5f906) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201024))
- [Remove the zoekt_search_api FF code](https://gitlab.com/gitlab-org/gitlab/-/commit/529f39b835d9d895145be948bbc956b99f3621ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201448)) **GitLab Enterprise Edition**
- [Remove jobs from deprecated UpdateProjectRunnersOwnerWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/28637a85eb9ae3719a322e7bbbb49e8b3ee3eeec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201812))
- [Add FK constraint (NOT VALID) to amrru#project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/e390b174455b0d32138372bd01b1170a8c896c29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200661))
- [Add index to amrru#project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2aef0c31ad1f12f3fb3984ad57fef2826df98036) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200661))
- [Add FK (NOT VALID) on push_event_payloads#project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/360fed4bea81d8c76df38b4731b6c0a5cb45e264) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201179))
- [Add index to push_event_payloads#project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/bfe66cb4a03b82bc44b0bd76fd71549fa562b86a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201179))
- [Ignore sharding_key_id column on runner-related models](https://gitlab.com/gitlab-org/gitlab/-/commit/987ac04104cbcaba2b8ad5a3894920e9fb3e3cc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201726))
- [Finalize BBM BackfillSnippetRepositoriesSnippetProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/a473fde9a58d7a72afafc79f68e45b2f7433adde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197544))
- [Remove the code related to FF zoekt_syntax_transpile](https://gitlab.com/gitlab-org/gitlab/-/commit/8b96dbfa9888c41c0a48b46a221c201cfb4fed7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201465)) **GitLab Enterprise Edition**
- [Migration to remove sidekiq jobs for confidential epic worker](https://gitlab.com/gitlab-org/gitlab/-/commit/3eed5264bd2a24db76fba79a4b767d5fbc889d7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200894))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/5c73da9d08e0c5732bead4407bfdeeffba00ca80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197074))

## 18.3.6 (2025-11-11)

### Fixed (3 changes)

- [Fix redirect loop in Gitea rate limit](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bd7b910e82630cf34e076d259898300063ca20b3)
- [Update dependency openssl to v3.3.2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/600ca97b8bcb50f826f7e5412535f31c2f6d2496)
- [Update rexml to v3.4.4](https://gitlab.com/gitlab-org/security/gitlab/-/commit/50b5a85fa48b062f5162f46ef30a351982cb73bb)

### Security (8 changes)

- [Security fix package api pipeline details](https://gitlab.com/gitlab-org/security/gitlab/-/commit/64c2516e6106fc3d9b5a4adc8888891b56a05476) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5426))
- [Group enforced pages access control should restrict non-members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/af0f99c9f71f16648a4cdcbb2fac78697efc20a8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5442))
- [Update to gitlab-glfm-markdown 0.0.38](https://gitlab.com/gitlab-org/security/gitlab/-/commit/71f73bd9e5df05fbcbdcd14dc29f7dea0b923902) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5463))
- [Encode protected branch names in API requests](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3cec6a99eceb5ae142612de4fc91c0df7d9b5691) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5458))
- [Prevent GraphQL subscriptions from blocked users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b70790900eada6b2fd02c84691d0fc9de78b808c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5432))
- [Prevent Duo Chat from reading confidential resources](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7a5abb5be4705ebabdc87074bf7193d839cd02bd) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5380))
- [Hide related branches when repository is private](https://gitlab.com/gitlab-org/security/gitlab/-/commit/472346b8db8ebc75c6ae3e26063ec0565e4bbe2a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5436))
- [Fix unauth workflow deletion by service accounts](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8d86f81230f96b8a031793ebbd0a5e12e3c0766f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5423))

### Performance (1 change)

- [Reduce cached SQL queries in `/api/v4/internal/pages` endpoint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e6a23475339be5edb58e8886f23bc10f2de56e1e)

## 18.3.5 (2025-10-21)

### Fixed (3 changes)

- [Downgrade redis-rb gem to v5.4.0](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0c70390c57627b25f78a942083ba3b74533fcf38)
- [Fix the undefined method id for nil:NilClass in WorkItem](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4bd440fa6f27f70c634bc9645a9026104a08c8f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208109))
- [Prevent session creation for sessionless users](https://gitlab.com/gitlab-org/security/gitlab/-/commit/133098a99deaa183b3a48956287b66fa26f110d4)

### Security (7 changes)

- [Non-group members can be added to projects even though the "Users cannot be...](https://gitlab.com/gitlab-org/security/gitlab/-/commit/df730b1ca1d1ae481bca03824c2f10cfb5baaecc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5279))
- [Ensure NPM upload cannot exceed plan limit](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b7bec383074374690f2a5b5f9e1b1791b5582036) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5429))
- [Limit JSON request payload for /-/collect_events](https://gitlab.com/gitlab-org/security/gitlab/-/commit/eabab1c4adb4919b4bcd0211b8bb0b7263cb0a76) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5405))
- [Track pull mirror updates using gitaly_context](https://gitlab.com/gitlab-org/security/gitlab/-/commit/86dee006dcb389a2cce881ace18f27800637ba9b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5412))
- [Reject quick actions for ai_workflows scope](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d1577ee72eacf3c0b3f9aa8f531c8b4a1604f990) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5374))
- [Use CE policy for runner ability check](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ca704d588d90378f4f80e46808274d6edb1072ae) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5415))
- [Limit depth, size and total elements when parsing JSON string](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ad3192d19fdeaad97211e6cdbd0ea52f7e4fb5a7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5408))

## 18.3.4 (2025-10-08)

### Fixed (2 changes)

- [Remove non Saas instances from calling CDOT for trial duration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/764210b1790db3e4984ecbd404f211c0668af1a4) **GitLab Enterprise Edition**
- [Transfer start and due dates data upon work item move or clone](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ec7a2082e1229aa64d0b1529135f2fb209ba656d)

### Security (5 changes)

- [Log JSON bytesize as well](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bd818dff7bb196ba52e428e8a90eb33869f60fa2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5389))
- [Adjust complexity for blob data fields](https://gitlab.com/gitlab-org/security/gitlab/-/commit/13b1fb00de0ab7db943c579b612b813199084f29) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5385))
- [Some mutations have read_api scope](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a2c70f53fde77761905c184021dba0a1c74013c8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5369))
- [Reject irrelevant 1xx responses](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e8060c8dd0cd6a268ac654b177e2ef7b28b2b245) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5302))
- [Restrict manual variables to explicit guests in internal projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/dcb8ddf94070937b7a245a9f300fede051a30252) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5365))

## 18.3.3 (2025-09-25)

### Added (1 change)

- [Add job project claims to CI ID Tokens](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f2fbc42345c2b907c7b3a8f9988972117199788f)

### Fixed (7 changes)

- [Use isUnsafeLink for xcode protocol](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cceeb02fd87dea5260935ca6dc485eb8de0b62c0)
- [Optimize HandleMalformedStrings middleware for CPU and memory](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4082a4d613c73890bc28839bc60d1352067fd9a3)
- [Merge branch 'tchu-fix-forbidden-causing-save-errors-in-search-admin' into 'master'](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fd9947e3073b242eaddcb29449345cb09a9bc47b) **GitLab Enterprise Edition**
- [Fix the rendering when content is empty](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6b7548ccf491e17aac35ef501f0a67f98f7fc150) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202049))
- [Exclude other report types from scan readiness check](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0d6684b6cff8dd9e323577276fb977b4d2f496a2) **GitLab Enterprise Edition**
- [Fix security widget polling indefinitely when there are sboms](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4613a87bde04e9bf4cd506c70a4e011fa9df986b) **GitLab Enterprise Edition**
- [Merge branch 'ngala/geo-secondary-deployment-filename' into 'master'](https://gitlab.com/gitlab-org/security/gitlab/-/commit/106eca44590cff62d0d4121660b91605b8043f5a)

### Security (11 changes)

- [Increase JSON validation limits on NPM endpoints](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4a9b696cdf821a88cab6664ab179ae46edb54f16) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5361))
- [Addresses logical bug in the GraphQL base resolver](https://gitlab.com/gitlab-org/security/gitlab/-/commit/536a9c86c750c8dfb94fc18f1e75f6a4c6b5975f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5275))
- [Escape text for wrapNodes utility](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4483cacb226a15a75ca690ff5c8e2795895d1597) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5307))
- [Add the rate limit in BlobSearch GraphQL](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0def0dec4033082f8f15a601ef5129372dade734) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5251))
- [Fix Identical Project Names via Move Issue Drop Down leads to Confusion](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d267a454c0eee30648c880c6f5ce17f1400a1c9e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5258))
- [Prevent role assignment for custom roles in projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cdbd08c0d9e72b5ce925c0df3b0fad7c1de5c713) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5338))
- [Only owners can invite groups](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bc2a782805997d9d7be4640d13d8a339020b3ab9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5310))
- [Add limit to array fields in WorkItems API](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0c67ed0d001cb492fbaf5fcac3419ad1349c5888) by @afrnz ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5262))
- [Limit String => Integer conversions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6abe5b8d77c7085cf36253f012ba809cd9341654) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5276))
- [Removes password field from maven upstream GraphQL type](https://gitlab.com/gitlab-org/security/gitlab/-/commit/811f03bc8c1b47ac9a97f32abbda5c57b6f0d61b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5315))
- [Add JSON input streaming validator middleware](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f6991c93fc0d9264d4870efcf372c1347df3b421) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5350))

## 18.3.2 (2025-09-09)

### Added (1 change)

- [Add Compare link to submodule diffs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2f6ecb3f3443b4cd710d59d5bda31ac1475a90f0)

### Fixed (9 changes)

- [Backport comment suggestion line range fix to 18-3](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b6ab76b225017a1e5046a11bc4456a918b76a66c)
- [Update gitlab-shell to v14.45.2 to allow ED25519 for FIPS](https://gitlab.com/gitlab-org/security/gitlab/-/commit/497cc999266226f1a61b5eac3ff87014e313bd4a)
- [Make FileLocationType.endLine nullable](https://gitlab.com/gitlab-org/security/gitlab/-/commit/eabd8d768f54de8c43a8206d272da2dfe82369f2) **GitLab Enterprise Edition**
- [Preserve the exact string representation of the URI](https://gitlab.com/gitlab-org/security/gitlab/-/commit/edc490fcb992e0ca351050beed0397331bb35162) **GitLab Enterprise Edition**
- [Fix nil error in Gitlab:Auth:IpRateLimiter](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6f1d8f3ec3841790aeb1d440122f89ffe8acc00e)
- [Display MCP in General settings of root groups for SM instances](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3abe94466b6ee1c99962d42400da46513d1b5e94)
- [Fix shared group access for advanced code search](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6bc61a1551d9a3c7b4df2c1d19efd33a7fd3f0c6) **GitLab Enterprise Edition**
- [Fix webauthn authentication in Firefox](https://gitlab.com/gitlab-org/security/gitlab/-/commit/05b92aeca1cf8590ae070e3c3d5ad5f12a7130ad)
- [Update gitlab-shell to v14.45.0](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8f040315eb5b3a09c19957fb1697b7e764ff9e6b)

### Security (6 changes)

- [Introduce limit for closed issues](https://gitlab.com/gitlab-org/security/gitlab/-/commit/00b2bd3e6a02e544918f4d604d64c8a5ab4832a6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5257))
- [Add file size limit for blob editing](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4db58c8cb370d31f5c93543bd6c533106c420182) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5296))
- [Fix DoS via large SAML Response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/52602fdd1094a9ca30603ca01be44093799a52e3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5263))
- [Add limit to deploy token name](https://gitlab.com/gitlab-org/security/gitlab/-/commit/df2340492a220a11f9fdebfd54df25be0c6e6d38) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5299))
- [Fix webhook custom header validation](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d80e590444fcee5ed0d747b83f4d051b1b8be218) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5292))
- [Show runner maintenance note only to runner maintainers](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c612438eba64061b130eb44c094c1d142ba6991d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5286))

### Other (1 change)

- [This reverts merge request 200657](https://gitlab.com/gitlab-org/security/gitlab/-/commit/33504c82acc926677c68a1e4c2bf2789a9be71da)

## 18.3.1 (2025-08-26)

### Fixed (1 change)

- [Fix trusted proxies regression when hostname is specified](https://gitlab.com/gitlab-org/security/gitlab/-/commit/70f1e084bfff4ee4e66c25729afba77d11f567f1)

### Security (4 changes)

- [Adjust snippet blob query complexity to mitigate potential DoS attack](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8aeaa284b4625e46b25498a7aea08f46c9808493) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5256))
- [Gitea import rate limiting](https://gitlab.com/gitlab-org/security/gitlab/-/commit/eba1f64c91f30a3196b176cd02212a66b1602437) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5253))
- [Fix tag/branch ambiguity in raw file display](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5c48100ee91213b8ba0d607a67b2dcd972cee889) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5248))
- [Add authentication check for manual variables via new policy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bf00956e1861280ab7e12e2ecc86f314ea125ade) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5255))

## 18.3.0 (2025-08-20)

### Added (205 changes)

- [Use Lookahead for work items children field](https://gitlab.com/gitlab-org/gitlab/-/commit/88fd35c29fcc27f174e80a513bf2d449938b8703) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201725)) **GitLab Enterprise Edition**
- [Add security_inventory_filters table](https://gitlab.com/gitlab-org/gitlab/-/commit/fc95b7f4c8ae135db9f8b1003ba5442ae6b22a15) by @ysiev ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198459)) **GitLab Enterprise Edition**
- [Add workflow events to project graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/45cc21b30ac038dcc47427c6b458dc30d053ba3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200083)) **GitLab Enterprise Edition**
- [Allow for editing of service account email address via UI](https://gitlab.com/gitlab-org/gitlab/-/commit/04ff57cc7ca7f60365f270ef359bd0d93dc042d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201536))
- [Add trigger for work_item_transitions](https://gitlab.com/gitlab-org/gitlab/-/commit/aec76eda3ead8794fc6d9a3ddccec56d86df5cca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200955))
- [Add cron schedule option for LdapAddOnSeatSyncWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/36fcc905a0957791a2e87575a11dfcf7f5bd14ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200729)) **GitLab Enterprise Edition**
- [Add duo agent platform create and start events](https://gitlab.com/gitlab-org/gitlab/-/commit/77edea09fe29e9afec073e13d27493f94cc5f6e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201505)) **GitLab Enterprise Edition**
- [Clickhouse model for ci_finished_builds](https://gitlab.com/gitlab-org/gitlab/-/commit/2a9b8e6fdc61814d92b8328b1a55dac7e3cce7a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198683))
- [Adds FE for ui setting](https://gitlab.com/gitlab-org/gitlab/-/commit/32e39afc14df8f4a8fe8ff438c94af812ba5e666) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200503))
- [Add JiraTrackerData sharding key db trigger](https://gitlab.com/gitlab-org/gitlab/-/commit/da0952c6b6bbeafc67b583ff204f15c204e223bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201119))
- [Add MCP get_merge_request_pipelines_service](https://gitlab.com/gitlab-org/gitlab/-/commit/8a0390c0a30ecef47718e270db3834744387e8c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201586))
- [Add backend link for email work item modal](https://gitlab.com/gitlab-org/gitlab/-/commit/9da1c9321d091776a4432bf8c51d79ed94128139) by @n.h.long.9697 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201422))
- [Gitaly page-token pagination for protected_tags and protected_branches](https://gitlab.com/gitlab-org/gitlab/-/commit/77978da98300bdf28bcf4d37d4ea70f326c30094) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200493))
- [Enable committer_email feature flag to true](https://gitlab.com/gitlab-org/gitlab/-/commit/59cb2d23714db729dd84a538dc3a2cc561462a00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201519))
- [Add vertical resizing to text boxes](https://gitlab.com/gitlab-org/gitlab/-/commit/8e61b92cc785dfa25a1bf4c18b807587cdd818a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198307))
- [Project level open vulnnerabiltiies](https://gitlab.com/gitlab-org/gitlab/-/commit/4e714bd9c871ba69379f90efda42063072f59eb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201036)) **GitLab Enterprise Edition**
- [Add bypass options to a police drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/c3b118436b9528e66b5f70d2c5a66df867a9ef3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200328)) **GitLab Enterprise Edition**
- [Enable AI flow triggers by default](https://gitlab.com/gitlab-org/gitlab/-/commit/84f558e24c0b12c6345b49ec2c6e8d75730234b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201480)) **GitLab Enterprise Edition**
- [Persist Internal Note Checkbox on Draft Comments](https://gitlab.com/gitlab-org/gitlab/-/commit/706eb719760f3cab776ad33ed69222e189e5cc1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199763))
- [Expose user_export_email on LinkPaths](https://gitlab.com/gitlab-org/gitlab/-/commit/a5b4928c26645c7fca5a80967b03e31d306560cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201404))
- [Add endpoint for work item calendar](https://gitlab.com/gitlab-org/gitlab/-/commit/34b291ad2fd1117a0459f63e10d8005f7076174e) by @n.h.long.9697 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198795))
- [Default enable ff_oauth_redirect_to_sso_login](https://gitlab.com/gitlab-org/gitlab/-/commit/f2463b4e63688ac57a86f028b79d5ed84be60e80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200682)) **GitLab Enterprise Edition**
- [Use Lookahead for work items children field](https://gitlab.com/gitlab-org/gitlab/-/commit/ea01ce2bb88e86620f5caaa08d987e36fc3ed2fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198531)) **GitLab Enterprise Edition**
- [Add STATUS_ASC and STATUS_DESC to WorkItemSort enum](https://gitlab.com/gitlab-org/gitlab/-/commit/157cb12b51693d70d952b064aa29f6ebe746bfb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201401)) **GitLab Enterprise Edition**
- [Add bypass options to a police drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/c8b12024379200a9ad759f1cc819b52dc1d496fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200259)) **GitLab Enterprise Edition**
- [Add ability to cleanup untracked CI secure files](https://gitlab.com/gitlab-org/gitlab/-/commit/f6ef0389971d8744c3055095bcbfe3b81c1f7676) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192954))
- [Expose analytics dashboard panel tooltip field to frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/a9a054a22f11f602fbc5c7126847e1999cab096c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201022)) **GitLab Enterprise Edition**
- [Add Jira import action to work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/2338de72f35823943b3f521753365b1ec379035b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200502))
- [Set git_authenticated_http_limit enabled to true](https://gitlab.com/gitlab-org/gitlab/-/commit/96939a9f038544f6b96d1441b8c6650d0eb60fac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201295))
- [Add bypass options to a police drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/cda45a86c5cd1118c418890fe3cedf12f7fa8e84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200486)) **GitLab Enterprise Edition**
- [Instrument authentication via ldap_with_git](https://gitlab.com/gitlab-org/gitlab/-/commit/d26e7d1c0bc0a8984cdeea515ef0bd2b0bf14ff5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199886))
- [Enable failed pipelines audit events feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/104931465b5fb4f17499571e1b20c88f154987a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201174)) **GitLab Enterprise Edition**
- [Enable skipped pipelines audit events feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7d8f7df2f9a84be176851bda13a8e860808d3c95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201098)) **GitLab Enterprise Edition**
- [Add iteration filtering to work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/2beef0c95aa34b1902a94979b99c8e4ac26162ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199739)) **GitLab Enterprise Edition**
- [Add security policy bypass push option](https://gitlab.com/gitlab-org/gitlab/-/commit/1a0cbaa828bfa5029036994c576580b733f9e64f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200025)) **GitLab Enterprise Edition**
- [Adds name argument to update lifecycle mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/69a18d23f1ce4aac9434156eb62b63286548f7ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200819))
- [Add bypass options to a police drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/d59cd934a332c3507a1516b3cc2839a209458cfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200669)) **GitLab Enterprise Edition**
- [Remove security_policies_bypass_options_tokens_accounts feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9b99262bbdccc8aad0a9f28ad42fd60a0328c783) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200786)) **GitLab Enterprise Edition**
- [Fuzzy search labels in quick actions dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/0c49b949daed952945981039932f4d68ef0afebc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200735))
- [Add index_and_search_validation elastic rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/6c2d9308997cd059d38567ae2f442328cc61cb5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200664)) **GitLab Enterprise Edition**
- [Add bypass options to a police drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/65df06c07d9ebce876a8b51e642c53c17c5f83af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200096)) **GitLab Enterprise Edition**
- [Add new project setting: display_pipeline_variables](https://gitlab.com/gitlab-org/gitlab/-/commit/245ab4f1998c860ea39fb7e1194b46956fee1ffa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200232))
- [Fix vertical alignment for devops adoption cell](https://gitlab.com/gitlab-org/gitlab/-/commit/e23f6e5e78dcba6ac87d39ceef6ba4209a04e160) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198416)) **GitLab Enterprise Edition**
- [API endpoint to allow enterprise group Owners to delete enterprise users](https://gitlab.com/gitlab-org/gitlab/-/commit/39e79458370221ff8e2d3f612da2d58efe89ce45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199646)) **GitLab Enterprise Edition**
- [Add job inputs to runner payload](https://gitlab.com/gitlab-org/gitlab/-/commit/a67b57128c80bff868873a8e9744821a92a9e9f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199581))
- [Add ai_workflows scopes to create_issue_links mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/01db63f603bfbb6987e6212eca74a4872102405e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199623)) **GitLab Enterprise Edition**
- [Remove Helm feature flag and related code for package protection](https://gitlab.com/gitlab-org/gitlab/-/commit/83757574aa116d67b751adb45a2bbf3f58c3469f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200799))
- [Document additional branch operations in the Web IDE](https://gitlab.com/gitlab-org/gitlab/-/commit/d226c8b5b097972f995c9cfe09ed2be9f084b7f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200632))
- [Add time range arguments to AiUsageEventsResolver](https://gitlab.com/gitlab-org/gitlab/-/commit/3a6cbd0a092e79fa5987831b5716b987d09d06a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200203)) **GitLab Enterprise Edition**
- [Add support for parent wildcard filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/b3db6acefe61e4097702d8b150fb07cabac9d5cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200140))
- [Add archive_group ability to GroupPermissions GraphQL type](https://gitlab.com/gitlab-org/gitlab/-/commit/671abcd89cf1401271ade8a108195e32d7393c15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200639))
- [Prepare foreign keys for bigint conversion on merge_request_diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/355321ec85f0875b536e9f65807776d709979cc0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196778))
- [Add automated email notifications for expiring project deploy tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/8883ce55416e8250dd796cd1e7f671a3835c84ff) by @guptapratibha26 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195254))
- [Updated custom roles payload](https://gitlab.com/gitlab-org/gitlab/-/commit/f998e5c98981017797c3138a3c1f7ea0b6a4ba01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200398)) **GitLab Enterprise Edition**
- [Add backend for violations export](https://gitlab.com/gitlab-org/gitlab/-/commit/428548ebf644f538ed6fb55c1557fff5e28d8131) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197831)) **GitLab Enterprise Edition**
- [Send a audit event for pep errors during pipeline creation](https://gitlab.com/gitlab-org/gitlab/-/commit/75b40408203d971c212ffe8d177ddf84c919f98c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199819)) **GitLab Enterprise Edition**
- [Add background migration for CodeSuggestion events](https://gitlab.com/gitlab-org/gitlab/-/commit/67f006670e331c7f84fac69a150348b28443ed0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199785))
- [Add graphql fields for enabled security scans](https://gitlab.com/gitlab-org/gitlab/-/commit/44e8ec38aa695ee9f3b8310b04d3898dcd02d128) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199032)) **GitLab Enterprise Edition**
- [Add retryPath to job query](https://gitlab.com/gitlab-org/gitlab/-/commit/1a9b2cf33ef46150295d4131a0c2f933f22d893a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199602))
- [Add release filtering to work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/6ef927b37a0e97d046f764eb8b207bac6c4137d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199741)) **GitLab Enterprise Edition**
- [Create work_item_transitions table](https://gitlab.com/gitlab-org/gitlab/-/commit/a98142b00a9ccaeb21d0053e0317eaafc970fede) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200035))
- [Add ai_flow_triggers table and ::Ai::FlowTrigger model](https://gitlab.com/gitlab-org/gitlab/-/commit/f626c91a00a545d48250eced7da6f9b4b7ce7afe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200396)) **GitLab Enterprise Edition**
- [Add security_inventory_filters table](https://gitlab.com/gitlab-org/gitlab/-/commit/7ef979f9cbc2c59c23a6469f4a4714605acd162c) by @ysiev ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197613)) **GitLab Enterprise Edition**
- [Remove FF change_priority_for_user_access_refresh_for_group_links](https://gitlab.com/gitlab-org/gitlab/-/commit/651aaa61f5d5cabd2242355a0a818ad23534b56f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199845))
- [Show Plan upgrade banner on Free tier](https://gitlab.com/gitlab-org/gitlab/-/commit/890af11b373d8552f626f3c88881f3cc8aa52798) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200080))
- [Add license configuration source to the security](https://gitlab.com/gitlab-org/gitlab/-/commit/470e6c2c227863fe125cc60106a63fb1bedd6d3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197371)) **GitLab Enterprise Edition**
- [Show `Closed` badge when closed categories in status modal](https://gitlab.com/gitlab-org/gitlab/-/commit/018abdb13b55a40722069ad17718f8272a8f1e63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200139))
- [Add `tooltip` field to CustomizableDashboardPanel GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/6b31e7543a29cee1d35cacaaf9e4d9d4ec395c59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199790)) **GitLab Enterprise Edition**
- [Add bypass_settings to a policy constructor](https://gitlab.com/gitlab-org/gitlab/-/commit/4bfa397e0c2ce716f461c34710475419ed08053e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200092)) **GitLab Enterprise Edition**
- [Enable more epic bulk edit options](https://gitlab.com/gitlab-org/gitlab/-/commit/6f47f8bc7504cc372c7d878fd5dfa6c35c0a199d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200186)) **GitLab Enterprise Edition**
- [Add CI_ENVIRONMENT_ID predefined variable](https://gitlab.com/gitlab-org/gitlab/-/commit/01c2eaa171d49c9c790012ae2ac11cbc91b1bc0b) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199758))
- [Add deletion related fields to projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/5e58d95cc77a6a7060b1144109ccee5a5d099970) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196448))
- [Add async worker for partner token verification](https://gitlab.com/gitlab-org/gitlab/-/commit/d0288cfe48a9f46ddc22fd0d66aa8782c806e852) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197843)) **GitLab Enterprise Edition**
- [Remove enable_add_on_users_pagesize_selection FF](https://gitlab.com/gitlab-org/gitlab/-/commit/30b8edf178dc37ef2c6e7a15d6977aff8024e073) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200122)) **GitLab Enterprise Edition**
- [Add project to security attribute table](https://gitlab.com/gitlab-org/gitlab/-/commit/ae7842383aa434183b51e05e82d4ab6f86d9990c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198519))
- [Make user popovers accessible](https://gitlab.com/gitlab-org/gitlab/-/commit/1d2f4f350a1a7e3f24f2b85ded03aa6a8cad8d7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197972))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/1e1d7bc6ecf89fde94aed68aaaac8c14cb880e07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200222))
- [Add single record query to data_management API](https://gitlab.com/gitlab-org/gitlab/-/commit/a6671d05a5d6158a81ac5baf0d75a51448a8e97b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199776)) **GitLab Enterprise Edition**
- [Adds shortcut 'd' to open Duo Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/41ec4080dcb460fbcf88c98d8411068240129ab1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199744))
- [Show manage status link in the status dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/bb1774a6ca8c3bbe6223d1c5cf10f45a01513b87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197082))
- [Add approval_policy_merge_request_bypass_events to store the bypasses](https://gitlab.com/gitlab-org/gitlab/-/commit/143055f44a4596657a4d35350e0f09dc6bf88587) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199151)) **GitLab Enterprise Edition**
- [Add tooltip support to search suggestion](https://gitlab.com/gitlab-org/gitlab/-/commit/113555e3a481112cef609c94e79823633ac5817e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200015)) **GitLab Enterprise Edition**
- [Send email notification when PAT is rotated](https://gitlab.com/gitlab-org/gitlab/-/commit/1ce83781914128a8acc76b86c1c5213fab2ef5eb) by @stalb ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199360))
- [Protected containers: Integrate delete protection in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/a96b10dc0e169ebec52ab9b58a16b3bb545828f8) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183545))
- [Revert removing Duo Code review claude 4.0](https://gitlab.com/gitlab-org/gitlab/-/commit/1c49537f2807cd896c6318980ade6f1a10bdcea0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199979)) **GitLab Enterprise Edition**
- [Add backend support for retrieving database schema results](https://gitlab.com/gitlab-org/gitlab/-/commit/ccee7abf9112370a9ab8128988d5377db3dd353c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200156))
- [Add groups archive service audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/d86d2573285512b3dbb088e1240e68f04741ac15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199419)) **GitLab Enterprise Edition**
- [Enable custom_admin_roles FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/62eb8483e17d31a1883ec3f57103ba61aedbd978) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200034)) **GitLab Enterprise Edition**
- [Enabled glab ask git for Amazon Q](https://gitlab.com/gitlab-org/gitlab/-/commit/45d87a75f36dabcd6a653e0f4b64c5887e7c43eb) by @protsivd ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199613)) **GitLab Enterprise Edition**
- [Auto collapse a line discussion if all threads on line are resolved](https://gitlab.com/gitlab-org/gitlab/-/commit/e4ead5b3183656dd0541252103d7f408daeec15b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197878))
- [Add committer email to x509 commit signatures](https://gitlab.com/gitlab-org/gitlab/-/commit/8dc5d9e83d70725b7f0e5e0a0898dd5bb8e32d28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199484))
- [Display Validity Check Token Status on Vulnerability Report](https://gitlab.com/gitlab-org/gitlab/-/commit/b76d6ec8962994e992ec7d758860a6c0a70ef21a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197337)) **GitLab Enterprise Edition**
- [Default enable security_policies_bypass_options_tokens_accounts](https://gitlab.com/gitlab-org/gitlab/-/commit/99166cd732a6c3f9cc97d0c75f31792cb08e2153) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199811)) **GitLab Enterprise Edition**
- [Show available statuses menu on status quick action](https://gitlab.com/gitlab-org/gitlab/-/commit/de8a8ec31ea0ff355188d244d7ee0c407bc21a29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198348)) **GitLab Enterprise Edition**
- [Enable Rapid Diffs on compare revisions page by default](https://gitlab.com/gitlab-org/gitlab/-/commit/4da13513b36b201c31fcecf3644ef91bbf075323) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199909))
- [Add negated iteration wildcard filtering for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/8e7f4e8ac0baf2a52afcb227df3983135b8f50ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199577)) **GitLab Enterprise Edition**
- [Reschedule finalization of MigrateEvidencesForVulnerabilityFindings](https://gitlab.com/gitlab-org/gitlab/-/commit/c1df4de0b223ca8e0863b0bf91cfcfcfded795ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199752))
- [Add experiment to fail pipeline when `.pipeline-policy-pre` stage fails](https://gitlab.com/gitlab-org/gitlab/-/commit/3ef72900a33d0480f82d67e4299eb10ac3b16de6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186968)) **GitLab Enterprise Edition**
- [Work item iteration popover](https://gitlab.com/gitlab-org/gitlab/-/commit/2ed5016338a5978bb1910d01b0cc47f954beff2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199446))
- [Add roles to bypasss options](https://gitlab.com/gitlab-org/gitlab/-/commit/3f610aa3eec0742102dffde70eff609e11ec78f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194043)) **GitLab Enterprise Edition**
- [Refactor autocomplete_sources_path to return all paths](https://gitlab.com/gitlab-org/gitlab/-/commit/a30d8fc9043f823089b0f683c7090f1b3fb36ba8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199229)) **GitLab Enterprise Edition**
- [Add Vulnerability ID to archival export](https://gitlab.com/gitlab-org/gitlab/-/commit/a029204bf43569c2a97ce514e9e7bfffb587b014) by @he-patrick ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198840)) **GitLab Enterprise Edition**
- [Add graphql endpoint for license configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/54cc594cd21b8fdf0e3416f9831b26cf6e4c971d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197369)) **GitLab Enterprise Edition**
- [Feat: Duo Amazon Q Generate MR Message](https://gitlab.com/gitlab-org/gitlab/-/commit/bc2197c116554f5da68d03bde9ba5247a89a2ced) by @wubenso ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199037)) **GitLab Enterprise Edition**
- [Add highlighting for Veryl language](https://gitlab.com/gitlab-org/gitlab/-/commit/bd96e6f8e78d4f3923de9cd43603d79e1ef5e04d) by @dalance ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199076))
- [Basic scaffold for primary verification API](https://gitlab.com/gitlab-org/gitlab/-/commit/a5e42bdb907bbbe9abc1772e6f4013bc6ae3d650) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197917)) **GitLab Enterprise Edition**
- [Add category create and update service](https://gitlab.com/gitlab-org/gitlab/-/commit/21ab62e510b780526323912675cd639f5e23e193) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199099)) **GitLab Enterprise Edition**
- [Add Database Diagnostics monitoring page](https://gitlab.com/gitlab-org/gitlab/-/commit/989936458cff4243bb156097070d75bdfa5f8a54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198009))
- [Add include_descendant_work_items arg](https://gitlab.com/gitlab-org/gitlab/-/commit/78dae69282cc3df429dfb387118618f7f778b30e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199065))
- [Add distinctive background for empty lines in Rapid Diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/9f271c99b11dee2ec142929baa8a270c954f24da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199634))
- [Add CI_PROJECT_TOPICS predefined variable](https://gitlab.com/gitlab-org/gitlab/-/commit/a0997480d0277eacc05b0df51edb36a165c85ec7) by @adrien.gooris ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199182))
- [Add documentation for pipeline sources](https://gitlab.com/gitlab-org/gitlab/-/commit/c1453f4304a1bff48204bc14e2e556c157966a16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196762))
- [Add Linear external issue tracker integration](https://gitlab.com/gitlab-org/gitlab/-/commit/c5e2b3e4f5d5360bc977478e97c5ab4dbb2ac589) by @leipert ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198297))
- [Expose adminWorkItemLifecycle GraphQL field](https://gitlab.com/gitlab-org/gitlab/-/commit/19c25629496a7a4c164e57d7f8ac665b59ca9fd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199228)) **GitLab Enterprise Edition**
- [Restore and finalize MigrateRemediationsForVulnerabilityFindings](https://gitlab.com/gitlab-org/gitlab/-/commit/02c982e7bf46a70a3b5534d1edead6b276ebf858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197534))
- [Expose issuesSettings GraphQL field](https://gitlab.com/gitlab-org/gitlab/-/commit/327f10b0cbe7105b599a661a6f3d9a01fffb2048) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199249))
- [Migrate AI events tables to AI usage data](https://gitlab.com/gitlab-org/gitlab/-/commit/25be801caf437fb521f3658002fc8a434e9cc28a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195474))
- [Add status filter support for work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/9484416aa070419826437da40fef96411c54c738) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198825))
- [GraphQL: Remove experiment status for some runner types](https://gitlab.com/gitlab-org/gitlab/-/commit/d729e851d4afc8295a78b04c4b4845d6b8ae7903) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199242))
- [Add security_inventory_filters table](https://gitlab.com/gitlab-org/gitlab/-/commit/417b7250009ecbca112eb93890bbf83cbd63d055) by @ysiev ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198112)) **GitLab Enterprise Edition**
- [Add SecurityMetricsType for project](https://gitlab.com/gitlab-org/gitlab/-/commit/dfd71d21b9ed2aa5b8272569cb6ccb78b319bc58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198192)) **GitLab Enterprise Edition**
- [Add full namespace descendants cache](https://gitlab.com/gitlab-org/gitlab/-/commit/d5d497d728a3503f41ad959fe31b4b77804d5764) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199449))
- [Add security category table](https://gitlab.com/gitlab-org/gitlab/-/commit/78a742403e0701e039667f99eedbd1fb353cfdd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198085))
- [Audit API access to group and project variables](https://gitlab.com/gitlab-org/gitlab/-/commit/58742be9f928fa29c3ce0ebf3836e677941be7f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197385))
- [Extend policy bypass option to include users, groups and roles](https://gitlab.com/gitlab-org/gitlab/-/commit/05df2d6e29a3fecb1c437ca9642c0e5e9d597d13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199017)) **GitLab Enterprise Edition**
- [Expose more licensed features in namespace.licensedFeatures GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/c063e90f65cb91d655d2e9f399888791b5f71f4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198572))
- [Modify group_push_rules sync triggers](https://gitlab.com/gitlab-org/gitlab/-/commit/34da2c89230333d0a22dab0e9d05e4ae89bba015) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199043))
- [Add system note when an issue is unlinked or linked to a violation](https://gitlab.com/gitlab-org/gitlab/-/commit/65230d751e172f8c3e417cd59526a85c5c61d5ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198722)) **GitLab Enterprise Edition**
- [On Project create, set pages unique domain based on application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/af28cf5f4bdc2e314f54803d96b233ac18d8902c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199174))
- [Allow to filter issuables assigned to group members](https://gitlab.com/gitlab-org/gitlab/-/commit/1ace66fd26c5f69aafa99733530143fb695bc3ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196727))
- [Add users to bypasss options](https://gitlab.com/gitlab-org/gitlab/-/commit/58f319dbaf87516a823823adea00412f9f510c60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199265)) **GitLab Enterprise Edition**
- [Allows surrounding quote usage in status quick action](https://gitlab.com/gitlab-org/gitlab/-/commit/fbc1c38b31ee1247745d691d9bdabc48365decb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198926)) **GitLab Enterprise Edition**
- [Remove feature flag compliance_group_dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/312f0b74f8a276b9a79f1b184c10d6614cb11fdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198919)) **GitLab Enterprise Edition**
- [Add archived field to GroupType and GroupChildEntity](https://gitlab.com/gitlab-org/gitlab/-/commit/e775cc8380ad7c816921eba1caf3c11440c66ef1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197597))
- [Add groups to bypasss options](https://gitlab.com/gitlab-org/gitlab/-/commit/b35360c8f457e55c65c49d289774acab8556e90a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194083)) **GitLab Enterprise Edition**
- [Add autocomplete for [issue: and [work_item:](https://gitlab.com/gitlab-org/gitlab/-/commit/37edf9df35feda1c2badc3bd9289df558532ea1b) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192275))
- [Add internal event tracking for work item preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/36a26ce18b9b3121748c77eadf0a25eb06c8da58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198482))
- [Add health status filter tokens to work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/00144d87c17de4077d67354a8d3c9cb8fe4655f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198932)) **GitLab Enterprise Edition**
- [Update grpc to v1.74.0](https://gitlab.com/gitlab-org/gitlab/-/commit/1fe9c3841c60c5afe7bfdad99524372ae2a35666) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199224))
- [Expose hasStatusesFeature field in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/7e7dfdad76ed1e1f483571e7cf226053bca6a765) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199207)) **GitLab Enterprise Edition**
- [Add legal disclaimer for catalog page](https://gitlab.com/gitlab-org/gitlab/-/commit/0ad6bc0f540eddc02682e9e4f45489e0c883ae42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199109))
- [Add workflows to project graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/d69112ea00e2ac50056d250d6b0751642c3dc672) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196164)) **GitLab Enterprise Edition**
- [Prevent infinite pipeline loops from CI job token pushes](https://gitlab.com/gitlab-org/gitlab/-/commit/7c4e24c3c3816bd9e30c566aaf4ae8ff4d081bc0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197418))
- [Show GLQL popover only when focused on editor](https://gitlab.com/gitlab-org/gitlab/-/commit/67d28e6f1fa8e2833410aaaf0d6a02c3c03cc07e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199115))
- [Add resources section to linked items widget](https://gitlab.com/gitlab-org/gitlab/-/commit/fb6c2eb7b897e7cb5e3d331c3fd4203bbc989893) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194876))
- [Enabled assign reviewer for Amazon Q](https://gitlab.com/gitlab-org/gitlab/-/commit/15eecdbcd5e741accca74aa95c80d4c92e3c898d) by @protsivd ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198344)) **GitLab Enterprise Edition**
- [Show status badge on Issue popover](https://gitlab.com/gitlab-org/gitlab/-/commit/18b82a4b642179aacf16def07fda5e9af494ab52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198618))
- [Add protected status information to GitInfo structure](https://gitlab.com/gitlab-org/gitlab/-/commit/d5d73d13cd43b8bb8d4d75432e9f6b75111d9634) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198820))
- [Audit event details drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/3650f4b9281491dbfb846f7f7bbe85d112c6256a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196622)) **GitLab Enterprise Edition**
- [Add backend support for running DB schema checks](https://gitlab.com/gitlab-org/gitlab/-/commit/7df9bfe579d6f3019dec70d7be7426299140a4bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198859))
- [Add merge_requests_enabled field to namespace in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/9e3579990f9c78df496227475b6dd026a6e006c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198958))
- [Enable the ActiveContext pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/e7922cb53fa5c04b0f0c38e701b40c6c924470e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198185)) **GitLab Enterprise Edition**
- [Restore and finalize MigrateEvidencesForVulnerabilityFindings](https://gitlab.com/gitlab-org/gitlab/-/commit/ce8b4eb118f0f64f1ce92f69fd0899ecc5995d35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197631))
- [Add weight filter token to work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/7c7f04b95e4f8749784c1cb7c46191c0fed710e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198712)) **GitLab Enterprise Edition**
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/1eb8fecd9462ae4958e1365fb6f55dca88ca8947) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197561))
- [Support bulk status updates for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/06d1f624405db030592902e148ab9e61804378c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198041)) **GitLab Enterprise Edition**
- [Add inactive_resource_access_tokens_delete_after_days instance setting](https://gitlab.com/gitlab-org/gitlab/-/commit/dc0679dcdc734c28f8fda28940001cb416fe2a86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197134))
- [Add security_inventory_filters table](https://gitlab.com/gitlab-org/gitlab/-/commit/1e83c186a11361b55486aa8e8cdc9742f1b0bc34) by @ysiev ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197186)) **GitLab Enterprise Edition**
- [Persist scan_type and pipeline_id on vulnerability_partial_scans](https://gitlab.com/gitlab-org/gitlab/-/commit/465f50d8e6532abf8210fbd9dc571c324ce83741) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198791))
- [Add Duo Agent Platform service account docs](https://gitlab.com/gitlab-org/gitlab/-/commit/3d44ec92d314d8f745736ecfaed4c92073aae029) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198284)) **GitLab Enterprise Edition**
- [Add outbound allowlist to allowed endpoints for SSRF filter](https://gitlab.com/gitlab-org/gitlab/-/commit/dcc729be9ace10fe93e957466015a27d0420a95f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198742))
- [Add application setting: pages_unique_domain_default_enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/a4a2a709995638d054ac85cdbff8064aeddd34d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198511))
- [Allow asciidoc toc class to not be sanitized](https://gitlab.com/gitlab-org/gitlab/-/commit/30e8ff22ba5597fb88266d2464a65176873e7850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197985))
- [Add security category table](https://gitlab.com/gitlab-org/gitlab/-/commit/95f1cec1d8d2dd991b886c7c3c71335a0a33d42f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197798))
- [Allow `self_rotate` scope in API endpoint to create PAT for current user](https://gitlab.com/gitlab-org/gitlab/-/commit/7d85605a97ef4e2782da33dd250b69b5e5d7c605) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197771))
- [Add deprecation status to AI usage events](https://gitlab.com/gitlab-org/gitlab/-/commit/823fffd92ae1a17f6cb0d3e68d1932660ed48186) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198699)) **GitLab Enterprise Edition**
- [Add AWS_DEBUG env variable for debugging S3 in Workhorse](https://gitlab.com/gitlab-org/gitlab/-/commit/79f9b5f92c63604e1ded0997d5539bcf26d0d52a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198651))
- [Show proper error messages](https://gitlab.com/gitlab-org/gitlab/-/commit/1c6e2de0cea253a83486857f2555c1507ad7ed51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197255))
- [Add available_features to namespace type](https://gitlab.com/gitlab-org/gitlab/-/commit/aa16d1e1f9b56c254c9c79bb52209a5b4cd239cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197095))
- [List system notes on violation detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/6491c149c6ee1f616733ae8a48d07952dcfbf340) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197071)) **GitLab Enterprise Edition**
- [Remove feature flags for security policy audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/5412e4735573a48cb7deabba1a176fe3c83be5e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198350)) **GitLab Enterprise Edition**
- [Add scheduled for deletion message to groups](https://gitlab.com/gitlab-org/gitlab/-/commit/280d68d1678ab6bf3abbee2072b3ec41006acc5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198191))
- [Add kind argument](https://gitlab.com/gitlab-org/gitlab/-/commit/80fa4b5e1b701631c65f0d1a94f6a417697046d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198134))
- [Adds attributes for email-based OTP to UserDetails](https://gitlab.com/gitlab-org/gitlab/-/commit/5444454472b5d5ca4604b85b78db5bb4b74c8b1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197706))
- [Add creation logic for vulnerability read igestion](https://gitlab.com/gitlab-org/gitlab/-/commit/116a85e5ccc02f1fd9ebe55e6b19d985bcedd93e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193387)) **GitLab Enterprise Edition**
- [Improve sorting and table header cell in GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/ba922beec0042b0ba7efd90b093a4d612c5ff67d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197817))
- [feat: Add success toast upon cloning with HTTP/SSH](https://gitlab.com/gitlab-org/gitlab/-/commit/547b70bdea516e5c7bdc49cd3d4d4eca5797a328) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197795))
- [Add configurable limits for SEP, MRAP and VMP policies](https://gitlab.com/gitlab-org/gitlab/-/commit/a99718014f571b8a27270625f19ebbd93c66a8b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188233)) **GitLab Enterprise Edition**
- [Add license_configuration_source to](https://gitlab.com/gitlab-org/gitlab/-/commit/ba85a0fbe11e28a7fc7d897c753cd14c6c1cbc4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195206)) **GitLab Enterprise Edition**
- [Remove approval_policy_branch_exceptions feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/76edcedc99e2d0d417b7188459866b41434888cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197938)) **GitLab Enterprise Edition**
- [Add the ci_job_inputs table](https://gitlab.com/gitlab-org/gitlab/-/commit/650e1fc87cb9642b9ea765af4e955cfcad471f37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194719))
- [Persist collapsed state in GLQL blocks](https://gitlab.com/gitlab-org/gitlab/-/commit/a09e6ab18ff77aa824bb80dde486bd907cc28b74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198117))
- [Embedded views GA](https://gitlab.com/gitlab-org/gitlab/-/commit/048b40d6b9193e52cce04243bc9c5c98b5f7e2ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197950))
- [Remove rapid_diffs_on_mr_creation feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b6f725681773d19d42e4f6a0e6fa7485f6ac4867) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197894))
- [Add email notification for pipeline variables migration completion](https://gitlab.com/gitlab-org/gitlab/-/commit/f381a6de4c1c246effe9b70d79d192d8f898b132) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196500))
- [Adds alt+shift+p shortcut](https://gitlab.com/gitlab-org/gitlab/-/commit/2b97c0bf5ab8d7c53a2223656e8e36ec37ac3973) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198078))
- [Add documentation link to status settings page](https://gitlab.com/gitlab-org/gitlab/-/commit/18578013236f2edfd747eace8cd49e9efce82294) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197883))
- [Add sbom_graph_paths.top_level column](https://gitlab.com/gitlab-org/gitlab/-/commit/4b6e5bac0015c1f19b52d897548ef0f1fdea459b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197606))
- [Unlink issues from compliance violation](https://gitlab.com/gitlab-org/gitlab/-/commit/c7aebf3e408051c7b2d502ca80d12bf6d5d1be71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196757)) **GitLab Enterprise Edition**
- [Add workItemsStateCount field to namespace type](https://gitlab.com/gitlab-org/gitlab/-/commit/9a08f13d0e2d653696fbae85b231f5ef5f1456d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197575))
- [Add a collapsed parameter to GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/4659af5e5bb43011db094e387cc7cd4920f32f5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197824))
- [Add indexed_at and schema_version to KG replica](https://gitlab.com/gitlab-org/gitlab/-/commit/1cb65a5ae4a921012e0d4cdc328746703692fad7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197462)) **GitLab Enterprise Edition**
- [Add failed pipelines with security policy jobs audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/b555923c3deeddf33e9d2d28ee143bd01c318314) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196628)) **GitLab Enterprise Edition**
- [ES backfill migration for vulnerability reachability field](https://gitlab.com/gitlab-org/gitlab/-/commit/1f5b3b83a6815c6898facba98f29b0ba866a83a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197007)) **GitLab Enterprise Edition**
- [Show Duo Agent platform settings on self managed](https://gitlab.com/gitlab-org/gitlab/-/commit/5b3d7678f2359884829b1f0eba6c44871326cf91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197439)) **GitLab Enterprise Edition**
- [Add documenation for IndexRepair task](https://gitlab.com/gitlab-org/gitlab/-/commit/580cd2380d294247b9d776218c41888a6b142d3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197339))
- [Set default concurrency limit based on urgency & max threads](https://gitlab.com/gitlab-org/gitlab/-/commit/307309068aa971656386fef6eb0655c5caa4858f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194881))
- [Link issues with compliance violation](https://gitlab.com/gitlab-org/gitlab/-/commit/a9c2c864e9cebb7e0eadff447ba1893e06bb40ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194579)) **GitLab Enterprise Edition**
- [Add exposed artifacts columns to p_ci_job_artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/daae392b94f8443d44d7ceec592e7227f3664f15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197728))
- [Add audit events for API archive calls via service refactor](https://gitlab.com/gitlab-org/gitlab/-/commit/f2e8439a2610eeed697345e118bf030cfa2c4f28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197348)) **GitLab Enterprise Edition**
- [Add preferred language to GET /user output](https://gitlab.com/gitlab-org/gitlab/-/commit/d576d7767178cb4e48bc6b2d498299584c1e0e07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197847))
- [Add issue to MR button](https://gitlab.com/gitlab-org/gitlab/-/commit/bf2bc7e24f3628c6b161239c9a4af8fcf09f9c20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197607)) **GitLab Enterprise Edition**
- [Remove rapid_diffs feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a70238c032ec26e799d4224f6ffa84d75b8aa91c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197779))
- [Add patch and diff formats for compare controller](https://gitlab.com/gitlab-org/gitlab/-/commit/ca301ab0e385b28f2137c2c7a8785f8d48dcc9e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193789))
- [Preserve markdown in rich text editor](https://gitlab.com/gitlab-org/gitlab/-/commit/907041f452a8acf85a364e5be04d7551465ae968) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197681))

### Fixed (182 changes)

- [Provide discernible name for dropdown trigger](https://gitlab.com/gitlab-org/gitlab/-/commit/cbe2596ae2081954ba393e541ddbd7ae51f4e7d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201341)) **GitLab Enterprise Edition**
- [Add limit to security policy projects queried before deleting group](https://gitlab.com/gitlab-org/gitlab/-/commit/d50b28a909395e07315f941ffcb8aacd1434b580) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201488)) **GitLab Enterprise Edition**
- [Fix collapsed config setting in GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/ab5da99bc84954e4bc51c22752cf022c8f8852a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201596))
- [Fix wrapping of inline code in rendered markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/86dbf29825f5795a73144798d59eb63744340d6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201646))
- [Add metadata cache validity hours to Maven upstreams](https://gitlab.com/gitlab-org/gitlab/-/commit/0c63fd18f0f23b198aeb47839371ea96c6dfc587) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201023)) **GitLab Enterprise Edition**
- [Update gitlab-shell to v14.44.0](https://gitlab.com/gitlab-org/gitlab/-/commit/c8f77ed3be964cff2622205719ec0b930b89a358) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201616))
- [Restrict issues settings access to maintainers+](https://gitlab.com/gitlab-org/gitlab/-/commit/f0220939132314b0773f8aa1bf75f38058e10726) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201427)) **GitLab Enterprise Edition**
- [Fix label template on project creation](https://gitlab.com/gitlab-org/gitlab/-/commit/40a9be7a5ff0f6fa99ea90ff65d5184b12277246) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201544))
- [Restrict the issues settings page to root groups](https://gitlab.com/gitlab-org/gitlab/-/commit/6f23d320b6234c7fd5df0940c72cfcb93e73cd97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201258)) **GitLab Enterprise Edition**
- [Do not show heading anchor links in Duo chat messages](https://gitlab.com/gitlab-org/gitlab/-/commit/51baf1407fce9d4be89293ced09bdfc86995b216) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201529))
- [Fix avatarUrl in Duo chat](https://gitlab.com/gitlab-org/gitlab/-/commit/d49fa87956bca0149f960bc478dcb4e5c2297829) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201526)) **GitLab Enterprise Edition**
- [Fix wrapping of inline code within paragraphs](https://gitlab.com/gitlab-org/gitlab/-/commit/414867237c06901a9a53c270166f6e26339f8b89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201484))
- [Fix revoking cluster tokens with same name](https://gitlab.com/gitlab-org/gitlab/-/commit/0131484b38e6e299744fffb52c94cbf8d75dd440) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201463))
- [Resolve analytics pages not redirecting to group SSO](https://gitlab.com/gitlab-org/gitlab/-/commit/5eb872bc73e25fde271ffdd43713fdeab89c172d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200511)) **GitLab Enterprise Edition**
- [Updated project dashboards abilities check](https://gitlab.com/gitlab-org/gitlab/-/commit/35b84e4e8af96eb693929199c694f069799a5916) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201074)) **GitLab Enterprise Edition**
- [Fix: Update duo issue to mr with status check](https://gitlab.com/gitlab-org/gitlab/-/commit/40d42bdc70c6028896f5fc9173d5b33d88c3b1b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201026)) **GitLab Enterprise Edition**
- [Fix Error Handling Logic in Subscription Breakdown Vue Component](https://gitlab.com/gitlab-org/gitlab/-/commit/674dee972c72b192a2b73b187272e85230fe8839) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201352)) **GitLab Enterprise Edition**
- [Display caret when user only has access to subgroup](https://gitlab.com/gitlab-org/gitlab/-/commit/4865920c5cc3c992371a4571a698f891f0ad59ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199732))
- [Fix `pluck_primary_key` method](https://gitlab.com/gitlab-org/gitlab/-/commit/9d8044b66a486938f9debb2c4ab4f3b030734d89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201321))
- [Fix project inheritance of Slack App settings from group/instance level](https://gitlab.com/gitlab-org/gitlab/-/commit/931b44db63fa5c598449f119168f7a3749b8da86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200657))
- [Fix falky spec external status check](https://gitlab.com/gitlab-org/gitlab/-/commit/697efa442e455248b931e2a7160c475152cbe5f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201286)) **GitLab Enterprise Edition**
- [Enable feature spec for group unarchive](https://gitlab.com/gitlab-org/gitlab/-/commit/686312979c1b3001f39541ee350de6fdfd9c9f38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201283))
- [Preload gitaly data for merge request diff creation](https://gitlab.com/gitlab-org/gitlab/-/commit/113060db587d94b7c59652b4ebf72f5fe65d162e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201271))
- [Fix EE imports in GLQL field presenters](https://gitlab.com/gitlab-org/gitlab/-/commit/2e09962b29ed71d82c09c2ad86bdc23e8014c1aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201201))
- [Only link to top in work item sticky header when not in a drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/4eea1e815098059e6933ea8a0c6582df6624b7a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201155))
- [Fix RefsFinder to support substring matching in reference names](https://gitlab.com/gitlab-org/gitlab/-/commit/0782f49ebdc7106996781882f7d50d933bc305da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201123))
- [Fix collapsing empty diff lines](https://gitlab.com/gitlab-org/gitlab/-/commit/fc852f5cb95030a4cdaa8dd1a55dd4295d38588b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201105))
- [Update the active_add_on_purchase check to include self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/4932043f15366db98bed89c7ca948f518318dd29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200258)) **GitLab Enterprise Edition**
- [Fix TypeError when JSON table contains array instead of hash](https://gitlab.com/gitlab-org/gitlab/-/commit/fa695e92f0d194b61f5d6f87402826385e797758) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201080))
- [Fix archive group settings returning 404](https://gitlab.com/gitlab-org/gitlab/-/commit/56e12a1cf61cac2325749dc213489adfafada552) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200466))
- [Trigger managed resource deletion when a stop job completes](https://gitlab.com/gitlab-org/gitlab/-/commit/b6d7b1dcc2b6c1dd20d6e3829f97c679ddbe9bae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201064))
- [fix(quick_actions/spend): Check if timezone is empty string as well](https://gitlab.com/gitlab-org/gitlab/-/commit/9b6a7baf58f7a5ce0725f0442c571a45398068b8) by @roth-wine ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199900))
- [Fix broken anchor link handling in read_more.js](https://gitlab.com/gitlab-org/gitlab/-/commit/b0e28d9b5f75a6757f5a7e183fac762c0b372ec9) by @monkey36 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200541))
- [Fix: Moving Project with compliance framework](https://gitlab.com/gitlab-org/gitlab/-/commit/b9f930eb5d67c881de5e747d88058a72c5984e87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198338)) **GitLab Enterprise Edition**
- [Handle missing project or user gracefully in CreatePipelineWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/384312e9c149391e47578b91b16983405b7ad076) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200986))
- [Update scroll buttons when toggling log line](https://gitlab.com/gitlab-org/gitlab/-/commit/68e6ba84a3d46e8b0c2b911a7d9584e834f4e104) by @FloEdelmann ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200524))
- [Wiki note internal replies: Fix background of replies](https://gitlab.com/gitlab-org/gitlab/-/commit/39be0507c3918902f2a3157921e827789d6d4856) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200956))
- [Fix zoekt reindexing logic to prevent excessive task creation](https://gitlab.com/gitlab-org/gitlab/-/commit/1135e7e74bc24bf3c1b45c2f0aedae98f9dbc411) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200791)) **GitLab Enterprise Edition**
- [Hide statuses and iterations for user namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/3aa051311fdaee622cc16b886f368412c3816eaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199531)) **GitLab Enterprise Edition**
- [Fix CVSS vector display on vulnerability details](https://gitlab.com/gitlab-org/gitlab/-/commit/34d922ba6bbd8b6e254404a4fa99c942444fd0e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200834)) **GitLab Enterprise Edition**
- [Fix panel tooltip `descriptionLink` field mapping and schema validation](https://gitlab.com/gitlab-org/gitlab/-/commit/3103a0f4837f0f3e47092c06282d8e21e0537383) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200835)) **GitLab Enterprise Edition**
- [Fix top level group expanding when searching](https://gitlab.com/gitlab-org/gitlab/-/commit/1f0e2441d290ebb8674f002bb99259d36f778dff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200279))
- [Use retryPath for deployment rollback/redeploy](https://gitlab.com/gitlab-org/gitlab/-/commit/e8760c457f423b0c6a1f91d0e3fca78600d9e6d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199726))
- [Return 400 error when Branches API receives an invalid regex](https://gitlab.com/gitlab-org/gitlab/-/commit/35765c6f197ee78e09001d7b3eecacc3bf4f3f0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200778))
- [Make delete orphaned deploy tokens migration noop](https://gitlab.com/gitlab-org/gitlab/-/commit/fe53df79fd9ab96d0337693953012a754b732fc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200647))
- [Fix namespace root ancestor preloader when namespace is not present](https://gitlab.com/gitlab-org/gitlab/-/commit/69ce5457855b1e29f5b1bbc6e852ee4d9a68eb98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200046))
- [Retain updated_at when an issuable is mentioned](https://gitlab.com/gitlab-org/gitlab/-/commit/a1690ffe0d41d5667a3cd5867cec2b12eaa178c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200705))
- [Fix milestone column description](https://gitlab.com/gitlab-org/gitlab/-/commit/f64fa23aba2e5028928b9810c0a857654763ede2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200668))
- [Update duo_workflow checkpoints rake task to use UUIDs](https://gitlab.com/gitlab-org/gitlab/-/commit/61e1c208e096f7ff1b901170cc9c24ccb83671d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200496))
- [Fix behavior of tag rows](https://gitlab.com/gitlab-org/gitlab/-/commit/77a62675b2c58e25adbe02c2975dccd242d36d2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200560))
- [Fix admin role badge on admin users list/details page for Premium plans](https://gitlab.com/gitlab-org/gitlab/-/commit/44cfd2d64c9d9d1d62e2ee04bf56b4403c62e575) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200336)) **GitLab Enterprise Edition**
- [Fix License Compliance widget link for fork pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/c0ad3b05af439aae65d3502c62ef1adecca59825) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200023)) **GitLab Enterprise Edition**
- [Update placeholder for license exceptions](https://gitlab.com/gitlab-org/gitlab/-/commit/d471c4ef3cff81d25a0ed14494f92c53d6866d7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200549)) **GitLab Enterprise Edition**
- [Fix group and project Vue apps when using `relative_url_root`](https://gitlab.com/gitlab-org/gitlab/-/commit/69742fb6046a26eb9c117031fa44e62d4eeb7eeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200577))
- [Check custom_role base_access_level in ScanResultPolicyRead](https://gitlab.com/gitlab-org/gitlab/-/commit/b12be8b5fd738444555e84d7af712d3312d9b876) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200554)) **GitLab Enterprise Edition**
- [Allow authenticated users to read instance runners](https://gitlab.com/gitlab-org/gitlab/-/commit/bea83f82aaff464c9baee2071231c2aaa63678f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199172))
- [fix: Add page title to duo home in SaaS admin](https://gitlab.com/gitlab-org/gitlab/-/commit/1fd918a8f27801e751ceb9721bdb071f2c68204d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200527)) **GitLab Enterprise Edition**
- [Fix `/status` quick action autocomplete for search](https://gitlab.com/gitlab-org/gitlab/-/commit/d9d7dc9b28195454c144248c5983f8cbae6a4669) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200526)) **GitLab Enterprise Edition**
- [Fix submodule URL parsing to handle comments and trailing content](https://gitlab.com/gitlab-org/gitlab/-/commit/3e0789372ac5fb295f25b8dfbb72bcc95720622f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200215))
- [Skip epics confidentiality check when param is false](https://gitlab.com/gitlab-org/gitlab/-/commit/d787dc1d45ac49eea6edb89d389b69f01555dd24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200062)) **GitLab Enterprise Edition**
- [Fix shared group access in search membership filter](https://gitlab.com/gitlab-org/gitlab/-/commit/7e73b9deaa95419a854d6ab796442f9dc05d35ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200088)) **GitLab Enterprise Edition**
- [Remove snapshots from security dashboard integration tests](https://gitlab.com/gitlab-org/gitlab/-/commit/67c802461a73e53abe2f09c0eb9d2fd868f9657a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200229)) **GitLab Enterprise Edition**
- [Detect CORS problems in Web IDE](https://gitlab.com/gitlab-org/gitlab/-/commit/a94db0ca8f1047c68a042692c1479fde5fb83068) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200350))
- [bug: Fix wrong participant count in issue page](https://gitlab.com/gitlab-org/gitlab/-/commit/38d4262972088230347c5b6605e9c2ee6116968a) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194199))
- [Hide LDAP Sync tab on Roles and permissions page for Premium license](https://gitlab.com/gitlab-org/gitlab/-/commit/2b6188650a4e99f4549ac427f0d503d990fa0f6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200458)) **GitLab Enterprise Edition**
- [Resolve groups correctly with html and json extensions](https://gitlab.com/gitlab-org/gitlab/-/commit/1e1ff71334392893cdd5e15c720be2a869af6789) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200197))
- [Display relative references in GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/f5f6799d180ffc3c52bbf8277183fc002ae53aa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200388))
- [Fix numpad enter not working for revision compare dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/1c5a8406f75f084d12ac525ff7125ddd5ebf31c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200385))
- [Fix work item description heading anchor links](https://gitlab.com/gitlab-org/gitlab/-/commit/b3b75c8c03c9a03d9bfc01c6b1d7679a42aa89aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200357))
- [Fix loading state for type selector on work item creation modal](https://gitlab.com/gitlab-org/gitlab/-/commit/4447456b70ad69938f08d58f2d94a6188a933ca6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200372))
- [Decouple :read_dependency from :download_code](https://gitlab.com/gitlab-org/gitlab/-/commit/0aa90b64a34eb5671dca77b66f88acf734399656) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195573))
- [Add custom encoding for repository path for commit data](https://gitlab.com/gitlab-org/gitlab/-/commit/d86edc7c4b869b48abd360955d4019ef39eb58ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200341))
- [Fix the error when configure security scans with a MR](https://gitlab.com/gitlab-org/gitlab/-/commit/832da9f5e338e597a6567b2b95c93e5633483041) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197860))
- [Align search with other buttons in sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/bde52feb53a1b08ab28b3ebbd6053a8943080763) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200260))
- [Fix the reset of sidebar navigation](https://gitlab.com/gitlab-org/gitlab/-/commit/6229aca66af7338eb68330cf689edfa7b6e9292a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200234))
- [Fix job log search for multiple segments](https://gitlab.com/gitlab-org/gitlab/-/commit/5a93c2c2b0acf96725d2b670deb588189a0f3f1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200231))
- [Fix NoMethodError from Projects::CompareController#show](https://gitlab.com/gitlab-org/gitlab/-/commit/9837e9030fa45c7b4dfde65e30e9ebb5536ff512) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200204))
- [Fix NoMethodError for Projects::BlobController#diff_lines](https://gitlab.com/gitlab-org/gitlab/-/commit/df6e634cae1be052bb61c748d8e82aef35582ae5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200196))
- [Fixed UI issues in dark mode](https://gitlab.com/gitlab-org/gitlab/-/commit/2a436c32a9346146902f5998f421b5c9acb45ea5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199767))
- [Ensure security policy bot for scheduled pipeline policies](https://gitlab.com/gitlab-org/gitlab/-/commit/d2a27552b24a8e255bc76f2a30938dd7b61403f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200180)) **GitLab Enterprise Edition**
- [Fixes issue with email not being sent on service account email update](https://gitlab.com/gitlab-org/gitlab/-/commit/128fdeaf2a1790e7a6049e35fb2db9df35901480) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199433))
- [Fix another case where Sidekiq can take too long to shut down](https://gitlab.com/gitlab-org/gitlab/-/commit/84cc4fecb555715deb0e32f7917046ab80e0f5c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200097))
- [Validate WorkItems::DatesSource dates for ElasticSearch compatibility](https://gitlab.com/gitlab-org/gitlab/-/commit/b0776965a2363646d5d5f83058b085cc68de6a35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198733))
- [Show error when user attempts to create wiki page with empty title](https://gitlab.com/gitlab-org/gitlab/-/commit/334a8f3acf72f66e145fd202f073850ce631c21e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194937))
- [Fix nested group expansion in Your Work > Groups Inactive tab](https://gitlab.com/gitlab-org/gitlab/-/commit/f819d43eb28084828bb471a12311e0b202830b2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199537))
- [Fix incorrect redirect url post group SAML SSO](https://gitlab.com/gitlab-org/gitlab/-/commit/b109cb18722aee7f439d0cd1effc9a70043d03a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199331))
- [Use projectRootPath to compose breadcrumb links](https://gitlab.com/gitlab-org/gitlab/-/commit/82b1593c095e96931ac6002a00247190674f558d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200059))
- [Fix NoMethodError for OrganizationClusterAgentsFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/05e4210d2e2f36eb9c40249fb26112b1142fd90b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200013)) **GitLab Enterprise Edition**
- [Maintenance Mode: Client side field count](https://gitlab.com/gitlab-org/gitlab/-/commit/2add8895c13d8441f335ba99d00187dd0232bbfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199031)) **GitLab Enterprise Edition**
- [Fix: ID order dependent receive expectation](https://gitlab.com/gitlab-org/gitlab/-/commit/9796568f98b5a64f9520f049f16f209e84e63925) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199884)) **GitLab Enterprise Edition**
- [Fixes bug for number options that do not have a `type`](https://gitlab.com/gitlab-org/gitlab/-/commit/4651cb64d6d8c3fb64653eb5b2374be7c67dc9db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199154))
- [Extract subscribed field to a separate query](https://gitlab.com/gitlab-org/gitlab/-/commit/f64bd681bdb3170933962ba778af350165779a4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198097))
- [Add uniqueness check per project_id on push rule creation](https://gitlab.com/gitlab-org/gitlab/-/commit/80ec19c1e5aaec81025c59ce4dc0d13439300b5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199163)) **GitLab Enterprise Edition**
- [Fix routing for raw snippets with semantic version branch names](https://gitlab.com/gitlab-org/gitlab/-/commit/4cb48f08a2b2cd470575dbd41bd6bbc3b9f91d1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199788))
- [fix(config/mail_room.yml): Respect sentinels_password if set](https://gitlab.com/gitlab-org/gitlab/-/commit/e7d91508ba4d08fecfa83c14ca20fa405ae9bc5f) by @roth-wine ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196933))
- [Wiki comment internal note: Add missing background color](https://gitlab.com/gitlab-org/gitlab/-/commit/1ff172a4a9e984300e61bb6eb3cf3e6685691535) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199766))
- [Fix manual confirmation message for environment stop jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/cbd5910c53455fa50024390ebc1325e80a6aa32f) by @vj35.cool ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198372))
- [Fix custom roles can not be used for MRAP](https://gitlab.com/gitlab-org/gitlab/-/commit/2182521d470eff7d6d62161aea46decd7533174c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199010)) **GitLab Enterprise Edition**
- [Fix generation of change title system note to not be out of range](https://gitlab.com/gitlab-org/gitlab/-/commit/bf3a6038533fa96b0c16eb96589e128cf80b33b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199699))
- [Fix stacking order between what's new and duo callout/drawers](https://gitlab.com/gitlab-org/gitlab/-/commit/aa2dbf951065db71bef8c930d90b3fd71b1c9ace) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199615)) **GitLab Enterprise Edition**
- [User popover: Break long usernames](https://gitlab.com/gitlab-org/gitlab/-/commit/45fa6909ccebd26da1aae4c503d45326873c6dfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199559))
- [Fix settings block chevron animation](https://gitlab.com/gitlab-org/gitlab/-/commit/f63c30913ec423cf945b4c59d015264de0236b33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199555))
- [Fix failing request when project has no group](https://gitlab.com/gitlab-org/gitlab/-/commit/ccc5a532f453b1ee086917362f50d0f297affb5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199547)) **GitLab Enterprise Edition**
- [Add fix to return correct value from noteUpdated subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/77ede6a6879491ee1394977044e87d511177cb38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199101))
- [Add missing elasticsearch_indexing checks to workers](https://gitlab.com/gitlab-org/gitlab/-/commit/de6858040c49e24974db018f62075bdc496ed86c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198634)) **GitLab Enterprise Edition**
- [Fix uploading focus area](https://gitlab.com/gitlab-org/gitlab/-/commit/46e2b4235e9114466486cfe944b9ae46a8cdc8e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197736))
- [Check group member perms in GroupMentionService](https://gitlab.com/gitlab-org/gitlab/-/commit/da55c9f1fb8d3b684a2410f8d37d980080ba950d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134677))
- [Sync security policies after group transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/c49564b075a0d271e7244c124303d87106618f37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199108)) **GitLab Enterprise Edition**
- [Fix migration rollback for user details registration objective column](https://gitlab.com/gitlab-org/gitlab/-/commit/49fb26eee99e094b05b849e217c0e4c2919e6e01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193340)) **GitLab Enterprise Edition**
- [Fix: include relative URL root in PDF worker and cMap paths](https://gitlab.com/gitlab-org/gitlab/-/commit/baeebd7bdf8752108ea037ee837f04ba630a02d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198984))
- [Move feature flag checks inside classes](https://gitlab.com/gitlab-org/gitlab/-/commit/3d30d4b19d62c12cdfc906861fd37f847bcee944) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197334))
- [Revert GLQL to v0.13.2](https://gitlab.com/gitlab-org/gitlab/-/commit/a0c8fb0c102cfb0fb5d6ddf4864c8fd2529c525f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199429))
- [Validate text limit constraint on oauth_applications.scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/79711e5c9b6993314ae0022f90a269ff38aff8ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195541))
- [Fix NoMethodError for ProcessCommitWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/5e4232c8da09875f7ed089ce186d1839cbac3503) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199427))
- [Allow empty telltale lists in Users::ArkoseSession](https://gitlab.com/gitlab-org/gitlab/-/commit/f3d33faa49f8d109a7c9d5aa11ca48f3c680f8f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199096)) **GitLab Enterprise Edition**
- [Remove duplicate policies from compliance frameworks dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/b37cc6797c513d421008369324dfa3e1c70b16dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198279)) **GitLab Enterprise Edition**
- [Hide new role button on roles and permissions page for Premium license](https://gitlab.com/gitlab-org/gitlab/-/commit/54406582007d39b721233d650ef4caace8c581c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199261)) **GitLab Enterprise Edition**
- [fix: Enable redirection for individual LFS downloads](https://gitlab.com/gitlab-org/gitlab/-/commit/b8105335ffbf5ccfcb7b76f5b70da5532cf8e979) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192486)) **GitLab Enterprise Edition**
- [Use configured protocol in OpenID URLs](https://gitlab.com/gitlab-org/gitlab/-/commit/955d8352a068535dd24976aa1d366629d83781d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199134))
- [Add client-side breadcrumbs for catalog](https://gitlab.com/gitlab-org/gitlab/-/commit/5bfa78abee086953d34bf1840815ae50942d8f69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199019))
- [Hide job count when filtering by bridge](https://gitlab.com/gitlab-org/gitlab/-/commit/4a44d83807830419e9a431cd0531b68c7e98108c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199312))
- [Fix syntax highlighting in merge conflict UI](https://gitlab.com/gitlab-org/gitlab/-/commit/76977c2dbdd64b928edeb07a7838ae62d689669e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199183))
- [Fix WITs with spaces in name + email template](https://gitlab.com/gitlab-org/gitlab/-/commit/dceff370399a4940cc39c85ff41f2b36f0e7bd50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198646))
- [Hide duo pro for premium tier with enterprise add-on](https://gitlab.com/gitlab-org/gitlab/-/commit/91d7ea3b0eda32d5902e555c7525e6580bf12193) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199255)) **GitLab Enterprise Edition**
- [Fix Active Context indexer HMAC signature error](https://gitlab.com/gitlab-org/gitlab/-/commit/a887a1c4dc9ee5e3dfba3a1894a14319c059a69c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199240)) **GitLab Enterprise Edition**
- [Fix n+1 query issue on dependencies controllers](https://gitlab.com/gitlab-org/gitlab/-/commit/745585d0ff0c892b529373c070c72824b580442c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198255))
- [New projects inherit parent value for duo_features_enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/01051e7e8be0e7c731afc70dcac08a3a08dd474a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199042)) **GitLab Enterprise Edition**
- [Change the logic of setting `created_at` for security scans](https://gitlab.com/gitlab-org/gitlab/-/commit/806db0b67a397e5085368f1b536690a5f84ea671) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199139)) **GitLab Enterprise Edition**
- [Order commits in sample hook data from oldest to newest](https://gitlab.com/gitlab-org/gitlab/-/commit/c898fd70fdf6efbb349f9a517d75b881ef1beac0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199128))
- [Reload page on branch change](https://gitlab.com/gitlab-org/gitlab/-/commit/de146755df00ba395ef4507228dd7f0c6cca237e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198467))
- [Remove parent link for child pipeline badge](https://gitlab.com/gitlab-org/gitlab/-/commit/a10f33ff32a359af0a149504f465f5fa1ca0ac62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199093))
- [Change database check in geo:check task](https://gitlab.com/gitlab-org/gitlab/-/commit/40f00b29e34c5a0bf9dfe94afe6f8fd0074b3531) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197635)) **GitLab Enterprise Edition**
- [Add pause_control to three elastic delete workers](https://gitlab.com/gitlab-org/gitlab/-/commit/7dbe9cdfb1f893e23ef99c0f5cfcf8f1ec2048e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198615)) **GitLab Enterprise Edition**
- [Skip Geo secondary for SyncProjectPolicyWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/282d524a6ed6640c8e5daaf1759d1570cfeccc4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198951)) **GitLab Enterprise Edition**
- [Fix Web IDE loading race condition](https://gitlab.com/gitlab-org/gitlab/-/commit/515fca5de5207f2bf44537c3c386ff6d18835402) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198930))
- [MR reviewer warning icon background fix](https://gitlab.com/gitlab-org/gitlab/-/commit/d98c554941c2a2517ba4fa74f00a5ce41f21c80a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198931))
- [Update assignee and reviewer avatar content accessibility](https://gitlab.com/gitlab-org/gitlab/-/commit/5b0ee9d2e0a387c10064290f9b6a20951e1ccdb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198455))
- [Squash commits popover fixes](https://gitlab.com/gitlab-org/gitlab/-/commit/82f9340e885c12095dfb43df57f4214dcbca3523) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198773))
- [Fix empty menu in runner page for runner associated to multiple projects](https://gitlab.com/gitlab-org/gitlab/-/commit/86352bb9d10bac147f28a08f88e9f10bbf5a8215) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198737))
- [Do not fetch manual variables for GenericCommitStatus or Bridges](https://gitlab.com/gitlab-org/gitlab/-/commit/fde7413e86bd097a71513f1e5514c1ffe75e97aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198151))
- [Fix boolean fields in Group-level Variables API](https://gitlab.com/gitlab-org/gitlab/-/commit/e19342ec14e8ad3d9a1cd60d4c265ad251d544fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198681))
- [Fix masked_and_hidden interpretation in Group-level variables API](https://gitlab.com/gitlab-org/gitlab/-/commit/7941a57cf6b8b5898d120b50f023cbb820f242b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198681))
- [Fix data race between Send and CloseSend operations](https://gitlab.com/gitlab-org/gitlab/-/commit/074c2e3f2f07c8ef2a1389fc2dddb2c0294f4f17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198593))
- [Don't check permission when creating project labels during transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/28e6f443e4a3b5dd796f2f87b2e92dc594400305) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198492))
- [Fixes fetching branch option](https://gitlab.com/gitlab-org/gitlab/-/commit/37c000ecdae624dee7fe0a293bc4407b572a3e2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198607)) **GitLab Enterprise Edition**
- [Restore `disabled` prop in `TagsList` component](https://gitlab.com/gitlab-org/gitlab/-/commit/9c59405b733b3fe759fae33b4e19c682bcc3151a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198576))
- [Fix CSV export mismatch when filtering by epic](https://gitlab.com/gitlab-org/gitlab/-/commit/a735cc2f415c828b124d30c1cf401a9884b891c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198414))
- [Increase the maximum allowed length for Namespace::Detail#description](https://gitlab.com/gitlab-org/gitlab/-/commit/378e5eb3013edf1229c1a87ec1dc174673e8fef4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198551))
- [Last commit: Fix verified badge alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/8b68fd04dae795d936ff47d766632ed2f0b4843f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198471))
- [Fix projects contributed tab to include personal projects](https://gitlab.com/gitlab-org/gitlab/-/commit/2acd1415138ea3e1f49dcf8e668a38fff2473049) by @ashu07das ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198287))
- [Fix S3 compatibility in Workhorse uploads for non-AWS S3 providers](https://gitlab.com/gitlab-org/gitlab/-/commit/5cc571e86e992e26cff61785e45381502f03920d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198371))
- [Fix counts.ci_runners_online metric](https://gitlab.com/gitlab-org/gitlab/-/commit/b6171ebb01733bee329698f05e4f74f87a172d81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198073))
- [Fix ArgumentError when upserting security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/6d1de4a4fd25c71a94f602545fbe040b0584107b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197970)) **GitLab Enterprise Edition**
- [Add cross project read permission check in search](https://gitlab.com/gitlab-org/gitlab/-/commit/5bed1a593839a742b9245145a2f1a955f8fc78f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197653)) **GitLab Enterprise Edition**
- [Make `Edit` path on Your work -> Groups a relative path](https://gitlab.com/gitlab-org/gitlab/-/commit/af57d6c28b2afb36b74659b526292653f9504a70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198325))
- [Add support for encoded absolute paths in file path validation](https://gitlab.com/gitlab-org/gitlab/-/commit/74035039ce720109afa9bf3377fbd6ea55b3f822) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196859))
- [Markdown editor: Zen mode double scrollbar fix](https://gitlab.com/gitlab-org/gitlab/-/commit/c4b0bc4bbf6a2bbebfc5ce3fa53c0f62d511cb3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198290))
- [Don't create policy violations for mismatching unenforceable rules](https://gitlab.com/gitlab-org/gitlab/-/commit/cc8f7a3c5789f5be467c5fb45fcdbb527879fd5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197162)) **GitLab Enterprise Edition**
- [Render Duo Agent Platform settings only for instance settings](https://gitlab.com/gitlab-org/gitlab/-/commit/2468d0bb27254943d04467d08fc4294376df140b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198251)) **GitLab Enterprise Edition**
- [Hide state in issue popover if request fails](https://gitlab.com/gitlab-org/gitlab/-/commit/543fcfde9396d23beef7035666dc592e4bef18ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198250))
- [Fix edit action button redirecting to 404 in "Your Work > Groups"](https://gitlab.com/gitlab-org/gitlab/-/commit/833821ef7f1dc6a1ab1ac5ff9c0598818e21949e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198237))
- [Align VSA duration charts' popover dates with x-axis dates](https://gitlab.com/gitlab-org/gitlab/-/commit/082b6e8bc0ce703f55ce2f5fdf3289c422cab1c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197973)) **GitLab Enterprise Edition**
- [Fix /unlink behaviour on Content Editor](https://gitlab.com/gitlab-org/gitlab/-/commit/d16277194edd57e7d3d90fa73d2c8dbfba29b515) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198165))
- [Only show draft status tag for draft MRs in list when FF is enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/c6a88c1162f96fa462407727d8778577ce5d0012) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198164))
- [Call sm_billable_role_change? upon billable users change for SM](https://gitlab.com/gitlab-org/gitlab/-/commit/e4a5ae8447976443c672922e3b1a6d81a6125715) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198145))
- [Fix inapplicable checkboxes in work items](https://gitlab.com/gitlab-org/gitlab/-/commit/18ef363d819e6fb8dd890cfd62251ae44d6ca68f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198147))
- [Fix /assign & /unassign behaviour on Content Editor](https://gitlab.com/gitlab-org/gitlab/-/commit/31172cf2bd0c02c1320af11e0813c10541ce8a2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198007))
- [Resolve project namespace in GlfMarkdown engine for FF check](https://gitlab.com/gitlab-org/gitlab/-/commit/a850c8c713c9b7d9148c386ebb156dbd42603810) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198133))
- [Prevent closing drawer when parent updates](https://gitlab.com/gitlab-org/gitlab/-/commit/e6fe4eb9cadbe617e6d58c2ebce03d65b2b5212b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198107))
- [Fix default selection for work items project selector](https://gitlab.com/gitlab-org/gitlab/-/commit/4187586196772cd3de00b094cb61762f4737ec09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198096))
- [Don't load admin groups from controller action](https://gitlab.com/gitlab-org/gitlab/-/commit/3d0c1731825fa552eadb02b299b742654a943063) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197699))
- [Fixed double message bug](https://gitlab.com/gitlab-org/gitlab/-/commit/85d99e5b0c5c401509652e757208b30371d26e5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197963)) **GitLab Enterprise Edition**
- [Make initials-only rails avatar component default to aria-hidden](https://gitlab.com/gitlab-org/gitlab/-/commit/e4a036ff93b0c240799fe033ee618f1990790202) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195855))
- [Fix user with custom role not being able to unassign project runner](https://gitlab.com/gitlab-org/gitlab/-/commit/e7bb4a0a087fefcf10f06ec7e11a7814acaa8cb7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196390)) **GitLab Enterprise Edition**
- [Set LtfC to 0 when deployment happens before merge](https://gitlab.com/gitlab-org/gitlab/-/commit/67864c8c1c0f7f7d502696e52a93209661d0ea32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197203)) **GitLab Enterprise Edition**
- [Fix running status indicator for narrow screen widths](https://gitlab.com/gitlab-org/gitlab/-/commit/c488849de737ed25b5b6601234430f9b1fefd19a) by @ericgpark ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197694))
- [Fix Bitbucket Server Importer enqueued job count](https://gitlab.com/gitlab-org/gitlab/-/commit/52ac4e912d5b5a3e1c2d9c0a390876f2a996642f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197510))
- [Fix flaky time-sensitive specs breaking CI](https://gitlab.com/gitlab-org/gitlab/-/commit/e013d0c6a2d1ab5fc86578cd363cb4bd3f0ca1fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197787))
- [Rendered markdown: Add aria-label to checkboxes if missing](https://gitlab.com/gitlab-org/gitlab/-/commit/27bbf1c010149349a9d3e84c8412b9b8e84239f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197661))
- [Hide group actions when deletion is in progress](https://gitlab.com/gitlab-org/gitlab/-/commit/dfcd2f957b6885aa1cc1e09cb51ab99ead5d627b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197248))
- [Fix internal note warnings on service desk issues](https://gitlab.com/gitlab-org/gitlab/-/commit/881fe3a191a0a316d40b92d61417c127d52e3a8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197422))
- [Fix Sidekiq strict args warning by using string keys in hash options](https://gitlab.com/gitlab-org/gitlab/-/commit/60de39edb6e285f757d7524ee5255b9626638972) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196660)) **GitLab Enterprise Edition**

### Changed (224 changes)

- [Add `none` to supported PURL types](https://gitlab.com/gitlab-org/gitlab/-/commit/bb07c9b583d677e884ec57009c8766d7a8b0ba79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199783))
- [Remove superfluous calls to access_token](https://gitlab.com/gitlab-org/gitlab/-/commit/ff449a89ae2ed62765544511a529fd6cd293e141) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201134)) **GitLab Enterprise Edition**
- [Clean up handover summary feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/becb7683d953a08ab73b167d83911462e4b7d50c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201595)) **GitLab Enterprise Edition**
- [Make file-based import respect group-level membership lock](https://gitlab.com/gitlab-org/gitlab/-/commit/81acb82cc9650f6de784d5d038f2077eccac8f07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201133)) **GitLab Enterprise Edition**
- [Sign Git Tags with SSH Keys](https://gitlab.com/gitlab-org/gitlab/-/commit/b06bae1c7e21481e2fe9e4870403e4106ae29796) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201444))
- [Update zoekt search parameter to use multi match when available](https://gitlab.com/gitlab-org/gitlab/-/commit/673f86bf4733414e322e937d9ca346ffcf395b25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201050)) **GitLab Enterprise Edition**
- [Remove grace period references from subscription expiration messaging](https://gitlab.com/gitlab-org/gitlab/-/commit/277c4a247d00da313bd89b4f9b0f4a0660002daf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200659)) **GitLab Enterprise Edition**
- [Update Merge request file tree placeholder text to align with Source Code file tree text](https://gitlab.com/gitlab-org/gitlab/-/commit/00a84b96f9b8a4ddb6514195e64ee67bb5d183bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201349))
- [Allow GLQL searching WorkItems index by various dates combinations](https://gitlab.com/gitlab-org/gitlab/-/commit/9f3304a9e1f7e5b56b2ff9c0c4cd2c90d11100e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200347))
- [Update whats new feature items](https://gitlab.com/gitlab-org/gitlab/-/commit/903cea3c1b504c2f315131e2209d16db90b03573) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199787))
- [Add feature flag to optionally index empty zoekt repos](https://gitlab.com/gitlab-org/gitlab/-/commit/edfe201b828ef208699b0605dbeea59ed082d73b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201141)) **GitLab Enterprise Edition**
- [Reindex zoekt repo when project visibility level changes](https://gitlab.com/gitlab-org/gitlab/-/commit/c3a5b1cd2e3b70b88ff9f401bdb45dc667fe67a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200853)) **GitLab Enterprise Edition**
- [Only show Duo Agent Platform settings on SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/5fa35c5b96c29ea58f9a720c4820126082a6aaee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200976)) **GitLab Enterprise Edition**
- [Add tooltip to FTB filter bar](https://gitlab.com/gitlab-org/gitlab/-/commit/c72c28188f800f751cb3bd329313f4ca0d83812a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201194))
- [Reindex zoekt repo when repo access level changes](https://gitlab.com/gitlab-org/gitlab/-/commit/a60685fb9aa55951d606c3d78b006b323d9550f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200851)) **GitLab Enterprise Edition**
- [Modify Duo solution](https://gitlab.com/gitlab-org/gitlab/-/commit/20d0e5abfb9e143a98b7e4076c5bb2aec611662b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199837))
- [Enable violations report feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1b9dbe5d975a8009c10a1be8bcc611e6a6692503) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201027)) **GitLab Enterprise Edition**
- [Update homepage data](https://gitlab.com/gitlab-org/gitlab/-/commit/682e40666ba96308211e70c2f73b81b9e30e93e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201335))
- [Enable feature flags for instance level's 18.3 release](https://gitlab.com/gitlab-org/gitlab/-/commit/3128bf83f54dda0d70fbfd916b2b0c050909587e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200629)) **GitLab Enterprise Edition**
- [Scope new/create project by Organization](https://gitlab.com/gitlab-org/gitlab/-/commit/3ccfd5177c39b62854d846c4c0b1a900300dd7e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198648))
- [Modify error messages for expiry date setting](https://gitlab.com/gitlab-org/gitlab/-/commit/bb42fe13052223e7167a581df0471cd06c70fdf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197703))
- [Add confirm variant to primary button](https://gitlab.com/gitlab-org/gitlab/-/commit/383135f4d9d6868a5d083f8a8a11e6a313327136) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201268)) **GitLab Enterprise Edition**
- [Remove hide_public_email_on_profile FF](https://gitlab.com/gitlab-org/gitlab/-/commit/b45afb4a47d4e1202ed845149f958bb055a46114) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201216))
- [Add context to work item creation drafts](https://gitlab.com/gitlab-org/gitlab/-/commit/44e65070a000836ed106b90300f599dde1a3a054) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200992))
- [feature: Remove scoped styles from agent flow logs](https://gitlab.com/gitlab-org/gitlab/-/commit/f6d87ed48bcad895f85bcca5e7ea4aca3dedca95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200400)) **GitLab Enterprise Edition**
- [Add support for additional Microsoft SAML email attribute name](https://gitlab.com/gitlab-org/gitlab/-/commit/c96b29a964ee9671c099a404c6a553c435c8c70e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201169))
- [Update branches header](https://gitlab.com/gitlab-org/gitlab/-/commit/388c5c3f6255a916a7d23c539198a13c2f9c2ee3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201021))
- [Check traversal id searchable on only ready zoekt repos](https://gitlab.com/gitlab-org/gitlab/-/commit/219b8eff2b1a5e31c5a1f277d53b5dca536aa291) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201120)) **GitLab Enterprise Edition**
- [Renaming Duo Workflow to Duo Agent Platform](https://gitlab.com/gitlab-org/gitlab/-/commit/024de8ba1aafacd10fd725b2107dc81539e40a53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201093))
- [Expose isGroupLevel field for BranchProtectionType](https://gitlab.com/gitlab-org/gitlab/-/commit/f0a20235941d996305ad69cab249bad61a0d4790) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200634)) **GitLab Enterprise Edition**
- [Remove feature flag and use terraform module presenter](https://gitlab.com/gitlab-org/gitlab/-/commit/c8a3caaf50fe4e43579b238285f3abd03990bf4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201011))
- [Remove a FF ci_aws_secrets_manager](https://gitlab.com/gitlab-org/gitlab/-/commit/1d09585b567d96f295747efbaf3ded5039b9e9c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200801))
- [Update details about oauth scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/f61020210317e6037704928320b0d25ec6f3cb3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200592))
- [Sync MR Widget with MR Dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/e2dd3995b91114108ad9eab2c1109284ead63596) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200563))
- [Allow flexible throughput adjustment for ActiveContext processing](https://gitlab.com/gitlab-org/gitlab/-/commit/dee0797702b3e6fbf4e5b1169c23e857f7d1b892) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199853)) **GitLab Enterprise Edition**
- [Add PROJECT_IDS to gitlab:git:fsck](https://gitlab.com/gitlab-org/gitlab/-/commit/b1c610b8ef7db313ce7dd5df89eb5a2665d6087a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197990))
- [Add event to track AWS Secrets Manager usage](https://gitlab.com/gitlab-org/gitlab/-/commit/05520c0ae9f52076be7b22bc039067f5c8cc2844) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200322)) **GitLab Enterprise Edition**
- [Geo Lists: UI Cleanup](https://gitlab.com/gitlab-org/gitlab/-/commit/4fcc586674b6132bb333ab632386d1556142b80a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200068)) **GitLab Enterprise Edition**
- [Reindex zoekt repo when project is archived](https://gitlab.com/gitlab-org/gitlab/-/commit/b717065cdaf43724b370a25606262bc727e08faa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200731)) **GitLab Enterprise Edition**
- [Add keyset pagination for project/issues endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/7c6addbdac0e02e22413dcfb00e0a59767ed191b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199887))
- [Real time updates for the job status](https://gitlab.com/gitlab-org/gitlab/-/commit/47b9fd61472fdd4b0e57f6fe9a126324f0b7c4f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200700))
- [Introduce container queries](https://gitlab.com/gitlab-org/gitlab/-/commit/0ecd4d3eadf3c50586a9b7e69952465e1c219c6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200217))
- [Add committer email column](https://gitlab.com/gitlab-org/gitlab/-/commit/cf8db902031f427553c3730d47222c34352ce4b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198688))
- [feat: Add Duo Agent Platform config file](https://gitlab.com/gitlab-org/gitlab/-/commit/70c758b39faa5a81b503c312cb94e66bf46ea529) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198747)) **GitLab Enterprise Edition**
- [Handle adding projects to CSP frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/baa56fe8e7e2d7ee5914acf6cb53df8b72bc0257) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200606)) **GitLab Enterprise Edition**
- [Cleanup pre_receive_secret_detection_enabled column](https://gitlab.com/gitlab-org/gitlab/-/commit/bd8cdecfd9dce3b910774789daeb11ec2c84a8fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189724))
- [Remove background color transition on glql table](https://gitlab.com/gitlab-org/gitlab/-/commit/99df88bd100ae937894ba138c966ed2855d64dcf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200726))
- [Handle non-csp framework vs csp frameworks in compliance dash](https://gitlab.com/gitlab-org/gitlab/-/commit/5703053b4c0f95e8d7aca419604757476e68059f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200309)) **GitLab Enterprise Edition**
- [Let keyboard users skip over RTE/MD formatting header](https://gitlab.com/gitlab-org/gitlab/-/commit/a557be2c19248b6de19bdbb787991b766809c3dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199969))
- [Migrate code-block-bubble-menu to gl-collapsible-list](https://gitlab.com/gitlab-org/gitlab/-/commit/8ff8345f8c713a33b0b217d68240952fbf883dc6) by @poojaghanghas479 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194129))
- [Make issue to mr use duo_workflow_in_ci ff](https://gitlab.com/gitlab-org/gitlab/-/commit/896ea6da6ffebdd8e4ce4d4f2c1be349b2c0529c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200538))
- [Update net-protocol to v0.2.2](https://gitlab.com/gitlab-org/gitlab/-/commit/f2dea9df048661ace4057473a70dadb22c3a3c33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200580))
- [Gate traversal id search behind minimum zoekt schema version](https://gitlab.com/gitlab-org/gitlab/-/commit/c6f292fed06ce811455b2bf3b4294be0a5380077) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200343)) **GitLab Enterprise Edition**
- [Create and use reusable Loading State Skeleton for Resource Lists](https://gitlab.com/gitlab-org/gitlab/-/commit/1941e7e09ec62f7978468f2b8bc45890020fdee9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196849))
- [Extend CS SBOM-based licenses to support id](https://gitlab.com/gitlab-org/gitlab/-/commit/1df33acee3946e84b21db9faa0c118837cb4311b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200685)) **GitLab Enterprise Edition**
- [Enable log-git-streaming-audit-events FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/87e65f01f6381d65ff1d3cadd6b7982972a55652) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200540))
- [Check root namespace of project framework for SAAS only](https://gitlab.com/gitlab-org/gitlab/-/commit/411e77d6ef3fee30956bcd58e27c3982d8c44b40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200432)) **GitLab Enterprise Edition**
- [Update Duo Agent Platform naming](https://gitlab.com/gitlab-org/gitlab/-/commit/c92b77d18cc8124a1d3582998a143d9b10d44b90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198322)) **GitLab Enterprise Edition**
- [Remove FF cloud_connector_new_token_path](https://gitlab.com/gitlab-org/gitlab/-/commit/b6fcc6c5caef6380aaa5375064746f787ebe3d7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200621)) **GitLab Enterprise Edition**
- [Remove feature flag for npm packages existance check refactor](https://gitlab.com/gitlab-org/gitlab/-/commit/67306fe46736219d5c6dc39cac764e24be213c74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200619))
- [Remove feature flag for conan package revisions support](https://gitlab.com/gitlab-org/gitlab/-/commit/5f12a5791215701966aa2de40e91d2fa09b74f16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200617))
- [Handle de-designation cleanup of project settings](https://gitlab.com/gitlab-org/gitlab/-/commit/4693706b9f1d9b5b3eb69934213a95adbcadf89f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199528)) **GitLab Enterprise Edition**
- [Add additional coverage for organization_csp_namespace method](https://gitlab.com/gitlab-org/gitlab/-/commit/57ef7e0f020281d3cf2af9de10ff886302904588) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200578)) **GitLab Enterprise Edition**
- [Add path to vulnerable_package_type](https://gitlab.com/gitlab-org/gitlab/-/commit/5eb4fb28a51acd3d936840e4f3fd9998f40275d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200559)) **GitLab Enterprise Edition**
- [Remove process_commit_worker_sticky feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/137297848c7054d9e631eeddd9ace3c14871bc59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200562))
- [MR review drawer: Improve UI](https://gitlab.com/gitlab-org/gitlab/-/commit/fe220402098b5a0a0b59ab29f0adc51f9125a27a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199085))
- [Add cleanup_stuck_agent_platform_session event](https://gitlab.com/gitlab-org/gitlab/-/commit/0029c21fab218d2393067dca247f4b19929297c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199917)) **GitLab Enterprise Edition**
- [Add repository shard size calculation to rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/2fa6ee78ea23cf472c07083a1f1ed5a0fe7c4b8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199334)) **GitLab Enterprise Edition**
- [Remove markdown h1 and h2 bottom borders](https://gitlab.com/gitlab-org/gitlab/-/commit/99cdb0e2f73aeb75716afe15fb5e18e7fb171553) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200386))
- [Add migration to delete orphaned security policy bot users](https://gitlab.com/gitlab-org/gitlab/-/commit/f0447eaadff29d4893b6dc8badaf55fffd92910d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199125))
- [Document the importance of `cut_off_date`](https://gitlab.com/gitlab-org/gitlab/-/commit/70b8482fff3262b9202732cc117964eb21479bca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200447)) **GitLab Enterprise Edition**
- [Add structured event tracking to pin and unpin of navigation items](https://gitlab.com/gitlab-org/gitlab/-/commit/eebcf6ca176dd61ad8503f673332e1a8ae1252c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199829))
- [Truncate job name at 2 lines](https://gitlab.com/gitlab-org/gitlab/-/commit/67e6c6046cd797ea2f94d638d415da9cdc4e24a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200348))
- [Disable variable_viewed_api audit event save to database](https://gitlab.com/gitlab-org/gitlab/-/commit/bc54d1dfdc02ae5233ece68475fb9d8ed17d5b2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200323)) **GitLab Enterprise Edition**
- [Remove feature flag reachability_es_filter](https://gitlab.com/gitlab-org/gitlab/-/commit/de6623843117d6f3077f48e6fdc79b1f4d86c276) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199835)) **GitLab Enterprise Edition**
- [Move similar items into collapsed crud component](https://gitlab.com/gitlab-org/gitlab/-/commit/8cb4a74df16888b214f58f4dca831094e1af0c26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199333))
- [Update pg gem to v1.6.1](https://gitlab.com/gitlab-org/gitlab/-/commit/a0bc797408b5eb54f5a5ecde66844db69e08fa7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200291))
- [Allow policy sync to accommodate compliance frameworks from CSP](https://gitlab.com/gitlab-org/gitlab/-/commit/72540d6bf07033e27704341223a9f90bf92aa713) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200183)) **GitLab Enterprise Edition**
- [Delete project settings when a CSP framework is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/bb0113d73a300a08e9d28519ee93a1d84468aa9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199221)) **GitLab Enterprise Edition**
- [Add AI workflow scope to vulnerability revert type](https://gitlab.com/gitlab-org/gitlab/-/commit/33946dee63280adcc748bd4447e11751df1aaea8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199408)) **GitLab Enterprise Edition**
- [Update zoekt cache to use project id and group id in scope](https://gitlab.com/gitlab-org/gitlab/-/commit/659218463d4589919888e34449f13cf6203413b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200243)) **GitLab Enterprise Edition**
- [Super sidebar navigation UI refinements](https://gitlab.com/gitlab-org/gitlab/-/commit/399cc07a9a9bf182882156eb0af936f707bb0690) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190699))
- [Delete customizable_dashboards feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/57ad2ff9fa42d85754fc86222ef3d9a00314677b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199438))
- [Schedule removing health status index](https://gitlab.com/gitlab-org/gitlab/-/commit/32fd44fef7977162d7cca453d4b7d73df684d611) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200195))
- [Migrate Admin Projects Dashboard to Vue-based dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/75b49ab14722f2883accb7c00f1493e53d7e0bb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199523))
- [Allow assignment of CSP frameworks to projects](https://gitlab.com/gitlab-org/gitlab/-/commit/1ae59d91ef855af31051733e4f1ef1c81ae9206d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198430)) **GitLab Enterprise Edition**
- [Clean up FF for security policy approval rule creation](https://gitlab.com/gitlab-org/gitlab/-/commit/3630086408dc6c9c294d04deff2e6c57e68986f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200173)) **GitLab Enterprise Edition**
- [Fix case sensitivity in CODEOWNERS validation](https://gitlab.com/gitlab-org/gitlab/-/commit/94dd26fbff69faa45dc26b8bb36721e688467938) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200043)) **GitLab Enterprise Edition**
- [Default new users to rich text editor preference](https://gitlab.com/gitlab-org/gitlab/-/commit/ef167535b518f79c29a5ff1213ad52d90a2daa1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194762))
- [Update single violation details](https://gitlab.com/gitlab-org/gitlab/-/commit/d49441e09b4d506da05ea9471b33bef1e33a88ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199694)) **GitLab Enterprise Edition**
- [Allow max file results to be zoekt count limit](https://gitlab.com/gitlab-org/gitlab/-/commit/5b26b424b461927344aafce795dfa306199462af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200103)) **GitLab Enterprise Edition**
- [Add custom matchers for scopes on graphql fields](https://gitlab.com/gitlab-org/gitlab/-/commit/8336e5e235c3804ce7ec10be8d9a0f4ff493f161) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199322))
- [Default directory_code_dropdown_updates](https://gitlab.com/gitlab-org/gitlab/-/commit/08d9bfe28d850833371b4e8ec509418c99629507) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200061))
- [Remove security policy violation audit event feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/afb72eb5c3a57d33da4a2074c630fd95a64a2489) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200050)) **GitLab Enterprise Edition**
- [Add context to zoekt AST queries](https://gitlab.com/gitlab-org/gitlab/-/commit/e8f2d10300a71f19819045380a3b074f0f6f61a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199933)) **GitLab Enterprise Edition**
- [Remove `merge_request_approval_policies_inapplicable_rule_evaluation` FF](https://gitlab.com/gitlab-org/gitlab/-/commit/538d02395acf388e0820d90544255a1321893c86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200027)) **GitLab Enterprise Edition**
- [Drop NULL constraint on vulnerability_occurrences.raw_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/57308d34b1042fc62b1aaa952034552b9e9e4f89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199468))
- [Add multi-threaded conversation support to Duo Agentic Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/4c15474ce48cc0f2bb28c086f3a8677ad52b0ae9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198948)) **GitLab Enterprise Edition**
- [Finalize migration BackfillHasVulnerabilityResolutionCwe78Cwe89](https://gitlab.com/gitlab-org/gitlab/-/commit/3ee841162d7d523c7750002ba2ead232aded0db3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193408))
- [Use named chunks in Webpack to ensure deterministic assets generation](https://gitlab.com/gitlab-org/gitlab/-/commit/0e5cfd3a208b4da2fab0770da8f1f3a40e386f30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199992))
- [Update authentication audit event to use Auditor](https://gitlab.com/gitlab-org/gitlab/-/commit/38c8fc0993dbd80cdb9729391603b5d9bff45470) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198216)) **GitLab Enterprise Edition**
- [Add faster SHA512 token hashing for Doorkeeper](https://gitlab.com/gitlab-org/gitlab/-/commit/5bf46987e55b6cc4f577d6f631fa11efb64b6043) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198910))
- [Requeue Backfill*RedirectRoutesNamespaceId BBMs](https://gitlab.com/gitlab-org/gitlab/-/commit/e2739673e8cab3613b211746a2887c45760f308e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199189))
- [Agent Flows - Update graphql for get_agent_flows](https://gitlab.com/gitlab-org/gitlab/-/commit/a5c39db66552e535511791bcedc1dbcda6c2922d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199818)) **GitLab Enterprise Edition**
- [Add workflow scope to BulkSeverityOverride types](https://gitlab.com/gitlab-org/gitlab/-/commit/6884296be5ac1718f8b63b3fe4ecde62241823fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199318)) **GitLab Enterprise Edition**
- [Add sticky header for work item drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/4aab6aa2829b807a4ec7c2f2c7ebb2ea23aabfe1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199820))
- [Remove feature flag for composer packages finder refactor](https://gitlab.com/gitlab-org/gitlab/-/commit/5ffafe5eb03e870df15bf5cb45238f0552d8d5f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199874))
- [Optimize #has_tags? for container repository](https://gitlab.com/gitlab-org/gitlab/-/commit/9660d23a077d2abd78ac036f48a469f43903f1ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199944))
- [Include CSP frameworks in policy validation check](https://gitlab.com/gitlab-org/gitlab/-/commit/facb1a1e3141dea60e498aa8b6545bb6d8d03c9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199394)) **GitLab Enterprise Edition**
- [Hides banner during experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/0f5950818aa09289c4e81f98932b6f56dfed6edd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198154)) **GitLab Enterprise Edition**
- [Persist homepage activity feed filters](https://gitlab.com/gitlab-org/gitlab/-/commit/73b715f8646fb9df4b7e1359742cd49bdf2cba17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199784))
- [Search repo ids via project ids in zoekt metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/8f3bb3b7e57f9c57cf5b33f22da43600d9bd3aa1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199439)) **GitLab Enterprise Edition**
- [Use table data for trend line in AI impact dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/57a8a4075600eea8dac3f95209f15f6e449322b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198799)) **GitLab Enterprise Edition**
- [Replace tooltip with a popover](https://gitlab.com/gitlab-org/gitlab/-/commit/1a201ba4aeb71edfe69280a0e9dbd5aed4dede62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199496)) **GitLab Enterprise Edition**
- [Filter to only active memberships in Members::DestroyedWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/fd54773426d17c7a2d8ee8e73507813444996772) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199020)) **GitLab Enterprise Edition**
- [Enable analyzer_status_update_worker_lock by default](https://gitlab.com/gitlab-org/gitlab/-/commit/46f4048a0fc92e5bfbc89d9f14cfae58fde29498) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199724)) **GitLab Enterprise Edition**
- [Add ability to skip zoekt JWT token expirations](https://gitlab.com/gitlab-org/gitlab/-/commit/6feea32e8795984d0b67aca30e401c8fcd363cdd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199330)) **GitLab Enterprise Edition**
- [Improve registry bulk-deletion to consider unselectable items](https://gitlab.com/gitlab-org/gitlab/-/commit/9656a5551df86f8c34a0249c068b6fa4c72fd286) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198667))
- [Update Security Dashboard Filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/7521674e67b2c5e5bb90def5f7ecac926aedfbdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198101)) **GitLab Enterprise Edition**
- [Change kind icon](https://gitlab.com/gitlab-org/gitlab/-/commit/b7c4d92f2923117324eadf66bdbe6ad5708b6962) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199593))
- [Refine file browser shortcuts](https://gitlab.com/gitlab-org/gitlab/-/commit/584db59d62691afe1c6b612ff6de975fde1ad416) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199595))
- [GitLab Duo project settings unboxing](https://gitlab.com/gitlab-org/gitlab/-/commit/503b8c217056cae36f5c3d9309b51e3d54eb84db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199548))
- [Limit parent options to open items](https://gitlab.com/gitlab-org/gitlab/-/commit/92948b6e7b1c2efd2bfd87a0e6a5b4746ce8bf6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198798))
- [Remove `geo_replicables_filtered_list_view` FF](https://gitlab.com/gitlab-org/gitlab/-/commit/a96e2dc1de73ca799bca891135968ec85208439c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199487)) **GitLab Enterprise Edition**
- [Ensure zoekt traversal id search uses prefix search](https://gitlab.com/gitlab-org/gitlab/-/commit/cad37dd0fefb854892b89420cc3fe8d8b0dd8354) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199450)) **GitLab Enterprise Edition**
- [Update tracking event](https://gitlab.com/gitlab-org/gitlab/-/commit/55a2d6daac2eceb856dbc6a50a7694b5fdcb4f5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198961))
- [Update gitlab-security_report_schemas to v0.1.3.min15.0.0.max15.2.3](https://gitlab.com/gitlab-org/gitlab/-/commit/07cec04d1beee144fb4f9356123fd54738c67db0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198359))
- [Add public_email filter to GET /users API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/68d639f5ec377173442a87af82227ad0377cc0e9) by @PatrickRice ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196748))
- [Milestone popover: Increase min width](https://gitlab.com/gitlab-org/gitlab/-/commit/d8773be4e622751e3343041e7883a53f4d8b8230) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199431))
- [Add namespace_id to compliance frameworks graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/2550874b5bb766c3234fcc90d8b44b9bd1f587be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199199)) **GitLab Enterprise Edition**
- [Remove Gitlab-Agentk-Api-Request header](https://gitlab.com/gitlab-org/gitlab/-/commit/f920db67598e1211180d4581b37e134cc5956589) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199392))
- [Show the CSP Group's frameworks for a top-level group](https://gitlab.com/gitlab-org/gitlab/-/commit/5f14e13788bca7e57fe1935dce77241c5e461047) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198195)) **GitLab Enterprise Edition**
- [Add traversal ids query for zoekt searches](https://gitlab.com/gitlab-org/gitlab/-/commit/4b93732b3724186cb7e2338efa462a3c956717f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195676)) **GitLab Enterprise Edition**
- [Optimize has tags to only check for one tag](https://gitlab.com/gitlab-org/gitlab/-/commit/061f5df0f86144a19bf965c3714cfde5cbbb3efb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198376))
- [Make new issue form buttons sticky](https://gitlab.com/gitlab-org/gitlab/-/commit/f62bbe3a33fe4aa35d115643dc321a5d6535492e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198803))
- [Work item create issue modal change resize position to right](https://gitlab.com/gitlab-org/gitlab/-/commit/3c6444885c4acd92ee4876880977a05383d75053) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199298))
- [Remove transaction from Sbom::BuildDependencyGraph](https://gitlab.com/gitlab-org/gitlab/-/commit/6bc9c0ce9a7d07e1570244753fd261a7427ef62d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198743)) **GitLab Enterprise Edition**
- [Hide token selector](https://gitlab.com/gitlab-org/gitlab/-/commit/7c5c571d29ffc33b2efb36f4aacdda378bd95ebe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198925)) **GitLab Enterprise Edition**
- [Add committer email column to ssh_signatures table](https://gitlab.com/gitlab-org/gitlab/-/commit/8a291a3c8ef56cf99fc299eb5b21f3898d7b3212) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198688))
- [Enhance accessibility in content editor and suggestions dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/165cc22532c01ee1acf32d1057e20fa1147c6ac5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193029))
- [Migrates .block-truncated to .gl-truncate](https://gitlab.com/gitlab-org/gitlab/-/commit/106cbca033a57ea34c487e4e36b0b53f3f0143e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199236))
- [Log SAML session_expires_at (SessionNotOnOrAfter)](https://gitlab.com/gitlab-org/gitlab/-/commit/571c19e28211fc20df2bdcc90489e7248014c2fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199173))
- [Allow GLQL filtering work items by health status](https://gitlab.com/gitlab-org/gitlab/-/commit/1f2ed53adf4573600d061923767be1e798677fae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198266))
- [Adjust deletion protection to 30 days for new self-managed installs](https://gitlab.com/gitlab-org/gitlab/-/commit/9b1f4994a242c5bf5e8e7ebd87080cf080bc345a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198561))
- [Allow GLQL searching work items by its type](https://gitlab.com/gitlab-org/gitlab/-/commit/eccbe0e44229160847860dc65b5e3ef5ef62c186) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195124))
- [Re-introduce reindex work item search migration](https://gitlab.com/gitlab-org/gitlab/-/commit/e6b8f5ad2443198f9849d4ca72925793f70a5a0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198706)) **GitLab Enterprise Edition**
- [Add 'Control Statuses' to compliance requirement status export](https://gitlab.com/gitlab-org/gitlab/-/commit/b08b461ce07a1c97c621805c66334f136a236eee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190301)) **GitLab Enterprise Edition**
- [Update io-event gem to v1.12.0](https://gitlab.com/gitlab-org/gitlab/-/commit/89454b22ab125283571c20c23a05bc492e1e6306) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199027))
- [Filter jobs by kind](https://gitlab.com/gitlab-org/gitlab/-/commit/1a18ff7d52848c286480fcf5d17f0903161706a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198577))
- [Add SCIM identities to Group SAML SSO settings page](https://gitlab.com/gitlab-org/gitlab/-/commit/a00fcc05e8284d2577cb482b4fb85661ef826d3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193032)) **GitLab Enterprise Edition**
- [Scope new/create project by Organization](https://gitlab.com/gitlab-org/gitlab/-/commit/408b22663cebdec61150254e2467c95f8a644ab3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197425))
- [Work item assignees: Add username and assignee to tooltip](https://gitlab.com/gitlab-org/gitlab/-/commit/62ef424ee05ffa91d1f6206b10debae5ddf0ca53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198270))
- [Use specific package class where possible](https://gitlab.com/gitlab-org/gitlab/-/commit/ca0b9ac8638cab38a214e3c3e5b997a1e4e57eca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196562))
- [Enhance collation checker](https://gitlab.com/gitlab-org/gitlab/-/commit/c813f7af1a268612a1499db559d580011e33c8e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198071))
- [Add group_scim_identity to the members API](https://gitlab.com/gitlab-org/gitlab/-/commit/9328ad0601673b41d6c239dcb5c62311f888df4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195574)) **GitLab Enterprise Edition**
- [Set focus on title when modal opens](https://gitlab.com/gitlab-org/gitlab/-/commit/b397b7b4f0bec6923bf787cbfb15b0ae3d131a76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197776))
- [Work item drawer: Add title to drawer title and some bugfixes](https://gitlab.com/gitlab-org/gitlab/-/commit/645909e90c0516806c1a93fdc982253fde1ccf5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198264))
- [Delete offer_email_reset ff and "update email" at sign up functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/222ce75642f3961a360d4fde7b5fd0767ab11f9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197491))
- [maintenance: Update help text of branch rules](https://gitlab.com/gitlab-org/gitlab/-/commit/ecff4fba185f9aee3383b0ad2c2e0d5d96ede190) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198025))
- [Show "Session expired" when there are no groups and no source](https://gitlab.com/gitlab-org/gitlab/-/commit/a6d858c6116771b8d261325736dfbcd2da348a90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196363))
- [Handle MR pipelines against source branch in protected pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/707266af6fa4ecf4f3b0dcb20fe33947be8da2d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198754))
- [Merge all PushRule updates to CreateUpdateService](https://gitlab.com/gitlab-org/gitlab/-/commit/5d32019bef521e2c55d30dab2aa3f97f3c3ed5d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197149)) **GitLab Enterprise Edition**
- [Add metrics for source branch exceptions for approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/cddc09dd6feb52cddcff075c06ab945714108539) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197833)) **GitLab Enterprise Edition**
- [Handle Geo Secondary and Maintenance Mode separately](https://gitlab.com/gitlab-org/gitlab/-/commit/a7fc58ccfd6213e4df76cc8580bbcc46cae36fe6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195835)) **GitLab Enterprise Edition**
- [Update constraint on tag name pattern for tag rules](https://gitlab.com/gitlab-org/gitlab/-/commit/611cffaa1d26e8031f41cdaadc5205c477ff25ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197758))
- [Add a popover for embeded views](https://gitlab.com/gitlab-org/gitlab/-/commit/fe52b7ca22cf7023a39d4664addcc2473a83afe0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198332))
- [Fix protected variables access in protected MR pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/e93479030a2075b4d4903a39db68b9348b8ee62e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196304))
- [No-op SetApiRateLimitsToZero migration](https://gitlab.com/gitlab-org/gitlab/-/commit/559dd0a9a31d817c677edeebc511413082efb2f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198215))
- [Reorganize create work item form](https://gitlab.com/gitlab-org/gitlab/-/commit/8d8de25c943041750595356d1c3cefe8b11159ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197700))
- [Update health status in embedded views](https://gitlab.com/gitlab-org/gitlab/-/commit/cb9468a64c152566a6e9a4ebe14b4407a97f7fef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198315))
- [Allow Git streaming audit events in all offerings](https://gitlab.com/gitlab-org/gitlab/-/commit/fc63726817115dd70c6cadaf196c82378c59c1f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196300)) **GitLab Enterprise Edition**
- [Composer packages: delegate composer_json to metadatum](https://gitlab.com/gitlab-org/gitlab/-/commit/d1b2972d4302c5872f4bc5634e0466f62fe8909d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196396))
- [Improve code coverage of EE approval_merge_request_rule.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/1e45182690fcdf6e4c8be941ab1a30a82463d9fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198224)) **GitLab Enterprise Edition**
- [Support all Value stream dashboard metrics in the AI dashboard table](https://gitlab.com/gitlab-org/gitlab/-/commit/54a5690e4f2708f617d5bf0ab88a635d693d5a88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197984)) **GitLab Enterprise Edition**
- [Improve grade aggregation using severity-based ordering](https://gitlab.com/gitlab-org/gitlab/-/commit/be04f04ade3bbd66b28491125d8d1de8195c1dda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195842)) **GitLab Enterprise Edition**
- [Scope bypass_settings related audit events to security policy project](https://gitlab.com/gitlab-org/gitlab/-/commit/6b9182d632bcae982e8adbfb42f05c5294c33b1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198002)) **GitLab Enterprise Edition**
- [Add popover to squash before merge checkboxes](https://gitlab.com/gitlab-org/gitlab/-/commit/5b9c439fc5cd1fb768f26cefc68577d71c94185b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198313))
- [Filter out NULL values](https://gitlab.com/gitlab-org/gitlab/-/commit/7173759c19da569f3b505658a92099e573e15bae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198305))
- [Rename Duo Workflow to Agent Platform and add service account docs](https://gitlab.com/gitlab-org/gitlab/-/commit/68a68164a17f7357935c4f527519196027a51e49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198301)) **GitLab Enterprise Edition**
- [Refactor snippet visibility edit component and update related tests](https://gitlab.com/gitlab-org/gitlab/-/commit/66169dc679790cde77ab9adae0db90806b509707) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198271))
- [Change use_service_account to a feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ede225dc5129c9ff619ff229fa5de387d21b5e44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197140)) **GitLab Enterprise Edition**
- [Use mutation for Ci lint on validate](https://gitlab.com/gitlab-org/gitlab/-/commit/8681698bb285e2b0630ca6a2ced0d472cc8d1d7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197165))
- [User popover: Fix alignment of popovers](https://gitlab.com/gitlab-org/gitlab/-/commit/1ba8871aee3186c17612b0bff494a699859cce90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195907))
- [Remove beta from dark and auto color mode options](https://gitlab.com/gitlab-org/gitlab/-/commit/d0b339e8b5336a384a1aa4e7e46853aad74067e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197263))
- [Add backfill migration for add on assignment versions](https://gitlab.com/gitlab-org/gitlab/-/commit/f5872ac075a02fae614eedc67fffffda90617b8b) ([merge request](https://gitlab.com/foo/bar/-/merge_requests/123)) **GitLab Enterprise Edition**
- [Show code coverage diff for blocked pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/6b95ee394436f872929bca95e9023046a81d084c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198182))
- [Return early to avoid db queries checking for policy jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/d3e8dfa703fb0df668587ba5a832da4070dcd033) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197979)) **GitLab Enterprise Edition**
- [Increases default page size for discussion.notes field to 200](https://gitlab.com/gitlab-org/gitlab/-/commit/90517ef31eb3a2f66c7665bc1b815d9b65567270) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198156))
- [Work item title: Add check if title is over limit](https://gitlab.com/gitlab-org/gitlab/-/commit/74654f2a97f29e7de80ef35c878bd668efd3ad61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198139))
- [Allow GLQL searching work items index by weight](https://gitlab.com/gitlab-org/gitlab/-/commit/92793a7c1619d67c9340b56bd8c540f9ab4c386b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198103))
- [Add milestone state to work items index](https://gitlab.com/gitlab-org/gitlab/-/commit/218ca0e926ce693e7711f6ed94a0c5cedfdafac2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198100))
- [Show Draft MR status on a project page](https://gitlab.com/gitlab-org/gitlab/-/commit/e3e13743c19d713e754af317dc7fb49b62e314ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197317))
- [Remove `merge_request_approval_policies_target_branch_matching` FF](https://gitlab.com/gitlab-org/gitlab/-/commit/f30309cdf9edf8730b3fc6e5691d8ff8697298ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197806)) **GitLab Enterprise Edition**
- [Use modal creation form for "New issue" from global nav](https://gitlab.com/gitlab-org/gitlab/-/commit/fc4a322bb7bbbf5ac83287531f90e74d3fcf13b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196168))
- [Update Duo self-hosted URL routing](https://gitlab.com/gitlab-org/gitlab/-/commit/bd7fadc3bcaf66823918e5b519c2eadde214d9ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196937)) **GitLab Enterprise Edition**
- [Add a check in `RegistriesResolver#resolve`](https://gitlab.com/gitlab-org/gitlab/-/commit/98a57a40b98cc89044f4d9de1e656b299af8a798) by @rodrigofarii ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196608)) **GitLab Enterprise Edition**
- [Update tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/0d6882d74d017ce19b7a71984636815c2334f61e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197999))
- [Set CI/CD variable to masked by default](https://gitlab.com/gitlab-org/gitlab/-/commit/6c4c984234ce72d975ec6ed6fccaccb2a5b1934a) by @dcouture ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195494))
- [Remove job_token_policies_enabled setting](https://gitlab.com/gitlab-org/gitlab/-/commit/0c77dd91660deb371c93d8e4878c5fdc53abb0a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196966))
- [Update Duo Agent Session stage to build](https://gitlab.com/gitlab-org/gitlab/-/commit/d42d539dc38ae1d59c7c071897841265592b1de3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197936))
- [Update vulnerability dropdown title from "Tool" to "Report Type"](https://gitlab.com/gitlab-org/gitlab/-/commit/50d0977abe5db2c7baf2295a731cb7fa51a1ec8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197639)) **GitLab Enterprise Edition**
- [Add featured updates section](https://gitlab.com/gitlab-org/gitlab/-/commit/c76147168c6eb32064b64ba68e97d8a7836c7933) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196883)) **GitLab Enterprise Edition**
- [New issue work item: Move contribution guidelines message](https://gitlab.com/gitlab-org/gitlab/-/commit/2d3f51511ec180abf56a8c80eed6b2d4b50fa110) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197775))
- [Introduce a new logger/log file for ActiveContext](https://gitlab.com/gitlab-org/gitlab/-/commit/ec60a976cc5ee4af0daf47799af4725e4a6622fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197897))
- [Scope project participants by organization](https://gitlab.com/gitlab-org/gitlab/-/commit/071897ac21149be67f5a147079c0e44b953fafa9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196928))
- [Improve test coverage group_group_like.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/c1ae248595658704d7fb6bbb3518cf185358b8c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197882))
- [Add check for licensed feature in ability](https://gitlab.com/gitlab-org/gitlab/-/commit/1c877d72a117e1901837db37fd27e244f75c64c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197551)) **GitLab Enterprise Edition**
- [Improve test coverage of approval_rule_like.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/400d80eea5508bc75802d40f4f46301784676143) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197748)) **GitLab Enterprise Edition**
- [Move Your work -> Groups to shared Vue components](https://gitlab.com/gitlab-org/gitlab/-/commit/b52e506cc201118654c2adc4d862520ab20bd3de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197711))
- [Increase polling time](https://gitlab.com/gitlab-org/gitlab/-/commit/e7dd1a26574f1fb0e900309cee0b10ef5db4094f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197845))
- [Maintenace: Remove filter_blob_path feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/41249510eef678320efcc83805a23ed5a6bfd8ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197211))
- [Update order of description and status in graphql docs](https://gitlab.com/gitlab-org/gitlab/-/commit/fc3658d6ebf7954649cf22065707cdc90df71b45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197782))
- [Enable `duo_rca_usage_rate` by default](https://gitlab.com/gitlab-org/gitlab/-/commit/8c3aab4441b69ee5450b4899b236b7d5a91985da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197818)) **GitLab Enterprise Edition**
- [Allow cross-project SPP access for PEP without checking token scope](https://gitlab.com/gitlab-org/gitlab/-/commit/1f6cada51872ceb61c9b630a801d21d2e621d9c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197820)) **GitLab Enterprise Edition**
- [Skip archived projects](https://gitlab.com/gitlab-org/gitlab/-/commit/4eea457373dbde7caee0607d441c501005330f4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195638))
- [Preserve workflowID when canceling duo agentic chat](https://gitlab.com/gitlab-org/gitlab/-/commit/d066c97b1f2b1de456041286d159e0da44050f38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197632)) **GitLab Enterprise Edition**
- [Update vulnerability report type to show scanner and vendor](https://gitlab.com/gitlab-org/gitlab/-/commit/0211c25fbb2c55c276e05edc1f0ce77a77c149a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197670)) **GitLab Enterprise Edition**
- [Update dependency auto-build-image to v4.12.0](https://gitlab.com/gitlab-org/gitlab/-/commit/aea31f5f58173de3929f0fdf4da6b5cc03225102) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197774))
- [Remove the allow_anonymous_searches ff and mark migration as noop](https://gitlab.com/gitlab-org/gitlab/-/commit/85200b038804fb5762dac937764bc6a3cca707a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197759))
- [Update the description of security policy project graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/c8a9d78c1cd9be08dc4e251f487a123b064db4e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197746)) **GitLab Enterprise Edition**
- [Show Create Work Item sidebar widgets based on user permission](https://gitlab.com/gitlab-org/gitlab/-/commit/b31cf505d59e25912b31b6c2f5f60b14e64b52c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195682))
- [Simplify work item retrieval in epics controller](https://gitlab.com/gitlab-org/gitlab/-/commit/e41b74f06711b57a6a7a8c781e5e5ab89dd2d491) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197658)) **GitLab Enterprise Edition**
- [Remove Duo Custom Rules Feature Flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e5c78a0bc2f7bd9f71ae2c169d52eebd50916a32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197634)) **GitLab Enterprise Edition**
- [Deduplicate label token results](https://gitlab.com/gitlab-org/gitlab/-/commit/7892a263f12f4e8b8ec2ad84a1ff709beaa8d590) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195997))

### Removed (36 changes)

- [Remove ff for generate_ref_commits](https://gitlab.com/gitlab-org/gitlab/-/commit/e5c447e517059f8dc51d005dc9b02b627d45f176) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201342))
- [Remove work_item_epics_ssot feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7e95837a42cb5bd62922cbe7267c8afb7aa9d76b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200829))
- [Remove optimistic locking FF for descendants cache](https://gitlab.com/gitlab-org/gitlab/-/commit/3726b9e18d40295211113d871e4aeeb432a07433) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201269))
- [Drop merge_requests trigram indexes for all instances](https://gitlab.com/gitlab-org/gitlab/-/commit/5eb6b89857318d821c1fbf09372524aa3e315cc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200932))
- [Remove FF_GLAS_ENABLE_PHP_SUPPORT feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/24c1a0f4a26637964747b61e379c5511bb18b6df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201339))
- [Delete the `issues_grid_view` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2ef47052b9bb94075682781c7c88ef1a961bdf90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200948))
- [Remove security_policies_bypass_options feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c7aec695f933f134403ebab4b76f9c13bd784533) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201094)) **GitLab Enterprise Edition**
- [Remove vulnerability_signatures_dedup_by_type feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c14a22add5bdb02cca361b8322ca49a438f6ffb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200394)) **GitLab Enterprise Edition**
- [Remove issue indexes concurrently](https://gitlab.com/gitlab-org/gitlab/-/commit/e0900bb975ad3a0c69c312ac96da0525bcf086c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200933))
- [Remove experimental `GET /groups/:id/users` API endpoint and accompanying code](https://gitlab.com/gitlab-org/gitlab/-/commit/eadc7422c288d3c77c65476f5d4d7635a4052836) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189638)) **GitLab Enterprise Edition**
- [Remove prevent_token_prefixed_password_fallback_sessionless FF](https://gitlab.com/gitlab-org/gitlab/-/commit/11ff5c38f34cdbe5897e30cd1dac3836b8e4d930) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199925))
- [Deleted feature flag from codebase](https://gitlab.com/gitlab-org/gitlab/-/commit/5724040ed434f012ab789dfc29256f99e9108658) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200627))
- [Schedule external_key index removal](https://gitlab.com/gitlab-org/gitlab/-/commit/0d4e5fbc5856b6f0a08972350848ded094263dcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200058))
- [Remove claude 4.0 feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/5477a0c21fc11557abc3fa995595da328d3aff10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198008)) **GitLab Enterprise Edition**
- [Remove ai_events_backfill_to_ch feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fe1d247beffe293770d6656065b86b98e9ba4197) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199877)) **GitLab Enterprise Edition**
- [Delete the `board_grouped_by_epic_performance` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0c76b05b88e79184efdb3d72d6d4ed96cceadc4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197604))
- [Remove restrict variables from CI/CD settings](https://gitlab.com/gitlab-org/gitlab/-/commit/ca5b4770cc59cae2f3543f47b863d1237cbc0409) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199142))
- [Bundle WI import / export with work_item_planning_view](https://gitlab.com/gitlab-org/gitlab/-/commit/c238af9e3733a584278b32934cf92587093fa13c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198447))
- [Remove the 'routable_pat' feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/36573efc4d2117b607d3105a154766351501f6ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199141))
- [Remove the 'rename_group_path_upon_deletion_scheduling' feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/10e4358925268a03d59b0872a1abb0bf498b99e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199140))
- [Remove the `policy_mergability_check` FF](https://gitlab.com/gitlab-org/gitlab/-/commit/0096bc0cd7e7f1238821f026aeb9b113880a3862) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198876)) **GitLab Enterprise Edition**
- [Delete the `track_epics_activity` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2381085896e171e8fa5c1cf2dde17c8a73bb9f89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198489))
- [Remove unused index_merge_requests_id_created_at_prepared_at and scope](https://gitlab.com/gitlab-org/gitlab/-/commit/9fef6af9626b37bb12ceeab77892db550e2fb271) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197599))
- [Remove unused organization_user_aliases table](https://gitlab.com/gitlab-org/gitlab/-/commit/80fdb2649841889278749be9046b7bfa9f303d48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194942))
- [Remove group hieararchy optimization FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5f61cf3c3e417d1e8235e98c3c9711aafaab356e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192975))
- [Drop title/description gin indexes from merge_requests](https://gitlab.com/gitlab-org/gitlab/-/commit/147edd6aa1ee864ec3c4f80300f19ccba23cf1df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198473))
- [Revert "Danger Finalize BBM Validator"](https://gitlab.com/gitlab-org/gitlab/-/commit/7077be40f707b0dc69b09ec1ec7bd5f3d5b5e21d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198565))
- [Delete the `usage_data_incident_management_incident_published` feature f](https://gitlab.com/gitlab-org/gitlab/-/commit/3677eb80ef39379b7302dcf2f8a66830ebbdd7fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198483))
- [Remove unused init_access_dropdown.js file](https://gitlab.com/gitlab-org/gitlab/-/commit/4d3c7985a02a229aafb1c6af13839725c4e22db1) by @ashu07das ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198374))
- [Remove generate_cube_query flag and feature](https://gitlab.com/gitlab-org/gitlab/-/commit/3baa6601e8e662ea842feea52782e945cceb2d4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196263))
- [Remove notes fields from work items index](https://gitlab.com/gitlab-org/gitlab/-/commit/d87768dba571a1f4f1249fe5d0d73e8199e173fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197065)) **GitLab Enterprise Edition**
- [Delete the `search_refactor_membership_filter` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9fae620a4f69634c8ee80cf3c067a435da5e78da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197683))
- [Remove slead CSS class](https://gitlab.com/gitlab-org/gitlab/-/commit/ad56768e5428a4778509b85aa4c9334f2eb3044c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197948))
- [Remove border-section CSS class](https://gitlab.com/gitlab-org/gitlab/-/commit/238b886ed4d0cdf7eb6275d3c4b5a33f00b794b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197769))
- [Remove append CSS classes](https://gitlab.com/gitlab-org/gitlab/-/commit/2ec0622c285488db409c8df3dd381708e91ddd8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197767))
- [Remove ignore rule for project_fingerprint column](https://gitlab.com/gitlab-org/gitlab/-/commit/dde6e5f47b7a1322c1c299e2ecb422d9f9dd75e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195070)) **GitLab Enterprise Edition**

### Security (19 changes)

- [Restrict namespace API billing fields based on user permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/1c5a2cb4697832885168d17a53c11bccc82b9532) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201016)) **GitLab Enterprise Edition**
- [Sanitize html for legacy simple blob viewer and code navigation nodes](https://gitlab.com/gitlab-org/gitlab/-/commit/8370acfaf1d203a7227765309492498c93806a52)
- [Remove the destroy issue permission from the planner role](https://gitlab.com/gitlab-org/gitlab/-/commit/7cef19c9fc5d3140c63721f63e42683868dd6f43)
- [Fix CI ID Token claims for forked project MR jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/7e9f329e8f6a33ffe3a63f8f64016d9b35b06a09)
- [More rigorous sanitization of placeholders](https://gitlab.com/gitlab-org/gitlab/-/commit/f96c1f0233f7a939f2e901a7d988a80d657c7115)
- [Release names are unbounded, leads to server crash](https://gitlab.com/gitlab-org/gitlab/-/commit/ad0760676fe8c18de286d609e9699a7245ed912f)
- [Prevent unauthorized maintainers from modifying runner records](https://gitlab.com/gitlab-org/gitlab/-/commit/4eb3695be9fdd75e020e9ac98f67ebff361b8664)
- [Change wiki_page_max_content_bytes default to 5 MB and in existing instances](https://gitlab.com/gitlab-org/gitlab/-/commit/597fbcc2baae7e932e85eac5c004de804837122c)
- [Only show titleHtml when valid](https://gitlab.com/gitlab-org/gitlab/-/commit/3ca4a93746a14dbb6e3d5a1bb7c0726fdddb83e0)
- [Block access to assigned issues when group has IP restriction](https://gitlab.com/gitlab-org/gitlab/-/commit/6a0b4ba092be75ad3752d183e242f2245a7b9b7b)
- [Prevent edits to MRAP approval rules](https://gitlab.com/gitlab-org/gitlab/-/commit/52e3fa2bb2dd193385f3aed594d3b40bd5315257)
- [Add length validations to ChatName model fields](https://gitlab.com/gitlab-org/gitlab/-/commit/160a209332f48df7aa28f0521d90470f1d2a6b22)
- [Restrict jobs artifacts API endpoint to token access](https://gitlab.com/gitlab-org/gitlab/-/commit/00958b62ac3057f8ca301b875cb3e9baf5e7b0dd)
- [Update GitLab Workspaces Proxy version](https://gitlab.com/gitlab-org/gitlab/-/commit/c6299c706176d54df37bdda629d57c8a612d78cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199422))
- [Restrict Service Desk email visibility to reporter+ role](https://gitlab.com/gitlab-org/gitlab/-/commit/3f9d9500a7e39dafc4ef05529f5eaacd08aece0e)
- [Prevent Duo Code Review from Showing Internal Notes](https://gitlab.com/gitlab-org/gitlab/-/commit/27082637f5a11b44d9eef9062cdd8873f6bb2e42) by @lesley-r
- [Add authorization to job field on deployment type](https://gitlab.com/gitlab-org/gitlab/-/commit/386b19160aef28d22c9ee2a69808d18d6be219e9)
- [Sensitive Information Disclosure via resource_group API Despite Repository and...](https://gitlab.com/gitlab-org/gitlab/-/commit/2abd91fa59379f838658cdb625d9596a803331ca)
- [Update GITLAB_KAS_VERSION to bring in "Disabling caching and nginx internal...](https://gitlab.com/gitlab-org/gitlab/-/commit/b0987d2440600720245d548b6d83b988bddc2448)

### Performance (10 changes)

- [Exclude deleted files from SPP payload](https://gitlab.com/gitlab-org/gitlab/-/commit/11a228355114ea2ddcbf314654020bc756c656ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200911))
- [Scope deployment lookup to project in DeploymentsController#show](https://gitlab.com/gitlab-org/gitlab/-/commit/5ab4585eeecb37ca7851a1f6ca45fa5596cb1078) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201053))
- [Refactor read build permission to be explicit](https://gitlab.com/gitlab-org/gitlab/-/commit/edac2e73b473fe82b9b3fa875b322b302f823024) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199552))
- [Adding a temporary project_id column for diff commits epic](https://gitlab.com/gitlab-org/gitlab/-/commit/a712032a3913ba6120326c502e361363ea213de5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197061))
- [Remove `deduplicate_process_commit_worker` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/64c487336aab226622d8db41cbb4c6b02cbd7dc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198888))
- [Refactor create/update/admin build permissions to be explicit](https://gitlab.com/gitlab-org/gitlab/-/commit/b52aaeb99a35ba100afada3f0b5ef26d82b0c5e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198936))
- [Adding a temporary project_id column for diff commits epic](https://gitlab.com/gitlab-org/gitlab/-/commit/fd6c89455e9d149796237b81be2b67642d240e56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196931))
- [Enable ci_enforce_throttle_pipeline_creation by default](https://gitlab.com/gitlab-org/gitlab/-/commit/7755bb3998360630208465db24f53feb87a92e2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196545))
- [Improve some queries in project list MRs API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/755de92f1fce5f4732234b14bd8a7f5372b6b090) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197105))
- [Enable caching for the ip_enforcement_prevents_access policy](https://gitlab.com/gitlab-org/gitlab/-/commit/4cb72209e2d14d9beae946f1a7b99d1e58417d22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197336)) **GitLab Enterprise Edition**

### Other (155 changes)

- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/ccd05294cf6d404851e587fd371ed7020ad0bf9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201756))
- [Use transaction callbacks for Vulnerabilities ES bookkeeping](https://gitlab.com/gitlab-org/gitlab/-/commit/55d406023384c4ae04789a933cb2ef563e561a62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199719)) **GitLab Enterprise Edition**
- [Add enhanced add code task to get started](https://gitlab.com/gitlab-org/gitlab/-/commit/9cca5db49737457222704f50592d4046c1a44930) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201020)) **GitLab Enterprise Edition**
- [Finalize BBM BackfillLicensesOutsideSpdxCatalogue](https://gitlab.com/gitlab-org/gitlab/-/commit/37ddf81a016293545a96e102d3a6e6dc4bb123c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201609))
- [Reschedule sent_notifications table backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/7aae8694a83514a7c10e2859b15fb5e2042f589a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201382))
- [Add organization_id to abuse_reports table](https://gitlab.com/gitlab-org/gitlab/-/commit/23525beae68594e1fbbe69ee596fea923ed1f95a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201276))
- [Sync translations from crowdin (2025-08-14)](https://gitlab.com/gitlab-org/gitlab/-/commit/6403b8ccc8c8519fc6313800ab2b2f5fa69c069c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201458))
- [Fix 1 rubocop violations for Layout/TrailingWhitespace](https://gitlab.com/gitlab-org/gitlab/-/commit/77ec45e5d1a589aae29894a201ae577336adff22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200151))
- [Re-enqueue backfill rolled up weights](https://gitlab.com/gitlab-org/gitlab/-/commit/6a0f0acf51571da79bb8a7a5c51376c7ab7765f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200713))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/570acfc5fb8395478dea0fd50dfe85134d8d5ba7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201224))
- [Add partitioned sent_notifications table](https://gitlab.com/gitlab-org/gitlab/-/commit/8e6e7bb91ca31d488eb65e4522f27cc864d4db00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201200))
- [Validate NOT NULL constraint on internal_ids sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/8600639c2696a401563e8a2fd5704eb2acb79204) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199806))
- [Step-up auth: Rename rejected? to failed? in step-up authentication flow](https://gitlab.com/gitlab-org/gitlab/-/commit/0e28ac0f4e8c0808700688e4da2bdb456d945713) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201328))
- [Add feature specs for group/project creation with active integration](https://gitlab.com/gitlab-org/gitlab/-/commit/23b3b1d643bbb4d8e388e9837a0a5fd33764a623) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201309))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1d57d5eda530977ec82ef6090b4d207fe39711bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201232))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/da46845a05192f022257bd9b698f4e5b5acee9b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201223))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f3321489ecd50b8637919c174cd25fc4452e9441) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201222))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/5a248317d4d3de2ba4210ac406739c57e6cf9026) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201220))
- [Run Storybook tests and accessibility checks in CI](https://gitlab.com/gitlab-org/gitlab/-/commit/50f7708aa104feba43df197c128370c81b80ed4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199550))
- [Check knowledge graph indexing FF on project](https://gitlab.com/gitlab-org/gitlab/-/commit/677af4db1b71a984f1e145a546bb9da9defa5dee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200860)) **GitLab Enterprise Edition**
- [Drop partitioned sent_notifications table by RANGE](https://gitlab.com/gitlab-org/gitlab/-/commit/92961029cba7db299f93ea824f4dae0ed2031cde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200871))
- [Fix 2 rubocop violations for InternalAffairs/RedundantExpectOffenseArgum](https://gitlab.com/gitlab-org/gitlab/-/commit/e0fc01280cd1f34215e24a78bc1f5a13f5afe066) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200145))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/d0078d2dd53a9ced12e0acdbbd5b7a071a46b999) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200963))
- [NOT NULL constraint for Epic Issues work_item_parent_link_id](https://gitlab.com/gitlab-org/gitlab/-/commit/03240780d78f81620c8ba97d47a98da80761c6b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197872)) **GitLab Enterprise Edition**
- [Labels sharding_key handles template labels](https://gitlab.com/gitlab-org/gitlab/-/commit/13f2cd78b67932403fe66f346ccbf0aeee628dd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198202))
- [Move web_based_commit_signing_enabled behind new feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3ff9cdcb8e4a8c112e916470504096625e86337b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200425)) **GitLab Enterprise Edition**
- [Deduplicate project_group_links records](https://gitlab.com/gitlab-org/gitlab/-/commit/9d2f68c9a7fec876e546748fbfa1278fbb391acc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191804))
- [Remove backend references](https://gitlab.com/gitlab-org/gitlab/-/commit/39bfc832bbd5491984038d293935bb67c1f9feac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200507))
- [Update db/docs schema](https://gitlab.com/gitlab-org/gitlab/-/commit/6504737dd324182f74452ece13299de23cac9198) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199951))
- [Remove current organization from session and FF](https://gitlab.com/gitlab-org/gitlab/-/commit/727a1a7931fe9dd70519b72a373b0d114b308e47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200076))
- [Switch sharding key to organization_id for users](https://gitlab.com/gitlab-org/gitlab/-/commit/49ac8936d65dcfc12a6ec175d94917d699a26b58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199473))
- [Mark 20250224195802 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/d68daabb9596d95fa261eb8a05833ea1fd6660e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198207)) **GitLab Enterprise Edition**
- [Added RunnerPolicyPreloader to prevent N+1](https://gitlab.com/gitlab-org/gitlab/-/commit/a9b551feef023ac73d8dfdaaafe442f5faac620e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197768))
- [Validate resource_state_events.namespace_id FK](https://gitlab.com/gitlab-org/gitlab/-/commit/9113eec224e5536036f8a1835e6bee77caaaaf3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200555))
- [Finalize backfill_approval_merge_request_rules_users_project_id BBM](https://gitlab.com/gitlab-org/gitlab/-/commit/42b03eaa8f28504153d1f5f1296fb23fdf2bd47b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197961))
- [Finalize BBM BackfillUpsertedCiBuildTraceMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/e7a49d1f9d3c54add7a701340f1f3b60da2a03d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198014))
- [Final sharding key steps for resource_iteration_events](https://gitlab.com/gitlab-org/gitlab/-/commit/678b3219c00e9ab3ed652dce51a6634fdbb5bea7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191825))
- [Ignore the column token in ci_runners](https://gitlab.com/gitlab-org/gitlab/-/commit/524fa3881632ef7e4be2f0e904651a6b0854dfa2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199904))
- [Sync translations from crowdin (2025-08-05)](https://gitlab.com/gitlab-org/gitlab/-/commit/eb3021021d2c5ec5d5360b9087537446755c8bda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200327))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/308555a01ec81eeecb480f255126d7fa48c2b3b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200116))
- [Add not null constraint to deploy token project_id and group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/12e0336a05cd088e144700a2ac93cbb9ef577025) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193245))
- [Upgrade to Vite 7](https://gitlab.com/gitlab-org/gitlab/-/commit/e771d9e446b7cc3cdfebec0d5b3938f9fc667b65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193581))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/975f20e420be14387da01fc6ad5fa846bb7bffd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200198))
- [Fix 20 rubocop violations for Lint/SymbolConversion](https://gitlab.com/gitlab-org/gitlab/-/commit/24ee101f066cf54d541143dbb0a653648ca32f62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200152))
- [Fix 13 rubocop violations for InternalAffairs/RedundantMessageArgument](https://gitlab.com/gitlab-org/gitlab/-/commit/239f18710aadbefb078bf6be9780d9c912aa6b6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200146))
- [Fix 7 rubocop violations for InternalAffairs/NodeMatcherDirective](https://gitlab.com/gitlab-org/gitlab/-/commit/59ac7fc24cf11c9159367ed82122444a4920cc41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200144))
- [Remove group_mention_access_check FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5c0c37ad9e2480ae1e24c3d5cc6acdc9a936fe20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200134))
- [refactor: Re-organize the delegates to namespace_settings from group](https://gitlab.com/gitlab-org/gitlab/-/commit/67e2e4e9fdc1fff08df19df608e3854a8d653d5a) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199928))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8eb4fe10b6883c7c18e4a501fcc1cdfacf475909) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200101))
- [Assign job definition to retried jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/bc239c2d27118ee66d77bf9f528864fadc874d9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200041))
- [Create job definition instances table](https://gitlab.com/gitlab-org/gitlab/-/commit/c09fb9ef2b040a8903bab9a86c5fc6f44858aaab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199292))
- [Clean up claude sonnet 3.7 feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/264a1e1c47d4c0b0b5aa36900cc2ad87931ef432) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199968)) **GitLab Enterprise Edition**
- [Finalize BBM UpdateSoftwareLicensePoliciesWithCustomLicenses](https://gitlab.com/gitlab-org/gitlab/-/commit/f70aaa88d5954b0485d9a04ba1b24f41c9597360) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197183))
- [Add Accept-Encoding identity header for file stream requests](https://gitlab.com/gitlab-org/gitlab/-/commit/64abce397daccd244a6a7a68a37ddf7f68f0ba42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199772))
- [Sync translations from crowdin (2025-07-31)](https://gitlab.com/gitlab-org/gitlab/-/commit/738230d17ebe0fc1da63be3143484d19ded928f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199743))
- [Fix 9 rubocop violations for Graphql/ResourceNotAvailableError](https://gitlab.com/gitlab-org/gitlab/-/commit/9706d78e059ae750bf64d7d1006cfc3b12853759) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193865))
- [Update sharding_key_issue_url for some integration tables](https://gitlab.com/gitlab-org/gitlab/-/commit/79312587d6d7037d77c7d7fe68c88787f5b3a0c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199902))
- [Create job definitions table](https://gitlab.com/gitlab-org/gitlab/-/commit/994a8f5597b2d94ca476152315684670e766a3e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199133))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/67bbff10addf72fd86a21b7bfad73250290ffb02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199843))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/034d89cf8f18051723b5d98558811573b344420e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198850))
- [Add NOT NULL to scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/be3018d1e619c814a954b42867ca5e317e21c30d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198173))
- [Remove deprecated compliance policy job instances](https://gitlab.com/gitlab-org/gitlab/-/commit/6e17f2c38dbbd291b0c4ddbff0b9dc37c75f9039) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199282)) **GitLab Enterprise Edition**
- [Enable duo_code_review_custom_instructions by default](https://gitlab.com/gitlab-org/gitlab/-/commit/d94f56d23ab723064a13a823366220b76809a754) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199802)) **GitLab Enterprise Edition**
- [Add NOT NULL to merge_request_context_commit_diff_files](https://gitlab.com/gitlab-org/gitlab/-/commit/52efdcd8d5668e04c1e374ebc4cc7938f3c73829) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197714))
- [Drop single parent constraint on resource_label_events](https://gitlab.com/gitlab-org/gitlab/-/commit/8b4a18b96a624b936fbc6bcb7d0a105b0ebc1bb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199519))
- [Backfill sharding key for clusters](https://gitlab.com/gitlab-org/gitlab/-/commit/b4c140f32c2beb5c869bc25a4275ccd7127b3003) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198431))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/f697853593d3ee4550204602d83376cbc216baf8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199418))
- [Mark 20250409103415 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/cba2847c756256b3f363d24cfc78e5c9ad5c018d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198213)) **GitLab Enterprise Edition**
- [Added fk validation for routes.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/637934eac58613e99cc8a9d21159ff071860e472) by @IP1102 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186351))
- [Sync translations from crowdin (2025-07-28)](https://gitlab.com/gitlab-org/gitlab/-/commit/3d7620d507fd96f5f6c39e4026cfecd3de678d5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199391))
- [Fix 20 rubocop violations for Layout/ArrayAlignment](https://gitlab.com/gitlab-org/gitlab/-/commit/ee1abde9846924c7accacc5d046d36fdc8219385) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198451))
- [Fix 20 rubocop violations for InternalAffairs/NodeMatcherDirective](https://gitlab.com/gitlab-org/gitlab/-/commit/40227bbdb8fd6c704fd52353d2002fa2244356b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199382))
- [Fix 16 rubocop violations for InternalAffairs/ExampleHeredocDelimiter](https://gitlab.com/gitlab-org/gitlab/-/commit/ff4ddb0e980cadb8e57e39021c302e72d2c5d7db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199381))
- [Remove enable_anthropic_prompt_caching feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0db39307737d30aa4e833e9b16f0cea9099f512a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197858))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f532d09f971eac07fe17da3c0b46ac8a729c3102) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198640))
- [Optimize application rate limiter Redis calls](https://gitlab.com/gitlab-org/gitlab/-/commit/014719d295972222d270551f2103f55c4a29f7c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199376))
- [Drop sharding_key_id check constraint on runner models](https://gitlab.com/gitlab-org/gitlab/-/commit/e50d455307b49283a02dfa742e9dcb5891022d5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199079))
- [Remove unused EE prop](https://gitlab.com/gitlab-org/gitlab/-/commit/8678d599fe71a34282707d2205cbc38ac459b634) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199272)) **GitLab Enterprise Edition**
- [Extract work item status icon color transformer to color utils](https://gitlab.com/gitlab-org/gitlab/-/commit/0c07b1b7c11c9a232c1fd6b754c99c093946c4f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199288)) **GitLab Enterprise Edition**
- [Finalize BackfillTerraformModulesMetadataWithSemver BBM](https://gitlab.com/gitlab-org/gitlab/-/commit/3d9d71178710ece95dee1aab36c3ea4a25d11321) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199290))
- [Add NOT NULL to merge_request_predictions](https://gitlab.com/gitlab-org/gitlab/-/commit/6714d086b1b035aa2dc6c3d438cf5546458db447) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197715))
- [Add Dependency paths metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/6b8fd055fa6155a763181ec12239e3dccca04783) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199068)) **GitLab Enterprise Edition**
- [Make text for entering URLs consistent: work items](https://gitlab.com/gitlab-org/gitlab/-/commit/5c10517cc69cabf9d2a6dbdb7d47daef8a4feb6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196812))
- [Add organization_id LFK to ci_runner_taggings](https://gitlab.com/gitlab-org/gitlab/-/commit/6366e41ea9f36abe36aa2f3dc95992ab8e184338) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198920))
- [Remove show_enable_duo_banner feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/88e9197ef1e34c4ce40a6e118e8c4923375b26c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198632)) **GitLab Enterprise Edition**
- [Finalize BBM BackfillSecurityFindingsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/77a16914828a305faa347819c08ddbb30181f692) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196947))
- [Update docs regarding cross_database_ignore_tables](https://gitlab.com/gitlab-org/gitlab/-/commit/f61989d0f05591c8a02532af8bf79a63edbdf540) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198960))
- [Expire from time of session creation - generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/12b1a7db15058cca1570eb8a75c570a160585576) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198734))
- [Sync translations from crowdin (2025-07-23)](https://gitlab.com/gitlab-org/gitlab/-/commit/442733c1155ea2bde52a7d1a6d907032525795c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198914))
- [Redesign OTP authenticator registration](https://gitlab.com/gitlab-org/gitlab/-/commit/b76319c230826a3818f4fe46624cd8628f580e28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198890))
- [Sync translations from crowdin (2025-07-23)](https://gitlab.com/gitlab-org/gitlab/-/commit/316241a86d52ef27f039ad2986339c45bfd49876) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198860))
- [Remove alert about introduction of branch rules editing](https://gitlab.com/gitlab-org/gitlab/-/commit/1fe05b02e2951374e5c3fcdc3e9d8292e3bc1a41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198772))
- [Mark 20250218133000 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/4e38a88f00a0c011919298c8d7fd8314981cc54c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198204)) **GitLab Enterprise Edition**
- [Fix RSpec/ClassStructure offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/00ae4acf732cb98e8430eeabee489fc7289e11c0) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198021))
- [Mark 20250408180015 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/2152c951d9ad7ae80a1ce89d0fc0aafd8da30736) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198212)) **GitLab Enterprise Edition**
- [Removing feature flag enable_standards_adherence_dashboard_v2](https://gitlab.com/gitlab-org/gitlab/-/commit/27a4384c5de2a2f5ae480d520be0c40051d93ccc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197744)) **GitLab Enterprise Edition**
- [Filter out invalid emails in pipeline email integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/fdac849b905e5b911317a91481b96f36456a6a4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197708))
- [Document job trace missing issue](https://gitlab.com/gitlab-org/gitlab/-/commit/b9d1c24ee0f84454db73cb905fdeefad6fe4c248) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197941))
- [Remove CI partitioning feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/403413aee23ed26d1dc5d4da49fc2bd03b3e0883) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198468))
- [Add security policies schema spec for bypass_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/bce06c6a24302e11c64d02bdc1c940394c3bbbc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198076)) **GitLab Enterprise Edition**
- [Finalize DeleteOrphanedCiRunnerMachineRecordsOnSelfManaged](https://gitlab.com/gitlab-org/gitlab/-/commit/4495af33c0595a5c32399cb4f80fe5f855827dd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198672))
- [Ignore sharding_key_id column on runner tables](https://gitlab.com/gitlab-org/gitlab/-/commit/1c333597beaccc1f8bc7da71a93714ee36b188c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197682))
- [Create dedicated table for storing CI environment options](https://gitlab.com/gitlab-org/gitlab/-/commit/3295b106fba46c5ac3801d48cbc76e3d0b4ef00e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192865))
- [Finalize and validate target_project_id FK + BBM](https://gitlab.com/gitlab-org/gitlab/-/commit/8f85a625ebbb4f8d787faa780cec44667a80e2d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181875))
- [Remove validate_lfs_object_access feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f845b541cf46d68bc2bb42cfaa81cf949a5aa9ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198623))
- [Mark 20250227113301 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/5c730e7510e7f8f3c328a0dae37f3d3e1fab0ebc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198209)) **GitLab Enterprise Edition**
- [Add NOT NULL to issue_assignees](https://gitlab.com/gitlab-org/gitlab/-/commit/021e07bb4770aa554a5f7fbd6cc9ffa7e59ff2cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197962))
- [Add approval_rules tracking event for approval policies](https://gitlab.com/gitlab-org/gitlab/-/commit/4b2f20c711ff59a5d29ecfab57de39a5dcdbc3ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198005)) **GitLab Enterprise Edition**
- [Add Cycle detection back to Sbom::PathFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/7d3c52cd6694f4909d75b0854aad2e25f64803ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198527)) **GitLab Enterprise Edition**
- [Finalize backfills of organization_id columns on runner tables](https://gitlab.com/gitlab-org/gitlab/-/commit/4dab4306134f828b0751b5079f96d08de6d920b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197600))
- [Mark 20250404170331 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/405bf9def816f47f788d13c1b34643861fd12ea9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198211)) **GitLab Enterprise Edition**
- [Mark 20250226135126 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/585b379be9bd11c59b52fde187edb6ec8cce4850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198208)) **GitLab Enterprise Edition**
- [Traverse sbom_graph_path records bottom up](https://gitlab.com/gitlab-org/gitlab/-/commit/8c07842a695bac58df91c5f4de45210c26ec682f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197274)) **GitLab Enterprise Edition**
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/96ff3b33d1915260ec36c46338fa5c26b9af54da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198513))
- [Remove geo_replicables_show_view feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/743ee06f318fdbc0b2c44dae1e8c25e059c6eda3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197803)) **GitLab Enterprise Edition**
- [Add organization_id check constraints to runner tables](https://gitlab.com/gitlab-org/gitlab/-/commit/e499a9a7d640fe1c4efe022da03c805176b70c1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197668))
- [Fix 20 rubocop violations for Layout/EmptyLineAfterMagicComment](https://gitlab.com/gitlab-org/gitlab/-/commit/21c8104a794ed751c49028fc7341ab082832255c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197579))
- [Fix 20 rubocop violations for InternalAffairs/NodeMatcherDirective](https://gitlab.com/gitlab-org/gitlab/-/commit/efaded3c2d16cb6b80b9dbe524c47a37627a970b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198450))
- [Fix 20 rubocop violations for InternalAffairs/ExampleHeredocDelimiter](https://gitlab.com/gitlab-org/gitlab/-/commit/85179efaf4094ae85d1a7f804047376372a8ab7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197576))
- [Add NOT NULL to bulk_import_failures](https://gitlab.com/gitlab-org/gitlab/-/commit/f9a4fd73c98cd0afba14e916d3f24324a9f72d03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198172))
- [Add sharding key columns to clusters table](https://gitlab.com/gitlab-org/gitlab/-/commit/b9ce72389dc0f4cca430b6ad00440b7b8b95ae56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198239))
- [Mark 20250220225059 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/9b9e0fc4b055968333a8d7f81713d48f7c5aacb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198206)) **GitLab Enterprise Edition**
- [Mark 20250220214819 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/f63e85d1dd19635348ed165f2ada53ce3f9084de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198205)) **GitLab Enterprise Edition**
- [Validate runner_id foreign key on ci_runner_machines](https://gitlab.com/gitlab-org/gitlab/-/commit/d8b3c031104fc3a4728bb98c47adbe677aa974d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197646))
- [Mark 20250311180329 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/614b59db4a332ae2d56cafc1f4ecb3630bbf69f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198210)) **GitLab Enterprise Edition**
- [Add migration for async validation of routes.namespace_id FK](https://gitlab.com/gitlab-org/gitlab/-/commit/e8f035881d2999e18af467aaee9b88d945880882) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198223))
- [Finalize BBM DeleteOrphanedRoutes](https://gitlab.com/gitlab-org/gitlab/-/commit/7147cd34d65372eec19af512bc2bd756775bd255) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198197))
- [Finalize BBM BackfillResourceIterationEventsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/74eb7a5690480a0ae48598412c4cbaa9a32484fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198196))
- [Finalize BBM BackfillSnippetRepositoriesSnippetOrganizationId](https://gitlab.com/gitlab-org/gitlab/-/commit/303476775c24b3d8d5dd2e7cf0959596e20fcf68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197400))
- [Add NOT NULL to approval_merge_request_rules_approved_approvers](https://gitlab.com/gitlab-org/gitlab/-/commit/7e52ac91cc59e7d3cc9bc3dbbc47421d96e3b605) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197383))
- [Finalize BBM BackfillApprovalPolicyRuleIds](https://gitlab.com/gitlab-org/gitlab/-/commit/add59c665ccb6f188a11983f2ae35435e6239f7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198012))
- [Remove duo_core_saas feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f8e95bdfcb81900b5bc221278f1c4d55ccb7e281) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198155))
- [Limit `define_variables` to `show` action in `Project/CiCdController`](https://gitlab.com/gitlab-org/gitlab/-/commit/9759b010bfe371406ad5c89762ce160a88fb5aa2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198144))
- [Finalize BBM CreateMissingNugetSymbolFiles](https://gitlab.com/gitlab-org/gitlab/-/commit/e4e03dfc15fb2133e0b008a4f2247f43c55aa2a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197720))
- [Update graphql gem](https://gitlab.com/gitlab-org/gitlab/-/commit/2837ad635c3dd66ff6386a3bfe94f8c5eefa527d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197472))
- [Finalize EncryptMissedCiRunnerToken bbm](https://gitlab.com/gitlab-org/gitlab/-/commit/8582aab40541b3db612337a4fc2efc705afc2b0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198049))
- [Finalize partitioned uploads back-fill](https://gitlab.com/gitlab-org/gitlab/-/commit/55b5578a0038d000b76ef36967b9e0bd764a001d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198033))
- [Finalize BBM SyncUnlinkedSecurityPolicyProjectLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/d64adeef8b77df129960ee69afa0597246e1836e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198011))
- [Finalize BBM ResyncApprovalPolicies](https://gitlab.com/gitlab-org/gitlab/-/commit/51c95f1e1271df2f9327924a0c6adfda48e78d3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197722))
- [Clean up importer_user_mapping flag](https://gitlab.com/gitlab-org/gitlab/-/commit/44b90ea38988a1b19e22eaa4d61ad664076853aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197465))
- [Stop using ci_builds_metadata.has_exposed_artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/b504e82f2ccba437cd189be36508c9e28ded526f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197704))
- [Add resource_label_events.namespace_id sync index](https://gitlab.com/gitlab-org/gitlab/-/commit/50695617751ce1ff3e2c25dca3a38871275980cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197983))
- [Backfill resource_label_events and clean invalid records](https://gitlab.com/gitlab-org/gitlab/-/commit/87b224b17accdc546adfcc642ac2ee2d755fc2f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197676))
- [Finalize BackfillSnippetStatisticsSnippetProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/734083808aadc236b0104bcb7ab5df867def7f06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196855))
- [Step-up Auth: StepUpAuthenticationFlow handle empty step-up auth session](https://gitlab.com/gitlab-org/gitlab/-/commit/f5daaee476bc0c2fd628a8be0b92db4029d1662c) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197900))
- [Remove sent_notifications.namespace_id index ASYNC](https://gitlab.com/gitlab-org/gitlab/-/commit/a491f6794f1eb76bb61386647ac1702825bd206b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197887))
- [Add NOT NULL to packages_debian_file_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/d43842ea34bd80187e2e2113f7969fea9c254e0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197212))
- [Stop explicitly deleting webhook logs](https://gitlab.com/gitlab-org/gitlab/-/commit/b75119e2b6ea775d9dfd45e766fd291439ac66f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197625))
- [Removing feature flag enable_stale_compliance_status_removal](https://gitlab.com/gitlab-org/gitlab/-/commit/4b3f8bce0cad5e6d8cd61f8d113970540efffe0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197741)) **GitLab Enterprise Edition**
- [Add NOT NULL to snippet_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/77526a49ffca44f55e4379e67e07a5524440a053) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197707))
- [Fix 16 rubocop violations for InternalAffairs/NodeTypePredicate](https://gitlab.com/gitlab-org/gitlab/-/commit/5617d6622c70137f5a422cb0a21f0a6e9ed7ed86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195243))
- [Fix 20 rubocop violations for InternalAffairs/NodeMatcherDirective](https://gitlab.com/gitlab-org/gitlab/-/commit/115783eb79e9cf89810db955bad1550542672c9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197577))
- [Finalize BBM BackfillScanResultPoliciesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/abfb77370cea034cfe41327535e6d7aa6445de0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197399))
- [Use proper vue frontend errors on company form](https://gitlab.com/gitlab-org/gitlab/-/commit/d04f737a5d4dbef68db29c73e37edf382b8cea79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194378)) **GitLab Enterprise Edition**
- [Remove ignore column from Users](https://gitlab.com/gitlab-org/gitlab/-/commit/ad08665571456b0e6d8d4f70f161a0980b6a4f80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197464))

## 18.2.8 (2025-10-08)

### Fixed (1 change)

- [Transfer start and due dates data upon work item move or clone](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ffa794edbc50ae509c9d2a9dcd6a3d30cf938de5)

### Security (4 changes)

- [Log JSON bytesize as well](https://gitlab.com/gitlab-org/security/gitlab/-/commit/99e5aeaddd439d66513cdf5710bc3fdb70df7cb4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5390))
- [Adjust complexity for blob data fields](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1fb1ff84697efa0abd38063207c7ec3905a9bfc2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5386))
- [Reject irrelevant 1xx responses](https://gitlab.com/gitlab-org/security/gitlab/-/commit/db84009946afba988a96aa6871d992ef3fcc02ed) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5303))
- [Restrict manual variables to explicit guests in internal projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/eaadf56f52b6533dd0d07e177a4df8d62d076d1b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5367))

## 18.2.7 (2025-09-25)

### Added (1 change)

- [Add target project claims to CI ID Tokens](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5dd1a33251ff65bf7e9951a00f7fa6d156cfa17d)

### Fixed (7 changes)

- [Optimize HandleMalformedStrings middleware for CPU and memory](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f738dfc3a780b22ea1a03911e1746f123fea3e03)
- [Exclude other report types from scan readiness check](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e3798968d9cbe9422d68ef35c094fcfb5b157f03) **GitLab Enterprise Edition**
- [Fix security widget polling indefinitely when there are sboms](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f0396a3c58481697e9939c02210e33fa1ab0f4c3) **GitLab Enterprise Edition**
- [Merge branch 'ngala/geo-secondary-deployment-filename' into 'master'](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b05f668d676ae3a253fab2e6a9ee910c4fdf21d3)
- [Backport comment suggestion line range fix to 18-2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7860283def2e88f5681f56f24ab38cb7b66231b8)
- [Fix the rendering when content is empty](https://gitlab.com/gitlab-org/security/gitlab/-/commit/de5a8fc41a8f6ee71ed9409c9b0cee9a704ae3da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202049))
- [Merge branch 'tchu-fix-forbidden-causing-save-errors-in-search-admin' into 'master'](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c1b259f987bda2512aa5b4e97df5f13e36f06bfd) **GitLab Enterprise Edition**

### Security (11 changes)

- [Increase JSON validation limits on NPM endpoints](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7a4ae3929eea14e5481fb24c416cf4864c913ee5) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5362))
- [Addresses logical bug in the GraphQL base resolver](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e0f469c9fb95b0a1260f5912d87423a31969d68f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5274))
- [Escape text for wrapNodes utility](https://gitlab.com/gitlab-org/security/gitlab/-/commit/24495b1b30347a4af4303c8462266dac22d7b10f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5308))
- [Add the rate limit in BlobSearch GraphQL](https://gitlab.com/gitlab-org/security/gitlab/-/commit/24938714fe99ac5e3f47b2c5a7d35c36c669f88c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5220))
- [Fix Identical Project Names via Move Issue Drop Down leads to Confusion](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ddf20d20cd34ea110afe42baedac79faa48b5055) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5259))
- [Prevent role assignment for custom roles in projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/afb3d9e6f0ff2e021ee0a31412e764e81c90c8f2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5339))
- [Only owners can invite groups](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1587f713029284cfb3686ca15de1a25614951649) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5233))
- [Add limit to array fields in WorkItems API](https://gitlab.com/gitlab-org/security/gitlab/-/commit/36a94015745c91d2c8da6a76a5f95dac8e28f155) by @afrnz ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5246))
- [Limit String => Integer conversions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bb7fe2763aa998310f4038845ad925f2f9b0efd8) by @afrnz ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5218))
- [Removes password field from maven upstream GraphQL type](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a2992dc98f2b61be6fda906b70d55d8fd44ced9a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5316))
- [Add JSON input streaming validator middleware](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bfb5c0c774a13ea24075d55e9ae941f29fa994de) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5351))

## 18.2.6 (2025-09-09)

### Added (1 change)

- [Add Compare link to submodule diffs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ae1c1e0c5a27ceddc5d1b14ab5c73c25a9624bf7)

### Fixed (5 changes)

- [Update gitlab-shell to v14.45.2 to allow ED25519 for FIPS](https://gitlab.com/gitlab-org/security/gitlab/-/commit/165c4e2f73a0ceef972c9266f1b289cd952ca31c)
- [Make FileLocationType.endLine nullable](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1c7f2bdd6364199ea31365f07579613588c2892c) **GitLab Enterprise Edition**
- [Preserve the exact string representation of the URI](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3240e03a283ab2d90a1d1dc168da0f952ef1dc00) **GitLab Enterprise Edition**
- [Fix shared group access for advanced code search](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d73ef815c69212ee97b7ae5adffd24efc2de2424) **GitLab Enterprise Edition**
- [Update gitlab-shell to v14.45.0](https://gitlab.com/gitlab-org/security/gitlab/-/commit/39c491d07bf756eca2769d728ff902d31570b0f6)

### Security (6 changes)

- [Introduce limit for closed issues](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3eb7690ee99be51187a85989005bcbb30e724e2b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5236))
- [Add file size limit for blob editing](https://gitlab.com/gitlab-org/security/gitlab/-/commit/77430a9aa9afea74e543b1a736c6d628d7f1b8df) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5297))
- [Fix DoS via large SAML Response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/14b82231074bcf66e96a9f05b1f7b5cfbaabd8ef) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5240))
- [Add limit to deploy token name](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a542fc2ae58af6f54db56beb247ce45536ca95d1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5300))
- [Fix webhook custom header validation](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7f80ed2fb18a32b87e265de9e559992531154e4e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5293))
- [Show runner maintenance note only to runner maintainers](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7df46119f30f9013bd08fda871c3a15db51f266a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5287))

## 18.2.5 (2025-08-26)

### Fixed (2 changes)

- [Ignore silent mode in clickhouse http calls](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ed59a658334df6d01362f6d23c08f5acd768ff8e)
- [Check Stage for self-managed](https://gitlab.com/gitlab-org/security/gitlab/-/commit/eb039f297e553de4847c97eff3c7c6f6f303fd7b) **GitLab Enterprise Edition**

### Security (4 changes)

- [Adjust snippet blob query complexity to mitigate potential DoS attack](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1e0eabbeda3d53a366689aefaad2691fb6e83789) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5232))
- [Gitea import rate limiting](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a9dd8d3b15f7b4b5a6c9775d9f72de2cf8fa36f3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5252))
- [Fix tag/branch ambiguity in raw file display](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f871b4ea8a988103c28423a99b7907fe1b36705a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5238))
- [Add authentication check for manual variables via new policy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1f5b9f623bcc43612fa07861a57d0901291be72c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5194))

## 18.2.4 (2025-08-18)

### Fixed (1 change)

- [Update gitlab-shell to v14.44.0](https://gitlab.com/gitlab-org/gitlab/-/commit/b68a4e61107e7317839d60ba2bd2ca9c75c2be4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201780))

## 18.2.3 (2025-08-18)

### Fixed (2 changes)

- [Merge branch 'bw-delegate-placeholder-check' into 'master'](https://gitlab.com/gitlab-org/gitlab/-/commit/c7370850eefb04eca86be0119b28fd85fe4b74b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201366))
- [Fix the reset of sidebar navigation](https://gitlab.com/gitlab-org/gitlab/-/commit/6908b7b9653109d202e13973da3f91a38f30b961) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/200234))

## 18.2.2 (2025-08-12)

### Added (1 change)

- [Add outbound allowlist to allowed endpoints for SSRF filter](https://gitlab.com/gitlab-org/security/gitlab/-/commit/23e2fe82bd5ccb84b739833ecd0092129c690c2a)

### Fixed (7 changes)

- [Detect CORS problems in Web IDE](https://gitlab.com/gitlab-org/security/gitlab/-/commit/84bd4650037396a8b0df0dcf6b7747b669418e91)
- [Fix Web IDE loading race condition](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8b48753fdce4a4fac10a07f45f1c1208afc32227)
- [Fix numpad enter not working for revision compare dropdown](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a802fcffc7359add5f39acfd6a1ef057f4b5ea08)
- [Fix another case where Sidekiq can take too long to shut down](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0d78035880ee5ed4f3fc7eac3b0aff67a5262103)
- [Fix: include relative URL root in PDF worker and cMap paths](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f7254c6383db50493e211a79a5a3dec7a8b603c4)
- [New projects inherit parent value for duo_features_enabled](https://gitlab.com/gitlab-org/security/gitlab/-/commit/478689b1f93ee21bb8bfa38eb7142e3e2ed3822b) **GitLab Enterprise Edition**
- [Skip Geo secondary for SyncProjectPolicyWorker](https://gitlab.com/gitlab-org/security/gitlab/-/commit/20de308d39a6821b741b83d37cdef1d3718ace50) **GitLab Enterprise Edition**

### Changed (2 changes)

- [Check root namespace of project framework for SAAS only](https://gitlab.com/gitlab-org/security/gitlab/-/commit/051fe36ef0e9b208a8ede74bce73c8a6082f94d5) **GitLab Enterprise Edition**
- [Fix case sensitivity in CODEOWNERS validation](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3c87a2c77787747a37be3069a91d7bdf7f98f42b) **GitLab Enterprise Edition**

### Security (12 changes)

- [Sanitize html for legacy simple blob viewer and code navigation nodes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/61f1c480da2916cd20eb82f1ae4ba8b0b96029c6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5203))
- [Remove the destroy issue permission from the planner role](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d604e0418ef28a03d49aa38830e1e8a6862d50ec) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5145))
- [Release names are unbounded, leads to server crash](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bc504676f35f3cd17a6e397b2e14c232e4982c19) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5208))
- [Block access to assigned issues when group has IP restriction](https://gitlab.com/gitlab-org/security/gitlab/-/commit/859a6a48b098369ff31878d8caad7916be4bbc21) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5161))
- [More rigorous sanitization of placeholders](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2c5937032ef4ef28234fecfe291bd072550e2545) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5205))
- [Restrict jobs artifacts API endpoint to token access](https://gitlab.com/gitlab-org/security/gitlab/-/commit/408839b414bfe5715d02027dc180f3be03f1cc10) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5154))
- [Only show titleHtml when valid](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d6a1743777deb7a142cd27343b7b88e960c2a328) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5177))
- [Prevent edits to MRAP approval rules](https://gitlab.com/gitlab-org/security/gitlab/-/commit/65bebfb6a10cb6b53c10788b59dc783abbe4ad22) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5200))
- [Fix CI ID Token claims for forked project MR jobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0ff776e5233cc24abc009930ede023782d42572e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5187))
- [Change wiki_page_max_content_bytes default to 5 MB and in existing instances](https://gitlab.com/gitlab-org/security/gitlab/-/commit/337a1cf51c823e9cf3a2ab0891947b1bff855faf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5142))
- [Prevent unauthorized maintainers from modifying runner records](https://gitlab.com/gitlab-org/security/gitlab/-/commit/07fdcbf5442a1a6088c0cc11837a38bdeae858c1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5172))
- [Add length validations to ChatName model fields](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5438b5d6bd8afe47a127f9680a6e84bc52aa69a4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5149))

## 18.2.1 (2025-07-22)

### Fixed (1 change)

- [Fix S3 compatibility in Workhorse uploads for non-AWS S3 providers](https://gitlab.com/gitlab-org/security/gitlab/-/commit/053528b7e6e451f7b7e41e3ea1be98fc79bdc98a)

### Changed (1 change)

- [Preserve workflowID when canceling duo agentic chat](https://gitlab.com/gitlab-org/security/gitlab/-/commit/974f1b29a43b61f1644d1f0e89152921fa6e093a) **GitLab Enterprise Edition**

### Security (4 changes)

- [Sensitive Information Disclosure via resource_group API Despite Repository and...](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8715e494fd33d7ba6ce94f8e3cb059d37fc509ae) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5155))
- [Prevent Duo Code Review from Showing Internal Notes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/49eb66cb6c57e074077f6e48e09e8e3699dd5937) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5143))
- [Restrict Service Desk email visibility to reporter+ role](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ea29f809e2bb029e18506afa58d2f0eea337c4d2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5150))
- [Add authorization to job field on deployment type](https://gitlab.com/gitlab-org/security/gitlab/-/commit/56e86a993e0954d7bb1b5883872f3016ed451550) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5140))

## 18.2.0 (2025-07-16)

### Added (203 changes)

- [Add analyzer status update mutex based on root namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/2f26e52eaba0524628ff3d8ee28743ec1ea78d05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197163)) **GitLab Enterprise Edition**
- [Cleanup package_registry_audit_events FF](https://gitlab.com/gitlab-org/gitlab/-/commit/a2203b63af9306abb314ee7a4a899b27705b6367) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197329))
- [Add API to enable/disable Pipeline Execution Policy setting](https://gitlab.com/gitlab-org/gitlab/-/commit/b027910ed535e66af80fb06134a63cda9e1381f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184883)) **GitLab Enterprise Edition**
- [Add vulnerability id to csv export](https://gitlab.com/gitlab-org/gitlab/-/commit/9ccaa0414e3d8aff61dfa210850f16a06e439a65) by @he-patrick ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197038)) **GitLab Enterprise Edition**
- [Archived & Stalled status for agent flows](https://gitlab.com/gitlab-org/gitlab/-/commit/92d4b5edda4f1088902f9ebeccb576e124f071a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197587))
- [Add issue to MR feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/41942778c06d7ece5a9e3a0a1c58b012f847a064) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197601)) **GitLab Enterprise Edition**
- [Project webhook events for Groups](https://gitlab.com/gitlab-org/gitlab/-/commit/ecedfe6746c2bc42672face501846620ec596d14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197489)) **GitLab Enterprise Edition**
- [Detect incorrect sequence owners](https://gitlab.com/gitlab-org/gitlab/-/commit/d0f0f47e2c84285bc4c62bf82bcef44c25ba3d40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197521))
- [Add visibility to projects API when using `simple` flag](https://gitlab.com/gitlab-org/gitlab/-/commit/35a57c5237aa23df26c36f2d67df699f5ec67455) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196896))
- [Release the beta of the Maven Virtual Registry](https://gitlab.com/gitlab-org/gitlab/-/commit/50e6adbdcce0c99d7f5e370b4b89b23b57bf8510) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197432))
- [Add support for placeholder variables in markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/e817748d61cf4b24db38e4573f863842adf04540) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194934))
- [Default enable consolidation audit event feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/301a6df351ec6e5b8b234f94700914116b9c46f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197001)) **GitLab Enterprise Edition**
- [Add user preference for maintaining cursor](https://gitlab.com/gitlab-org/gitlab/-/commit/e8d58c9f583c4a1e3fc0d8de79426fda1c733345) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197504))
- [Add bypass_settings to MR approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/8dd73bf3fe8498b500e08f93bd8c1c180d5ec831) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196249)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/cbdf3075e42e88fa9fd660d75d9de5845a01089b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197471))
- [Add new mutation that adds children items to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/098b7d39f77322c7425bd54e65956e3ae9e075da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196291))
- [Replace top_level_namespace_path with root_namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/37ed7f2f02beacc975be9cb71c3b2c9961899662) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197266)) **GitLab Enterprise Edition**
- [Add SDRS configuration fields to application_settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/8dadab8a51d37ff449a568855172ff07ee62712c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196753)) **GitLab Enterprise Edition**
- [Cleanup feature flag and add feature spec](https://gitlab.com/gitlab-org/gitlab/-/commit/9ff53e981f03281f322ed27da95f20f35a33f42e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195665)) **GitLab Enterprise Edition**
- [feat: Add bulk move functionality to WorkItems::BulkUpdate](https://gitlab.com/gitlab-org/gitlab/-/commit/2846395973ea2c456c676a8e05ae736e8306f85b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196698))
- [Add support for pagination in GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/ca3c24b24928c45134bc95a9c878bb56e51610c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196188))
- [Add skipped security policies pipelines audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/b22c8223bb76f04550718ce755ffb1d1438dc518) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195325)) **GitLab Enterprise Edition**
- [Add customizable metadata field visibility to work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/229891d068789c3879636d774b5185ae98250df6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196127)) **GitLab Enterprise Edition**
- [Add repair index tool](https://gitlab.com/gitlab-org/gitlab/-/commit/b9b512c1e7b71a92a841d11ba13e5c3c7677a846) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196677))
- [Add status field for work item list metadata preference](https://gitlab.com/gitlab-org/gitlab/-/commit/93e5e3ef7638205f7e170510682dd31c6364252d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197424))
- [Support type, status and source/target project fields in GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/ff1b3438433d2fadcfb0b293bb0b40e5b7f351f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197407))
- [Toggle enabled by default for compliance group dashboard FF](https://gitlab.com/gitlab-org/gitlab/-/commit/4efadf4f7dbdd75aaca38e93a7937b75c6e7022e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197390)) **GitLab Enterprise Edition**
- [Default enable FF advanced_vulnerability_management](https://gitlab.com/gitlab-org/gitlab/-/commit/1cf021b95eb614f8a64df9ef915c6aa7363c6fe9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193929)) **GitLab Enterprise Edition**
- [Implement frameworks needs attention panel](https://gitlab.com/gitlab-org/gitlab/-/commit/7bacc0c5f2ce91fe5b5ec5e83802a4f86ddcd7d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196050)) **GitLab Enterprise Edition**
- [Add user prefernce markdown_maintain_indentation](https://gitlab.com/gitlab-org/gitlab/-/commit/add69b668a580a7e8de8f530e03d748337ae570c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193534))
- [Implement `strategy: mirror`](https://gitlab.com/gitlab-org/gitlab/-/commit/227718a162db50910ae90ba277f4ac40d3119234) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195627))
- [Add audit event for external status check update](https://gitlab.com/gitlab-org/gitlab/-/commit/53dd1a91ab932e010bf23e0577595a75f1e2dc16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189293)) **GitLab Enterprise Edition**
- [Add a system note when the status of a compliance violation is updated](https://gitlab.com/gitlab-org/gitlab/-/commit/dc1a5d4c9d9acdcff204d4e2d5ef08ad9847a746) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197333)) **GitLab Enterprise Edition**
- [FF Cleanup -  Release protected nuget packages](https://gitlab.com/gitlab-org/gitlab/-/commit/60bdc1b728e9df98a0d50095f823f2cd8d475701) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197311))
- [Add namespace_id arg and deprecate parent_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1b35d9a572eb8556f9865b803a8ca2fd66622bb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196941))
- [Include vulnerabilities indexing during indexing trigger](https://gitlab.com/gitlab-org/gitlab/-/commit/4c2f7e7cdec91c4abc5492b2eb27ad29154867a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197147)) **GitLab Enterprise Edition**
- [Add all_active_project_ids to namespace descendants cache](https://gitlab.com/gitlab-org/gitlab/-/commit/483d2ca94d01e004efe556a3a3ee1f31beb733a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194296)) **GitLab Enterprise Edition**
- [MergeRequestLink custom DataTable field component](https://gitlab.com/gitlab-org/gitlab/-/commit/38327c70d8c84d7c4e6333b366d9533ce2618af0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197017)) **GitLab Enterprise Edition**
- [Add groups web_based_commit_signing_enabled field and argument](https://gitlab.com/gitlab-org/gitlab/-/commit/687453b2e10e711a32ee0ef3b2f43bc9441c84fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196768)) **GitLab Enterprise Edition**
- [feat: Enable dependency graph visuals by default](https://gitlab.com/gitlab-org/gitlab/-/commit/d1370df636a45baa832086d13ba13f2f5983a206) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197224)) **GitLab Enterprise Edition**
- [Add syntax for issue and workitem references](https://gitlab.com/gitlab-org/gitlab/-/commit/14e461fd33e5e9a2f4e2b36339c941691aefa6e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197052))
- [Add agentic mode toggle to Duo Chat interfaces](https://gitlab.com/gitlab-org/gitlab/-/commit/a5cb6fec2951afc43668de713c8390b3a394f9db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196712)) **GitLab Enterprise Edition**
- [Release security inventory dashboard (beta)](https://gitlab.com/gitlab-org/gitlab/-/commit/a2ca68d9140c75638ce5b9316a359fedf43d9526) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196924)) **GitLab Enterprise Edition**
- [Add request body size configuration to Workhorse](https://gitlab.com/gitlab-org/gitlab/-/commit/2e90e838bf4588cffd4ac0e37d15f4e23b643819) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197116))
- [Allows email to be updated in the group level service account update API](https://gitlab.com/gitlab-org/gitlab/-/commit/43dfda645ca5c2435761bfeb6d9487ffab627850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196309)) **GitLab Enterprise Edition**
- [Sync vulnerability ES index on sbom ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/ec5c8ba7627e73b14da3e04a175fa691e5cf7c76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195640)) **GitLab Enterprise Edition**
- [Add email notifications for expiring deploy tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/0063f94323963eb6ab5d86dbf4bfadfffd3c84fe) by @guptapratibha26 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193155))
- [Add reserved_storage_bytes for replicas](https://gitlab.com/gitlab-org/gitlab/-/commit/16892ee29b8e6337ac12175563e6cbfdb386937c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195807)) **GitLab Enterprise Edition**
- [feat: Add dependencyPaths Vulnerability support to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/1413d339150dcd9adbe4727723619896b45e0620) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189825)) **GitLab Enterprise Edition**
- [Cleanup packages_protected_packages_generic FF](https://gitlab.com/gitlab-org/gitlab/-/commit/dc0fa4e904d474f46838bd0f2856961b0bc33a15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196865))
- [Enable AWS Secrets Manager integration in GitLab CI](https://gitlab.com/gitlab-org/gitlab/-/commit/9102e9e19d457a6b75127f887e7819b7bb725a41) by @DerAstronaut ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191905)) **GitLab Enterprise Edition**
- [Add `p_duo_workflows_checkpoints` daily partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/eb25acbf0fd4db02259b7cf09d092ed1fab06272) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193398))
- [Add toggle for active state on streaming destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/e9a8bc4dfe507ccc5193a5972ec312505e23cf62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193955)) **GitLab Enterprise Edition**
- [Listing issues linked with compliance violation](https://gitlab.com/gitlab-org/gitlab/-/commit/81251ae4608f53d94437bb6f6314342d0bbd02c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195447)) **GitLab Enterprise Edition**
- [Implement failed controls & failed requirements panels](https://gitlab.com/gitlab-org/gitlab/-/commit/ecd5315e3abf44d33a0e578be81d645a59b60f1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196049)) **GitLab Enterprise Edition**
- [Start adding new service for model matching](https://gitlab.com/gitlab-org/gitlab/-/commit/384a09da56f79f6758f75ff17314d35a6e241088) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196293)) **GitLab Enterprise Edition**
- [Add bypass_settings to MR approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/02d3780b877646024d346181e097a1575ae9d48a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194945)) **GitLab Enterprise Edition**
- [Update YAML with service accounts](https://gitlab.com/gitlab-org/gitlab/-/commit/3bc6c18eb4b4cfd75fabda31301e69d2c776699a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195452)) **GitLab Enterprise Edition**
- [Graphql query for frameworks needing attention](https://gitlab.com/gitlab-org/gitlab/-/commit/77a47630c3e34253b1fdda0b162af4398e4afbf6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193082)) **GitLab Enterprise Edition**
- [Update AnalyzerNamespaceStatuses on group deleted events](https://gitlab.com/gitlab-org/gitlab/-/commit/4112bf4e896824b7a1eb7eccff7317020ad76f9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193404)) **GitLab Enterprise Edition**
- [Omit streaming token from helper methods syncing](https://gitlab.com/gitlab-org/gitlab/-/commit/4523efa3cf5fe7feb9ada7bf9427287314f1fbf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196173)) **GitLab Enterprise Edition**
- [Update the title if exportable has name or title](https://gitlab.com/gitlab-org/gitlab/-/commit/954c447f0cb9186343bb33ab30fa9ec65ed98126) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196603)) **GitLab Enterprise Edition**
- [Add project_statistics field to groups GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/8d74488f59f81be1b399fc623354d2d614276824) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195853))
- [Introduce new ff for SettingsBasedUpdateService](https://gitlab.com/gitlab-org/gitlab/-/commit/19121122a78be1bef28e363201233c037d3b1bca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196691)) **GitLab Enterprise Edition**
- [ActiveContext: add completed check for migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/a634d17d55e958f24138a083e411c0665f26010b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196121)) **GitLab Enterprise Edition**
- [Add work item to current context for chat](https://gitlab.com/gitlab-org/gitlab/-/commit/7338deb6ef69fc3034f2686b1c7b79e3fadadadd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194302)) **GitLab Enterprise Edition**
- [Use created_at column to fetch latest sbom graph](https://gitlab.com/gitlab-org/gitlab/-/commit/c180937fbe41e352ba18828d94c95151b7660e2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196799)) **GitLab Enterprise Edition**
- [Include changes param in shellhorse Git over HTTP](https://gitlab.com/gitlab-org/gitlab/-/commit/fe6b0c4f464ed7dc0e55697dab0b225442daf028) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196743))
- [Add pagination for violations](https://gitlab.com/gitlab-org/gitlab/-/commit/e3e00f34a5015d67c318ad8e984acb6846819fa3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196053)) **GitLab Enterprise Edition**
- [Duo Chat custom rules](https://gitlab.com/gitlab-org/gitlab/-/commit/ec9ce2dfc6bed5392c48ad19f1d716d7d243b999) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196688)) **GitLab Enterprise Edition**
- [Add hierarchy_widget to bulk update](https://gitlab.com/gitlab-org/gitlab/-/commit/0b2a31979dfe8a9856c4a4ff589d815f28e09ff9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196344))
- [Allow setting default status](https://gitlab.com/gitlab-org/gitlab/-/commit/1d5a9b9a11b42f1f2ff1522acc3e96f90a25cd87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196348))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/19b1d609181ac880c22d86be7bb7ead5228d9627) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196645))
- [Allow reorder of status in lifecycle page](https://gitlab.com/gitlab-org/gitlab/-/commit/469d9964b09e4bf55b531b9aa3be19e0370c4761) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196335))
- [Add GraphQL active status updates for AWS audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/f253bea7f6b52e3cf3d67aeba45704a268d49aec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195513)) **GitLab Enterprise Edition**
- [Add insecure channel on TS](https://gitlab.com/gitlab-org/gitlab/-/commit/8518cf1ca783098fc6c25608a35f554e6014cfc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196354))
- [feat: Add tool approval flow for Duo Agentic Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/7ab32eb076a67d32b15341f657662f2ddeda30b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195538)) **GitLab Enterprise Edition**
- [Allow using directories (folders) with rules:exists](https://gitlab.com/gitlab-org/gitlab/-/commit/2f6af09c614b4c0971d3fcdd6458be21a0e47d53) by @thinard ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195797))
- [Added files count for zoekt results on Advanced Search page](https://gitlab.com/gitlab-org/gitlab/-/commit/90f727552e62461ba27de363787845caa4878443) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196160))
- [Small fixes for edit lifecycle form](https://gitlab.com/gitlab-org/gitlab/-/commit/acbcd534ad3f60ddb25e6e5bf4f7386b6a7d1e73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196330))
- [Record user Arkose data to Users::ArkoseSession](https://gitlab.com/gitlab-org/gitlab/-/commit/669a0063654d70ab41bd5f94db03bab6d7a3320f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194590)) **GitLab Enterprise Edition**
- [Add active status updates for streaming audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/3d5d4389171f4e05c0d7d37608dffae7d9e8a6d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195512)) **GitLab Enterprise Edition**
- [Persist partial_scan_mode when storing scans](https://gitlab.com/gitlab-org/gitlab/-/commit/a1119675beec867aec1f506a7c5dbd942d78db1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195373)) **GitLab Enterprise Edition**
- [Add Pipeline Trigger token to validity checks](https://gitlab.com/gitlab-org/gitlab/-/commit/6a76e5592593447ce081aa196dddba060fbc5dac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196203)) **GitLab Enterprise Edition**
- [Add experiment badge to vulnerability Validity Check](https://gitlab.com/gitlab-org/gitlab/-/commit/ed63d47b81f6e1246a9edf29a90979ced8794f81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196381)) **GitLab Enterprise Edition**
- [Add reachability to ES within vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/bed7824eacd6dc1df75510a63a1499096401e773) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194804)) **GitLab Enterprise Edition**
- [Geo Replicables List: Error details](https://gitlab.com/gitlab-org/gitlab/-/commit/e447d72a2cb3e22f6dceeca16e644e34cd9f3c19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196180)) **GitLab Enterprise Edition**
- [Isolate Create Work Item draft for New Related Item flow](https://gitlab.com/gitlab-org/gitlab/-/commit/f5894fca4fe904513ea65ffdaa592d406d1c868a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196032))
- [Add graphQL endpoint for import work item by csv](https://gitlab.com/gitlab-org/gitlab/-/commit/ed3ffd315ac49233bcd0bea0a141fa8df19a9858) by @n.h.long.9697 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195686))
- [Add class method to update last_downloaded_at](https://gitlab.com/gitlab-org/gitlab/-/commit/1cf6e7ed8363daebd50f460b7f7ba595dbf36a6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196388))
- [Feat: Paginate dependency paths](https://gitlab.com/gitlab-org/gitlab/-/commit/ed526fee2c57b02ea3dd17dcf8c66993b3884c3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195455)) **GitLab Enterprise Edition**
- [Add group SSO support for OAuth applications](https://gitlab.com/gitlab-org/gitlab/-/commit/85d373af7ea1c767c0377679faf05b6e1fb4369e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194455))
- [Track AI usage to new Ai::UsageEvent model](https://gitlab.com/gitlab-org/gitlab/-/commit/a5de8af6d78b60f72ef2d201516f0d89297ab15d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195653)) **GitLab Enterprise Edition**
- [Update project violation status](https://gitlab.com/gitlab-org/gitlab/-/commit/fc74553bbc203a6977b7e3b856c045608b960c88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195768)) **GitLab Enterprise Edition**
- [Add is_self_deletion_scheduled field to GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/a40a9bb7797ec713a8225d820b93e904154f43a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196329))
- [Add metrics for SEP trigger condition](https://gitlab.com/gitlab-org/gitlab/-/commit/cb5c73559fabfa4bd2acb75e9841c0d5da1db4ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195996)) **GitLab Enterprise Edition**
- [Add plan field to namespace GraphQL type](https://gitlab.com/gitlab-org/gitlab/-/commit/f2b69be6cdfd78c75a305e1cc816f81babc60b11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194946)) **GitLab Enterprise Edition**
- [Add audit event type to violation graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/b1141c08d81ec6d082d09aabfb85125bc016e130) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195576)) **GitLab Enterprise Edition**
- [Create audit logs when an MR is bypassed by security policy](https://gitlab.com/gitlab-org/gitlab/-/commit/4b0c2504185f2a676c93d738ca8c0f301a348cfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195942)) **GitLab Enterprise Edition**
- [Add execution type to duo workflows](https://gitlab.com/gitlab-org/gitlab/-/commit/08d38afe321f5374ed09dc4993644ed0f3dc2dea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195183)) **GitLab Enterprise Edition**
- [Add full_path_search parameter to namespaces API](https://gitlab.com/gitlab-org/gitlab/-/commit/b67916366ea0224d5391fe1c83c1339b194a3a11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195427))
- [Remove feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1cd102c05bdd2f336f1a70496e4ceb475e64b57e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196271)) **GitLab Enterprise Edition**
- [Add configuration option for opening work items drawer on Lists](https://gitlab.com/gitlab-org/gitlab/-/commit/1bec5a6af74668a02660d4b288792febab6c60a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194816))
- [Add health_status_widget arg](https://gitlab.com/gitlab-org/gitlab/-/commit/410aaab796bb909caf6464c4aeb3df83a5498a96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195418))
- [Requeue BBM a second time](https://gitlab.com/gitlab-org/gitlab/-/commit/7265b5c9d47688e51533a5a801d609e9d3c6816d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196078))
- [Add purge cache functionality for Maven virtual registry upstreams](https://gitlab.com/gitlab-org/gitlab/-/commit/ab45f8d2bb48d401a8d54516316c2fc09598c8c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195815)) **GitLab Enterprise Edition**
- [Add experiment badge and fix text color for Validity Checks](https://gitlab.com/gitlab-org/gitlab/-/commit/990f4bd4b940b6f1daddc8cd404fe0fced67270e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196182)) **GitLab Enterprise Edition**
- [Accept group handles on IssuablesFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/5399cf2b8aa5c9ad64501fc28b050a5d778f4e88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192936))
- [Add Collation Checker task](https://gitlab.com/gitlab-org/gitlab/-/commit/37349387415e94cdabffe6b71637ceefcead0c6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195450))
- [Add GraphQL mutation for bulk updating work items](https://gitlab.com/gitlab-org/gitlab/-/commit/f98addb989ebc6d1a17f36952cc5e92f88cfb110) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195298))
- [Add namespace filter sync helper](https://gitlab.com/gitlab-org/gitlab/-/commit/1a8a8ab8277358b0aee4b7ba52e4cf3d22545c98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192818)) **GitLab Enterprise Edition**
- [Return occurrence_id to /dependencies/location api](https://gitlab.com/gitlab-org/gitlab/-/commit/cb9fb946c3c4e41a7ade3fe2fddbd630b07a9a68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196125)) **GitLab Enterprise Edition**
- [Use Activatable concern for strategy and streamers](https://gitlab.com/gitlab-org/gitlab/-/commit/4500b4297b08fff0bd75f6745104955b5b04c234) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195511)) **GitLab Enterprise Edition**
- [Add support for fixing schema drift in schema validation gem](https://gitlab.com/gitlab-org/gitlab/-/commit/5e618810ae7ce5d6bc3da39d3f9ca49eb28f7b05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195751))
- [Added new CI variable for releases](https://gitlab.com/gitlab-org/gitlab/-/commit/8b68766aeb535528ec4807d6d629b990b14e8640) by @galyfray ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195992))
- [Share compatible Parent & Custom Fields between WI types during create](https://gitlab.com/gitlab-org/gitlab/-/commit/195964dc2cd915a98b7723070e066346270de6eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195700))
- [Add projects web_based_commit_signing_enabled field and argument](https://gitlab.com/gitlab-org/gitlab/-/commit/e348d85e1e5772c5d059c0c4e4215dc594bef879) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195204)) **GitLab Enterprise Edition**
- [Added SettingsBasedUpdateService](https://gitlab.com/gitlab-org/gitlab/-/commit/5735cd677551b8d5dade1f2481279855f18b901d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195320)) **GitLab Enterprise Edition**
- [Implement initial compliance dashboard for group level](https://gitlab.com/gitlab-org/gitlab/-/commit/9e2323b76790be19d2118373c62468179e44ce65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195759)) **GitLab Enterprise Edition**
- [Add headers sync for consolidated APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/55ad0acb4c8528f887d6fdb9506eba8686879d69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192816)) **GitLab Enterprise Edition**
- [feat: Step-up auth: Show step-up auth for admin mode in active sessions](https://gitlab.com/gitlab-org/gitlab/-/commit/5796f3a7d4ea800a10c7cbb3d1987e1dacf30941) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175441))
- [Add AssigneeAvatars as a custom field for DataTable visualization](https://gitlab.com/gitlab-org/gitlab/-/commit/b779fff3b147c284f5ac1934a3237e94cdc19d3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195675)) **GitLab Enterprise Edition**
- [Adds reachability to vulnerability reference](https://gitlab.com/gitlab-org/gitlab/-/commit/4dcfe4673510373a793761ba604f28e3ce7ab623) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193888)) **GitLab Enterprise Edition**
- [Add listing of violations](https://gitlab.com/gitlab-org/gitlab/-/commit/f9886fe1ec66167c6763a8b6dad66a9905ab51b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194206)) **GitLab Enterprise Edition**
- [Add rca claude 4 upgrade](https://gitlab.com/gitlab-org/gitlab/-/commit/c29379c03aee906a226d597a9e7ab1c27cafabf5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195598)) **GitLab Enterprise Edition**
- [Update issue status when moving between lists](https://gitlab.com/gitlab-org/gitlab/-/commit/45e35201e89cec6f25c7e86a7a6f39b1a0362c8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194393)) **GitLab Enterprise Edition**
- [Add email token and feed token to validity checks](https://gitlab.com/gitlab-org/gitlab/-/commit/1f040a95c8e6ee1abcab0d365ee66c9aaf1e3212) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195232)) **GitLab Enterprise Edition**
- [Use Activatable concern for strategy and streamers](https://gitlab.com/gitlab-org/gitlab/-/commit/d20d7b9c5b7300f22ba43a67e9df38f7c3983714) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195510)) **GitLab Enterprise Edition**
- [Add source_branch option to start Duo Workflow](https://gitlab.com/gitlab-org/gitlab/-/commit/7e45ab021c126015d176fd6cba3661e468880862) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195747)) **GitLab Enterprise Edition**
- [Retain selected work item type in Create form draft](https://gitlab.com/gitlab-org/gitlab/-/commit/11fcde10bb7ede018a186952d1f2c91e95d5403e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195191))
- [Add bypass_settings to MR approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/e0fd2fbae6bc8db0e10915b3e36155495d962fee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194242)) **GitLab Enterprise Edition**
- [Adds support for setting Parent during create work item for all types](https://gitlab.com/gitlab-org/gitlab/-/commit/bd66886ee886a7f4bac4ae90182a62794981a1fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195658))
- [Geo Replicables List: Verification status](https://gitlab.com/gitlab-org/gitlab/-/commit/d459b435ac45013a1b8cb3d4ff08c663f1e09a41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195691)) **GitLab Enterprise Edition**
- [Graphql query for requirement coverage](https://gitlab.com/gitlab-org/gitlab/-/commit/74f6df38d52e3806dba6967fb25621f22bdf6ba6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192874)) **GitLab Enterprise Edition**
- [List service account PAT in credentials inventory](https://gitlab.com/gitlab-org/gitlab/-/commit/862d73a82fca46229cf9f364ca5ef430542fb506) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194021)) **GitLab Enterprise Edition**
- [Add additional metrics to the AI impact analytics dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/bd168685260f6f391a43044a1a01a09659e7a5ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195519)) **GitLab Enterprise Edition**
- [Create new issues in status lists](https://gitlab.com/gitlab-org/gitlab/-/commit/67b3e540cefeab4d86909c65337739cadaddcf2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195234))
- [Enable Rapid Diffs on the merge request creation form](https://gitlab.com/gitlab-org/gitlab/-/commit/d1d17e247c24d763ba648afdbd68b3cecbd8813f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195599))
- [Add traversable traversal_ids within scope](https://gitlab.com/gitlab-org/gitlab/-/commit/30f4d39353c74de1793d6e619a5aa2c06b67ba60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194855))
- [Add support of bulk update from project and group issues list](https://gitlab.com/gitlab-org/gitlab/-/commit/b120906d9fd3ba976d28d1282ab2d0f553ce6465) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192590))
- [Add Direct Transfer export audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/1dcf4424533c59a8bd1219829d283c8853786abd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194872))
- [Use Activatable concern for strategy and streamers](https://gitlab.com/gitlab-org/gitlab/-/commit/81520e96f8721b9c42d40d98e3fa17edd4d9ba95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190745)) **GitLab Enterprise Edition**
- [Add more info to gitlab:elastic:info rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/cf65fb1eaa15e0f59bc7660dd5735ca04d2c75c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195681)) **GitLab Enterprise Edition**
- [Add model batch update button](https://gitlab.com/gitlab-org/gitlab/-/commit/46a5a52c5573e545f5c3395a4a9ba77c8a4d04f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194108)) **GitLab Enterprise Edition**
- [Add namespace data to audit event for project deletion marked](https://gitlab.com/gitlab-org/gitlab/-/commit/fe08a45636976edc57a78deaeae6a493f12afae0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195663)) **GitLab Enterprise Edition**
- [Add custom table field components to Analytics DataTable](https://gitlab.com/gitlab-org/gitlab/-/commit/754dd05fa0eef4916d2fa2700a9f7e63cbd67159) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195057)) **GitLab Enterprise Edition**
- [Add validity checks toggle to pipeline secret detection](https://gitlab.com/gitlab-org/gitlab/-/commit/e0e49a30cf35d1676acda2ebd47458c1f32a220f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195074)) **GitLab Enterprise Edition**
- [Added SettingsBasedUpdateService](https://gitlab.com/gitlab-org/gitlab/-/commit/a23de3d544b2d104b0afa515ac19539872165e89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195223)) **GitLab Enterprise Edition**
- [Added SettingsBasedUpdateService](https://gitlab.com/gitlab-org/gitlab/-/commit/e651ac2a15e76e2a9c5bbe9d25458fa67c8e7e1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194365)) **GitLab Enterprise Edition**
- [Prevent streaming token header from being edited](https://gitlab.com/gitlab-org/gitlab/-/commit/0d32917420e62d1e3434b49b5222e27f3ccf075a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193356)) **GitLab Enterprise Edition**
- [Add branches to scheduled pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/7030b32d4dd41cb9f0684111d5710b0f0bf8649a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191946)) **GitLab Enterprise Edition**
- [Add hidden and imported badges to work item header](https://gitlab.com/gitlab-org/gitlab/-/commit/2c9146cd5d8d4789467ccb9722d8d068662631ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194893))
- [Update YAML with tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/16dff58ea924ec136d84d6dcf2dc973805da56f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194709)) **GitLab Enterprise Edition**
- [Add job execution status to Runner, RunnerManager API](https://gitlab.com/gitlab-org/gitlab/-/commit/d64069c576e0d60c750d84a716ae1fd0d890a834) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192534))
- [Add Author role badge for wiki notes](https://gitlab.com/gitlab-org/gitlab/-/commit/227a7b590a1fda18d288c82cc066a5b6428a3ce7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194857))
- [Add project_path in lookup path api response](https://gitlab.com/gitlab-org/gitlab/-/commit/05823ebe58f25bfdbc9a244c0971d73e720e1e8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192892))
- [Show badge on dashboard app](https://gitlab.com/gitlab-org/gitlab/-/commit/968fc6116e86bea5a075e221429ef42a21ae3e18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191884))
- [Add 'marked_for_deletion' and 'is_self_deletion_in_progress' fields](https://gitlab.com/gitlab-org/gitlab/-/commit/9c40b2aabe1540e00b051f9a65a4b86826e3d753) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194707))
- [Add namespace_path support for Projects Graphql API](https://gitlab.com/gitlab-org/gitlab/-/commit/a6913921ae905a0a9d3b54ffd78a976c42efad1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194559))
- [Configure web based commit signing with project update endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/b64bc95d9c55e5834c841bb6e93903a60b0ad2c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194650)) **GitLab Enterprise Edition**
- [Added target branch filter](https://gitlab.com/gitlab-org/gitlab/-/commit/5c998cd8adf064e055b6ca4c24a5eaddaf7ece3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195169))
- [Graphql query for fetching project compliance violation](https://gitlab.com/gitlab-org/gitlab/-/commit/3fad0782a2fcb65ff7158a763d12a9223f31de13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195272)) **GitLab Enterprise Edition**
- [Add Step 1 for Lightweight Registration Experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/8ea09301a8fcb1beeecb267d40eff539293d4392) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193822)) **GitLab Enterprise Edition**
- [Access requirement from control and framework from requirement](https://gitlab.com/gitlab-org/gitlab/-/commit/6d495021bd8649d9f4046560b818acc0c6242529) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193122)) **GitLab Enterprise Edition**
- [Support visibilityLevel parameter on Projects GQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/afe2577b06a2d22d747b37b15e3e75bbf18897ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194415))
- [Add CI_DEFAULT_BRANCH_SLUG env variable](https://gitlab.com/gitlab-org/gitlab/-/commit/2a2738b5a1240cf181eae3e9e8c67c17115b0614) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192216))
- [Add compliance_controls field to audit event YML](https://gitlab.com/gitlab-org/gitlab/-/commit/c0e717196ca217c450961af02b13ea1ac97eaf74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195212))
- [Enable filtering multiple values for a single multi-select custom field](https://gitlab.com/gitlab-org/gitlab/-/commit/e615e827d699abab85f6f4416d5dc78c8a6b2dcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194368))
- [Add tooltip to requirement controls](https://gitlab.com/gitlab-org/gitlab/-/commit/77fca70f270276a7dbe82579f04d428adba1cffb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195190)) **GitLab Enterprise Edition**
- [Fix event type filters for consolidated APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/4a079e6214c8b1ab2844344df48a061af8a3a663) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192815)) **GitLab Enterprise Edition**
- [Enable multiple token types for validity checks](https://gitlab.com/gitlab-org/gitlab/-/commit/219b7c6b1949590882a315327fe832bc857739af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193885)) **GitLab Enterprise Edition**
- [Make the announcement dismissible](https://gitlab.com/gitlab-org/gitlab/-/commit/cbe9e72f8096bab0f68b825ec3cc157adfdca983) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194837)) **GitLab Enterprise Edition**
- [Add `config_file_ref` argument for Changelog API](https://gitlab.com/gitlab-org/gitlab/-/commit/3ce5b7c273fefbdc671b24c9cca810939c8403c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191043))
- [Add duplicate validation](https://gitlab.com/gitlab-org/gitlab/-/commit/4f936f1e1010faad1b7226060bb51e5da2cefdd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193825)) **GitLab Enterprise Edition**
- [Requeue BBM for vulnerability_statistics backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/3922568e5b73bfdc1e2d4e46a146303a12c37f84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195098))
- [Audit creating an OAuth application](https://gitlab.com/gitlab-org/gitlab/-/commit/8e80ebc08021d5cefcc31f125d379b94a4415a54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194557)) **GitLab Enterprise Edition**
- [Support `active` parameter group's children.json endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/a502a91832f14eb8f4d8ad3a366461a17ffebae7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195083))
- [Expose `work_item_status_feature_flag` to epics controller](https://gitlab.com/gitlab-org/gitlab/-/commit/f4b25d6467dfd10b27cf845e862d1331bbb1f28a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195077))
- [Remove feature flag search_mr_filter_target_branch](https://gitlab.com/gitlab-org/gitlab/-/commit/871bc9e1351c53112e942e65c189c96cff48442b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194978)) **GitLab Enterprise Edition**
- [Backfill packages_composer_packages table](https://gitlab.com/gitlab-org/gitlab/-/commit/18db29a85539571e54ff2aeefde615ed040e6e7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194157))
- [Filter work item status on frontend and hide status badge](https://gitlab.com/gitlab-org/gitlab/-/commit/ea015e47de819eaafb0838b26a16e5b47b76c64f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194672))
- [Added ability to remove frontend feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/f061b9f3253f88f3aca12c8f7eb026d33e83aa3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185426))
- [Use sbom_graph_paths in DependencyPaths graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/1e6d09940f061811b10de8bd33144e4cb14ff94c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193268)) **GitLab Enterprise Edition**
- [Hide state when status is available](https://gitlab.com/gitlab-org/gitlab/-/commit/001d174a0b544b729588f2e513f6906f1e60025c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194600))
- [Add maintenance note for project and group runners](https://gitlab.com/gitlab-org/gitlab/-/commit/8775fbd93079324b86484a9e57475abd8983a7bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194284)) **GitLab Enterprise Edition**
- [Add a list of selected exceptions](https://gitlab.com/gitlab-org/gitlab/-/commit/c8275a217a27e4ae12733e57ebc3810a1dfcc77f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193608)) **GitLab Enterprise Edition**
- [Add preview inputs feature](https://gitlab.com/gitlab-org/gitlab/-/commit/7ac6f920c6788cf756c6fd9b7064c6ab736a7aca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194200))
- [Expend analyzer types enum with new types](https://gitlab.com/gitlab-org/gitlab/-/commit/1d6ed49418c574a24d6d076a09afc4775e755b16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193914)) **GitLab Enterprise Edition**
- [Link to a specific file from the overview tab](https://gitlab.com/gitlab-org/gitlab/-/commit/0c929605ec5e254e1386c8435733e810c7d268b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181163))
- [Feature flag enforce_pipl_compliance converted to app setting](https://gitlab.com/gitlab-org/gitlab/-/commit/b3aed8112cbabefbb893e0f7412996687a963f54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193498))
- [Make the /manage/PATs GET endpoint use the cred_inv_finder](https://gitlab.com/gitlab-org/gitlab/-/commit/1c0b5bfa858b76ea29b85cb67a5d099cee4d61c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194865)) **GitLab Enterprise Edition**
- [Add all_active_project_ids column to namespace_descendants table](https://gitlab.com/gitlab-org/gitlab/-/commit/975a7f2572381a7029ecf6fdfbd304f5f54b5c22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194833)) **GitLab Enterprise Edition**
- [Allow DataTable fields to be customized](https://gitlab.com/gitlab-org/gitlab/-/commit/de676f0ca849d08e886b892b51a2ac4701d265d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194441)) **GitLab Enterprise Edition**
- [Make relation export batch size configurable as an application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/f61a0c7ee2394fc40c572b8e7d5934bc2e2ce18d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194607))
- [User OrganizationUserDetail in mentions, autocomplete, participants](https://gitlab.com/gitlab-org/gitlab/-/commit/eba73c65bae37a36800232200bf0d746d5d362b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190607))
- [Added archived field to resource type](https://gitlab.com/gitlab-org/gitlab/-/commit/d7f5d9f1acbd57f1ae89410cff7e0bab3736f78e) by @npilin ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191985))
- [Add audit_event_table_name column to project_compliance_violations](https://gitlab.com/gitlab-org/gitlab/-/commit/73e85ca95aa080194364ba3091f13fbf022d0369) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194502)) **GitLab Enterprise Edition**
- [Remove restartable_project_import feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/082c59d267fe93601678b426be7586edc48c3678) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194695))
- [Return vulnerability initial and latest pipeline in GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/ff1a62392f32b63b5eda7e2ef470b2d9f0f5809c) by @he-patrick ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193819)) **GitLab Enterprise Edition**
- [Add source_branch option to start Duo Workflow](https://gitlab.com/gitlab-org/gitlab/-/commit/1bbe0c58ff1d20dd5f1defee8e8458ca2b86a737) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194588)) **GitLab Enterprise Edition**
- [Share Create Work Item Form draft between Work Item types](https://gitlab.com/gitlab-org/gitlab/-/commit/68083e80c89909a46a492c3b4bed7a5595901c8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193942))
- [Graphql mutation endpoint to create a Duo Workflow](https://gitlab.com/gitlab-org/gitlab/-/commit/2f3984ea08c0307a60d6585adb53db2a88e0efd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194269)) **GitLab Enterprise Edition**
- [Swap to http integration requests for prometheus alerting](https://gitlab.com/gitlab-org/gitlab/-/commit/76efc7949f3c854b724f5ce4c037e1d498ca4926) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193830))

### Fixed (142 changes)

- [Fix commit signatures route](https://gitlab.com/gitlab-org/gitlab/-/commit/6de4035eb972ff614c17a2f2dab6d93b74695bfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197189))
- [GitLab UI integration test for tabs-fix-aria-role](https://gitlab.com/gitlab-org/gitlab/-/commit/e6b521016bc8f98294ae2f78e2bb0ea36be7b95f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193415)) **GitLab Enterprise Edition**
- [Fix 500 from too many dots in inputs expression](https://gitlab.com/gitlab-org/gitlab/-/commit/8d1199a870caeff463f83d797d569aa262bd1719) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196567))
- [Fix runner REST API documentation inconsistencies](https://gitlab.com/gitlab-org/gitlab/-/commit/332024a6e24d08cac2c716a74ba899e0ac9c737b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197488))
- [VSA: Refetch stage counts when switching between value streams](https://gitlab.com/gitlab-org/gitlab/-/commit/2ecdc2c60c29c7eaa0398ac566b593c136bb5a4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197508)) **GitLab Enterprise Edition**
- [Handle blank event_name for audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/f88ca19ecf2778934f456667bb4e070c004ac850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197514)) **GitLab Enterprise Edition**
- [Do not record group member last_activity_at on self-managed instances](https://gitlab.com/gitlab-org/gitlab/-/commit/3c3c632a32bfa5c71021b2daa49d1d5525397e6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196476))
- [Fix audit event types docs](https://gitlab.com/gitlab-org/gitlab/-/commit/24d5574b68a9278a11195e94a85ccb108b50c69b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197483))
- [Fix handling of gist import rate limit](https://gitlab.com/gitlab-org/gitlab/-/commit/3cadf5f4f78b98a429e7cc04b64a4ab02eff3d11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197325))
- [Clear Create Work Item form draft for related item on save](https://gitlab.com/gitlab-org/gitlab/-/commit/051277f12b7460afe2a3b937965360b41009e120) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197485))
- [Fix a11y of colors used in system emails](https://gitlab.com/gitlab-org/gitlab/-/commit/d84753af0ea330766dd92559d052048ec44b6d1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197050))
- [Remove list markers from day activity view](https://gitlab.com/gitlab-org/gitlab/-/commit/87b4fa8539e7779b8ee16ccf041c7266f7ad4e75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197468))
- [Markdown: Add aria-label to checkboxes](https://gitlab.com/gitlab-org/gitlab/-/commit/562dcaa9c04b5a623d52d2f9156cd096aec3692a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194823))
- [Use individual feature flags for bypass settings](https://gitlab.com/gitlab-org/gitlab/-/commit/ffe905c0fcf2ab29b82b175c0e02fba1334fcbda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197322)) **GitLab Enterprise Edition**
- [VSA: Fix overview chart loading when switching value streams](https://gitlab.com/gitlab-org/gitlab/-/commit/65d6b83e9c9260c33cfd35f1a57f8d114a05fa56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197362)) **GitLab Enterprise Edition**
- [Exclude service accounts from top-level group owners](https://gitlab.com/gitlab-org/gitlab/-/commit/81d59d7b177cc38817f83efbcca4e5218a2c2f7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195966)) **GitLab Enterprise Edition**
- [Group maintainer cannot see subgroup runners](https://gitlab.com/gitlab-org/gitlab/-/commit/2dd40b5375a3521a6221de6d69dc94ff40990431) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197130))
- [Fix `NoMethodError` in SBOM ingestion logic](https://gitlab.com/gitlab-org/gitlab/-/commit/e4250b77a1f1460ddbe656c7f1c20975f1bbc301) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197174)) **GitLab Enterprise Edition**
- [Fix validity check project policy](https://gitlab.com/gitlab-org/gitlab/-/commit/a01f809dcaa0271f06e6a0f45e0c6773ebad6ccb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197058)) **GitLab Enterprise Edition**
- [Normalize absolute paths in CI config files entry](https://gitlab.com/gitlab-org/gitlab/-/commit/80fab123e89ccad2baf2a1ce74d1b3adda69aea7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195811))
- [Prevent the access token to be added to the search field](https://gitlab.com/gitlab-org/gitlab/-/commit/8f8865bd7948104395ce071f9fb66871410d532f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197091))
- [Fix broken button](https://gitlab.com/gitlab-org/gitlab/-/commit/2b44faa3ac7c5cd05e9fc7aed1d289c33dbccf97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197088))
- [Relax the test for tracking DB connection](https://gitlab.com/gitlab-org/gitlab/-/commit/012ae4aa9345b384f50605f8b7ad5b3ad7f75c27) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196659)) **GitLab Enterprise Edition**
- [Fix setting analyzer statuses being changed on pipeline run](https://gitlab.com/gitlab-org/gitlab/-/commit/7994cf80f910286df310fd23abbabe34a7585ae8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196528)) **GitLab Enterprise Edition**
- [Fix GutHub Import stage pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/5df01510120c56aa8428eace26c33c01251d262b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196625))
- [Fix no method error license report](https://gitlab.com/gitlab-org/gitlab/-/commit/67cc6f05cc2fd41e950fed9b633418e141c832a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195651)) **GitLab Enterprise Edition**
- [Disable batch update if model is incompatible with other features](https://gitlab.com/gitlab-org/gitlab/-/commit/17dcb9c5a88d0c1c2ea9f89dca7172106d5dac5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196784)) **GitLab Enterprise Edition**
- [Add batch_counter based on max model primary](https://gitlab.com/gitlab-org/gitlab/-/commit/f0ada8bf2960e686a370247a51248bd370cee116) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196428)) **GitLab Enterprise Edition**
- [Fixes increase_sequences_range](https://gitlab.com/gitlab-org/gitlab/-/commit/f7e30e04c21d7a62c917b2ee6946e4a361fca621) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196839))
- [Trigger subscription when closing or reopening](https://gitlab.com/gitlab-org/gitlab/-/commit/c4eceed9e1e1a3e34b97d6f76c2c3e36dfb7e7c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196776))
- [Fix alignment of upvotes, downvotes etc on issues list](https://gitlab.com/gitlab-org/gitlab/-/commit/4b7769bf1c64584b679649a3541a4c7a78f32cd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196905))
- [Switch to using relative URLs in group and project lists](https://gitlab.com/gitlab-org/gitlab/-/commit/70d49eaada57691b24de7b735c8978dfee07bf7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196877))
- [Only skip the ci check for the two auto merge strategies](https://gitlab.com/gitlab-org/gitlab/-/commit/5e2e33fa3458064d045ff7a1db37887cf84ba65a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194836))
- [Update user attachment url](https://gitlab.com/gitlab-org/gitlab/-/commit/d208027e5a345c2d4a102fe4f751158d332ec3b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196137))
- [Reduce setting changed update worker input size](https://gitlab.com/gitlab-org/gitlab/-/commit/7c91f8cac0457322dd840fa7e5a1df1578175f78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196555)) **GitLab Enterprise Edition**
- [Add defer_on_database_health_signal to setting change update worker](https://gitlab.com/gitlab-org/gitlab/-/commit/86e93a5a57eebaaa37c3801d4e8f73262b49b41e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196683)) **GitLab Enterprise Edition**
- [Fix group overview routes when switching tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/3882d1e5767e453aacabdfc17a8badc2ab746b45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196198))
- [Add handling for verification-secret token migration conversion](https://gitlab.com/gitlab-org/gitlab/-/commit/6e12b85d2d1d72fca2febd78ac846cc9d9fa6663) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195717)) **GitLab Enterprise Edition**
- [Truncate namespace in Usage Overview panel in Value Streams Dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/f5c1e8becf068ac1b3861e74f4871b51fc4fb48a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196015)) **GitLab Enterprise Edition**
- [Display comment text area while comments are loading](https://gitlab.com/gitlab-org/gitlab/-/commit/674a1ef3bf081c40359b3601944da8c9f509effc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195720))
- [Add worker delay between scheduled workers](https://gitlab.com/gitlab-org/gitlab/-/commit/10242ddde3b3701e8caae1e9e2dbc852b2db11a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196558)) **GitLab Enterprise Edition**
- [Allow removing labels using remove button in create mode](https://gitlab.com/gitlab-org/gitlab/-/commit/fdbab01e4d96e6cf5eddd95fb7c28ec09fadf70f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196576))
- [Issue boards: Make tooltips accessibile via keyboard](https://gitlab.com/gitlab-org/gitlab/-/commit/5e3426d2bc87c1ee433c618472833e4a73d4bab8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195166))
- [Fix missing permissions for group runners owned indirectly](https://gitlab.com/gitlab-org/gitlab/-/commit/6d731b80d0ffee174c9f686d0005c016926b4931) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196152))
- [Use reactive ref for currentRef](https://gitlab.com/gitlab-org/gitlab/-/commit/6f88bf835e84031d2730d287eae60d1579e1a4d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196520))
- [Fix symbol parameter being passed to sidekiq](https://gitlab.com/gitlab-org/gitlab/-/commit/dd0fcfd0615ecd5917909211a6b8b33483f3d338) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196407)) **GitLab Enterprise Edition**
- [Hide the created token when navigating to another service account](https://gitlab.com/gitlab-org/gitlab/-/commit/4779db47ffc4e5988d46fea9256b4fea8db33b7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196415))
- [Fix Firefox bug where content was bleeding into threads dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/3ea703ca841e33cd2b039515afeb7676696f242e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196405))
- [Fix alignment of mirror button on commits page](https://gitlab.com/gitlab-org/gitlab/-/commit/1b2acfc1a5ca85234e95d97b2af1dab9c3b548ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196172))
- [Add contribution guideline link to work item creation flow](https://gitlab.com/gitlab-org/gitlab/-/commit/d6b2d5612f2ccf9b181808a14fa789721e556156) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195342))
- [Rake Doctor Secrets: Fix WebHook error](https://gitlab.com/gitlab-org/gitlab/-/commit/72f6b787a6c0d21503e38cfc7631431a12a52c82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196094))
- [Fix ruby syntax highlighting](https://gitlab.com/gitlab-org/gitlab/-/commit/edf3a3e2c4200e89d74a8e1ee468923cd0dc774a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196091))
- [Allow user to access project runners through group access](https://gitlab.com/gitlab-org/gitlab/-/commit/c31ed5fdb920305b1a6feaf7bdf2e2428f905cb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194442))
- [Fixed page reset in zoekt multi-result view](https://gitlab.com/gitlab-org/gitlab/-/commit/6db12b60d3eb5c8440cdf4ab1a33a53f25142136) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195006))
- [Fix custom roles not showing when inviting members/groups to a project](https://gitlab.com/gitlab-org/gitlab/-/commit/ee5229c294bfbe9785cb38d092365b7c84cfed4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196204)) **GitLab Enterprise Edition**
- [Fixes 3 extra queries by preloading :project_namespace in ProjectType](https://gitlab.com/gitlab-org/gitlab/-/commit/9da1bc4075f157d723a0ddc6cc26ce16ccdb1b3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195103))
- [Fix project creation permissions for users in shared groups](https://gitlab.com/gitlab-org/gitlab/-/commit/0da67572afe6a8f450bf45a349043fa208a086dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196218))
- [Ensure status limit validations are enforced](https://gitlab.com/gitlab-org/gitlab/-/commit/b6922d060b495918aa0520ba77c3b3e29006309c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196084)) **GitLab Enterprise Edition**
- [Update tier and offering in policy settings API docs](https://gitlab.com/gitlab-org/gitlab/-/commit/cf9c4fc17b2a640630132c9a6b437c47effa4d26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196133))
- [Prevent deletion of last group owner in concurrent requests](https://gitlab.com/gitlab-org/gitlab/-/commit/81501f5f870fcee64f38053480c4885cddd8d607) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196087))
- [Skip unenforceable policy rules notification for child pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/0976da2e0bd19d482f73445cf26576ee3ac16f65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196000)) **GitLab Enterprise Edition**
- [Log message whenever 403 occurs due to too many IPs from one user](https://gitlab.com/gitlab-org/gitlab/-/commit/6c1377f2333934117a2c34882fad98d68a09749e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196016))
- [Add gl-wrap-anywhere to MR titles](https://gitlab.com/gitlab-org/gitlab/-/commit/dce59ef142aa44af7ae11f94df8503ec091423a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196031))
- [Ensure uploaded file copy URL button in RTE copies full URL](https://gitlab.com/gitlab-org/gitlab/-/commit/ccd88997053b1e508816fedb18474f5c7d3c5b2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195531))
- [Do not arbitrarily truncate status at a fixed width](https://gitlab.com/gitlab-org/gitlab/-/commit/177bfbc3db422ad60e21795f3380a70810f9b8de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196004))
- [Show both author and committer in last commit](https://gitlab.com/gitlab-org/gitlab/-/commit/3ef8931b7ac748f180e5c64cb5842b17ded8e804) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195767))
- [Support legacy blob URLs in branch selector](https://gitlab.com/gitlab-org/gitlab/-/commit/85131609a45e7b82766fabbc1a5d0facd465ea15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195957))
- [Include Incidents in Milestone dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/1c4f9eafbf657988ecd87c23ce73266a89d6ecfd) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195921))
- [Fix layout shift when modal window is toggled](https://gitlab.com/gitlab-org/gitlab/-/commit/e3fcd6f4d1a62b762ec3d084162c8d741aa4a162) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195914))
- [Fix pipelines with PEP executed via ChatOps commands](https://gitlab.com/gitlab-org/gitlab/-/commit/dcd81b48183737dd8fcd26c8b530d32e9d6a65a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195909)) **GitLab Enterprise Edition**
- [Link policies to containing group in sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/bbf0cba5e295d6f592a2549c5cb65c3bad94345d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194381)) **GitLab Enterprise Edition**
- [Add linkPaths to work_item_metadata_provider](https://gitlab.com/gitlab-org/gitlab/-/commit/d7b54652d44fbf71fe668df4eaeefe205405bd63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194847))
- [Work item (issue): Make user popovers keyboard accessible](https://gitlab.com/gitlab-org/gitlab/-/commit/d4f2f1242e66fa2360154829c8ebb4571f9447b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195336))
- [Unify framework compliance badge token across compliance center](https://gitlab.com/gitlab-org/gitlab/-/commit/fc7437561332cbd086fa84fc647ca09540edfb35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194137)) **GitLab Enterprise Edition**
- [Add migration to update oauth_applications scopes field to text](https://gitlab.com/gitlab-org/gitlab/-/commit/096aa257ba83bc47553d125b7ab430982bcab0ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194604))
- [Fix Task only custom field filter not showing on issues list and board](https://gitlab.com/gitlab-org/gitlab/-/commit/8ee4f22e50b21fd4826d7ac7972ac2ad268f3e18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195568))
- [Remove Sidekiq shutdown delay in ConcurrencyLimitSampler](https://gitlab.com/gitlab-org/gitlab/-/commit/bdcc16cd44900a7f1f84ba00d21f2c66e469dfa6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195697))
- [Fix generate description on work items](https://gitlab.com/gitlab-org/gitlab/-/commit/bf6268c18f42027774a373246434b74dfa3fa567) by @psimyn ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193474))
- [Fix spacing in file path header](https://gitlab.com/gitlab-org/gitlab/-/commit/26af5e9f280ddec9ea3e8ba274874954bfddb63d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195687))
- [Fix border radius of merged status](https://gitlab.com/gitlab-org/gitlab/-/commit/33c39ec0fe991786ff6108cb5455251a810e6bef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195683))
- [Add tooltip with keyboard shortcut to Markdown preview toggle button](https://gitlab.com/gitlab-org/gitlab/-/commit/5946a40a0796e43bc67f0ba2f4a4656e0fbe89e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195648))
- [Filter inactive CRM contacts out of work item sidebar CRM widget options](https://gitlab.com/gitlab-org/gitlab/-/commit/693903b306d80d73f6d411b20e3bedc6e5600d9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194638))
- [Add a redirect status as a success](https://gitlab.com/gitlab-org/gitlab/-/commit/8bac5936efca3e575726972e73dacfef3fdde53c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195423))
- [Fixed issues label row margin regression](https://gitlab.com/gitlab-org/gitlab/-/commit/4380472e2a25219f90223649ece16c7ec85e4c3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195026))
- [Fix title on empty projects](https://gitlab.com/gitlab-org/gitlab/-/commit/d1a27f0b40df690effd62b1f8f7b6f0f26b2b09a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195498))
- [Exclude project template as admin import source](https://gitlab.com/gitlab-org/gitlab/-/commit/2025675ef929539ad16ef077e4848e17aba488e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194724)) **GitLab Enterprise Edition**
- [Project members: Make user popovers keyboard accessible](https://gitlab.com/gitlab-org/gitlab/-/commit/58636d61d7992e1d8e2e1339dc6e2485fcd3e51a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195312))
- [Fix 404 to group CI/CD variables](https://gitlab.com/gitlab-org/gitlab/-/commit/2d7f979a4a83640dd089254771d534496834ddd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195027))
- [Merge request approval coverage check popover keyboard focus fix](https://gitlab.com/gitlab-org/gitlab/-/commit/51f5d60a069872b5856a8e9e3d8cce062f383037) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195303))
- [Access tokens table: Fix responsive behavior](https://gitlab.com/gitlab-org/gitlab/-/commit/af66881970b0dfbf98a0bd8e00f90de042358dad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195438))
- [Issuable list: Fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/493bbb4c5edc08144b1b8f2e6d5e27f60f6d8c1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194159))
- [RTE: Add aria-label to checkboxes](https://gitlab.com/gitlab-org/gitlab/-/commit/46887fe20687e174e40a4add4c361587ac802f8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194720))
- [Ensure line numbers meet minimum WCAG AA touch target size](https://gitlab.com/gitlab-org/gitlab/-/commit/de018067c60b756a4e0a70c690536e209c951846) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194225))
- [Zoekt: Only enable global search when nodes are online](https://gitlab.com/gitlab-org/gitlab/-/commit/4569f6d3a9e481179bcdbbe3ee59767ed31ff720) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195106)) **GitLab Enterprise Edition**
- [Feature flags list: Fix tooltips not accessible via keyboard](https://gitlab.com/gitlab-org/gitlab/-/commit/569926c22adfc323166a47e08eae31bfc7a92033) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195295))
- [Issues list: Fix tooltip for keyboard users](https://gitlab.com/gitlab-org/gitlab/-/commit/2205318c4d93df51d9b2f749c79fb11d9d25c106) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195282))
- [Groups: Fix tabindex of stats](https://gitlab.com/gitlab-org/gitlab/-/commit/a5a24483b983eb6cc33199609add2cd0b2891c7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195264))
- [Fix NamespacesLinkPaths.newCommentTemplate](https://gitlab.com/gitlab-org/gitlab/-/commit/595fe4e5a33e19e845203156a9826691b0417560) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195000))
- [Handle error response in project/runner_projects_controller#destroy](https://gitlab.com/gitlab-org/gitlab/-/commit/e57a6cb92aec40635647b82db4439fe00ba0106a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194969))
- [Guard against empty filenames for job artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/f45e618477ff627a2cceaeb58957f694b48f6f9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165212)) **GitLab Enterprise Edition**
- [No-op vulnerabilities when group is unlicensed](https://gitlab.com/gitlab-org/gitlab/-/commit/46b155344f025b5e333127ddd027e7d891a00ed3) by @he-patrick ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187201)) **GitLab Enterprise Edition**
- [Search modal: Remove dot when no subitem or namespace is available](https://gitlab.com/gitlab-org/gitlab/-/commit/47f099661fe1e3d37f02a725986083dc3a4a5dfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195008))
- [Pipeline actions: Make tooltips available via focus](https://gitlab.com/gitlab-org/gitlab/-/commit/048d4b686d551c9ee38f34b952756f6f924e1bee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195157))
- [Explore projects: Fix topics not being accessible by keyboard](https://gitlab.com/gitlab-org/gitlab/-/commit/11969ad669bdcbf3586d8cf21fc5f064640d5c50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195139))
- [Re-instate dependency proxy tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/3b4e1175a8394f69e8edf34b9228c1939e4ac61d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194977))
- [Provide fallback background-color for prefers-reduced-transparency](https://gitlab.com/gitlab-org/gitlab/-/commit/36c258a630898fe86c617c8df9b99913aa8f2db0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195079))
- [Fix merge request fluid layout gap](https://gitlab.com/gitlab-org/gitlab/-/commit/1ca96575f25b78dbe4676f7f54e01e110f3dbbb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195081))
- [Adjust placement of "Milestone can be closed" alert](https://gitlab.com/gitlab-org/gitlab/-/commit/bfabf0f2cb6e7eea532cede5116bbc8afc881e5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194912))
- [Chomp a trailng slash in pages.publish keyword](https://gitlab.com/gitlab-org/gitlab/-/commit/40e1747a2eeefaec6991c701f618ea81b089b86b) by @curs3_w4ll ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190681))
- [Fix state badges for epics in GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/fef2b68f9a577158b2a72a1ffd3ea8ab9ee5e637) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195042))
- [Fix code owner validation for roles](https://gitlab.com/gitlab-org/gitlab/-/commit/5cd41d6da44a4a892abc361cfdfa90b8f3f8230d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193183)) **GitLab Enterprise Edition**
- [fix: Git over ssh proxied to secondary failing](https://gitlab.com/gitlab-org/gitlab/-/commit/cf103b1a254b3a7202b57cf06a1839d06714a88d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194673)) **GitLab Enterprise Edition**
- [Fetch commentTemplatesPaths for work items views](https://gitlab.com/gitlab-org/gitlab/-/commit/fd6d7025e3c6dd0e0cd254dbc48ca2f02961fa36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192948))
- [Add hasErrorDuringInvite prop to handle invite errors](https://gitlab.com/gitlab-org/gitlab/-/commit/0ceb4d9606f53d4c8beebafff04db468d356eb69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193826)) **GitLab Enterprise Edition**
- [Fix project project list fetching from Create Form](https://gitlab.com/gitlab-org/gitlab/-/commit/9f0c203dee513b86a18c30b932515f4782b025bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194519))
- [Repo list: Fix lock hover state](https://gitlab.com/gitlab-org/gitlab/-/commit/e287d807bc7629aab2c424ba0f8da0cd06b4e6c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194703))
- [Uncheck SAML options if they are disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/2ae3e61ddf0af580f8f1ef0fc9a889f38fa70d18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194909))
- [Show vulnerability severiy only if an override is present](https://gitlab.com/gitlab-org/gitlab/-/commit/daf925cf5da832be7451c07d66108c147f122a88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194907)) **GitLab Enterprise Edition**
- [Create external statuses on new pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/f3fec6d634d034abad26d02006f751bde7a43ad4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194887))
- [Pipeline item loading icon alignment fix](https://gitlab.com/gitlab-org/gitlab/-/commit/8fefb58c81cb2bc1f64f93beb10ac3485b1c8d57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194882))
- [Fix viewed files in file browser in file by file mode](https://gitlab.com/gitlab-org/gitlab/-/commit/648619a10650e9493e7d470cf2a8a58ce4f0cfed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194879))
- [Fix race condition in memory reporter](https://gitlab.com/gitlab-org/gitlab/-/commit/ec3ee43c269000861b2ca9827b1e9f34e8089282) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194462))
- [Fix calculation for tagging `expiring` tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/8ad6768048cbc06578f9aeb54a24e55fdeee0b74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192396))
- [Fix variable expansion in dynamic child pipelines with nested includes](https://gitlab.com/gitlab-org/gitlab/-/commit/8c5a94ee42eb5f8d3d0d46d691be6048ba3c2ec3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194343))
- [Remove overflow on RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/0d3b004bd68632de984ddcadebc5e1cfc5fdc061) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194839))
- [Add VR resolution to pipeline security report](https://gitlab.com/gitlab-org/gitlab/-/commit/dfb750ef6cf28cd7ea5b9995a484f3d27857b478) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193445)) **GitLab Enterprise Edition**
- [Wiki page: Fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/9d675556d0128cc9a9a54261d82afa12289e99e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194182))
- [Place never contacted runners at end when sorting desc by contacted_at](https://gitlab.com/gitlab-org/gitlab/-/commit/90e93a0a436091b88efe151f4735ccaeff977e02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194632))
- [Fix dark mode MR suggestion border color](https://gitlab.com/gitlab-org/gitlab/-/commit/0fbaa5ab10897944de44700f190f76628c616975) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194768))
- [Re-focus markdown textarea when exiting zen mode](https://gitlab.com/gitlab-org/gitlab/-/commit/b73c0e8b626fcf77bea85266abe72d0b39980f0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194375))
- [Add a validation for an empty commit message](https://gitlab.com/gitlab-org/gitlab/-/commit/04c35bcc7df4587fcbae20d02cd4b853c4e484db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194427))
- [Fix preserve markdown logic for lists](https://gitlab.com/gitlab-org/gitlab/-/commit/38bda0ec967dcc63ad6789a7080cb9e7c0a8dd7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194714))
- [Handle GRPC::DeadlineExceeded for CI project include](https://gitlab.com/gitlab-org/gitlab/-/commit/9468c4cf362a6701f370ef83a6be03f28e2b69e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194697))
- [Add resolver for preReceiveSecretDetection in ProjectType](https://gitlab.com/gitlab-org/gitlab/-/commit/38bc3d82329d460de61ed253a5651e8fa816c376) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194372)) **GitLab Enterprise Edition**
- [Remove concurrency_limit_group_enterprise_users_associate_worker FF](https://gitlab.com/gitlab-org/gitlab/-/commit/6693af323edf48a19e07392a6814cb06b72ef0fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194613)) **GitLab Enterprise Edition**
- [Fix undefined title segments in repository](https://gitlab.com/gitlab-org/gitlab/-/commit/81e8e18904e913d4e037e955e247d6b50534870c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194577))
- [Fall back to diff start pipeline when comparing security reports](https://gitlab.com/gitlab-org/gitlab/-/commit/a4c4a4c27f9a4610ae408a104c6f74261070cf0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192293)) **GitLab Enterprise Edition**
- [Fix adding action with  default variables](https://gitlab.com/gitlab-org/gitlab/-/commit/7da06dd9e056510f7f62ce1d5a5e9164a17f05f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194386)) **GitLab Enterprise Edition**
- [When entering zen mode, set fixed MR top bar to static](https://gitlab.com/gitlab-org/gitlab/-/commit/93f8ed95681bdbd5fba0720b48bfc0b6a7e00a43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194373))
- [Use merge base for all report comparisons](https://gitlab.com/gitlab-org/gitlab/-/commit/af865dd7447fe253ea2feaae40fe174d6ff7e9e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192288))
- [Ensure read_compliance_report custom role has access to new report](https://gitlab.com/gitlab-org/gitlab/-/commit/b58ab5bd018f3c8dbda2b4555275b495aeb5de9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194327)) **GitLab Enterprise Edition**
- [bug: Fix mermaid rendering for wiki content on project main page](https://gitlab.com/gitlab-org/gitlab/-/commit/fcd91cb73c70027da059e6c39c35e613b3417658) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193840))

### Changed (176 changes)

- [Migrate default: {} for JSONB column](https://gitlab.com/gitlab-org/gitlab/-/commit/ae56c539758f3149e6728a6463cdcee21569f417) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197249))
- [Clarifies purpose of the user settings > chat function](https://gitlab.com/gitlab-org/gitlab/-/commit/e88af5dc8f4a219f6b351c4aaa681caa8526d9c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196763))
- [Hide default options in filter while searching](https://gitlab.com/gitlab-org/gitlab/-/commit/0fa8a96e167e25a281a4b943c20a7503fc390913) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197363))
- [Fix archived counts as not_configured in analyzer_namespace_statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/0cd288e13deda311baeaf65b70459be72300e2f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193624)) **GitLab Enterprise Edition**
- [Add expiry date to enterprise bypass placeholder confirmation](https://gitlab.com/gitlab-org/gitlab/-/commit/75359a8572c431c2a0990829f2d0c6248164005b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195328)) **GitLab Enterprise Edition**
- [Enforce RE2 regex for all push rules](https://gitlab.com/gitlab-org/gitlab/-/commit/4882c42fc0bff191dd4b90b292bee9961512a5f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195527)) **GitLab Enterprise Edition**
- [Make MR list status badge keyboard accessible](https://gitlab.com/gitlab-org/gitlab/-/commit/77e2243f59d295d09e5f65d0bea1608b743619a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197221))
- [Use mutation for CI lint](https://gitlab.com/gitlab-org/gitlab/-/commit/89084ef858345d92917d5d338bc71033ed251f6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197153))
- [Update status on violations propogates to backend](https://gitlab.com/gitlab-org/gitlab/-/commit/3c0d7b6361d9bcaa783c78897b2ec8138b7a389a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196879)) **GitLab Enterprise Edition**
- [Make issues list keyboard accessible](https://gitlab.com/gitlab-org/gitlab/-/commit/0c6817fc5295d874e281b8b5a246c94b61325415) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196903))
- [Animate diff header chevron](https://gitlab.com/gitlab-org/gitlab/-/commit/bc471d6e796d0420981d25911a9821d2b2b799b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197434))
- [ActiveContext code: switch completed check](https://gitlab.com/gitlab-org/gitlab/-/commit/9042f429ea4b89ac390b2fee9a57d8d1becbca3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196819)) **GitLab Enterprise Edition**
- [Update gitlab-secret_detection ruby gem to v0.33.0](https://gitlab.com/gitlab-org/gitlab/-/commit/9540ce556532d62ecb35499addf5eba0d334268a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197368))
- [Aggregate Duo Core state in overview](https://gitlab.com/gitlab-org/gitlab/-/commit/5e5b0dab217c90305ba2cb260a8cd423498e5797) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197343)) **GitLab Enterprise Edition**
- [Disable Duo Core checkbox on Duo availability always off](https://gitlab.com/gitlab-org/gitlab/-/commit/9b5300eb573f5e32a6d783c462aa1e70746fa7cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196907)) **GitLab Enterprise Edition**
- [Check Topology Service Health during cells sequence alteration](https://gitlab.com/gitlab-org/gitlab/-/commit/b5e184f796ff3e61e1726340962906c3110ad625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196025))
- [Discard SBoM graph building job on invalid foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/078c876774a0824fa0137088502cd28323dcd6d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197342)) **GitLab Enterprise Edition**
- [Switch from client resolvers](https://gitlab.com/gitlab-org/gitlab/-/commit/77242eaed3f1eca7639feb58cc55cdc3976b8b1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196498)) **GitLab Enterprise Edition**
- [Remove import user membership popover](https://gitlab.com/gitlab-org/gitlab/-/commit/0a8d6b922f658867419adac1f09e282053303e75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196397))
- [Introduce container registry immutable tags](https://gitlab.com/gitlab-org/gitlab/-/commit/40725be29503bb9572db996be7612f351aa385b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195824))
- [Make epics list items keyboard accessible](https://gitlab.com/gitlab-org/gitlab/-/commit/116bc3b3fe95f82a2eef3bd12f8f02854e48b016) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197191))
- [Show model used by "GitLab Default" option](https://gitlab.com/gitlab-org/gitlab/-/commit/029453cf649905262935834b7e55ea755a501851) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196353)) **GitLab Enterprise Edition**
- [Update JWT banner text on settings page](https://gitlab.com/gitlab-org/gitlab/-/commit/a9ed0283ee5d0c310b828500be0908c672e3a2a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196968))
- [Show Draft status instead of Open when MR is Draft](https://gitlab.com/gitlab-org/gitlab/-/commit/49228042ace585168d3926a1e58ec52c5dba0a90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194864))
- [Add dark mode syntax highlight theme options to profile preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/e39e332ae837d297321ccacd1e95f24b5e471988) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194552))
- [Send staging events to Snowplow staging endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/398a5097c75ab8e5cca0881fba27356226b94433) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194800))
- [Add organization_id to security_policy_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/c097dbc182cfa907c86dc2c381e0dfbb68046c25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196402)) **GitLab Enterprise Edition**
- [Update violation columns with more info](https://gitlab.com/gitlab-org/gitlab/-/commit/175afc8ab366695b3ce6c99834a15f80ff10fbe9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197070)) **GitLab Enterprise Edition**
- [Make Create Work Item form enhancements generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/eceb15979d729aa687b33d815f5c26b371dae24b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196714))
- [Deduplicate graph path nodes before saving](https://gitlab.com/gitlab-org/gitlab/-/commit/ad2ef4d09d51986f0bbf906fe121d6289eab4c55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196991)) **GitLab Enterprise Edition**
- [Allow namespace-forced access control on unique and custom domains](https://gitlab.com/gitlab-org/gitlab/-/commit/b4640dbfd30bf174bba8aa86b3560b572f4bffa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196663))
- [Create runner form: Add a registration step](https://gitlab.com/gitlab-org/gitlab/-/commit/2c65631989a64222c47aa9e559aa29c1bca7b51b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196553))
- [Fix placeholder user table to make in responsive](https://gitlab.com/gitlab-org/gitlab/-/commit/888e64896444a6edf880c17548ef5bd951440e8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196156))
- [Change deduplication strategy for Sbom::BuildDependencyGraphWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/5e4b93f4653a30771c75c8aa28a520d8e69831f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196977)) **GitLab Enterprise Edition**
- [Group non-chat Duo features by functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/6546edb7b8f6dc0e6ed80f00d86886965015a1e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196505)) **GitLab Enterprise Edition**
- [List framework with control in violations listing](https://gitlab.com/gitlab-org/gitlab/-/commit/61dd6955bc7727fa576097a787b8005541fc9611) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196736)) **GitLab Enterprise Edition**
- [Remove `use_websocket_for_k8s_watch` FF](https://gitlab.com/gitlab-org/gitlab/-/commit/8c90d8cee5f83b9f78e818c9bf5c20234cdcf0e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193641))
- [Update job badge to lowercase](https://gitlab.com/gitlab-org/gitlab/-/commit/39da209f4fb5bc683104975d30bb1a3481f6f7b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196684))
- [Re-order AI analytics dashboard lifecycle metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/efb2bf57fc7993e68dc6fb0b5f235c536f215cb4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196732)) **GitLab Enterprise Edition**
- [Remove duo_chat_early_thread_creation feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/81213c46b4e6faa3cbcff91c0e4fac36a0f50079) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196943)) **GitLab Enterprise Edition**
- [Replace file browser shortcut with mod+b](https://gitlab.com/gitlab-org/gitlab/-/commit/75728f03a14604bfe932c64854e468fb5682ed64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196614))
- [Update group member placeholder empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/311f60b193ddecdfb006a4b6d6aeff53a0448504) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196139))
- [Update metric names in AI usage metrics table](https://gitlab.com/gitlab-org/gitlab/-/commit/86ee0c8b787e14f78795a13be857c321222ef931) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196870)) **GitLab Enterprise Edition**
- [Add new access point for whats new](https://gitlab.com/gitlab-org/gitlab/-/commit/cab1c82e280ba3cbeea911434fefd17acd5514be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195793))
- [Fix TypeError in JiraConnect for mixed response types](https://gitlab.com/gitlab-org/gitlab/-/commit/5b98bdabf236660ffa579d0dd1a4e12056fde7d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196710))
- [Add not null constraint on integrations table](https://gitlab.com/gitlab-org/gitlab/-/commit/1a6d84c1f0011e425f923db2c7c7a9ed27654222) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190852))
- [Clean-up feature flag enable_add_on_users_filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/824f0203f34c662860745323a2172726c9c5ab35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196801))
- [Remove Sbom::GraphPath records in a separate job](https://gitlab.com/gitlab-org/gitlab/-/commit/2b37b2e338de585d44a2a063989fef223d89af8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196719)) **GitLab Enterprise Edition**
- [Improve Web IDE workbench error handling](https://gitlab.com/gitlab-org/gitlab/-/commit/e0837c98de48e35ed9b189e90dfaeb7def9d0940) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195611))
- [Add database columns for 7+30+60d Deploy Token expiry notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/2030a6c46e3c64329bd7fb04a9feac7ee996ac96) by @guptapratibha26 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193078))
- [Add pagination to DataTable analytics dashboard visualization](https://gitlab.com/gitlab-org/gitlab/-/commit/d373bf0e0cd9ee356325c071e7fef56674e2d386) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196739)) **GitLab Enterprise Edition**
- [Add default 'd' collprovider](https://gitlab.com/gitlab-org/gitlab/-/commit/45c32b261aa10275c150c60b552c82be0c22e18c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196430))
- [Update compliance center tab titles](https://gitlab.com/gitlab-org/gitlab/-/commit/d8eff9c7aea43d53325fbfa0c644304a85dc98f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196633)) **GitLab Enterprise Edition**
- [Update indexes of user_group_member_roles table](https://gitlab.com/gitlab-org/gitlab/-/commit/656fc25d77ae6b7ade50dec09b79e6cbfc30c1ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195127)) **GitLab Enterprise Edition**
- [Allow deletion of unused converted custom statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/0206d4ccea4d3138acfa7506afa89b27bd64a226) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196225)) **GitLab Enterprise Edition**
- [Make merge request list metadata accessible by keyboard](https://gitlab.com/gitlab-org/gitlab/-/commit/1aff02eaecc4048146606b3b5f5fad149efe52c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196599))
- [Test coverage report badges for a job is independent of pipeline status](https://gitlab.com/gitlab-org/gitlab/-/commit/f058f9a3eb85c0b305b11f570b9149e972b8946a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196621))
- [Update `SingleStat` panels in AI impact analytics dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/7dfbe0feb92af30a278ebbc602d83f9b0ef9aebf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196445)) **GitLab Enterprise Edition**
- [Back off immediately if we can't acquire advisory lock](https://gitlab.com/gitlab-org/gitlab/-/commit/ae8c6430fdc903dba8594dcd0077bb52df35bb2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196421)) **GitLab Enterprise Edition**
- [Remove summarize_new_merge_request_claude_4_0_rollout](https://gitlab.com/gitlab-org/gitlab/-/commit/6e4cfb7f87b7c790e95c8b3883942b335a6be061) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194675))
- [Update validate_lfs_object_access default to true](https://gitlab.com/gitlab-org/gitlab/-/commit/6476a7d9e9f4e505f0c9a0e632f1f8794a2b8def) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196502))
- [Remove unneeded restrict user defined variables control check](https://gitlab.com/gitlab-org/gitlab/-/commit/15dd8fdd50e7465e6bed8f19009d95083eae6616) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195710)) **GitLab Enterprise Edition**
- [Add project and agent privileges to Duo Workflow Event graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/798a0547ced45baade5bbc077e283df6262c6256) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195940))
- [Default to similarity sort if searching projects](https://gitlab.com/gitlab-org/gitlab/-/commit/31c87fd3059836cbba153f9c07dca2fa91df387d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196200))
- [Add expired artifact field](https://gitlab.com/gitlab-org/gitlab/-/commit/994423f835c0729906f0c8cbb28bb1e7a7e8e65e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196420))
- [Import table: Fix icons shrinking and alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/d649ff73fea17c69cc23a6212b197d1cab4641c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196395))
- [Namespacing dependency graph rebuild cache key](https://gitlab.com/gitlab-org/gitlab/-/commit/866daeb3831e68f4acd5eae8b0e06d54813916c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196150)) **GitLab Enterprise Edition**
- [Finalize BackfillOnboardingStatusRegistrationObjective migration](https://gitlab.com/gitlab-org/gitlab/-/commit/79b4f4d7beaabd923f8bb76e3b3150b3e0fe9e25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195690)) **GitLab Enterprise Edition**
- [Persist source_id in params of the framework create service call](https://gitlab.com/gitlab-org/gitlab/-/commit/a979cb1961f79586cf238ed7891640e7b251cd8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195575)) **GitLab Enterprise Edition**
- [Fix the owner for sequence ci_builds_id_seq](https://gitlab.com/gitlab-org/gitlab/-/commit/1bbf8013e918d54bd2cd672b3e477a1e4b25a2c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196110))
- [Remove enable_lock_retries! from migration helpers](https://gitlab.com/gitlab-org/gitlab/-/commit/64ed41e00fd8b59f2720e285f18f5738dfdec92d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196323))
- [Set custom statuses via /status quick action](https://gitlab.com/gitlab-org/gitlab/-/commit/0bb386688638311f7b8cd459db565cb151e23be9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195743)) **GitLab Enterprise Edition**
- [Allow GLQL searching by label names](https://gitlab.com/gitlab-org/gitlab/-/commit/2631522891168f510aa1f03ae10dcf0239ae29e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195434))
- [Animate widget chevron](https://gitlab.com/gitlab-org/gitlab/-/commit/2ed910a808910fe038beba1208e8b70e6a64bf22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194601))
- [Add batched background migration to update user detail onboarding URLs](https://gitlab.com/gitlab-org/gitlab/-/commit/03383892ffc1d65d8e30e922c93ca3b664c5558a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195542))
- [Add new column  to compliance management frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/c5014d6c473bb40a9685779f140127c1eb234b9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193536)) **GitLab Enterprise Edition**
- [Use open and reopen instead of unresolve for threads](https://gitlab.com/gitlab-org/gitlab/-/commit/82567ec7d8d49676c9a9a27a41af6067dbbdcd54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195868))
- [Improve runner detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/9cc0fe7b0515faca403efea0cea1b45370a86e99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194454))
- [Fix user placeholder buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/6bcaf7b966e9020b110211783a70e992546d84af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196148))
- [Unify Duo configuration overview](https://gitlab.com/gitlab-org/gitlab/-/commit/1b4c31c4d7c63b7498da0bc4950473e81e26d2da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196022)) **GitLab Enterprise Edition**
- [Remove feature flag active_context_code_event_saas_initial_indexing](https://gitlab.com/gitlab-org/gitlab/-/commit/017cb1b7107abe74599c68f5f84595c03602f892) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196106)) **GitLab Enterprise Edition**
- [Simplifying the cache key generation for dependency graph](https://gitlab.com/gitlab-org/gitlab/-/commit/37111c89df83e637b3ec6a1035a3f97aef292a7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195982)) **GitLab Enterprise Edition**
- [Reduce lifecycle name and status description limits](https://gitlab.com/gitlab-org/gitlab/-/commit/0fb97dc0ba6038d1806932c7673a0b45d3e435f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196060)) **GitLab Enterprise Edition**
- [Rename to read_work_item_lifecycle policy](https://gitlab.com/gitlab-org/gitlab/-/commit/57b3a7bd7b9550d0d6ae4b43c072c32eba483377) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195879)) **GitLab Enterprise Edition**
- [Dependency Graph rebuild only on components change](https://gitlab.com/gitlab-org/gitlab/-/commit/f67f8e7704f357e9118e48dd18ddfa9a70dd729e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195798)) **GitLab Enterprise Edition**
- [Advanced Search: Allow custom prefix for index names](https://gitlab.com/gitlab-org/gitlab/-/commit/f3e4862d04ba89c6292a2272665fb2f87fa1ceb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195449)) **GitLab Enterprise Edition**
- [Add add_ssh_key audit event type](https://gitlab.com/gitlab-org/gitlab/-/commit/692472a0f280e537360cfabaa1cf4063a50902bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195379)) **GitLab Enterprise Edition**
- [Alter compliance framework details graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/10377cc044df3bdc5722f992ea9b770814cb61c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195759)) **GitLab Enterprise Edition**
- [Extend Duo Core description for GitLab.com and Self-Managed/Dedicated](https://gitlab.com/gitlab-org/gitlab/-/commit/e3401eaf715d1d774c6fb6852f2da6599bc0a85f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195959)) **GitLab Enterprise Edition**
- [Use advisory lock when recreating dependency graphs](https://gitlab.com/gitlab-org/gitlab/-/commit/f66b0ff3b62b27eca9d504dc1189065fb3bbb5f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195635)) **GitLab Enterprise Edition**
- [Add more feature flags for bypass options](https://gitlab.com/gitlab-org/gitlab/-/commit/29452a070960c0752bc3424221f58880b72789df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195877)) **GitLab Enterprise Edition**
- [Remove duo_workflow_mcp_support feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/327c906be27a0bd81cfd3a247b1bd17f9a412174) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194778)) **GitLab Enterprise Edition**
- [Add validity_checks_enabled backend-to-frontend data flow](https://gitlab.com/gitlab-org/gitlab/-/commit/977f8bc5f4ddeb20b86d5ac998f8e96859d3f684) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195801)) **GitLab Enterprise Edition**
- [Fix Protected Tags Flaky Specs](https://gitlab.com/gitlab-org/gitlab/-/commit/e57ac0bf3099af8c5ddec99f0250712713536351) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195276))
- [Use lowercase cloud connector headers](https://gitlab.com/gitlab-org/gitlab/-/commit/0da725c111393d2e735d07fa14401399d9c8154b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195827)) **GitLab Enterprise Edition**
- [Reduce status name limit from 255 to 32 chars](https://gitlab.com/gitlab-org/gitlab/-/commit/82dad124c4cf6330b762ddde7a71a9dfa76be029) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195898)) **GitLab Enterprise Edition**
- [Remove calls to enable_lock_retries! from migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/719d30ac5634ef942604d943ef723c980f778ca6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194367))
- [Implement dynamic routing for Compare GitLab plans link](https://gitlab.com/gitlab-org/gitlab/-/commit/2b6111a950fe8e50121206ff5b9cb44b0d95b34c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194246))
- [Update styling of /welcome page to match other areas](https://gitlab.com/gitlab-org/gitlab/-/commit/aa6b26be8d9e5cdb0a85ef378d42fb76bce7c7a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192777)) **GitLab Enterprise Edition**
- [Use default button variant for code dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/079da708ef196ee0203e6ad627ddba458fcaa6e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195706))
- [Rename all_active_project_ids to all_unarchived_project_ids](https://gitlab.com/gitlab-org/gitlab/-/commit/14ac92b85f2f26baf784a4c5c575978b35fa7d59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195462)) **GitLab Enterprise Edition**
- [Enable using glab for CI release](https://gitlab.com/gitlab-org/gitlab/-/commit/e07263f5d6ff29e532c2ae47227b0d7f5cf093d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195702))
- [Extend remove_ssh_key audit event to Enterprise users](https://gitlab.com/gitlab-org/gitlab/-/commit/7788dec554bdcba668ff9700749cf386d4025b38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195390)) **GitLab Enterprise Edition**
- [Do not return status lists if the FF is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/a2df6d330e8ccea4d27cfd9feb6c91a32f193753) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195425)) **GitLab Enterprise Edition**
- [Truncate long custom statuses in issue lists and wrap issue list item](https://gitlab.com/gitlab-org/gitlab/-/commit/9631abeece2923f75adeffcb36cf88f626439d56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195501)) **GitLab Enterprise Edition**
- [Fixes padding and navbar issues](https://gitlab.com/gitlab-org/gitlab/-/commit/fc4c7b3c7c8e5753d6d6d030a8c02acb7b3fa3a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195701)) **GitLab Enterprise Edition**
- [Implement methods for .sql validation source](https://gitlab.com/gitlab-org/gitlab/-/commit/836e32af2c3b7063696c1f0d492c9e04e6c189cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195579))
- [Add happy path feature spec for experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/d55a082fdbda3887e306d4cbcc5bda659fff80cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195680)) **GitLab Enterprise Edition**
- [Only count open abuse reports in admin nav](https://gitlab.com/gitlab-org/gitlab/-/commit/9707228a0fb13e97846a395ec0cd05ebb3ffb1d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195393))
- [Update pipeline inputs empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/0dfa0e5880278f49715603ad02237def401dd17a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194924))
- [Ignore software_license_id in SoftwareLicensePolicy](https://gitlab.com/gitlab-org/gitlab/-/commit/07cebb3cc57d766e91d4c818e6f9227bb449a94a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189535)) **GitLab Enterprise Edition**
- [Add Grape API for fetching and updating CSP](https://gitlab.com/gitlab-org/gitlab/-/commit/f54333d69af9dcd4c7ce60c161e5333b925a354e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194469)) **GitLab Enterprise Edition**
- [Admin dashboard: Migrate GlCard to Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/96636bf0b3371f1e12d2b5cc6fcf0df1d3c0d97a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195601))
- [Improve the bot message disabling with multiple policies](https://gitlab.com/gitlab-org/gitlab/-/commit/beef27c6c9766267c4210a22e087485686aa31d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194271)) **GitLab Enterprise Edition**
- [Backfill traversal_ids in notes index](https://gitlab.com/gitlab-org/gitlab/-/commit/092ed3e9f66729028f1c88eaf2183f888b50ec65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193058)) **GitLab Enterprise Edition**
- [Show 'Pending deletion' badge for group children in groups list](https://gitlab.com/gitlab-org/gitlab/-/commit/2fced668626e997f3df68166768ebde634a328a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193576))
- [Show an indicator when a group is being deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/1ef84c155e5643cb6c9426e1543aae8f04954432) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193576))
- [Add status exclusion filtering for board lists](https://gitlab.com/gitlab-org/gitlab/-/commit/8e9b011a3784ce3a320eaed9ea255e0f4685a003) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194818)) **GitLab Enterprise Edition**
- [Add worker to delete expired and revoked OAuth Access Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/fbc4851591b231cc145ef4234be7862a5e5f9d0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194633))
- [Improve public pipelines setting text](https://gitlab.com/gitlab-org/gitlab/-/commit/aa4ce1c5c2d5b0184f925c6c0cc382fb85a6be95) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195502))
- [Remove generate_commit_message_claude_4_0 feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e93e73f06c9519badaaf0573a9247863e95394ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194649)) **GitLab Enterprise Edition**
- [Reduce batch size and number of retries](https://gitlab.com/gitlab-org/gitlab/-/commit/40a0d6ef654435805e5ea207ee0ceab35cb00d1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195475)) **GitLab Enterprise Edition**
- [Do not search notes if query source is GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/e9f61e8639c5fab7e65f7d977faa4b421683404f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194737))
- [Remove ff collect_product_usage_events](https://gitlab.com/gitlab-org/gitlab/-/commit/67493c3d97ca4888398a2613d088f6f25596550f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195435))
- [Remove `commits_from_gitaly` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/639c634ab7f82a4ce153792f6c07d0bead3bd8aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182921))
- [Add default_dark_syntax_highlighting_theme to application settings](https://gitlab.com/gitlab-org/gitlab/-/commit/576b526455f353d867810b8365fa67e0281b91ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191597))
- [Cleanup "containing_commits_limit" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f87b1045e9d83c095979d323562e4b403f43a98e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195431))
- [Replace feature flag with application setting for pipeline variables](https://gitlab.com/gitlab-org/gitlab/-/commit/d7209343905715daa71106f686b829a8ce11af19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194273))
- [Timeline entry timeago: Remove double tabbing](https://gitlab.com/gitlab-org/gitlab/-/commit/fa1d09b5db840ad4315d256e6448b5696b8c3d53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195162))
- [Show update fork button on mobile](https://gitlab.com/gitlab-org/gitlab/-/commit/c08364efecd1905eb9535f15ec1c633571e72ae3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195389))
- [Build#debug_mode? to return true when degenerated](https://gitlab.com/gitlab-org/gitlab/-/commit/4420e962acfed97f8edf9f4d9aba2121050bb493) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194954))
- [Add docs for Workspace token](https://gitlab.com/gitlab-org/gitlab/-/commit/4a27e22494463f5400db87b147bed2f85aee8131) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195227)) **GitLab Enterprise Edition**
- [Improve actions discoverability](https://gitlab.com/gitlab-org/gitlab/-/commit/74eaf3a90269c09490192aea4331f50a049c69a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195362))
- [Set :throttled urgency for GlobalAdvisoryScanWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/cd68130cd30dafd6aa14edc20078af31aed61d72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194796)) **GitLab Enterprise Edition**
- [Change test summary table header text](https://gitlab.com/gitlab-org/gitlab/-/commit/92c108c26b1d33a2f5668472e6c292a34a3bf133) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195331))
- [Provide branch to Duo Workflow action](https://gitlab.com/gitlab-org/gitlab/-/commit/53fed0b18c4cc8cc2a45d97cea656d901b34a936) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195329)) **GitLab Enterprise Edition**
- [Enable multi-domain architecture in self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/7682869860de2b3ece1a8e2cc69f63804adbafa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193417))
- [Detect more Jenkinsfile patterns](https://gitlab.com/gitlab-org/gitlab/-/commit/6bbdcdf2afe2fbf9e5350741502d6805953a3339) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195309))
- [Allow GLQL search ES by work item assignees](https://gitlab.com/gitlab-org/gitlab/-/commit/db6df68af7fd0c7f04af4d1ef045ba3776160a05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193007))
- [Remove code_based_slash_commands_claude_4_0_rollout feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bc169f3bbef1bc9c3a944e78e4ed923dd9f71c12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194856))
- [Remove code_generation_claude_4_0_rollout feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8805c774ff2b249180ed0887a7cdcac7e13f428b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194848))
- [Set importer_user_mapping_allow_bypass_of_confirmation to true](https://gitlab.com/gitlab-org/gitlab/-/commit/639cf7b6b4c6a4c3790452ff1a9967574401eec2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195262))
- [Add internal endpoint to fetch agent info for agentk](https://gitlab.com/gitlab-org/gitlab/-/commit/9fa72200e51b4e8231a46accf11f8f9c029e9621) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195148))
- [Change Incident sidebar label to `Paging status`](https://gitlab.com/gitlab-org/gitlab/-/commit/ef1531c777147d4c530df2d5807d9fa31823bcbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195225))
- [Update vue 3 tests for mr widget](https://gitlab.com/gitlab-org/gitlab/-/commit/833854a8b0769d20a4e8b28e135c9256e0d0702f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195247))
- [Work item: Add spacing between ancestors and title](https://gitlab.com/gitlab-org/gitlab/-/commit/00540019d73fd24157d67250086419ff70e03252) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194736))
- [Increase interruption retries for Bitbucket Server workers](https://gitlab.com/gitlab-org/gitlab/-/commit/8c20aec273de8f4b8251e65b9685eaf4f9339edb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194947))
- [Add project policy to take ancestors in account](https://gitlab.com/gitlab-org/gitlab/-/commit/15eb8536e2ee10d8f966b46eebe5c36edfc5108a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193746)) **GitLab Enterprise Edition**
- [Remove tabs from from runners details page](https://gitlab.com/gitlab-org/gitlab/-/commit/78a1cf707cfe88cac6a4943ee27fa5da6ddfd894) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193592))
- [Return counts for all analyzer types](https://gitlab.com/gitlab-org/gitlab/-/commit/a00b8124c846a864fb7edd626c5197967cc0be69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194514)) **GitLab Enterprise Edition**
- [Add spacing between project export buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/246cfea2716266f44b973e0a7b38face4680f71d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195107))
- [Add index to workspace tokens on token_encrypted](https://gitlab.com/gitlab-org/gitlab/-/commit/6865753ac724c4551ba297184dd17bf65b93545d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194645)) **GitLab Enterprise Edition**
- [Include email in Arkose::DataExchangePayload](https://gitlab.com/gitlab-org/gitlab/-/commit/dfe8a0956e65126660b6c11a015f269c65c51c7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194420)) **GitLab Enterprise Edition**
- [Remove Feature flag vulnerability_es_ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/067f032758694de6ba0f9a5fd7211e7501a3a13b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194747)) **GitLab Enterprise Edition**
- [Rename column duo_nano_features_enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/7f0fb0bef2e5a9931d572ce63c0f0c8d6db38bcf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191993)) **GitLab Enterprise Edition**
- [Remove work_item_epics_list feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d9069385180d990ba49ff0c424687f579bc879ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191815)) **GitLab Enterprise Edition**
- [Prevent removal of mapped statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/a54b6be18614e6499b1946c0d2ac3f737842a964) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194548)) **GitLab Enterprise Edition**
- [Update Company Logos on billing page in Dark Mode](https://gitlab.com/gitlab-org/gitlab/-/commit/01fe4d9a087a0c5eb554854d87b0c7c7d76d8c83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194320)) **GitLab Enterprise Edition**
- [Clean up root_cause_analysis_hotspot experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/373267fb7713d5e5a864d96c4de86b0545a8d74a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194767))
- [Fail RelationExportWorker when user is banned](https://gitlab.com/gitlab-org/gitlab/-/commit/df134875d8c83d5d414b3b873a5c2b21570051cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194092))
- [Fix more actions button in groups and projects](https://gitlab.com/gitlab-org/gitlab/-/commit/3460f51a4ef456b9203e033426eee13c8127fbfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193033))
- [Clean up feature flag duo_workflow_claude_sonnet_4](https://gitlab.com/gitlab-org/gitlab/-/commit/8b1aba332748b46ed75ecdda8f1b4c7d80c33d25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194886)) **GitLab Enterprise Edition**
- [Create ActiveContext state tracking models](https://gitlab.com/gitlab-org/gitlab/-/commit/5eaf7c865a8292ed1979ddd9077f4bfc2f578fd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193429)) **GitLab Enterprise Edition**
- [Use long timestamps for LDAP sync item](https://gitlab.com/gitlab-org/gitlab/-/commit/fcda3d156529e6660e335ce6f547fa4d193dbd1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194663)) **GitLab Enterprise Edition**
- [Improve styling of GLQL tables](https://gitlab.com/gitlab-org/gitlab/-/commit/e9a1b1e7826d43f137b17948db942aac2f34629e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194761))
- [Show date when relative time is over a year](https://gitlab.com/gitlab-org/gitlab/-/commit/9c42ba8cd085dc1f4cd9dea33ad5cca23f18130b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193861))
- [Update Trial Widget to be compliant with Dark Mode](https://gitlab.com/gitlab-org/gitlab/-/commit/93b4d867e16d2fa7887a9468aceae468008485a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194055)) **GitLab Enterprise Edition**
- [Compare versions: Migrate GlCard to Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/52fd5a7e593539ab2f40d2ac1b029ebbf5731154) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194279))
- [Filter issues in status-based board lists](https://gitlab.com/gitlab-org/gitlab/-/commit/ce43bc10a927dbb9dc65d978f9c184ecdca16a7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193992)) **GitLab Enterprise Edition**
- [Remove summarize_new_merge_request_claude_4_0_rollout feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d023580b99c59d066042ecfcd4c0f07a32d9cbdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194665))
- [Repository analytics: Migrate components and fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/363125d394d8d54a714ceb9ff69fe95bc2ddab2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194464))
- [Show an indicator when a group is being deleted (backend)](https://gitlab.com/gitlab-org/gitlab/-/commit/54d8082eaa3da4a99044cdc7fe80a45a1f7ceac3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191459))
- [Update pipeline inputs selector](https://gitlab.com/gitlab-org/gitlab/-/commit/8ea2f84903ba77d5f2a7654ecbb07a82cfa583d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194594))
- [Remove transition from work item drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/e988e6c76afe4ec6f4ed9a01ca9a43782ffbe29c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194510))
- [Log filtered SAML response for all SAML providers](https://gitlab.com/gitlab-org/gitlab/-/commit/f5e03e06a1341662d8e1cf6983cce808554f0911) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192717))
- [chore: Cleanup batch_duo_workflow_planner_tasks feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/35a2c1ad3b8b800ff937c4b02ba295473faf0703) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194003)) **GitLab Enterprise Edition**

### Deprecated (1 change)

- [Mark all prometheus mutations as deprecated](https://gitlab.com/gitlab-org/gitlab/-/commit/da109bfdb455719cb769ecdf197e87c531d1de78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195386))

### Removed (19 changes)

- [Drop p_ci_pipelines_config table](https://gitlab.com/gitlab-org/gitlab/-/commit/2db639d98242d07e943cba21992d1304c7da511b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194730))
- [Convert feature flag to application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/0801e68535754f9bab09130ade7ebb66d251be06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191032))
- [Remove unified_ai_events_write feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e0f26432f32071fed7566f1725dfb78b3ce21ba0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197102)) **GitLab Enterprise Edition**
- [Remove MR Experience survey & sub-components & feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7802a55e03d95e2466a886925ed4c52df7a56347) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195384))
- [Ensure foreign keys are handled correctly when dropping table](https://gitlab.com/gitlab-org/gitlab/-/commit/3e251b15a186ea371d737e2611de2f6d00c499ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196326))
- [Removal of FF delete_pipl_non_compliant_users](https://gitlab.com/gitlab-org/gitlab/-/commit/8067d099b1aff23b9593dfe2f35e42b1946fab07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196255)) **GitLab Enterprise Edition**
- [Delete the `search_uses_match_queries` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3edaba9c9ee7b774f0fb651db523ffeff1eb492d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190976))
- [Cleanup usage of epic_update_via_work_item FF](https://gitlab.com/gitlab-org/gitlab/-/commit/718cadba458df3d3fab102702d9ce9c98837dd08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195076))
- [Cleanup usage of work_item_epic_milestones feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c54d9bc73aef454703a8f4ba64d147b4029576be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195530))
- [Delete the `frontend_caching` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0d3b403c0c42f3405d25ad17e5a354eb34c84f4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195297))
- [Remove `ci_runner_separation_by_plan` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/081902227c3c3062a52c714b7d567dddd074846e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195296))
- [Remove subscription_plan_cache_key feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/69b88f82884e9c97d2eb9b95e10c0e59855aa4e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195564))
- [Delete the `enhanced_notify_css` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c6e743d986a79f3acb25b9c00b0d5de86141b200) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195300))
- [Remove Projects::CommitController#branches endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/7ce803ae87ca01ab2bfc8bbe445526dbae2d00bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195437))
- [Drop unused roadmap_sort_order helper](https://gitlab.com/gitlab-org/gitlab/-/commit/8cdaefdd6a9bd7c59c84132ce33738ae9cacb4d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195306))
- [Delete the `ci_queuing_include_allowed_plans` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d08f069250ec40dbdb2aba5ac641620a0e40e45f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195296))
- [Drop remaining metrics dashboard tables](https://gitlab.com/gitlab-org/gitlab/-/commit/7e229413ce14e1160088e365eefba6e756c750d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194965))
- [Remove ignore rule for project_fingerprint column](https://gitlab.com/gitlab-org/gitlab/-/commit/e11c2a696da65a2c102cd80ebbb0e2e1ab62f192) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195072)) **GitLab Enterprise Edition**
- [Remove ignore rule for project_fingerprint column](https://gitlab.com/gitlab-org/gitlab/-/commit/a73b0a17b087c4f35fa1c545dd8780d95b6aff11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195071)) **GitLab Enterprise Edition**

### Security (15 changes)

- [Enable by default the path traversal middleware](https://gitlab.com/gitlab-org/gitlab/-/commit/1d87962fa79d54ff703c998721ac147c90d2cba0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197109))
- [Update rack in vendored gems to patch CVEs](https://gitlab.com/gitlab-org/gitlab/-/commit/5db0096500c0a2a9ef98fc13e2b8fb3f17733665) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197228))
- [Revert "Merge branch 'security-fix-id-tokens-forked-projects-security-vulnerability' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/428b6f7203b5202e4ac6f76c270a3a315e898330)
- [Fix CI ID Token claims for forked project MR jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/ab9fc6baa59d16eb09e7e3843deb7c375982c6d1)
- [Prevent linking fork if target group disallows external forks](https://gitlab.com/gitlab-org/gitlab/-/commit/1d997dfac706f608f84eb84b2b54bff8c6b04231)
- [Enforces invite_project_members permission when creating project members](https://gitlab.com/gitlab-org/gitlab/-/commit/4ea90f015abe476a1d110af1cabc828ec0458170)
- [Enforces invite_group_members permission when creating group members](https://gitlab.com/gitlab-org/gitlab/-/commit/68abcb923ad37efcb4e809ca8473e917e4412b83)
- [OSS ultimate should require identity check](https://gitlab.com/gitlab-org/gitlab/-/commit/2f718218db806668f2597e480d6370b4b8f66d65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196296)) **GitLab Enterprise Edition**
- [Fix XSS via blob rich viewer](https://gitlab.com/gitlab-org/gitlab/-/commit/847f350fa8f79b9c6081f5020b7780aa15059402)
- [Fix guest permissions for incident hierarchy updates](https://gitlab.com/gitlab-org/gitlab/-/commit/99c886fb29c0e429480ef814aacf1bf553743672)
- [Checking if framework and project have same namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/77b0f0e08877c9190093f02122619251a3d99648)
- [Prevent anonymous users from creating uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/d19cd44112120396ba92a76880c6cc696b86c08c)
- [Fix the validation logic for IDP Certificate Fingerprint](https://gitlab.com/gitlab-org/gitlab/-/commit/ba94514fb46d816d643cbc444177e560006fe391)
- [Fix incorrect role grant after a user access_request](https://gitlab.com/gitlab-org/gitlab/-/commit/9249ebcc259b9e4b95bba121dd82f9b6ffc39746)
- [Remove `saml_provider_id` filter for `GET /users` API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/dda9b306ca4c8ddc6fee2fcdcb4ab1a9674c49b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190512)) **GitLab Enterprise Edition**

### Performance (7 changes)

- [Adding a temporary project_id column for diff commits epic](https://gitlab.com/gitlab-org/gitlab/-/commit/1382013211237cbaeff6cdc191065770ca2d43a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196884))
- [Use keyset pagination for iterating through MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/82ca9e45938669504442f02c6a61b27221b23760) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196530))
- [Add index for duo settings on namespace_settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/9721b5d12898e46747a284ce1b4a220acd993683) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196589))
- [Add composite index on oauth_access_grants for cleanup worker](https://gitlab.com/gitlab-org/gitlab/-/commit/efbd298f97a0e2cbc32d9cc212e164ce18ede133) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195990))
- [Lowering max project_ids to prevent timeouts](https://gitlab.com/gitlab-org/gitlab/-/commit/fff87d51a8b63fb84717e505fffcbfc546138f8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196155)) **GitLab Enterprise Edition**
- [Provide limit to Gitaly for "Get references a commit is pushed to" API](https://gitlab.com/gitlab-org/gitlab/-/commit/3cc90613d079d834176c2b748d6914bb61349c18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194863))
- [Increase the performance of the PatFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/1db5a6ff6c1e0b0dfe8a9f276e2b9140d44fb9ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193375)) **GitLab Enterprise Edition**

### Other (165 changes)

- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/cd5c38421a71cbb5bb2e46f93f898a31e939502e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197747))
- [Cleanup feature flag unblock_rules_using_pipeline_execution_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e1cb03a5cfc052d09417869af1cb986a6e7248fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197589)) **GitLab Enterprise Edition**
- [Cleanup dependency path CTE and related code](https://gitlab.com/gitlab-org/gitlab/-/commit/d67803ca7a6bae88aee8fcde0da9323a0245337f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197596)) **GitLab Enterprise Edition**
- [Improve UI text for "Assign to commenting user"](https://gitlab.com/gitlab-org/gitlab/-/commit/86ba58c1a5353c6297c53e9c722ef974ce89884f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196818))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/76414fd7341fa29a0d861edd62022d23d2979c30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197096))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/87ae0ca161158387ca2d611125dc2331baed7e8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197547))
- [Finalize BBM BackfillBulkImportFailuresProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/cdd0ff028d1e640eaef6a45b5645105470a930db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196951))
- [Finalize BBM BackfillOnboardingStatusSetupForCompany](https://gitlab.com/gitlab-org/gitlab/-/commit/65e9f48689199e152e7a4dd14cd010ba6432e5e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197397))
- [Cleanup pnp_subscription_plan_cache_key feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/68e4091c4150b6985548916acd548141a2f7d061) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197111))
- [Adds db.rake and its spec files to Database codeowners](https://gitlab.com/gitlab-org/gitlab/-/commit/410e3077cb7dab1dbe7e123ddbf57d1eb0f7c0f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197452))
- [Revert backfill rolled-up weight migration](https://gitlab.com/gitlab-org/gitlab/-/commit/8feeef238e2f1b31daa5162e05ad40559c71ec51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197427))
- [Drop operations_feature_flag_scopes table](https://gitlab.com/gitlab-org/gitlab/-/commit/0eb999afce7907c2258218c2707bad07c86e50b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197233))
- [feat: Add sharding key issue URLs for database tables](https://gitlab.com/gitlab-org/gitlab/-/commit/98ecfce56975066db26dcc58fe8313935782c325) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196728))
- [Finalize BackfillScanResultPoliciesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/1aba751622a5cb4c2e918043f87964011e6f7fc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196190))
- [Remove keyset_paginate_exported_merge_requests feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b642489177ea9e98b3ec51c852b82ab384fb0e05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197341))
- [Remove active_context_code_event_mark_repository_ready feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/afcd096aa37d622984586aa959fa6b6b43ef522f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197098)) **GitLab Enterprise Edition**
- [Remove redundant logs](https://gitlab.com/gitlab-org/gitlab/-/commit/a1797055267cf505e7db01a3fc2e0c69b72971cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196955))
- [Backfill resource_state_events sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/46c059eca4577b1d108b06e52da7f54866affc05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196201))
- [Finalize BackfillSnippetStatisticsSnippetProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/bd155173b1cc9318e3d77643f87a076ab9065212) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196881))
- [Clean up feature flag with references](https://gitlab.com/gitlab-org/gitlab/-/commit/407e55d102b12af94055f949439bdf378e45a68f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197188))
- [Remove dependency_paths field from vulnerability entity](https://gitlab.com/gitlab-org/gitlab/-/commit/e910a4a69ac7e82063ccf7673814974dbb70838e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197154)) **GitLab Enterprise Edition**
- [Finalize BBM FixUsernamespaceAuditEvents](https://gitlab.com/gitlab-org/gitlab/-/commit/c9309dcab2d16ab4351ae7f6a0ef05f21b85867a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196957))
- [Finalize BBM BackfillSeatAssignmentsTable](https://gitlab.com/gitlab-org/gitlab/-/commit/70456730735fd2ac538dbb67731325ff97f93709) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196956))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/104087d2eb26bf825fb1a1b155c9523c290a4f79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196333))
- [Remove dependency_paths from dependencies](https://gitlab.com/gitlab-org/gitlab/-/commit/b697d7f7fa89a395210608b5643264761fa624f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196837)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/9011a2f779894e3947aad9bbaaf913d1ea51d50c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196214))
- [Finalize BackfillIssueAssigneesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/57225a0520f3a5a7ae96a91f55790613fdd6b93b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197051))
- [Finalize BackfillMergeRequestPredictionsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/dd18ab5bae9289d5096abf16b37aba0066cc8d64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197048))
- [Finalize BackfillMergeRequestContextCommitDiffFilesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/4c9be29f71b33ff159df4b4a7974769a72d5b721) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197046))
- [Backfills AnalyzerProjectStatuses](https://gitlab.com/gitlab-org/gitlab/-/commit/dd68e2e2d4b7d84e92339babca8bb336807299b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195856)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint to required_code_owners_sections](https://gitlab.com/gitlab-org/gitlab/-/commit/614e7d243e500a5c9ebcd3f9c1d21f05ff42f93b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196487))
- [Finalize BBM BackfillBulkImportFailuresOrganizationId](https://gitlab.com/gitlab-org/gitlab/-/commit/d15f8e0e8b749bc02b72e21ba9d81cdc2a399a73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196950))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/667a867a01e1b28389210253d1ba8ffb0c44d2dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196972))
- [Finalize BBM BackfillOnboardingStatusRegistrationObjective](https://gitlab.com/gitlab-org/gitlab/-/commit/39af317b8acef5741a5ca853e008271a731c1711) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196954))
- [Finalize BBM BackfillBulkImportFailuresNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/85eecd9a1cf62d35f7b6126db9241152bf2d3075) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196949))
- [Skip cyclic paths in Sbom::PathFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/b2108015601d1a1646ada62cafea6c757a0f78fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196938)) **GitLab Enterprise Edition**
- [Do not add issue_id to epic resource_label_events](https://gitlab.com/gitlab-org/gitlab/-/commit/1fd06dd4a228326e5ee55cd197fc43a8bdee5bdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196618))
- [Finalize BackfillApprovalMergeRequestRulesApprovedApprovers](https://gitlab.com/gitlab-org/gitlab/-/commit/b696c1dfe2bae10f143a8133e6187b033d0817cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196904))
- [Remove integrations not null constraint if it exists](https://gitlab.com/gitlab-org/gitlab/-/commit/3f8d6ca6f49957d1206c93d55d5ab3649abce13c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196875))
- [Add NOT NULL constraint to dast_pre_scan_verification_steps](https://gitlab.com/gitlab-org/gitlab/-/commit/5cfdb1724134c949b0a43ea000e50bcdebb3e56a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196028))
- [Finalize BackfillSnippetUserMentionsSnippetOrganizationId](https://gitlab.com/gitlab-org/gitlab/-/commit/d477ff6279142d56b169a52a904407b725217ef7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196882))
- [Cleanup ultimate_trial_single_form feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7caecf842cc27592fc04228ab8f57b8791486f9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196191)) **GitLab Enterprise Edition**
- [Finalize BackfillSnippetStatisticsSnippetOrganizationId](https://gitlab.com/gitlab-org/gitlab/-/commit/4d412b83b5e6627a7b4b0e61dd5e759633d0d42b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196858))
- [Add NOT NULL constraint to snippet_repository_storage_moves](https://gitlab.com/gitlab-org/gitlab/-/commit/435aba5d45ab8aa23797d1cad6daf809be22b6af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196852))
- [Clean up bitbucket_import_resumable_worker feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b057f98c1ba5b563e01747d43990a23079f77324) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196853))
- [Cleanup security_policies_optional_variables_control and fix schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/3b90a955032893d02fe73a698ee4df521f147140) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196823)) **GitLab Enterprise Edition**
- [Handling string errors from AI GW](https://gitlab.com/gitlab-org/gitlab/-/commit/0ce0d881c01d27fdc2c9395a782cb0a0ee96b3ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196809))
- [Cleanup security_policies_optional_variables_control on backend](https://gitlab.com/gitlab-org/gitlab/-/commit/dd63e489059827bd28079bc53c90470e2c9ca705) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196822)) **GitLab Enterprise Edition**
- [Remove store_arkose_session feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/87270f6fb2b1cb00167f2967ef5731387c0aec9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196772))
- [Remove explore_pipeline_status feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/05628250ee8c0395f5365e6b292ad69d0bf22669) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196165))
- [Add node_modules to default dependency scanning excluded paths](https://gitlab.com/gitlab-org/gitlab/-/commit/5d5f3620c9353673b108257fee606197f24b8ed4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195988)) **GitLab Enterprise Edition**
- [Api#buidlUrl skipped if input is an absolute URL](https://gitlab.com/gitlab-org/gitlab/-/commit/56305277fdc7a90a527fa79d26ea31c11df909e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196109))
- [Cleanup use_approval_policy_rules_for_approval_rules feature](https://gitlab.com/gitlab-org/gitlab/-/commit/9835720270ec3814d226ced0539a958025b0ea38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191927)) **GitLab Enterprise Edition**
- [Add PG index to support code suggestions filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/e7c65dde45b8a80d2fc84d8401088a107f7eefa6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194935))
- [Finalize BBM MigrateScimIdentities](https://gitlab.com/gitlab-org/gitlab/-/commit/1a269e6a40de976fe10815ae72c475571b44a669) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193954))
- [Sets the frequency of the Oauth Access Token cleanup job to daily](https://gitlab.com/gitlab-org/gitlab/-/commit/19dfd83c9e1b8098fccc20bf3a2b6ad5a40bbf20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196364))
- [Remove concurrency_limit from ArchiveTraceWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/fe16dc2710f6be9da8a972cc49548b1ca56f63ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196549))
- [maintenance: Encrypt missed ci_runner plain tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/dbf5c32e8ff2e0d78ee866a48c26059e9dcedbbd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196265))
- [No-op FinalizeBackfillOnboardingStatusRegistrationObjective migration](https://gitlab.com/gitlab-org/gitlab/-/commit/c17df555df4546db2497e4530ad5962dd2078c9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196463))
- [Backfill partitioned sent_notifications table](https://gitlab.com/gitlab-org/gitlab/-/commit/8eb12f90b7d77ec13cebbaced21ab7f51cbb2bf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194482))
- [Advanced to Exact query transpiler for API](https://gitlab.com/gitlab-org/gitlab/-/commit/2922298bd8bf165e67c24c669869133b69a28698) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195463)) **GitLab Enterprise Edition**
- [Add resource_state_events sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/53844371ddebd06b51b2a02cb113889c5ce2feab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196030))
- [Make confidential items checkbox clearer](https://gitlab.com/gitlab-org/gitlab/-/commit/78c551363021526a39f706e6c324d310b69ee167) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193795))
- [Remove enqueue_immediately feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/60c49d0dd29033e6ec2d4d3020605eaeb545f352) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196242))
- [Remove notify_compromised_passwords feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c729fd3ab643438843e695a799da0a4be59303fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196220))
- [Log errors return from AI GW on direct_access_endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/c46013c808a40a0ad0faee9ab7b87d093f6d6cd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195814))
- [Finalize BackfillPackagesDebianFileMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/af6d5dfe9d9db8a5ab6389792b5b1bc4a38f1c48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194667))
- [Add NOT NULL to protected_branch_unprotect_access_levels](https://gitlab.com/gitlab-org/gitlab/-/commit/8a392eca771abd3994469460984cbac79af4d9e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196183))
- [Finalize BackfillSnippetRepositoryStorageMovesSnippetProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/35f8adf74eaa06b64b3f672dbb68b9b0a47a51c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195382))
- [Quarantining end to end spec](https://gitlab.com/gitlab-org/gitlab/-/commit/bb89800875af958618e8bf63ded192dc537a9957) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196178))
- [Remove Planner role promotion related code](https://gitlab.com/gitlab-org/gitlab/-/commit/e91d7b42fabe6611eac1532af7ba492f0e628f5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196130))
- [Add text limit constraint to oauth_applications.scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/6a8b5dc858f4a4c2b328b000f7729ffcf8fee4af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195534))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/56f232fff10116b6056d1bdc1bf05424a66015a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196122))
- [Fix 20 rubocop violations for Layout/ArrayAlignment](https://gitlab.com/gitlab-org/gitlab/-/commit/5492e32b5018d56dac24b757ef18ff0a9e4ef434) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196073))
- [Fix 10 rubocop violations for InternalAffairs/RedundantSourceRange](https://gitlab.com/gitlab-org/gitlab/-/commit/7e3a10e47f84636e6f9abd6df622bb3e521502dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196072))
- [Fix 20 rubocop violations for InternalAffairs/NodeMatcherDirective](https://gitlab.com/gitlab-org/gitlab/-/commit/a780246ac747346555b652ebe656ee0d22b4a79d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196070))
- [Fix 20 rubocop violations for InternalAffairs/ExampleHeredocDelimiter](https://gitlab.com/gitlab-org/gitlab/-/commit/7c4e7394b0810b60ac74f9da843a81d0f7374c41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196069))
- [Initialize conversion of deployments to bigint](https://gitlab.com/gitlab-org/gitlab/-/commit/81f0ea4a9246202f62d2573cd60bf0aa94546e10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194972))
- [Finalize QueueBackfillRequiredCodeOwnersSectionsProtectedBranch](https://gitlab.com/gitlab-org/gitlab/-/commit/5c2e9011677716b2f1f37e1c295f8078d09b9a08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195363))
- [Add NOT NULL constraint to requirements_management_test_reports](https://gitlab.com/gitlab-org/gitlab/-/commit/3a45f75a27d317071d07942709dba9122cd9d8dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196012))
- [Remove remove_prompt_migration_review_merge_request feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a522eca5e821f34aa53458dc8e92dc239e601dc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195989)) **GitLab Enterprise Edition**
- [Remove backoff count from web_hooks table](https://gitlab.com/gitlab-org/gitlab/-/commit/1ddf882f9c5cd67d6ba106384d4a774a6551b808) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195820))
- [Fills analyzer_project_statuses values](https://gitlab.com/gitlab-org/gitlab/-/commit/6284d5ef5e42b4c89f893ae7204b023cb5673907) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195569)) **GitLab Enterprise Edition**
- [Make Code Owners validations generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/fb8aad4c8d8cf038a96189111cf48da9f9ab8a83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195771)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1460e2b8a60d51e1043d910c8eb5844dd5a84142) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195412))
- [Add NOT NULL constraint to packages_conan_file_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/da1be2ffb1ceee7a930382e27ea4fdf245d81cbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195558))
- [Remove attribute_parser_fix feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4dd34c14dcd0da392397121cce5bcdc4718e980f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195867))
- [Initialize conversion of deployment_clusters to bigint](https://gitlab.com/gitlab-org/gitlab/-/commit/a1236d3dbd3d57e9f7953fc085a4da1730a0d4d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195236))
- [Add NOT NULL constraint to wiki_page_slugs](https://gitlab.com/gitlab-org/gitlab/-/commit/0a4ba13e7519300aaedfe72fbfd0b9d9c15dd607) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195860))
- [Add NOT NULL constraint to operations_scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/b2565309c34218768138a2c700022a9da8f1a8c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195836))
- [Add NOT NULL constraint to packages_package_file_build_infos](https://gitlab.com/gitlab-org/gitlab/-/commit/ac503dfb0c97e631760680b87a553bc6416b0f67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195834))
- [Backfill organization_id values in ci_runner_machines](https://gitlab.com/gitlab-org/gitlab/-/commit/380a3cd17b824b12163666655633282ef0204255) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195123))
- [Finalize BackfillDastPreScanVerificationStepsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/296245816ebbb5ba42425ae9efe6faaf6167d70f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194505))
- [Remove duo_code_review_show_all_comments feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/453475c5632e92af8e2bcb4a594fe0f6b4c00292) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194422)) **GitLab Enterprise Edition**
- [Validate organization_id on runner-related models](https://gitlab.com/gitlab-org/gitlab/-/commit/c52a6a03f1355064d986c471950ccfe061e49b27) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195151))
- [Add NOT NULL cosntraint to packages_nuget_dependency_link_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/8568fed969c76ed29e8b644a7a370b472a4a0e0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195726))
- [Remove `use_merge_base_for_all_report_comparisons` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7dbb880292476602148d7e4cae04b905621aa2fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195678))
- [No-op ValidateCiBuildNeedsProjectIdNotNull](https://gitlab.com/gitlab-org/gitlab/-/commit/b57d4d6177ef675605e7f5e7cfbcb8698a55f05b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195684))
- [Add NOT NULL constraint to packages_debian_project_component_files](https://gitlab.com/gitlab-org/gitlab/-/commit/1bb941a03cf2898d3ee819120a12951f7ffba6e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195674))
- [Add NOT NULL constraint to packages_helm_file_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/f5c49d934bf48327c0b7d0af25bc6e0ee9ceea25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195679))
- [Add NOT NULL to bulk_import_export_batches](https://gitlab.com/gitlab-org/gitlab/-/commit/fbd645d2b4320b175de69c8e554f797019b11088) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194255))
- [Cleanup destroy_fork_network_on_archive-ff FF](https://gitlab.com/gitlab-org/gitlab/-/commit/89448bbb2560be6fa6ea3db3a09b75c8c14a9cfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195507))
- [Add NOT NULL constraint to packages_debian_group_component_files](https://gitlab.com/gitlab-org/gitlab/-/commit/7ca22f33e386c68526426c158f46fc5f410adc67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195571))
- [Add NOT NULL constraint to packages_composer_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/685a643364f544b09cae16c34be1ae4ca955ab03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195520))
- [Enforcing Gitlab::Database::Migration[2.3] as new DB migration version](https://gitlab.com/gitlab-org/gitlab/-/commit/3b50cdd4f1108cc5b833438b02b630082f5115d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195144))
- [Clean up runner_spec.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/689c48ffa4544de513978cc2385d9ae9002e9677) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195358))
- [Finalize BackfillSnippetRepositoryStorageMovesSnippetOrgId](https://gitlab.com/gitlab-org/gitlab/-/commit/656fbeae5103f277e7eddda3dbfd42499ab54c65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195383))
- [Remove dead code from ff removal](https://gitlab.com/gitlab-org/gitlab/-/commit/b562f12b56c4ea2ad906d007f9a279cd765490d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195187)) **GitLab Enterprise Edition**
- [Fix E2E tests for personal access tokens UI](https://gitlab.com/gitlab-org/gitlab/-/commit/e07eec988a69856e66cc3d39da329a43d9743603) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194843))
- [Finalize BackfillRequiredCodeOwnersSectionsProtectedBranchProjId](https://gitlab.com/gitlab-org/gitlab/-/commit/15927dcbabd7c8884bc179c0210d9da260d2a7cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195361))
- [Add NOT NULL to issue_customer_relations_contacts](https://gitlab.com/gitlab-org/gitlab/-/commit/334ee7ec492e2acc1dbfeac42b81ed3ae9df602b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194738))
- [Remove chat mutation flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3316ec8d7708049850bd780a39e92cd0191dbe88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194487))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/f2d361bfdfdd92865c0abc0c5ffeb298e4883810) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195302))
- [Remove file from CODEOWNERS](https://gitlab.com/gitlab-org/gitlab/-/commit/b009c20838a72c64e8e38d3f5981f7b86f78fedb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195277))
- [Removes `merge_request_dashboard_author_or_assignee` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c9705392c8e16bf53ccf49804f3691ad11150290) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194996))
- [Fix 1 rubocop violations for InternalAffairs/ProcessedSourceBufferName](https://gitlab.com/gitlab-org/gitlab/-/commit/40099777b8bfababdbfa31ceb665e1ea86e94367) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195244))
- [Fix 1 rubocop violations for InternalAffairs/NodePatternGroups](https://gitlab.com/gitlab-org/gitlab/-/commit/d3ccc7e52845d40502046e00adf4e5b3559678a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195242))
- [Fix 20 rubocop violations for InternalAffairs/NodeMatcherDirective](https://gitlab.com/gitlab-org/gitlab/-/commit/b852346b6d314a7f2f0eef10aa237406c9628903) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195241))
- [Fix 20 rubocop violations for InternalAffairs/ExampleHeredocDelimiter](https://gitlab.com/gitlab-org/gitlab/-/commit/a52259f5381278607402d6d4cb4e9c51fcb52f15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195240))
- [Fix 6 rubocop violations for InternalAffairs/ExampleDescription](https://gitlab.com/gitlab-org/gitlab/-/commit/c90c357d8867099311cddfbb53d01eb17c2e06f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193867))
- [Finalize Backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/2ee8f80a7fa4e4789cd58df915127c658f83487c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195198))
- [Finalize BackfillRequirementsManagementTestReportsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/41aee7edfd4a85b49d0749b6b2d3eeb5be127a87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195180))
- [Add NOT NULL to issuable_slas](https://gitlab.com/gitlab-org/gitlab/-/commit/cf15db4ef881b53410be147880f36bc3a50b2d11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194395))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/25e2c80f7035c43230e3828579e5cced4fefb672) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195087))
- [Finalize BackfillPackagesConanFileMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/c05446c0c81e64b8da97e159f7809fdd16434997) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194630))
- [Finalize BackfillWikiPageSlugsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/c0b500d90f35d646d605c0e0d77b6e5e8b7d69e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195051))
- [Add partitioned copy for sent_notifications table](https://gitlab.com/gitlab-org/gitlab/-/commit/c5c5ff618f33f34bf0827968e4b082c0e1f4f685) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192267))
- [Remove `current_user_use_work_items_view` user preference usage](https://gitlab.com/gitlab-org/gitlab/-/commit/407c2d26c652b30789f494fbeea841cb0d3ec66c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195041))
- [Clean up version filtering FF](https://gitlab.com/gitlab-org/gitlab/-/commit/6abb90456c5cf83d39f6bdff5b366dcf42198ab1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194758)) **GitLab Enterprise Edition**
- [Finalize BackfillOperationsScopesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/79dad1c0962aef3c803d940e5ffa90ce43e7dc48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195036))
- [Add migration to truncate old build names partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/93c364cb5b6e0e0a0e03e6ae9566ce40791672c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193406))
- [Create index synchronously](https://gitlab.com/gitlab-org/gitlab/-/commit/5163e119b2746a4ff0f1faf3565ea1a745c2676f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194546))
- [Finalize BackfillPackagesComposerMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/b32ac96155c67aeb69a728e97083a5beee9ee764) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194224))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/54719717a05a136f0576f9c487ffa8a97a46a06c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193555))
- [Finalize BackfillPackagesNugetDependencyLinkMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/56a0c5557170ec065c556c693ab01f6dbe37b439) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194803))
- [Finalize BackfillNamespacesRedirectRoutesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/c5d28aa230c67405444b7cefc18402a5aefc8c56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194949))
- [Finalize BackfillProjectsRedirectRoutesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/15f999c1475d9827dfaf654a95ddaaa92ff796ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194948))
- [Add Max number of files setting for zoekt indexable project](https://gitlab.com/gitlab-org/gitlab/-/commit/e8e5b512ae145023ae159d0368719fb6589f46c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194428)) **GitLab Enterprise Edition**
- [Finalize BackfillPackagesPackageFileBuildInfosProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/4f6d98b1517b2a4372b7b4cba94d324a4d9384f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194926))
- [Add NOT NULL to bulk_import_configurations](https://gitlab.com/gitlab-org/gitlab/-/commit/40550ca51c526748b6a43b55f2906e99371008e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194192))
- [Finalize BBM MigrateScimTokens](https://gitlab.com/gitlab-org/gitlab/-/commit/8caeee4798d618f777519cb8f981179930f46fb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194247))
- [Add NOT NULL to design_management_repository_states](https://gitlab.com/gitlab-org/gitlab/-/commit/4ae019754d04fa7deb1a096307640c89c9adb7c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194353))
- [Enable two tests for personal access token UI](https://gitlab.com/gitlab-org/gitlab/-/commit/6e111dbc85a294640ef01c5a2b64990b21e46bf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194889))
- [Add NOT NULL to issuable_resource_links](https://gitlab.com/gitlab-org/gitlab/-/commit/ecc5295e4198c9ca633237aa31df309df707d165) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193957))
- [Remove pull_ref_directly_from_gitaly FF](https://gitlab.com/gitlab-org/gitlab/-/commit/30565924c51ca7eba54349eefedefaea0d6e86d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194799))
- [Finalize BackfillPackagesHelmFileMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/4c4656e6742641f22772050683be4e10d3cba22d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194782))
- [Finalize BackfillPackagesDebianProjectComponentFilesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d6187674050437a34950b7a57e7143ffb0f7fedd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194769))
- [Finalize BackfillPackagesDebianGroupComponentFilesGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/4764944057ff71cb27b76c06454d5ea815e55624) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194756))
- [Refine some company form items and remove unnecessary website_url](https://gitlab.com/gitlab-org/gitlab/-/commit/092fd0b9569c7fb0f50f12de201bd21682b554ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194513)) **GitLab Enterprise Edition**
- [Warn Elasticsearch disabled in rake list pending migrations task](https://gitlab.com/gitlab-org/gitlab/-/commit/a787cbb57e42be86e9acf475238086ef9c6a645b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194617)) **GitLab Enterprise Edition**
- [Add NOT NULL to boards_epic_list_user_preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/9b388a5a6d27261c47b93deb8d83a08ac5e0c791) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194349))
- [Move the about site link to self-managed for trial registrations](https://gitlab.com/gitlab-org/gitlab/-/commit/48a3314b1dd916f54e0537c32faf8d53f28b1dd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194204)) **GitLab Enterprise Edition**
- [Backfill ci_runners.organization_id](https://gitlab.com/gitlab-org/gitlab/-/commit/e37852fe69d3bd5936fb05a8fe9b617acaae3233) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193195))
- [Add NOT NULL to sentry_issues](https://gitlab.com/gitlab-org/gitlab/-/commit/a20e0b44a39cf4be2cfe8c1d202fe74c1d21c046) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194039))
- [Fix 7 rubocop violations for InternalAffairs/NodeFirstOrLastArgument](https://gitlab.com/gitlab-org/gitlab/-/commit/8006a0b22b99ba1b0993b3a6133fc91dfacab7f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193872))
- [Fix 10 rubocop violations for InternalAffairs/MethodNameEqual](https://gitlab.com/gitlab-org/gitlab/-/commit/0004da09281a9955bca6daccbf3d1963b3944ccd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193871))
- [Fix 1 rubocop violations for InternalAffairs/MethodNameEndWith](https://gitlab.com/gitlab-org/gitlab/-/commit/294181871e4c02355c1d938ac2dc20971c2d1ae6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193870))
- [Fix 20 rubocop violations for InternalAffairs/ExampleHeredocDelimiter](https://gitlab.com/gitlab-org/gitlab/-/commit/6bf0bc41ef3eb5d543c874edf90b20282347747a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193868))
- [Fix 1 rubocop violations for InternalAffairs/EmptyLineBetweenExpectOffen](https://gitlab.com/gitlab-org/gitlab/-/commit/3e4d3f00f23310b7ad091b41d6aab5320198b0ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193866))
- [Backfill issue_tracker_data sharding_key](https://gitlab.com/gitlab-org/gitlab/-/commit/1f59f4a24bdf208723b1f702f6f2b2d2da1b5443) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193901))
- [Back-fill new partitioned uploads table](https://gitlab.com/gitlab-org/gitlab/-/commit/55f66b67090c57605657650d1e2a255126f60e7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181349))
- [Finalize BackfillIssueCustomerRelationsContactsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/d86b24e21c32e8c329dd6cc8613f4ec152d65446) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194075))
- [Remove pat_last_used_at_optimization FF](https://gitlab.com/gitlab-org/gitlab/-/commit/07b0af7a1bef7be80a2b9ed8d1a8e1ee38b8b0fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193718))
- [Add NOT NULL on incident_management_pending_alert_escalations](https://gitlab.com/gitlab-org/gitlab/-/commit/9eb4353a140f28bb89931e52a7606657915e95b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193647))
- [Sync translations from crowdin (2025-05-28)](https://gitlab.com/gitlab-org/gitlab/-/commit/b7be101322f296e7351d9f2348e5ee32ead9228a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192769))

## 18.1.6 (2025-09-09)

### Fixed (1 change)

- [Make FileLocationType.endLine nullable](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d182c402a89a05008c98ff5fbd30bbcfc547a789) **GitLab Enterprise Edition**

### Security (6 changes)

- [Introduce limit for closed issues](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2a869c795eb95f8012e9343521f1be9007cf2dab) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5237))
- [Add file size limit for blob editing](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4e9cb1f4b1f02e7c932f3cf98beff6efe7de1a10) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5298))
- [Fix DoS via large SAML Response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bf826c92b10e5c36d16aaff1baad1ba5dfda8cde) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5241))
- [Add limit to deploy token name](https://gitlab.com/gitlab-org/security/gitlab/-/commit/09bb4e1c9da13aca8fd29e1cf19fb8e314ab43f0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5301))
- [Fix webhook custom header validation](https://gitlab.com/gitlab-org/security/gitlab/-/commit/87b35b0046ab269fa0f469a7df196ccbc95f22bc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5294))
- [Show runner maintenance note only to runner maintainers](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0b91b0297eedbf681c1355e8ef9f3f0a055aec06) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5288))

## 18.1.5 (2025-08-26)

### Security (4 changes)

- [Adjust snippet blob query complexity to mitigate potential DoS attack](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1002ddc2767f2e4734ecc3029dea74639f1863ea) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5231))
- [Gitea import rate limiting](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5e14b26cb33e61c0605f1a0ec91c3e0467533fb3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5254))
- [Fix tag/branch ambiguity in raw file display](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ffb1039c1e06962b217b479799b6b3052a824b7b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5239))
- [Add authentication check for manual variables via new policy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e4fa4e405ddb8eca1cfccc9a8db355a07254f8f3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5195))

## 18.1.4 (2025-08-12)

### Fixed (4 changes)

- [Fix numpad enter not working for revision compare dropdown](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bfcc6cd8395c3038be6db16a251eb8fa4bd70ada)
- [Fix another case where Sidekiq can take too long to shut down](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7e653c4d1c8aad46bd21652fcb073bc4695af30b)
- [Fix: include relative URL root in PDF worker and cMap paths](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0c2bc0d69c6317df9db3b7fdabaf282ff53f78f8)
- [Skip Geo secondary for SyncProjectPolicyWorker](https://gitlab.com/gitlab-org/security/gitlab/-/commit/46cc0c9398a878c31fc1a578cf2d2e61ca127e6e) **GitLab Enterprise Edition**

### Changed (2 changes)

- [Check root namespace of project framework for SAAS only](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6d5a089a23b31cb4bd0d7bd8d162d96047842570) **GitLab Enterprise Edition**
- [Fix case sensitivity in CODEOWNERS validation](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8152fbb8df5026f8c3cf76c8c6ce8c1bead50330) **GitLab Enterprise Edition**

### Security (11 changes)

- [Sanitize html for legacy simple blob viewer and code navigation nodes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4cf31d635d329618a1fd5781f4ae0d8da62d0fb9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5204))
- [Remove the destroy issue permission from the planner role](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9fc0d52f04f83ad1903d3ea937b1ddde6e8e6c46) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5129))
- [Release names are unbounded, leads to server crash](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a5e31c80d3bf6940ab0d40f322abe78f2b7be35c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5209))
- [Block access to assigned issues when group has IP restriction](https://gitlab.com/gitlab-org/security/gitlab/-/commit/97d3f19798fe0ef7f201c4931d20fbb5d268d40b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5162))
- [Restrict jobs artifacts API endpoint to token access](https://gitlab.com/gitlab-org/security/gitlab/-/commit/76f4fb8fbb9a5833637e3a8c96a173f98f54808c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5122))
- [Only show titleHtml when valid](https://gitlab.com/gitlab-org/security/gitlab/-/commit/92b9a198e548991cdab54a51f0dedc22916f46d3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5178))
- [Prevent edits to MRAP approval rules](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0db41a6626e55dc76b42fb2915ca2513f579319f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5199))
- [Fix CI ID Token claims for forked project MR jobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5a8aec11fea6fa05fbd27c18b723a0f9c5adf47c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5188))
- [Change wiki_page_max_content_bytes default to 5 MB and in existing instances](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2ef6a9e7d85603049fd9eb482f03b829fc1e8714) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5136))
- [Prevent unauthorized maintainers from modifying runner records](https://gitlab.com/gitlab-org/security/gitlab/-/commit/56d359e0a914a37ed130d224929b1b70d2535b53) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5173))
- [Add length validations to ChatName model fields](https://gitlab.com/gitlab-org/security/gitlab/-/commit/36007067bcc7853d0b175170303112a6be38b0ad) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5147))

## 18.1.3 (2025-07-22)

### Security (4 changes)

- [Sensitive Information Disclosure via resource_group API Despite Repository and...](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a4b4f9fe9d9e3b92d9519a4d11aa9bee6487b101) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5156))
- [Prevent Duo Code Review from Showing Internal Notes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/181999a033b2b0972c4b22edcea776a68a3d4a13) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5086))
- [Restrict Service Desk email visibility to reporter+ role](https://gitlab.com/gitlab-org/security/gitlab/-/commit/22af4f97cd80bffcba82b311d4caa31a075ae2f3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5151))
- [Add authorization to job field on deployment type](https://gitlab.com/gitlab-org/security/gitlab/-/commit/743c520ceffb91b16590355ebbaf9a97b413ff5f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5133))

## 18.1.2 (2025-07-09)

### Fixed (5 changes)

- [Rake Doctor Secrets: Fix WebHook error](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ce02068cccff230ffbef2f88b169902fe7f43bbf)
- [Fix title on empty projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3ea74609f662c78433afcfe160a028a5bbbdf2fc)
- [Show both author and committer in last commit](https://gitlab.com/gitlab-org/security/gitlab/-/commit/52ba3c0f90dd0ebc4f6a27beab60588f091068af)
- [Remove Sidekiq shutdown delay in ConcurrencyLimitSampler](https://gitlab.com/gitlab-org/security/gitlab/-/commit/03315bd4f35d87ff58220bf581158698ce163b72)
- [Fix code owner validation for roles](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e797849679b80d660a34b65f11dd7506e9fdf35b) **GitLab Enterprise Edition**

### Changed (2 changes)

- [Fix the owner for sequence ci_builds_id_seq](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d594b6dc14fc5b2ed52f49e7d97d1a2363397185)
- [Enable using glab for CI release](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b91e1226900cbdbb1dfd53efd65c9cb2b6d2f64a)

### Security (6 changes)

- [Revert "Merge branch..." from 18.1](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5384ab91a8eaaa1cfe253eb093277f76cde48d09) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5126))
- [Enforces invite_group_members permission when creating group members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e3f78357e039d70c0eaf67d86f46cced28c8ce3b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5105))
- [Enforces invite_project_members permission when creating project members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/064d8e2a0ce7a9c0191c9ec3ef7f43d1f25e8f29) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5108))
- [Fix XSS via blob rich viewer](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2cd8baa02ea37d89d2f7c67749947da520cb4ea1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5119))
- [Fix CI ID Token claims for forked project MR jobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1a79ece45035eec1d5daee10f89363be089ff069) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5114))
- [Prevent linking fork if target group disallows external forks](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3ccce42e662ce3849c8dde62975e21146d6ef0fa) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5102))

## 18.1.1 (2025-06-24)

### Security (5 changes)

- [Fix guest permissions for incident hierarchy updates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f3cd30dec5fc9123ce7afecc5f94d74b4083f7cf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5078))
- [Fix the validation logic for IDP Certificate Fingerprint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f53497ee0ff29b45f4a3698a7085d036891afbe2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5081))
- [Checking if framework and project have same namespace](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e328730a2b5373b3b400d734b1d6ac3cdb436b19) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5075))
- [Fix incorrect role grant after a user access_request](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cb1b44753248959f3738c502570148cd6ad43059) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5077))
- [Prevent anonymous users from creating uploads](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6e8cee2e35a2f61c610b95569b76ac74d546455a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5076))

## 18.1.0 (2025-06-18)

### Added (182 changes)

- [Update yaml with branch patterns](https://gitlab.com/gitlab-org/gitlab/-/commit/2ce0ac184a6644496b6ed97db1a155984cba2ca3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193441)) **GitLab Enterprise Edition**
- [Show warning for incidents dragging on status list](https://gitlab.com/gitlab-org/gitlab/-/commit/7aaa20fe6b9ccabe78f6f127e8b10c6213679a7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193563))
- [Configure web_based_commit_signing_enabled with group update endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/50a1c2bc28f1c12b45274c750e68206125fb6b8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193928)) **GitLab Enterprise Edition**
- [Extracts logic for Pipeline Secret Detection into its own feature card](https://gitlab.com/gitlab-org/gitlab/-/commit/b8c283030b543d87ae62797dfb59c1f54eb7b4bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194103))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/da28142b6e18617a080dee0924cab70fd32910e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193853))
- [Remove experiment flag from CiLint mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/aac08a48dcf18fbd420f76216a7b9a33b1990980) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194599))
- [New UI for the personal access tokens in the profile settings](https://gitlab.com/gitlab-org/gitlab/-/commit/e5394a7d66393d4881e6ebbcc1e3c96e30ea886a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194582))
- [Add group and project transferred analyzers status event handlers](https://gitlab.com/gitlab-org/gitlab/-/commit/10a79d0acae3cab9c8a8923a598c0ef310868fcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192449)) **GitLab Enterprise Edition**
- [Enable accessible_code_owners_validation feature by default](https://gitlab.com/gitlab-org/gitlab/-/commit/f361f959dfd8f4e152a92fc8cb6cec03fbb764dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194496)) **GitLab Enterprise Edition**
- [Add setting for bypassing placeholder email confirmation](https://gitlab.com/gitlab-org/gitlab/-/commit/38b3dd1dc1f8582489bf3c74fb669d8d0298b9c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189546)) **GitLab Enterprise Edition**
- [Clean up duo_workflow_commit_tools feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/62e708f3761f60e5a0bc3349388138afb3c1c0ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194486)) **GitLab Enterprise Edition**
- [Add work items display settings to user preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/f99042538ab1cc62c0222d30fbd9cfa9a4751aac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193878))
- [Move the zoekt indexing timeout to the application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/7fefc2e01f79f2b48446058030ba534af597ccf3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194297)) **GitLab Enterprise Edition**
- [Add marked_for_deletion field to Projects GraphQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/fbb60e4f9e7f086d0e3e9546f32b6030e82b5974) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193696))
- [WIP Add toggle for new violations view](https://gitlab.com/gitlab-org/gitlab/-/commit/b0091695cd0843e4bae98d2012201b711cfa8c89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193226)) **GitLab Enterprise Edition**
- [Implement `DELETE /Groups/:id` SCIM endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/91864e91e0f8a5e4868b53c51b98305a46d2d94b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192421)) **GitLab Enterprise Edition**
- [Implement grouping for new adherence report](https://gitlab.com/gitlab-org/gitlab/-/commit/ccb2135f4d7300fe5abd9cb5e47d7f6a19e3c049) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193794)) **GitLab Enterprise Edition**
- [Graphql query for controls coverage](https://gitlab.com/gitlab-org/gitlab/-/commit/8e496e01af42c208b38a1ab1f470f97a6c741f0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192880)) **GitLab Enterprise Edition**
- [Add zoekt node services](https://gitlab.com/gitlab-org/gitlab/-/commit/91efe37e0bf253740f497cfc9c61c9acf6146d31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192789)) **GitLab Enterprise Edition**
- [Add a worker to update minimum override role](https://gitlab.com/gitlab-org/gitlab/-/commit/b643f313f64b8508686eb87d59fd8cb9ea177347) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188932))
- [Show icons on status lists](https://gitlab.com/gitlab-org/gitlab/-/commit/ebfe58dd27f641446609c2533079b626ca374e6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193966))
- [Implement compliance requirement status hover popup](https://gitlab.com/gitlab-org/gitlab/-/commit/f7b5080207ba8ae313efc9b9f09e03246e3239f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188369)) **GitLab Enterprise Edition**
- [Add GraphQL mutation for updating lifecycles](https://gitlab.com/gitlab-org/gitlab/-/commit/525379752a5fb9c8510ad65cf3786afa383ffb32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192988)) **GitLab Enterprise Edition**
- [Add "select all" button to inputs selector](https://gitlab.com/gitlab-org/gitlab/-/commit/5da173963db25688d41b3fd1cfe29c031270f696) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194077))
- [Add Modal for User Cap settings change](https://gitlab.com/gitlab-org/gitlab/-/commit/2846288ed78915b0c78a069622319b0ecf79f3f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184460)) **GitLab Enterprise Edition**
- [Add missing filters for: Cadence, Iteration](https://gitlab.com/gitlab-org/gitlab/-/commit/695025d8b9f5d168b23a6bb43a7963ffdf538e0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193448)) **GitLab Enterprise Edition**
- [Personal and Group access token support for new virtual registry scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/ea19b786b6c8b0ebfe943eafd6d98d70b8be522f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189792))
- [Add custom fields filtering to work items list view](https://gitlab.com/gitlab-org/gitlab/-/commit/8f5df65c6d7e18da4c2842a2cd880585e9b4c68a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193834)) **GitLab Enterprise Edition**
- [Allow creation of Prometheus-type HTTP integrations in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/7ef168efbf9de62f3595c562f6a69c18a5b8d9a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120197))
- [Add ability to copy the selected ref](https://gitlab.com/gitlab-org/gitlab/-/commit/260aec07f103d35ab88aa3e42bbd35d54c042c06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193724))
- [Create column and setting for confirmation bypass](https://gitlab.com/gitlab-org/gitlab/-/commit/e79f3880aa4019dd638396260e2cc65ec41bde78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188810)) **GitLab Enterprise Edition**
- [Add an option to insert GLQL view in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/27a1f387abeeecd849489e6299c3c79ceafb5b40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194156))
- [Graphql api for listing project compliance violations](https://gitlab.com/gitlab-org/gitlab/-/commit/268d8bd6a426665c9797cae3e13423682da1e0eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192606)) **GitLab Enterprise Edition**
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/c10f840361b24b8e7db92c25655b860b97f0dbba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193854))
- [Add author role badge to Wiki notes](https://gitlab.com/gitlab-org/gitlab/-/commit/362e46e2d6ea3e34ce5e873bd069cd190fcd2e32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194142))
- [Use existing Namespaces::WorkItemsResolver on namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/7184188fa50466ed709206719f18e9e98cb44dde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193714))
- [Support minimum language server client restriction](https://gitlab.com/gitlab-org/gitlab/-/commit/fc2cc87ce811685cc7884af69f22081a2d261608) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193642))
- [Graphql query for framework coverage summary](https://gitlab.com/gitlab-org/gitlab/-/commit/9f4ff6a8af06d4b6e8c7f9d7b1ed486f0b009f33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192753)) **GitLab Enterprise Edition**
- [Reintroduce backfill migration for vulnerabilities ES index](https://gitlab.com/gitlab-org/gitlab/-/commit/a4905edda8374bf635537859279d2777d65bb441) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194116)) **GitLab Enterprise Edition**
- [Add wiki page subscription backend and GraphQL mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/4d478584807600e505149871df2be7ebf78421bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193342))
- [Create Duo Self-Hosted Provision Service Class](https://gitlab.com/gitlab-org/gitlab/-/commit/7e75d6925a40c576fe75232726d492d7e29361eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193352)) **GitLab Enterprise Edition**
- [Remove duplicated incidents from change failure rate](https://gitlab.com/gitlab-org/gitlab/-/commit/2a2a7111768de87b9b9adb4bb5f10b3ce95bc8d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193910)) **GitLab Enterprise Edition**
- [Add mention of the policy logs in PEP documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/1bb4e120701f00bb74cdecc13cc039870ecfa309) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193800))
- [Remove connection types from CI lint mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/cea4d5c8633355561e73ed165656b882abe52021) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192782))
- [Expose container_scanning_for_registry_enabled in graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/09663b677f09501283a466dd4f9f787c2e2b5456) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193450)) **GitLab Enterprise Edition**
- [Add health status and weight filter for WorkItem API ](https://gitlab.com/gitlab-org/gitlab/-/commit/d0872d58d03b902f1d2979356a479f3525b904a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193114))
- [Add UI for controlling variables restriction in pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/26d0e331e3012124a4bf79576b6d2b25309e4576) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190833))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/abb721e4e60676e516cb4bdb88f898cc0e2861ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194011))
- [Track event when fine-grained permissions are enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/50afb2b9c0265b69874f6398d1d9ad447747145a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192810))
- [New log and event for the adjustment service](https://gitlab.com/gitlab-org/gitlab/-/commit/3f65b7d17a342087631a1a637f0f2f5b81968fdd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192643)) **GitLab Enterprise Edition**
- [Step-up auth: Add support for `included` condition](https://gitlab.com/gitlab-org/gitlab/-/commit/b68d138de87ec673c959550509f99605f4c59cf0) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187491))
- [Allow to update value stream stages on GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/f3077c28bcc5e9ab8f18765bef6e7ac8739b0ce2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193524)) **GitLab Enterprise Edition**
- [Display runner creator and runner created_at within Runners API](https://gitlab.com/gitlab-org/gitlab/-/commit/6974adfdc1bac2b1724bce6b870645ce334a7a6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191738))
- [Expose status details in the board list API](https://gitlab.com/gitlab-org/gitlab/-/commit/4486ab79fb29261d81de399e9510a6e8790ea355) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193841)) **GitLab Enterprise Edition**
- [Add rechability field to vulnerability index](https://gitlab.com/gitlab-org/gitlab/-/commit/bed4f8f8bca33a914d33815f894cbb47013dbb20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192619)) **GitLab Enterprise Edition**
- [Add ability to sort compliance frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/739ffb89109603cb7634fbe60d8369cdba5addd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192560)) **GitLab Enterprise Edition**
- [Create new page for violation details](https://gitlab.com/gitlab-org/gitlab/-/commit/e751acf34d76e479c9829dd5e77a252e12d2ae40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192686)) **GitLab Enterprise Edition**
- [Add Duo Context Exclusion settings GraphQL interface](https://gitlab.com/gitlab-org/gitlab/-/commit/37abb68e214523219633796f8e1c6da56b52a4d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192819))
- [Add "GET /groups/:id/saml_users" API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/d942843296c886aa9800de4bebda635653b485d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193748)) **GitLab Enterprise Edition**
- [Add filter `ALL` to cluster agents query](https://gitlab.com/gitlab-org/gitlab/-/commit/50c3a76fae60ff539f042a0fdcaf05bf8ed55422) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192329)) **GitLab Enterprise Edition**
- [Release OWASP 2021 grouping](https://gitlab.com/gitlab-org/gitlab/-/commit/13821750dd43595618a30f09cf0f76270a74f14b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192766)) **GitLab Enterprise Edition**
- [Add sorting to compliance_frameworks GraphQL field](https://gitlab.com/gitlab-org/gitlab/-/commit/a0aecb84c5cc79f80e41b0b7f8944a766d3905f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192475)) **GitLab Enterprise Edition**
- [Add Release, Contact, Organisation filters on WorkItems API](https://gitlab.com/gitlab-org/gitlab/-/commit/911cd90b94cd64b3c938074376d20be14119476b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192906))
- [feat: Introducing Labkit::Metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/4a71eb380049a8e381bde495945ddeafc4588077) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188302)) **GitLab Enterprise Edition**
- [Add conan delete package_revision endpoint for v2](https://gitlab.com/gitlab-org/gitlab/-/commit/c6586265313eee149b8edb358c27e03a582ce672) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191910))
- [Add index to `sbom_graph_paths` for efficient EachBatch usage](https://gitlab.com/gitlab-org/gitlab/-/commit/5de136e6f5097b3f7f466bfa08f75debddda94ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193610))
- [Update pipeline inputs view](https://gitlab.com/gitlab-org/gitlab/-/commit/f862064b9115a52b35bd88d791d813c9e9199453) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193286))
- [Allow adding comments to project_compliance_violations](https://gitlab.com/gitlab-org/gitlab/-/commit/59fc3735fa7e81de0a9849286a45fe096439ecc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193065)) **GitLab Enterprise Edition**
- [Add learn more button to the banner](https://gitlab.com/gitlab-org/gitlab/-/commit/906e932443412e7678273b42f12fd9ef322a1b0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193573)) **GitLab Enterprise Edition**
- [Add packages_composer_packages database table](https://gitlab.com/gitlab-org/gitlab/-/commit/ea100a16ea7505e1ac99b004908ca39c22dbdc0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186126))
- [Add index on provider, sync_status to ldap_admin_role_links table](https://gitlab.com/gitlab-org/gitlab/-/commit/c6bde1469358684405c18bb69b6962ccb77b8aa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193554))
- [Query work item statuses for a namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/8524f8987d1da8901857f8fd80642ceb72b98c2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191897)) **GitLab Enterprise Edition**
- [Cache and restore Work Item sidebar widgets during create](https://gitlab.com/gitlab-org/gitlab/-/commit/1a02ad8a0d7b9dba82a1d0a25a9cad2761da9d81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192301))
- [Fix and requeue analyzer status backfill migration](https://gitlab.com/gitlab-org/gitlab/-/commit/6b597bec3ffc17ab6b2d5045e5e7458da0cc92ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193293)) **GitLab Enterprise Edition**
- [Drop 2 unused indexes](https://gitlab.com/gitlab-org/gitlab/-/commit/4ac59c6b59f386f606fc08ce8a6bcd603b75f533) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193504))
- [Add event and metric for GET groups/:id/enterprise_users](https://gitlab.com/gitlab-org/gitlab/-/commit/76ac4d9498214115bb30ef849bfaa14d3b80c66a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191615)) **GitLab Enterprise Edition**
- [Remove FF auto_enable_duo_core_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/04edce4a00295e6ad67d508c149012e0eb2c9fe7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193438)) **GitLab Enterprise Edition**
- [Add branch pattern editor](https://gitlab.com/gitlab-org/gitlab/-/commit/bcab3a33424c6234f5d9ab08a8fac7fe0779e794) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193063)) **GitLab Enterprise Edition**
- [Expose policy options for runner jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/9e450d9b0e2e3983ebc173918206256ec9c9ea61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193187)) **GitLab Enterprise Edition**
- [Add support for placeholder variables in markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/147d21d4ea29b7da2efabb60d57d11fdc0bc3e0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186028))
- [Introduce LicensedFeatures field](https://gitlab.com/gitlab-org/gitlab/-/commit/5397562376e4183a48ecfd63162ec6ffc4831236) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192188))
- [Add oid column to lfs_objects_projects](https://gitlab.com/gitlab-org/gitlab/-/commit/a6df38c1ffd20935af1b513ae1c24ef8938e7ed2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192839))
- [Add AWS Secrets Manager Support](https://gitlab.com/gitlab-org/gitlab/-/commit/e7289eb8d688b7458fa61e4c73f8fd8d57fd3aab) by @DerAstronaut ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191780)) **GitLab Enterprise Edition**
- [Add pagination to a policy list](https://gitlab.com/gitlab-org/gitlab/-/commit/eac228e4489ea7393b359631c76d297eecb45672) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190376)) **GitLab Enterprise Edition**
- [Update work item titles to show html version](https://gitlab.com/gitlab-org/gitlab/-/commit/2bf359303c88f85edcf660505e200a732e3b4292) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187577))
- [Add Activatible concern for audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/9279602f955525919765a3598bf072ccca6992ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190737)) **GitLab Enterprise Edition**
- [Enable security_policies_optional_variables_control by default](https://gitlab.com/gitlab-org/gitlab/-/commit/8827864cfac543024b0d3d47682b3620774587f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193282)) **GitLab Enterprise Edition**
- [Add a `jsonb` column to `vulnerability_exports` table](https://gitlab.com/gitlab-org/gitlab/-/commit/7a9481118043804cf9b389edfc51f96bca71689c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192895)) **GitLab Enterprise Edition**
- [Add license check for work item detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/34eb3cda749d48ad608acd694000e6df2035b9b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192467))
- [Add sync info to admin role ldap sync table](https://gitlab.com/gitlab-org/gitlab/-/commit/8441ae61ab1aa86f2540949b060e5fc83d4ad4a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191695)) **GitLab Enterprise Edition**
- [Add migration to correct vulnerabilities transitioned by auto-resolve](https://gitlab.com/gitlab-org/gitlab/-/commit/9a27e91d317e371afa74be021b309391cfee57a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190859))
- [Update analyzer_namespace_status on project archive event](https://gitlab.com/gitlab-org/gitlab/-/commit/a6628782dc384efaa5527494d64d078bfd4b68ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191931)) **GitLab Enterprise Edition**
- [Add policy exceptions selector](https://gitlab.com/gitlab-org/gitlab/-/commit/191b43c7f01acba4f3b53616acd32d61c3ca99a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192723)) **GitLab Enterprise Edition**
- [Add name column to CI pipeline tables in ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/1a15cb572d6632f700ccb4a7b38ed710b19993d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190848))
- [Add runner tokens to validity checks](https://gitlab.com/gitlab-org/gitlab/-/commit/ec671e3818beb3af098eaf77a66ba90782b7dfde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192314)) **GitLab Enterprise Edition**
- [Hide CRM Contacts widget when source group has no contacts](https://gitlab.com/gitlab-org/gitlab/-/commit/654d2c2eb657565400faf2aebf79cb7abf01d41f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192935))
- [Created index for project violation for created](https://gitlab.com/gitlab-org/gitlab/-/commit/a45d6d070827bb0ea5b8fd7eeacd86e1e9a9cf10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192746)) **GitLab Enterprise Edition**
- [Build dependency graphs after ingesting SBoM report](https://gitlab.com/gitlab-org/gitlab/-/commit/d5eabfecf1b5c95812446225c0e4d4aa22f881d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184472)) **GitLab Enterprise Edition**
- [Expose prometheus-type HTTP alert integrations in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/0009bb74d4342f63b4e853b5a0a103a322b1e678) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129758))
- [Add created_by/updated_by to lifecycle and status](https://gitlab.com/gitlab-org/gitlab/-/commit/875763bd1095c9ed3b2b6cbf9be28591c8ab2ac4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192866)) **GitLab Enterprise Edition**
- [Add not_configured counter to AnalyzerGroupStatusType in graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/2f4d627a04f87bafde23e7ba09d0a45433800117) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192207)) **GitLab Enterprise Edition**
- [Remove duo_code_review_multi_file feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/76fdd56e5359cf033f431aeb16382837ed3dca6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192762)) **GitLab Enterprise Edition**
- [Query work item lifecycles for a namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/317b5c92fef13dff126f5482fd75ed3ab18463a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192196))
- [Support creating board lists with status values](https://gitlab.com/gitlab-org/gitlab/-/commit/8a7bb199fa5a24e462406c0ba64a27c0b76e8381) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189433)) **GitLab Enterprise Edition**
- [Enable version filtering by default](https://gitlab.com/gitlab-org/gitlab/-/commit/e6f56225ee250500044bffac540a45068daf6a63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192291)) **GitLab Enterprise Edition**
- [Adding glab CLI event tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/975a25c811298c8cc2fdf4d3b7ae433bc453e597) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190595))
- [Add status list filtering in issue boards](https://gitlab.com/gitlab-org/gitlab/-/commit/98fa3a63a69401eec465b14c180c2bf2daaa74cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191720))
- [Add lazy-load to projects & requirements section](https://gitlab.com/gitlab-org/gitlab/-/commit/c4ca27859f3abd2c970745aeee87a96a940bcf8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192613)) **GitLab Enterprise Edition**
- [Add group delete event handler](https://gitlab.com/gitlab-org/gitlab/-/commit/236605dc031e1450c9c0bb656656308e8aa7e317) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191189)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/6a4d3c948fde71a3b97c4aaed6dd6703708fb982) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192608))
- [Enable group hierarchy lookup optimization](https://gitlab.com/gitlab-org/gitlab/-/commit/2d4b28fc0e08c7b30930467ed1868358312e14db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188379))
- [Display only project-specific data in project compliance center](https://gitlab.com/gitlab-org/gitlab/-/commit/e875cb96611aeda872f64fad86630db4fb0348a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192598)) **GitLab Enterprise Edition**
- [Add project_count field to User type in Graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/d1c2fcfd74a9575590d90703eaf8cb42c3c42ab9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191450))
- [Configure delete_limit of async delete pipelines for deleted triggers](https://gitlab.com/gitlab-org/gitlab/-/commit/e4b0b6db4836bcb40500462f6a4b4438a4a67dda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192206))
- [Paginate requirements in framework edit sectino](https://gitlab.com/gitlab-org/gitlab/-/commit/f17a4bfd2babdd36512d91f4c135ceb9024922af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192403)) **GitLab Enterprise Edition**
- [Add project_id index on p_ci_pipeline_variables](https://gitlab.com/gitlab-org/gitlab/-/commit/dbd7f6e44cd631eb42dbe9d2365e387d37fa8191) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191736))
- [Adding documentation for Experimental Feature](https://gitlab.com/gitlab-org/gitlab/-/commit/78149c8d4327d0f2a8f32860965737e0b5cca6b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191104))
- [Small UI changes for long status names](https://gitlab.com/gitlab-org/gitlab/-/commit/a506573b2f3aa883039441ca13fa94d900b0e0b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192462)) **GitLab Enterprise Edition**
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/f662f9b23f702298812320c60b368a82a163568c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192458))
- [Adds groupRunnersEnabled to CiCdSettings GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/19b7deecd3148655a8eb5ebcb1d1ca346aebe523) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192202))
- [Add knowledge graph models](https://gitlab.com/gitlab-org/gitlab/-/commit/adb9697105d13e8530516292e561ad231885a64f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191162)) **GitLab Enterprise Edition**
- [Add namespace analyzer status alignment service](https://gitlab.com/gitlab-org/gitlab/-/commit/537e53011a34c1e5ceb1753bffe98aad4c8ecf97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189363)) **GitLab Enterprise Edition**
- [Allows users to bulk pause/unpause runners in runner lists](https://gitlab.com/gitlab-org/gitlab/-/commit/bdf0713c958bd67d780e6e3dad9ab74f0797773e) by @tonton1728 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187903))
- [Call create mutation when admin role LDAP sync form is submitted](https://gitlab.com/gitlab-org/gitlab/-/commit/9e6fce71ec06998181e5f75df757dc0bb8a19173) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191420)) **GitLab Enterprise Edition**
- [Evaluate project statuses on requirement update](https://gitlab.com/gitlab-org/gitlab/-/commit/63b7004a5755fafbb9945b412c8c560e6b1a4c68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187512)) **GitLab Enterprise Edition**
- [Email/banner when compromised password is detected](https://gitlab.com/gitlab-org/gitlab/-/commit/08c4ee0ae9e29d692de57705c927b14c65d194a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191921)) **GitLab Enterprise Edition**
- [Add top_namespace_model_ref logic to request](https://gitlab.com/gitlab-org/gitlab/-/commit/6518a77380b51054f47df862563a7170042b8e0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191475)) **GitLab Enterprise Edition**
- [Code Context: use new unit prmitive](https://gitlab.com/gitlab-org/gitlab/-/commit/f36db6894bf37c28bce020696bdda4c64d4ee95e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191919)) **GitLab Enterprise Edition**
- [Add updatedAt field to graphql analyzer statuses types](https://gitlab.com/gitlab-org/gitlab/-/commit/fb99200bf1e040bfeb12bca8fd9ca1e7d7b13693) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192198)) **GitLab Enterprise Edition**
- [Add DuoWorkflowAction to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/3a7a7bb0233ceed22feed67737a2ca429ac6462f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191303)) **GitLab Enterprise Edition**
- [Add role dropdown to LDAP admin role sync form](https://gitlab.com/gitlab-org/gitlab/-/commit/a63e172f9b4979600548429ba67719413ec453df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191139)) **GitLab Enterprise Edition**
- [Show work item status badge in issue cards](https://gitlab.com/gitlab-org/gitlab/-/commit/7dd9347e8356079fdfa956ae9ce9b096359d1433) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191151))
- [Add csp_namespace_id to application settings](https://gitlab.com/gitlab-org/gitlab/-/commit/7922bf711c6c7b4eca134932a707c8f00c2fd26d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191298)) **GitLab Enterprise Edition**
- [Add script to create AI context migration files](https://gitlab.com/gitlab-org/gitlab/-/commit/92087a50c60fbb52bfaaa2427db5158dec70c8d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191791))
- [Pages live block](https://gitlab.com/gitlab-org/gitlab/-/commit/f725b0cd7220978fc487e3e98dd6a6b0e56c2adf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191809))
- [Updated resource_spec file](https://gitlab.com/gitlab-org/gitlab/-/commit/ccb7109080643ec0870732b8480780df4a17e62c) by @Syandell ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192092))
- [Add deploy token support to Validity checks](https://gitlab.com/gitlab-org/gitlab/-/commit/3fd5d5295c1af7c14aafc5127d1cdb1966bdb995) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187802)) **GitLab Enterprise Edition**
- [ActiveContext: add code embedding files](https://gitlab.com/gitlab-org/gitlab/-/commit/3377d9cd8d423a0f99dfe2cc4cc91a0223f39844) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190313)) **GitLab Enterprise Edition**
- [Add project_compliance_violations DB table](https://gitlab.com/gitlab-org/gitlab/-/commit/457cc8db280f361896232b89d56cf83379a96627) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191311)) **GitLab Enterprise Edition**
- [Add findingTokenStatus to Vulnerability GraphQL type](https://gitlab.com/gitlab-org/gitlab/-/commit/771305bdeae681fcf987f2d1d525d103a2357199) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190440)) **GitLab Enterprise Edition**
- [Protected packages: Generic package push protection](https://gitlab.com/gitlab-org/gitlab/-/commit/b9cf4a11ad09cb99940be2bd87875cabc6ebc0c7) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189435))
- [Add GitHub username to user profile](https://gitlab.com/gitlab-org/gitlab/-/commit/ebdabf763283691dc1c2d26f936e93e68fedc823) by @bufferoverflow ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190014))
- [Introduced policy for Duo Agentic Chat availability](https://gitlab.com/gitlab-org/gitlab/-/commit/e27cf22db0b65d499908771672af6a52208a0557) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191327)) **GitLab Enterprise Edition**
- [Add status widget definition to issue work item type](https://gitlab.com/gitlab-org/gitlab/-/commit/100925332bfd4fb2204f4832f7a437f2a84dc922) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189786))
- [Allow agent CI access sharing across top level groups](https://gitlab.com/gitlab-org/gitlab/-/commit/b1c81e29a83b203415d9c415d84e694aceb39437) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190769))
- [Add Irish to llist of selectable languages in the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/76506506e58d5758d65000b3294c35c7f7ee95fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191651))
- [Make groups GraphQL query countable and add `active` argument](https://gitlab.com/gitlab-org/gitlab/-/commit/030ef93f8710fb5220aa59e8f0b4af5ba5b670c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191398))
- [Remove track_sidekiq_concurrency_limit_execution FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5761e5c90a675b436ae2ce33eebd27a8711178ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191735))
- [Remove gitlab_managed_cluster_resources feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7c583424bdf53485cc3141e5bb98087cf3744cfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191718))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/485422d6051fdd3aed5f4ab1067673e1842366ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191714))
- [Add active column to audit event streaming destination tables](https://gitlab.com/gitlab-org/gitlab/-/commit/85371d8613a498dd49f3dc74aa025b63621c45e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191352)) **GitLab Enterprise Edition**
- [Sync group_push_rules on push_rules write operations](https://gitlab.com/gitlab-org/gitlab/-/commit/73968b211e8489b593df8c8046d7accfbe1c2361) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188143))
- [Add API endpoint to retrieve Conan package revisions](https://gitlab.com/gitlab-org/gitlab/-/commit/d5ce47a3f9d41746385b9e11e8d663279ad09fd8) by @mbo5be ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189380))
- [Add conan delete recipe_revision endpoint for v2](https://gitlab.com/gitlab-org/gitlab/-/commit/1659f1b3185b21011bd88db7eda3655ae88ed60b) by @mbo5be ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186073))
- [GraphQL: Allow retrieving pending jobs compatible with runner](https://gitlab.com/gitlab-org/gitlab/-/commit/d991ff886453569fe3f43f6a9ab73bb910875e75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191130))
- [Add FK on project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/4db3dceff24cb8116242829534cbe1613ef0da46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191546))
- [Add CompromisedPasswordDetection model and service](https://gitlab.com/gitlab-org/gitlab/-/commit/f0a50f2abd6733c24c6411de43c5e1f2cd90c21a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191112)) **GitLab Enterprise Edition**
- [Add "imported" field to WorkItemType](https://gitlab.com/gitlab-org/gitlab/-/commit/8da21cb86c5c98fe49581cba04b8c6bb2e9c36ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191494))
- [Add ability to filter project and group issues by status](https://gitlab.com/gitlab-org/gitlab/-/commit/fdc51e5cbc9210ff18df731ff6abed37d86e458d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189870))
- [Create index on MRDC synchronously](https://gitlab.com/gitlab-org/gitlab/-/commit/344b413592f00421fa7691dd321ebb9bc6acb031) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191446))
- [Add sync method radios to LDAP create sync form](https://gitlab.com/gitlab-org/gitlab/-/commit/037b21ce820b389810f97759b731e1588f2675b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190929)) **GitLab Enterprise Edition**
- [Add ServerFormGroup for admin role ldap sync form](https://gitlab.com/gitlab-org/gitlab/-/commit/6b32ffc8574473152d9d4f528b082b0147c409be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191164)) **GitLab Enterprise Edition**
- [Filter by access_levels in projects members GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/ec3f042f90ee5fd28d687cff3e40bf1129c58546) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190924))
- [Add bypass option widget](https://gitlab.com/gitlab-org/gitlab/-/commit/5d54d76f23957a2bc2241b7b8881f202a015156f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191160)) **GitLab Enterprise Edition**
- [Add group archived abilities policy](https://gitlab.com/gitlab-org/gitlab/-/commit/d8c427861a92d4fb0dfb24967359923f9e044c85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188742))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/9861466794a4eb9570ee318ae1d3d56491f31538) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191367))
- [Use Elasticsearch to fetch vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/b82b38b429c9298030b59a7d92926b3167f6d6ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190673)) **GitLab Enterprise Edition**
- [Add the zoekt setting to control parallel processes](https://gitlab.com/gitlab-org/gitlab/-/commit/33014e3157bb92071e095f515419901845407a85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191283)) **GitLab Enterprise Edition**
- [Translucent glass utility: Add option to pass bg color](https://gitlab.com/gitlab-org/gitlab/-/commit/420af7320347ecb651dc66b9a8d041c47806ed02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191133))
- [Protected packages: Helm chart push protection](https://gitlab.com/gitlab-org/gitlab/-/commit/8f778b6bc3cd26d94a4f9cb79beb9488d7ce00bd) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189801))
- [Refactor the Ci::Trigger.last_used](https://gitlab.com/gitlab-org/gitlab/-/commit/e3c62ced38005c2fec955b39b33dd6379ed5ad5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191124))
- [Use ES to fetch identifier names](https://gitlab.com/gitlab-org/gitlab/-/commit/9cc26b5e6849c704626cd8d3097366fb0dd4561f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189627)) **GitLab Enterprise Edition**
- [Updating Learn Gitlab with Get Familiar section](https://gitlab.com/gitlab-org/gitlab/-/commit/4f53f36cc7b93e096ea3d18fe97377e8f117b3c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190915)) **GitLab Enterprise Edition**
- [Fill project analyzer build_id column post pipeline execution](https://gitlab.com/gitlab-org/gitlab/-/commit/5eab5fed0e7637eda3de6d3eaa57a6d60967868d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191197)) **GitLab Enterprise Edition**
- [Use ES to fetch severity counts](https://gitlab.com/gitlab-org/gitlab/-/commit/fe4a66a03b169eaa47f3cccd64ad33e33444ae82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188597)) **GitLab Enterprise Edition**
- [Backfill software_license_policies with custom licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/17af9ac835eb78080833645d0ced997e33f86f60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190394)) **GitLab Enterprise Edition**
- [Add GraphQL mutation to assign or unassign projects to a runner](https://gitlab.com/gitlab-org/gitlab/-/commit/02fa9f8f31ad8a12e5c762fceb35f79e10a04b08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189579))
- [Show default selected status when creating a work item](https://gitlab.com/gitlab-org/gitlab/-/commit/155f606641c6e81e202bbf804cad441566d806f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190662)) **GitLab Enterprise Edition**
- [Remove cluster_agent_migrations feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/762d27780454d1b898c6b5f0b297f58a03144916) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190626))
- [Remove autocomplete_users_rate_limit FF](https://gitlab.com/gitlab-org/gitlab/-/commit/3ffe16584c4b799fedb32c1f1b9637cfb3b43cef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189015))
- [Extend the existing package license to](https://gitlab.com/gitlab-org/gitlab/-/commit/d935664b967af4d3e503b91d1ae8c4a60aff85df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186258)) **GitLab Enterprise Edition**
- [Add merged date to work item  MR items](https://gitlab.com/gitlab-org/gitlab/-/commit/a8dc3056ea0dd6e170b777952bb816e96568f457) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190742))

### Fixed (204 changes)

- [Fix Value Stream form restore defaults button](https://gitlab.com/gitlab-org/gitlab/-/commit/4b16a7602e85569388429879a814e1b8a74f4cbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194074)) **GitLab Enterprise Edition**
- [Fix link to the docs page to create project with "git push"](https://gitlab.com/gitlab-org/gitlab/-/commit/3d4e9b7b965dc62a411ad9a09a07ddbf8d636bbb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193998))
- [Fix ref selector branch list](https://gitlab.com/gitlab-org/gitlab/-/commit/7825aea1c73912c7b537759b8ecba71e8c18397c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194570))
- [Only show restore link on project listing when pending deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/31222e087337ffe9ed34484835ea2e2380d5d63e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194534))
- [Make all scanner variables additional variables](https://gitlab.com/gitlab-org/gitlab/-/commit/e9fa61f5f781f88db55cabc427e516b85cfa76e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193522)) **GitLab Enterprise Edition**
- [Ensure overage modal appears for Projects](https://gitlab.com/gitlab-org/gitlab/-/commit/eaf8a4b269ad261319f71b692f174f0b1eec54dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192949))
- [Add data points to Value Stream Analytics overview chart](https://gitlab.com/gitlab-org/gitlab/-/commit/3a0c9e1f237bb9d0693ebf71919ec32929293532) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194497)) **GitLab Enterprise Edition**
- [Handle situation where match line is after target line](https://gitlab.com/gitlab-org/gitlab/-/commit/955a328194a75146dda66de34ca93496ec6c8c97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194243))
- [Fix stuck mirrors logic](https://gitlab.com/gitlab-org/gitlab/-/commit/0ad32c7903f3ca5051593a6337e229a6364eda35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194478)) **GitLab Enterprise Edition**
- [Fix PowerShell variable expansion in Windows release scripts](https://gitlab.com/gitlab-org/gitlab/-/commit/4f529d8786afb882d0ce78a14b506a64b70cd026) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194450))
- [Make `any_merge_request` approval policy rules respect branch spec](https://gitlab.com/gitlab-org/gitlab/-/commit/fade41e234b86f52137d0be7becf89d7f8070a6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191989)) **GitLab Enterprise Edition**
- [Issue boards: Fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/d99122306a5a5349b2e37fc2c4289ff82e64cdd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194170))
- [Activity lists: List should be marked as such (a11y fix)](https://gitlab.com/gitlab-org/gitlab/-/commit/83e0a3afa6dbb0fc82b82238deb9539539fadef0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194435))
- [Pipeline editor visualize tab: Fix a11y issue with heading](https://gitlab.com/gitlab-org/gitlab/-/commit/7d9ddd64eb66e0f609bb4bf9db93542479f741cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194429))
- [Fix wrong check on displaying passed status in popup](https://gitlab.com/gitlab-org/gitlab/-/commit/5c1039830f28251d6708957ff9d9df5e3b9a5648) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194421)) **GitLab Enterprise Edition**
- [Restrict adding a forward slash to node name](https://gitlab.com/gitlab-org/gitlab/-/commit/8ff2a30b41d691891f4fc827cd7c4e5d44d7e3db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/191833)) **GitLab Enterprise Edition**
- [Fix stop button in MR widget](https://gitlab.com/gitlab-org/gitlab/-/commit/188529ecd18d4ec12cc45fad3b11008ebccd7bfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194317))
- [Disable using glab for CI release](https://gitlab.com/gitlab-org/gitlab/-/commit/715a8311fa838f395fc48ae29c1c3c3d57d12b25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194341))
- [Maintain label sorting when LabelLinks exist on Epic and WorkItem](https://gitlab.com/gitlab-org/gitlab/-/commit/39d7656f6b0cb7e117d89016469c351022ec1770) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194227))
- [File diff: Fix border radius issue with lighter syntax themes](https://gitlab.com/gitlab-org/gitlab/-/commit/aae2e3124d8eeb8e6ad3a0642705deada187b8c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194312))
- [Backfill placeholder users that miss an organization](https://gitlab.com/gitlab-org/gitlab/-/commit/8da4cee10b76b89ed19667cb0f524dedce2d6163) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193458))
- [Fix security policy sync workers to use string keys for params](https://gitlab.com/gitlab-org/gitlab/-/commit/c953d9c1918f0c1867f9475ead935d673d089c89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194173)) **GitLab Enterprise Edition**
- [Fix uppercase secret detection report type](https://gitlab.com/gitlab-org/gitlab/-/commit/797ecbcf1277e97c23c88a121fc52c993811dd81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194253)) **GitLab Enterprise Edition**
- [Make selected only toggle use backend for filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/6ed1bacff11dbfd1bf681e5295faa5b4e9bcbf90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194174)) **GitLab Enterprise Edition**
- [Identify error for scope value field in issue boards](https://gitlab.com/gitlab-org/gitlab/-/commit/7512069162868d9dd413ae1caad56688934e68fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193038))
- [Fix issue board content wrapping](https://gitlab.com/gitlab-org/gitlab/-/commit/b2b0c3fc154761d85aceec7ec0c958073b5ae706) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194218))
- [Ensure scoped labels display properly in source code md preview](https://gitlab.com/gitlab-org/gitlab/-/commit/1ea5c9cef0278799284a271b86a19a6dc950b357) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194201))
- [Fix error when fetching all policies by type](https://gitlab.com/gitlab-org/gitlab/-/commit/c8d21048908dd19eefd39119a97f838294434b89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193216)) **GitLab Enterprise Edition**
- [Adds missing h1 to branches, commits and snippets pages](https://gitlab.com/gitlab-org/gitlab/-/commit/1f03d3b46b60458cb6dc8fccfad5afbf945a7dc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194187))
- [Iteration cadences: Fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/fb56fa7e3ed8aeed9fcb4705661b83b4088b1690) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194175))
- [Milestones a11y fix: Add missing h1](https://gitlab.com/gitlab-org/gitlab/-/commit/a8dccfb56b46265b80b145242ac23dcde4ca40d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194172))
- [Labels page: Fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/b2b4da37615a70e60959d3299b03394bf3765253) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194164))
- [Acvitity pages: Add hidden h1](https://gitlab.com/gitlab-org/gitlab/-/commit/e2b330fa4ae566a4308d3049b0d94f4b46e47a3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194163))
- [Enable batch loading linked work items](https://gitlab.com/gitlab-org/gitlab/-/commit/76cac1e179b8a92f91e418d95ef847961d706343) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194130))
- [Environments page: Fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/4ab94abe61a9fb8e4612c8afddd75a82da873f3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194144))
- [Pass seat_control value to FE for non-licensed (EE) instances](https://gitlab.com/gitlab-org/gitlab/-/commit/b38172daa017c62555736cfb8713a83014dae326) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193562)) **GitLab Enterprise Edition**
- [GLQL table shadow fix (darkmode)](https://gitlab.com/gitlab-org/gitlab/-/commit/515593d6e2b81f7963d2719e6719fcbc3b06236a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194026))
- [Avoid extra line when no actions](https://gitlab.com/gitlab-org/gitlab/-/commit/f183b763b4033aa1b4495c3a2d90ed1e5cdd4111) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193355))
- [Prevent value dropdown from overflowing](https://gitlab.com/gitlab-org/gitlab/-/commit/c2b80f6377fbd8ea352c51b1b65a67b932f4fcd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194058))
- [Fix line number in zoekt results](https://gitlab.com/gitlab-org/gitlab/-/commit/de8b998845e78f495dc0c2667fc0ba63f0647cba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192929)) **GitLab Enterprise Edition**
- [Add active nav state to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/0902014ab9455e28009d6918118a4e2edb8063d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193936))
- [Add support for ADDITIONAL_CA_CERT_BUNDLE in glab releases](https://gitlab.com/gitlab-org/gitlab/-/commit/163761b484ed716dd4fa3eecfa0e78402ea1b16a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193000))
- [Fix incorrect redirect when branch doesn't include files](https://gitlab.com/gitlab-org/gitlab/-/commit/8b8c4088437903b987ed14acc4a322ae71e2bc1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193993))
- [Explicitly normalize timestamps to use UTC timezone](https://gitlab.com/gitlab-org/gitlab/-/commit/e3b5081542496b905584afa13b4f07ad1f278eed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192821)) **GitLab Enterprise Edition**
- [Limit Validity Checks to Only Display on Secret Detection Reports](https://gitlab.com/gitlab-org/gitlab/-/commit/a639948502714d012ded63ff32900116a5eba2b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193836)) **GitLab Enterprise Edition**
- [Fix NamespaceStatistics total counter](https://gitlab.com/gitlab-org/gitlab/-/commit/b605b80b4ee90ba1601664b121b494c785a05920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193845)) **GitLab Enterprise Edition**
- [Transform epic data source properly](https://gitlab.com/gitlab-org/gitlab/-/commit/f871920bf66ff1946a17210884a89de7edaaa54f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193827))
- [Fix border radius of failed jobs widget; update hover state](https://gitlab.com/gitlab-org/gitlab/-/commit/648958ce0fea0a3b0bd3f2a74d4e6997d4132d5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193807))
- [Fix race condition / segfault in the glab release command](https://gitlab.com/gitlab-org/gitlab/-/commit/3ce96c1e151e382082f95340ba990e0bd6c0bd4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193796))
- [Fixing Coverage-Check automatically being approved](https://gitlab.com/gitlab-org/gitlab/-/commit/ccdbb46054b4a6a6673efe200e906b2dd06e01a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193541)) **GitLab Enterprise Edition**
- [Fix incorrect log formatting of variables_override without exceptions](https://gitlab.com/gitlab-org/gitlab/-/commit/290f5623d15a91ee05cddef8e4dc5d7c218c707a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193757)) **GitLab Enterprise Edition**
- [Intersperse collection of items with a space](https://gitlab.com/gitlab-org/gitlab/-/commit/b2b334149c58978ad0b179a19ef7d822f4f42518) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193741))
- [Recover when a partition is missing from the current state](https://gitlab.com/gitlab-org/gitlab/-/commit/88189b1ded675d3eccc011c2210d1573de3540b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193727))
- [Add new notification](https://gitlab.com/gitlab-org/gitlab/-/commit/91c5efcbacc39bf2641c513377071a58c1762940) ([merge request](https://