---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Missing Content-Type header
---

## Description

The `Content-Type` header ensures that user agents correctly interpret the data being received. Without this header
being sent, the browser may misinterpret the data, leading to MIME confusion attacks. If an attacker were able
to upload files that are accessible by using a browser, they could upload files that may be interpreted as
HTML and so execute Cross-Site Scripting (XSS) attacks.

## Remediation

Ensure all resources return a proper `Content-Type` header that matches their format. As an example,
when returning JavaScript files, the response header should be: `Content-Type: application/javascript`

For added protection, all resources should return the `X-Content-Type-Options: nosniff`
header to disable user agents from mis-interpreting resources.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 16.1 | true | 16 | Passive | Low |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/16.html)
- [Mozilla Blog on MIME Confusion attacks](https://blog.mozilla.org/security/2016/08/26/mitigating-mime-confusion-attacks-in-firefox/)
