/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.emptyMethod;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.options.JavaClassValidator;
import com.intellij.codeInspection.AddToInspectionOptionListFix;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFunctionalExpression;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefOverridable;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.SpecialAnnotationsUtilBase;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public final class EmptyMethodInspection
extends GlobalJavaBatchInspectionTool {
    @NonNls
    private static final String SHORT_NAME = "EmptyMethod";
    private static final ExtensionPointName<Condition<RefMethod>> CAN_BE_EMPTY_EP = new ExtensionPointName("com.intellij.canBeEmpty");
    public final JDOMExternalizableStringList EXCLUDE_ANNOS = new JDOMExternalizableStringList();
    public boolean commentsAreContent = false;
    private static final Logger LOG = Logger.getInstance(EmptyMethodInspection.class);

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity == null) {
            EmptyMethodInspection.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            EmptyMethodInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            EmptyMethodInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            EmptyMethodInspection.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            EmptyMethodInspection.$$$reportNull$$$0(4);
        }
        if (!(refEntity instanceof RefMethod)) {
            return null;
        }
        RefMethod refMethod = (RefMethod)refEntity;
        if (!this.isBodyEmpty(refMethod)) {
            return null;
        }
        if (refMethod.isConstructor()) {
            return null;
        }
        if (refMethod.isSyntheticJSP()) {
            return null;
        }
        for (RefMethod refSuper : refMethod.getSuperMethods()) {
            if (this.checkElement((RefEntity)refSuper, scope, manager, globalContext, processor) == null) continue;
            return null;
        }
        String message = null;
        boolean needToDeleteHierarchy = false;
        RefMethod refSuper = EmptyMethodInspection.findSuperWithBody(refMethod);
        if (refMethod.isOnlyCallsSuper() && !refMethod.isFinal()) {
            RefJavaUtil refUtil = RefJavaUtil.getInstance();
            if (refSuper != null && Comparing.strEqual((String)refMethod.getAccessModifier(), (String)refSuper.getAccessModifier())) {
                PsiModifierListOwner supMethod;
                PsiModifierList list;
                if (Comparing.strEqual((String)refSuper.getAccessModifier(), (String)"protected") && !Comparing.strEqual((String)refUtil.getPackageName((RefEntity)refSuper), (String)refUtil.getPackageName((RefEntity)refMethod))) {
                    return null;
                }
                PsiModifierListOwner javaPsi = EmptyMethodInspection.getAsJavaPsi(refMethod);
                if (javaPsi != null && (list = javaPsi.getModifierList()) != null && (supMethod = EmptyMethodInspection.getAsJavaPsi(refSuper)) != null) {
                    PsiModifierList superModifiedList = supMethod.getModifierList();
                    LOG.assertTrue(superModifiedList != null);
                    if (list.hasModifierProperty("synchronized") && !superModifiedList.hasModifierProperty("synchronized")) {
                        return null;
                    }
                }
            }
            if (refSuper == null || refUtil.compareAccess(refMethod.getAccessModifier(), refSuper.getAccessModifier()) <= 0) {
                message = JvmAnalysisBundle.message("inspection.empty.method.problem.descriptor", new Object[0]);
            }
        } else if (refMethod.hasBody() && this.hasEmptySuperImplementation(refMethod)) {
            message = JvmAnalysisBundle.message("inspection.empty.method.problem.descriptor1", new Object[0]);
        } else if (refSuper == null && this.areAllImplementationsEmpty((RefOverridable)refMethod)) {
            if (refMethod.hasBody()) {
                if (refMethod.getDerivedMethods().isEmpty()) {
                    if (refMethod.getSuperMethods().isEmpty()) {
                        message = JvmAnalysisBundle.message("inspection.empty.method.problem.descriptor2", new Object[0]);
                    }
                } else {
                    needToDeleteHierarchy = true;
                    message = JvmAnalysisBundle.message("inspection.empty.method.problem.descriptor3", new Object[0]);
                }
            } else if (!refMethod.getDerivedReferences().isEmpty()) {
                needToDeleteHierarchy = true;
                message = JvmAnalysisBundle.message("inspection.empty.method.problem.descriptor4", new Object[0]);
            }
        }
        if (message != null) {
            PsiElement anchor;
            PsiElement psi;
            GlobalInspectionContextBase globalInspectionContextBase;
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            fixes.add(EmptyMethodInspection.getFix(processor, needToDeleteHierarchy));
            if (globalContext instanceof GlobalInspectionContextBase && (globalInspectionContextBase = (GlobalInspectionContextBase)globalContext).getCurrentProfile().getSingleTool() == null && (psi = refMethod.getPsiElement()) instanceof PsiModifierListOwner) {
                PsiModifierListOwner owner = (PsiModifierListOwner)psi;
                SpecialAnnotationsUtilBase.processUnknownAnnotations((PsiModifierListOwner)owner, qualifiedName -> {
                    fixes.add((LocalQuickFix)new AddToInspectionOptionListFix((InspectionProfileEntry)this, QuickFixBundle.message((String)"fix.add.special.annotation.text", (Object[])new Object[]{qualifiedName}), qualifiedName, insp -> insp.EXCLUDE_ANNOS));
                    return true;
                });
            }
            if ((anchor = UDeclarationKt.getAnchorPsi((UDeclaration)refMethod.getUastElement())) != null) {
                ProblemDescriptor descriptor = manager.createProblemDescriptor(anchor, message, false, fixes.toArray(LocalQuickFix.EMPTY_ARRAY), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                return new ProblemDescriptor[]{descriptor};
            }
        }
        return null;
    }

    private static PsiModifierListOwner getAsJavaPsi(RefMethod refMethod) {
        UMethod uMethod = refMethod.getUastElement();
        if (uMethod == null) {
            return null;
        }
        return uMethod.getJavaPsi();
    }

    private boolean isBodyEmpty(RefMethod refMethod) {
        if (!refMethod.isBodyEmpty()) {
            return false;
        }
        PsiModifierListOwner owner = EmptyMethodInspection.getAsJavaPsi(refMethod);
        if (owner == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (Collection)this.EXCLUDE_ANNOS, (int)0)) {
            return false;
        }
        if (CAN_BE_EMPTY_EP.findFirstSafe(condition -> condition.value((Object)refMethod)) != null) {
            return false;
        }
        return !this.commentsAreContent || PsiTreeUtil.findChildOfType((PsiElement)owner, PsiComment.class) == null;
    }

    @Nullable
    private static RefMethod findSuperWithBody(RefMethod refMethod) {
        for (RefMethod refSuper : refMethod.getSuperMethods()) {
            if (!refSuper.hasBody()) continue;
            return refSuper;
        }
        return null;
    }

    private boolean areAllImplementationsEmpty(@NotNull RefOverridable reference) {
        RefFunctionalExpression refFunctionalExpression;
        RefMethod refMethod;
        if (reference == null) {
            EmptyMethodInspection.$$$reportNull$$$0(5);
        }
        if (reference instanceof RefMethod ? (refMethod = (RefMethod)reference).hasBody() && !this.isBodyEmpty(refMethod) : reference instanceof RefFunctionalExpression && !(refFunctionalExpression = (RefFunctionalExpression)reference).hasEmptyBody()) {
            return false;
        }
        for (RefOverridable derivedReference : reference.getDerivedReferences()) {
            if (this.areAllImplementationsEmpty(derivedReference)) continue;
            return false;
        }
        return true;
    }

    private boolean hasEmptySuperImplementation(RefMethod refMethod) {
        for (RefMethod refSuper : refMethod.getSuperMethods()) {
            if (!refSuper.hasBody() || !this.isBodyEmpty(refSuper)) continue;
            return true;
        }
        return false;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext context, final @NotNull ProblemDescriptionsProcessor descriptionsProcessor) {
        if (manager == null) {
            EmptyMethodInspection.$$$reportNull$$$0(6);
        }
        if (context == null) {
            EmptyMethodInspection.$$$reportNull$$$0(7);
        }
        if (descriptionsProcessor == null) {
            EmptyMethodInspection.$$$reportNull$$$0(8);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitMethod(@NotNull RefMethod refMethod) {
                if (refMethod == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (descriptionsProcessor.getDescriptions((RefEntity)refMethod) == null) {
                    return;
                }
                if ("private".equals(refMethod.getAccessModifier())) {
                    return;
                }
                context.enqueueDerivedMethodsProcessor(refMethod, derivedMethod -> {
                    UMethod uDerivedMethod = (UMethod)UastContextKt.toUElement((PsiElement)derivedMethod, UMethod.class);
                    if (uDerivedMethod == null) {
                        return true;
                    }
                    UExpression body = uDerivedMethod.getUastBody();
                    if (RefMethodImpl.isEmptyExpression((UExpression)body)) {
                        return true;
                    }
                    if (RefJavaUtil.getInstance().isMethodOnlyCallsSuper(uDerivedMethod)) {
                        return true;
                    }
                    descriptionsProcessor.ignoreElement((RefEntity)refMethod);
                    return false;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$1", "visitMethod"));
            }
        });
        return false;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
        if (string == null) {
            EmptyMethodInspection.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            EmptyMethodInspection.$$$reportNull$$$0(10);
        }
        if (!this.EXCLUDE_ANNOS.isEmpty() || this.commentsAreContent) {
            super.writeSettings(node);
        }
    }

    private static LocalQuickFix getFix(ProblemDescriptionsProcessor processor, boolean needToDeleteHierarchy) {
        return new DeleteMethodQuickFix(processor, needToDeleteHierarchy);
    }

    public String getHint(@NotNull QuickFix fix) {
        if (fix == null) {
            EmptyMethodInspection.$$$reportNull$$$0(11);
        }
        if (fix instanceof DeleteMethodQuickFix) {
            DeleteMethodQuickFix deleteMethodQuickFix = (DeleteMethodQuickFix)fix;
            return String.valueOf(deleteMethodQuickFix.myNeedToDeleteHierarchy);
        }
        return null;
    }

    @NotNull
    public LocalQuickFix getQuickFix(String hint) {
        return new DeleteMethodIntention(hint);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"commentsAreContent", (String)JvmAnalysisBundle.message("checkbox.comments.and.javadoc.count.as.content", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.stringList((String)"EXCLUDE_ANNOS", (String)JavaBundle.message((String)"special.annotations.annotations.list", (Object[])new Object[0]), (StringValidator)new JavaClassValidator().annotationsOnly())});
        if (optPane == null) {
            EmptyMethodInspection.$$$reportNull$$$0(12);
        }
        return optPane;
    }

    @IntentionFamilyName
    private static String getQuickFixName() {
        return JvmAnalysisBundle.message("inspection.empty.method.delete.quickfix", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionsProcessor";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areAllImplementationsEmpty";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
            case 9: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 12 -> new IllegalStateException(string);
        };
    }

    private static final class DeleteMethodQuickFix
    implements LocalQuickFix,
    BatchQuickFix {
        private final ProblemDescriptionsProcessor myProcessor;
        private final boolean myNeedToDeleteHierarchy;

        private DeleteMethodQuickFix(ProblemDescriptionsProcessor processor, boolean needToDeleteHierarchy) {
            this.myProcessor = processor;
            this.myNeedToDeleteHierarchy = needToDeleteHierarchy;
        }

        @NotNull
        public String getFamilyName() {
            String string = EmptyMethodInspection.getQuickFixName();
            if (string == null) {
                DeleteMethodQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                DeleteMethodQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                DeleteMethodQuickFix.$$$reportNull$$$0(2);
            }
            this.applyFix(project, (CommonProblemDescriptor[])new ProblemDescriptor[]{descriptor}, List.of(), null);
        }

        private static void deleteHierarchy(RefMethod refMethod, List<? super PsiElement> result) {
            RefMethod[] refMethods;
            Collection derivedMethods = refMethod.getDerivedMethods();
            for (RefMethod refDerived : refMethods = derivedMethods.toArray(new RefMethod[0])) {
                DeleteMethodQuickFix.deleteMethod(refDerived, result);
            }
            DeleteMethodQuickFix.deleteMethod(refMethod, result);
        }

        private static void deleteMethod(RefMethod refMethod, List<? super PsiElement> result) {
            PsiElement psiElement = refMethod.getPsiElement();
            if (psiElement == null) {
                return;
            }
            if (!result.contains(psiElement)) {
                result.add((PsiElement)psiElement);
            }
        }

        public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            if (project == null) {
                DeleteMethodQuickFix.$$$reportNull$$$0(3);
            }
            if (psiElementsToIgnore == null) {
                DeleteMethodQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptors == null) {
                DeleteMethodQuickFix.$$$reportNull$$$0(5);
            }
            for (CommonProblemDescriptor descriptor : descriptors) {
                RefElement refElement = (RefElement)this.myProcessor.getElement(descriptor);
                if (!(refElement instanceof RefMethod)) continue;
                RefMethod refMethod = (RefMethod)refElement;
                if (!refElement.isValid()) continue;
                if (this.myNeedToDeleteHierarchy) {
                    DeleteMethodQuickFix.deleteHierarchy(refMethod, psiElementsToIgnore);
                    continue;
                }
                DeleteMethodQuickFix.deleteMethod(refMethod, psiElementsToIgnore);
            }
            ApplicationManager.getApplication().invokeLater(() -> SafeDeleteHandler.invoke((Project)project, (PsiElement[])PsiUtilCore.toPsiElementArray((Collection)psiElementsToIgnore), (boolean)false, (Runnable)refreshViews), project.getDisposed());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElementsToIgnore";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class DeleteMethodIntention
    implements LocalQuickFix {
        private final String myHint;

        DeleteMethodIntention(String hint) {
            this.myHint = hint;
        }

        @NotNull
        public String getFamilyName() {
            String string = EmptyMethodInspection.getQuickFixName();
            if (string == null) {
                DeleteMethodIntention.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethod psiMethod;
            if (project == null) {
                DeleteMethodIntention.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                DeleteMethodIntention.$$$reportNull$$$0(2);
            }
            if ((psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class, (boolean)false)) != null) {
                ArrayList<PsiMethod> psiElements = new ArrayList<PsiMethod>();
                psiElements.add(psiMethod);
                if (Boolean.valueOf(this.myHint).booleanValue()) {
                    Query query = AllOverridingMethodsSearch.search((PsiClass)psiMethod.getContainingClass());
                    query.forEach(pair -> {
                        if (pair.first == psiMethod) {
                            psiElements.add((PsiMethod)((PsiElement)pair.second));
                        }
                        return true;
                    });
                }
                ApplicationManager.getApplication().invokeLater(() -> SafeDeleteHandler.invoke((Project)project, (PsiElement[])PsiUtilCore.toPsiElementArray((Collection)psiElements), (boolean)false), project.getDisposed());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodIntention";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodIntention";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

