/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.codeInsight.hint.DeclarationRangeUtil;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassBody;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPairMatcher;", "Lcom/intellij/lang/PairedBraceMatcher;", "<init>", "()V", "pairs", "", "Lcom/intellij/lang/BracePair;", "[Lcom/intellij/lang/BracePair;", "getPairs", "()[Lcom/intellij/lang/BracePair;", "isPairedBracesAllowedBeforeType", "", "lbraceType", "Lcom/intellij/psi/tree/IElementType;", "contextType", "getCodeConstructStart", "", "file", "Lcom/intellij/psi/PsiFile;", "openingBraceOffset", "kotlin.base.code-insight.minimal"})
public final class KotlinPairMatcher
implements PairedBraceMatcher {
    @NotNull
    private final BracePair[] pairs;

    public KotlinPairMatcher() {
        BracePair[] bracePairArray = new BracePair[]{new BracePair((IElementType)KDocTokens.KDOC_LPAR, (IElementType)KDocTokens.KDOC_RPAR, false), new BracePair((IElementType)KtTokens.LPAR, (IElementType)KtTokens.RPAR, false), new BracePair((IElementType)KtTokens.LONG_TEMPLATE_ENTRY_START, (IElementType)KtTokens.LONG_TEMPLATE_ENTRY_END, false), new BracePair((IElementType)KtTokens.LBRACE, (IElementType)KtTokens.RBRACE, true), new BracePair((IElementType)KtTokens.LBRACKET, (IElementType)KtTokens.RBRACKET, false), new BracePair((IElementType)KtTokens.LT, (IElementType)KtTokens.GT, false)};
        this.pairs = bracePairArray;
    }

    @NotNull
    public BracePair[] getPairs() {
        return this.pairs;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        Intrinsics.checkNotNullParameter((Object)lbraceType, (String)"lbraceType");
        return Intrinsics.areEqual((Object)lbraceType, (Object)KtTokens.LONG_TEMPLATE_ENTRY_START) ? false : KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(contextType) || contextType == KtTokens.COLON || contextType == KtTokens.SEMICOLON || contextType == KtTokens.COMMA || contextType == KtTokens.RPAR || contextType == KtTokens.RBRACKET || contextType == KtTokens.RBRACE || contextType == KtTokens.LBRACE || contextType == KtTokens.LONG_TEMPLATE_ENTRY_END;
    }

    public int getCodeConstructStart(@NotNull PsiFile file, int openingBraceOffset) {
        int n;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiElement element = file.findElementAt(openingBraceOffset);
        if (element == null || element instanceof PsiFile) {
            return openingBraceOffset;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof KtClassBody || Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)parent), (Object)KtNodeTypes.BLOCK)) {
            TextRange textRange = DeclarationRangeUtil.getPossibleDeclarationAtRange((PsiElement)parent.getParent());
            n = textRange != null ? textRange.getStartOffset() : openingBraceOffset;
        } else {
            n = openingBraceOffset;
        }
        return n;
    }
}

