/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.wire;

import java.util.Iterator;
import java.util.Map;
import org.jetbrains.kotlin.com.google.inject.name.Named;

final class NamedIterableAdapter<V>
implements Iterable<Map.Entry<String, V>> {
    private final Iterable<Map.Entry<Named, V>> delegate;

    NamedIterableAdapter(Iterable<Map.Entry<Named, V>> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterator<Map.Entry<String, V>> iterator() {
        return new NamedIterator<V>(this.delegate);
    }

    private static final class NamedEntry<V>
    implements Map.Entry<String, V> {
        private final Map.Entry<Named, V> entry;

        NamedEntry(Map.Entry<Named, V> entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            return this.entry.getKey().value();
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + this.getValue();
        }
    }

    private static final class NamedIterator<V>
    implements Iterator<Map.Entry<String, V>> {
        private final Iterator<Map.Entry<Named, V>> iterator;

        NamedIterator(Iterable<Map.Entry<Named, V>> iterable) {
            this.iterator = iterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            return new NamedEntry<V>(this.iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

