/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public final class GroovyLiteralSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            GroovyLiteralSelectioner.$$$reportNull$$$0(0);
        }
        PsiElement parent = e.getParent();
        return GroovyLiteralSelectioner.isLiteral(e) || GroovyLiteralSelectioner.isLiteral(parent);
    }

    private static boolean isLiteral(PsiElement element) {
        return element instanceof GrListOrMap || element instanceof GrArgumentLabel || element instanceof GrLiteral && ((GrLiteral)element).isString();
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (e == null) {
            GroovyLiteralSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            GroovyLiteralSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GroovyLiteralSelectioner.$$$reportNull$$$0(3);
        }
        List result2 = super.select(e, editorText, cursorOffset, editor);
        if (e instanceof GrListOrMap) {
            return result2;
        }
        assert (result2 != null);
        int startOffset = -1;
        int endOffset = -1;
        String text = e.getText();
        int stringOffset = e.getTextOffset();
        IElementType elementType = e.getNode().getElementType();
        if (elementType == GroovyTokenTypes.mGSTRING_CONTENT || elementType == GroovyTokenTypes.mREGEX_CONTENT || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT) {
            int cur;
            int index = -1;
            while ((cur = text.indexOf(10, index + 1)) >= 0 && cur + stringOffset <= cursorOffset) {
                index = cur;
            }
            if (index >= 0) {
                startOffset = stringOffset + index + 1;
            }
            if ((index = text.indexOf(10, cursorOffset - stringOffset)) >= 0) {
                endOffset = stringOffset + index + 1;
            }
        }
        if (startOffset >= 0 && endOffset >= 0) {
            result2.add(new TextRange(startOffset, endOffset));
        }
        String content = GrStringUtil.removeQuotes(text);
        String trimmedContent = content.trim();
        result2.addAll(GroovyLiteralSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)TextRange.from((int)(stringOffset + text.indexOf(trimmedContent)), (int)trimmedContent.length())));
        result2.add(TextRange.from((int)(stringOffset + text.indexOf(content)), (int)content.length()));
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/editor/selection/GroovyLiteralSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

