/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import java.io.Serializable;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;

public class NTV2GridShift
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double METRE_PER_SECOND = Math.PI * 2 * Ellipsoid.WGS84.a / 3600.0 / 360.0;
    private static final double RADIANS_PER_SECOND = 4.84813681109536E-6;
    private double lon;
    private double lat;
    private double lonShift;
    private double latShift;
    private double lonAccuracy;
    private double latAccuracy;
    private boolean latAccuracyAvailable;
    private boolean lonAccuracyAvailable;
    private String subGridName;

    public NTV2GridShift() {
    }

    public NTV2GridShift(LatLon p) {
        this.setLatDegrees(p.lat());
        this.setLonPositiveEastDegrees(p.lon());
    }

    public double getLatSeconds() {
        return this.lat;
    }

    public double getLatDegrees() {
        return this.lat / 3600.0;
    }

    public double getLatShiftSeconds() {
        return this.latShift;
    }

    public double getLatShiftDegrees() {
        return this.latShift / 3600.0;
    }

    public double getShiftedLatSeconds() {
        return this.lat + this.latShift;
    }

    public double getShiftedLatDegrees() {
        return (this.lat + this.latShift) / 3600.0;
    }

    public boolean isLatAccuracyAvailable() {
        return this.latAccuracyAvailable;
    }

    public double getLatAccuracySeconds() {
        if (!this.latAccuracyAvailable) {
            throw new IllegalStateException("Latitude Accuracy not available");
        }
        return this.latAccuracy;
    }

    public double getLatAccuracyDegrees() {
        if (!this.latAccuracyAvailable) {
            throw new IllegalStateException("Latitude Accuracy not available");
        }
        return this.latAccuracy / 3600.0;
    }

    public double getLatAccuracyMetres() {
        if (!this.latAccuracyAvailable) {
            throw new IllegalStateException("Latitude Accuracy not available");
        }
        return this.latAccuracy * METRE_PER_SECOND;
    }

    public double getLonPositiveWestSeconds() {
        return this.lon;
    }

    public double getLonPositiveEastDegrees() {
        return this.lon / -3600.0;
    }

    public double getLonShiftPositiveWestSeconds() {
        return this.lonShift;
    }

    public double getLonShiftPositiveEastDegrees() {
        return this.lonShift / -3600.0;
    }

    public double getShiftedLonPositiveWestSeconds() {
        return this.lon + this.lonShift;
    }

    public double getShiftedLonPositiveEastDegrees() {
        return (this.lon + this.lonShift) / -3600.0;
    }

    public boolean isLonAccuracyAvailable() {
        return this.lonAccuracyAvailable;
    }

    public double getLonAccuracySeconds() {
        if (!this.lonAccuracyAvailable) {
            throw new IllegalStateException("Longitude Accuracy not available");
        }
        return this.lonAccuracy;
    }

    public double getLonAccuracyDegrees() {
        if (!this.lonAccuracyAvailable) {
            throw new IllegalStateException("Longitude Accuracy not available");
        }
        return this.lonAccuracy / 3600.0;
    }

    public double getLonAccuracyMetres() {
        if (!this.lonAccuracyAvailable) {
            throw new IllegalStateException("Longitude Accuracy not available");
        }
        return this.lonAccuracy * METRE_PER_SECOND * Math.cos(4.84813681109536E-6 * this.lat);
    }

    public final void setLatSeconds(double d) {
        this.lat = d;
    }

    public final void setLatDegrees(double d) {
        this.lat = d * 3600.0;
    }

    public final void setLatAccuracyAvailable(boolean b) {
        this.latAccuracyAvailable = b;
    }

    public final void setLatAccuracySeconds(double d) {
        this.latAccuracy = d;
    }

    public final void setLatShiftSeconds(double d) {
        this.latShift = d;
    }

    public final void setLonPositiveWestSeconds(double d) {
        this.lon = d;
    }

    public final void setLonPositiveEastDegrees(double d) {
        this.lon = d * -3600.0;
    }

    public final void setLonAccuracyAvailable(boolean b) {
        this.lonAccuracyAvailable = b;
    }

    public final void setLonAccuracySeconds(double d) {
        this.lonAccuracy = d;
    }

    public final void setLonShiftPositiveWestSeconds(double d) {
        this.lonShift = d;
    }

    public String getSubGridName() {
        return this.subGridName;
    }

    public void setSubGridName(String string) {
        this.subGridName = string;
    }
}

