/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import com.headius.invokebinder.Binder;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import jnr.constants.Constant;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.AbstractRubyMethod;
import org.jruby.DelegatedModule;
import org.jruby.EvalType;
import org.jruby.IncludedModule;
import org.jruby.IncludedModuleWrapper;
import org.jruby.MetaClass;
import org.jruby.ObjectFlags;
import org.jruby.PrependedModule;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyMethod;
import org.jruby.RubyNameError;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.AnnotationHelper;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.anno.TypePopulator;
import org.jruby.api.Access;
import org.jruby.api.Check;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.JRubyAPI;
import org.jruby.api.Warn;
import org.jruby.common.IRubyWarnings;
import org.jruby.embed.Extension;
import org.jruby.exceptions.LoadError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RuntimeError;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.AttrReaderMethod;
import org.jruby.internal.runtime.methods.AttrWriterMethod;
import org.jruby.internal.runtime.methods.DefineMethodMethod;
import org.jruby.internal.runtime.methods.DelegatingDynamicMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.NativeCallMethod;
import org.jruby.internal.runtime.methods.PartialDelegatingMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.internal.runtime.methods.RefinedMarker;
import org.jruby.internal.runtime.methods.RefinedWrapper;
import org.jruby.internal.runtime.methods.SynchronizedDynamicMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRMethod;
import org.jruby.ir.Interp;
import org.jruby.ir.JIT;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.binding.MethodGatherer;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.runtime.profile.MethodEnhancer;
import org.jruby.util.ByteList;
import org.jruby.util.ClassProvider;
import org.jruby.util.CommonByteLists;
import org.jruby.util.IdUtil;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;
import org.jruby.util.cli.Options;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyClass(name={"Module"})
public class RubyModule
extends RubyObject {
    private static final Logger LOG = LoggerFactory.getLogger(RubyModule.class);
    public static final int CACHEPROXY_F = ObjectFlags.CACHEPROXY_F;
    public static final int NEEDSIMPL_F = ObjectFlags.NEEDSIMPL_F;
    public static final int REFINED_MODULE_F = ObjectFlags.REFINED_MODULE_F;
    public static final int IS_OVERLAID_F = ObjectFlags.IS_OVERLAID_F;
    public static final int OMOD_SHARED = ObjectFlags.OMOD_SHARED;
    public static final int INCLUDED_INTO_REFINEMENT = ObjectFlags.INCLUDED_INTO_REFINEMENT;
    public static final int TEMPORARY_NAME = ObjectFlags.TEMPORARY_NAME;
    public static final String BUILTIN_CONSTANT = "";
    public static final ObjectAllocator MODULE_ALLOCATOR = RubyModule::new;
    protected static final CacheEntryFactory NormalCacheEntryFactory = new CacheEntryFactory(){

        @Override
        public CacheEntry newCacheEntry(String id, DynamicMethod method2, RubyModule sourceModule, int token2) {
            return new CacheEntry(method2, sourceModule, token2);
        }
    };
    private volatile CacheEntryFactory cacheEntryFactory;
    public KindOf kindOf = KindOf.DEFAULT_KIND_OF;
    public final int id;
    private MethodHandle idTest;
    public RubyModule parent;
    protected String baseName;
    private transient String cachedName;
    private transient RubyString cachedRubyName;
    private transient IRubyObject cachedSymbolName;
    private volatile Map<String, ConstantEntry> constants;
    private static final VarHandle CONSTANTS_HANDLE;
    private volatile Map<String, Autoload> autoloads;
    private static final VarHandle AUTOLOADS_HANDLE;
    protected volatile Map<String, DynamicMethod> methods;
    private static final VarHandle METHODS_HANDLE;
    protected Map<String, CacheEntry> cachedMethods;
    protected int generation;
    protected Integer generationObject;
    protected volatile RubyClass.RubyClassSet includingHierarchies;
    private static final VarHandle INCLUDING_HIERARCHIES_HANDLE;
    protected volatile RubyModule methodLocation;
    private volatile transient Set<ClassProvider> classProviders;
    private static final VarHandle CLASS_PROVIDERS_HANDLE;
    protected RubyClass superClass;
    @Deprecated(since="9.0.0.0")
    public int index;
    @Deprecated(since="9.0.0.0")
    public static final Set<String> SCOPE_CAPTURING_METHODS;
    protected ClassIndex classIndex = ClassIndex.NO_INDEX;
    private volatile Map<String, IRubyObject> classVariables;
    private static final VarHandle CLASSVARS_HANDLE;
    volatile RefinementStore refinementStore;
    private static final VarHandle REFINEMENT_STORE_HANDLE;
    protected final Invalidator methodInvalidator;
    private int lastInvalidatorSize = 4;
    private boolean javaProxy = false;
    private static final MethodHandles.Lookup LOOKUP;
    private static final MethodHandle testModuleMatch;

    public static void finishModuleClass(RubyClass Module2) {
        ((RubyModule)((RubyModule)Module2.reifiedClass(RubyModule.class)).kindOf(new JavaClassKindOf(RubyModule.class))).classIndex(ClassIndex.MODULE);
    }

    public static void finishCreateModuleClass(ThreadContext context, RubyClass Module2) {
        Module2.defineMethods(context, RubyModule.class, ModuleKernelMethods.class);
    }

    public void checkValidBindTargetFrom(ThreadContext context, RubyModule originModule, boolean fromBind) throws RaiseException {
        if (!originModule.isModule() && !this.hasModuleInHierarchy(originModule)) {
            if (originModule instanceof MetaClass) {
                throw Error.typeError(context, "can't bind singleton method to a different class");
            }
            String thing = fromBind ? "an instance" : "a subclass";
            throw Error.typeError(context, "bind argument must be " + thing + " of ", originModule, BUILTIN_CONSTANT);
        }
    }

    public ClassIndex getClassIndex() {
        return this.classIndex;
    }

    @Deprecated(since="10.0.0.0")
    void setClassIndex(ClassIndex classIndex) {
        this.classIndex(classIndex);
    }

    @JRubyMethod
    public IRubyObject autoload(ThreadContext context, IRubyObject symbol, IRubyObject file2) {
        RubyString fileString = RubyFile.get_path(context, file2);
        if (fileString.isEmpty()) {
            throw Error.argumentError(context, "empty file name");
        }
        String symbolStr = symbol.asJavaString();
        if (!IdUtil.isValidConstantName(symbol)) {
            throw Error.nameError(context, "autoload must be constant name", symbol);
        }
        IRubyObject existingValue = this.fetchConstant(context, symbolStr);
        if (existingValue != null && existingValue != RubyObject.UNDEF) {
            return context.nil;
        }
        this.defineAutoload(context, symbolStr, fileString);
        return context.nil;
    }

    @JRubyMethod(name={"autoload?"})
    public IRubyObject autoload_p(ThreadContext context, IRubyObject symbol) {
        return this.hasAutoload(context, Check.checkID(context, symbol).idString(), true);
    }

    @JRubyMethod(name={"autoload?"})
    public IRubyObject autoload_p(ThreadContext context, IRubyObject symbol, IRubyObject inherit) {
        return this.hasAutoload(context, Check.checkID(context, symbol).idString(), inherit.isTrue());
    }

    public IRubyObject hasAutoload(ThreadContext context, String idString, boolean inherit) {
        for (RubyModule mod = this; mod != null; mod = mod.getSuperClass()) {
            IRubyObject loadedValue = mod.fetchConstant(context, idString);
            if (loadedValue == UNDEF) {
                Autoload autoload2 = mod.getAutoloadMap().get(idString);
                if (autoload2 == null) {
                    return context.nil;
                }
                if (autoload2.getValue() != null) {
                    return context.nil;
                }
                RubyString file2 = autoload2.getPath();
                if (autoload2.ctx != null && !autoload2.isSelf(context)) {
                    return file2;
                }
                if (!Access.loadService(context).featureAlreadyLoaded(file2.asJavaString())) {
                    return file2;
                }
            }
            if (!inherit) break;
        }
        return context.nil;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.MODULE;
    }

    @Override
    public boolean isModule() {
        return true;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isInstance(IRubyObject object) {
        return this.kindOf.isKindOf(object, this);
    }

    public boolean hasAncestor(RubyModule type2) {
        return this.searchAncestor(type2.getDelegate().getOrigin()) != null;
    }

    public Map<String, ConstantEntry> getConstantMap() {
        Map<String, ConstantEntry> constants2 = this.getOrigin().constants;
        return constants2 == null ? Collections.EMPTY_MAP : constants2;
    }

    public Map<String, ConstantEntry> getConstantMapForWrite() {
        Map<String, ConstantEntry> constants2 = this.constants;
        if (constants2 == null && !CONSTANTS_HANDLE.compareAndSet(this, null, constants2 = new ConcurrentHashMap<String, ConstantEntry>(2, 0.9f, 1))) {
            constants2 = this.constants;
        }
        return constants2;
    }

    protected Map<String, Autoload> getAutoloadMap() {
        Map<String, Autoload> autoloads = this.autoloads;
        return autoloads == null ? Collections.EMPTY_MAP : autoloads;
    }

    protected Map<String, Autoload> getAutoloadMapForWrite() {
        Map<String, Autoload> autoloads = this.autoloads;
        if (autoloads == null && !AUTOLOADS_HANDLE.compareAndSet(this, null, autoloads = new ConcurrentHashMap<String, Autoload>(2, 0.9f, 1))) {
            autoloads = this.autoloads;
        }
        return autoloads;
    }

    private RubyClass.RubyClassSet getIncludingHierarchiesForRead() {
        RubyClass.RubyClassSet includingHierarchies = this.includingHierarchies;
        return includingHierarchies == null ? RubyClass.EMPTY_RUBYCLASS_SET : includingHierarchies;
    }

    protected RubyClass.RubyClassSet getIncludingHierarchiesForWrite() {
        RubyClass.RubyClassSet includingHierarchies = this.includingHierarchies;
        if (includingHierarchies == null && !INCLUDING_HIERARCHIES_HANDLE.compareAndSet(this, null, includingHierarchies = new RubyClass.WeakRubyClassSet(4))) {
            includingHierarchies = this.includingHierarchies;
        }
        return includingHierarchies;
    }

    public void addIncludingHierarchy(IncludedModule hierarchy) {
        this.getIncludingHierarchiesForWrite().addClass(hierarchy);
    }

    public final MethodHandle getIdTest() {
        MethodHandle idTest = this.idTest;
        if (idTest != null) {
            return idTest;
        }
        this.idTest = this.newIdTest();
        return this.idTest;
    }

    protected final MethodHandle newIdTest() {
        return Binder.from(Boolean.TYPE, ThreadContext.class, IRubyObject.class).insert(2, this.id).invoke(testModuleMatch);
    }

    protected RubyModule(Ruby runtime2, RubyClass metaClass, boolean objectSpace) {
        super(runtime2, metaClass, objectSpace);
        this.id = runtime2.allocModuleId();
        if (metaClass == runtime2.getModule()) {
            runtime2.addModule(this);
        }
        this.setFlag(NEEDSIMPL_F, !this.isClass());
        this.updateGeneration(runtime2);
        this.cacheEntryFactory = runtime2.getInstanceConfig().isProfiling() ? new ProfilingCacheEntryFactory(runtime2, NormalCacheEntryFactory) : NormalCacheEntryFactory;
        this.methodInvalidator = OptoFactory.newMethodInvalidator(this);
    }

    protected RubyModule(Ruby runtime2, RubyClass metaClass) {
        this(runtime2, metaClass, runtime2.isObjectSpaceEnabled());
    }

    public RubyModule(Ruby runtime2) {
        this(runtime2, runtime2.getModule());
    }

    public boolean needsImplementer() {
        return this.getFlag(NEEDSIMPL_F);
    }

    @Deprecated(since="10.0.0.0")
    public static RubyModule newModule(Ruby runtime2) {
        return new RubyModule(runtime2);
    }

    @Deprecated(since="10.0.0.0")
    public static RubyModule newModule(Ruby runtime2, String name2, RubyModule parent, boolean setParent, String file2, int line) {
        return RubyModule.newModule(runtime2.getCurrentContext(), name2, parent, setParent, file2, line);
    }

    public static RubyModule newModule(ThreadContext context, String name2, RubyModule parent, boolean setParent, String file2, int line) {
        Object module = Define.defineModule(context).baseName(name2);
        if (setParent) {
            ((RubyModule)module).setParent(parent);
        }
        if (file2 != null) {
            parent.setConstant(context, name2, (IRubyObject)module, file2, line);
        } else {
            parent.setConstant(context, name2, (IRubyObject)module);
        }
        return module;
    }

    @Deprecated(since="10.0.0.0")
    public static RubyModule newModule(Ruby runtime2, String name2, RubyModule parent, boolean setParent) {
        ThreadContext context = runtime2.getCurrentContext();
        Object module = new RubyModule(runtime2).baseName(name2);
        if (setParent) {
            ((RubyModule)module).setParent(parent);
        }
        parent.setConstant(context, name2, (IRubyObject)module);
        return module;
    }

    public static RubyModule newModuleBootstrap(Ruby runtime2, String name2, RubyModule parent) {
        Object module = new RubyModule(runtime2).baseName(name2);
        parent.defineConstantBootstrap(name2, (IRubyObject)module);
        return module;
    }

    private Set<ClassProvider> getClassProvidersForRead() {
        Set<ClassProvider> classProviders = this.classProviders;
        return classProviders == null ? Collections.EMPTY_SET : classProviders;
    }

    private Set<ClassProvider> getClassProvidersForWrite() {
        Set<ClassProvider> classProviders = this.classProviders;
        if (classProviders == null && !CLASS_PROVIDERS_HANDLE.compareAndSet(this, null, classProviders = new CopyOnWriteArraySet<ClassProvider>())) {
            classProviders = this.classProviders;
        }
        return classProviders;
    }

    public final synchronized void addClassProvider(ClassProvider provider) {
        this.getClassProvidersForWrite().add(provider);
    }

    public final synchronized void removeClassProvider(ClassProvider provider) {
        this.getClassProvidersForWrite().remove(provider);
    }

    private void checkForCyclicInclude(ThreadContext context, RubyModule m) throws RaiseException {
        if (this.isSameOrigin(m)) {
            throw Error.argumentError(context, "cyclic include detected");
        }
    }

    protected void checkForCyclicPrepend(ThreadContext context, RubyModule m) throws RaiseException {
        if (this.isSameOrigin(m)) {
            throw Error.argumentError(context, this.getName(context) + " cyclic prepend detected " + m.getName(context));
        }
    }

    private RubyClass searchProvidersForClass(ThreadContext context, String name2, RubyClass superClazz) {
        Set<ClassProvider> classProviders = this.classProviders;
        if (classProviders == null) {
            return null;
        }
        for (ClassProvider classProvider : classProviders) {
            RubyClass clazz = classProvider.defineClassUnder(context, this, name2, superClazz);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    private RubyModule searchProvidersForModule(ThreadContext context, String name2) {
        Set<ClassProvider> classProviders = this.classProviders;
        if (classProviders == null) {
            return null;
        }
        for (ClassProvider classProvider : classProviders) {
            RubyModule module = classProvider.defineModuleUnder(context, this, name2);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    public RubyClass getSuperClass() {
        return this.superClass();
    }

    @Deprecated(since="10.0.0.0")
    public void setSuperClass(RubyClass superClass) {
        this.superClass(superClass);
    }

    public RubyModule getParent() {
        return this.parent;
    }

    public void setParent(RubyModule parent) {
        this.parent = parent;
    }

    public RubyModule getMethodLocation() {
        RubyModule methodLocation = this.methodLocation;
        return methodLocation == null ? this : methodLocation;
    }

    public void setMethodLocation(RubyModule module) {
        this.methodLocation = module;
    }

    public Map<String, DynamicMethod> getMethods() {
        Map<String, DynamicMethod> methods2 = this.methods;
        return methods2 == null ? Collections.EMPTY_MAP : methods2;
    }

    public Map<String, DynamicMethod> getMethodsForWrite() {
        Map<String, DynamicMethod> methods2 = this.methods;
        if (methods2 == null && !METHODS_HANDLE.compareAndSet(this, null, methods2 = new ConcurrentHashMap<String, DynamicMethod>(2, 0.9f, 1))) {
            methods2 = this.methods;
        }
        return methods2;
    }

    @Deprecated(since="10.0.0.0")
    public DynamicMethod putMethod(Ruby runtime2, String id, DynamicMethod method2) {
        return this.putMethod(this.getCurrentContext(), id, method2);
    }

    public DynamicMethod putMethod(ThreadContext context, String id, DynamicMethod method2) {
        DynamicMethod oldMethod;
        RubyModule methodLocation = this.getMethodLocation();
        if (this.hasPrepends()) {
            method2 = method2.dup();
            method2.setImplementationClass(methodLocation);
        }
        if ((oldMethod = methodLocation.getMethodsForWrite().put(id, method2)) != null && oldMethod.isRefined()) {
            methodLocation.getMethodsForWrite().put(id, new RefinedWrapper(method2.getImplementationClass(), method2.getVisibility(), id, method2));
        }
        context.runtime.addProfiledMethod(id, method2);
        return method2;
    }

    public boolean isIncluded() {
        return false;
    }

    public boolean isPrepended() {
        return false;
    }

    public RubyModule getOrigin() {
        return this;
    }

    @Deprecated(since="9.3.0.0")
    public RubyModule getNonIncludedClass() {
        return this;
    }

    public RubyModule getDelegate() {
        return this;
    }

    public RubyModule getRealModule() {
        RubyModule cl = this;
        while (cl != null && (cl.isSingleton() || cl.isIncluded())) {
            cl = cl.superClass;
        }
        return cl;
    }

    public String getBaseName() {
        return this.baseName;
    }

    @Deprecated(since="10.0.0.0")
    public void setBaseName(String name2) {
        this.baseName(name2);
    }

    @Deprecated(since="10.0.0.0")
    public String getName() {
        return this.getName(this.getCurrentContext());
    }

    public String getName(ThreadContext context) {
        return this.cachedName != null ? this.cachedName : this.calculateName(context);
    }

    @Deprecated(since="10.0.0.0")
    public RubyString rubyName() {
        return this.rubyName(this.getCurrentContext());
    }

    public RubyString rubyName(ThreadContext context) {
        return this.cachedRubyName != null ? this.cachedRubyName : this.calculateRubyName(context);
    }

    @Deprecated(since="10.0.0.0")
    public RubySymbol symbolName() {
        return this.symbolName(this.getCurrentContext());
    }

    public RubySymbol symbolName(ThreadContext context) {
        IRubyObject symbolName = this.cachedSymbolName;
        if (symbolName == null) {
            this.cachedSymbolName = symbolName = this.calculateSymbolName(context);
        }
        return symbolName == UNDEF ? null : (RubySymbol)symbolName;
    }

    @Deprecated(since="10.0.0.0")
    public RubyString rubyBaseName() {
        return this.rubyBaseName(this.getCurrentContext());
    }

    public RubyString rubyBaseName(ThreadContext context) {
        String baseName = this.getBaseName();
        return baseName == null ? null : (RubyString)Convert.asSymbol(context, baseName).to_s(context);
    }

    private RubyString calculateAnonymousRubyName(ThreadContext context) {
        RubyString anonBase = Create.newString(context, "#<");
        anonBase.append(this.metaClass.getRealClass().rubyName(context)).append(Create.newString(context, ":0x"));
        anonBase.append(Create.newString(context, Integer.toHexString(System.identityHashCode(this)))).append(Create.newString(context, ">"));
        return anonBase;
    }

    private RubyString calculateRubyName(ThreadContext context) {
        boolean cache = true;
        if (this.getBaseName() == null) {
            return this.calculateAnonymousRubyName(context);
        }
        if (this.usingTemporaryName()) {
            this.cachedRubyName = Convert.asSymbol(context, this.baseName).toRubyString(context);
            return this.cachedRubyName;
        }
        RubyClass Object2 = Access.objectClass(context);
        ArrayList<RubyString> parents = new ArrayList<RubyString>(5);
        for (RubyModule p2 = this.getParent(); p2 != null && p2 != Object2 && p2 != this; p2 = p2.getParent()) {
            RubyString name2 = p2.rubyBaseName(context);
            if (name2 == null) {
                cache = false;
                name2 = p2.rubyName(context);
            }
            parents.add(name2);
        }
        RubyString fullName = this.buildPathString(context, parents);
        if (cache) {
            this.cachedRubyName = fullName;
        }
        return fullName;
    }

    private IRubyObject calculateSymbolName(ThreadContext context) {
        if (this.getBaseName() == null) {
            return UNDEF;
        }
        if (this.usingTemporaryName()) {
            return Convert.asSymbol(context, this.baseName);
        }
        RubyClass Object2 = Access.objectClass(context);
        ArrayList<RubyString> parents = new ArrayList<RubyString>(5);
        for (RubyModule p2 = this.getParent(); p2 != null && p2 != Object2 && p2 != this; p2 = p2.getParent()) {
            RubyString name2 = p2.rubyBaseName(context);
            if (name2 == null) {
                return UNDEF;
            }
            parents.add(name2);
        }
        RubyString fullName = this.buildPathString(context, parents);
        return fullName.intern(context);
    }

    private RubyString buildPathString(ThreadContext context, List<RubyString> parents) {
        RubyString colons = Create.newString(context, "::");
        RubyString fullName = context.runtime.newString();
        fullName.setEncoding(USASCIIEncoding.INSTANCE);
        for (int i2 = parents.size() - 1; i2 >= 0; --i2) {
            RubyString rubyString = fullName.catWithCodeRange(parents.get(i2));
            rubyString.catWithCodeRange(colons);
        }
        fullName.catWithCodeRange(this.rubyBaseName(context));
        fullName.setFrozen(true);
        return fullName;
    }

    @Deprecated(since="10.0.0.0")
    public String getSimpleName() {
        return this.getSimpleName(this.getCurrentContext());
    }

    public String getSimpleName(ThreadContext context) {
        return this.baseName != null ? this.baseName : this.calculateAnonymousName(context);
    }

    private String calculateName(ThreadContext context) {
        boolean cache = true;
        if (this.getBaseName() == null) {
            return this.calculateAnonymousName(context);
        }
        String name2 = this.getBaseName();
        RubyClass Object2 = Access.objectClass(context);
        int parentCount = 0;
        for (RubyModule p2 = this.getParent(); p2 != null && p2 != Object2 && p2 != this; p2 = p2.getParent()) {
            ++parentCount;
        }
        String[] parentNames = new String[parentCount];
        int i2 = parentCount - 1;
        int totalLength = name2.length() + parentCount * 2;
        RubyModule p3 = this.getParent();
        while (p3 != null && p3 != Object2 && p3 != this) {
            Object pName = p3.getBaseName();
            if (pName == null) {
                cache = false;
                pName = p3.getName(context);
            }
            parentNames[i2] = pName;
            totalLength += ((String)pName).length();
            p3 = p3.getParent();
            --i2;
        }
        StringBuilder builder = new StringBuilder(totalLength);
        for (String parentName : parentNames) {
            builder.append(parentName).append("::");
        }
        builder.append(name2);
        String fullName = builder.toString();
        if (cache) {
            this.cachedName = fullName;
        }
        return fullName;
    }

    private String calculateAnonymousName(ThreadContext context) {
        Object cachedName = this.cachedName;
        if (cachedName == null) {
            cachedName = this.cachedName = "#<" + this.anonymousMetaNameWithIdentifier(context) + ">";
        }
        return cachedName;
    }

    @JRubyMethod(required=1)
    public IRubyObject set_temporary_name(ThreadContext context, IRubyObject arg2) {
        if (this.baseName != null && IdUtil.isValidConstantName(this.baseName) && (this.parent == null || this.parent.baseName != null)) {
            throw Error.runtimeError(context, "can't change permanent name");
        }
        if (arg2.isNil()) {
            this.baseName(null);
        } else {
            RubyString name2 = arg2.convertToString();
            if (name2.length() == 0) {
                throw Error.argumentError(context, "empty class/module name");
            }
            if (RubyModule.isValidConstantPath(name2)) {
                throw Error.argumentError(context, "the temporary name must not be a constant path to avoid confusion");
            }
            this.setFlag(TEMPORARY_NAME, true);
            this.baseName(Convert.asSymbol(context, name2.getByteList()).idString());
        }
        return this;
    }

    String anonymousMetaNameWithIdentifier(ThreadContext context) {
        return this.metaClass.getRealClass().getName(context) + ":0x" + Integer.toHexString(System.identityHashCode(this));
    }

    @JRubyMethod(name={"refine"}, reads={FrameField.SCOPE})
    public IRubyObject refine(ThreadContext context, IRubyObject klass, Block block) {
        if (!block.isGiven()) {
            throw Error.argumentError(context, "no block given");
        }
        if (block.isEscaped()) {
            throw Error.argumentError(context, "can't pass a Proc as a block to Module#refine");
        }
        if (!(klass instanceof RubyModule)) {
            throw Error.typeError(context, klass, "Class or Module");
        }
        RefinementStore refinementStore = this.getRefinementStoreForWrite();
        RubyModule moduleToRefine = (RubyModule)klass;
        RubyModule refinement = refinementStore.refinements.get(moduleToRefine);
        if (refinement == null) {
            refinement = this.createNewRefinedModule(context, moduleToRefine);
            this.addActivatedRefinement(context, moduleToRefine, refinement);
        }
        this.yieldRefineBlock(context, refinement, block);
        return refinement;
    }

    RefinementStore getRefinementStoreForWrite() {
        RefinementStore refinementStore = this.refinementStore;
        if (refinementStore == null && !REFINEMENT_STORE_HANDLE.compareAndSet(this, null, refinementStore = new RefinementStore(this))) {
            refinementStore = this.refinementStore;
        }
        return refinementStore;
    }

    private RubyModule createNewRefinedModule(ThreadContext context, RubyModule klass) {
        Ruby runtime2 = context.runtime;
        Object newRefinement = new RubyModule(runtime2, runtime2.getRefinement()).superClass(RubyModule.refinementSuperclass(context, klass));
        ((RubyBasicObject)newRefinement).setFlag(REFINED_MODULE_F, true);
        ((RubyBasicObject)newRefinement).setFlag(NEEDSIMPL_F, false);
        RefinementStore newRefinementStore = ((RubyModule)newRefinement).getRefinementStoreForWrite();
        newRefinementStore.refinedClass = klass;
        newRefinementStore.definedAt = this;
        this.getRefinementStoreForWrite().refinements.put(klass, (RubyModule)newRefinement);
        return newRefinement;
    }

    private static RubyClass refinementSuperclass(ThreadContext context, RubyModule superClass) {
        if (superClass.isModule()) {
            return new IncludedModuleWrapper(context.runtime, Access.basicObjectClass(context), superClass);
        }
        return (RubyClass)superClass;
    }

    private void yieldRefineBlock(ThreadContext context, RubyModule refinement, Block block) {
        block = block.cloneBlockAndFrame(EvalType.MODULE_EVAL);
        block.getBinding().setSelf(refinement);
        RubyModule overlayModule = block.getBody().getStaticScope().getOverlayModuleForWrite(context);
        overlayModule.getRefinementStoreForWrite().refinements = this.getRefinementStoreForWrite().refinements;
        block.yieldSpecific(context);
    }

    private void addActivatedRefinement(ThreadContext context, RubyModule moduleToRefine, RubyModule refinement) {
        RubyClass superClass = null;
        RefinementStore myRefinementStore = this.getRefinementStoreForWrite();
        RubyClass c = myRefinementStore.activatedRefinements.get(moduleToRefine);
        if (c != null) {
            superClass = c;
            while (c != null && c.isIncluded()) {
                if (c.getOrigin() == refinement) {
                    return;
                }
                c = c.getSuperClass();
            }
        }
        refinement.setFlag(IS_OVERLAID_F, true);
        IncludedModuleWrapper iclass = new IncludedModuleWrapper(context.runtime, superClass, refinement);
        c = iclass;
        RefinementStore otherRefinementStore = c.getRefinementStoreForWrite();
        otherRefinementStore.refinedClass = moduleToRefine;
        for (refinement = refinement.getSuperClass(); refinement != null; refinement = refinement.getSuperClass()) {
            refinement.setFlag(IS_OVERLAID_F, true);
            c.superClass(new IncludedModuleWrapper(context.runtime, c.getSuperClass(), refinement));
            c = c.getSuperClass();
            otherRefinementStore.refinedClass = moduleToRefine;
        }
        myRefinementStore.activatedRefinements.put(moduleToRefine, iclass);
    }

    @JRubyMethod(name={"using"}, visibility=Visibility.PRIVATE, reads={FrameField.SELF, FrameField.SCOPE})
    public IRubyObject using(ThreadContext context, IRubyObject refinedModule) {
        if (context.getFrameSelf() != this) {
            throw Error.runtimeError(context, "Module#using is not called on self");
        }
        if (context.getCurrentStaticScope().isWithinMethod()) {
            throw Error.runtimeError(context, "Module#using is not permitted in methods");
        }
        StaticScope staticScope = context.getCurrentStaticScope();
        RubyModule overlayModule = staticScope.getOverlayModuleForWrite(context);
        RubyModule.usingModule(context, overlayModule, refinedModule);
        return this;
    }

    public static void usingModule(ThreadContext context, RubyModule cref, IRubyObject refinedModule) {
        RubyModule.usingModuleRecursive(context, cref, Convert.castAsModule(context, refinedModule));
    }

    private static void usingModuleRecursive(ThreadContext context, RubyModule cref, RubyModule module) {
        RubyClass superClass = module.getSuperClass();
        if (superClass != null) {
            RubyModule.usingModuleRecursive(context, cref, superClass);
        }
        if (module instanceof DelegatedModule) {
            module = module.getDelegate();
        } else if (!module.isModule()) {
            throw Error.typeError(context, (IRubyObject)module, "Module");
        }
        RefinementStore refinementStore = module.refinementStore;
        if (refinementStore == null) {
            return;
        }
        Map<RubyModule, RubyModule> refinements2 = refinementStore.refinements;
        for (Map.Entry<RubyModule, RubyModule> entry : refinements2.entrySet()) {
            RubyModule.usingRefinement(context, cref, entry.getKey(), entry.getValue());
        }
    }

    private static void usingRefinement(ThreadContext context, RubyModule cref, RubyModule klass, RubyModule module) {
        RubyModule c;
        RubyModule superclass2 = klass;
        RefinementStore crefRefinementStore = cref.getRefinementStoreForWrite();
        if (cref.getFlag(OMOD_SHARED)) {
            crefRefinementStore.refinements = RubyModule.newRefinementsMap(crefRefinementStore.refinements);
            cref.setFlag(OMOD_SHARED, false);
        }
        if ((c = crefRefinementStore.refinements.get(klass)) != null) {
            superclass2 = c;
            while (c != null && c instanceof IncludedModule) {
                if (c.getOrigin() == module) {
                    return;
                }
                c = c.getSuperClass();
            }
        }
        module.setFlag(IS_OVERLAID_F, true);
        superclass2 = RubyModule.refinementSuperclass(context, superclass2);
        IncludedModuleWrapper iclass = new IncludedModuleWrapper(context.runtime, (RubyClass)superclass2, module);
        c = iclass;
        c.getRefinementStoreForWrite().refinedClass = klass;
        for (module = module.getSuperClass(); module != null && module != klass; module = module.getSuperClass()) {
            module.setFlag(IS_OVERLAID_F, true);
            c.superClass(new IncludedModuleWrapper(context.runtime, c.getSuperClass(), module));
            c = c.getSuperClass();
            c.getRefinementStoreForWrite().refinedClass = klass;
        }
        crefRefinementStore.refinements.put(klass, iclass);
    }

    public static Map<RubyModule, RubyModule> newRefinementsMap(Map<RubyModule, RubyModule> refinements2) {
        return Collections.synchronizedMap(new IdentityHashMap<RubyModule, RubyModule>(refinements2));
    }

    public static Map<RubyModule, RubyModule> newRefinementsMap() {
        return Collections.synchronizedMap(new IdentityHashMap());
    }

    public static Map<RubyModule, IncludedModule> newActivatedRefinementsMap() {
        return Collections.synchronizedMap(new IdentityHashMap());
    }

    @JRubyMethod(name={"used_modules"}, reads={FrameField.SCOPE})
    public IRubyObject used_modules(ThreadContext context) {
        RubyArray<?> ary = Create.newArray(context);
        for (StaticScope cref = context.getCurrentStaticScope(); cref != null; cref = cref.getPreviousCRefScope()) {
            RefinementStore overlayRefinementStore;
            RubyModule overlay = cref.getOverlayModuleForRead();
            if (overlay == null || (overlayRefinementStore = overlay.refinementStore) == null || overlayRefinementStore.refinements.isEmpty()) continue;
            overlayRefinementStore.refinements.forEach((mod, x) -> {
                while (mod != null && mod.getOrigin().isRefinement()) {
                    ary.push(context, mod.getOrigin().getRefinementStoreForWrite().definedAt);
                    mod = mod.getSuperClass();
                }
            });
        }
        return ary;
    }

    @Deprecated(since="1.1.5")
    public IncludedModuleWrapper newIncludeClass(RubyClass superClazz) {
        ThreadContext context = this.getCurrentContext();
        IncludedModuleWrapper includedModule = new IncludedModuleWrapper(context.runtime, superClazz, this);
        if (this.getSuperClass() != null) {
            includedModule.includeModule(context, this.getSuperClass());
        }
        return includedModule;
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule getModule(String name2) {
        return this.getModule(this.getCurrentContext(), name2);
    }

    public RubyModule getModule(ThreadContext context, String name2) {
        return (RubyModule)this.getConstantAt(context, name2);
    }

    @Deprecated(since="10.0.0.0")
    public RubyClass getClass(String name2) {
        return this.getClass(this.getCurrentContext(), name2);
    }

    @JRubyAPI
    public RubyClass getClass(ThreadContext context, String name2) {
        return (RubyClass)this.getConstantAt(context, name2);
    }

    @Deprecated(since="1.7.0")
    public RubyClass fastGetClass(String internedName) {
        return this.getClass(this.getCurrentContext(), internedName);
    }

    @Deprecated(since="10.0.0.0")
    public void prependModule(RubyModule module) {
        this.prependModule(this.getCurrentContext(), module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prependModule(final ThreadContext context, final RubyModule module) {
        this.testFrozen("module");
        RefinementStore moduleRefinementStore = module.refinementStore;
        if (moduleRefinementStore != null && moduleRefinementStore.refinedClass != null) {
            throw Error.typeError(context, "Cannot prepend refinement");
        }
        this.checkForCyclicPrepend(context, module);
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            if (this.hasModuleInPrepends(module)) {
                this.invalidateCacheDescendants(context);
                return;
            }
            this.doPrependModule(context, module);
            if (this.isModule()) {
                this.getIncludingHierarchiesForRead().forEachClass(new RubyClass.BiConsumerIgnoresSecond<RubyClass>(){
                    boolean doPrepend = true;

                    @Override
                    public void accept(RubyClass includeClass) {
                        RubyClass checkClass = includeClass;
                        while (checkClass != null) {
                            if (checkClass instanceof IncludedModule && checkClass.getOrigin() == module) {
                                this.doPrepend = false;
                            }
                            checkClass = checkClass.superClass;
                        }
                        if (this.doPrepend) {
                            includeClass.doPrependModule(context, module);
                        }
                    }
                });
            }
            this.invalidateCacheDescendants(context);
            this.invalidateConstantCacheForModuleInclusion(context, module);
        }
    }

    @Deprecated(since="9.2.8.0")
    public void prependModule(IRubyObject arg2) {
        assert (arg2 != null);
        this.prependModule(Convert.castAsModule(this.getCurrentContext(), arg2));
    }

    @Deprecated(since="10.0.0.0")
    public synchronized void includeModule(IRubyObject arg2) {
        this.includeModule(this.getCurrentContext(), arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void includeModule(final ThreadContext context, IRubyObject arg2) {
        RubyModule module;
        assert (arg2 != null);
        this.testFrozen("module");
        if (!(arg2 instanceof RubyModule)) {
            Error.typeError(context, arg2, "Module");
        }
        if ((module = (RubyModule)arg2).isRefinement()) {
            throw Error.typeError(context, "Cannot include refinement");
        }
        this.checkForCyclicInclude(context, module);
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            this.doIncludeModule(context, module);
            if (this.isModule()) {
                this.getIncludingHierarchiesForRead().forEachClass(new RubyClass.BiConsumerIgnoresSecond<RubyClass>(){
                    boolean doInclude = true;

                    @Override
                    public void accept(RubyClass includeClass) {
                        RubyClass checkClass = includeClass;
                        while (checkClass != null) {
                            if (checkClass instanceof IncludedModule && checkClass.getOrigin() == module) {
                                this.doInclude = false;
                            }
                            checkClass = checkClass.superClass;
                        }
                        if (this.doInclude) {
                            includeClass.doIncludeModule(context, module);
                        }
                    }
                });
            }
            this.invalidateCacheDescendants(context);
            this.invalidateConstantCacheForModuleInclusion(context, module);
        }
    }

    @Deprecated(since="10.0.0.0")
    public void defineAnnotatedMethod(Class clazz, String name2) {
        boolean foundMethod = false;
        JRubyClassLoader JRubyClassLoader2 = this.getCurrentContext().runtime.getJRubyClassLoader();
        for (Method method2 : clazz.getDeclaredMethods()) {
            if (!method2.getName().equals(name2) || !this.defineAnnotatedMethod(method2, MethodFactory.createFactory(JRubyClassLoader2))) continue;
            foundMethod = true;
        }
        if (!foundMethod) {
            throw new RuntimeException("No JRubyMethod present for method " + name2 + "on class " + clazz.getName());
        }
    }

    @Deprecated(since="10.0.0.0")
    public final void defineAnnotatedConstants(Class clazz) {
        this.defineConstants(this.getCurrentContext(), clazz);
    }

    @Deprecated(since="10.0.0.0")
    public final boolean defineAnnotatedConstant(Field field) {
        return this.defineAnnotatedConstant(this.getCurrentContext(), field);
    }

    private boolean defineAnnotatedConstant(ThreadContext context, Field field) {
        IRubyObject realVal;
        JRubyConstant jrubyConstant = field.getAnnotation(JRubyConstant.class);
        if (jrubyConstant == null) {
            return false;
        }
        Class<?> tp = field.getType();
        try {
            realVal = tp == Integer.class || tp == Integer.TYPE || tp == Short.class || tp == Short.TYPE || tp == Byte.class || tp == Byte.TYPE ? Convert.asFixnum(context, field.getInt(null)) : (tp == Boolean.class || tp == Boolean.TYPE ? Convert.asBoolean(context, field.getBoolean(null)) : context.nil);
        }
        catch (Exception e) {
            realVal = context.nil;
        }
        String[] names2 = jrubyConstant.value();
        if (names2.length == 0) {
            this.defineConstant(context, field.getName(), realVal);
        } else {
            for (String name2 : names2) {
                this.defineConstant(context, name2, realVal);
            }
        }
        return true;
    }

    @Extension
    @Deprecated(since="10.0.0.0")
    public void defineAnnotatedMethods(Class clazz) {
        this.defineAnnotatedMethodsIndividually(clazz);
    }

    public static TypePopulator loadPopulatorFor(Class<?> type2) {
        block6: {
            if (Options.DEBUG_FULLTRACE.load().booleanValue()) {
                LOG.debug("trace mode, using default populator", new Object[0]);
            } else {
                try {
                    String qualifiedName = "org.jruby.gen." + type2.getCanonicalName().replace('.', '$');
                    String fullName = qualifiedName + "$POPULATOR";
                    String fullPath = fullName.replace('.', '/') + ".class";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("looking for populator " + fullName, new Object[0]);
                    }
                    if (Ruby.getClassLoader().getResource(fullPath) != null) {
                        return (TypePopulator)Class.forName(fullName).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    LOG.debug("could not find it, using default populator", new Object[0]);
                }
                catch (Throwable ex) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("could not find populator, using default (" + String.valueOf(ex) + ")", new Object[0]);
                }
            }
        }
        return new TypePopulator.ReflectiveTypePopulator(type2);
    }

    @Deprecated(since="10.0.0.0")
    public final void defineAnnotatedMethodsIndividually(Class clazz) {
        ThreadContext context = this.getCurrentContext();
        context.runtime.POPULATORS.get(clazz).populate(context, this, clazz);
    }

    @Deprecated(since="10.0.0.0")
    public final boolean defineAnnotatedMethod(String name2, List<JavaMethodDescriptor> methods2, MethodFactory methodFactory) {
        if (methods2.size() == 1 && methods2.get((int)0).anno == null) {
            return false;
        }
        this.defineAnnotatedMethod(this.getCurrentContext(), name2, methods2, methodFactory);
        return true;
    }

    public final void defineAnnotatedMethod(ThreadContext context, String name2, List<JavaMethodDescriptor> methods2, MethodFactory methodFactory) {
        JavaMethodDescriptor desc = methods2.get(0);
        DynamicMethod dynamicMethod = methods2.size() == 1 ? methodFactory.getAnnotatedMethod(this, desc, name2) : methodFactory.getAnnotatedMethod(this, methods2, name2);
        RubyModule.define(context, this, desc, dynamicMethod);
    }

    @Deprecated(since="10.0.0.0")
    public final boolean defineAnnotatedMethod(Method method2, MethodFactory methodFactory) {
        if (method2.getAnnotation(JRubyMethod.class) == null) {
            return false;
        }
        JavaMethodDescriptor desc = new JavaMethodDescriptor(method2);
        DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, desc, method2.getName());
        RubyModule.define(this.getCurrentContext(), this, desc, dynamicMethod);
        return true;
    }

    @Deprecated(since="10.0.0.0")
    public final boolean defineAnnotatedMethod(String name2, JavaMethodDescriptor desc, MethodFactory methodFactory) {
        if (desc.anno == null) {
            return false;
        }
        DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, desc, name2);
        RubyModule.define(this.getCurrentContext(), this, desc, dynamicMethod);
        return true;
    }

    @JRubyAPI
    public <T extends RubyModule> T baseName(String name2) {
        this.baseName = name2;
        this.cachedName = null;
        this.cachedRubyName = null;
        return (T)this;
    }

    @JRubyAPI
    public <T extends RubyModule> T classIndex(ClassIndex classIndex) {
        this.classIndex = classIndex;
        this.index = classIndex.ordinal();
        return (T)this;
    }

    @JRubyAPI
    public <T extends RubyClass> T defineClassUnder(ThreadContext context, String name2, RubyClass superClass, ObjectAllocator allocator) {
        return (T)context.runtime.defineClassUnder(context, name2, superClass, allocator, this, null);
    }

    @JRubyAPI
    public <T extends RubyModule> T defineConstants(ThreadContext context, Class constantSource) {
        for (Field field : constantSource.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            this.defineAnnotatedConstant(context, field);
        }
        return (T)this;
    }

    @JRubyAPI
    public <C extends Enum<C>, T extends RubyModule> T defineConstantsFrom(ThreadContext context, Class<C> enumClass) {
        for (Enum constant : EnumSet.allOf(enumClass)) {
            String name2 = constant.name();
            if (!((Constant)((Object)constant)).defined() || !Character.isUpperCase(name2.charAt(0))) continue;
            this.defineConstant(context, name2, Convert.asFixnum(context, ((Constant)((Object)constant)).intValue()));
        }
        return (T)this;
    }

    @JRubyAPI
    public RubyModule defineModuleUnder(ThreadContext context, String name2) {
        return context.runtime.defineModuleUnder(context, name2, this);
    }

    @JRubyAPI
    public <T extends RubyModule> T defineMethods(ThreadContext context, Class ... methodSources) {
        ClassValue<TypePopulator> populators = context.runtime.POPULATORS;
        for (Class clazz : methodSources) {
            populators.get(clazz).populate(context, this, clazz);
        }
        return (T)this;
    }

    @JRubyAPI
    public <T extends RubyModule> T include(ThreadContext context, RubyModule module) {
        this.includeModule(context, module);
        return (T)this;
    }

    @JRubyAPI
    public <T extends RubyModule> T kindOf(KindOf kindOf) {
        this.kindOf = kindOf;
        return (T)this;
    }

    @JRubyAPI
    public RubyClass superClass() {
        return this.superClass;
    }

    @JRubyAPI
    public <T extends RubyModule> T superClass(RubyClass superClass) {
        this.superClass = superClass;
        if (superClass != null && superClass.isSynchronized()) {
            this.becomeSynchronized();
        }
        return (T)this;
    }

    @JRubyAPI
    public <T extends RubyModule> T tap(Consumer<T> consumer) {
        consumer.accept(this);
        return (T)this;
    }

    @JRubyAPI
    public <T extends RubyModule> T undefMethods(ThreadContext context, String ... names2) {
        for (String name2 : names2) {
            this.getMethodLocation().addMethod(context, name2, UndefinedMethod.getInstance());
        }
        return (T)this;
    }

    @Deprecated(since="10.0.0.0")
    public void undefineMethod(String name2) {
        this.getMethodLocation().addMethod(this.getCurrentContext(), name2, UndefinedMethod.getInstance());
    }

    public void undef(ThreadContext context, String name2) {
        this.testFrozen("module");
        if (name2.equals("__send__") || name2.equals("object_id") || name2.equals("initialize")) {
            Warn.warn(context, "undefining '" + name2 + "' may cause serious problems");
        }
        if (name2.equals("method_missing")) {
            IRubyObject oldExc = context.getErrorInfo();
            try {
                this.removeMethod(context, name2);
            }
            catch (RaiseException t) {
                if (!(t.getException() instanceof RubyNameError)) {
                    throw t;
                }
                context.setErrorInfo(oldExc);
            }
            return;
        }
        DynamicMethod method2 = this.searchMethod(name2);
        if (method2.isUndefined()) {
            this.raiseUndefinedNameError(context, name2);
        }
        this.getMethodLocation().addMethod(context, name2, UndefinedMethod.getInstance());
        this.methodUndefined(context, Convert.asSymbol(context, name2));
    }

    private void raiseUndefinedNameError(ThreadContext context, String name2) {
        String s0 = " class";
        RubyModule c = this;
        if (c.isSingleton()) {
            RubyBasicObject obj = ((MetaClass)c).getAttached();
            if (obj instanceof RubyClass) {
                c = (RubyModule)obj;
            } else if (obj instanceof RubyModule) {
                s0 = BUILTIN_CONSTANT;
            }
        } else if (c.isModule()) {
            s0 = " module";
        }
        throw Error.nameError(context, RubyStringBuilder.str(context.runtime, "undefined method '" + name2 + "' for" + s0 + " '", c, "'"), name2);
    }

    @JRubyMethod(name={"include?"})
    public IRubyObject include_p(ThreadContext context, IRubyObject arg2) {
        if (!arg2.isModule()) {
            throw Error.typeError(context, arg2, "Module");
        }
        RubyModule moduleToCompare = (RubyModule)arg2;
        for (RubyClass p2 = this.getSuperClass(); p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.isSame(moduleToCompare)) continue;
            return context.tru;
        }
        return context.fals;
    }

    @JRubyMethod(name={"singleton_class?"})
    public IRubyObject singleton_class_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isSingleton());
    }

    private String frozenType() {
        return this.isClass() ? "class" : "module";
    }

    @Deprecated(since="10.0.0.0")
    public void addMethod(String id, DynamicMethod method2) {
        this.addMethod(this.getCurrentContext(), id, method2);
    }

    public void addMethod(ThreadContext context, String id, DynamicMethod method2) {
        if (this instanceof MetaClass) {
            ((MetaClass)this).getAttached().testFrozen();
        } else {
            this.testFrozen(this.frozenType());
        }
        RubyModule methodLocation = this.methodLocation;
        if (methodLocation != null) {
            methodLocation.addMethod(context, id, method2);
            return;
        }
        if (this.isRefinement()) {
            this.addRefinedMethodEntry(context, id, method2);
        }
        this.addMethodInternal(context, id, method2);
    }

    private void addRefinedMethodEntry(ThreadContext context, String id, DynamicMethod method2) {
        RubyModule refinedClass = this.refinementStore.refinedClass;
        RubyModule methodLocation = refinedClass.getMethodLocation();
        DynamicMethod orig = methodLocation.searchMethodCommon(id);
        if (orig == null) {
            refinedClass.addMethod(context, id, new RefinedMarker(methodLocation, method2.getVisibility(), id));
        } else {
            if (orig.isRefined()) {
                return;
            }
            refinedClass.addMethod(context, id, new RefinedWrapper(methodLocation, method2.getVisibility(), id, orig));
        }
    }

    @Deprecated(since="10.0.0.0")
    public final void addMethodInternal(String name2, DynamicMethod method2) {
        this.addMethodInternal(this.getCurrentContext(), name2, method2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMethodInternal(ThreadContext context, String name2, DynamicMethod method2) {
        Map<String, DynamicMethod> map2 = this.getMethodLocation().getMethodsForWrite();
        synchronized (map2) {
            this.putMethod(context, name2, method2);
        }
        this.invalidateMethodCache(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethod(ThreadContext context, String id) {
        this.testFrozen("class/module");
        switch (id) {
            case "object_id": {
                RubyModule.warnMethodRemoval(context, id);
                break;
            }
            case "__send__": {
                RubyModule.warnMethodRemoval(context, id);
                break;
            }
            case "initialize": {
                RubyModule.warnMethodRemoval(context, id);
            }
        }
        RubySymbol name2 = Convert.asSymbol(context, id);
        Map<String, DynamicMethod> methodsForWrite = this.getMethodLocation().getMethodsForWrite();
        Object object = methodsForWrite;
        synchronized (object) {
            DynamicMethod method2 = methodsForWrite.get(id);
            if (method2 == null || method2.isUndefined() || method2 instanceof RefinedMarker) {
                throw Error.nameError(context, RubyStringBuilder.str(context.runtime, "method '", name2, "' not defined in ", this.rubyName(context)), id);
            }
            method2 = methodsForWrite.remove(id);
            if (method2.isRefined()) {
                methodsForWrite.put(id, new RefinedMarker(method2.getImplementationClass(), method2.getVisibility(), id));
            }
        }
        object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            this.invalidateCacheDescendants(context);
        }
        this.methodRemoved(context, name2);
    }

    private static void warnMethodRemoval(ThreadContext context, String id) {
        Warn.warn(context, RubyStringBuilder.str(context.runtime, "removing '", RubyStringBuilder.ids(context.runtime, id), "' may cause serious problems"));
    }

    public final DynamicMethod searchMethod(String name2) {
        return this.searchWithCache((String)name2).method;
    }

    public CacheEntry searchWithCache(String name2) {
        return this.searchWithCacheAndRefinements(name2, null);
    }

    public CacheEntry searchWithRefinements(String name2, StaticScope refinedScope) {
        return this.searchWithCacheAndRefinements(name2, refinedScope);
    }

    @Deprecated(since="10.0.1.0")
    public final CacheEntry searchWithCache(String id, boolean cacheUndef) {
        CacheEntry entry = this.cacheHit(id);
        return entry != null ? entry : this.searchWithCacheMiss(this.getRuntime(), id);
    }

    private CacheEntry searchWithCacheAndRefinements(String id, StaticScope refinedScope) {
        CacheEntry entry = this.cacheHit(id);
        if (entry == null) {
            entry = this.searchWithCacheMiss(this.getRuntime(), id);
        }
        if (entry.method.isRefined()) {
            while (refinedScope != null) {
                RubyModule overlay = refinedScope.getOverlayModuleForRead();
                if (overlay != null) {
                    CacheEntry maybeEntry = this.resolveRefinedMethod(overlay, entry, id);
                    if (!maybeEntry.method.isUndefined()) {
                        return maybeEntry;
                    }
                }
                refinedScope = refinedScope.getEnclosingScope();
            }
            return this.resolveRefinedMethod(null, entry, id);
        }
        return entry;
    }

    private CacheEntry refinedMethodOriginalMethodEntry(RubyModule overlay, String id, CacheEntry entry) {
        DynamicMethod method2 = entry.method;
        if (method2 instanceof DelegatingDynamicMethod) {
            method2 = ((DelegatingDynamicMethod)method2).getDelegate();
        }
        if (method2 instanceof RefinedWrapper) {
            return this.cacheEntryFactory.newCacheEntry(id, ((RefinedWrapper)method2).getWrapped(), entry.sourceModule, entry.token);
        }
        RubyClass superClass = entry.sourceModule.getSuperClass();
        if (superClass == null) {
            return CacheEntry.NULL_CACHE;
        }
        return this.resolveRefinedMethod(overlay, superClass.searchWithCache(id), id);
    }

    private CacheEntry searchWithCacheMiss(Ruby runtime2, String id) {
        int token2 = this.generation;
        CacheEntry methodEntry = this.searchMethodEntryInner(id);
        if (methodEntry == null) {
            return this.addToCache(id, UndefinedMethod.getInstance(), this, token2);
        }
        if (!runtime2.isBooting()) {
            this.addToCache(id, methodEntry);
        }
        return methodEntry;
    }

    @Deprecated(since="1.7.0")
    public final int getCacheToken() {
        return this.generation;
    }

    public final int getGeneration() {
        return this.generation;
    }

    public final Integer getGenerationObject() {
        return this.generationObject;
    }

    protected final Map<String, CacheEntry> getCachedMethods() {
        Map<String, CacheEntry> cachedMethods = this.cachedMethods;
        return cachedMethods == null ? Collections.EMPTY_MAP : cachedMethods;
    }

    private final Map<String, CacheEntry> getCachedMethodsForWrite() {
        Map<String, CacheEntry> myCachedMethods = this.cachedMethods;
        if (myCachedMethods == null) {
            myCachedMethods = this.cachedMethods = new ConcurrentHashMap<String, CacheEntry>(0, 0.75f, 1);
        }
        return myCachedMethods;
    }

    private CacheEntry cacheHit(String name2) {
        CacheEntry cacheEntry = this.getMethodLocation().getCachedMethods().get(name2);
        if (cacheEntry != null && cacheEntry.token == this.getGeneration()) {
            return cacheEntry;
        }
        return null;
    }

    private void invalidateConstantCacheForModuleInclusion(ThreadContext context, RubyModule module) {
        HashMap<String, Invalidator> invalidators = null;
        for (RubyModule mod : this.gatherModules(module)) {
            for (String name2 : mod.getConstantMap().keySet()) {
                if (invalidators == null) {
                    invalidators = new HashMap<String, Invalidator>(4);
                }
                invalidators.put(name2, context.runtime.getConstantInvalidator(name2));
            }
        }
        if (invalidators != null) {
            ArrayList<Invalidator> values2 = new ArrayList<Invalidator>(invalidators.values());
            ((Invalidator)values2.get(0)).invalidateAll(values2);
        }
    }

    public void becomeSynchronized() {
        this.cacheEntryFactory = new SynchronizedCacheEntryFactory(this.cacheEntryFactory);
    }

    public boolean isSynchronized() {
        return this.cacheEntryFactory.hasCacheEntryFactory(SynchronizedCacheEntryFactory.class);
    }

    protected CacheEntry addToCache(String id, DynamicMethod method2, RubyModule sourceModule, int token2) {
        CacheEntry entry = this.cacheEntryFactory.newCacheEntry(id, method2, sourceModule, token2);
        this.getMethodLocation().getCachedMethodsForWrite().put(id, entry);
        return entry;
    }

    protected CacheEntry addToCache(String id, CacheEntry entry) {
        this.getMethodLocation().getCachedMethodsForWrite().put(id, entry);
        return entry;
    }

    public DynamicMethod searchMethodInner(String id) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            DynamicMethod method2 = module.searchMethodCommon(id);
            if (method2 == null) continue;
            return method2.isNull() ? null : method2;
        }
        return null;
    }

    public CacheEntry searchMethodEntryInner(String id) {
        int token2 = this.generation;
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            DynamicMethod method2 = module.searchMethodCommon(id);
            if (method2 == null) continue;
            return method2.isNull() ? null : this.cacheEntryFactory.newCacheEntry(id, method2, module, token2);
        }
        return null;
    }

    @Deprecated(since="9.3.11.0")
    public DynamicMethod searchMethodLateral(String id) {
        for (RubyModule module = this; module == this || module instanceof IncludedModuleWrapper; module = module.getSuperClass()) {
            DynamicMethod method2 = module.searchMethodCommon(id);
            if (method2 == null) continue;
            return method2.isNull() ? null : method2;
        }
        return null;
    }

    public CacheEntry resolveRefinedMethod(RubyModule overlay, CacheEntry entry, String id) {
        if (entry != null && entry.method.isRefined()) {
            RubyModule refinement = RubyModule.findRefinement(overlay, entry.method.getDefinedClass());
            if (refinement == null) {
                return this.refinedMethodOriginalMethodEntry(overlay, id, entry);
            }
            CacheEntry tmpEntry = refinement.searchWithCache(id);
            if (!tmpEntry.method.isRefined()) {
                return tmpEntry;
            }
            return this.refinedMethodOriginalMethodEntry(overlay, id, entry);
        }
        return entry;
    }

    private static RubyModule findRefinement(RubyModule overlay, RubyModule target2) {
        RefinementStore refinementStore;
        if (overlay == null || (refinementStore = overlay.refinementStore) == null) {
            return null;
        }
        Map<RubyModule, RubyModule> refinements2 = refinementStore.refinements;
        return refinements2.get(target2);
    }

    protected DynamicMethod searchMethodCommon(String id) {
        return this.getMethods().get(id);
    }

    @Deprecated(since="10.0.0.0")
    public void invalidateCacheDescendants() {
        this.invalidateCacheDescendants(this.getCurrentContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCacheDescendants(ThreadContext context) {
        LOG.debug("{} invalidating descendants", this.baseName);
        context.runtime.getCaches().incrementMethodInvalidations();
        Invalidator methodInvalidator = this.methodInvalidator;
        RubyClass.RubyClassSet includingHierarchies = this.getIncludingHierarchiesForRead();
        if (includingHierarchies.isEmptyOfClasses()) {
            methodInvalidator.invalidate();
            return;
        }
        InvalidatorList<Invalidator> invalidators = new InvalidatorList<Invalidator>((int)((double)this.lastInvalidatorSize * 1.25));
        methodInvalidator.addIfUsed(invalidators);
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            includingHierarchies.forEachClass(invalidators);
        }
        this.lastInvalidatorSize = invalidators.size();
        methodInvalidator.invalidateAll(invalidators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateMethodCache(ThreadContext context) {
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            this.invalidateCacheDescendants(context);
        }
    }

    @Deprecated(since="10.0.0.0")
    protected void invalidateCoreClasses() {
    }

    public Invalidator getInvalidator() {
        return this.methodInvalidator;
    }

    public void updateGeneration() {
        this.updateGeneration(this.getRuntime());
    }

    private void updateGeneration(Ruby runtime2) {
        this.generation = runtime2.getNextModuleGeneration();
        this.generationObject = this.generation;
    }

    @Deprecated(since="10.0.0.0")
    protected void invalidateConstantCache(String constantName) {
        this.invalidateConstantCache(this.getCurrentContext(), constantName);
    }

    protected void invalidateConstantCache(ThreadContext context, String constantName) {
        context.runtime.getConstantInvalidator(constantName).invalidate();
    }

    @Deprecated(since="10.0.0.0")
    protected void invalidateConstantCaches(Set<String> constantNames) {
        if (constantNames.size() > 0) {
            Ruby runtime2 = this.getCurrentContext().runtime;
            ArrayList<Invalidator> constantInvalidators = new ArrayList<Invalidator>(constantNames.size());
            for (String name2 : constantNames) {
                constantInvalidators.add(runtime2.getConstantInvalidator(name2));
            }
            ((Invalidator)constantInvalidators.get(0)).invalidateAll(constantInvalidators);
        }
    }

    public DynamicMethod retrieveMethod(String name2) {
        return this.getMethods().get(name2);
    }

    public RubyModule findImplementer(RubyModule clazz) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.isSame(clazz)) continue;
            return module;
        }
        return null;
    }

    @Deprecated(since="10.0.0.0")
    public void addModuleFunction(String name2, DynamicMethod method2) {
        ThreadContext context = this.getCurrentContext();
        this.addMethod(context, name2, method2);
        this.singletonClass(context).addMethod(context, name2, method2);
    }

    @Deprecated(since="10.0.0.0")
    public synchronized void defineAlias(String name2, String oldName) {
        this.defineAlias(this.getCurrentContext(), name2, oldName);
    }

    @Deprecated(since="10.0.0.0")
    public void putAlias(String id, DynamicMethod method2, String oldName) {
        this.putAlias(this.getCurrentContext(), id, method2, oldName);
    }

    public void putAlias(ThreadContext context, String id, DynamicMethod method2, String oldName) {
        if (id.equals(oldName)) {
            return;
        }
        this.putMethod(context.runtime, id, (DynamicMethod)new AliasMethod(this, new CacheEntry(method2, method2.getImplementationClass(), this.generation), id, oldName));
        if (this.isRefinement()) {
            this.addRefinedMethodEntry(context, id, method2);
        }
    }

    @Deprecated(since="10.0.0.0")
    public void putAlias(String id, CacheEntry entry, String oldName) {
        this.putAlias(this.getCurrentContext(), id, entry, oldName);
    }

    public void putAlias(ThreadContext context, String id, CacheEntry entry, String oldName) {
        if (id.equals(oldName)) {
            return;
        }
        this.putMethod(context.runtime, id, (DynamicMethod)new AliasMethod(this, entry, id, oldName));
        if (this.isRefinement()) {
            this.addRefinedMethodEntry(context, id, entry.method);
        }
    }

    private CacheEntry searchForAliasMethod(ThreadContext context, String id) {
        return this.deepMethodSearch(context, id);
    }

    private void checkAliasFrameAccesses(ThreadContext context, String id, String newName, DynamicMethod method2) {
        if (method2 instanceof NativeCallMethod) {
            boolean writesSuperset;
            DynamicMethod.NativeCall nativeCall = ((NativeCallMethod)((Object)method2)).getNativeCall();
            if (nativeCall == null) {
                return;
            }
            Method javaMethod = nativeCall.getMethod();
            JRubyMethod anno = javaMethod.getAnnotation(JRubyMethod.class);
            if (anno == null) {
                return;
            }
            FrameField[] sourceReads = anno.reads();
            FrameField[] sourceWrites = anno.writes();
            Set<FrameField> targetReads = MethodIndex.METHOD_FRAME_READS.get(newName);
            Set<FrameField> targetWrites = MethodIndex.METHOD_FRAME_READS.get(newName);
            boolean readsSuperset = sourceReads.length == 0 || targetReads != null && targetReads.containsAll(Arrays.asList(sourceReads));
            boolean bl = writesSuperset = sourceWrites.length == 0 || targetWrites != null && targetWrites.containsAll(Arrays.asList(sourceWrites));
            if (!readsSuperset || !writesSuperset) {
                MethodIndex.addMethodReadFields(newName, sourceReads);
                MethodIndex.addMethodWriteFields(newName, sourceWrites);
                if (context.runtime.isVerbose()) {
                    RubyBasicObject attached;
                    String baseName = this.getBaseName();
                    int refChar = 35;
                    String simpleName = this.getSimpleName(context);
                    if (baseName == null && this instanceof MetaClass && (attached = ((MetaClass)this).getAttached()) instanceof RubyModule) {
                        simpleName = ((RubyModule)attached).getSimpleName(context);
                        refChar = 46;
                    }
                    Warn.warning(context, simpleName + (char)refChar + id + " accesses caller method's state and should not be aliased");
                }
            }
        }
    }

    @Deprecated(since="10.0.0.0")
    public RubyClass defineOrGetClassUnder(String name2, RubyClass superClazz) {
        return this.defineClassUnder(this.getCurrentContext(), name2, superClazz, null, null, -1);
    }

    @Deprecated(since="10.0.0.0")
    public RubyClass defineOrGetClassUnder(String name2, RubyClass superClazz, String file2, int line) {
        return this.defineClassUnder(this.getCurrentContext(), name2, superClazz, null, file2, line);
    }

    @Deprecated(since="10.0.0.0")
    public RubyClass defineOrGetClassUnder(String name2, RubyClass superClazz, ObjectAllocator allocator) {
        return this.defineClassUnder(this.getCurrentContext(), name2, superClazz, allocator, null, -1);
    }

    @Deprecated(since="10.0.0.0")
    public RubyClass defineOrGetClassUnder(String name2, RubyClass superClazz, ObjectAllocator allocator, String file2, int line) {
        return this.defineClassUnder(this.getCurrentContext(), name2, superClazz, allocator, file2, line);
    }

    public RubyClass defineClassUnder(ThreadContext context, String name2, RubyClass superClazz, ObjectAllocator allocator, String file2, int line) {
        RubyClass clazz;
        IRubyObject classObj = this.getConstantAtSpecial(context, name2);
        if (classObj != null) {
            if (!(classObj instanceof RubyClass)) {
                throw Error.typeError(context, name2 + " is not a class");
            }
            RubyClass clazzy = (RubyClass)classObj;
            clazz = clazzy;
            if (superClazz != null) {
                RubyClass tmp;
                for (tmp = clazz.getSuperClass(); tmp != null && tmp.isIncluded(); tmp = tmp.getSuperClass()) {
                }
                if (tmp != null) {
                    tmp = tmp.getRealClass();
                }
                if (tmp != superClazz) {
                    throw Error.typeError(context, "superclass mismatch for class " + String.valueOf(RubyStringBuilder.ids(context.runtime, name2)));
                }
            }
        } else {
            clazz = this.searchProvidersForClass(context, name2, superClazz);
            if (clazz == null) {
                if (superClazz == null) {
                    superClazz = Access.objectClass(context);
                }
                if (allocator == null) {
                    allocator = this.isReifiable(Access.objectClass(context), superClazz) ? (Options.REIFY_CLASSES.load().booleanValue() ? REIFYING_OBJECT_ALLOCATOR : (Options.REIFY_VARIABLES.load().booleanValue() ? IVAR_INSPECTING_OBJECT_ALLOCATOR : OBJECT_ALLOCATOR)) : superClazz.getAllocator();
                }
                clazz = RubyClass.newClass(context, superClazz, name2, allocator, this, true, file2, line);
            }
        }
        return clazz;
    }

    private boolean isReifiable(RubyClass Object2, RubyClass superClass) {
        return superClass == Object2 || superClass.getAllocator() == IVAR_INSPECTING_OBJECT_ALLOCATOR;
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule defineOrGetModuleUnder(String name2) {
        return this.defineOrGetModuleUnder(this.getCurrentContext(), name2, null, -1);
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule defineOrGetModuleUnder(String name2, String file2, int line) {
        return this.defineOrGetModuleUnder(this.getCurrentContext(), name2, file2, line);
    }

    @Interp
    @JIT
    public RubyModule defineOrGetModuleUnder(ThreadContext context, String name2, String file2, int line) {
        RubyModule module;
        IRubyObject moduleObj = this.getConstantAtSpecial(context, name2);
        if (moduleObj != null) {
            if (!moduleObj.isModule()) {
                throw Error.typeError(context, BUILTIN_CONSTANT, moduleObj, " is not a module");
            }
            module = (RubyModule)moduleObj;
        } else {
            module = this.searchProvidersForModule(context, name2);
            if (module == null) {
                module = RubyModule.newModule(context, name2, this, true, file2, line);
            }
        }
        return module;
    }

    @Deprecated(since="10.0.0.0")
    public RubyClass defineClassUnder(String name2, RubyClass superClass, ObjectAllocator allocator) {
        return this.defineClassUnder(this.getCurrentContext(), name2, superClass, allocator);
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule defineModuleUnder(String name2) {
        return this.defineModuleUnder(this.getCurrentContext(), name2);
    }

    private void addAccessor(ThreadContext context, RubySymbol identifier, Visibility visibility, boolean readable, boolean writeable) {
        String internedIdentifier = identifier.idString();
        if (visibility == Visibility.MODULE_FUNCTION) {
            Warn.warning(context, "attribute accessor as module_function");
            visibility = Visibility.PRIVATE;
        }
        if (!identifier.validLocalVariableName() && !identifier.validConstantName()) {
            throw Error.nameError(context, "invalid attribute name", identifier);
        }
        String variableName = identifier.asInstanceVariable().idString();
        if (readable) {
            this.addMethod(context, internedIdentifier, new AttrReaderMethod(this.getMethodLocation(), visibility, variableName));
            this.methodAdded(context, identifier);
        }
        if (writeable) {
            identifier = identifier.asWriter();
            this.addMethod(context, identifier.idString(), new AttrWriterMethod(this.getMethodLocation(), visibility, variableName));
            this.methodAdded(context, identifier);
        }
    }

    protected void methodAdded(ThreadContext context, RubySymbol identifier) {
        if (this.isSingleton()) {
            ((MetaClass)this).getAttached().callMethod(context, "singleton_method_added", (IRubyObject)identifier);
        } else {
            this.callMethod(context, "method_added", (IRubyObject)identifier);
        }
    }

    private void methodUndefined(ThreadContext context, RubySymbol nameSymbol) {
        if (this.isSingleton()) {
            ((MetaClass)this).getAttached().callMethod(context, "singleton_method_undefined", (IRubyObject)nameSymbol);
        } else {
            this.callMethod(context, "method_undefined", (IRubyObject)nameSymbol);
        }
    }

    private void methodRemoved(ThreadContext context, RubySymbol name2) {
        if (this.isSingleton()) {
            ((MetaClass)this).getAttached().callMethod(context, "singleton_method_removed", (IRubyObject)name2);
        } else {
            this.callMethod(context, "method_removed", (IRubyObject)name2);
        }
    }

    @Deprecated(since="10.0.0.0")
    public void setMethodVisibility(IRubyObject[] methods2, Visibility visibility) {
        this.setMethodVisibility(this.getCurrentContext(), methods2, visibility);
    }

    public void setMethodVisibility(ThreadContext context, IRubyObject[] methods2, Visibility visibility) {
        if (methods2.length == 1 && methods2[0] instanceof RubyArray) {
            this.setMethodVisibility(context, ((RubyArray)methods2[0]).toJavaArray(context), visibility);
            return;
        }
        for (IRubyObject method2 : methods2) {
            this.exportMethod(context, Check.checkID(context, method2).idString(), visibility);
        }
    }

    @Deprecated(since="10.0.0.0")
    public void exportMethod(String name2, Visibility visibility) {
        this.exportMethod(this.getCurrentContext(), name2, visibility);
    }

    private void exportMethod(ThreadContext context, String name2, Visibility visibility) {
        CacheEntry entry = this.getMethodLocation().deepMethodSearch(context, name2);
        DynamicMethod method2 = entry.method;
        if (method2.getVisibility() != visibility) {
            if (this == method2.getImplementationClass()) {
                method2.setVisibility(visibility);
            } else {
                PartialDelegatingMethod newMethod = new PartialDelegatingMethod(this, entry, visibility);
                this.getMethodLocation().addMethod(context, name2, newMethod);
            }
            this.invalidateCacheDescendants(context);
        }
    }

    private CacheEntry deepMethodSearch(ThreadContext context, String id) {
        CacheEntry orig;
        block4: {
            block5: {
                orig = this.searchWithCache(id);
                if (orig.method.isRefined()) {
                    orig = this.resolveRefinedMethod(null, orig, id);
                }
                if (!orig.method.isUndefined() && !orig.method.isRefined()) break block4;
                if (!this.isModule()) break block5;
                orig = Access.objectClass(context).searchWithCache(id);
                if (!orig.method.isUndefined()) break block4;
            }
            RubySymbol name2 = Convert.asSymbol(context, id);
            throw Error.nameError(context, RubyModule.undefinedMethodMessage(context.runtime, name2, this.rubyName(context), this.isModule()), name2);
        }
        return orig;
    }

    public static String undefinedMethodMessage(Ruby runtime2, IRubyObject name2, IRubyObject modName, boolean isModule) {
        return RubyStringBuilder.str(runtime2, "undefined method '", name2, "' for " + (isModule ? "module" : "class") + " '", modName, "'");
    }

    public boolean isMethodBound(String name2, boolean checkVisibility) {
        DynamicMethod method2 = this.searchMethod(name2);
        return !method2.isUndefined() && (!checkVisibility || method2.getVisibility() != Visibility.PRIVATE);
    }

    public boolean respondsToMethod(String name2, boolean checkVisibility, StaticScope scope) {
        return Helpers.respondsToMethod(this.searchWithRefinements((String)name2, (StaticScope)scope).method, checkVisibility);
    }

    public boolean respondsToMethod(String name2, boolean checkVisibility) {
        return Helpers.respondsToMethod(this.searchMethod(name2), checkVisibility);
    }

    @Deprecated(since="9.1.7.0")
    public boolean isMethodBound(String name2, boolean checkVisibility, boolean checkRespondTo) {
        return checkRespondTo ? this.respondsToMethod(name2, checkVisibility) : this.isMethodBound(name2, checkVisibility);
    }

    @Deprecated(since="10.0.0.0")
    public final IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility) {
        return this.newMethod(this.getCurrentContext(), receiver2, methodName, null, bound, visibility, false, true);
    }

    @Deprecated(since="10.0.0.0")
    public final IRubyObject newMethod(IRubyObject receiver2, String methodName, StaticScope refinedScope, boolean bound, Visibility visibility) {
        return this.newMethod(this.getCurrentContext(), receiver2, methodName, refinedScope, bound, visibility, false, true);
    }

    @Deprecated(since="10.0.0.0")
    public final IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility, boolean respondToMissing) {
        return this.newMethod(this.getCurrentContext(), receiver2, methodName, null, bound, visibility, respondToMissing, true);
    }

    @Deprecated(since="10.0.0.0")
    public final IRubyObject newMethod(IRubyObject receiver2, String methodName, StaticScope scope, boolean bound, Visibility visibility, boolean respondToMissing) {
        return this.newMethod(this.getCurrentContext(), receiver2, methodName, scope, bound, visibility, respondToMissing, true);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility, boolean respondToMissing, boolean priv) {
        return this.newMethod(this.getCurrentContext(), receiver2, methodName, null, bound, visibility, respondToMissing, priv);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject newMethod(IRubyObject receiver2, String methodName, StaticScope scope, boolean bound, Visibility visibility, boolean respondToMissing, boolean priv) {
        return this.newMethod(this.getCurrentContext(), receiver2, methodName, scope, bound, visibility, respondToMissing, priv);
    }

    protected IRubyObject newMethod(ThreadContext context, IRubyObject receiver2, String methodName, StaticScope scope, boolean bound, Visibility visibility, boolean respondToMissing, boolean priv) {
        RubyModule originModule;
        CacheEntry entry;
        CacheEntry cacheEntry = entry = scope == null ? this.searchWithCache(methodName) : this.searchWithRefinements(methodName, scope);
        if (entry.method.isUndefined() || visibility != null && entry.method.getVisibility() != visibility) {
            if (!respondToMissing || !receiver2.respondsToMissing(methodName, priv)) {
                throw Error.nameError(context, "undefined method '" + methodName + "' for class '" + this.getName(context) + "'", methodName);
            }
            entry = new CacheEntry(new RespondToMissingMethod(this, Visibility.PUBLIC, methodName), entry.sourceModule, entry.token);
        }
        RubyModule implementationModule = entry.method.getDefinedClass();
        for (originModule = this; originModule != implementationModule && (originModule.isSingleton() || originModule.isIncluded()); originModule = originModule.getSuperClass()) {
        }
        AbstractRubyMethod newMethod = bound ? RubyMethod.newMethod(implementationModule, methodName, originModule, methodName, entry, receiver2) : RubyUnboundMethod.newUnboundMethod(implementationModule, methodName, originModule, methodName, entry);
        return newMethod;
    }

    @JRubyMethod(name={"define_method"}, reads={FrameField.VISIBILITY})
    public IRubyObject define_method(ThreadContext context, IRubyObject arg0, Block block) {
        Visibility visibility = this.getCurrentVisibilityForDefineMethod(context);
        return this.defineMethodFromBlock(context, arg0, block, visibility);
    }

    private Visibility getCurrentVisibilityForDefineMethod(ThreadContext context) {
        return context.getCurrentFrame().getSelf() == this ? context.getCurrentVisibility() : Visibility.PUBLIC;
    }

    public IRubyObject defineMethodFromBlock(ThreadContext context, IRubyObject arg0, Block block, Visibility visibility) {
        BlockBody blockBody;
        RubySymbol name2 = Check.checkID(context, arg0);
        if (!block.isGiven()) {
            throw Error.argumentError(context, "tried to create Proc object without a block");
        }
        if ("initialize".equals(name2.idString())) {
            visibility = Visibility.PRIVATE;
        }
        if ((blockBody = block.getBody()) instanceof IRBlockBody) {
            IRMethod method2;
            IRClosure closure;
            IRBlockBody body = (IRBlockBody)blockBody;
            if (Access.instanceConfig(context).getCompileMode().shouldJIT() && (closure = body.getScope()) != null && (method2 = closure.convertToMethod(name2.getBytes())) != null) {
                DefineMethodMethod newMethod = new DefineMethodMethod(method2, visibility, this, context.getFrameBlock());
                Helpers.addInstanceMethod(this, name2, newMethod, visibility, context);
                return name2;
            }
        }
        DynamicMethod newMethod = this.createProcMethod(context.runtime, name2.idString(), visibility, block);
        Helpers.addInstanceMethod(this, name2, newMethod, visibility, context);
        return name2;
    }

    @JRubyMethod(name={"define_method"}, reads={FrameField.VISIBILITY})
    public IRubyObject define_method(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        Visibility visibility = this.getCurrentVisibilityForDefineMethod(context);
        return this.defineMethodFromCallable(context, arg0, arg1, visibility);
    }

    public IRubyObject defineMethodFromCallable(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Visibility visibility) {
        DynamicMethod newMethod;
        RubySymbol name2 = Check.checkID(context, arg0);
        if ("initialize".equals(name2.idString())) {
            visibility = Visibility.PRIVATE;
        }
        if (context.runtime.getProc().isInstance(arg1)) {
            RubyProc proc2 = (RubyProc)arg1;
            newMethod = this.createProcMethod(context.runtime, name2.idString(), visibility, proc2.getBlock());
        } else if (arg1 instanceof AbstractRubyMethod) {
            AbstractRubyMethod method2 = (AbstractRubyMethod)arg1;
            this.checkValidBindTargetFrom(context, (RubyModule)method2.owner(context), false);
            newMethod = method2.getMethod().dup();
            newMethod.setImplementationClass(this);
            newMethod.setVisibility(visibility);
        } else {
            throw Error.typeError(context, arg1, "Proc/Method/UnboundMethod");
        }
        Helpers.addInstanceMethod(this, name2, newMethod, visibility, context);
        return name2;
    }

    @Deprecated(since="1.1.2")
    public IRubyObject define_method(ThreadContext context, IRubyObject[] args2, Block block) {
        return switch (args2.length) {
            case 1 -> this.define_method(context, args2[0], block);
            case 2 -> this.define_method(context, args2[0], args2[1], block);
            default -> throw Error.argumentError(context, "wrong number of arguments (" + args2.length + " for 2)");
        };
    }

    private DynamicMethod createProcMethod(Ruby runtime2, String name2, Visibility visibility, Block block) {
        block = block.cloneBlockAndFrame();
        block.getBinding().getFrame().setKlazz(this);
        block.getBinding().getFrame().setName(name2);
        RubyProc proc2 = RubyProc.newMethodProc(runtime2, block);
        block.getBody().getStaticScope().makeArgumentScope();
        return new ProcMethod(this, proc2, visibility, name2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject name() {
        return this.name(this.getCurrentContext());
    }

    @JRubyMethod(name={"name"})
    public IRubyObject name(ThreadContext context) {
        return this.getBaseName() == null ? context.nil : this.rubyName(context);
    }

    @Deprecated(since="10.0.0.0")
    protected final IRubyObject cloneMethods(RubyModule clone2) {
        return this.cloneMethods(this.getCurrentContext(), clone2);
    }

    protected final IRubyObject cloneMethods(ThreadContext context, RubyModule clone2) {
        RubyModule realType = this.getOrigin();
        for (Map.Entry<String, DynamicMethod> entry : this.getMethods().entrySet()) {
            DynamicMethod method2 = entry.getValue();
            if (!method2.isImplementedBy(realType) && !method2.isUndefined()) continue;
            DynamicMethod clonedMethod = method2.dup();
            clonedMethod.setImplementationClass(clone2);
            clone2.putMethod(context.runtime, entry.getKey(), clonedMethod);
        }
        return clone2;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject original) {
        RubyModule rubyModule = this;
        if (rubyModule instanceof RubyClass) {
            RubyClass klazz = (RubyClass)rubyModule;
            this.checkSafeTypeToCopy(context, klazz);
        }
        super.initialize_copy(context, original);
        RubyModule originalModule = (RubyModule)original;
        if (!this.getMetaClass().isSingleton()) {
            this.setMetaClass(originalModule.getSingletonClassCloneAndAttach(context, this));
        }
        this.superClass(originalModule.superClass());
        if (originalModule.hasVariables()) {
            this.syncVariables(originalModule);
        }
        this.syncConstants(originalModule);
        originalModule.cloneMethods(context, this);
        this.javaProxy = originalModule.javaProxy;
        return this;
    }

    private void checkSafeTypeToCopy(ThreadContext context, RubyClass original) {
        RubyClass BasicObject = Access.basicObjectClass(context);
        if (original == BasicObject) {
            throw Error.typeError(context, "can't copy the root class");
        }
        if (this.getSuperClass() == BasicObject) {
            throw Error.typeError(context, "already initialized class");
        }
        if (original.isSingleton()) {
            throw Error.typeError(context, "can't copy singleton class");
        }
    }

    public void syncConstants(RubyModule other) {
        Map<String, Autoload> autoloadMap;
        if (other.getConstantMap() != Collections.EMPTY_MAP) {
            this.getConstantMapForWrite().putAll(other.getConstantMap());
        }
        if (!(autoloadMap = other.getAutoloadMap()).isEmpty()) {
            this.autoloads = autoloadMap;
        }
    }

    public void syncClassVariables(RubyModule other) {
        if (other.getClassVariablesForRead() != Collections.EMPTY_MAP) {
            this.getClassVariables().putAll(other.getClassVariablesForRead());
        }
    }

    @JRubyMethod(name={"included_modules"})
    public RubyArray included_modules(ThreadContext context) {
        RubyArray<?> ary = Create.newArray(context);
        for (RubyClass p2 = this.getSuperClass(); p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.isIncluded()) continue;
            ary.append(context, p2.getDelegate().getOrigin());
        }
        return ary;
    }

    public boolean hasPrepends() {
        return this.methodLocation != null;
    }

    @JRubyMethod(name={"ancestors"})
    public RubyArray ancestors(ThreadContext context) {
        return Create.newArray(context, this.getAncestorList());
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray ancestors() {
        return this.ancestors(this.getCurrentContext());
    }

    public List<IRubyObject> getAncestorList() {
        ArrayList<IRubyObject> list2 = new ArrayList<IRubyObject>(4);
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (module.getMethodLocation() != module) continue;
            list2.add(module.getDelegate().getOrigin());
        }
        return list2;
    }

    public boolean hasModuleInPrepends(RubyModule type2) {
        RubyModule methodLocation = this.methodLocation;
        if (methodLocation == null) {
            return false;
        }
        for (RubyClass module = this.getSuperClass(); module != methodLocation; module = module.getSuperClass()) {
            if (type2 != module.getOrigin()) continue;
            return true;
        }
        return false;
    }

    private RubyModule getPrependCeiling() {
        RubyModule methodLocation = this.getMethodLocation();
        RubyClass mlSuper = methodLocation.getSuperClass();
        return mlSuper == null ? methodLocation : mlSuper.getRealClass();
    }

    public boolean hasModuleInHierarchy(RubyModule type2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (module.getOrigin() != type2) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        RubyClass metaClass = this.metaClass;
        if (metaClass == null) {
            return this.id;
        }
        if (this.getJavaProxy()) {
            return this.id;
        }
        Ruby runtime2 = metaClass.getClassRuntime();
        if (runtime2.isBooting()) {
            return this.id;
        }
        ThreadContext context = runtime2.getCurrentContext();
        CachingCallSite hash2 = RubyModule.sites((ThreadContext)context).hash;
        if (hash2.isBuiltin(this)) {
            return this.id;
        }
        return (int)hash2.call(context, this, this).convertToInteger().getLongValue();
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.id);
    }

    @Override
    public RubyString to_s() {
        return (RubyString)this.to_s(this.getCurrentContext());
    }

    @Override
    @JRubyMethod(name={"to_s"}, alias={"inspect"})
    public IRubyObject to_s(ThreadContext context) {
        RubyModule refinedClass;
        if (this.isSingleton()) {
            RubyBasicObject attached = ((MetaClass)this).getAttached();
            RubyString buffer = Create.newString(context, "#<Class:");
            if (attached instanceof RubyModule) {
                buffer.catWithCodeRange(attached.inspect(context).convertToString());
            } else if (attached != null) {
                buffer.catWithCodeRange(Convert.anyToString(context, attached));
            }
            buffer.cat(62, buffer.getEncoding());
            return buffer;
        }
        RefinementStore refinementStore = this.refinementStore;
        if (refinementStore != null && (refinedClass = refinementStore.refinedClass) != null) {
            RubyString buffer = Create.newString(context, "#<refinement:");
            buffer.catWithCodeRange(refinedClass.inspect(context).convertToString());
            buffer.cat(64, buffer.getEncoding());
            buffer.catWithCodeRange(refinementStore.definedAt.inspect(context).convertToString());
            buffer.cat(62, buffer.getEncoding());
            return buffer;
        }
        return Create.dupString(context, this.rubyName(context));
    }

    @Override
    @JRubyMethod(name={"==="})
    public RubyBoolean op_eqq(ThreadContext context, IRubyObject obj) {
        return Convert.asBoolean(context, this.isInstance(obj));
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyModule)) {
            return context.fals;
        }
        RubyModule otherModule = (RubyModule)other;
        if (otherModule.isIncluded()) {
            return Convert.asBoolean(context, otherModule.isSame(this));
        }
        return Convert.asBoolean(context, this.isSame(otherModule));
    }

    @Override
    @JRubyMethod(name={"freeze"})
    public final IRubyObject freeze(ThreadContext context) {
        this.to_s(context);
        return super.freeze(context);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_le(IRubyObject arg2) {
        return this.op_le(this.getCurrentContext(), arg2);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject arg2) {
        RubyModule argMod = Convert.castAsModule(context, arg2, "compared with non class/module");
        if (this.searchAncestor(argMod.getMethodLocation()) != null) {
            return context.tru;
        }
        if (argMod.searchAncestor(this) != null) {
            return context.fals;
        }
        return context.nil;
    }

    protected RubyModule searchAncestor(RubyModule c) {
        for (RubyModule cl = this; cl != null; cl = cl.getSuperClass()) {
            if (cl != c && !cl.isSame(c) && cl.getDelegate().getOrigin() != c) continue;
            return cl;
        }
        return null;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_lt(IRubyObject obj) {
        return this.op_lt(this.getCurrentContext(), obj);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject obj) {
        return obj == this ? context.fals : this.op_le(context, obj);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_ge(IRubyObject obj) {
        return this.op_ge(this.getCurrentContext(), obj);
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject obj) {
        return Convert.castAsModule(context, obj, "compared with non class/module").op_le(context, this);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_gt(IRubyObject obj) {
        return this.op_gt(this.getCurrentContext(), obj);
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject obj) {
        return this == obj ? context.fals : this.op_ge(context, obj);
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject obj) {
        if (this == obj) {
            return Convert.asFixnum(context, 0);
        }
        if (!(obj instanceof RubyModule)) {
            return context.nil;
        }
        RubyModule module = (RubyModule)obj;
        if (module.isKindOfModule(this)) {
            return Convert.asFixnum(context, 1);
        }
        if (this.isKindOfModule(module)) {
            return Convert.asFixnum(context, -1);
        }
        return context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_cmp(IRubyObject obj) {
        return this.op_cmp(this.getCurrentContext(), obj);
    }

    public boolean isKindOfModule(RubyModule type2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.isSame(type2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSame(RubyModule module) {
        return this == module;
    }

    protected boolean isSameOrigin(RubyModule other) {
        return this.getOrigin() == other.getOrigin();
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        if (block.isGiven()) {
            this.module_exec(context, new IRubyObject[]{this}, block);
        }
        return context.nil;
    }

    public void addReadWriteAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, RubySymbol.newHardSymbol(context.runtime, name2.intern()), Visibility.PUBLIC, true, true);
    }

    public void addReadAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, RubySymbol.newHardSymbol(context.runtime, name2.intern()), Visibility.PUBLIC, true, false);
    }

    public void addWriteAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, RubySymbol.newHardSymbol(context.runtime, name2.intern()), Visibility.PUBLIC, false, true);
    }

    @JRubyMethod(required=1, rest=true, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject ruby2_keywords(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, -1);
        this.checkFrozen();
        for (IRubyObject name2 : args2) {
            String id = RubySymbol.idStringFromObject(context, name2);
            DynamicMethod method2 = this.searchMethod(id);
            if (method2.isUndefined() && this.isModule()) {
                method2 = Access.objectClass(context).searchMethod(id);
            }
            if (method2.isUndefined()) {
                throw Error.nameError(context, RubyModule.undefinedMethodMessage(context.runtime, name2, this.rubyName(context), this.isModule()), name2);
            }
            if (method2.getDefinedClass() == this) {
                if (!method2.isNative()) {
                    Signature signature = method2.getSignature();
                    if (!signature.hasRest()) {
                        Warn.warn(context, RubyStringBuilder.str(context.runtime, "Skipping set of ruby2_keywords flag for ", RubyStringBuilder.ids(context.runtime, name2), " (method accepts keywords or method does not accept argument splat)"));
                        continue;
                    }
                    if (!signature.hasKwargs()) {
                        method2.setRuby2Keywords();
                        continue;
                    }
                    if (!(method2 instanceof AbstractIRMethod) || ((AbstractIRMethod)method2).getStaticScope().exists("...") != -1) continue;
                    Warn.warn(context, RubyStringBuilder.str(context.runtime, "Skipping set of ruby2_keywords flag for ", RubyStringBuilder.ids(context.runtime, name2), " (method accepts keywords or method does not accept argument splat)"));
                    continue;
                }
                Warn.warn(context, RubyStringBuilder.str(context.runtime, "Skipping set of ruby2_keywords flag for ", RubyStringBuilder.ids(context.runtime, name2), " (method not defined in Ruby)"));
                continue;
            }
            Warn.warn(context, RubyStringBuilder.str(context.runtime, "Skipping set of ruby2_keywords flag for ", RubyStringBuilder.ids(context.runtime, name2), " (can only set in method defining module)"));
        }
        return context.nil;
    }

    @JRubyMethod(name={"attr"}, rest=true, reads={FrameField.VISIBILITY})
    public IRubyObject attr(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 2 && (args2[1] == context.tru || args2[1] == context.fals)) {
            Warn.warningDeprecated(context, "optional boolean argument is obsoleted");
            boolean writeable = args2[1].isTrue();
            RubySymbol sym = Check.checkID(context, args2[0]);
            this.addAccessor(context, sym, this.getCurrentVisibilityForDefineMethod(context), args2[0].isTrue(), writeable);
            return writeable ? Create.newArray(context, (IRubyObject)sym, (IRubyObject)Convert.asSymbol(context, sym.getBytes().dup().append(61))) : Create.newArray(context, (IRubyObject)sym);
        }
        return this.attr_reader(context, args2);
    }

    @Deprecated(since="1.1.5")
    public IRubyObject attr_reader(IRubyObject[] args2) {
        return this.attr_reader(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"attr_reader"}, rest=true, reads={FrameField.VISIBILITY})
    public IRubyObject attr_reader(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = this.getCurrentVisibilityForDefineMethod(context);
        IRubyObject[] result2 = new IRubyObject[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            RubySymbol sym = Check.checkID(context, args2[i2]);
            result2[i2] = sym;
            this.addAccessor(context, sym, visibility, true, false);
        }
        return Create.newArray(context, result2);
    }

    @JRubyMethod(name={"attr_writer"}, rest=true, reads={FrameField.VISIBILITY})
    public IRubyObject attr_writer(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = this.getCurrentVisibilityForDefineMethod(context);
        IRubyObject[] result2 = new IRubyObject[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            RubySymbol sym = Check.checkID(context, args2[i2]);
            ByteList writer = sym.getBytes().dup().append(61);
            result2[i2] = Convert.asSymbol(context, writer);
            this.addAccessor(context, sym, visibility, false, true);
        }
        return Create.newArray(context, result2);
    }

    @Deprecated(since="1.1.5")
    public IRubyObject attr_accessor(IRubyObject[] args2) {
        return this.attr_accessor(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"attr_accessor"}, rest=true, reads={FrameField.VISIBILITY})
    public IRubyObject attr_accessor(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = this.getCurrentVisibilityForDefineMethod(context);
        IRubyObject[] result2 = new IRubyObject[2 * args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            RubySymbol sym = Check.checkID(context, args2[i2]);
            ByteList reader = sym.getBytes().shallowDup();
            result2[i2 * 2] = Convert.asSymbol(context, reader);
            ByteList writer = sym.getBytes().dup().append(61);
            result2[i2 * 2 + 1] = Convert.asSymbol(context, writer);
            this.addAccessor(context, sym, visibility, true, true);
        }
        return Create.newArray(context, result2);
    }

    @Deprecated(since="10.0.0.0")
    private RubyArray instance_methods(IRubyObject[] args2, Visibility visibility, boolean not) {
        boolean includeSuper = args2.length > 0 ? args2[0].isTrue() : true;
        return this.instanceMethods(this.getCurrentContext(), visibility, includeSuper, true, not);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray instanceMethods(IRubyObject[] args2, Visibility visibility, boolean obj, boolean not) {
        return this.instanceMethods(this.getCurrentContext(), args2, visibility, obj, not);
    }

    public RubyArray instanceMethods(ThreadContext context, IRubyObject[] args2, Visibility visibility, boolean obj, boolean not) {
        boolean includeSuper = args2.length > 0 ? args2[0].isTrue() : true;
        return this.instanceMethods(context, visibility, includeSuper, obj, not);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray instanceMethods(Visibility visibility, boolean includeSuper, boolean obj, boolean not) {
        return this.instanceMethods(this.getCurrentContext(), visibility, includeSuper, obj, not);
    }

    private RubyArray instanceMethods(ThreadContext context, Visibility visibility, boolean includeSuper, boolean obj, boolean not) {
        RubyArray<?> ary = Create.newArray(context);
        this.populateInstanceMethodNames(context, new HashSet<String>(), ary, visibility, obj, not, includeSuper);
        return ary;
    }

    final void populateInstanceMethodNames(ThreadContext context, Set<String> seen, RubyArray ary, Visibility visibility, boolean obj, boolean not, boolean recur) {
        RubyModule mod = this;
        boolean prepended2 = false;
        RubyModule methodLocation = this.methodLocation;
        if (!recur && methodLocation != null) {
            mod = methodLocation;
            prepended2 = true;
        }
        while (mod != null) {
            mod.addMethodSymbols(context.runtime, seen, ary, not, visibility);
            if (!(!prepended2 && mod.isIncluded() || obj && mod.isSingleton() || recur)) break;
            mod = mod.getSuperClass();
        }
    }

    @Deprecated(since="10.0.0.0")
    protected void addMethodSymbols(Ruby runtime2, Set<String> seen, RubyArray ary, boolean not, Visibility visibility) {
        this.addMethodSymbols(this.getCurrentContext(), seen, ary, not, visibility);
    }

    protected void addMethodSymbols(ThreadContext context, Set<String> seen, RubyArray ary, boolean not, Visibility visibility) {
        this.getMethods().forEach((id, method2) -> {
            if (method2 instanceof RefinedMarker) {
                return;
            }
            if (seen.add((String)id) && (!not && method2.getVisibility() == visibility || not && method2.getVisibility() != visibility) && !method2.isUndefined()) {
                ary.append(context, Convert.asSymbol(context, id));
            }
        });
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray<?> instance_methods19(IRubyObject[] args2) {
        return this.instance_methods(args2);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray<?> instance_methods(IRubyObject[] args2) {
        return this.instance_methods(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"instance_methods"}, optional=1, checkArity=false)
    public RubyArray instance_methods(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return this.instanceMethods(context, args2, Visibility.PRIVATE, false, true);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray<?> public_instance_methods19(IRubyObject[] args2) {
        return this.public_instance_methods(args2);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray<?> public_instance_methods(IRubyObject[] args2) {
        return this.public_instance_methods(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"public_instance_methods"}, optional=1, checkArity=false)
    public RubyArray public_instance_methods(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return this.instanceMethods(context, args2, Visibility.PUBLIC, false, false);
    }

    @JRubyMethod(name={"instance_method"}, reads={FrameField.SCOPE})
    public IRubyObject instance_method(ThreadContext context, IRubyObject symbol) {
        return this.newMethod(context, null, Check.checkID(context, symbol).idString(), context.getCurrentStaticScope(), false, null, false, true);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject instance_method(IRubyObject symbol) {
        return this.instance_method(this.getCurrentContext(), symbol);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject public_instance_method(IRubyObject symbol) {
        return this.public_instance_method(this.getCurrentContext(), symbol);
    }

    @JRubyMethod(name={"public_instance_method"})
    public IRubyObject public_instance_method(ThreadContext context, IRubyObject symbol) {
        return this.newMethod(context, null, Check.checkID(context, symbol).idString(), null, false, Visibility.PUBLIC, false, true);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray protected_instance_methods(IRubyObject[] args2) {
        return this.protected_instance_methods(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"protected_instance_methods"}, optional=1, checkArity=false)
    public RubyArray protected_instance_methods(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return this.instanceMethods(context, args2, Visibility.PROTECTED, false, false);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray private_instance_methods(IRubyObject[] args2) {
        return this.private_instance_methods(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"private_instance_methods"}, optional=1, checkArity=false)
    public RubyArray private_instance_methods(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return this.instanceMethods(context, args2, Visibility.PRIVATE, false, false);
    }

    @JRubyMethod(name={"undefined_instance_methods"})
    public IRubyObject undefined_instance_method(ThreadContext context) {
        RubyArray<?> list2 = Create.newArray(context);
        this.getMethods().forEach((id, method2) -> {
            if (method2 instanceof RefinedMarker) {
                return;
            }
            if (method2.isUndefined()) {
                list2.append(context, Convert.asSymbol(context, id));
            }
        });
        return list2;
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule prepend_features(IRubyObject include2) {
        return this.prepend_features(this.getCurrentContext(), include2);
    }

    @JRubyMethod(name={"prepend_features"}, visibility=Visibility.PRIVATE)
    public RubyModule prepend_features(ThreadContext context, IRubyObject include2) {
        this.verifyNormalModule(context, include2).prependModule(context, this);
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule append_features(IRubyObject include2) {
        return this.append_features(this.getCurrentContext(), include2);
    }

    @JRubyMethod(name={"append_features"}, visibility=Visibility.PRIVATE)
    public RubyModule append_features(ThreadContext context, IRubyObject include2) {
        this.verifyNormalModule(context, include2).include(context, this);
        return this;
    }

    private RubyModule verifyNormalModule(ThreadContext context, IRubyObject include2) {
        if (!this.isModule()) {
            throw Error.typeError(context, (IRubyObject)this, "Module");
        }
        RubyModule mod = Convert.castAsModule(context, include2);
        if (!mod.isModule() && !mod.isClass()) {
            throw Error.typeError(context, include2, "Module");
        }
        return mod;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject extend_object(IRubyObject obj) {
        return this.extend_object(this.getCurrentContext(), obj);
    }

    @JRubyMethod(name={"extend_object"}, visibility=Visibility.PRIVATE)
    public IRubyObject extend_object(ThreadContext context, IRubyObject obj) {
        if (!this.isModule()) {
            throw Error.typeError(context, (IRubyObject)this, "Module");
        }
        obj.singletonClass(context).include(context, this);
        return obj;
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule include(IRubyObject[] modules) {
        return this.include(this.getCurrentContext(), modules);
    }

    @JRubyMethod(name={"include"}, required=1, rest=true, checkArity=false)
    public RubyModule include(ThreadContext context, IRubyObject[] modules) {
        int argc = Arity.checkArgumentCount(context, modules, 1, -1);
        if (this.isRefinement()) {
            throw Error.typeError(context, "Refinement#include has been removed");
        }
        for (IRubyObject module : modules) {
            if (!module.isModule()) {
                throw Error.typeError(context, module, "Module");
            }
            if (!((RubyModule)module).isRefinement()) continue;
            throw Error.typeError(context, "Cannot include refinement");
        }
        for (int i2 = argc - 1; i2 >= 0; --i2) {
            IRubyObject module = modules[i2];
            module.callMethod(context, "append_features", this);
            module.callMethod(context, "included", this);
        }
        return this;
    }

    @JRubyMethod(name={"include"})
    public RubyModule include(ThreadContext context, IRubyObject module) {
        if (this.isRefinement()) {
            throw Error.typeError(context, "Refinement#include has been removed");
        }
        if (!module.isModule()) {
            throw Error.typeError(context, module, "Module");
        }
        if (((RubyModule)module).isRefinement()) {
            throw Error.typeError(context, "Cannot include refinement");
        }
        module.callMethod(context, "append_features", this);
        module.callMethod(context, "included", this);
        return this;
    }

    @JRubyMethod(name={"included"}, visibility=Visibility.PRIVATE)
    public IRubyObject included(ThreadContext context, IRubyObject other) {
        return context.nil;
    }

    @JRubyMethod(name={"extended"}, visibility=Visibility.PRIVATE)
    public IRubyObject extended(ThreadContext context, IRubyObject other, Block block) {
        return context.nil;
    }

    @JRubyMethod(name={"mix"}, visibility=Visibility.PRIVATE)
    public IRubyObject mix(ThreadContext context, IRubyObject modArg) {
        RubyModule mod = Convert.castAsModule(context, modArg);
        Map<String, DynamicMethod> methods2 = mod.getMethods();
        for (Map.Entry<String, DynamicMethod> entry : methods2.entrySet()) {
            if (!this.getMethodLocation().getMethods().containsKey(entry.getKey())) continue;
            throw Error.argumentError(context, "method would conflict - " + entry.getKey());
        }
        for (Map.Entry<String, DynamicMethod> entry : methods2.entrySet()) {
            this.getMethodLocation().getMethodsForWrite().put(entry.getKey(), entry.getValue().dup());
        }
        return mod;
    }

    @JRubyMethod(name={"mix"}, visibility=Visibility.PRIVATE)
    public IRubyObject mix(ThreadContext context, IRubyObject modArg, IRubyObject hash0) {
        RubyModule mod = Convert.castAsModule(context, modArg);
        if (!mod.isModule()) {
            throw Error.typeError(context, (IRubyObject)mod, "Module");
        }
        RubyHash methodNames = Convert.castAsHash(context, hash0);
        for (Map.Entry entry : methodNames.directEntrySet()) {
            String name2 = ((IRubyObject)entry.getValue()).toString();
            if (!this.getMethods().containsKey(name2)) continue;
            throw Error.argumentError(context, "constant would conflict - " + name2);
        }
        for (Map.Entry entry : mod.getMethods().entrySet()) {
            if (!this.getMethods().containsKey(entry.getKey())) continue;
            throw Error.argumentError(context, "method would conflict - " + (String)entry.getKey());
        }
        for (Map.Entry entry : mod.getMethods().entrySet()) {
            String id = (String)entry.getKey();
            IRubyObject mapped = methodNames.fastARef(Convert.asSymbol(context, id));
            if (mapped != NEVER) {
                if (mapped == context.nil) continue;
                id = Check.checkID(context, mapped).idString();
            }
            this.getMethodLocation().getMethodsForWrite().put(id, ((DynamicMethod)entry.getValue()).dup());
        }
        return mod;
    }

    private void setVisibility(ThreadContext context, IRubyObject[] args2, Visibility visibility) {
        if (args2.length == 0) {
            context.setCurrentVisibility(visibility);
        } else {
            this.setMethodVisibility(context, args2, visibility);
        }
    }

    @JRubyMethod(name={"public"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public IRubyObject _public(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        this.setVisibility(context, args2, Visibility.PUBLIC);
        switch (args2.length) {
            case 0: {
                return context.nil;
            }
            case 1: {
                return args2[0];
            }
        }
        return Create.newArray(context, args2);
    }

    @Deprecated(since="9.4.0.0")
    public IRubyObject rbPublic(ThreadContext context, IRubyObject[] args2) {
        this._public(context, args2);
        return this;
    }

    @JRubyMethod(name={"protected"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public IRubyObject _protected(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        this.setVisibility(context, args2, Visibility.PROTECTED);
        switch (args2.length) {
            case 0: {
                return context.nil;
            }
            case 1: {
                return args2[0];
            }
        }
        return Create.newArray(context, args2);
    }

    @Deprecated(since="9.4.0.0")
    public IRubyObject rbProtected(ThreadContext context, IRubyObject[] args2) {
        this._protected(context, args2);
        return this;
    }

    @JRubyMethod(name={"private"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public IRubyObject _private(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        this.setVisibility(context, args2, Visibility.PRIVATE);
        switch (args2.length) {
            case 0: {
                return context.nil;
            }
            case 1: {
                return args2[0];
            }
        }
        return Create.newArray(context, args2);
    }

    @Deprecated(since="9.4.0.0")
    public IRubyObject rbPrivate(ThreadContext context, IRubyObject[] args2) {
        this._private(context, args2);
        return this;
    }

    @JRubyMethod(name={"module_function"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public IRubyObject _module_function(ThreadContext context, IRubyObject[] args2) {
        if (!this.isModule()) {
            throw Error.typeError(context, "module_function must be called for modules");
        }
        if (args2.length == 0) {
            context.setCurrentVisibility(Visibility.MODULE_FUNCTION);
        } else {
            this.setMethodVisibility(context, args2, Visibility.PRIVATE);
            RubyClass singleton = this.singletonClass(context);
            for (int i2 = 0; i2 < args2.length; ++i2) {
                RubySymbol name2 = Check.checkID(context, args2[i2]);
                DynamicMethod newMethod = this.deepMethodSearch((ThreadContext)context, (String)name2.idString()).method.dup();
                newMethod.setImplementationClass(singleton);
                newMethod.setVisibility(Visibility.PUBLIC);
                singleton.addMethod(context, name2.idString(), newMethod);
                singleton.methodAdded(context, name2);
            }
        }
        switch (args2.length) {
            case 0: {
                return context.nil;
            }
            case 1: {
                return args2[0];
            }
        }
        return Create.newArray(context, args2);
    }

    public IRubyObject module_function(ThreadContext context, IRubyObject[] args2) {
        this._module_function(context, args2);
        return this;
    }

    @JRubyMethod(name={"const_added"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject const_added(ThreadContext context, IRubyObject _newConstant) {
        return context.nil;
    }

    @JRubyMethod(name={"method_added"}, visibility=Visibility.PRIVATE)
    public IRubyObject method_added(ThreadContext context, IRubyObject nothing) {
        return context.nil;
    }

    @JRubyMethod(name={"method_removed"}, visibility=Visibility.PRIVATE)
    public IRubyObject method_removed(ThreadContext context, IRubyObject nothing) {
        return context.nil;
    }

    @JRubyMethod(name={"method_undefined"}, visibility=Visibility.PRIVATE)
    public IRubyObject method_undefined(ThreadContext context, IRubyObject nothing) {
        return context.nil;
    }

    @JRubyMethod(name={"method_defined?"})
    public RubyBoolean method_defined_p(ThreadContext context, IRubyObject symbol) {
        return Convert.asBoolean(context, this.isMethodBound(Check.checkID(context, symbol).idString(), true));
    }

    @JRubyMethod(name={"method_defined?"})
    public RubyBoolean method_defined_p(ThreadContext context, IRubyObject symbol, IRubyObject includeSuper) {
        boolean parents = includeSuper.isTrue();
        if (parents) {
            return this.method_defined_p(context, symbol);
        }
        Visibility visibility = this.checkMethodVisibility(context, symbol, parents);
        return Convert.asBoolean(context, visibility != Visibility.UNDEFINED && visibility != Visibility.PRIVATE);
    }

    @JRubyMethod(name={"public_method_defined?"})
    public IRubyObject public_method_defined(ThreadContext context, IRubyObject symbol) {
        return Convert.asBoolean(context, this.checkMethodVisibility(context, symbol, true) == Visibility.PUBLIC);
    }

    @JRubyMethod(name={"public_method_defined?"})
    public IRubyObject public_method_defined(ThreadContext context, IRubyObject symbol, IRubyObject includeSuper) {
        boolean parents = includeSuper.isTrue();
        return Convert.asBoolean(context, this.checkMethodVisibility(context, symbol, parents) == Visibility.PUBLIC);
    }

    @JRubyMethod(name={"protected_method_defined?"})
    public IRubyObject protected_method_defined(ThreadContext context, IRubyObject symbol) {
        return Convert.asBoolean(context, this.checkMethodVisibility(context, symbol, true) == Visibility.PROTECTED);
    }

    @JRubyMethod(name={"protected_method_defined?"})
    public IRubyObject protected_method_defined(ThreadContext context, IRubyObject symbol, IRubyObject includeSuper) {
        boolean parents = includeSuper.isTrue();
        return Convert.asBoolean(context, this.checkMethodVisibility(context, symbol, parents) == Visibility.PROTECTED);
    }

    @JRubyMethod(name={"private_method_defined?"})
    public IRubyObject private_method_defined(ThreadContext context, IRubyObject symbol) {
        return Convert.asBoolean(context, this.checkMethodVisibility(context, symbol, true) == Visibility.PRIVATE);
    }

    @JRubyMethod(name={"private_method_defined?"})
    public IRubyObject private_method_defined(ThreadContext context, IRubyObject symbol, IRubyObject includeSuper) {
        boolean parents = includeSuper.isTrue();
        return Convert.asBoolean(context, this.checkMethodVisibility(context, symbol, parents) == Visibility.PRIVATE);
    }

    private Visibility checkMethodVisibility(ThreadContext context, IRubyObject symbol, boolean parents) {
        String name2 = Check.checkID(context, symbol).idString();
        RubyModule mod = this;
        if (!parents) {
            mod = this.getMethodLocation();
        }
        CacheEntry entry = mod.searchWithCache(name2);
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return Visibility.UNDEFINED;
        }
        if (!parents && entry.sourceModule != mod) {
            return Visibility.UNDEFINED;
        }
        return method2.getVisibility();
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule public_class_method(IRubyObject[] args2) {
        return this.public_class_method(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"public_class_method"}, rest=true)
    public RubyModule public_class_method(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        this.singletonClass(context).setMethodVisibility(context, args2, Visibility.PUBLIC);
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule private_class_method(IRubyObject[] args2) {
        return this.private_class_method(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"private_class_method"}, rest=true)
    public RubyModule private_class_method(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        this.singletonClass(context).setMethodVisibility(context, args2, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"alias_method"})
    public IRubyObject aliasMethod(ThreadContext context, IRubyObject newId, IRubyObject oldId) {
        RubySymbol newSym = Check.checkID(context, newId);
        RubySymbol oldSym = Check.checkID(context, oldId);
        this.defineAlias(context, newSym.idString(), oldSym.idString());
        this.methodAdded(context, newSym);
        return newSym;
    }

    public RubyModule alias_method(ThreadContext context, IRubyObject newId, IRubyObject oldId) {
        this.aliasMethod(context, newId, oldId);
        return this;
    }

    @JRubyMethod(name={"undef_method"}, rest=true)
    public RubyModule undef_method(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            RubySymbol name2 = Check.checkID(context, args2[i2]);
            this.undef(context, name2.idString());
        }
        return this;
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, keywords=true)
    public IRubyObject module_eval(ThreadContext context, Block block) {
        return this.specificEval(context, this, block, EvalType.MODULE_EVAL);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, keywords=true)
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this, arg0, block, EvalType.MODULE_EVAL);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, keywords=true)
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this, arg0, arg1, block, EvalType.MODULE_EVAL);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, keywords=true)
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this, arg0, arg1, arg2, block, EvalType.MODULE_EVAL);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, rest=true, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject module_eval(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.module_eval(context, block);
            }
            case 1: {
                return this.module_eval(context, args2[0], block);
            }
            case 2: {
                return this.module_eval(context, args2[0], args2[1], block);
            }
            case 3: {
                return this.module_eval(context, args2[0], args2[1], args2[2], block);
            }
        }
        throw Error.argumentError(context, args2.length, 1, 3);
    }

    @JRubyMethod(name={"module_exec", "class_exec"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, keywords=true)
    public IRubyObject module_exec(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(context, this, IRubyObject.NULL_ARRAY, block.cloneBlockAndFrame(), EvalType.MODULE_EVAL);
        }
        throw context.runtime.newLocalJumpErrorNoBlock();
    }

    @JRubyMethod(name={"module_exec", "class_exec"}, rest=true, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, keywords=true)
    public IRubyObject module_exec(ThreadContext context, IRubyObject[] args2, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(context, this, args2, block.cloneBlockAndFrame(), EvalType.MODULE_EVAL);
        }
        throw context.runtime.newLocalJumpErrorNoBlock();
    }

    @JRubyMethod(name={"remove_method"}, rest=true)
    public RubyModule remove_method(ThreadContext context, IRubyObject[] args2) {
        for (IRubyObject name2 : args2) {
            this.removeMethod(context, Check.checkID(context, name2).idString());
        }
        return this;
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static void marshalTo(RubyModule module, MarshalStream output) throws IOException {
        ThreadContext context = module.getRuntime().getCurrentContext();
        output.registerLinkTarget(context, module);
        output.writeString(MarshalStream.getPathFromClass(module));
    }

    public static void marshalTo(ThreadContext context, RubyOutputStream out, RubyModule module, MarshalDumper output) {
        output.registerLinkTarget(module);
        output.writeString(out, MarshalDumper.getPathFromClass(context, module).idString());
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static RubyModule unmarshalFrom(UnmarshalStream input) throws IOException {
        String name2 = RubyString.byteListToString(input.unmarshalString());
        return UnmarshalStream.getModuleFromPath(input.getRuntime(), name2);
    }

    public static RubyModule unmarshalFrom(ThreadContext context, RubyInputStream in, MarshalLoader input) {
        String name2 = RubyString.byteListToString(input.unmarshalString(context, in));
        return MarshalLoader.getModuleFromPath(context, name2);
    }

    @JRubyMethod(name={"nesting"}, reads={FrameField.SCOPE}, meta=true)
    public static RubyArray nesting(ThreadContext context, IRubyObject recv2, Block block) {
        RubyClass object = Access.objectClass(context);
        StaticScope scope = context.getCurrentStaticScope();
        RubyArray<?> result2 = Create.newArray(context);
        StaticScope current2 = scope;
        while (current2.getModule() != object) {
            result2.append(context, current2.getModule());
            current2 = current2.getPreviousCRefScope();
        }
        return result2;
    }

    void doIncludeModule(ThreadContext context, RubyModule baseModule) {
        List<RubyModule> modulesToInclude = this.gatherModules(baseModule);
        RubyModule currentInclusionPoint = this.getMethodLocation();
        block0: for (RubyModule nextModule : modulesToInclude) {
            this.checkForCyclicInclude(context, nextModule);
            boolean superclassSeen = false;
            for (RubyClass nextClass = this.getSuperClass(); nextClass != null; nextClass = nextClass.getSuperClass()) {
                if (nextClass.isIncluded()) {
                    if (nextClass.getDelegate() != nextModule.getDelegate()) continue;
                    if (superclassSeen) continue block0;
                    currentInclusionPoint = nextClass;
                    continue block0;
                }
                superclassSeen = true;
            }
            currentInclusionPoint = this.proceedWithInclude(context, currentInclusionPoint, nextModule.getDelegate());
        }
    }

    IncludedModuleWrapper findModuleInAncestors(RubyModule arg2) {
        for (RubyClass nextClass = this.getSuperClass(); nextClass != null; nextClass = nextClass.getSuperClass()) {
            if (!nextClass.isIncluded() || nextClass.getDelegate() != arg2.getDelegate()) continue;
            return (IncludedModuleWrapper)nextClass;
        }
        return null;
    }

    void doPrependModule(ThreadContext context, RubyModule baseModule) {
        List<RubyModule> modulesToInclude = this.gatherModules(baseModule);
        RubyModule startOrigin = this.getMethodLocation();
        if (!this.hasPrepends()) {
            PrependedModule origin = new PrependedModule(context.runtime, this.getSuperClass(), this);
            if (this instanceof RubyClass) {
                if (this.getSuperClass() != null) {
                    this.getSuperClass().replaceSubclass((RubyClass)this, origin);
                }
                origin.addSubclass((RubyClass)this);
            }
            this.superClass(origin);
        }
        RubyModule inclusionPoint = this;
        block0: for (RubyModule nextModule : modulesToInclude) {
            this.checkForCyclicPrepend(context, nextModule);
            boolean startSeen = false;
            boolean superclassSeen = false;
            if (startOrigin == this) {
                startSeen = true;
            }
            RubyModule stopClass = this.getPrependCeiling();
            if (startOrigin != this) {
                for (RubyClass nextClass = this.getSuperClass(); nextClass != stopClass && startOrigin != nextClass; nextClass = nextClass.getSuperClass()) {
                    if (this == nextClass) {
                        startSeen = true;
                    }
                    if (nextClass.isIncluded()) {
                        if (nextClass.getDelegate() != nextModule.getDelegate()) continue;
                        if (superclassSeen || !startSeen) continue block0;
                        inclusionPoint = nextClass;
                        continue block0;
                    }
                    superclassSeen = true;
                }
            }
            inclusionPoint = this.proceedWithPrepend(context, inclusionPoint, nextModule.getDelegate());
        }
    }

    private List<RubyModule> gatherModules(RubyModule baseModule) {
        ArrayList<RubyModule> modulesToInclude = new ArrayList<RubyModule>(4);
        while (baseModule != null) {
            if (baseModule == baseModule.getMethodLocation()) {
                modulesToInclude.add(baseModule.getDelegate());
            }
            baseModule = baseModule.superClass;
        }
        return modulesToInclude;
    }

    private RubyModule proceedWithInclude(ThreadContext context, RubyModule insertAbove, RubyModule moduleToInclude) {
        IncludedModuleWrapper wrapper = new IncludedModuleWrapper(context.runtime, insertAbove.getSuperClass(), moduleToInclude, moduleToInclude.getMethodLocation());
        if (insertAbove instanceof RubyClass) {
            RubyClass insertAboveClass = (RubyClass)insertAbove;
            if (insertAboveClass.getSuperClass() != null) {
                insertAboveClass.getSuperClass().replaceSubclass(insertAboveClass, wrapper);
            }
            wrapper.addSubclass(insertAboveClass);
        }
        insertAbove.superClass(wrapper);
        insertAbove = insertAbove.getSuperClass();
        if (this.isRefinement()) {
            wrapper.getMethods().forEach((name2, method2) -> this.addRefinedMethodEntry(context, (String)name2, (DynamicMethod)method2));
            wrapper.setFlag(INCLUDED_INTO_REFINEMENT, true);
        }
        return insertAbove;
    }

    private RubyModule proceedWithPrepend(ThreadContext context, RubyModule insertBelow, RubyModule moduleToPrepend) {
        return this.proceedWithInclude(context, insertBelow, !moduleToPrepend.isPrepended() ? moduleToPrepend.getOrigin() : moduleToPrepend);
    }

    @JRubyMethod(name={"class_variable_defined?"})
    public IRubyObject class_variable_defined_p(ThreadContext context, IRubyObject var) {
        String id = this.validateClassVariable(context, var);
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.hasClassVariable(id)) continue;
            return context.tru;
        }
        return context.fals;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject class_variable_get19(IRubyObject name2) {
        return this.class_variable_get(name2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject class_variable_get(IRubyObject name2) {
        return this.class_variable_get(this.getCurrentContext(), name2);
    }

    @JRubyMethod(name={"class_variable_get"})
    public IRubyObject class_variable_get(ThreadContext context, IRubyObject name2) {
        return this.getClassVar(context, name2, this.validateClassVariable(context, name2));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject class_variable_set(IRubyObject name2, IRubyObject value2) {
        return this.class_variable_set(this.getCurrentContext(), name2, value2);
    }

    @JRubyMethod(name={"class_variable_set"})
    public IRubyObject class_variable_set(ThreadContext context, IRubyObject name2, IRubyObject value2) {
        return this.setClassVar(context, this.validateClassVariable(context, name2), value2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject class_variable_set19(IRubyObject name2, IRubyObject value2) {
        return this.class_variable_set(name2, value2);
    }

    @JRubyMethod(name={"remove_class_variable"})
    public IRubyObject remove_class_variable(ThreadContext context, IRubyObject name2) {
        return this.removeClassVariable(context, this.validateClassVariable(context, name2));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject remove_class_variable19(ThreadContext context, IRubyObject name2) {
        return this.remove_class_variable(context, name2);
    }

    @JRubyMethod(name={"class_variables"})
    public RubyArray class_variables(ThreadContext context) {
        RubyArray<?> ary = Create.newArray(context);
        for (String name2 : this.classVariablesCommon(true)) {
            ary.add(Convert.asSymbol(context, name2));
        }
        return ary;
    }

    @JRubyMethod(name={"class_variables"})
    public RubyArray class_variables(ThreadContext context, IRubyObject inherit) {
        RubyArray<?> ary = Create.newArray(context);
        for (String name2 : this.classVariablesCommon(inherit.isTrue())) {
            ary.add(Convert.asSymbol(context, name2));
        }
        return ary;
    }

    private Collection<String> classVariablesCommon(boolean inherit) {
        HashSet<String> names2 = new HashSet<String>();
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            names2.addAll(p2.getClassVariableNameList());
            if (!inherit) break;
        }
        return names2;
    }

    @JRubyMethod(name={"const_defined?"})
    public RubyBoolean const_defined_p(ThreadContext context, IRubyObject name2) {
        return Convert.asBoolean(context, this.constDefined(context, name2, true));
    }

    @JRubyMethod(name={"const_defined?"})
    public RubyBoolean const_defined_p(ThreadContext context, IRubyObject name2, IRubyObject recurse) {
        return Convert.asBoolean(context, this.constDefined(context, name2, recurse.isTrue()));
    }

    private boolean constDefined(ThreadContext context, IRubyObject name2, boolean inherit) {
        int patternIndex;
        if (name2 instanceof RubySymbol) {
            RubySymbol sym = (RubySymbol)name2;
            if (!sym.validConstantName()) {
                throw Error.nameError(context, RubyStringBuilder.str(context.runtime, "wrong constant name ", RubyStringBuilder.ids(context.runtime, sym)), sym);
            }
            String id = sym.idString();
            return inherit ? this.constDefined(context, id) : this.constDefinedAt(context, id);
        }
        RubyString fullName = name2.convertToString();
        ByteList value2 = fullName.getByteList();
        ByteList pattern = CommonByteLists.COLON_COLON;
        Encoding enc = pattern.getEncoding();
        byte[] bytes2 = value2.getUnsafeBytes();
        int begin2 = value2.getBegin();
        int realSize = value2.getRealSize();
        int end2 = begin2 + realSize;
        int currentOffset = 0;
        int index2 = 0;
        RubyModule mod = this;
        boolean includeObject = true;
        if (value2.startsWith(pattern)) {
            mod = Access.objectClass(context);
            currentOffset += 2;
        }
        while (currentOffset < realSize && (patternIndex = value2.indexOf(pattern, currentOffset)) >= 0) {
            int t = enc.rightAdjustCharHead(bytes2, currentOffset + begin2, patternIndex + begin2, end2) - begin2;
            if (t != patternIndex) {
                currentOffset = t;
            } else {
                IRubyObject obj;
                ByteList segment = value2.makeShared(currentOffset, patternIndex - currentOffset);
                String id = RubySymbol.newConstantSymbol(context, (IRubyObject)fullName, segment).idString();
                if (!inherit) {
                    if (!mod.constDefinedAt(context, id)) {
                        return false;
                    }
                    obj = mod.getConstantAt(context, id);
                } else if (index2 == 0 && segment.realSize() == 0) {
                    if (!mod.constDefined(context, id)) {
                        return false;
                    }
                    obj = mod.getConstant(context, id);
                } else {
                    if (!mod.constDefinedFrom(context, id)) {
                        return false;
                    }
                    obj = mod.getConstantFrom(context, id);
                }
                if (!(obj instanceof RubyModule)) {
                    throw Error.typeError(context, String.valueOf(segment) + " does not refer to class/module");
                }
                mod = (RubyModule)obj;
                currentOffset = patternIndex + pattern.getRealSize();
                includeObject = false;
            }
            ++index2;
        }
        if (mod == null) {
            mod = this;
        }
        ByteList lastSegment = value2.makeShared(currentOffset, realSize - currentOffset);
        String id = RubySymbol.newConstantSymbol(context, (IRubyObject)fullName, lastSegment).idString();
        return mod.getConstantSkipAutoload(context, id, inherit, inherit && includeObject, false) != null;
    }

    @JRubyMethod(name={"const_get"})
    public IRubyObject const_get(ThreadContext context, IRubyObject arg0) {
        return this.constGetCommon(context, arg0, true);
    }

    @JRubyMethod(name={"const_get"})
    public IRubyObject const_get(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.constGetCommon(context, arg0, arg1.isTrue());
    }

    private IRubyObject constGetCommon(ThreadContext context, IRubyObject symbol, boolean inherit) {
        RubySymbol fullName = Check.checkID(context, symbol);
        String name2 = fullName.idString();
        int sep = name2.indexOf("::");
        if (symbol instanceof RubySymbol && sep != -1) {
            throw Error.nameError(context, "wrong constant name ", fullName);
        }
        RubyModule mod = this;
        if (sep == 0) {
            mod = Access.objectClass(context);
            name2 = name2.substring(2);
        }
        if (name2.isEmpty()) {
            throw Error.nameError(context, "wrong constant name ", fullName);
        }
        boolean firstConstant = true;
        while ((sep = name2.indexOf("::")) != -1) {
            String segment = name2.substring(0, sep);
            IRubyObject obj = mod.getConstant(context, this.validateConstant(context, segment, symbol), inherit, inherit);
            if (!(obj instanceof RubyModule)) {
                throw Error.typeError(context, segment + " does not refer to class/module");
            }
            mod = (RubyModule)obj;
            name2 = name2.substring(sep + 2);
            firstConstant = false;
        }
        return mod.getConstant(context, this.validateConstant(context, name2, symbol), firstConstant && inherit, firstConstant && inherit);
    }

    public static boolean isValidConstantPath(RubyString str) {
        ByteList byteList = str.getByteList();
        int index2 = 0;
        int sep = 0;
        while ((sep = byteList.indexOf(CommonByteLists.COLON_COLON, index2)) != -1) {
            if (sep == 0) {
                index2 += 2;
                continue;
            }
            if (!RubyModule.isValidConstantName(byteList, index2, sep)) {
                return false;
            }
            index2 = sep + 2;
        }
        return RubyModule.isValidConstantName(byteList, index2, byteList.realSize());
    }

    public static boolean isValidConstantName(ByteList bytelist, int start2, int end2) {
        if (start2 == end2) {
            return false;
        }
        Encoding enc = bytelist.getEncoding();
        byte[] bytes2 = bytelist.unsafeBytes();
        int beg = bytelist.begin();
        int p2 = beg + start2;
        int e = beg + end2;
        int l = StringSupport.preciseLength(enc, bytes2, p2, e);
        int c = StringSupport.codePoint(enc, bytes2, p2, e);
        if (!enc.isUpper(c)) {
            return false;
        }
        p2 += l;
        while (p2 < e) {
            l = StringSupport.preciseLength(enc, bytes2, p2, e);
            c = StringSupport.codePoint(enc, bytes2, p2, e);
            if (!enc.isAlnum(c)) {
                return false;
            }
            p2 += l;
        }
        return true;
    }

    @JRubyMethod(required=1, optional=1, checkArity=false)
    public IRubyObject const_source_location(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        boolean inherit = argc == 1 || !args2[1].isNil() && args2[1].isTrue();
        IRubyObject symbol = args2[0];
        String name2 = symbol instanceof RubySymbol ? Check.checkID(context, symbol).idString() : symbol.convertToString().asJavaString();
        int sep = name2.indexOf("::");
        if (symbol instanceof RubySymbol && sep != -1) {
            throw Error.nameError(context, "wrong constant name", symbol);
        }
        RubyModule mod = this;
        if (sep == 0) {
            mod = Access.objectClass(context);
            name2 = name2.substring(2);
        }
        if (name2.isEmpty()) {
            throw Error.nameError(context, "wrong constant name ", symbol);
        }
        while ((sep = name2.indexOf("::")) != -1) {
            String segment = name2.substring(0, sep);
            IRubyObject obj = mod.getConstant(context, this.validateConstant(context, segment, symbol), inherit, inherit);
            if (!(obj instanceof RubyModule)) {
                throw Error.typeError(context, segment + " does not refer to class/module");
            }
            mod = (RubyModule)obj;
            name2 = name2.substring(sep + 2);
        }
        SourceLocation location = mod.getConstantSourceLocation(context, this.validateConstant(context, name2, symbol), inherit, inherit);
        if (location != null && location.getFile() != null) {
            return location.getFile().equals(BUILTIN_CONSTANT) ? Create.newEmptyArray(context) : Create.newArray(context, (IRubyObject)Create.newString(context, location.getFile()), (IRubyObject)Convert.asFixnum(context, location.getLine()));
        }
        return context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject const_set(IRubyObject name2, IRubyObject value2) {
        return this.const_set(this.getCurrentContext(), name2, value2);
    }

    @JRubyMethod(name={"const_set"})
    public IRubyObject const_set(ThreadContext context, IRubyObject name2, IRubyObject value2) {
        return this.setConstant(context, this.validateConstant(context, name2), value2, context.getFile(), context.getLine() + 1);
    }

    @JRubyMethod(name={"remove_const"}, visibility=Visibility.PRIVATE)
    public IRubyObject remove_const(ThreadContext context, IRubyObject rubyName) {
        String id = this.validateConstant(context, rubyName);
        IRubyObject value2 = this.deleteConstant(id);
        if (value2 != null) {
            this.invalidateConstantCache(context, id);
            if (value2 != UNDEF) {
                return value2;
            }
            this.removeAutoload(id);
            return context.nil;
        }
        if (this.hasConstantInHierarchy(id)) {
            throw this.cannotRemoveError(context, id);
        }
        throw Error.nameError(context, "constant " + id + " not defined for " + this.getName(context), id);
    }

    private boolean hasConstantInHierarchy(String name2) {
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.hasConstant(name2)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"const_missing"})
    public IRubyObject const_missing(ThreadContext context, IRubyObject rubyName, Block block) {
        RubyModule privateConstReference = context.getPrivateConstantReference();
        if (privateConstReference != null) {
            context.setPrivateConstantReference(null);
            throw context.runtime.newNameError("private constant " + String.valueOf(privateConstReference) + "::" + String.valueOf(rubyName) + " referenced", (IRubyObject)privateConstReference, rubyName);
        }
        if (this != Access.objectClass(context)) {
            throw context.runtime.newNameError("uninitialized constant %2$s::%1$s", (IRubyObject)this, rubyName);
        }
        throw context.runtime.newNameError("uninitialized constant %1$s", (IRubyObject)this, rubyName);
    }

    @JRubyMethod(name={"constants"})
    public RubyArray constants(ThreadContext context) {
        return this.constantsCommon(context, true, true);
    }

    @JRubyMethod(name={"constants"})
    public RubyArray constants(ThreadContext context, IRubyObject allConstants) {
        return this.constantsCommon(context, false, allConstants.isTrue());
    }

    private RubyArray<?> constantsCommon(ThreadContext context, boolean replaceModule, boolean allConstants) {
        Collection<String> constantNames = this.constantsCommon(context.runtime, replaceModule, allConstants, false);
        RubyArray array2 = RubyArray.newBlankArrayInternal(context.runtime, constantNames.size());
        int i2 = 0;
        for (String name2 : constantNames) {
            array2.storeInternal(context, i2++, Convert.asSymbol(context, name2));
        }
        array2.realLength = i2;
        return array2;
    }

    public Collection<String> constantsCommon(Ruby runtime2, boolean replaceModule, boolean allConstants) {
        return this.constantsCommon(runtime2, replaceModule, allConstants, true);
    }

    public Collection<String> constantsCommon(Ruby runtime2, boolean replaceModule, boolean allConstants, boolean includePrivate) {
        Collection<String> constantNames;
        RubyClass objectClass = runtime2.getObject();
        if (allConstants) {
            if (replaceModule && runtime2.getModule() == this || objectClass == this) {
                constantNames = objectClass.getConstantNames(includePrivate);
            } else {
                HashSet<String> names2 = new HashSet<String>();
                for (RubyModule module = this; module != null && module != objectClass; module = module.getSuperClass()) {
                    names2.addAll(module.getConstantNames(includePrivate));
                }
                constantNames = names2;
            }
        } else {
            constantNames = replaceModule && runtime2.getModule() == this || objectClass == this ? objectClass.getConstantNames(includePrivate) : this.getConstantNames(includePrivate);
        }
        return constantNames;
    }

    @Deprecated(since="10.0.0.0")
    public void deprecateConstant(Ruby runtime2, String name2) {
        this.deprecateConstant(runtime2.getCurrentContext(), name2);
    }

    @JRubyAPI
    public void deprecateConstant(ThreadContext context, String name2) {
        ConstantEntry entry = this.getConstantMap().get(name2);
        if (entry == null) {
            Ruby runtime2 = context.runtime;
            throw Error.nameError(context, RubyStringBuilder.str(runtime2, "constant ", RubyStringBuilder.types(runtime2, this), "::", RubyStringBuilder.ids(runtime2, name2), " not defined"), name2);
        }
        this.storeConstant(context, name2, entry.value, entry.hidden, true);
        this.invalidateConstantCache(context, name2);
    }

    @JRubyMethod
    public IRubyObject deprecate_constant(ThreadContext context, IRubyObject name2) {
        this.checkFrozen();
        this.deprecateConstant(context, this.validateConstant(context, name2));
        return this;
    }

    @JRubyMethod(rest=true)
    public IRubyObject deprecate_constant(ThreadContext context, IRubyObject[] names2) {
        for (IRubyObject name2 : names2) {
            this.deprecate_constant(context, name2);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject private_constant(ThreadContext context, IRubyObject name2) {
        this.checkFrozen();
        String id = this.validateConstant(context, name2);
        this.setConstantVisibility(context, id, true);
        this.invalidateConstantCache(context, id);
        return this;
    }

    @JRubyMethod(required=1, rest=true, checkArity=false)
    public IRubyObject private_constant(ThreadContext context, IRubyObject[] rubyNames) {
        Arity.checkArgumentCount(context, rubyNames, 1, -1);
        for (IRubyObject rubyName : rubyNames) {
            this.private_constant(context, rubyName);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject public_constant(ThreadContext context, IRubyObject name2) {
        this.checkFrozen();
        String id = this.validateConstant(context, name2);
        this.setConstantVisibility(context, id, false);
        this.invalidateConstantCache(context, id);
        return this;
    }

    @JRubyMethod(required=1, rest=true, checkArity=false)
    public IRubyObject public_constant(ThreadContext context, IRubyObject[] rubyNames) {
        Arity.checkArgumentCount(context, rubyNames, 1, -1);
        for (IRubyObject rubyName : rubyNames) {
            this.public_constant(context, rubyName);
        }
        return this;
    }

    @JRubyMethod(name={"prepend"}, required=1, rest=true, checkArity=false)
    public IRubyObject prepend(ThreadContext context, IRubyObject[] modules) {
        int argc = Arity.checkArgumentCount(context, modules, 1, -1);
        if (this.isRefinement()) {
            throw Error.typeError(context, "Refinement#prepend has been removed");
        }
        int i2 = argc;
        while (--i2 >= 0) {
            if (!modules[i2].isModule()) {
                throw Error.typeError(context, modules[i2], "Module");
            }
            if (!((RubyModule)modules[i2]).isRefinement()) continue;
            throw Error.typeError(context, "Cannot prepend refinement");
        }
        for (i2 = argc - 1; i2 >= 0; --i2) {
            modules[i2].callMethod(context, "prepend_features", this);
            modules[i2].callMethod(context, "prepended", this);
        }
        return this;
    }

    @JRubyMethod(name={"prepended"}, visibility=Visibility.PRIVATE)
    public IRubyObject prepended(ThreadContext context, IRubyObject other) {
        return context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public final void setConstantVisibility(Ruby runtime2, String name2, boolean hidden) {
        this.setConstantVisibility(runtime2.getCurrentContext(), name2, hidden);
    }

    public final void setConstantVisibility(ThreadContext context, String name2, boolean hidden) {
        ConstantEntry entry = this.getConstantMap().get(name2);
        if (entry == null) {
            throw Error.nameError(context, "constant " + this.getName(context) + "::" + name2 + " not defined", name2);
        }
        this.setConstantCommon(context, name2, entry.value, hidden, false, entry.getFile(), entry.getLine());
    }

    @JRubyMethod(name={"refinements"})
    public IRubyObject refinements(ThreadContext context) {
        RefinementStore refinementStore = this.refinementStore;
        if (refinementStore == null) {
            return Create.newEmptyArray(context);
        }
        RubyArray<?> refinementModules = Create.allocArray(context, refinementStore.refinements.size());
        refinementStore.refinements.forEach((key2, value2) -> refinementModules.append(context, (IRubyObject)value2));
        return refinementModules;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject refined_class(ThreadContext context) {
        return this.getRefinedClassOrThrow(context, false);
    }

    @JRubyMethod(name={"target"})
    public IRubyObject target(ThreadContext context) {
        return this.getRefinedClassOrThrow(context, true);
    }

    private IRubyObject getRefinedClassOrThrow(ThreadContext context, boolean nameIsTarget) {
        if (this.isRefinement()) {
            return this.refinementStore.refinedClass;
        }
        String methodName = nameIsTarget ? "target" : "refined_class";
        String errMsg = RubyStringBuilder.str(context.runtime, "undefined method '" + methodName + "' for ", this.rubyBaseName(context), ":", this.getMetaClass());
        throw context.runtime.newNoMethodError(errMsg, this, "target", Create.newEmptyArray(context));
    }

    @JRubyMethod(name={"used_refinements"})
    public IRubyObject used_refinements(ThreadContext context) {
        return Create.newEmptyArray(context);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject setClassVar(String name2, IRubyObject value2) {
        return this.setClassVar(this.getCurrentContext(), name2, value2);
    }

    public IRubyObject setClassVar(ThreadContext context, String name2, IRubyObject value2) {
        RubyModule module = this;
        RubyModule highest = this;
        do {
            if (!module.hasClassVariable(name2)) continue;
            highest = module;
        } while ((module = module.getSuperClass()) != null);
        return highest.storeClassVariable(context, name2, value2);
    }

    @Deprecated(since="1.7.0")
    public IRubyObject fastSetClassVar(String internedName, IRubyObject value2) {
        return this.setClassVar(this.getCurrentContext(), internedName, value2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getClassVar(String name2) {
        return this.getClassVar(this.getCurrentContext(), name2);
    }

    public IRubyObject getClassVar(ThreadContext context, String name2) {
        IRubyObject value2 = this.getClassVarQuiet(context, name2);
        if (value2 == null) {
            throw context.runtime.newNameError("uninitialized class variable %1$s in %2$s", (IRubyObject)this, name2);
        }
        return value2;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getClassVar(IRubyObject nameObject, String name2) {
        return this.getClassVar(this.getCurrentContext(), nameObject, name2);
    }

    public IRubyObject getClassVar(ThreadContext context, IRubyObject nameObject, String name2) {
        IRubyObject value2 = this.getClassVarQuiet(context, name2);
        if (value2 == null) {
            throw context.runtime.newNameError("uninitialized class variable %1$s in %2$s", (IRubyObject)this, nameObject);
        }
        return value2;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getClassVarQuiet(String name2) {
        return this.getClassVarQuiet(this.getCurrentContext(), name2);
    }

    private IRubyObject getClassVarQuiet(ThreadContext context, String name2) {
        assert (IdUtil.isClassVariable(name2));
        RubyModule module = this;
        RubyModule highest = null;
        RubyModule lowest = null;
        do {
            if (!module.hasClassVariable(name2)) continue;
            highest = module;
            if (lowest != null) continue;
            lowest = module;
        } while ((module = module.getSuperClass()) != null);
        if (lowest != highest && !highest.isPrepended()) {
            if (lowest.getOrigin().getRealModule() != highest.getOrigin().getRealModule()) {
                throw Error.runtimeError(context, RubyStringBuilder.str(context.runtime, "class variable " + name2 + " of ", lowest.getOrigin(), " is overtaken by ", highest.getOrigin()));
            }
            if (lowest.isClass()) {
                lowest.removeClassVariable(name2);
            }
        }
        if (highest != null) {
            return highest.fetchClassVariable(name2);
        }
        return null;
    }

    @Deprecated(since="1.7.0")
    public IRubyObject fastGetClassVar(String internedName) {
        return this.getClassVar(this.getCurrentContext(), internedName);
    }

    public boolean isClassVarDefined(String name2) {
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(name2)) continue;
            return true;
        } while ((module = module.getSuperClass()) != null);
        return false;
    }

    @Deprecated(since="1.7.0")
    public boolean fastIsClassVarDefined(String internedName) {
        return this.isClassVarDefined(internedName);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject removeClassVariable(String name2) {
        return this.removeClassVariable(this.getCurrentContext(), name2);
    }

    public IRubyObject removeClassVariable(ThreadContext context, String name2) {
        String javaName = this.validateClassVariable(context, name2);
        IRubyObject value2 = this.deleteClassVariable(context, javaName);
        if (value2 != null) {
            return value2;
        }
        throw this.isClassVarDefined(javaName) ? this.cannotRemoveError(context, javaName) : Error.nameError(context, "class variable " + javaName + " not defined for " + this.getName(context), javaName);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstantAtSpecial(String name2) {
        return this.getConstantAtSpecial(this.getCurrentContext(), name2);
    }

    public IRubyObject getConstantAtSpecial(ThreadContext context, String name2) {
        IRubyObject value2 = this == Access.objectClass(context) ? this.getConstantNoConstMissing(context, name2) : this.fetchConstant(context, name2);
        return value2 == UNDEF ? this.resolveUndefConstant(context, name2) : value2;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstantAt(String name2) {
        return this.getConstantAt(this.getCurrentContext(), name2);
    }

    public IRubyObject getConstantAt(ThreadContext context, String name2) {
        return this.getConstantAt(context, name2, true);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstantAt(String name2, boolean includePrivate) {
        return this.getConstantAt(this.getCurrentContext(), name2, includePrivate);
    }

    public IRubyObject getConstantAt(ThreadContext context, String name2, boolean includePrivate) {
        IRubyObject value2 = this.fetchConstant(context, name2, includePrivate);
        return value2 == UNDEF ? this.resolveUndefConstant(context, name2) : value2;
    }

    @Deprecated(since="1.7.0")
    public IRubyObject fastGetConstantAt(String internedName) {
        return this.getConstantAt(this.getCurrentContext(), internedName);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstant(String name2) {
        return this.getConstant(this.getCurrentContext(), name2);
    }

    public IRubyObject getConstant(ThreadContext context, String name2) {
        return this.getConstant(context, name2, true);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstant(String name2, boolean inherit) {
        return this.getConstant(this.getCurrentContext(), name2, inherit);
    }

    public IRubyObject getConstant(ThreadContext context, String name2, boolean inherit) {
        return this.getConstant(context, name2, inherit, true);
    }

    @Deprecated(since="10.0.0.0")
    public SourceLocation getConstantSourceLocation(String name2, boolean inherit, boolean includeObject) {
        return this.getConstantSourceLocation(this.getCurrentContext(), name2, inherit, includeObject);
    }

    public SourceLocation getConstantSourceLocation(ThreadContext context, String name2, boolean inherit, boolean includeObject) {
        SourceLocation location = RubyModule.iterateConstantEntryNoConstMissing(name2, this, inherit);
        RubyClass Object2 = Access.objectClass(context);
        if (location == null && !this.isClass() && includeObject) {
            location = RubyModule.iterateConstantEntryNoConstMissing(name2, Object2, inherit);
        }
        return location;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstant(String name2, boolean inherit, boolean includeObject) {
        return this.getConstant(this.getCurrentContext(), name2, inherit, includeObject);
    }

    public IRubyObject getConstant(ThreadContext context, String name2, boolean inherit, boolean includeObject) {
        assert (name2 != null) : "null name";
        IRubyObject value2 = this.getConstantNoConstMissing(context, name2, inherit, includeObject);
        return value2 != null ? value2 : this.callMethod(context, "const_missing", (IRubyObject)Convert.asSymbol(context, name2));
    }

    @Deprecated(since="1.7.0")
    public IRubyObject fastGetConstant(String internedName) {
        return this.getConstant(this.getCurrentContext(), internedName);
    }

    @Deprecated(since="1.7.0")
    public IRubyObject fastGetConstant(String internedName, boolean inherit) {
        return this.getConstant(this.getCurrentContext(), internedName, inherit);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstantNoConstMissing(String name2) {
        return this.getConstantNoConstMissing(this.getCurrentContext(), name2);
    }

    public IRubyObject getConstantNoConstMissing(ThreadContext context, String name2) {
        return this.getConstantNoConstMissing(context, name2, true);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstantNoConstMissing(String name2, boolean inherit) {
        return this.getConstantNoConstMissing(this.getCurrentContext(), name2, inherit);
    }

    public IRubyObject getConstantNoConstMissing(ThreadContext context, String name2, boolean inherit) {
        return this.getConstantNoConstMissing(context, name2, inherit, true);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstantNoConstMissing(String name2, boolean inherit, boolean includeObject) {
        return this.getConstantNoConstMissing(this.getCurrentContext(), name2, inherit, includeObject);
    }

    public IRubyObject getConstantNoConstMissing(ThreadContext context, String name2, boolean inherit, boolean includeObject) {
        IRubyObject constant = RubyModule.iterateConstantNoConstMissing(context, name2, this, inherit, true, true);
        if (constant == null && !this.isClass() && includeObject) {
            constant = RubyModule.iterateConstantNoConstMissing(context, name2, Access.objectClass(context), inherit, true, true);
        }
        return constant;
    }

    @Deprecated(since="10.0.0.0")
    public final IRubyObject getConstantNoConstMissingSkipAutoload(String name2) {
        return this.getConstantNoConstMissingSkipAutoload(this.getCurrentContext(), name2);
    }

    public final IRubyObject getConstantNoConstMissingSkipAutoload(ThreadContext context, String name2) {
        return this.getConstantSkipAutoload(context, name2, true, true, true);
    }

    @Deprecated(since="9.2.1.0")
    public IRubyObject getConstantNoConstMissingSKipAutoload(String name2) {
        return this.getConstantSkipAutoload(this.getCurrentContext(), name2, true, true, true);
    }

    private IRubyObject getConstantSkipAutoload(ThreadContext context, String name2, boolean inherit, boolean searchObject, boolean inheritObject) {
        IRubyObject constant = RubyModule.iterateConstantNoConstMissing(context, name2, this, inherit, false, inheritObject);
        if (constant == null && !this.isClass() && searchObject) {
            constant = RubyModule.iterateConstantNoConstMissing(context, name2, this.getRuntime().getObject(), inherit, false, true);
        }
        return constant;
    }

    private static SourceLocation iterateConstantEntryNoConstMissing(String name2, RubyModule init, boolean inherit) {
        for (RubyModule mod = init; mod != null; mod = mod.getSuperClass()) {
            ConstantEntry entry = mod.constantEntryFetch(name2);
            if (entry != null) {
                IRubyObject value2 = entry.value;
                if (value2 == UNDEF) {
                    return mod.getAutoloadMap().get(name2);
                }
                return entry;
            }
            if (!inherit) break;
        }
        return null;
    }

    private static IRubyObject iterateConstantNoConstMissing(ThreadContext context, String name2, RubyModule init, boolean inherit, boolean loadConstant, boolean includeObject) {
        RubyClass objectClass = init.getRuntime().getObject();
        for (RubyModule mod = init; mod != null; mod = mod.getSuperClass()) {
            IRubyObject value2;
            IRubyObject iRubyObject = value2 = loadConstant ? mod.getConstantWithAutoload(context, name2, null, true) : mod.fetchConstant(context, name2, true);
            if (value2 == UNDEF && !loadConstant && mod.getAutoloadMap().get(name2) == null) {
                return null;
            }
            if (value2 != null) {
                return value2;
            }
            if (!inherit || !includeObject && mod.getSuperClass() == objectClass) break;
        }
        return null;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstantFrom(String name2) {
        return this.getConstantFrom(this.getCurrentContext(), name2);
    }

    public IRubyObject getConstantFrom(ThreadContext context, String name2) {
        IRubyObject value2 = this.getConstantFromNoConstMissing(context, name2);
        return value2 != null ? value2 : this.getConstantFromConstMissing(context, name2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstantWithAutoload(String name2, IRubyObject failedAutoloadValue, boolean includePrivate) {
        return this.getConstantWithAutoload(this.getCurrentContext(), name2, failedAutoloadValue, includePrivate);
    }

    public IRubyObject getConstantWithAutoload(ThreadContext context, String name2, IRubyObject failedAutoloadValue, boolean includePrivate) {
        IRubyObject result2;
        RubyModule autoloadModule = null;
        while ((result2 = this.fetchConstant(context, name2, includePrivate)) != null) {
            if (result2 == RubyObject.UNDEF) {
                if (autoloadModule == this) {
                    return failedAutoloadValue;
                }
                autoloadModule = this;
                Autoload autoload2 = this.getAutoloadMap().get(name2);
                if (autoload2 == null) {
                    return null;
                }
                if (autoload2.getValue() != null) {
                    return autoload2.getValue();
                }
                autoload2.load(context);
                continue;
            }
            return result2;
        }
        return autoloadModule != null ? failedAutoloadValue : null;
    }

    @Deprecated(since="1.7.0")
    public IRubyObject fastGetConstantFrom(String internedName) {
        return this.getConstantFrom(this.getCurrentContext(), internedName);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstantFromNoConstMissing(String name2) {
        return this.getConstantFromNoConstMissing(this.getCurrentContext(), name2);
    }

    public IRubyObject getConstantFromNoConstMissing(ThreadContext context, String name2) {
        return this.getConstantFromNoConstMissing(context, name2, true);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstantFromNoConstMissing(String name2, boolean includePrivate) {
        return this.getConstantFromNoConstMissing(this.getCurrentContext(), name2, includePrivate);
    }

    public IRubyObject getConstantFromNoConstMissing(ThreadContext context, String name2, boolean includePrivate) {
        RubyClass Object2 = Access.objectClass(context);
        for (RubyModule mod = this; mod != null; mod = mod.getSuperClass()) {
            IRubyObject result2 = mod.getConstantWithAutoload(context, name2, null, includePrivate);
            if (result2 == null) continue;
            return mod == Object2 && this != Object2 ? null : result2;
        }
        return null;
    }

    @Deprecated(since="1.7.0")
    public IRubyObject fastGetConstantFromNoConstMissing(String internedName) {
        return this.getConstantFromNoConstMissing(this.getCurrentContext(), internedName);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject getConstantFromConstMissing(String name2) {
        return this.getConstantFromConstMissing(this.getCurrentContext(), name2);
    }

    public IRubyObject getConstantFromConstMissing(ThreadContext context, String name2) {
        return this.callMethod(context, "const_missing", (IRubyObject)context.runtime.fastNewSymbol(name2));
    }

    @Deprecated(since="1.7.0")
    public IRubyObject fastGetConstantFromConstMissing(String internedName) {
        return this.getConstantFromConstMissing(this.getCurrentContext(), internedName);
    }

    @Deprecated(since="10.0.0.0")
    public final IRubyObject resolveUndefConstant(String name2) {
        return this.resolveUndefConstant(this.getCurrentContext(), name2);
    }

    IRubyObject resolveUndefConstant(ThreadContext context, String name2) {
        return this.getAutoloadConstant(context, name2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject setConstantQuiet(String name2, IRubyObject value2) {
        return this.setConstantQuiet(this.getCurrentContext(), name2, value2);
    }

    public IRubyObject setConstantQuiet(ThreadContext context, String name2, IRubyObject value2) {
        return this.setConstantCommon(context, name2, value2, null, false, null, -1);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject setConstant(String name2, IRubyObject value2) {
        return this.setConstant(this.getCurrentContext(), name2, value2);
    }

    public IRubyObject setConstant(ThreadContext context, String name2, IRubyObject value2) {
        return this.setConstantCommon(context, name2, value2, null, true, null, -1);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject setConstant(String name2, IRubyObject value2, String file2, int line) {
        return this.setConstant(this.getCurrentContext(), name2, value2, file2, line);
    }

    public IRubyObject setConstant(ThreadContext context, String name2, IRubyObject value2, String file2, int line) {
        return this.setConstantCommon(context, name2, value2, null, true, file2, line);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject setConstant(String name2, IRubyObject value2, boolean hidden) {
        return this.setConstant(this.getCurrentContext(), name2, value2, hidden);
    }

    public IRubyObject setConstant(ThreadContext context, String name2, IRubyObject value2, boolean hidden) {
        return this.setConstantCommon(context, name2, value2, hidden, true, null, -1);
    }

    private IRubyObject setConstantCommon(ThreadContext context, String name2, IRubyObject value2, Boolean hiddenObj, boolean warn2, String file2, int line) {
        ConstantEntry oldEntry = this.fetchConstantEntry(context, name2, true);
        this.setParentForModule(context, name2, value2);
        if (oldEntry != null) {
            boolean notAutoload;
            boolean hidden = oldEntry.hidden;
            if (hiddenObj != null) {
                hidden = hiddenObj;
            }
            boolean bl = notAutoload = oldEntry.value != UNDEF;
            if (notAutoload) {
                if (warn2) {
                    Warn.warn(context, "already initialized constant " + (String)(this.equals(Access.objectClass(context)) ? name2 : String.valueOf(this) + "::" + name2));
                }
                this.storeConstant(context, name2, value2, hidden, file2, line);
            } else if (value2 == UNDEF) {
                this.storeConstant(context, name2, value2, hidden, file2, line);
            } else {
                boolean autoloading = this.setAutoloadConstant(context, name2, value2, hidden, file2, line);
                if (autoloading) {
                    this.callMethod(context, "const_added", (IRubyObject)Convert.asSymbol(context, name2));
                } else {
                    this.storeConstant(context, name2, value2, hidden, file2, line);
                }
            }
        } else {
            if (this == context.runtime.getObject() && name2.equals("Ruby")) {
                Warn.warnReservedName(context, "::Ruby", "3.5");
            }
            this.storeConstant(context, name2, value2, hiddenObj == null ? false : hiddenObj, file2, line);
        }
        this.invalidateConstantCache(context, name2);
        return value2;
    }

    private void setParentForModule(ThreadContext context, String name2, IRubyObject value2) {
        if (value2 instanceof RubyModule) {
            RubyModule module = (RubyModule)value2;
            if (module != this && (module.getBaseName() == null || module.usingTemporaryName())) {
                module.baseName(name2);
                module.setParent(this);
            }
            module.calculateName(context);
        }
    }

    @Deprecated(since="9.4-")
    public IRubyObject fastSetConstant(String internedName, IRubyObject value2) {
        return this.setConstant(this.getCurrentContext(), internedName, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T extends RubyModule> T defineAlias(ThreadContext context, String name2, String oldName) {
        this.testFrozen("module");
        CacheEntry entry = this.searchForAliasMethod(context, oldName);
        DynamicMethod method2 = this.getMethods().get(name2);
        if (method2 != null && entry.method.getRealMethod() != method2.getRealMethod() && !method2.isUndefined()) {
            if (method2.getRealMethod().getAliasCount() == 0) {
                Warn.warning(context, "method redefined; discarding old " + name2);
            }
            if (method2 instanceof PositionAware) {
                PositionAware posAware = (PositionAware)((Object)method2);
                context.runtime.getWarnings().warning(IRubyWarnings.ID.REDEFINING_METHOD, posAware.getFile(), posAware.getLine() + 1, "previous definition of " + name2 + " was here");
            }
        }
        this.checkAliasFrameAccesses(context, oldName, name2, entry.method);
        this.putAlias(context, name2, entry, oldName);
        RubyModule methodLocation = this.getMethodLocation();
        Object object = context.runtime.getHierarchyLock();
        synchronized (object) {
            methodLocation.invalidateCacheDescendants(context);
        }
        return (T)this;
    }

    @JRubyAPI
    public <T extends RubyModule> T defineConstant(ThreadContext context, String name2, IRubyObject value2) {
        return this.defineConstant(context, name2, value2, false);
    }

    @JRubyAPI
    public <T extends RubyModule> T defineConstant(ThreadContext context, String name2, IRubyObject value2, boolean hidden) {
        if (!IdUtil.isValidConstantName(name2)) {
            throw Error.nameError(context, "bad constant name " + name2, name2);
        }
        this.setConstantCommon(context, name2, value2, hidden, true, null, -1);
        return (T)this;
    }

    @Extension
    @Deprecated(since="10.0.0.0")
    public void defineConstant(String name2, IRubyObject value2) {
        ThreadContext context = this.getCurrentContext();
        assert (value2 != null);
        if (!IdUtil.isValidConstantName(name2)) {
            throw Error.nameError(context, "bad constant name " + name2, name2);
        }
        this.setConstant(context, name2, value2);
    }

    @Deprecated(since="10.0.0.0")
    public boolean isConstantDefined(String name2, boolean inherit) {
        return this.constDefinedInner(this.getCurrentContext(), name2, false, inherit, false);
    }

    @Deprecated(since="10.0.0.0")
    public boolean constDefined(String name2) {
        return this.constDefined(this.getCurrentContext(), name2);
    }

    public boolean constDefined(ThreadContext context, String name2) {
        return this.constDefinedInner(context, name2, false, true, false);
    }

    @Deprecated(since="10.0.0.0")
    public boolean constDefinedAt(String name2) {
        return this.constDefinedAt(this.getCurrentContext(), name2);
    }

    public boolean constDefinedAt(ThreadContext context, String name2) {
        return this.constDefinedInner(context, name2, true, false, false);
    }

    @Deprecated(since="10.0.0.0")
    public boolean constDefinedFrom(String name2) {
        return this.constDefinedFrom(this.getCurrentContext(), name2);
    }

    public boolean constDefinedFrom(ThreadContext context, String name2) {
        return this.constDefinedInner(context, name2, true, true, false);
    }

    @Deprecated(since="10.0.0.0")
    public boolean publicConstDefinedFrom(String name2) {
        return this.publicConstDefinedFrom(this.getCurrentContext(), name2);
    }

    public boolean publicConstDefinedFrom(ThreadContext context, String name2) {
        return this.constDefinedInner(context, name2, true, true, true);
    }

    private boolean constDefinedInner(ThreadContext context, String name2, boolean exclude, boolean recurse, boolean visibility) {
        RubyClass object = Access.objectClass(context);
        boolean moduleRetry = false;
        RubyModule module = this;
        while (true) {
            if (module != null) {
                ConstantEntry entry = module.constantEntryFetch(name2);
                if (entry != null) {
                    if (visibility && entry.hidden) {
                        return false;
                    }
                    IRubyObject value2 = entry.value;
                    if (value2 == UNDEF && module.checkAutoloadRequired(context, name2, null) == null && !module.autoloadingValue(context, name2)) {
                        return false;
                    }
                    return !exclude || module != object || this == object;
                }
                if (recurse) {
                    module = module.getSuperClass();
                    continue;
                }
            }
            if (exclude || moduleRetry || !this.isModule()) break;
            moduleRetry = true;
            module = object;
        }
        return false;
    }

    @Deprecated(since="10.0.0.0")
    public boolean autoloadingValue(Ruby runtime2, String name2) {
        return this.autoloadingValue(runtime2.getCurrentContext(), name2);
    }

    public boolean autoloadingValue(ThreadContext context, String name2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        return autoload2 != null && autoload2.isSelf(context) && autoload2.getValue() != null;
    }

    private RubyString checkAutoloadRequired(ThreadContext context, String name2, String[] autoloadPath) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 == null) {
            return null;
        }
        RubyString file2 = autoload2.getPath();
        if (file2.length() == 0) {
            throw Error.argumentError(context, "empty file name");
        }
        if (autoload2.ctx != null && !autoload2.isSelf(context)) {
            return file2;
        }
        String[] loading = new String[]{null};
        if (!Access.loadService(context).featureAlreadyLoaded(file2.asJavaString(), loading)) {
            return file2;
        }
        if (autoloadPath != null && loading[0] != null) {
            autoloadPath[0] = loading[0];
            return file2;
        }
        return null;
    }

    @Deprecated(since="10.0.0.0")
    public boolean isConstantDefined(String name2) {
        return this.isConstantDefined(this.getCurrentContext(), name2);
    }

    public boolean isConstantDefined(ThreadContext context, String name2) {
        return this.constDefinedInner(context, name2, false, true, false);
    }

    private RaiseException cannotRemoveError(ThreadContext context, String id) {
        return Error.nameError(context, RubyStringBuilder.str(context.runtime, "cannot remove ", RubyStringBuilder.ids(context.runtime, id), " for ", RubyStringBuilder.types(context.runtime, this)), id);
    }

    public static boolean testModuleMatch(ThreadContext context, IRubyObject arg0, int id) {
        return arg0 instanceof RubyModule && ((RubyModule)arg0).id == id;
    }

    public boolean hasInternalModuleVariable(String name2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.hasInternalVariable(name2)) continue;
            return true;
        }
        return false;
    }

    public IRubyObject searchInternalModuleVariable(String name2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            IRubyObject value2 = (IRubyObject)module.getInternalVariable(name2);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    public void setInternalModuleVariable(String name2, IRubyObject value2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.hasInternalVariable(name2)) continue;
            module.setInternalVariable(name2, value2);
            return;
        }
        this.setInternalVariable(name2, value2);
    }

    protected Map<String, IRubyObject> getClassVariables() {
        return this.getClassVariablesForWrite();
    }

    private Map<String, IRubyObject> getClassVariablesForWrite() {
        Map<String, IRubyObject> classVariables = this.classVariables;
        if (classVariables == null && !CLASSVARS_HANDLE.compareAndSet(this, null, classVariables = new ConcurrentHashMap<String, IRubyObject>(4, 0.75f, 2))) {
            classVariables = this.classVariables;
        }
        return classVariables;
    }

    protected Map<String, IRubyObject> getClassVariablesForRead() {
        Map<String, IRubyObject> classVariables = this.classVariables;
        return classVariables == null ? Collections.EMPTY_MAP : classVariables;
    }

    public boolean hasClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        return this.getClassVariablesForRead().containsKey(name2);
    }

    @Deprecated(since="1.7.0")
    public boolean fastHasClassVariable(String internedName) {
        return this.hasClassVariable(internedName);
    }

    public IRubyObject fetchClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        return this.getClassVariablesForRead().get(name2);
    }

    @Deprecated(since="1.7.0")
    public IRubyObject fastFetchClassVariable(String internedName) {
        return this.fetchClassVariable(internedName);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject storeClassVariable(String name2, IRubyObject value2) {
        return this.storeClassVariable(this.getCurrentContext(), name2, value2);
    }

    public IRubyObject storeClassVariable(ThreadContext context, String name2, IRubyObject value2) {
        assert (IdUtil.isClassVariable(name2) && value2 != null);
        this.checkAndRaiseIfFrozen(context);
        this.getClassVariables().put(name2, value2);
        return value2;
    }

    @Deprecated(since="1.7.0")
    public IRubyObject fastStoreClassVariable(String internedName, IRubyObject value2) {
        return this.storeClassVariable(this.getCurrentContext(), internedName, value2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject deleteClassVariable(String name2) {
        return this.deleteClassVariable(this.getCurrentContext(), name2);
    }

    private IRubyObject deleteClassVariable(ThreadContext context, String name2) {
        assert (IdUtil.isClassVariable(name2));
        this.checkAndRaiseIfFrozen(context);
        return this.getClassVariablesForRead().remove(name2);
    }

    public List<String> getClassVariableNameList() {
        return new ArrayList<String>(this.getClassVariablesForRead().keySet());
    }

    @Deprecated(since="10.0.0.0")
    protected final String validateClassVariable(String name2) {
        return this.validateClassVariable(this.getCurrentContext(), name2);
    }

    private String validateClassVariable(ThreadContext context, String name2) {
        if (IdUtil.isValidClassVariableName(name2)) {
            return name2;
        }
        throw context.runtime.newNameError("'%1$s' is not allowed as a class variable name", (IRubyObject)this, name2);
    }

    @Deprecated(since="10.0.0.0")
    protected final String validateClassVariable(IRubyObject nameObj, String name2) {
        if (IdUtil.isValidClassVariableName(name2)) {
            return name2;
        }
        throw this.getCurrentContext().runtime.newNameError("'%1$s' is not allowed as a class variable name", (IRubyObject)this, nameObj);
    }

    @Deprecated(since="10.0.0.0")
    protected String validateClassVariable(Ruby runtime2, IRubyObject object) {
        return this.validateClassVariable(runtime2.getCurrentContext(), object);
    }

    protected String validateClassVariable(ThreadContext context, IRubyObject object) {
        RubySymbol name2 = Check.checkID(context, object);
        if (!name2.validClassVariableName()) {
            throw context.runtime.newNameError(RubyStringBuilder.str(context.runtime, "'", RubyStringBuilder.ids(context.runtime, name2), "' is not allowed as a class variable name"), (IRubyObject)this, object);
        }
        return name2.idString();
    }

    @Deprecated(since="10.0.0.0")
    protected final void ensureClassVariablesSettable() {
        this.checkAndRaiseIfFrozen(this.getCurrentContext());
    }

    public boolean hasConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        return this.constantTableContains(name2);
    }

    @Deprecated(since="1.7.0")
    public boolean fastHasConstant(String internedName) {
        return this.hasConstant(internedName);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject fetchConstant(String name2) {
        return this.fetchConstant(this.getCurrentContext(), name2);
    }

    public IRubyObject fetchConstant(ThreadContext context, String name2) {
        return this.fetchConstant(context, name2, true);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject fetchConstant(String name2, boolean includePrivate) {
        return this.fetchConstant(this.getCurrentContext(), name2, includePrivate);
    }

    public IRubyObject fetchConstant(ThreadContext context, String name2, boolean includePrivate) {
        ConstantEntry entry = this.fetchConstantEntry(context, name2, includePrivate);
        return entry != null ? entry.value : null;
    }

    @Deprecated(since="10.0.0.0")
    public ConstantEntry fetchConstantEntry(String name2, boolean includePrivate) {
        return this.fetchConstantEntry(this.getCurrentContext(), name2, includePrivate);
    }

    public ConstantEntry fetchConstantEntry(ThreadContext context, String name2, boolean includePrivate) {
        ConstantEntry entry = this.constantEntryFetch(name2);
        if (entry == null) {
            return null;
        }
        if (entry.hidden && !includePrivate) {
            context.setPrivateConstantReference(this.getOrigin());
            return null;
        }
        if (entry.deprecated) {
            String parent = "Object".equals(this.getName(context)) ? BUILTIN_CONSTANT : this.getName(context);
            Warn.warnDeprecated(context, "constant " + parent + "::" + name2 + " is deprecated");
        }
        return entry;
    }

    @Deprecated(since="1.7.0")
    public IRubyObject fastFetchConstant(String internedName) {
        return this.fetchConstant(this.getCurrentContext(), internedName);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject storeConstant(String name2, IRubyObject value2) {
        return this.storeConstant(this.getCurrentContext(), name2, value2);
    }

    public IRubyObject storeConstant(ThreadContext context, String name2, IRubyObject value2) {
        assert (value2 != null) : "value is null";
        this.checkAndRaiseIfFrozen(context);
        return this.constantTableStore(name2, value2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject storeConstant(String name2, IRubyObject value2, boolean hidden, String file2, int line) {
        return this.storeConstant(this.getCurrentContext(), name2, value2, hidden, file2, line);
    }

    public IRubyObject storeConstant(ThreadContext context, String name2, IRubyObject value2, boolean hidden, String file2, int line) {
        assert (value2 != null) : "value is null";
        this.checkAndRaiseIfFrozen(context);
        this.constantTableStore(name2, value2, hidden, false, file2, line);
        if (file2 != null && file2 != BUILTIN_CONSTANT) {
            this.callMethod(context, "const_added", (IRubyObject)Convert.asSymbol(context, name2));
        }
        return value2;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject storeConstant(String name2, IRubyObject value2, boolean hidden) {
        assert (value2 != null) : "value is null";
        this.checkAndRaiseIfFrozen(this.getCurrentContext());
        return this.constantTableStore(name2, value2, hidden);
    }

    private IRubyObject storeConstant(ThreadContext context, String name2, IRubyObject value2, boolean hidden, boolean deprecated) {
        assert (value2 != null) : "value is null";
        this.checkAndRaiseIfFrozen(context);
        return this.constantTableStore(name2, value2, hidden, deprecated);
    }

    @Deprecated(since="1.7.0")
    public IRubyObject fastStoreConstant(String internedName, IRubyObject value2) {
        return this.storeConstant(this.getCurrentContext(), internedName, value2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject deleteConstant(String name2) {
        return this.deleteConstant(this.getCurrentContext(), name2);
    }

    public IRubyObject deleteConstant(ThreadContext context, String name2) {
        assert (name2 != null) : "name is null";
        this.checkAndRaiseIfFrozen(context);
        return this.constantTableRemove(name2);
    }

    @Deprecated(since="1.1.5")
    public List<Variable<IRubyObject>> getStoredConstantList() {
        return null;
    }

    @Deprecated(since="1.1.5")
    public List<String> getStoredConstantNameList() {
        return new ArrayList<String>(this.getConstantMap().keySet());
    }

    public Collection<String> getConstantNames() {
        return this.getConstantMap().keySet();
    }

    public Collection<String> getConstantNames(boolean includePrivate) {
        if (includePrivate) {
            return this.getConstantNames();
        }
        if (this.getConstantMap().size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> publicNames = new HashSet<String>(this.getConstantMap().size());
        for (Map.Entry<String, ConstantEntry> entry : this.getConstantMap().entrySet()) {
            if (entry.getValue().hidden) continue;
            publicNames.add(entry.getKey());
        }
        return publicNames;
    }

    @Deprecated(since="10.0.0.0")
    protected final String validateConstant(IRubyObject name2) {
        return this.validateConstant(this.getCurrentContext(), name2);
    }

    protected final String validateConstant(ThreadContext context, IRubyObject name2) {
        return RubySymbol.retrieveIDSymbol(name2, (sym, newSym) -> {
            if (!sym.validConstantName()) {
                throw Error.nameError(context, RubyStringBuilder.str(context.runtime, "wrong constant name ", sym), sym);
            }
        }).idString();
    }

    @Deprecated(since="10.0.0.0")
    protected final String validateConstant(String name2, IRubyObject errorName) {
        return this.validateConstant(this.getCurrentContext(), name2, errorName);
    }

    private final String validateConstant(ThreadContext context, String name2, IRubyObject errorName) {
        if (IdUtil.isValidConstantName(name2)) {
            return name2;
        }
        RubyString nameString = errorName.asString();
        return RubySymbol.retrieveIDSymbol(nameString, (sym, newSym) -> {
            if (!sym.validConstantName()) {
                throw Error.nameError(context, RubyStringBuilder.str(context.runtime, "wrong constant name ", sym), sym);
            }
        }).idString();
    }

    @Deprecated(since="10.0.0.0")
    protected final void ensureConstantsSettable() {
        this.checkAndRaiseIfFrozen(this.getCurrentContext());
    }

    private void checkAndRaiseIfFrozen(ThreadContext context) throws RaiseException {
        if (this.isFrozen()) {
            if (!(this instanceof RubyClass)) {
                throw Error.frozenError(context, this, "Module");
            }
            if (this.getBaseName() != null) {
                throw Error.frozenError(context, this, "#<Class:" + this.getName(context) + ">");
            }
            throw Error.frozenError(context, this, this.getName(context));
        }
    }

    @Override
    public final void checkFrozen() {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(this.isClass() ? "class" : "module", this);
        }
    }

    protected boolean constantTableContains(String name2) {
        return this.getConstantMap().containsKey(name2);
    }

    protected IRubyObject constantTableFetch(String name2) {
        ConstantEntry entry = this.getConstantMap().get(name2);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    protected ConstantEntry constantEntryFetch(String name2) {
        return this.getConstantMap().get(name2);
    }

    protected IRubyObject constantTableStore(String name2, IRubyObject value2) {
        Map<String, ConstantEntry> constMap = this.getConstantMapForWrite();
        boolean hidden = false;
        ConstantEntry entry = constMap.get(name2);
        if (entry != null && entry.value != UNDEF) {
            hidden = entry.hidden;
        }
        constMap.put(name2, new ConstantEntry(value2, hidden));
        return value2;
    }

    protected IRubyObject constantTableStore(String name2, IRubyObject value2, boolean hidden) {
        return this.constantTableStore(name2, value2, hidden, false);
    }

    public void defineConstantBootstrap(String name2, IRubyObject value2) {
        this.constantTableStore(name2, value2, false, false, null, -1);
    }

    protected IRubyObject constantTableStore(String name2, IRubyObject value2, boolean hidden, boolean deprecated, String file2, int line) {
        Map<String, ConstantEntry> constMap = this.getConstantMapForWrite();
        ConstantEntry entry = new ConstantEntry(value2, hidden, deprecated);
        if (file2 != null) {
            entry.file = file2;
            entry.line = line;
        }
        constMap.put(name2, entry);
        return value2;
    }

    protected IRubyObject constantTableStore(String name2, IRubyObject value2, boolean hidden, boolean deprecated) {
        Map<String, ConstantEntry> constMap = this.getConstantMapForWrite();
        constMap.put(name2, new ConstantEntry(value2, hidden, deprecated));
        return value2;
    }

    protected IRubyObject constantTableRemove(String name2) {
        ConstantEntry entry = this.getConstantMapForWrite().remove(name2);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    @Deprecated(since="10.0.0.0")
    protected final void defineAutoload(String symbol, RubyString path2) {
        this.defineAutoload(this.getCurrentContext(), symbol, path2);
    }

    protected final void defineAutoload(ThreadContext context, String symbol, RubyString path2) {
        Autoload existingAutoload = this.getAutoloadMap().get(symbol);
        if (existingAutoload == null || existingAutoload.getValue() == null) {
            this.storeConstant(context, symbol, RubyObject.UNDEF, false, context.getFile(), context.getLine());
            RubyStackTraceElement caller2 = context.getSingleBacktrace();
            this.getAutoloadMapForWrite().put(symbol, new Autoload(symbol, path2, caller2.getFileName(), caller2.getLineNumber()));
        }
    }

    @Deprecated(since="10.0.0.0")
    protected final IRubyObject finishAutoload(String name2) {
        return this.finishAutoload(this.getCurrentContext(), name2);
    }

    protected final IRubyObject finishAutoload(ThreadContext context, String name2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 == null) {
            return null;
        }
        IRubyObject value2 = autoload2.getValue();
        if (value2 != null && value2 != UNDEF) {
            this.storeConstant(context, name2, value2, autoload2.hidden, autoload2.getFile(), autoload2.getLine());
            this.invalidateConstantCache(context, name2);
        }
        this.removeAutoload(name2);
        return value2;
    }

    @Deprecated(since="10.0.0.0")
    public final IRubyObject getAutoloadConstant(String name2) {
        return this.getAutoloadConstant(this.getCurrentContext(), name2);
    }

    public final IRubyObject getAutoloadConstant(ThreadContext context, String name2) {
        return this.getAutoloadConstant(context, name2, true);
    }

    @Deprecated(since="10.0.0.0")
    protected IRubyObject getAutoloadConstant(String name2, boolean loadConstant) {
        return this.getAutoloadConstant(this.getCurrentContext(), name2, loadConstant);
    }

    protected IRubyObject getAutoloadConstant(ThreadContext context, String name2, boolean loadConstant) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 == null) {
            return null;
        }
        if (!loadConstant) {
            return RubyObject.UNDEF;
        }
        return autoload2.load(context);
    }

    private boolean setAutoloadConstant(ThreadContext context, String name2, IRubyObject value2, boolean hidden, String file2, int line) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 == null) {
            return false;
        }
        boolean set2 = autoload2.setConstant(context, value2, hidden, file2, line);
        if (!set2) {
            this.removeAutoload(name2);
        }
        return set2;
    }

    private void removeAutoload(String name2) {
        this.getAutoloadMapForWrite().remove(name2);
    }

    protected RubyString getAutoloadFile(String name2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        return autoload2 == null ? null : autoload2.getPath();
    }

    private static void define(ThreadContext context, RubyModule module, JavaMethodDescriptor desc, DynamicMethod dynamicMethod) {
        block16: {
            String baseName;
            String[] aliases2;
            String[] names2;
            JRubyMethod jrubyMethod;
            block15: {
                String baseName2;
                jrubyMethod = desc.anno;
                names2 = jrubyMethod.name();
                aliases2 = jrubyMethod.alias();
                if (!jrubyMethod.meta()) break block15;
                RubyClass singletonClass = module.singletonClass(context);
                dynamicMethod.setImplementationClass(singletonClass);
                if (names2.length == 0) {
                    baseName2 = desc.name;
                    singletonClass.addMethod(context, baseName2, dynamicMethod);
                } else {
                    baseName2 = names2[0];
                    for (String name2 : names2) {
                        singletonClass.addMethod(context, name2, dynamicMethod);
                    }
                }
                if (aliases2.length <= 0) break block16;
                for (String alias : aliases2) {
                    singletonClass.defineAlias(context, alias, baseName2);
                }
                break block16;
            }
            if (names2.length == 0) {
                baseName = desc.name;
                module.getMethodLocation().addMethod(context, baseName, dynamicMethod);
            } else {
                baseName = names2[0];
                for (String name3 : names2) {
                    module.getMethodLocation().addMethod(context, name3, dynamicMethod);
                }
            }
            if (aliases2.length > 0) {
                for (String alias : aliases2) {
                    module.defineAlias(context, alias, baseName);
                }
            }
            if (jrubyMethod.module()) {
                RubyClass singletonClass = module.singletonClass(context);
                DynamicMethod moduleMethod = dynamicMethod.dup();
                moduleMethod.setImplementationClass(singletonClass);
                moduleMethod.setVisibility(Visibility.PUBLIC);
                if (names2.length == 0) {
                    baseName = desc.name;
                    singletonClass.addMethod(context, desc.name, moduleMethod);
                } else {
                    baseName = names2[0];
                    for (String name4 : names2) {
                        singletonClass.addMethod(context, name4, moduleMethod);
                    }
                }
                if (aliases2.length > 0) {
                    for (String alias : aliases2) {
                        singletonClass.defineAlias(context, alias, baseName);
                    }
                }
            }
        }
    }

    @Deprecated(since="1.7.0")
    public IRubyObject initialize(Block block) {
        return this.initialize(this.getCurrentContext());
    }

    public void setJavaProxy(boolean javaProxy) {
        this.javaProxy = javaProxy;
    }

    public boolean getJavaProxy() {
        return this.javaProxy;
    }

    public boolean getCacheProxy() {
        return this.getFlag(CACHEPROXY_F);
    }

    public void setCacheProxy(boolean cacheProxy) {
        this.setFlag(CACHEPROXY_F, cacheProxy);
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        Class<?> javaClass;
        if (target2 == Class.class && (javaClass = JavaUtil.getJavaClass(this, null)) != null) {
            return (T)javaClass;
        }
        return super.toJava(target2);
    }

    public Set<String> discoverInstanceVariables() {
        HashSet<String> set2 = new HashSet<String>();
        for (RubyModule cls = this; cls != null; cls = cls.getSuperClass()) {
            Map<String, DynamicMethod> methods2 = cls.getOrigin().getMethodLocation().getMethods();
            methods2.forEach((name2, method2) -> set2.addAll(method2.getInstanceVariableNames()));
        }
        return set2;
    }

    public boolean isRefinement() {
        return this.getFlag(REFINED_MODULE_F);
    }

    public boolean usingTemporaryName() {
        return this.getFlag(TEMPORARY_NAME);
    }

    public boolean isIncludedIntoRefinement() {
        return this.getFlag(INCLUDED_INTO_REFINEMENT);
    }

    public boolean isMethodBuiltin(String methodName) {
        DynamicMethod method2 = this.searchMethod(methodName);
        return method2 != null && method2.isBuiltin();
    }

    public Map<RubyModule, RubyModule> getRefinements() {
        RefinementStore refinementStore = this.refinementStore;
        if (refinementStore == null) {
            return Collections.EMPTY_MAP;
        }
        return refinementStore.refinements;
    }

    public Map<RubyModule, RubyModule> getRefinementsForWrite() {
        RefinementStore refinementStore = this.getRefinementStoreForWrite();
        return refinementStore.refinements;
    }

    public void setRefinements(Map<RubyModule, RubyModule> refinements2) {
        this.getRefinementStoreForWrite().refinements = refinements2;
    }

    public static void finishRefinementClass(ThreadContext context, RubyClass Refinement) {
        ((RubyModule)((RubyModule)((RubyModule)Refinement.reifiedClass(RubyModule.class)).classIndex(ClassIndex.REFINEMENT)).defineMethods(context, RefinementMethods.class)).undefMethods(context, "append_features", "prepend_features", "extend_object");
    }

    @Deprecated(since="9.3.0.0")
    public boolean fastIsConstantDefined(String internedName) {
        return this.isConstantDefined(this.getCurrentContext(), internedName);
    }

    @Deprecated(since="9.3.1.0")
    public synchronized void defineAliases(List<String> aliases2, String oldId) {
        ThreadContext context = this.getCurrentContext();
        this.testFrozen("module");
        CacheEntry entry = this.deepMethodSearch(context, oldId);
        DynamicMethod method2 = entry.method;
        for (String name2 : aliases2) {
            this.checkAliasFrameAccesses(context, oldId, name2, method2);
            this.putAlias(context, name2, entry, oldId);
        }
        RubyModule methodLocation = this.getMethodLocation();
        methodLocation.invalidateCacheDescendants(context);
    }

    public static JavaSites.ModuleSites sites(ThreadContext context) {
        return context.sites.Module;
    }

    @Deprecated(since="9.4.6.0")
    public IRubyObject const_get(IRubyObject symbol) {
        return this.const_get(this.getCurrentContext(), symbol);
    }

    @Deprecated(since="9.4.6.0")
    public IRubyObject const_get(ThreadContext context, IRubyObject ... args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        boolean inherit = argc == 1 || !args2[1].isNil() && args2[1].isTrue();
        IRubyObject symbol = args2[0];
        return this.constGetCommon(context, symbol, inherit);
    }

    @Deprecated(since="9.4.6.0")
    public IRubyObject const_get_1_9(ThreadContext context, IRubyObject[] args2) {
        return this.const_get(context, args2);
    }

    @Deprecated(since="9.4.6.0")
    public IRubyObject const_get_2_0(ThreadContext context, IRubyObject[] args2) {
        return this.const_get(context, args2);
    }

    static {
        try {
            CONSTANTS_HANDLE = MethodHandles.lookup().findVarHandle(RubyModule.class, "constants", Map.class);
            AUTOLOADS_HANDLE = MethodHandles.lookup().findVarHandle(RubyModule.class, "autoloads", Map.class);
            METHODS_HANDLE = MethodHandles.lookup().findVarHandle(RubyModule.class, "methods", Map.class);
            INCLUDING_HIERARCHIES_HANDLE = MethodHandles.lookup().findVarHandle(RubyModule.class, "includingHierarchies", RubyClass.RubyClassSet.class);
            CLASS_PROVIDERS_HANDLE = MethodHandles.lookup().findVarHandle(RubyModule.class, "classProviders", Set.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        SCOPE_CAPTURING_METHODS = new HashSet<String>(Arrays.asList("eval", "module_eval", "class_eval", "instance_eval", "module_exec", "class_exec", "instance_exec", "binding", "local_variables"));
        try {
            CLASSVARS_HANDLE = MethodHandles.lookup().findVarHandle(RubyModule.class, "classVariables", Map.class);
            REFINEMENT_STORE_HANDLE = MethodHandles.lookup().findVarHandle(RubyModule.class, "refinementStore", RefinementStore.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        LOOKUP = MethodHandles.lookup();
        testModuleMatch = Binder.from(Boolean.TYPE, ThreadContext.class, IRubyObject.class, Integer.TYPE).invokeStaticQuiet(LOOKUP, RubyModule.class, "testModuleMatch");
    }

    public static final class JavaClassKindOf
    extends KindOf {
        private final Class klass;

        public JavaClassKindOf(Class klass) {
            this.klass = klass;
        }

        @Override
        public boolean isKindOf(IRubyObject obj, RubyModule type2) {
            return this.klass.isInstance(obj);
        }
    }

    public static class KindOf {
        public static final KindOf DEFAULT_KIND_OF = new KindOf();

        public boolean isKindOf(IRubyObject obj, RubyModule type2) {
            RubyClass cl = obj.getMetaClass();
            if (cl == null) {
                return false;
            }
            return cl.hasAncestor(type2);
        }
    }

    @Deprecated(since="9.3.0.0")
    public static class ModuleKernelMethods {
        @Deprecated(since="9.3.0.0")
        public static IRubyObject autoload(ThreadContext context, IRubyObject self2, IRubyObject symbol, IRubyObject file2) {
            return ((RubyModule)self2).autoload(context, symbol, file2);
        }

        @Deprecated(since="9.3.0.0")
        public static IRubyObject autoload_p(ThreadContext context, IRubyObject self2, IRubyObject symbol) {
            return ((RubyModule)self2).autoload_p(context, symbol);
        }
    }

    public final class Autoload
    implements SourceLocation {
        private volatile ThreadContext ctx;
        private volatile IRubyObject value;
        private boolean hidden;
        private final String symbol;
        private final RubyString path;
        public String file;
        public int line;

        Autoload(String symbol, RubyString path2, String file2, int line) {
            this.symbol = symbol;
            this.path = path2;
            this.file = file2;
            this.line = line;
        }

        @Override
        public String getFile() {
            return this.file;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        synchronized IRubyObject load(ThreadContext context) {
            if (this.ctx == null) {
                this.ctx = context;
            } else if (this.isSelf(context)) {
                return this.getValue();
            }
            try {
                LoadService loadService = Access.loadService(context);
                if (!loadService.featureAlreadyLoaded(this.path.asJavaString()) && loadService.autoloadRequire(this.path)) {
                    RubyModule.this.finishAutoload(context, this.symbol);
                }
            }
            catch (LoadError | RuntimeError lre) {
                this.ctx = null;
                throw lre;
            }
            return this.getValue();
        }

        synchronized boolean setConstant(ThreadContext ctx, IRubyObject newValue, boolean hidden, String file2, int line) {
            boolean isSelf = this.isSelf(ctx);
            if (isSelf) {
                if (newValue != null && newValue != RubyBasicObject.UNDEF) {
                    this.value = newValue;
                }
                this.hidden = hidden;
                this.file = file2;
                this.line = line;
            }
            return isSelf;
        }

        synchronized IRubyObject getValue() {
            return this.value;
        }

        RubyString getPath() {
            return this.path;
        }

        private boolean isSelf(ThreadContext rhs) {
            ThreadContext ctx = this.ctx;
            return ctx != null && ctx.getThread() == rhs.getThread();
        }
    }

    protected static class ProfilingCacheEntryFactory
    extends WrapperCacheEntryFactory {
        private final MethodEnhancer enhancer;

        public ProfilingCacheEntryFactory(Ruby runtime2, CacheEntryFactory previous) {
            super(previous);
            this.enhancer = runtime2.getProfilingService().newMethodEnhancer(runtime2);
        }

        private MethodEnhancer getMethodEnhancer() {
            return this.enhancer;
        }

        @Override
        public CacheEntry newCacheEntry(String id, DynamicMethod method2, RubyModule sourceModule, int token2) {
            if (method2.isUndefined()) {
                return new CacheEntry(method2, token2);
            }
            CacheEntry delegated = this.previous.newCacheEntry(id, method2, sourceModule, token2);
            DynamicMethod enhancedMethod = this.getMethodEnhancer().enhance(id, delegated.method);
            return new CacheEntry(enhancedMethod, delegated.sourceModule, delegated.token);
        }
    }

    protected static abstract class CacheEntryFactory {
        protected CacheEntryFactory() {
        }

        public abstract CacheEntry newCacheEntry(String var1, DynamicMethod var2, RubyModule var3, int var4);

        public boolean hasCacheEntryFactory(Class cacheEntryFactoryClass) {
            CacheEntryFactory current2 = this;
            while (current2 instanceof WrapperCacheEntryFactory) {
                if (cacheEntryFactoryClass.isAssignableFrom(current2.getClass())) {
                    return true;
                }
                current2 = ((WrapperCacheEntryFactory)current2).getPrevious();
            }
            return cacheEntryFactoryClass.isAssignableFrom(current2.getClass());
        }
    }

    private class RefinementStore {
        private volatile Map<RubyModule, RubyModule> refinements = RubyModule.newRefinementsMap();
        private final Map<RubyModule, IncludedModule> activatedRefinements = RubyModule.newActivatedRefinementsMap();
        volatile RubyModule refinedClass;
        private volatile RubyModule definedAt;

        private RefinementStore(RubyModule rubyModule) {
        }
    }

    protected static class SynchronizedCacheEntryFactory
    extends WrapperCacheEntryFactory {
        public SynchronizedCacheEntryFactory(CacheEntryFactory previous) {
            super(previous);
        }

        @Override
        public CacheEntry newCacheEntry(String id, DynamicMethod method2, RubyModule sourceModule, int token2) {
            if (method2.isUndefined()) {
                return new CacheEntry(method2, token2);
            }
            CacheEntry delegated = this.previous.newCacheEntry(id, method2, sourceModule, token2);
            return new CacheEntry(new SynchronizedDynamicMethod(delegated.method), delegated.sourceModule, delegated.token);
        }
    }

    public static class InvalidatorList<T>
    extends ArrayList<T>
    implements RubyClass.BiConsumerIgnoresSecond<RubyClass> {
        public InvalidatorList(int size2) {
            super(size2);
        }

        @Override
        public void accept(RubyClass rubyClass) {
            rubyClass.addInvalidatorsAndFlush(this);
        }
    }

    public static class RespondToMissingMethod
    extends JavaMethod.JavaMethodNBlock {
        final String methodName;

        public RespondToMissingMethod(RubyModule implClass, Visibility visibility, String methodName) {
            super(implClass, visibility, methodName);
            this.setParameterList(REST);
            this.methodName = methodName;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return Helpers.callMethodMissing(context, self2, this.getVisibility(), name2, CallType.UNKNOWN, args2, block);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof RespondToMissingMethod && ((RespondToMissingMethod)other).methodName.equals(this.methodName);
        }

        public int hashCode() {
            return this.methodName.hashCode();
        }
    }

    public static interface SourceLocation {
        public String getFile();

        public int getLine();
    }

    public static class ConstantEntry
    implements SourceLocation {
        public final IRubyObject value;
        public final boolean hidden;
        final boolean deprecated;
        private String file;
        private int line;

        public ConstantEntry(IRubyObject value2, boolean hidden) {
            this.value = value2;
            this.hidden = hidden;
            this.deprecated = false;
        }

        ConstantEntry(IRubyObject value2, boolean hidden, boolean deprecated) {
            this.value = value2;
            this.hidden = hidden;
            this.deprecated = deprecated;
        }

        ConstantEntry(IRubyObject value2, boolean hidden, boolean deprecated, String file2, int line) {
            this.value = value2;
            this.hidden = hidden;
            this.deprecated = deprecated;
            this.file = file2;
            this.line = line;
        }

        @Override
        public String getFile() {
            return this.file;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        public ConstantEntry dup() {
            return new ConstantEntry(this.value, this.hidden, this.deprecated);
        }
    }

    public static class RefinementMethods {
        @JRubyMethod(required=1, rest=true, checkArity=false, visibility=Visibility.PRIVATE)
        public static IRubyObject import_methods(ThreadContext context, IRubyObject self2, IRubyObject[] modules) {
            RubyModule module;
            Arity.checkArgumentCount(context, modules, 1, -1);
            RubyModule selfModule = (RubyModule)self2;
            for (IRubyObject _module : modules) {
                module = Convert.castAsModule(context, _module);
                if (module.getSuperClass() == null) continue;
                Warn.warn(context, module.getName(context) + " has ancestors, but Refinement#import_methods doesn't import their methods");
            }
            for (IRubyObject _module : modules) {
                module = (RubyModule)_module;
                for (Map.Entry<String, DynamicMethod> entry : module.getMethods().entrySet()) {
                    RefinementMethods.refinementImportMethodsIter(context, selfModule, module, entry);
                }
            }
            return self2;
        }

        private static void refinementImportMethodsIter(ThreadContext context, RubyModule selfModule, RubyModule module, Map.Entry<String, DynamicMethod> entry) {
            DynamicMethod method2 = entry.getValue();
            if (!(method2 instanceof AbstractIRMethod)) {
                throw Error.argumentError(context, "Can't import method which is not defined with Ruby code: " + module.getName(context) + "#" + entry.getKey());
            }
            DynamicMethod dup2 = entry.getValue().dup();
            ((AbstractIRMethod)dup2).getIRScope().setIsMaybeUsingRefinements();
            selfModule.addMethod(context, entry.getKey(), dup2);
        }
    }

    @Deprecated(since="9.3.0.0")
    public static interface AutoloadMethod {
        public void load(Ruby var1);

        public RubyString getFile();
    }

    static class SubclassList
    extends ArrayList<RubyClass>
    implements RubyClass.BiConsumerIgnoresSecond<RubyClass> {
        boolean includeDescendants;

        public SubclassList(boolean includeDescendants, int i2) {
            super(i2);
            this.includeDescendants = includeDescendants;
        }

        @Override
        public void accept(RubyClass klass) {
            this.add(klass);
            if (this.includeDescendants) {
                klass.addAllSubclasses(this);
            }
        }
    }

    protected static abstract class WrapperCacheEntryFactory
    extends CacheEntryFactory {
        protected final CacheEntryFactory previous;

        public WrapperCacheEntryFactory(CacheEntryFactory previous) {
            this.previous = previous;
        }

        public CacheEntryFactory getPrevious() {
            return this.previous;
        }
    }

    public static final class MethodClumper {
        private HashMap<String, List<JavaMethodDescriptor>> annotatedMethods;
        private HashMap<String, List<JavaMethodDescriptor>> staticAnnotatedMethods;
        public Map<Set<FrameField>, List<String>> readGroups = Collections.EMPTY_MAP;
        public Map<Set<FrameField>, List<String>> writeGroups = Collections.EMPTY_MAP;

        public void clump(Class klass) {
            this.clump(MethodGatherer.DECLARED_METHODS.get(klass));
        }

        public void clump(Method[] declaredMethods) {
            for (Method method2 : declaredMethods) {
                ArrayList<JavaMethodDescriptor> methodDescs;
                HashMap<String, List<JavaMethodDescriptor>> methodsHash;
                String name2;
                JRubyMethod anno = method2.getAnnotation(JRubyMethod.class);
                if (anno == null || method2.isBridge()) continue;
                JavaMethodDescriptor desc = new JavaMethodDescriptor(method2);
                String[] names2 = anno.name();
                String string2 = name2 = names2.length == 0 ? method2.getName() : names2[0];
                if (desc.isStatic) {
                    methodsHash = this.staticAnnotatedMethods;
                    if (methodsHash == null) {
                        this.staticAnnotatedMethods = new HashMap();
                        methodsHash = this.staticAnnotatedMethods;
                    }
                } else {
                    methodsHash = this.annotatedMethods;
                    if (methodsHash == null) {
                        this.annotatedMethods = new HashMap();
                        methodsHash = this.annotatedMethods;
                    }
                }
                if ((methodDescs = (ArrayList<JavaMethodDescriptor>)methodsHash.get(name2)) == null) {
                    methodDescs = new ArrayList<JavaMethodDescriptor>(4);
                    methodsHash.put(name2, methodDescs);
                }
                methodDescs.add(desc);
                if (anno.reads().length > 0 && this.readGroups == Collections.EMPTY_MAP) {
                    this.readGroups = new HashMap<Set<FrameField>, List<String>>();
                }
                if (anno.writes().length > 0 && this.writeGroups == Collections.EMPTY_MAP) {
                    this.writeGroups = new HashMap<Set<FrameField>, List<String>>();
                }
                AnnotationHelper.groupFrameFields(this.readGroups, this.writeGroups, anno, method2.getName());
            }
        }

        @Deprecated(since="9.1.0.0")
        public Map<String, List<JavaMethodDescriptor>> getAllAnnotatedMethods() {
            return null;
        }

        public final Map<String, List<JavaMethodDescriptor>> getAnnotatedMethods() {
            return this.annotatedMethods == null ? Collections.EMPTY_MAP : this.annotatedMethods;
        }

        public final Map<String, List<JavaMethodDescriptor>> getStaticAnnotatedMethods() {
            return this.staticAnnotatedMethods == null ? Collections.EMPTY_MAP : this.staticAnnotatedMethods;
        }
    }
}

