/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.rules;

import java.util.List;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.immutables.value.Value;
import org.opensearch.sql.calcite.plan.OpenSearchRuleConfig;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.opensearch.planner.rules.ImmutableSortIndexScanRule;
import org.opensearch.sql.opensearch.planner.rules.InterruptibleRelRule;
import org.opensearch.sql.opensearch.storage.scan.AbstractCalciteIndexScan;

@Value.Enclosing
public class SortIndexScanRule
extends InterruptibleRelRule<Config> {
    protected SortIndexScanRule(Config config) {
        super(config);
    }

    @Override
    protected void onMatchImpl(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        AbstractCalciteIndexScan scan = (AbstractCalciteIndexScan)call.rel(1);
        if (sort.getConvention() != scan.getConvention()) {
            return;
        }
        List collations = sort.collation.getFieldCollations();
        AbstractCalciteIndexScan newScan = scan.pushDownSort(collations);
        if (newScan != null) {
            call.transformTo((RelNode)newScan);
        }
    }

    @Value.Immutable
    public static interface Config
    extends OpenSearchRuleConfig {
        public static final Config DEFAULT = ImmutableSortIndexScanRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(Sort.class).predicate(PlanUtils::sortByFieldsOnly).oneInput(b1 -> b1.operand(AbstractCalciteIndexScan.class).predicate(Predicate.not(AbstractCalciteIndexScan::isTopKPushed).and(Predicate.not(AbstractCalciteIndexScan::isMetricsOrderPushed))).noInputs()));

        default public SortIndexScanRule toRule() {
            return new SortIndexScanRule(this);
        }
    }
}

