/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import shaded.com.google.common.collect.ImmutableMap;

public class RemoveOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final Set<ReferenceExpression> removeList;
    private final Set<String> nameRemoveList;

    public RemoveOperator(PhysicalPlan input, Set<ReferenceExpression> removeList) {
        this.input = input;
        this.removeList = removeList;
        this.nameRemoveList = removeList.stream().map(ReferenceExpression::getAttr).collect(Collectors.toSet());
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitRemove(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.input.hasNext();
    }

    @Override
    public ExprValue next() {
        ExprValue inputValue = (ExprValue)this.input.next();
        if (ExprCoreType.STRUCT == inputValue.type()) {
            ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
            Map<String, ExprValue> tupleValue = ExprValueUtils.getTupleValue(inputValue);
            for (Map.Entry<String, ExprValue> valueEntry : tupleValue.entrySet()) {
                if (this.nameRemoveList.contains(valueEntry.getKey())) continue;
                mapBuilder.put(valueEntry);
            }
            return ExprTupleValue.fromExprValueMap((Map<String, ExprValue>)mapBuilder.build());
        }
        return inputValue;
    }

    @Generated
    public String toString() {
        return "RemoveOperator(input=" + String.valueOf(this.getInput()) + ", removeList=" + String.valueOf(this.getRemoveList()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveOperator)) {
            return false;
        }
        RemoveOperator other = (RemoveOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        Set<ReferenceExpression> this$removeList = this.getRemoveList();
        Set<ReferenceExpression> other$removeList = other.getRemoveList();
        return !(this$removeList == null ? other$removeList != null : !((Object)this$removeList).equals(other$removeList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        Set<ReferenceExpression> $removeList = this.getRemoveList();
        result = result * 59 + ($removeList == null ? 43 : ((Object)$removeList).hashCode());
        return result;
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public Set<ReferenceExpression> getRemoveList() {
        return this.removeList;
    }
}

