/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.runner;

import com.amazon.randomcutforest.runner.ArgumentParser;
import com.amazon.randomcutforest.runner.SimpleRunner;
import com.amazon.randomcutforest.runner.UpdateOnlyTransformer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.StringJoiner;

public class ImputeRunner
extends SimpleRunner {
    private String missingValueMarker;
    private int numberOfMissingValues;
    private int[] missingIndexes;

    public ImputeRunner() {
        super(new ImputeArgumentParser(), UpdateOnlyTransformer::new);
    }

    public static void main(String ... args) throws IOException {
        ImputeRunner runner = new ImputeRunner();
        runner.parse(args);
        System.out.println("Reading from stdin... (Ctrl-c to exit)");
        runner.run(new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8)), new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8)));
        System.out.println("Done.");
    }

    @Override
    protected void prepareAlgorithm(int dimensions) {
        super.prepareAlgorithm(dimensions);
        this.missingIndexes = new int[dimensions];
        this.missingValueMarker = ((ImputeArgumentParser)this.argumentParser).getMissingValueMarker();
    }

    @Override
    protected void processLine(String[] values, PrintWriter out) {
        this.numberOfMissingValues = 0;
        for (int i = 0; i < this.getPointSize(); ++i) {
            if (!this.missingValueMarker.equals(values[i])) continue;
            this.missingIndexes[this.numberOfMissingValues++] = i;
            values[i] = "0";
        }
        if (this.numberOfMissingValues > 0) {
            this.parsePoint(values);
            double[] imputedPoint = this.algorithm.getForest().imputeMissingValues(this.pointBuffer, this.numberOfMissingValues, this.missingIndexes);
            StringJoiner joiner = new StringJoiner(this.argumentParser.getDelimiter());
            Arrays.stream(imputedPoint).mapToObj(Double::toString).forEach(joiner::add);
            out.println(joiner.toString());
        } else {
            super.processLine(values, out);
        }
    }

    public static class ImputeArgumentParser
    extends ArgumentParser {
        private final ArgumentParser.StringArgument missingValueMarker = new ArgumentParser.StringArgument(null, "--missing-value-marker", "String used to represent a missing value in the data.", "NA");

        public ImputeArgumentParser() {
            super(ImputeRunner.class.getName(), "Read rows with missing values and write rows with missing values imputed.");
            this.addArgument(this.missingValueMarker);
            this.removeArgument("--shingle-size");
            this.removeArgument("--shingle-cyclic");
        }

        public String getMissingValueMarker() {
            return (String)this.missingValueMarker.getValue();
        }
    }
}

