/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xdgf.usermodel.section.geometry;

import com.microsoft.schemas.office.visio.x2012.main.CellType;
import com.microsoft.schemas.office.visio.x2012.main.RowType;
import java.awt.geom.Path2D;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.xdgf.usermodel.XDGFCell;
import org.apache.poi.xdgf.usermodel.XDGFShape;
import org.apache.poi.xdgf.usermodel.section.geometry.GeometryRow;

public class PolyLineTo
implements GeometryRow {
    private static final String POLYLINE_FORMULA_PREFIX = "POLYLINE(";
    private static final String POLYLINE_FORMULA_SUFFIX = ")";
    PolyLineTo _master;
    Double x;
    Double y;
    String a;
    Boolean deleted;

    public PolyLineTo(RowType row) {
        if (row.isSetDel()) {
            this.deleted = row.getDel();
        }
        block10: for (CellType cell : row.getCellArray()) {
            String cellName;
            switch (cellName = cell.getN()) {
                case "X": {
                    this.x = XDGFCell.parseDoubleValue(cell);
                    continue block10;
                }
                case "Y": {
                    this.y = XDGFCell.parseDoubleValue(cell);
                    continue block10;
                }
                case "A": {
                    this.a = cell.getV();
                    continue block10;
                }
                default: {
                    throw new POIXMLException("Invalid cell '" + cellName + "' in ArcTo row");
                }
            }
        }
    }

    public boolean getDel() {
        if (this.deleted != null) {
            return this.deleted;
        }
        return this._master != null && this._master.getDel();
    }

    public Double getX() {
        return this.x == null ? this._master.x : this.x;
    }

    public Double getY() {
        return this.y == null ? this._master.y : this.y;
    }

    public String getA() {
        return this.a == null ? this._master.a : this.a;
    }

    @Override
    public void setupMaster(GeometryRow row) {
        this._master = (PolyLineTo)row;
    }

    @Override
    public void addToPath(Path2D.Double path, XDGFShape parent) {
        if (this.getDel()) {
            return;
        }
        String formula = this.getA().trim();
        if (!formula.startsWith(POLYLINE_FORMULA_PREFIX) || !formula.endsWith(POLYLINE_FORMULA_SUFFIX)) {
            throw new POIXMLException("Invalid POLYLINE formula: " + formula);
        }
        String[] components = formula.substring(POLYLINE_FORMULA_PREFIX.length(), formula.length() - POLYLINE_FORMULA_SUFFIX.length()).split(",");
        if (components.length < 2) {
            throw new POIXMLException("Invalid POLYLINE formula (not enough arguments): " + formula);
        }
        if (components.length % 2 != 0) {
            throw new POIXMLException("Invalid POLYLINE formula -- need 2 + n*2 arguments, got " + components.length);
        }
        if (components.length > 2) {
            double xScale = Integer.parseInt(components[0].trim()) == 0 ? parent.getWidth() : 1.0;
            double yScale = Integer.parseInt(components[1].trim()) == 0 ? parent.getHeight() : 1.0;
            for (int i = 2; i < components.length - 1; i += 2) {
                double x = Double.parseDouble(components[i].trim());
                double y = Double.parseDouble(components[i + 1].trim());
                path.lineTo(x * xScale, y * yScale);
            }
        }
        path.lineTo(this.getX(), this.getY());
    }
}

