/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query.visitor;

import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.BooleanClause;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.neuralsearch.query.ModelInferenceQueryBuilder;

public class NeuralSearchQueryVisitor
implements QueryBuilderVisitor {
    private final String modelId;
    private final Map<String, Object> neuralFieldMap;

    private Boolean isFieldDefaultModelIdApplied(String fieldName) {
        if (Objects.nonNull(this.neuralFieldMap) && Objects.nonNull(fieldName) && Objects.nonNull(this.neuralFieldMap.get(fieldName))) {
            return true;
        }
        return false;
    }

    public void accept(QueryBuilder queryBuilder) {
        ModelInferenceQueryBuilder modelInferenceQueryBuilder;
        if (queryBuilder instanceof ModelInferenceQueryBuilder && (modelInferenceQueryBuilder = (ModelInferenceQueryBuilder)queryBuilder).modelId() == null) {
            if (this.isFieldDefaultModelIdApplied(modelInferenceQueryBuilder.fieldName()).booleanValue()) {
                String fieldDefaultModelId = (String)this.neuralFieldMap.get(modelInferenceQueryBuilder.fieldName());
                modelInferenceQueryBuilder.modelId(fieldDefaultModelId);
            } else if (Objects.nonNull(this.modelId)) {
                modelInferenceQueryBuilder.modelId(this.modelId);
            } else {
                throw new IllegalArgumentException("model id must be provided in neural query or a default model id must be set in search request processor");
            }
        }
    }

    public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
        return this;
    }

    @Generated
    public NeuralSearchQueryVisitor(String modelId, Map<String, Object> neuralFieldMap) {
        this.modelId = modelId;
        this.neuralFieldMap = neuralFieldMap;
    }
}

