/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.performanceanalyzer.commons.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;

public class AdmissionControlMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    private static final Logger LOG = LogManager.getLogger(AdmissionControlMetricsCollector.class);
    private static final int sTimeInterval = 5000;
    private static final int KEYS_PATH_LENGTH = 0;
    private StringBuilder value = new StringBuilder();
    private static final String GLOBAL_JVMMP = "Global_JVMMP";
    private static final String REQUEST_SIZE = "Request_Size";
    private static final String ADMISSION_CONTROLLER = "com.sonian.opensearch.http.jetty.throttling.AdmissionController";
    private static final String ADMISSION_CONTROL_SERVICE = "com.sonian.opensearch.http.jetty.throttling.JettyAdmissionControlService";
    private Class admissionControllerClass;
    private Class jettyAdmissionControllerServiceClass;
    private final boolean admissionControllerAvailable = this.canLoadAdmissionControllerClasses();

    public AdmissionControlMetricsCollector() {
        super(5000, "AdmissionControlMetricsCollector", (MeasurementSet)StatMetrics.ADMISSION_CONTROL_COLLECTOR_EXECUTION_TIME, StatExceptionCode.ADMISSION_CONTROL_COLLECTOR_ERROR);
    }

    public void collectMetrics(long startTime) {
        if (!this.admissionControllerAvailable) {
            LOG.debug("AdmissionControl is not available for this domain");
            ServiceMetrics.COMMONS_STAT_METRICS_AGGREGATOR.updateStat((MeasurementSet)StatMetrics.ADMISSION_CONTROL_COLLECTOR_NOT_AVAILABLE, (Number)1);
            return;
        }
        try {
            Method getAdmissionController = this.jettyAdmissionControllerServiceClass.getDeclaredMethod("getAdmissionController", String.class);
            Object globalJVMMP = getAdmissionController.invoke(null, GLOBAL_JVMMP);
            Object requestSize = getAdmissionController.invoke(null, REQUEST_SIZE);
            if (Objects.isNull(globalJVMMP) && Objects.isNull(requestSize)) {
                return;
            }
            this.value.setLength(0);
            Method getUsedQuota = this.admissionControllerClass.getDeclaredMethod("getUsedQuota", new Class[0]);
            Method getTotalQuota = this.admissionControllerClass.getDeclaredMethod("getTotalQuota", new Class[0]);
            Method getRejectionCount = this.admissionControllerClass.getDeclaredMethod("getRejectionCount", new Class[0]);
            if (!Objects.isNull(globalJVMMP)) {
                this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(new AdmissionControlMetrics(GLOBAL_JVMMP, (Long)getUsedQuota.invoke(globalJVMMP, new Object[0]), (Long)getTotalQuota.invoke(globalJVMMP, new Object[0]), (Long)getRejectionCount.invoke(globalJVMMP, new Object[0])).serialize());
            }
            if (!Objects.isNull(requestSize)) {
                this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(new AdmissionControlMetrics(REQUEST_SIZE, (Long)getUsedQuota.invoke(requestSize, new Object[0]), (Long)getTotalQuota.invoke(requestSize, new Object[0]), (Long)getRejectionCount.invoke(requestSize, new Object[0])).serialize());
            }
            this.saveMetricValues(this.value.toString(), startTime, new String[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((AdmissionControlMetricsCollector)this).getCollectorName();
            supplierArray[1] = ex::getMessage;
            LOG.debug("[ {} ] Exception in collecting AdmissionControl Metrics: {}", supplierArray);
            StatsCollector.instance().logException(StatExceptionCode.ADMISSION_CONTROL_COLLECTOR_ERROR);
        }
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"admission_control_metrics"});
    }

    private boolean canLoadAdmissionControllerClasses() {
        try {
            ClassLoader admissionControlClassLoader = ((Object)((Object)this)).getClass().getClassLoader().getParent();
            this.admissionControllerClass = Class.forName(ADMISSION_CONTROLLER, false, admissionControlClassLoader);
            this.jettyAdmissionControllerServiceClass = Class.forName(ADMISSION_CONTROL_SERVICE, false, admissionControlClassLoader);
        }
        catch (Exception e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::toString;
            LOG.debug("Failed to load AdmissionControllerService classes : {}", supplierArray);
            StatsCollector.instance().logException(StatExceptionCode.ADMISSION_CONTROL_COLLECTOR_ERROR);
            return false;
        }
        return true;
    }

    static class AdmissionControlMetrics
    extends MetricStatus {
        private String controllerName;
        private long current;
        private long threshold;
        private long rejectionCount;

        public AdmissionControlMetrics() {
        }

        public AdmissionControlMetrics(String controllerName, long current, long threshold, long rejectionCount) {
            this.controllerName = controllerName;
            this.current = current;
            this.threshold = threshold;
            this.rejectionCount = rejectionCount;
        }

        @JsonProperty(value="ControllerName")
        public String getControllerName() {
            return this.controllerName;
        }

        @JsonProperty(value="AdmissionControl_CurrentValue")
        public long getCurrent() {
            return this.current;
        }

        @JsonProperty(value="AdmissionControl_ThresholdValue")
        public long getThreshold() {
            return this.threshold;
        }

        @JsonProperty(value="AdmissionControl_RejectionCount")
        public long getRejectionCount() {
            return this.rejectionCount;
        }
    }
}

