/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.w3c.dom.Attr;

public class SubjectConfirmationDataUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    @Override
    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        SubjectConfirmationData subjectCD = (SubjectConfirmationData)parentObject;
        subjectCD.getUnknownXMLObjects().add(childObject);
    }

    @Override
    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        SubjectConfirmationData subjectCD = (SubjectConfirmationData)xmlObject;
        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals("NotBefore") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                subjectCD.setNotBefore(DOMTypeSupport.stringToInstant(attribute.getValue()));
            } else if (attribute.getLocalName().equals("NotOnOrAfter") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                subjectCD.setNotOnOrAfter(DOMTypeSupport.stringToInstant(attribute.getValue()));
            } else if (attribute.getLocalName().equals("Recipient")) {
                subjectCD.setRecipient(attribute.getValue());
            } else if (attribute.getLocalName().equals("InResponseTo")) {
                subjectCD.setInResponseTo(attribute.getValue());
            } else if (attribute.getLocalName().equals("Address")) {
                subjectCD.setAddress(attribute.getValue());
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        } else {
            this.processUnknownAttribute(subjectCD, attribute);
        }
    }
}

