/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.enterProcessors;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.SmartEnterUtil;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.enterProcessors.EnterProcessor;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStatementPart;
import org.jetbrains.annotations.Nullable;

public class PyPlainEnterProcessor
implements EnterProcessor {
    @Nullable
    private static PyStatementList getStatementList(PsiElement psiElement, Editor editor2) {
        if (psiElement instanceof PyStatementListContainer) {
            return ((PyStatementListContainer)psiElement).getStatementList();
        }
        CaretModel caretModel = editor2.getCaretModel();
        PsiElement atCaret = psiElement.getContainingFile().findElementAt(caretModel.getOffset());
        PyStatementPart statementPart = (PyStatementPart)PsiTreeUtil.getParentOfType((PsiElement)atCaret, PyStatementPart.class);
        if (statementPart != null) {
            return statementPart.getStatementList();
        }
        return null;
    }

    @Override
    public boolean doEnter(Editor editor2, PsiElement psiElement, boolean isModified) {
        PyStatementList statementList = PyPlainEnterProcessor.getStatementList(psiElement, editor2);
        if (statementList != null && statementList.getStatements().length == 0) {
            SmartEnterUtil.plainEnter(editor2);
            return true;
        }
        return false;
    }
}

