define(["exports","./apiclient.js","./../localdatabase/localassetmanager.js","./../common/servicelocator.js"],function(_exports,_apiclient,_localassetmanager,_servicelocator){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var localPrefix="local:";function isLocalId(str){return(str=str&&Array.isArray(str)?str[0]:str)&&str.startsWith("local")}function mapToId(i){return i.Id}function stripLocalPrefix(str){str=stripStart(str,localPrefix);return stripStart(str,"localview:")}function stripStart(str,find){return str&&find&&str.startsWith(find)?str.substr(find.length):str}function convertIdToLocal(guid){return guid?isLocalId(guid)?guid:localPrefix+guid:null}function syncNow(){require(["localsync"],function(localSync){localSync.sync()})}function getLocalUrl(_ref){var _ref=_ref.MediaSources;return _ref&&_ref.length?(_ref=_ref[0]).StreamUrl||_ref.Path:""}function getMusicFolders(serverId){var list=[];return list.push({Name:"Albums",ServerId:serverId,Id:"localview:MusicAlbumsView",Type:"MusicAlbumsView",IsFolder:!0}),list.push({Name:"Songs",ServerId:serverId,Id:"localview:MusicSongsView",Type:"MusicSongsView",IsFolder:!0}),list}function getTopLevelViews(serverId,types,forceIncludeAll){var list=[];return(types.includes("Audio")||forceIncludeAll)&&list.push({Name:"Music",ServerId:serverId,Id:"localview:MusicView",Type:"MusicView",CollectionType:"music",IsFolder:!0}),(types.includes("Photo")||forceIncludeAll)&&list.push({Name:"Photos",ServerId:serverId,Id:"localview:PhotosView",Type:"PhotosView",CollectionType:"photos",IsFolder:!0}),(types.includes("Episode")||forceIncludeAll)&&list.push({Name:"TV",ServerId:serverId,Id:"localview:TVView",Type:"TVView",CollectionType:"tvshows",IsFolder:!0}),(types.includes("Movie")||forceIncludeAll)&&list.push({Name:"Movies",ServerId:serverId,Id:"localview:MoviesView",Type:"MoviesView",CollectionType:"movies",IsFolder:!0}),(types.includes("Video")||forceIncludeAll)&&list.push({Name:"Videos",ServerId:serverId,Id:"localview:VideosView",Type:"VideosView",IsFolder:!0}),(types.includes("MusicVideo")||forceIncludeAll)&&list.push({Name:"Music Videos",ServerId:serverId,Id:"localview:MusicVideosView",Type:"MusicVideosView",CollectionType:"musicvideos",IsFolder:!0}),(types.includes("Trailer")||forceIncludeAll)&&list.push({Name:"Trailers",ServerId:serverId,Id:"localview:TrailersView",Type:"TrailersView",IsFolder:!0}),(types.includes("Book")||forceIncludeAll)&&list.push({Name:"Books",ServerId:serverId,Id:"localview:BooksView",Type:"BooksView",IsFolder:!0}),(types.includes("Game")||forceIncludeAll)&&list.push({Name:"Games",ServerId:serverId,Id:"localview:GamesView",Type:"GamesView",IsFolder:!0}),list}function getDownloadedItems(serverId,options){var items,searchParentId=options.ParentId;switch((searchParentId=searchParentId)?(searchParentId=stripStart(searchParentId,"localview:"),stripStart(searchParentId,"local:")):null){case"MusicView":if(options.Recursive)break;return Promise.resolve({Items:items=getMusicFolders(serverId),TotalRecordCount:items.length})}return _servicelocator.itemRepository.getLibraryItems(serverId,options)}function adjustIdProperties(downloadedItem){downloadedItem.Id=convertIdToLocal(downloadedItem.Id),downloadedItem.SeriesId=convertIdToLocal(downloadedItem.SeriesId),downloadedItem.SeasonId=convertIdToLocal(downloadedItem.SeasonId),downloadedItem.AlbumId=convertIdToLocal(downloadedItem.AlbumId),downloadedItem.ParentId=convertIdToLocal(downloadedItem.ParentId),downloadedItem.ParentThumbItemId=convertIdToLocal(downloadedItem.ParentThumbItemId),downloadedItem.ParentPrimaryImageItemId=convertIdToLocal(downloadedItem.ParentPrimaryImageItemId),downloadedItem.PrimaryImageItemId=convertIdToLocal(downloadedItem.PrimaryImageItemId),downloadedItem.ParentLogoItemId=convertIdToLocal(downloadedItem.ParentLogoItemId),downloadedItem.ParentBackdropItemId=convertIdToLocal(downloadedItem.ParentBackdropItemId),downloadedItem.ParentBackdropImageTags=null}var min,max,PlaySessionIdPrefix=Date.now()+"_"+(min=1,max=1e5,min=Math.ceil(min),max=Math.floor(max),Math.floor(Math.random()*(max-min)+min));function nextPlaySessionId(){return PlaySessionIdPrefix+"_"+Date.now()}function ApiClientEx(serverAddress,appName,appVersion,deviceName,deviceId,devicePixelRatio){_apiclient.default.apply(this,arguments)}Object.assign(ApiClientEx.prototype,_apiclient.default.prototype),ApiClientEx.prototype.getPlaybackInfo=function(itemId,options,deviceProfile,signal){var promises=[];return isLocalId(itemId)||isLocalId(null==options?void 0:options.MediaSourceId)?promises.push(Promise.resolve({MediaSources:[],PlaySessionId:nextPlaySessionId()})):promises.push(_apiclient.default.prototype.getPlaybackInfo.apply(this,arguments)),options&&options.MediaSourceId&&!isLocalId(options.MediaSourceId)?promises.push(Promise.resolve({MediaSources:[],PlaySessionId:nextPlaySessionId()})):promises.push(_servicelocator.itemRepository.getLibraryItem(this.serverId(),stripLocalPrefix(itemId)).then(function(item){return!item||item.SyncStatus&&"synced"!==item.SyncStatus?{MediaSources:[],PlaySessionId:nextPlaySessionId()}:{MediaSources:item.Item.MediaSources.map(function(m){return null!=options.AudioStreamIndex&&(m.DefaultAudioStreamIndex=parseInt(options.AudioStreamIndex)),null!=options.SubtitleStreamIndex&&(m.DefaultSubtitleStreamIndex=parseInt(options.SubtitleStreamIndex)),m.SupportsDirectPlay=!0,m.SupportsDirectStream=!1,m.SupportsTranscoding=!1,m.IsLocal=!0,m.Name="Downloaded version",m.Id=localPrefix+item.Item.Id,m}),PlaySessionId:nextPlaySessionId()}})),Promise.all(promises).then(function(results){var result=results[0],localResult=results[1];localResult.MediaSources.length&&(result.ErrorCode=null);for(var i=0,length=localResult.MediaSources.length;i<length;i++)result.MediaSources.unshift(localResult.MediaSources[i]);return result})},ApiClientEx.prototype.getAudioStreamUrl=function(item,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia){var mediaSource;if(isLocalId(item.Id)&&(item.MediaSources&&item.MediaSources.length))return(mediaSource=item.MediaSources[0]).StreamUrl||mediaSource.Path;return _apiclient.default.prototype.getAudioStreamUrl.apply(this,arguments)},ApiClientEx.prototype.getAudioStreamUrls=function(items,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia){var instance,ids;return items.length?isLocalId(items[0].Id)?Promise.resolve(items.map(getLocalUrl)):(instance=this,ids=items.map(function(_ref2){return _ref2.Id}),_servicelocator.itemRepository.getLibraryItemPathsByIds(items[0].ServerId,ids).then(function(localItems){var localItemMap={},localUrls=localItems.map(function(libraryItem){return(localItemMap[libraryItem.ItemId]=libraryItem).LocalPath});if(localUrls.length===items.length)return localUrls;if(localItems.length){for(var streamUrls=[],i=0;i<items.length;i++){var item=items[i],streamUrl=void 0;streamUrl=localItemMap[item.Id]?localItemMap[item.Id].LocalPath:_apiclient.default.prototype.getAudioStreamUrl.call(instance,item,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia),streamUrls.push(streamUrl||"")}return streamUrls}return _apiclient.default.prototype.getAudioStreamUrls.call(instance,items,transcodingProfile,directPlayContainers,maxBitrate,maxAudioSampleRate,maxAudioBitDepth,startPosition,enableRemoteMedia)})):Promise.resolve([])},ApiClientEx.prototype.getItems=function(userId,options){if(isLocalId(options.ListItemIds))return Promise.resolve({Items:[],TotalRecordCount:0});var serverInfo=this.serverInfo();if(serverInfo&&"localview"===options.ParentId)return this.getLocalFolders(serverInfo.Id,userId).then(function(items){items={Items:items,TotalRecordCount:items.length};return Promise.resolve(items)});if(serverInfo&&options&&(isLocalId(options.ParentId)||isLocalId(options.SeriesId)||isLocalId(options.SeasonId)||isLocalId(options.AlbumIds)))return getDownloadedItems(serverInfo.Id,options).then(function(result){return result.Items.forEach(function(item){adjustIdProperties(item)}),Promise.resolve(result)});if(options&&options.ExcludeItemIds&&options.ExcludeItemIds.length){for(var exItems=Array.isArray(options.ExcludeItemIds)?options.ExcludeItemIds:options.ExcludeItemIds.split(","),i=0;i<exItems.length;i++)if(isLocalId(exItems[i]))return Promise.resolve({Items:[],TotalRecordCount:0})}else if(options&&options.Ids&&options.Ids.length){for(var localIds,ids=Array.isArray(options.Ids)?options.Ids:options.Ids.split(","),hasLocal=!1,_i=0;_i<ids.length;_i++)if(isLocalId(ids[_i])){hasLocal=!0;break}if(hasLocal)return localIds=ids.map(stripLocalPrefix),_servicelocator.itemRepository.getLibraryItemsByIds(serverInfo.Id,localIds).then(function(items){items.forEach(function(_ref3){adjustIdProperties(_ref3.Item)});items=items.map(function(_ref4){return _ref4.Item}),items={Items:items,TotalRecordCount:items.length};return Promise.resolve(items)})}return _apiclient.default.prototype.getItems.apply(this,arguments)},ApiClientEx.prototype.getItem=function(userId,itemId,options){var serverInfo,list,str;if(itemId)return"localview"===(itemId=itemId&&itemId.toString())&&(serverInfo=this.serverInfo())?function(instance,serverId,userId){return instance.getLocalFolders(serverId,userId).then(function(views){var localView=null;return 0<views.length&&(localView={Name:instance.downloadsTitleText||"Downloads",ServerId:serverId,Id:"localview",Type:"localview",IsFolder:!0}),Promise.resolve(localView)})}(this,serverInfo.Id,userId):(str=itemId)&&str.startsWith("localview:")&&(serverInfo=this.serverInfo())?(str=serverInfo.Id,list=(list=getTopLevelViews(str,[],!0)).concat(getMusicFolders(str)),Promise.resolve(list).then(function(items){items=items.filter(function(_ref5){return _ref5.Id===itemId});return 0<items.length?Promise.resolve(items[0]):Promise.reject()})):isLocalId(itemId)?(serverInfo=this.serverInfo())?_servicelocator.itemRepository.getLibraryItem(serverInfo.Id,stripLocalPrefix(itemId)).then(function(item){return item?(adjustIdProperties(item.Item),Promise.resolve(item.Item)):Promise.reject()}):Promise.reject():_apiclient.default.prototype.getItem.apply(this,arguments);throw new Error("null itemId")},ApiClientEx.prototype.getLocalFolders=function(userId){var serverId,serverInfo=this.serverInfo();return userId=userId||serverInfo.UserId,serverId=serverInfo.Id,_servicelocator.itemRepository.getLibarytemTypes(serverId).then(function(types){return getTopLevelViews(serverId,types)}).catch(function(){return[]})},ApiClientEx.prototype.getSeasons=function(itemId,options){return isLocalId(itemId)?(options.SeriesId=itemId,options.IncludeItemTypes="Season",options.Recursive?options.SortBy="ParentIndexNumber,IndexNumber":options.SortBy="IndexNumber",this.getItems(this.getCurrentUserId(),options)):_apiclient.default.prototype.getSeasons.apply(this,arguments)},ApiClientEx.prototype.getEpisodes=function(itemId,options){return isLocalId(options.SeasonId)||isLocalId(options.seasonId)||isLocalId(itemId)?(options.SeriesId=itemId,options.IncludeItemTypes="Episode",options.SortBy="ParentIndexNumber,IndexNumber,SortName",this.getItems(this.getCurrentUserId(),options)):_apiclient.default.prototype.getEpisodes.apply(this,arguments)},ApiClientEx.prototype.getLatestOfflineItems=function(options){options.SortBy="DateCreated",options.SortOrder="Descending",options.EnableTotalRecordCount=!1;var serverInfo=this.serverInfo();return serverInfo?_servicelocator.itemRepository.getLibraryItems(serverInfo.Id,options).then(function(_ref6){_ref6=_ref6.Items;return _ref6.forEach(function(item){adjustIdProperties(item)}),Promise.resolve(_ref6)}):Promise.resolve([])},ApiClientEx.prototype.getImageUrl=function(itemId,options){var id;return isLocalId(itemId)||options&&options.itemid&&isLocalId(options.itemid)?(id=stripLocalPrefix(itemId),_localassetmanager.default.getImageUrl(this.serverId(),id,options)):_apiclient.default.prototype.getImageUrl.apply(this,arguments)},ApiClientEx.prototype.updateFavoriteStatus=function(userId,itemIds,isFavorite){return _apiclient.default.prototype.updateFavoriteStatus.apply(this,arguments).then(function(response){var serverInfo,promises;return 0<(itemIds=itemIds.filter(isLocalId)).length&&(serverInfo=this.serverInfo())&&(promises=itemIds.map(function(itemId){return function(serverId,itemId,isFavorite){return _servicelocator.itemRepository.getLibraryItem(serverId,stripLocalPrefix(itemId)).then(function(item){var libraryItem=item.Item;return libraryItem.UserData=libraryItem.UserData||{},libraryItem.UserData.IsFavorite=isFavorite,_servicelocator.itemRepository.updateLibraryItem(item.ServerId,item.Id,item).then(function(){return Promise.resolve()})})}(serverInfo.Id,itemId,isFavorite)}),promises=Promise.all(promises)),(promises||Promise.resolve()).then(function(){return response})})},ApiClientEx.prototype.markPlayed=function(userId,itemIds,date){return _apiclient.default.prototype.markPlayed.apply(this,arguments).then(function(response){var serverInfo,promises;return 0<(itemIds=itemIds.filter(isLocalId)).length&&(serverInfo=this.serverInfo())&&(promises=itemIds.map(function(itemId){return function(serverId,itemId){return _servicelocator.itemRepository.getLibraryItem(serverId,stripLocalPrefix(itemId)).then(function(item){var libraryItem=item.Item;return libraryItem.UserData=libraryItem.UserData||{},libraryItem.UserData.Played=!0,_servicelocator.itemRepository.updateLibraryItem(item.ServerId,item.Id,item).then(function(){return Promise.resolve()})})}(serverInfo.Id,itemId)}),promises=Promise.all(promises)),(promises||Promise.resolve()).then(function(){return response})})},ApiClientEx.prototype.markUnplayed=function(userId,itemIds){return _apiclient.default.prototype.markUnplayed.apply(this,arguments).then(function(response){var serverInfo,promises;return 0<(itemIds=itemIds.filter(isLocalId)).length&&(serverInfo=this.serverInfo())&&(promises=itemIds.map(function(itemId){return function(serverId,itemId){return _servicelocator.itemRepository.getLibraryItem(serverId,stripLocalPrefix(itemId)).then(function(item){var libraryItem=item.Item;return libraryItem.UserData=libraryItem.UserData||{},libraryItem.UserData.Played=!1,_servicelocator.itemRepository.updateLibraryItem(item.ServerId,item.Id,item).then(function(){return Promise.resolve()})})}(serverInfo.Id,itemId)}),promises=Promise.all(promises)),(promises||Promise.resolve()).then(function(){return response})})},ApiClientEx.prototype.reportPlaybackProgress=function(options){var localPromise,localId,serverInfo;if(options)return(localId=isLocalId(options.ItemId)?options.ItemId:isLocalId(options.MediaSourceId)?options.MediaSourceId:null)&&(serverInfo=this.serverInfo())&&(localPromise=_servicelocator.itemRepository.getLibraryItem(serverInfo.Id,stripLocalPrefix(localId)).then(function(item){var libraryItem;return item?"Video"===(libraryItem=item.Item).MediaType?(libraryItem.UserData=libraryItem.UserData||{},libraryItem.UserData.PlaybackPositionTicks=options.PositionTicks,libraryItem.UserData.PlayedPercentage=Math.min(libraryItem.RunTimeTicks?(options.PositionTicks||0)/libraryItem.RunTimeTicks*100:0,100),libraryItem.UserData.PlaybackPositionTicks&&libraryItem.RunTimeTicks&&libraryItem.UserData.PlaybackPositionTicks>=.9*libraryItem.RunTimeTicks&&(libraryItem.UserData.Played=!0,libraryItem.UserData.PlaybackPositionTicks=0,libraryItem.UserData.PlayedPercentage=0),_servicelocator.itemRepository.updateLibraryItem(item.ServerId,item.Id,item)):void 0:(console.log("item not found in local database: "+stripLocalPrefix(localId)),Promise.resolve())})),serverInfo=isLocalId(options.ItemId)?Promise.resolve():_apiclient.default.prototype.reportPlaybackProgress.apply(this,arguments),Promise.all([localPromise||Promise.resolve(),serverInfo]);throw new Error("null options")},ApiClientEx.prototype.reportPlaybackStopped=function(options){var localId,serverInfo,instance,localPromise,serverPromise;if(options)return(localId=isLocalId(options.ItemId)?options.ItemId:isLocalId(options.MediaSourceId)?options.MediaSourceId:null)&&(serverInfo=this.serverInfo())&&(instance=this,localPromise=_servicelocator.itemRepository.getLibraryItem(serverInfo.Id,stripLocalPrefix(localId)).then(function(item){var libraryItem;return item?"Video"===(libraryItem=item.Item).MediaType?(libraryItem.UserData=libraryItem.UserData||{},libraryItem.UserData.PlaybackPositionTicks=options.PositionTicks,libraryItem.UserData.PlayedPercentage=Math.min(libraryItem.RunTimeTicks?(options.PositionTicks||0)/libraryItem.RunTimeTicks*100:0,100),libraryItem.UserData.PlaybackPositionTicks&&libraryItem.RunTimeTicks&&libraryItem.UserData.PlaybackPositionTicks>=.9*libraryItem.RunTimeTicks&&(libraryItem.UserData.Played=!0,libraryItem.UserData.PlaybackPositionTicks=0,libraryItem.UserData.PlayedPercentage=0),_servicelocator.itemRepository.updateLibraryItem(item.ServerId,item.Id,item).then(function(){var action,d;return isLocalId(options.ItemId)?(action={Date:(new Date).toISOString(),ItemId:stripLocalPrefix(localId),PositionTicks:options.PositionTicks,ServerId:serverInfo.Id,Type:"PlayedItem",UserId:instance.getCurrentUserId(),Id:(d=Date.now(),window.performance&&"function"==typeof window.performance.now&&(d+=performance.now()),"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(c){var r=(d+16*Math.random())%16|0;return d=Math.floor(d/16),("x"===c?r:3&r|8).toString(16)}))},_servicelocator.userActionRepository.addUserAction(action.Id,action)):Promise.resolve()})):void 0:(console.log("item not found in local database: "+stripLocalPrefix(localId)),Promise.resolve())})),serverPromise=isLocalId(options.ItemId)?Promise.resolve():_apiclient.default.prototype.reportPlaybackStopped.apply(this,arguments),Promise.all([localPromise||Promise.resolve(),serverPromise]);throw new Error("null options")},ApiClientEx.prototype.getItemDownloadUrl=function(itemId,mediaSourceId){var serverInfo,localId=isLocalId(itemId)?itemId:isLocalId(mediaSourceId)?mediaSourceId:null;return localId?(serverInfo=this.serverInfo())?_servicelocator.itemRepository.getLibraryItem(serverInfo.Id,stripLocalPrefix(localId)).then(function(_ref7){_ref7=_ref7.LocalPath;return Promise.resolve(_ref7)}):Promise.reject():_apiclient.default.prototype.getItemDownloadUrl.apply(this,arguments)},ApiClientEx.prototype.getItemOriginalFileUrl=function(itemId,mediaSourceId){var serverInfo,localId=isLocalId(itemId)?itemId:isLocalId(mediaSourceId)?mediaSourceId:null;return localId?(serverInfo=this.serverInfo())?_servicelocator.itemRepository.getLibraryItem(serverInfo.Id,stripLocalPrefix(localId)).then(function(_ref8){_ref8=_ref8.LocalPath;return Promise.resolve(_ref8)}):Promise.reject():_apiclient.default.prototype.getItemOriginalFileUrl.apply(this,arguments)},ApiClientEx.prototype.deleteItemsInternal=function(items){var itemIds,instance;if(items)return itemIds=items.map(mapToId).filter(isLocalId),_apiclient.default.prototype.deleteItemsInternal.apply(instance=this,arguments).then(function(){return Promise.all(itemIds.map(function(itemId){return _servicelocator.itemRepository.getLibraryItem(instance.serverId(),stripLocalPrefix(itemId)).then(function(item){return item?_localassetmanager.default.removeLocalItem(item).then(syncNow):Promise.resolve()})}))});throw new Error("null itemId")};_exports.default=ApiClientEx});