/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.MUIFactory;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

public class FontSizeControlGroup
implements ControlGroup {
    static final String NODE_FONT_SIZE = "nodefontsize";
    private RevertingProperty mSetNodeFontSize;
    private ComboProperty mNodeFontSize;
    private FontSizeChangeListener propertyChangeListener;

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetNodeFontSize = new RevertingProperty();
        ArrayList<String> sizesVector = new ArrayList<String>(Arrays.asList(MUIFactory.FONT_SIZES));
        this.mNodeFontSize = new ComboProperty(NODE_FONT_SIZE, sizesVector, sizesVector);
        this.mNodeFontSize.setEditable(true);
        this.propertyChangeListener = new FontSizeChangeListener(this.mSetNodeFontSize, (IPropertyControl)this.mNodeFontSize);
        this.mSetNodeFontSize.addPropertyChangeListener(this.propertyChangeListener);
        this.mNodeFontSize.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mNodeFontSize.appendToForm(formBuilder);
        this.mSetNodeFontSize.appendToForm(formBuilder);
    }

    private class FontSizeChangeListener
    extends ControlGroupChangeListener {
        public FontSizeChangeListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            try {
                styleController.setFontSize(node, enabled ? Integer.valueOf(FontSizeControlGroup.this.mNodeFontSize.getValue()) : null);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeStyleController styleController = NodeStyleController.getController();
            Integer fontSize = NodeStyleModel.getFontSize((NodeModel)node);
            Integer viewfontSize = styleController.getFontSize(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            FontSizeControlGroup.this.mSetNodeFontSize.setValue(fontSize != null);
            FontSizeControlGroup.this.mNodeFontSize.setValue(viewfontSize.toString());
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)FontSizeControlGroup.this.mSetNodeFontSize);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)FontSizeControlGroup.this.mNodeFontSize);
        }
    }
}

