# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: objectpool.proto for package 'gitaly'

require 'grpc'
require 'objectpool_pb'

module Gitaly
  module ObjectPoolService
    # ObjectPoolService is a service that manages the lifetime of object pools.
    #
    # An object pool is a separate repository that can be linked to from multiple object pool members
    # in order to deduplicate common objects between them. This is mostly used in the context of
    # repository forks.
    #
    # The typical lifetime of an object pool is as follows:
    #
    # 1. An object pool is created via CreateObjectPool from its primary pool member. Typically this
    #    would be the repository that gets forked.
    # 2. One or more repositories are linked to the object pool via LinkRepositoryToObjectPool. Each
    #    object pool member linked to the repository will have its objects deduplicated when its
    #    objects get repacked the next time.
    # 3. The object pool is regularly updated via FetchIntoObjectPool. This is typically only done from
    #    the primary object pool member.
    # 4. Repositories may leave the object pool via DisconnectGitAlternates. There is not much of a
    #    reason to do this for any repositories except for the primary object pool member in case it
    #    for example becomes private.
    # 5. When the object pool does not have any members anymore it gets deleted via DeleteObjectPool.
    #    It is the responsibility of the caller to ensure that it really has no members left, else
    #    any existing member will become corrupt.
    class Service

      include ::GRPC::GenericService

      self.marshal_class_method = :encode
      self.unmarshal_class_method = :decode
      self.service_name = 'gitaly.ObjectPoolService'

      # CreateObjectPool creates an object pool from a specific source repository. It will create the
      # object pool by cloning all contents from that source repository. The source repository will not
      # automatically be linked to the object pool, you need to call LinkRepositoryToObjectPool for
      # this. If the object pool exists already this RPC returns an error with the FailedPrecondition
      # gRPC error code.
      rpc :CreateObjectPool, ::Gitaly::CreateObjectPoolRequest, ::Gitaly::CreateObjectPoolResponse
      # DeleteObjectPool deletes the object pool. There are no safety checks in place, so if any
      # repository is still using this object pool it will become corrupted.
      rpc :DeleteObjectPool, ::Gitaly::DeleteObjectPoolRequest, ::Gitaly::DeleteObjectPoolResponse
      # LinkRepositoryToObjectPool links the specified repository to the object pool. Objects contained
      # in the object pool will be deduplicated for this repository when repacking objects.
      rpc :LinkRepositoryToObjectPool, ::Gitaly::LinkRepositoryToObjectPoolRequest, ::Gitaly::LinkRepositoryToObjectPoolResponse
      # DisconnectGitAlternates will disconnect the object pool member from its object pool. It will:
      #
      # 1. Link all objects from the object pool into the member repository. This essenitally
      #    reduplicates previously-duplicated objects so that the repository will continue to function
      #    after being unlinked.
      # 2. Remove the alternates link to the object pool.
      # 3. Perform a consistency check to assert that the repository is indeed fully functional after
      #    unlinking it from its pool. If the consistency check fails the alternates link is restored
      #    an the RPC fails.
      #
      # If successful, the object pool member is disconnected from the object pool and does not depend
      # on it anymore.
      #
      # This RPC does not return an error in case the repository is not linked to any object pool.
      rpc :DisconnectGitAlternates, ::Gitaly::DisconnectGitAlternatesRequest, ::Gitaly::DisconnectGitAlternatesResponse
      # FetchIntoObjectPool fetches all references from a pool member into an object pool so that
      # objects shared between this repository and other pool members can be deduplicated. This RPC
      # will perform housekeeping tasks after the object pool has been updated to ensure that the pool
      # is in an optimal state.
      rpc :FetchIntoObjectPool, ::Gitaly::FetchIntoObjectPoolRequest, ::Gitaly::FetchIntoObjectPoolResponse
      # GetObjectPool returns the object pool a repository is connected to. If the repository is not
      # connected to a pool then this RPC returns successfully with an empty response.
      rpc :GetObjectPool, ::Gitaly::GetObjectPoolRequest, ::Gitaly::GetObjectPoolResponse
    end

    Stub = Service.rpc_stub_class
  end
end
