/*
 * Decompiled with CFR 0.152.
 */
package training.onboarding;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.wizard.OnboardingTipsInstallationInfo;
import com.intellij.internal.statistic.local.ActionExtendedSummary;
import com.intellij.internal.statistic.local.ActionsLocalSummary;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GotItTooltip;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.learn.LearnBundle;
import training.onboarding.NewProjectOnboardingTipsImplKt;
import training.onboarding.OnboardingTipsStatistics;
import training.ui.LearningUiUtil;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002\u001a\u001d\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\t2\u000b\u0010 \u001a\u00070\u0007\u00a2\u0006\u0002\b!H\u0002\u001a\u001d\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\t2\u000b\u0010 \u001a\u00070\u0007\u00a2\u0006\u0002\b!H\u0002\"$\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u00018B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0003\u0010\u0004\"\u0004\b\u0005\u0010\u0006\",\u0010\b\u001a\u0004\u0018\u00010\u0007*\u00020\t2\b\u0010\u0000\u001a\u0004\u0018\u00010\u00078G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\"\u0011\u0010\u000e\u001a\u00020\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"value", "", "onboardingGenerationNumber", "getOnboardingGenerationNumber", "()I", "setOnboardingGenerationNumber", "(I)V", "", "filePathWithOnboardingTips", "Lcom/intellij/openapi/project/Project;", "getFilePathWithOnboardingTips", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/String;", "setFilePathWithOnboardingTips", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "renderedOnboardingTipsEnabled", "", "getRenderedOnboardingTipsEnabled", "()Z", "promotedActions", "", "getPromotedActions", "()Ljava/util/List;", "onboardingTipsInstallationInfoKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ide/wizard/OnboardingTipsInstallationInfo;", "installTipsInFirstEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "info", "installActionListener", "pathToRunningFile", "Lorg/jetbrains/annotations/NonNls;", "installDebugListener", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nNewProjectOnboardingTipsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewProjectOnboardingTipsImpl.kt\ntraining/onboarding/NewProjectOnboardingTipsImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1285#2,2:188\n1299#2,4:190\n*S KotlinDebug\n*F\n+ 1 NewProjectOnboardingTipsImpl.kt\ntraining/onboarding/NewProjectOnboardingTipsImplKt\n*L\n129#1:188,2\n129#1:190,4\n*E\n"})
public final class NewProjectOnboardingTipsImplKt {
    @NotNull
    private static final List<String> promotedActions;
    @NotNull
    private static final Key<OnboardingTipsInstallationInfo> onboardingTipsInstallationInfoKey;

    private static final int getOnboardingGenerationNumber() {
        return PropertiesComponent.getInstance().getInt("onboarding.generation.number", 0);
    }

    private static final void setOnboardingGenerationNumber(int value) {
        PropertiesComponent.getInstance().setValue("onboarding.generation.number", value, 0);
    }

    @ApiStatus.Internal
    @Nullable
    public static final String getFilePathWithOnboardingTips(@NotNull Project $this$filePathWithOnboardingTips) {
        Intrinsics.checkNotNullParameter((Object)$this$filePathWithOnboardingTips, (String)"<this>");
        return PropertiesComponent.getInstance((Project)$this$filePathWithOnboardingTips).getValue("onboarding.tips.debug.path");
    }

    @ApiStatus.Internal
    public static final void setFilePathWithOnboardingTips(@NotNull Project $this$filePathWithOnboardingTips, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)$this$filePathWithOnboardingTips, (String)"<this>");
        PropertiesComponent.getInstance((Project)$this$filePathWithOnboardingTips).setValue("onboarding.tips.debug.path", value);
    }

    @ApiStatus.Internal
    public static final boolean getRenderedOnboardingTipsEnabled() {
        return Registry.Companion.is("doc.onboarding.tips.render");
    }

    @NotNull
    public static final List<String> getPromotedActions() {
        return promotedActions;
    }

    private static final void installTipsInFirstEditor(Editor editor, Project project, OnboardingTipsInstallationInfo info) {
        OnboardingTipsStatistics.logOnboardingTipsInstalled(project, NewProjectOnboardingTipsImplKt.getOnboardingGenerationNumber());
        PropertiesComponent.getInstance().setValue("NewProjectWizard.generateOnboardingTips", true);
        VirtualFile virtualFile = editor.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return;
        }
        Document document2 = document;
        Function1 function1 = info.getOffsetForBreakpoint();
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        Integer offset = (Integer)function1.invoke((Object)charSequence);
        if (offset != null) {
            XSourcePosition xSourcePosition = XDebuggerUtil.getInstance().createPositionByOffset(file, offset.intValue());
            if (xSourcePosition == null) {
                return;
            }
            XSourcePosition position = xSourcePosition;
            List types = XBreakpointUtil.getAvailableLineBreakpointTypes((Project)project, (XSourcePosition)position, null);
            XDebuggerUtilImpl.toggleAndReturnLineBreakpoint((Project)project, (List)types, (XSourcePosition)position, (boolean)false, (boolean)false, null, (boolean)true);
        }
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String pathToRunningFile = string;
        NewProjectOnboardingTipsImplKt.setFilePathWithOnboardingTips(project, pathToRunningFile);
        NewProjectOnboardingTipsImplKt.installDebugListener(project, pathToRunningFile);
        NewProjectOnboardingTipsImplKt.installActionListener(project, pathToRunningFile);
        int n = NewProjectOnboardingTipsImplKt.getOnboardingGenerationNumber();
        NewProjectOnboardingTipsImplKt.setOnboardingGenerationNumber(n + 1);
    }

    private static final void installActionListener(Project project, String pathToRunningFile) {
        MessageBusConnection connection = project.getMessageBus().connect();
        Iterable $this$associateWith$iv = promotedActions;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Boolean bl2 = false;
            map.put(t, bl2);
        }
        Map actionsMapReported = MapsKt.toMutableMap((Map)result$iv);
        Topic topic = AnActionListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new AnActionListener(pathToRunningFile, actionsMapReported, project){
            final /* synthetic */ String $pathToRunningFile;
            final /* synthetic */ Map<String, Boolean> $actionsMapReported;
            final /* synthetic */ Project $project;
            {
                this.$pathToRunningFile = $pathToRunningFile;
                this.$actionsMapReported = $actionsMapReported;
                this.$project = $project;
            }

            public void afterActionPerformed(AnAction action, AnActionEvent event, AnActionResult result) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
                if (editor == null || (editor = editor.getVirtualFile()) == null) {
                    return;
                }
                Editor virtualFile = editor;
                if (!Intrinsics.areEqual((Object)virtualFile.getPath(), (Object)this.$pathToRunningFile)) {
                    return;
                }
                AnAction original = ActionUtil.getDelegateChainRootAction((AnAction)action);
                String string = ActionManager.getInstance().getId(original);
                if (string == null) {
                    return;
                }
                String actionId = string;
                Boolean bl = this.$actionsMapReported.get(actionId);
                if (bl == null) {
                    return;
                }
                boolean reported = bl;
                if (!reported) {
                    this.$actionsMapReported.put(actionId, true);
                    boolean $i$f$service = false;
                    Class<ActionsLocalSummary> serviceClass$iv = ActionsLocalSummary.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    ActionExtendedSummary actionExtendedSummary = ((ActionsLocalSummary)object).getActionStatsById(actionId);
                    if (actionExtendedSummary == null) {
                        return;
                    }
                    int usageCount = actionExtendedSummary.usageCount;
                    OnboardingTipsStatistics.logPromotedActionUsedEvent(this.$project, actionId, NewProjectOnboardingTipsImplKt.access$getOnboardingGenerationNumber(), usageCount == 1);
                }
            }
        });
    }

    private static final void installDebugListener(Project project, String pathToRunningFile) {
        MessageBusConnection connection = project.getMessageBus().connect();
        Topic topic = XDebuggerManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new XDebuggerManagerListener(pathToRunningFile, project, connection){
            final /* synthetic */ String $pathToRunningFile;
            final /* synthetic */ Project $project;
            final /* synthetic */ MessageBusConnection $connection;
            {
                this.$pathToRunningFile = $pathToRunningFile;
                this.$project = $project;
                this.$connection = $connection;
            }

            public void processStarted(XDebugProcess debugProcess) {
                String currentFilePath;
                Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                XDebugSession xDebugSession = debugProcess.getSession();
                XDebugSessionImpl xDebugSessionImpl = xDebugSession instanceof XDebugSessionImpl ? (XDebugSessionImpl)xDebugSession : null;
                XDebugSessionImpl xDebugSessionImpl2 = xDebugSessionImpl;
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = xDebugSessionImpl2 != null && (xDebugSessionImpl2 = xDebugSessionImpl2.getExecutionEnvironment()) != null ? xDebugSessionImpl2.getRunnerAndConfigurationSettings() : null;
                RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = runnerAndConfigurationSettings instanceof RunnerAndConfigurationSettingsImpl ? (RunnerAndConfigurationSettingsImpl)runnerAndConfigurationSettings : null;
                String string = currentFilePath = runnerAndConfigurationSettingsImpl != null ? runnerAndConfigurationSettingsImpl.getFilePathIfRunningCurrentFile() : null;
                if (!Intrinsics.areEqual((Object)currentFilePath, (Object)this.$pathToRunningFile)) {
                    return;
                }
                debugProcess.getSession().addSessionListener(new XDebugSessionListener(this.$project, this.$connection){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ MessageBusConnection $connection;
                    {
                        this.$project = $project;
                        this.$connection = $connection;
                    }

                    public void sessionPaused() {
                        AnAction targetAction = ActionManager.getInstance().getAction("StepInto");
                        ApplicationManager.getApplication().executeOnPooledThread(() -> installDebugListener.processStarted.1.sessionPaused$lambda$2(this.$project, targetAction, this.$connection));
                    }

                    private static final boolean sessionPaused$lambda$2$lambda$0(AnAction $targetAction, ActionButton button2) {
                        Intrinsics.checkNotNullParameter((Object)button2, (String)"button");
                        return Intrinsics.areEqual((Object)button2.getAction(), (Object)$targetAction);
                    }

                    private static final Unit sessionPaused$lambda$2$lambda$1(ActionButton $targetComponent, MessageBusConnection $connection) {
                        String stepInIcon = "<icon src=\"AllIcons.Actions.TraceInto\"/>";
                        String resumeIcon = "<icon src=\"AllIcons.Actions.Resume\"/>";
                        String stopIcon = "<icon src=\"AllIcons.Actions.Suspend\"/>";
                        Object[] objectArray = new Object[]{stepInIcon, resumeIcon, stopIcon};
                        new GotItTooltip("onboarding.tips.debug.panel.got.it", LearnBundle.INSTANCE.message("onboarding.debug.got.it.text", objectArray), null, 4, null).withHeader(LearnBundle.INSTANCE.message("onboarding.debug.got.it.header", new Object[0])).withPosition(Balloon.Position.above).show((JComponent)$targetComponent, GotItTooltip.TOP_MIDDLE);
                        $connection.disconnect();
                        return Unit.INSTANCE;
                    }

                    private static final void sessionPaused$lambda$2(Project $project, AnAction $targetAction, MessageBusConnection $connection) {
                        ActionButton targetComponent = (ActionButton)LearningUiUtil.findComponentOrNull$default(LearningUiUtil.INSTANCE, $project, ActionButton.class, null, arg_0 -> installDebugListener.processStarted.1.sessionPaused$lambda$2$lambda$0($targetAction, arg_0), 4, null);
                        if (targetComponent != null) {
                            ActionsKt.invokeLater$default(null, () -> installDebugListener.processStarted.1.sessionPaused$lambda$2$lambda$1(targetComponent, $connection), (int)1, null);
                        }
                    }
                });
            }
        });
    }

    public static final /* synthetic */ Key access$getOnboardingTipsInstallationInfoKey$p() {
        return onboardingTipsInstallationInfoKey;
    }

    public static final /* synthetic */ void access$installDebugListener(Project project, String pathToRunningFile) {
        NewProjectOnboardingTipsImplKt.installDebugListener(project, pathToRunningFile);
    }

    public static final /* synthetic */ void access$installTipsInFirstEditor(Editor editor, Project project, OnboardingTipsInstallationInfo info) {
        NewProjectOnboardingTipsImplKt.installTipsInFirstEditor(editor, project, info);
    }

    public static final /* synthetic */ int access$getOnboardingGenerationNumber() {
        return NewProjectOnboardingTipsImplKt.getOnboardingGenerationNumber();
    }

    static {
        Object[] objectArray = new String[]{"SearchEverywhere", "ShowIntentionActions", "Run", "RunClass", "Debug", "DebugClass", "ToggleLineBreakpoint"};
        promotedActions = CollectionsKt.listOf((Object[])objectArray);
        onboardingTipsInstallationInfoKey = new Key("onboardingTipsInstallationInfo");
    }
}

