/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.dependency.fest_reflect.method;

import org.assertj.swing.dependency.fest_reflect.method.Invoker;
import org.assertj.swing.dependency.fest_reflect.method.MethodParameterTypes;
import org.assertj.swing.dependency.fest_reflect.method.MethodReturnType;
import org.assertj.swing.dependency.fest_reflect.method.MethodReturnTypeRef;
import org.assertj.swing.dependency.fest_reflect.reference.TypeRef;
import org.assertj.swing.dependency.fest_util.Strings;

public final class MethodName {
    private final String name;

    public static MethodName startMethodAccess(String name) {
        MethodName.validateIsNotNullOrEmpty(name);
        return new MethodName(name);
    }

    private static void validateIsNotNullOrEmpty(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the method to access should not be null");
        }
        if (Strings.isEmpty(name)) {
            throw new IllegalArgumentException("The name of the method to access should not be empty");
        }
    }

    private MethodName(String name) {
        this.name = name;
    }

    public <T> MethodReturnType<T> withReturnType(Class<T> type) {
        return MethodReturnType.newReturnType(this.name, type);
    }

    public <T> MethodReturnTypeRef<T> withReturnType(TypeRef<T> type) {
        return MethodReturnTypeRef.newReturnTypeRef(this.name, type);
    }

    public MethodParameterTypes<Void> withParameterTypes(Class<?> ... parameterTypes) {
        return MethodParameterTypes.newParameterTypes(this.name, parameterTypes);
    }

    public Invoker<Void> in(Object target) {
        return Invoker.newInvoker(this.name, target, new Class[0]);
    }
}

