/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.settings;

import java.util.Objects;
import java.util.Set;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Name;
import jdk.jfr.Timespan;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

@MetadataDefinition
@Label(value="Threshold")
@Name(value="jdk.settings.Threshold")
@Description(value="Record event with duration above or equal to threshold")
@Timespan
public final class ThresholdSetting
extends Control {
    private static final long typeId = Type.getTypeId(ThresholdSetting.class);
    private String value = "0 ns";
    private final PlatformEventType eventType;

    public ThresholdSetting(PlatformEventType platformEventType, String string) {
        super(string);
        this.eventType = Objects.requireNonNull(platformEventType);
    }

    @Override
    public String combine(Set<String> set) {
        Long l = null;
        String string = null;
        for (String string2 : set) {
            long l2 = Utils.parseTimespanWithInfinity(string2);
            if (l == null) {
                l = l2;
                string = string2;
                continue;
            }
            if (l2 >= l) continue;
            string = string2;
            l = l2;
        }
        return string == null ? "0 ns" : string;
    }

    @Override
    public void setValue(String string) {
        long l = Utils.parseTimespanWithInfinity(string);
        this.value = string;
        this.eventType.setThreshold(l);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static boolean isType(long l) {
        return typeId == l;
    }
}

