/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveIndexedArgBase;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceivePostReqdArgInstr
extends ReceiveIndexedArgBase
implements FixedArityInstr {
    public final int preReqdArgsCount;
    public final int optArgsCount;
    public final boolean restArg;
    public final int postReqdArgsCount;

    public ReceivePostReqdArgInstr(Variable result2, Variable keywords, int argIndex, int preReqdArgsCount, int optArgCount, boolean restArg, int postReqdArgsCount) {
        super(Operation.RECV_POST_REQD_ARG, result2, keywords, argIndex);
        this.preReqdArgsCount = preReqdArgsCount;
        this.optArgsCount = optArgCount;
        this.restArg = restArg;
        this.postReqdArgsCount = postReqdArgsCount;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"index: " + this.getArgIndex(), "pre: " + this.preReqdArgsCount, "post: " + this.postReqdArgsCount};
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new ReceivePostReqdArgInstr(info.getRenamedVariable(this.result), info.getRenamedVariable(this.getKeywords()), this.argIndex, this.preReqdArgsCount, this.optArgsCount, this.restArg, this.postReqdArgsCount);
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.canMapArgsStatically()) {
            int n = ii.getArgsCount();
            int remaining = n - this.preReqdArgsCount;
            Operand argVal = remaining <= this.argIndex ? ii.getHostScope().getManager().getNil() : (remaining > this.postReqdArgsCount ? ii.getArg(n - this.postReqdArgsCount + this.argIndex) : ii.getArg(this.preReqdArgsCount + this.argIndex));
            return new CopyInstr(ii.getRenamedVariable(this.result), argVal);
        }
        return new ReqdArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), ii.getArgs(), this.argIndex, this.preReqdArgsCount, this.postReqdArgsCount);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.preReqdArgsCount);
        e.encode(this.optArgsCount);
        e.encode(this.restArg);
        e.encode(this.postReqdArgsCount);
    }

    public static ReceivePostReqdArgInstr decode(IRReaderDecoder d) {
        return new ReceivePostReqdArgInstr(d.decodeVariable(), d.decodeVariable(), d.decodeInt(), d.decodeInt(), d.decodeInt(), d.decodeBoolean(), d.decodeInt());
    }

    public IRubyObject receivePostReqdArg(ThreadContext context, IRubyObject self2, DynamicScope currDynScope, StaticScope currScope, Object[] temp, IRubyObject[] args2) {
        IRubyObject keywords = (IRubyObject)this.getKeywords().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.receivePostReqdArg(context, args2, keywords, this.preReqdArgsCount, this.optArgsCount, this.restArg, this.postReqdArgsCount, this.argIndex);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReceivePostReqdArgInstr(this);
    }
}

