/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.SharedSessionContract;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.BlobImplementer;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.internal.StreamBackedBinaryStream;
import org.hibernate.engine.jdbc.proxy.BlobProxy;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.IncomparableComparator;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class BlobJavaType
extends AbstractClassJavaType<Blob> {
    public static final BlobJavaType INSTANCE = new BlobJavaType();

    public BlobJavaType() {
        super(Blob.class, BlobMutabilityPlan.INSTANCE, IncomparableComparator.INSTANCE);
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof Blob;
    }

    @Override
    public String extractLoggableRepresentation(Blob value) {
        return value == null ? "null" : "{blob}";
    }

    @Override
    public String toString(Blob value) {
        byte[] bytes;
        try {
            bytes = DataHelper.extractBytes(value.getBinaryStream());
        }
        catch (SQLException e) {
            throw new HibernateException("Unable to access blob stream", e);
        }
        return PrimitiveByteArrayJavaType.INSTANCE.toString(bytes);
    }

    @Override
    public Blob fromString(CharSequence string) {
        return BlobProxy.generateProxy(PrimitiveByteArrayJavaType.INSTANCE.fromString(string));
    }

    @Override
    public int extractHashCode(Blob value) {
        return System.identityHashCode(value);
    }

    @Override
    public boolean areEqual(Blob one, Blob another) {
        return one == another;
    }

    @Override
    public Blob getReplacement(Blob original, Blob target, SharedSessionContractImplementor session) {
        return session.getJdbcServices().getJdbcEnvironment().getDialect().getLobMergeStrategy().mergeBlob(original, target, session);
    }

    @Override
    public <X> X unwrap(Blob value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        try {
            if (Blob.class.isAssignableFrom(type)) {
                return (X)options.getLobCreator().toJdbcBlob(value);
            }
            if (byte[].class.isAssignableFrom(type)) {
                if (value instanceof BlobImplementer) {
                    BlobImplementer blobImplementer = (BlobImplementer)((Object)value);
                    return (X)blobImplementer.getUnderlyingStream().getBytes();
                }
                try {
                    return (X)value.getBinaryStream().readAllBytes();
                }
                catch (IOException e) {
                    throw new HibernateException("IOException occurred reading a binary value", e);
                }
            }
            if (BinaryStream.class.isAssignableFrom(type)) {
                if (value instanceof BlobImplementer) {
                    BlobImplementer blobImplementer = (BlobImplementer)((Object)value);
                    return (X)blobImplementer.getUnderlyingStream();
                }
                return (X)new StreamBackedBinaryStream(value.getBinaryStream(), value.length());
            }
            if (InputStream.class.isAssignableFrom(type)) {
                if (value instanceof BlobImplementer) {
                    BlobImplementer blobImplementer = (BlobImplementer)((Object)value);
                    return (X)blobImplementer.getUnderlyingStream().getInputStream();
                }
                return (X)value.getBinaryStream();
            }
        }
        catch (SQLException e) {
            throw new HibernateException("Unable to access blob stream", e);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Blob wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        LobCreator lobCreator = options.getLobCreator();
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            return lobCreator.wrap(blob);
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return lobCreator.createBlob(bytes);
        }
        if (value instanceof BinaryStream) {
            BinaryStream binaryStream = (BinaryStream)value;
            return binaryStream.asBlob(lobCreator);
        }
        if (value instanceof InputStream) {
            InputStream inputStream = (InputStream)value;
            return lobCreator.createBlob(DataHelper.extractBytes(inputStream));
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultLobLength();
    }

    public static class BlobMutabilityPlan
    implements MutabilityPlan<Blob> {
        public static final BlobMutabilityPlan INSTANCE = new BlobMutabilityPlan();

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public Blob deepCopy(Blob value) {
            return value;
        }

        @Override
        public Serializable disassemble(Blob value, SharedSessionContract session) {
            throw new UnsupportedOperationException("Blobs are not cacheable");
        }

        @Override
        public Blob assemble(Serializable cached, SharedSessionContract session) {
            throw new UnsupportedOperationException("Blobs are not cacheable");
        }
    }
}

