/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.queue;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import java.util.concurrent.atomic.AtomicReference;

public final class MpscLinkedQueue<T>
implements SimplePlainQueue<T> {
    private final AtomicReference<LinkedQueueNode<T>> producerNode = new AtomicReference();
    private final AtomicReference<LinkedQueueNode<T>> consumerNode = new AtomicReference();

    public MpscLinkedQueue() {
        LinkedQueueNode node = new LinkedQueueNode();
        this.spConsumerNode(node);
        this.xchgProducerNode(node);
    }

    @Override
    public boolean offer(T e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        LinkedQueueNode<T> nextNode = new LinkedQueueNode<T>(e);
        LinkedQueueNode<T> prevProducerNode = this.xchgProducerNode(nextNode);
        prevProducerNode.soNext(nextNode);
        return true;
    }

    @Override
    @Nullable
    public T poll() {
        LinkedQueueNode<T> currConsumerNode = this.lpConsumerNode();
        LinkedQueueNode<T> nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            T nextValue = nextNode.getAndNullValue();
            this.spConsumerNode(nextNode);
            currConsumerNode.soNext(null);
            return nextValue;
        }
        if (currConsumerNode != this.lvProducerNode()) {
            while ((nextNode = currConsumerNode.lvNext()) == null) {
            }
            T nextValue = nextNode.getAndNullValue();
            this.spConsumerNode(nextNode);
            currConsumerNode.soNext(null);
            return nextValue;
        }
        return null;
    }

    @Override
    public boolean offer(T v1, T v2) {
        this.offer(v1);
        this.offer(v2);
        return true;
    }

    @Override
    public void clear() {
        while (this.poll() != null && !this.isEmpty()) {
        }
    }

    LinkedQueueNode<T> lvProducerNode() {
        return this.producerNode.get();
    }

    LinkedQueueNode<T> xchgProducerNode(LinkedQueueNode<T> node) {
        return this.producerNode.getAndSet(node);
    }

    LinkedQueueNode<T> lvConsumerNode() {
        return this.consumerNode.get();
    }

    LinkedQueueNode<T> lpConsumerNode() {
        return this.consumerNode.get();
    }

    void spConsumerNode(LinkedQueueNode<T> node) {
        this.consumerNode.lazySet(node);
    }

    @Override
    public boolean isEmpty() {
        return this.lvConsumerNode() == this.lvProducerNode();
    }

    static final class LinkedQueueNode<E>
    extends AtomicReference<LinkedQueueNode<E>> {
        private static final long serialVersionUID = 2404266111789071508L;
        private E value;

        LinkedQueueNode() {
        }

        LinkedQueueNode(E val) {
            this.spValue(val);
        }

        public E getAndNullValue() {
            E temp = this.lpValue();
            this.spValue(null);
            return temp;
        }

        public E lpValue() {
            return this.value;
        }

        public void spValue(E newValue) {
            this.value = newValue;
        }

        public void soNext(LinkedQueueNode<E> n) {
            this.lazySet(n);
        }

        public LinkedQueueNode<E> lvNext() {
            return (LinkedQueueNode)this.get();
        }
    }
}

