/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.internal.jta.utils.XAUtils;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.XAResourceOrphanFilter;
import java.util.List;
import javax.transaction.xa.Xid;

public class NodeNameXAResourceOrphanFilter
implements XAResourceOrphanFilter {
    public static final String RECOVER_ALL_NODES = "*";

    @Override
    public XAResourceOrphanFilter.Vote checkXid(Xid xid) {
        List<String> _xaRecoveryNodes = jtaPropertyManager.getJTAEnvironmentBean().getXaRecoveryNodes();
        if (_xaRecoveryNodes == null || _xaRecoveryNodes.isEmpty()) {
            this.doWarning();
            return XAResourceOrphanFilter.Vote.ABSTAIN;
        }
        if (_xaRecoveryNodes.contains(RECOVER_ALL_NODES)) {
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug((Object)("Ignoring node name. Will recover " + String.valueOf(xid)));
            }
            return XAResourceOrphanFilter.Vote.ROLLBACK;
        }
        String nodeName = XAUtils.getXANodeName(xid);
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug((Object)("node name of " + String.valueOf(xid) + " is " + nodeName));
        }
        if (_xaRecoveryNodes.contains(nodeName)) {
            return XAResourceOrphanFilter.Vote.ROLLBACK;
        }
        return XAResourceOrphanFilter.Vote.ABSTAIN;
    }

    private void doWarning() {
        jtaLogger.i18NLogger.info_recovery_noxanodes();
    }
}

