/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.SdkDoubleGauge;
import io.opentelemetry.sdk.metrics.SdkDoubleHistogram;
import io.opentelemetry.sdk.metrics.SdkLongCounter;
import io.opentelemetry.sdk.metrics.SdkLongUpDownCounter;
import io.opentelemetry.sdk.metrics.SdkObservableInstrument;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.MeterConfig;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.AsynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.CallbackRegistration;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorageRegistry;
import io.opentelemetry.sdk.metrics.internal.state.SdkObservableMeasurement;
import io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class SdkMeter
implements Meter {
    private static final Logger logger = Logger.getLogger(SdkMeter.class.getName());
    private static final Pattern VALID_INSTRUMENT_NAME_PATTERN = Pattern.compile("([A-Za-z]){1}([A-Za-z0-9\\_\\-\\./]){0,254}");
    private static final Meter NOOP_METER = MeterProvider.noop().get("noop");
    private static final String NOOP_INSTRUMENT_NAME = "noop";
    private final Object collectLock = new Object();
    private final Object callbackLock = new Object();
    private final List<CallbackRegistration> callbackRegistrations = new ArrayList<CallbackRegistration>();
    private final MeterProviderSharedState meterProviderSharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final Map<RegisteredReader, MetricStorageRegistry> readerStorageRegistries;
    private final boolean meterEnabled;

    SdkMeter(MeterProviderSharedState meterProviderSharedState, InstrumentationScopeInfo instrumentationScopeInfo, List<RegisteredReader> registeredReaders, MeterConfig meterConfig) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.meterProviderSharedState = meterProviderSharedState;
        this.readerStorageRegistries = registeredReaders.stream().collect(Collectors.toMap(Function.identity(), unused -> new MetricStorageRegistry()));
        this.meterEnabled = meterConfig.isEnabled();
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<MetricData> collectAll(RegisteredReader registeredReader, long epochNanos) {
        ArrayList<CallbackRegistration> currentRegisteredCallbacks;
        if (!this.meterEnabled) {
            return Collections.emptyList();
        }
        Object object = this.callbackLock;
        synchronized (object) {
            currentRegisteredCallbacks = new ArrayList<CallbackRegistration>(this.callbackRegistrations);
        }
        object = this.collectLock;
        synchronized (object) {
            for (CallbackRegistration callbackRegistration : currentRegisteredCallbacks) {
                callbackRegistration.invokeCallback(registeredReader, this.meterProviderSharedState.getStartEpochNanos(), epochNanos);
            }
            Collection<MetricStorage> storages = Objects.requireNonNull(this.readerStorageRegistries.get(registeredReader)).getStorages();
            ArrayList<MetricData> result = new ArrayList<MetricData>(storages.size());
            for (MetricStorage storage : storages) {
                MetricData current = storage.collect(this.meterProviderSharedState.getResource(), this.getInstrumentationScopeInfo(), this.meterProviderSharedState.getStartEpochNanos(), epochNanos);
                if (current.isEmpty()) continue;
                result.add(current);
            }
            return Collections.unmodifiableList(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetForTest() {
        Object object = this.collectLock;
        synchronized (object) {
            Object object2 = this.callbackLock;
            synchronized (object2) {
                this.callbackRegistrations.clear();
            }
            this.readerStorageRegistries.values().forEach(MetricStorageRegistry::resetForTest);
        }
    }

    public LongCounterBuilder counterBuilder(String name) {
        return SdkMeter.checkValidInstrumentName(name) ? new SdkLongCounter.SdkLongCounterBuilder(this, name) : NOOP_METER.counterBuilder(NOOP_INSTRUMENT_NAME);
    }

    public LongUpDownCounterBuilder upDownCounterBuilder(String name) {
        return SdkMeter.checkValidInstrumentName(name) ? new SdkLongUpDownCounter.SdkLongUpDownCounterBuilder(this, name) : NOOP_METER.upDownCounterBuilder(NOOP_INSTRUMENT_NAME);
    }

    public DoubleHistogramBuilder histogramBuilder(String name) {
        return SdkMeter.checkValidInstrumentName(name) ? new SdkDoubleHistogram.SdkDoubleHistogramBuilder(this, name) : NOOP_METER.histogramBuilder(NOOP_INSTRUMENT_NAME);
    }

    public DoubleGaugeBuilder gaugeBuilder(String name) {
        return SdkMeter.checkValidInstrumentName(name) ? new SdkDoubleGauge.SdkDoubleGaugeBuilder(this, name) : NOOP_METER.gaugeBuilder(NOOP_INSTRUMENT_NAME);
    }

    public BatchCallback batchCallback(Runnable callback, ObservableMeasurement observableMeasurement, ObservableMeasurement ... additionalMeasurements) {
        HashSet<ObservableMeasurement> measurements = new HashSet<ObservableMeasurement>();
        measurements.add(observableMeasurement);
        Collections.addAll(measurements, additionalMeasurements);
        ArrayList<SdkObservableMeasurement> sdkMeasurements = new ArrayList<SdkObservableMeasurement>();
        for (ObservableMeasurement measurement : measurements) {
            if (!(measurement instanceof SdkObservableMeasurement)) {
                logger.log(Level.WARNING, "batchCallback called with instruments that were not created by the SDK.");
                continue;
            }
            SdkObservableMeasurement sdkMeasurement = (SdkObservableMeasurement)measurement;
            if (!this.instrumentationScopeInfo.equals(sdkMeasurement.getInstrumentationScopeInfo())) {
                logger.log(Level.WARNING, "batchCallback called with instruments that belong to a different Meter.");
                continue;
            }
            sdkMeasurements.add(sdkMeasurement);
        }
        CallbackRegistration callbackRegistration = CallbackRegistration.create(sdkMeasurements, callback);
        this.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this, callbackRegistration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallback(CallbackRegistration callbackRegistration) {
        Object object = this.callbackLock;
        synchronized (object) {
            this.callbackRegistrations.remove(callbackRegistration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerCallback(CallbackRegistration callbackRegistration) {
        Object object = this.callbackLock;
        synchronized (object) {
            this.callbackRegistrations.add(callbackRegistration);
        }
    }

    boolean isMeterEnabled() {
        return this.meterEnabled;
    }

    WriteableMetricStorage registerSynchronousMetricStorage(InstrumentDescriptor instrument) {
        ArrayList<SynchronousMetricStorage> registeredStorages = new ArrayList<SynchronousMetricStorage>();
        for (Map.Entry<RegisteredReader, MetricStorageRegistry> entry : this.readerStorageRegistries.entrySet()) {
            RegisteredReader reader = entry.getKey();
            MetricStorageRegistry registry = entry.getValue();
            for (RegisteredView registeredView : reader.getViewRegistry().findViews(instrument, this.getInstrumentationScopeInfo())) {
                if (Aggregation.drop() == registeredView.getView().getAggregation()) continue;
                registeredStorages.add(registry.register(SynchronousMetricStorage.create(reader, registeredView, instrument, this.meterProviderSharedState.getExemplarFilter())));
            }
        }
        if (registeredStorages.size() == 1) {
            return (WriteableMetricStorage)registeredStorages.get(0);
        }
        return new MultiWritableMetricStorage(registeredStorages);
    }

    SdkObservableMeasurement registerObservableMeasurement(InstrumentDescriptor instrumentDescriptor) {
        ArrayList registeredStorages = new ArrayList();
        for (Map.Entry<RegisteredReader, MetricStorageRegistry> entry : this.readerStorageRegistries.entrySet()) {
            RegisteredReader reader = entry.getKey();
            MetricStorageRegistry registry = entry.getValue();
            for (RegisteredView registeredView : reader.getViewRegistry().findViews(instrumentDescriptor, this.getInstrumentationScopeInfo())) {
                if (Aggregation.drop() == registeredView.getView().getAggregation()) continue;
                registeredStorages.add(registry.register(AsynchronousMetricStorage.create(reader, registeredView, instrumentDescriptor)));
            }
        }
        return SdkObservableMeasurement.create(this.instrumentationScopeInfo, instrumentDescriptor, registeredStorages);
    }

    public String toString() {
        return "SdkMeter{instrumentationScopeInfo=" + this.instrumentationScopeInfo + "}";
    }

    static boolean checkValidInstrumentName(String name) {
        if (name != null && VALID_INSTRUMENT_NAME_PATTERN.matcher(name).matches()) {
            return true;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Instrument name \"" + name + "\" is invalid, returning noop instrument. Instrument names must consist of 255 or fewer characters including alphanumeric, _, ., -, /, and start with a letter.", (Throwable)((Object)new AssertionError()));
        }
        return false;
    }

    private static class MultiWritableMetricStorage
    implements WriteableMetricStorage {
        private final List<? extends WriteableMetricStorage> storages;

        private MultiWritableMetricStorage(List<? extends WriteableMetricStorage> storages) {
            this.storages = storages;
        }

        @Override
        public void recordLong(long value, Attributes attributes, Context context) {
            for (WriteableMetricStorage writeableMetricStorage : this.storages) {
                writeableMetricStorage.recordLong(value, attributes, context);
            }
        }

        @Override
        public void recordDouble(double value, Attributes attributes, Context context) {
            for (WriteableMetricStorage writeableMetricStorage : this.storages) {
                writeableMetricStorage.recordDouble(value, attributes, context);
            }
        }

        @Override
        public boolean isEnabled() {
            for (WriteableMetricStorage writeableMetricStorage : this.storages) {
                if (!writeableMetricStorage.isEnabled()) continue;
                return true;
            }
            return false;
        }
    }
}

