/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionKey;

@ProtoTypeId(value=65607)
@Indexed
public class RemoteAuthenticatedClientSessionEntity {
    private final String userSessionId;
    private final String clientId;
    private final String userId;
    private final String realmId;
    private int started;
    private String protocol;
    private String redirectUri;
    private String action;
    private Map<String, String> notes;
    private int timestamp;

    private RemoteAuthenticatedClientSessionEntity(String userSessionId, String clientId, String userId, String realmId) {
        this.userSessionId = Objects.requireNonNull(userSessionId);
        this.clientId = Objects.requireNonNull(clientId);
        this.userId = Objects.requireNonNull(userId);
        this.realmId = Objects.requireNonNull(realmId);
    }

    @ProtoFactory
    RemoteAuthenticatedClientSessionEntity(String clientId, String userId, String userSessionId, String realmId, Map<String, String> notes, String action, String protocol, String redirectUri, int timestamp, int started) {
        this.userSessionId = userSessionId;
        this.clientId = clientId;
        this.userId = userId;
        this.realmId = realmId;
        this.action = action;
        this.protocol = protocol;
        this.redirectUri = redirectUri;
        this.notes = notes;
        this.timestamp = timestamp;
        this.started = started;
    }

    public static RemoteAuthenticatedClientSessionEntity create(ClientSessionKey id, String realmId, UserSessionModel userSession) {
        RemoteAuthenticatedClientSessionEntity e = new RemoteAuthenticatedClientSessionEntity(id.userSessionId(), id.clientId(), userSession.getUser().getId(), realmId);
        e.timestamp = e.started = Time.currentTime();
        e.notes = new HashMap<String, String>();
        return e;
    }

    public static RemoteAuthenticatedClientSessionEntity createFromModel(ClientSessionKey id, AuthenticatedClientSessionModel model) {
        RemoteAuthenticatedClientSessionEntity e = new RemoteAuthenticatedClientSessionEntity(id.userSessionId(), id.clientId(), model.getUserSession().getUser().getId(), model.getRealm().getId());
        e.timestamp = e.started = Time.currentTime();
        e.notes = model.getNotes() == null || model.getNotes().isEmpty() ? new HashMap() : new HashMap(model.getNotes());
        return e;
    }

    public static RemoteAuthenticatedClientSessionEntity mockEntity(String userSessionId, String userId, String realmId) {
        return RemoteAuthenticatedClientSessionEntity.mockEntity(userSessionId, "client", userId, realmId);
    }

    public static RemoteAuthenticatedClientSessionEntity mockEntity(String userSessionId, String clientId, String userId, String realmId) {
        return new RemoteAuthenticatedClientSessionEntity(userSessionId, clientId, userId, realmId);
    }

    @ProtoField(value=1)
    @Basic(projectable=true, sortable=true)
    public String getClientId() {
        return this.clientId;
    }

    @ProtoField(value=2)
    @Basic
    public String getUserId() {
        return this.userId;
    }

    @ProtoField(value=3)
    @Basic(projectable=true, sortable=true)
    public String getUserSessionId() {
        return this.userSessionId;
    }

    @ProtoField(value=4)
    @Basic
    public String getRealmId() {
        return this.realmId;
    }

    @ProtoField(value=5, mapImplementation=HashMap.class)
    public Map<String, String> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<String, String> notes) {
        this.notes = notes;
    }

    @ProtoField(value=6)
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @ProtoField(value=7)
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @ProtoField(value=8)
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @ProtoField(value=9)
    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    @ProtoField(value=10)
    public int getStarted() {
        return this.started;
    }

    public void setStarted(int started) {
        this.started = started;
    }

    public void restart() {
        this.action = null;
        this.redirectUri = null;
        this.timestamp = this.started = Time.currentTime();
        this.notes.clear();
    }

    public ClientSessionKey createCacheKey() {
        return new ClientSessionKey(this.userSessionId, this.clientId);
    }

    public String createId() {
        return UUID.nameUUIDFromBytes((this.userSessionId + this.clientId).getBytes(StandardCharsets.UTF_8)).toString();
    }
}

