/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CompilationOutputs;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportModelToTsDeclarationsKt;
import org.jetbrains.kotlin.ir.backend.js.tsexport.TypeScriptFragment;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.config.ModuleKind;
import org.jetbrains.kotlin.js.config.TsCompilationStrategy;
import org.jetbrains.kotlin.js.config.WebArtifactConfiguration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H&J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u001aJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170!J\u0016\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%R,\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00000\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010&\u001a\u00020\u0017*\u00020\u00178DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/CompilationOutputs;", "", "<init>", "()V", "dependencies", "", "Lkotlin/Pair;", "", "getDependencies", "()Ljava/util/Collection;", "setDependencies", "(Ljava/util/Collection;)V", "tsDefinitions", "Lorg/jetbrains/kotlin/ir/backend/js/tsexport/TypeScriptFragment;", "getTsDefinitions-LIvGIQ8", "()Ljava/lang/String;", "jsProgram", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "getJsProgram", "()Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "writeJsCode", "", "outputJsFile", "Ljava/io/File;", "outputJsMapFile", "createWrittenFilesContainer", "", "writeAll", "artifactConfiguration", "Lorg/jetbrains/kotlin/js/config/WebArtifactConfiguration;", "deleteNonWrittenFiles", "outputDir", "writtenFiles", "", "getFullTsDefinition", "moduleName", "moduleKind", "Lorg/jetbrains/kotlin/js/config/ModuleKind;", "normalizedAbsoluteFile", "getNormalizedAbsoluteFile", "(Ljava/io/File;)Ljava/io/File;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nCompilationOutputs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationOutputs.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/CompilationOutputs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n1915#2,2:185\n1642#2,10:188\n1915#2:198\n1916#2:200\n1652#2:201\n1#3:187\n1#3:199\n*S KotlinDebug\n*F\n+ 1 CompilationOutputs.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/CompilationOutputs\n*L\n49#1:185,2\n73#1:188,10\n73#1:198\n73#1:200\n73#1:201\n73#1:199\n*E\n"})
public abstract class CompilationOutputs {
    @NotNull
    private Collection<? extends Pair<String, ? extends CompilationOutputs>> dependencies = CollectionsKt.emptyList();

    @NotNull
    public final Collection<Pair<String, CompilationOutputs>> getDependencies() {
        return this.dependencies;
    }

    public final void setDependencies(@NotNull Collection<? extends Pair<String, ? extends CompilationOutputs>> collection) {
        Intrinsics.checkNotNullParameter(collection, "<set-?>");
        this.dependencies = collection;
    }

    @Nullable
    public abstract String getTsDefinitions-LIvGIQ8();

    @Nullable
    public abstract JsProgram getJsProgram();

    public abstract void writeJsCode(@NotNull File var1, @NotNull File var2);

    @NotNull
    public final Set<File> createWrittenFilesContainer() {
        return new LinkedHashSet(2 * (this.dependencies.size() + 1) + 1);
    }

    @NotNull
    public Collection<File> writeAll(@NotNull WebArtifactConfiguration artifactConfiguration) {
        Set<File> set;
        Intrinsics.checkNotNullParameter(artifactConfiguration, "artifactConfiguration");
        Set<File> writtenFiles = this.createWrittenFilesContainer();
        Iterable $this$forEach$iv = this.dependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String name2 = (String)pair.component1();
            CompilationOutputs content = (CompilationOutputs)pair.component2();
            CompilationOutputs.writeAll$writeOutputFiles(artifactConfiguration, this, writtenFiles, name2, content);
        }
        CompilationOutputs.writeAll$writeOutputFiles(artifactConfiguration, this, writtenFiles, artifactConfiguration.getOutputName(), this);
        if (artifactConfiguration.getTsCompilationStrategy() == TsCompilationStrategy.MERGED) {
            File dtsFile = this.getNormalizedAbsoluteFile(WebArtifactConfiguration.outputDtsFile$default(artifactConfiguration, null, 1, null));
            FilesKt.writeText$default(dtsFile, this.getFullTsDefinition(artifactConfiguration.getModuleName(), artifactConfiguration.getModuleKind()), null, 2, null);
            ((Collection)writtenFiles).add(dtsFile);
        }
        Set<File> it = set = writtenFiles;
        boolean bl = false;
        this.deleteNonWrittenFiles(artifactConfiguration.getOutputDirectory(), it);
        return set;
    }

    public final void deleteNonWrittenFiles(@NotNull File outputDir, @NotNull Set<? extends File> writtenFiles) {
        Intrinsics.checkNotNullParameter(outputDir, "outputDir");
        Intrinsics.checkNotNullParameter(writtenFiles, "writtenFiles");
        ((Stream)Files.walk(outputDir.toPath(), new FileVisitOption[0]).parallel()).map(arg_0 -> CompilationOutputs.deleteNonWrittenFiles$lambda$1(CompilationOutputs::deleteNonWrittenFiles$lambda$0, arg_0)).filter(arg_0 -> CompilationOutputs.deleteNonWrittenFiles$lambda$3(arg_0 -> CompilationOutputs.deleteNonWrittenFiles$lambda$2(outputDir, writtenFiles, arg_0), arg_0)).forEach(arg_0 -> CompilationOutputs.deleteNonWrittenFiles$lambda$4(deleteNonWrittenFiles.3.INSTANCE, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getFullTsDefinition(@NotNull String moduleName2, @NotNull ModuleKind moduleKind) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
        Intrinsics.checkNotNullParameter((Object)moduleKind, "moduleKind");
        Iterable $this$mapNotNull$iv = this.dependencies;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeScriptFragment it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            String string = ((CompilationOutputs)it.getSecond()).getTsDefinitions-LIvGIQ8();
            if ((string != null ? TypeScriptFragment.box-impl(string) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        String string = this.getTsDefinitions-LIvGIQ8();
        List<TypeScriptFragment> allTsDefinitions = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOfNotNull(string != null ? TypeScriptFragment.box-impl(string) : null));
        return ExportModelToTsDeclarationsKt.toTypeScript(allTsDefinitions, moduleName2, moduleKind);
    }

    @NotNull
    protected final File getNormalizedAbsoluteFile(@NotNull File $this$normalizedAbsoluteFile) {
        Intrinsics.checkNotNullParameter($this$normalizedAbsoluteFile, "<this>");
        File file = $this$normalizedAbsoluteFile.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue(file, "getAbsoluteFile(...)");
        return FilesKt.normalize(file);
    }

    private static final void writeAll$writeOutputFiles(WebArtifactConfiguration $artifactConfiguration, CompilationOutputs this$0, Set<File> writtenFiles, String outputName, CompilationOutputs out) {
        block0: {
            TypeScriptFragment typeScriptFragment;
            File jsFile = null;
            jsFile = $artifactConfiguration.outputJsFile(outputName);
            jsFile.getParentFile().mkdirs();
            jsFile = this$0.getNormalizedAbsoluteFile(jsFile);
            File jsMapFile = this$0.getNormalizedAbsoluteFile($artifactConfiguration.outputSourceMapFile(outputName));
            out.writeJsCode(jsFile, jsMapFile);
            ((Collection)writtenFiles).add(jsFile);
            ((Collection)writtenFiles).add(jsMapFile);
            String string = out.getTsDefinitions-LIvGIQ8();
            TypeScriptFragment typeScriptFragment2 = typeScriptFragment = string != null ? TypeScriptFragment.box-impl(string) : null;
            String it = typeScriptFragment2 != null ? typeScriptFragment2.unbox-impl() : null;
            boolean bl = false;
            TypeScriptFragment typeScriptFragment3 = $artifactConfiguration.getTsCompilationStrategy() == TsCompilationStrategy.EACH_FILE ? typeScriptFragment : null;
            String string2 = typeScriptFragment3 != null ? typeScriptFragment3.unbox-impl() : null;
            if (string2 == null) break block0;
            it = TypeScriptFragment.box-impl(string2).unbox-impl();
            boolean bl2 = false;
            File tsFile = this$0.getNormalizedAbsoluteFile($artifactConfiguration.outputDtsFile(outputName));
            List<TypeScriptFragment> list = CollectionsKt.listOf(TypeScriptFragment.box-impl(it));
            String string3 = jsFile.getName();
            Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
            FilesKt.writeText$default(tsFile, ExportModelToTsDeclarationsKt.toTypeScript(list, string3, $artifactConfiguration.getModuleKind()), null, 2, null);
            ((Collection)writtenFiles).add(tsFile);
        }
    }

    private static final File deleteNonWrittenFiles$lambda$0(Path it) {
        return it.toFile();
    }

    private static final File deleteNonWrittenFiles$lambda$1(Function1 $tmp0, Object p0) {
        return (File)$tmp0.invoke(p0);
    }

    private static final boolean deleteNonWrittenFiles$lambda$2(File $outputDir, Set $writtenFiles, File it) {
        return !Intrinsics.areEqual(it, $outputDir) && !$writtenFiles.contains(it);
    }

    private static final boolean deleteNonWrittenFiles$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void deleteNonWrittenFiles$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

