## Learning Git

The following sites are great references for Git padawans and jedi alike:

* [Git-SVN crash course](http://git.or.cz/course/svn.html): Lots of good stuff on helping newbies grok the concepts of Git w/ reference to similar concepts in Subversion.
* [Codecademy Git Course](https://www.codecademy.com/learn/learn-git): Great free course for quickly getting up to speed on Git with helpful hands on exercises.
* [Learn Git Branching](https://learngitbranching.js.org/): Good website for learning how Git branching works in a visual and interactive manner.
* [Git Reference](http://gitref.org): From the site: "meant to be a quick reference for learning and remembering the most important and commonly used Git commands." Follows a tutorial-like format. Great for beginners.
* [The Pro Git Book](https://git-scm.com/book/en/v2): A free, online copy of the Pro Git book by GitHubber Scott Chacon.
* [The Git Community Book](http://book.git-scm.com): A free book put together by the Git community for those new to Git.
* [Git Magic](http://www-cs-students.stanford.edu/~blynn/gitmagic/): Another free Git book put together by a Stanford CS student.
* [Git Ready](http://gitready.com): A collection of Git tips and tricks.
* [The Git Parable](http://tom.preston-werner.com/2009/05/19/the-git-parable.html): A story by GitHub founder Tom Preston-Werner that reveals the underlying principles behind Git's construction. A great starting point for understanding the nature of Git.
* [Git is Easier Than You Think](http://nfarina.com/post/9868516270/git-is-simpler): A nice tutorial that breaks down one Git user's experience switching from Subversion.
* [PeepCode: Git](http://peepcode.com/products/git): A one-hour (not-free) screencast covering Git basics. Well-made and easy to follow.
* [GitHub Flow](http://scottchacon.com/2011/08/31/github-flow.html): Another great post from Scott Chacon describing a GitHub-based workflow for projects.
* [Getting Started with GitHub](https://pragprog.com/screencasts/v-scgithub/insider-guide-to-github): Also from GitHub's own Scott Chacon, this two-part screencast (one free and one paid) will walk you through the basics of using GitHub.


## Using Git in Editors

* [Fugitive plugin for Vim](https://github.com/tpope/vim-fugitive): Provides lots of tasty functionality from inside Vim.  There's also a five-part series on [VimCasts](http://vimcasts.org/episodes/fugitive-vim---a-complement-to-command-line-git/) on using Fugitive for almost any git task you can think of.

* TextMate - a bundle for git ships with the editor.  Highlight your top-level folder in the project drawer and then invoke with Command-Shift-G

## SVN mirroring

Of course, if you're still having trouble, GitHub does offer [basic SVN read-write support](https://github.com/blog/644-subversion-write-support).
