/**
 * ./src/classes/daddy.ts
 * penguins-eggs v.25.7.x / ECMAScript 2020
 * author: Piero Proietti (modified by Hossein Seilani)
 * license: MIT
 */
import Settings from '../classes/settings.js';
import { IEggsConfig } from '../interfaces/i-eggs-config.js';
export default class Daddy {
    settings: Settings;
    /**
     * [CHANGE 1] Modular, type-safe, interactive configuration editor
     * This method asks the user for LiveCD parameters using inquirer and returns
     * a fully typed IEggsConfig object. It replaces the older JSON.stringify/parse approach.
     */
    editConfig(config: IEggsConfig): Promise<IEggsConfig>;
    /**
     * [CHANGE 2] Central method to manage environment, configuration and save
     * This method is modular, type-safe, and handles:
     * - Pacman and distro templates check
     * - Load, reset, or apply custom configuration
     * - Save configuration to disk
     * - Provide clear guidance to the user
     */
    helpMe(reset?: boolean, isCustom?: boolean, fileCustom?: string, verbose?: boolean): Promise<void>;
    /**
     * Check and install Pacman configuration and templates if missing
     */
    private checkPacman;
    /**
     * Apply reset or custom configuration
     */
    private applyResetOrCustomConfig;
    /**
     * Load and apply a custom YAML configuration
     * [CHANGE 3] Async reading of file and type-safe parsing
     */
    private applyCustomYAML;
    /**
     * Display final guidance and tips to the user
     * [CHANGE 4] Modular, clear, user-friendly messages
     */
    private displayFinalHelp;
}
