/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.teoz.CommonTile;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TimeHook;
import net.sourceforge.plantuml.sequencediagram.teoz.YGauge;

public class TileParallel
extends CommonTile {
    private final List<Tile> tiles = new ArrayList<Tile>();

    public TileParallel(StringBounder stringBounder, Real currentY) {
        super(stringBounder);
    }

    @Override
    public YGauge getYGauge() {
        ArrayList<Real> mins = new ArrayList<Real>();
        ArrayList<Real> maxs = new ArrayList<Real>();
        for (Tile tile : this.tiles) {
            YGauge yGauge = tile.getYGauge();
            mins.add(yGauge.getMin());
            maxs.add(yGauge.getMax());
        }
        return new YGauge(RealUtils.min(mins), RealUtils.max(maxs));
    }

    @Override
    protected final void callbackY_internal(TimeHook y) {
        super.callbackY_internal(y);
    }

    public void add(Tile tile) {
        this.tiles.add(tile);
    }

    @Override
    public void drawU(UGraphic ug) {
        double yPointAll = this.getContactPointRelative();
        for (Tile tile : this.tiles) {
            double yPoint = tile.getContactPointRelative();
            ((UDrawable)((Object)tile)).drawU(ug.apply(UTranslate.dy(yPointAll - yPoint)));
        }
    }

    @Override
    public double getContactPointRelative() {
        double result = 0.0;
        for (Tile tile : this.tiles) {
            result = Math.max(result, tile.getContactPointRelative());
        }
        return result;
    }

    @Override
    public double getZZZ() {
        double result = 0.0;
        for (Tile tile : this.tiles) {
            result = Math.max(result, tile.getZZZ());
        }
        return result;
    }

    @Override
    public double getPreferredHeight() {
        return this.getContactPointRelative() + this.getZZZ();
    }

    @Override
    public void addConstraints() {
        for (Tile tile : this.tiles) {
            tile.addConstraints();
        }
    }

    @Override
    public Real getMinX() {
        return RealUtils.min((Collection<Real>)new AbstractCollection<Real>(){

            @Override
            public Iterator<Real> iterator() {
                return new Iterator<Real>(){
                    private final Iterator<Tile> source;
                    {
                        this.source = TileParallel.this.tiles.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.source.hasNext();
                    }

                    @Override
                    public Real next() {
                        return this.source.next().getMinX();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return TileParallel.this.tiles.size();
            }
        });
    }

    @Override
    public Real getMaxX() {
        return RealUtils.max((Collection<Real>)new AbstractCollection<Real>(){

            @Override
            public Iterator<Real> iterator() {
                return new Iterator<Real>(){
                    private final Iterator<Tile> source;
                    {
                        this.source = TileParallel.this.tiles.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.source.hasNext();
                    }

                    @Override
                    public Real next() {
                        return this.source.next().getMaxX();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return TileParallel.this.tiles.size();
            }
        });
    }

    @Override
    public Event getEvent() {
        return null;
    }

    @Override
    public boolean matchAnchor(String anchor) {
        for (Tile tile : this.tiles) {
            if (!tile.matchAnchor(anchor)) continue;
            return true;
        }
        return false;
    }

    protected List<Tile> getTiles() {
        return this.tiles;
    }
}

