/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart.command;

import net.sourceforge.plantuml.chart.ChartAnnotation;
import net.sourceforge.plantuml.chart.ChartDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandChartAnnotation
extends SingleLineCommand2<ChartDiagram> {
    public CommandChartAnnotation() {
        super(false, CommandChartAnnotation.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandChartAnnotation.class.getName(), RegexLeaf.start(), new RegexLeaf("annotation"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "TEXT", "\"([^\"]+)\""), RegexLeaf.spaceOneOrMore(), new RegexLeaf("at"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\("), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "XPOS", "([^,]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "YPOS", "([^)]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\)"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "ARROW", "<<(arrow)>>")), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ChartDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        double yPosition;
        Object xPosition;
        String text = arg.get("TEXT", 0);
        String xPosStr = arg.get("XPOS", 0).trim();
        String yPosStr = arg.get("YPOS", 0).trim();
        String arrowStr = arg.getLazzy("ARROW", 0);
        try {
            xPosition = Double.parseDouble(xPosStr);
        }
        catch (NumberFormatException e) {
            xPosition = xPosStr;
        }
        try {
            yPosition = Double.parseDouble(yPosStr);
        }
        catch (NumberFormatException e) {
            return CommandExecutionResult.error("Y position must be a numeric value: " + yPosStr);
        }
        boolean showArrow = arrowStr != null;
        ChartAnnotation annotation = new ChartAnnotation(text, xPosition, yPosition, showArrow);
        return diagram.addAnnotation(annotation);
    }
}

