/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PyAnnotationHolder {
    private final boolean myTestMode;
    @NotNull
    private final AnnotationHolder myHolder;

    public PyAnnotationHolder(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            PyAnnotationHolder.$$$reportNull$$$0(0);
        }
        this.myTestMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myHolder = holder;
    }

    @Contract(pure=true)
    @NotNull
    public AnnotationBuilder newAnnotation(@NotNull HighlightSeverity severity, @NotNull @InspectionMessage String message) {
        if (severity == null) {
            PyAnnotationHolder.$$$reportNull$$$0(1);
        }
        if (message == null) {
            PyAnnotationHolder.$$$reportNull$$$0(2);
        }
        AnnotationBuilder annotationBuilder = this.myHolder.newAnnotation(severity, message);
        if (annotationBuilder == null) {
            PyAnnotationHolder.$$$reportNull$$$0(3);
        }
        return annotationBuilder;
    }

    @Contract(pure=true)
    @NotNull
    public AnnotationBuilder newSilentAnnotation(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            PyAnnotationHolder.$$$reportNull$$$0(4);
        }
        AnnotationBuilder annotationBuilder = this.myHolder.newSilentAnnotation(severity);
        if (annotationBuilder == null) {
            PyAnnotationHolder.$$$reportNull$$$0(5);
        }
        return annotationBuilder;
    }

    public void markError(@NotNull PsiElement element, @NotNull @InspectionMessage String message) {
        if (element == null) {
            PyAnnotationHolder.$$$reportNull$$$0(6);
        }
        if (message == null) {
            PyAnnotationHolder.$$$reportNull$$$0(7);
        }
        this.myHolder.newAnnotation(HighlightSeverity.ERROR, message).range(element).create();
    }

    public void addHighlightingAnnotation(@NotNull PsiElement target, @NotNull TextAttributesKey key) {
        if (target == null) {
            PyAnnotationHolder.$$$reportNull$$$0(8);
        }
        if (key == null) {
            PyAnnotationHolder.$$$reportNull$$$0(9);
        }
        this.addHighlightingAnnotation(target, key, HighlightInfoType.SYMBOL_TYPE_SEVERITY);
    }

    public void addHighlightingAnnotation(@NotNull PsiElement target, @NotNull TextAttributesKey key, @NotNull HighlightSeverity severity) {
        if (target == null) {
            PyAnnotationHolder.$$$reportNull$$$0(10);
        }
        if (key == null) {
            PyAnnotationHolder.$$$reportNull$$$0(11);
        }
        if (severity == null) {
            PyAnnotationHolder.$$$reportNull$$$0(12);
        }
        String message = this.myTestMode ? key.getExternalName() : null;
        HighlightSeverity actualSeverity = this.myTestMode && severity.myVal < HighlightSeverity.INFORMATION.myVal ? HighlightSeverity.INFORMATION : severity;
        (message == null ? this.myHolder.newSilentAnnotation(actualSeverity) : this.myHolder.newAnnotation(actualSeverity, message)).range(target).textAttributes(key).create();
    }

    public void addHighlightingAnnotation(@NotNull ASTNode target, @NotNull TextAttributesKey key) {
        if (target == null) {
            PyAnnotationHolder.$$$reportNull$$$0(13);
        }
        if (key == null) {
            PyAnnotationHolder.$$$reportNull$$$0(14);
        }
        this.addHighlightingAnnotation(target.getPsi(), key);
    }

    @NotNull
    public AnnotationHolder getOriginalHolder() {
        AnnotationHolder annotationHolder = this.myHolder;
        if (annotationHolder == null) {
            PyAnnotationHolder.$$$reportNull$$$0(15);
        }
        return annotationHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/validation/PyAnnotationHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/validation/PyAnnotationHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newSilentAnnotation";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "newAnnotation";
                break;
            }
            case 3: 
            case 5: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newSilentAnnotation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markError";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addHighlightingAnnotation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 15 -> new IllegalStateException(string);
        };
    }
}

