/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.IntegerContentCommand;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.datatool.DataNumericElement;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import com.dickimawbooks.texparserlib.latex.datatool.Julian;
import java.io.IOException;

public class DataIntElement
extends UserNumber
implements DataNumericElement {
    protected TeXObject original;

    public DataIntElement() {
        this(0);
    }

    public DataIntElement(Number number) {
        super(number.intValue());
    }

    public DataIntElement(int n) {
        super(n);
    }

    public DataIntElement(TeXNumber teXNumber) {
        super(teXNumber.getValue());
    }

    public DataIntElement(int n, TeXObject teXObject) {
        super(n);
        this.original = teXObject;
    }

    @Override
    public Object clone() {
        return new DataIntElement(this.getValue(), this.original == null ? null : (TeXObject)this.original.clone());
    }

    @Override
    public byte getDataType() {
        return 1;
    }

    @Override
    public DatumType getDatumType() {
        return DatumType.INTEGER;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public int intValue() {
        return this.getValue();
    }

    @Override
    public void setValue(int n) {
        super.setValue(n);
        this.original = null;
    }

    @Override
    public TeXObject getTeXValue(TeXParser teXParser) {
        return new UserNumber(this.intValue());
    }

    @Override
    public TeXObject getContent(TeXParser teXParser) {
        if (this.original == null) {
            return new UserNumber(this.intValue());
        }
        return this.original;
    }

    @Override
    public TeXObject getCurrencySymbol() {
        return null;
    }

    @Override
    public Julian getJulian() {
        return null;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        if (this.original == null) {
            TeXObjectList teXObjectList2 = teXParserListener.createStack();
            teXObjectList2.add(teXParserListener.getControlSequence("__texparser_fmt_integer_value:n"));
            teXObjectList2.add(new UserNumber(this.getValue()));
            TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
        } else {
            TeXParserUtils.process(this.original, teXParser, teXObjectList);
        }
    }

    @Override
    public String format() {
        if (this.original == null) {
            return "" + this.getValue();
        }
        return this.original.format();
    }

    @Override
    public String toString(TeXParser teXParser) {
        if (this.original == null) {
            return super.toString(teXParser);
        }
        return this.original.toString(teXParser);
    }

    @Override
    public String toString() {
        return String.format("%s[value=%d,original=%s]", this.getClass().getSimpleName(), this.intValue(), this.original);
    }

    @Override
    public ControlSequence createControlSequence(String string) {
        return new IntegerContentCommand(string, this.intValue());
    }
}

