/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves.rewrite;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.connector.Request;
import org.apache.catalina.valves.rewrite.Resolver;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.jsse.PEMFile;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.net.openssl.ciphers.EncryptionLevel;
import org.apache.tomcat.util.net.openssl.ciphers.OpenSSLCipherConfigurationParser;
import org.apache.tomcat.util.res.StringManager;

public class ResolverImpl
extends Resolver {
    private static final StringManager sm = StringManager.getManager(ResolverImpl.class);
    protected final Request request;
    private final Log containerLog;

    @Deprecated
    public ResolverImpl(Request request) {
        this(request, request.getContext().getLogger());
    }

    public ResolverImpl(Request request, Log log) {
        this.request = request;
        this.containerLog = log;
    }

    @Override
    public String resolve(String string) {
        if (string.equals("HTTP_USER_AGENT")) {
            return this.request.getHeader("user-agent");
        }
        if (string.equals("HTTP_REFERER")) {
            return this.request.getHeader("referer");
        }
        if (string.equals("HTTP_COOKIE")) {
            return this.request.getHeader("cookie");
        }
        if (string.equals("HTTP_FORWARDED")) {
            return this.request.getHeader("forwarded");
        }
        if (string.equals("HTTP_HOST")) {
            return this.request.getServerName();
        }
        if (string.equals("HTTP_PROXY_CONNECTION")) {
            return this.request.getHeader("proxy-connection");
        }
        if (string.equals("HTTP_ACCEPT")) {
            return this.request.getHeader("accept");
        }
        if (string.equals("REMOTE_ADDR")) {
            return this.request.getRemoteAddr();
        }
        if (string.equals("REMOTE_HOST")) {
            return this.request.getRemoteHost();
        }
        if (string.equals("REMOTE_PORT")) {
            return String.valueOf(this.request.getRemotePort());
        }
        if (string.equals("REMOTE_USER")) {
            return this.request.getRemoteUser();
        }
        if (string.equals("REMOTE_IDENT")) {
            return this.request.getRemoteUser();
        }
        if (string.equals("REQUEST_METHOD")) {
            return this.request.getMethod();
        }
        if (string.equals("SCRIPT_FILENAME")) {
            return this.request.getServletContext().getRealPath(this.request.getServletPath());
        }
        if (string.equals("REQUEST_PATH")) {
            return this.request.getRequestPathMB().toString();
        }
        if (string.equals("CONTEXT_PATH")) {
            return this.request.getContextPath();
        }
        if (string.equals("SERVLET_PATH")) {
            return ResolverImpl.emptyStringIfNull(this.request.getServletPath());
        }
        if (string.equals("PATH_INFO")) {
            return ResolverImpl.emptyStringIfNull(this.request.getPathInfo());
        }
        if (string.equals("QUERY_STRING")) {
            return ResolverImpl.emptyStringIfNull(this.request.getQueryString());
        }
        if (string.equals("AUTH_TYPE")) {
            return this.request.getAuthType();
        }
        if (string.equals("DOCUMENT_ROOT")) {
            return this.request.getServletContext().getRealPath("/");
        }
        if (string.equals("SERVER_NAME")) {
            return this.request.getLocalName();
        }
        if (string.equals("SERVER_ADDR")) {
            return this.request.getLocalAddr();
        }
        if (string.equals("SERVER_PORT")) {
            return String.valueOf(this.request.getLocalPort());
        }
        if (string.equals("SERVER_PROTOCOL")) {
            return this.request.getProtocol();
        }
        if (string.equals("SERVER_SOFTWARE")) {
            return "tomcat";
        }
        if (string.equals("THE_REQUEST")) {
            return this.request.getMethod() + " " + this.request.getRequestURI() + " " + this.request.getProtocol();
        }
        if (string.equals("REQUEST_URI")) {
            return this.request.getRequestURI();
        }
        if (string.equals("REQUEST_FILENAME")) {
            return this.request.getPathTranslated();
        }
        if (string.equals("HTTPS")) {
            return this.request.isSecure() ? "on" : "off";
        }
        if (string.equals("TIME_YEAR")) {
            return String.valueOf(Calendar.getInstance().get(1));
        }
        if (string.equals("TIME_MON")) {
            return String.valueOf(Calendar.getInstance().get(2));
        }
        if (string.equals("TIME_DAY")) {
            return String.valueOf(Calendar.getInstance().get(5));
        }
        if (string.equals("TIME_HOUR")) {
            return String.valueOf(Calendar.getInstance().get(11));
        }
        if (string.equals("TIME_MIN")) {
            return String.valueOf(Calendar.getInstance().get(12));
        }
        if (string.equals("TIME_SEC")) {
            return String.valueOf(Calendar.getInstance().get(13));
        }
        if (string.equals("TIME_WDAY")) {
            return String.valueOf(Calendar.getInstance().get(7));
        }
        if (string.equals("TIME")) {
            return FastHttpDateFormat.getCurrentDate();
        }
        return null;
    }

    @Override
    public String resolveEnv(String string) {
        Object object = this.request.getAttribute(string);
        return object != null ? object.toString() : System.getProperty(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String resolveSsl(String string) {
        SSLSupport sSLSupport = (SSLSupport)this.request.getAttribute("jakarta.servlet.request.ssl_session_mgr");
        try {
            if (string.equals("HTTPS")) {
                boolean bl;
                if (sSLSupport != null) {
                    bl = true;
                    return String.valueOf(bl);
                }
                bl = false;
                return String.valueOf(bl);
            }
            if (string.equals("SSL_PROTOCOL")) {
                return sSLSupport.getProtocol();
            }
            if (string.equals("SSL_SESSION_ID")) {
                return sSLSupport.getSessionId();
            }
            if (string.equals("SSL_SESSION_RESUMED")) {
                return null;
            }
            if (string.equals("SSL_SECURE_RENEG")) {
                return null;
            }
            if (string.equals("SSL_COMPRESS_METHOD")) {
                return null;
            }
            if (string.equals("SSL_TLS_SNI")) {
                return null;
            }
            if (string.equals("SSL_CIPHER")) {
                return sSLSupport.getCipherSuite();
            }
            if (string.equals("SSL_CIPHER_EXPORT")) {
                String string2 = sSLSupport.getCipherSuite();
                if (string2 == null) return null;
                LinkedHashSet linkedHashSet = OpenSSLCipherConfigurationParser.parse((String)string2);
                if (linkedHashSet.size() != 1) return null;
                Cipher cipher = (Cipher)linkedHashSet.iterator().next();
                if (cipher.getLevel().equals((Object)EncryptionLevel.EXP40)) return "true";
                if (!cipher.getLevel().equals((Object)EncryptionLevel.EXP56)) return "false";
                return "true";
            }
            if (string.equals("SSL_CIPHER_ALGKEYSIZE")) {
                String string3 = sSLSupport.getCipherSuite();
                if (string3 == null) return null;
                LinkedHashSet linkedHashSet = OpenSSLCipherConfigurationParser.parse((String)string3);
                if (linkedHashSet.size() != 1) return null;
                Cipher cipher = (Cipher)linkedHashSet.iterator().next();
                return String.valueOf(cipher.getAlg_bits());
            }
            if (string.equals("SSL_CIPHER_USEKEYSIZE")) {
                Integer n = sSLSupport.getKeySize();
                if (n == null) {
                    return null;
                }
                String string4 = sSLSupport.getKeySize().toString();
                return string4;
            }
            if (string.startsWith("SSL_CLIENT_")) {
                X509Certificate[] x509CertificateArray = sSLSupport.getPeerCertificateChain();
                if (x509CertificateArray == null) return null;
                if (x509CertificateArray.length <= 0) return null;
                String string5 = this.resolveSslCertificates(string = string.substring("SSL_CLIENT_".length()), x509CertificateArray);
                if (string5 != null) {
                    return string5;
                }
                if (string.startsWith("SAN_OTHER_msUPN_")) {
                    string = string.substring("SAN_OTHER_msUPN_".length());
                    return null;
                }
                if (string.equals("CERT_RFC4523_CEA")) {
                    return null;
                }
            } else {
                if (!string.startsWith("SSL_SERVER_")) return null;
                X509Certificate[] x509CertificateArray = sSLSupport.getLocalCertificateChain();
                if (x509CertificateArray == null) return null;
                if (x509CertificateArray.length <= 0) return null;
                String string6 = this.resolveSslCertificates(string = string.substring("SSL_SERVER_".length()), x509CertificateArray);
                if (string6 != null) {
                    return string6;
                }
                if (!string.startsWith("SAN_OTHER_dnsSRV_")) return null;
                string = string.substring("SAN_OTHER_dnsSRV_".length());
                return null;
            }
            if (!string.equals("VERIFY")) return null;
            return null;
        }
        catch (IOException iOException) {
            if (!this.containerLog.isDebugEnabled()) return null;
            this.containerLog.debug((Object)sm.getString("resolverImpl.tlsError"), (Throwable)iOException);
        }
        return null;
    }

    private String resolveSslCertificates(String string, X509Certificate[] x509CertificateArray) {
        if (string.equals("M_VERSION")) {
            return String.valueOf(x509CertificateArray[0].getVersion());
        }
        if (string.equals("M_SERIAL")) {
            return x509CertificateArray[0].getSerialNumber().toString();
        }
        if (string.equals("S_DN")) {
            return x509CertificateArray[0].getSubjectX500Principal().toString();
        }
        if (string.startsWith("S_DN_")) {
            string = string.substring("S_DN_".length());
            return this.resolveComponent(x509CertificateArray[0].getSubjectX500Principal().getName(), string);
        }
        if (string.startsWith("SAN_Email_")) {
            string = string.substring("SAN_Email_".length());
            return this.resolveAlternateName(x509CertificateArray[0], 1, Integer.parseInt(string));
        }
        if (string.startsWith("SAN_DNS_")) {
            string = string.substring("SAN_DNS_".length());
            return this.resolveAlternateName(x509CertificateArray[0], 2, Integer.parseInt(string));
        }
        if (string.equals("I_DN")) {
            return x509CertificateArray[0].getIssuerX500Principal().getName();
        }
        if (string.startsWith("I_DN_")) {
            string = string.substring("I_DN_".length());
            return this.resolveComponent(x509CertificateArray[0].getIssuerX500Principal().toString(), string);
        }
        if (string.equals("V_START")) {
            return String.valueOf(x509CertificateArray[0].getNotBefore().getTime());
        }
        if (string.equals("V_END")) {
            return String.valueOf(x509CertificateArray[0].getNotAfter().getTime());
        }
        if (string.equals("V_REMAIN")) {
            long l = x509CertificateArray[0].getNotAfter().getTime() - System.currentTimeMillis();
            if (l < 0L) {
                l = 0L;
            }
            return String.valueOf(TimeUnit.MILLISECONDS.toDays(l));
        }
        if (string.equals("A_SIG")) {
            return x509CertificateArray[0].getSigAlgName();
        }
        if (string.equals("A_KEY")) {
            return x509CertificateArray[0].getPublicKey().getAlgorithm();
        }
        if (string.equals("CERT")) {
            try {
                return PEMFile.toPEM((X509Certificate)x509CertificateArray[0]);
            }
            catch (CertificateEncodingException certificateEncodingException) {
            }
        } else if (string.startsWith("CERT_CHAIN_")) {
            string = string.substring("CERT_CHAIN_".length());
            try {
                return PEMFile.toPEM((X509Certificate)x509CertificateArray[Integer.parseInt(string)]);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException | CertificateEncodingException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String resolveComponent(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(61);
            if (n <= 0 || n + 1 >= string3.length()) continue;
            hashMap.put(string3.substring(0, n), string3.substring(n + 1));
        }
        return (String)hashMap.get(string2);
    }

    private String resolveAlternateName(X509Certificate x509Certificate, int n, int n2) {
        try {
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (List<?> list : collection) {
                    Integer n3 = (Integer)list.get(0);
                    if (n3 != n) continue;
                    arrayList.add(String.valueOf(list.get(1)));
                }
                if (arrayList.size() > n2) {
                    return (String)arrayList.get(n2);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException | CertificateParsingException exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String resolveHttp(String string) {
        return Objects.requireNonNullElse(this.request.getHeader(string), "");
    }

    @Override
    public boolean resolveResource(int n, String string) {
        WebResourceRoot webResourceRoot = this.request.getContext().getResources();
        WebResource webResource = webResourceRoot.getResource(string);
        if (!webResource.exists()) {
            return false;
        }
        switch (n) {
            case 0: {
                return webResource.isDirectory();
            }
            case 1: {
                return webResource.isFile();
            }
            case 2: {
                return webResource.isFile() && webResource.getContentLength() > 0L;
            }
        }
        return false;
    }

    private static String emptyStringIfNull(String string) {
        return Objects.requireNonNullElse(string, "");
    }

    @Override
    public Charset getUriCharset() {
        return this.request.getConnector().getURICharset();
    }
}

