/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSource;
import org.apache.tomcat.dbcp.pool2.impl.BaseObjectPoolConfig;

public class BasicDataSourceFactory
implements ObjectFactory {
    private static final Log log = LogFactory.getLog(BasicDataSourceFactory.class);
    private static final String PROP_DEFAULT_AUTO_COMMIT = "defaultAutoCommit";
    private static final String PROP_DEFAULT_READ_ONLY = "defaultReadOnly";
    private static final String PROP_DEFAULT_TRANSACTION_ISOLATION = "defaultTransactionIsolation";
    private static final String PROP_DEFAULT_CATALOG = "defaultCatalog";
    private static final String PROP_DEFAULT_SCHEMA = "defaultSchema";
    private static final String PROP_CACHE_STATE = "cacheState";
    private static final String PROP_DRIVER_CLASS_NAME = "driverClassName";
    private static final String PROP_LIFO = "lifo";
    private static final String PROP_MAX_TOTAL = "maxTotal";
    private static final String PROP_MAX_IDLE = "maxIdle";
    private static final String PROP_MIN_IDLE = "minIdle";
    private static final String PROP_INITIAL_SIZE = "initialSize";
    private static final String PROP_MAX_WAIT_MILLIS = "maxWaitMillis";
    private static final String PROP_TEST_ON_CREATE = "testOnCreate";
    private static final String PROP_TEST_ON_BORROW = "testOnBorrow";
    private static final String PROP_TEST_ON_RETURN = "testOnReturn";
    private static final String PROP_TIME_BETWEEN_EVICTION_RUNS_MILLIS = "timeBetweenEvictionRunsMillis";
    private static final String PROP_NUM_TESTS_PER_EVICTION_RUN = "numTestsPerEvictionRun";
    private static final String PROP_MIN_EVICTABLE_IDLE_TIME_MILLIS = "minEvictableIdleTimeMillis";
    private static final String PROP_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS = "softMinEvictableIdleTimeMillis";
    private static final String PROP_EVICTION_POLICY_CLASS_NAME = "evictionPolicyClassName";
    private static final String PROP_TEST_WHILE_IDLE = "testWhileIdle";
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_URL = "url";
    private static final String PROP_USER_NAME = "username";
    private static final String PROP_VALIDATION_QUERY = "validationQuery";
    private static final String PROP_VALIDATION_QUERY_TIMEOUT = "validationQueryTimeout";
    private static final String PROP_JMX_NAME = "jmxName";
    private static final String PROP_REGISTER_CONNECTION_MBEAN = "registerConnectionMBean";
    private static final String PROP_CONNECTION_FACTORY_CLASS_NAME = "connectionFactoryClassName";
    private static final String PROP_CONNECTION_INIT_SQLS = "connectionInitSqls";
    private static final String PROP_ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED = "accessToUnderlyingConnectionAllowed";
    private static final String PROP_REMOVE_ABANDONED_ON_BORROW = "removeAbandonedOnBorrow";
    private static final String PROP_REMOVE_ABANDONED_ON_MAINTENANCE = "removeAbandonedOnMaintenance";
    private static final String PROP_REMOVE_ABANDONED_TIMEOUT = "removeAbandonedTimeout";
    private static final String PROP_LOG_ABANDONED = "logAbandoned";
    private static final String PROP_ABANDONED_USAGE_TRACKING = "abandonedUsageTracking";
    private static final String PROP_POOL_PREPARED_STATEMENTS = "poolPreparedStatements";
    private static final String PROP_CLEAR_STATEMENT_POOL_ON_RETURN = "clearStatementPoolOnReturn";
    private static final String PROP_MAX_OPEN_PREPARED_STATEMENTS = "maxOpenPreparedStatements";
    private static final String PROP_CONNECTION_PROPERTIES = "connectionProperties";
    private static final String PROP_MAX_CONN_LIFETIME_MILLIS = "maxConnLifetimeMillis";
    private static final String PROP_LOG_EXPIRED_CONNECTIONS = "logExpiredConnections";
    private static final String PROP_ROLLBACK_ON_RETURN = "rollbackOnReturn";
    private static final String PROP_ENABLE_AUTO_COMMIT_ON_RETURN = "enableAutoCommitOnReturn";
    private static final String PROP_DEFAULT_QUERY_TIMEOUT = "defaultQueryTimeout";
    private static final String PROP_FAST_FAIL_VALIDATION = "fastFailValidation";
    private static final String PROP_DISCONNECTION_SQL_CODES = "disconnectionSqlCodes";
    private static final String PROP_DISCONNECTION_IGNORE_SQL_CODES = "disconnectionIgnoreSqlCodes";
    private static final String NUPROP_MAX_ACTIVE = "maxActive";
    private static final String NUPROP_REMOVE_ABANDONED = "removeAbandoned";
    private static final String NUPROP_MAXWAIT = "maxWait";
    private static final String SILENT_PROP_FACTORY = "factory";
    private static final String SILENT_PROP_SCOPE = "scope";
    private static final String SILENT_PROP_SINGLETON = "singleton";
    private static final String SILENT_PROP_AUTH = "auth";
    private static final List<String> ALL_PROPERTY_NAMES = Arrays.asList("defaultAutoCommit", "defaultReadOnly", "defaultTransactionIsolation", "defaultCatalog", "defaultSchema", "cacheState", "driverClassName", "lifo", "maxTotal", "maxIdle", "minIdle", "initialSize", "maxWaitMillis", "testOnCreate", "testOnBorrow", "testOnReturn", "timeBetweenEvictionRunsMillis", "numTestsPerEvictionRun", "minEvictableIdleTimeMillis", "softMinEvictableIdleTimeMillis", "evictionPolicyClassName", "testWhileIdle", "password", "url", "username", "validationQuery", "validationQueryTimeout", "connectionInitSqls", "accessToUnderlyingConnectionAllowed", "removeAbandonedOnBorrow", "removeAbandonedOnMaintenance", "removeAbandonedTimeout", "logAbandoned", "abandonedUsageTracking", "poolPreparedStatements", "clearStatementPoolOnReturn", "maxOpenPreparedStatements", "connectionProperties", "maxConnLifetimeMillis", "logExpiredConnections", "rollbackOnReturn", "enableAutoCommitOnReturn", "defaultQueryTimeout", "fastFailValidation", "disconnectionSqlCodes", "disconnectionIgnoreSqlCodes", "jmxName", "registerConnectionMBean", "connectionFactoryClassName");
    private static final Map<String, String> NUPROP_WARNTEXT = new LinkedHashMap<String, String>();
    private static final List<String> SILENT_PROPERTIES;

    private static <V> void accept(Properties properties, String string2, Function<String, V> function, Consumer<V> consumer) {
        BasicDataSourceFactory.getOptional(properties, string2).ifPresent(string -> consumer.accept(function.apply((String)string)));
    }

    private static void acceptBoolean(Properties properties, String string, Consumer<Boolean> consumer) {
        BasicDataSourceFactory.accept(properties, string, Boolean::parseBoolean, consumer);
    }

    private static void acceptDurationOfMillis(Properties properties, String string2, Consumer<Duration> consumer) {
        BasicDataSourceFactory.accept(properties, string2, string -> Duration.ofMillis(Long.parseLong(string)), consumer);
    }

    private static void acceptDurationOfSeconds(Properties properties, String string2, Consumer<Duration> consumer) {
        BasicDataSourceFactory.accept(properties, string2, string -> Duration.ofSeconds(Long.parseLong(string)), consumer);
    }

    private static void acceptInt(Properties properties, String string, Consumer<Integer> consumer) {
        BasicDataSourceFactory.accept(properties, string, Integer::parseInt, consumer);
    }

    private static void acceptString(Properties properties, String string, Consumer<String> consumer) {
        BasicDataSourceFactory.accept(properties, string, Function.identity(), consumer);
    }

    public static BasicDataSource createDataSource(Properties properties) throws SQLException {
        BasicDataSource basicDataSource = new BasicDataSource();
        BasicDataSourceFactory.acceptBoolean(properties, PROP_DEFAULT_AUTO_COMMIT, basicDataSource::setDefaultAutoCommit);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_DEFAULT_READ_ONLY, basicDataSource::setDefaultReadOnly);
        BasicDataSourceFactory.getOptional(properties, PROP_DEFAULT_TRANSACTION_ISOLATION).ifPresent(string -> {
            string = string.toUpperCase(Locale.ROOT);
            int n = -1;
            switch (string) {
                case "NONE": {
                    n = 0;
                    break;
                }
                case "READ_COMMITTED": {
                    n = 2;
                    break;
                }
                case "READ_UNCOMMITTED": {
                    n = 1;
                    break;
                }
                case "REPEATABLE_READ": {
                    n = 4;
                    break;
                }
                case "SERIALIZABLE": {
                    n = 8;
                    break;
                }
                default: {
                    try {
                        n = Integer.parseInt(string);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Could not parse defaultTransactionIsolation: " + string);
                        System.err.println("WARNING: defaultTransactionIsolation not set");
                        System.err.println("using default value of database driver");
                        n = -1;
                    }
                }
            }
            basicDataSource.setDefaultTransactionIsolation(n);
        });
        BasicDataSourceFactory.acceptString(properties, PROP_DEFAULT_SCHEMA, basicDataSource::setDefaultSchema);
        BasicDataSourceFactory.acceptString(properties, PROP_DEFAULT_CATALOG, basicDataSource::setDefaultCatalog);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_CACHE_STATE, basicDataSource::setCacheState);
        BasicDataSourceFactory.acceptString(properties, PROP_DRIVER_CLASS_NAME, basicDataSource::setDriverClassName);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_LIFO, basicDataSource::setLifo);
        BasicDataSourceFactory.acceptInt(properties, PROP_MAX_TOTAL, basicDataSource::setMaxTotal);
        BasicDataSourceFactory.acceptInt(properties, PROP_MAX_IDLE, basicDataSource::setMaxIdle);
        BasicDataSourceFactory.acceptInt(properties, PROP_MIN_IDLE, basicDataSource::setMinIdle);
        BasicDataSourceFactory.acceptInt(properties, PROP_INITIAL_SIZE, basicDataSource::setInitialSize);
        BasicDataSourceFactory.acceptDurationOfMillis(properties, PROP_MAX_WAIT_MILLIS, basicDataSource::setMaxWait);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_TEST_ON_CREATE, basicDataSource::setTestOnCreate);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_TEST_ON_BORROW, basicDataSource::setTestOnBorrow);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_TEST_ON_RETURN, basicDataSource::setTestOnReturn);
        BasicDataSourceFactory.acceptDurationOfMillis(properties, PROP_TIME_BETWEEN_EVICTION_RUNS_MILLIS, basicDataSource::setDurationBetweenEvictionRuns);
        BasicDataSourceFactory.acceptInt(properties, PROP_NUM_TESTS_PER_EVICTION_RUN, basicDataSource::setNumTestsPerEvictionRun);
        BasicDataSourceFactory.acceptDurationOfMillis(properties, PROP_MIN_EVICTABLE_IDLE_TIME_MILLIS, basicDataSource::setMinEvictableIdle);
        BasicDataSourceFactory.acceptDurationOfMillis(properties, PROP_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS, basicDataSource::setSoftMinEvictableIdle);
        BasicDataSourceFactory.acceptString(properties, PROP_EVICTION_POLICY_CLASS_NAME, basicDataSource::setEvictionPolicyClassName);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_TEST_WHILE_IDLE, basicDataSource::setTestWhileIdle);
        BasicDataSourceFactory.acceptString(properties, PROP_PASSWORD, basicDataSource::setPassword);
        BasicDataSourceFactory.acceptString(properties, PROP_URL, basicDataSource::setUrl);
        BasicDataSourceFactory.acceptString(properties, PROP_USER_NAME, basicDataSource::setUsername);
        BasicDataSourceFactory.acceptString(properties, PROP_VALIDATION_QUERY, basicDataSource::setValidationQuery);
        BasicDataSourceFactory.acceptDurationOfSeconds(properties, PROP_VALIDATION_QUERY_TIMEOUT, basicDataSource::setValidationQueryTimeout);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED, basicDataSource::setAccessToUnderlyingConnectionAllowed);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_REMOVE_ABANDONED_ON_BORROW, basicDataSource::setRemoveAbandonedOnBorrow);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_REMOVE_ABANDONED_ON_MAINTENANCE, basicDataSource::setRemoveAbandonedOnMaintenance);
        BasicDataSourceFactory.acceptDurationOfSeconds(properties, PROP_REMOVE_ABANDONED_TIMEOUT, basicDataSource::setRemoveAbandonedTimeout);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_LOG_ABANDONED, basicDataSource::setLogAbandoned);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_ABANDONED_USAGE_TRACKING, basicDataSource::setAbandonedUsageTracking);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_POOL_PREPARED_STATEMENTS, basicDataSource::setPoolPreparedStatements);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_CLEAR_STATEMENT_POOL_ON_RETURN, basicDataSource::setClearStatementPoolOnReturn);
        BasicDataSourceFactory.acceptInt(properties, PROP_MAX_OPEN_PREPARED_STATEMENTS, basicDataSource::setMaxOpenPreparedStatements);
        BasicDataSourceFactory.getOptional(properties, PROP_CONNECTION_INIT_SQLS).ifPresent(string -> basicDataSource.setConnectionInitSqls(BasicDataSourceFactory.parseList(string, ';')));
        String string2 = properties.getProperty(PROP_CONNECTION_PROPERTIES);
        if (string2 != null) {
            Properties properties2 = BasicDataSourceFactory.getProperties(string2);
            for (Object object : properties2.keySet()) {
                String string3 = Objects.toString(object);
                basicDataSource.addConnectionProperty(string3, properties2.getProperty(string3));
            }
        }
        BasicDataSourceFactory.acceptDurationOfMillis(properties, PROP_MAX_CONN_LIFETIME_MILLIS, basicDataSource::setMaxConn);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_LOG_EXPIRED_CONNECTIONS, basicDataSource::setLogExpiredConnections);
        BasicDataSourceFactory.acceptString(properties, PROP_JMX_NAME, basicDataSource::setJmxName);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_REGISTER_CONNECTION_MBEAN, basicDataSource::setRegisterConnectionMBean);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_ENABLE_AUTO_COMMIT_ON_RETURN, basicDataSource::setAutoCommitOnReturn);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_ROLLBACK_ON_RETURN, basicDataSource::setRollbackOnReturn);
        BasicDataSourceFactory.acceptDurationOfSeconds(properties, PROP_DEFAULT_QUERY_TIMEOUT, basicDataSource::setDefaultQueryTimeout);
        BasicDataSourceFactory.acceptBoolean(properties, PROP_FAST_FAIL_VALIDATION, basicDataSource::setFastFailValidation);
        BasicDataSourceFactory.getOptional(properties, PROP_DISCONNECTION_SQL_CODES).ifPresent(string -> basicDataSource.setDisconnectionSqlCodes(BasicDataSourceFactory.parseList(string, ',')));
        BasicDataSourceFactory.getOptional(properties, PROP_DISCONNECTION_IGNORE_SQL_CODES).ifPresent(string -> basicDataSource.setDisconnectionIgnoreSqlCodes(BasicDataSourceFactory.parseList(string, ',')));
        BasicDataSourceFactory.acceptString(properties, PROP_CONNECTION_FACTORY_CLASS_NAME, basicDataSource::setConnectionFactoryClassName);
        if (basicDataSource.getInitialSize() > 0) {
            basicDataSource.getLogWriter();
        }
        return basicDataSource;
    }

    private static Optional<String> getOptional(Properties properties, String string) {
        return Optional.ofNullable(properties.getProperty(string));
    }

    private static Properties getProperties(String string) throws SQLException {
        Properties properties = new Properties();
        if (string != null) {
            try {
                properties.load(new ByteArrayInputStream(string.replace(';', '\n').getBytes(StandardCharsets.ISO_8859_1)));
            }
            catch (IOException iOException) {
                throw new SQLException(string, iOException);
            }
        }
        return properties;
    }

    private static List<String> parseList(String string, char c) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, Character.toString(c));
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws SQLException {
        if (object == null || !(object instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)object;
        if (!"javax.sql.DataSource".equals(reference.getClassName())) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.validatePropertyNames(reference, name, arrayList, arrayList2);
        arrayList.forEach(arg_0 -> ((Log)log).warn(arg_0));
        arrayList2.forEach(arg_0 -> ((Log)log).info(arg_0));
        Properties properties = new Properties();
        ALL_PROPERTY_NAMES.forEach(string -> {
            RefAddr refAddr = reference.get((String)string);
            if (refAddr != null) {
                properties.setProperty((String)string, Objects.toString(refAddr.getContent(), null));
            }
        });
        return BasicDataSourceFactory.createDataSource(properties);
    }

    private void validatePropertyNames(Reference reference, Name name, List<String> list, List<String> list2) {
        String string = name != null ? "Name = " + name.toString() + " " : "";
        NUPROP_WARNTEXT.forEach((string2, string3) -> {
            RefAddr refAddr = reference.get((String)string2);
            if (refAddr != null && !ALL_PROPERTY_NAMES.contains(refAddr.getType())) {
                StringBuilder stringBuilder = new StringBuilder(string);
                String string4 = Objects.toString(refAddr.getContent(), null);
                stringBuilder.append((String)string3).append(" You have set value of \"").append(string4).append("\" for \"").append((String)string2).append("\" property, which is being ignored.");
                list.add(stringBuilder.toString());
            }
        });
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            RefAddr refAddr = enumeration.nextElement();
            String string4 = refAddr.getType();
            if (ALL_PROPERTY_NAMES.contains(string4) || NUPROP_WARNTEXT.containsKey(string4) || SILENT_PROPERTIES.contains(string4)) continue;
            String string5 = Objects.toString(refAddr.getContent(), null);
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append("Ignoring unknown property: ").append("value of \"").append(string5).append("\" for \"").append(string4).append("\" property");
            list2.add(stringBuilder.toString());
        }
    }

    static {
        NUPROP_WARNTEXT.put(NUPROP_MAX_ACTIVE, "Property maxActive is not used in DBCP2, use maxTotal instead. maxTotal default value is 8.");
        NUPROP_WARNTEXT.put(NUPROP_REMOVE_ABANDONED, "Property removeAbandoned is not used in DBCP2, use one or both of removeAbandonedOnBorrow or removeAbandonedOnMaintenance instead. Both have default value set to false.");
        NUPROP_WARNTEXT.put(NUPROP_MAXWAIT, "Property maxWait is not used in DBCP2 , use maxWaitMillis instead. maxWaitMillis default value is " + String.valueOf(BaseObjectPoolConfig.DEFAULT_MAX_WAIT) + ".");
        SILENT_PROPERTIES = new ArrayList<String>();
        SILENT_PROPERTIES.add(SILENT_PROP_FACTORY);
        SILENT_PROPERTIES.add(SILENT_PROP_SCOPE);
        SILENT_PROPERTIES.add(SILENT_PROP_SINGLETON);
        SILENT_PROPERTIES.add(SILENT_PROP_AUTH);
    }
}

