/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;

public class TextEncoding
implements OdfDataType {
    private String mTextEncoding;
    private static final Pattern textEncodingPattern = Pattern.compile("^[A-Za-z][A-Za-z0-9._\\-]*$");

    public TextEncoding(String textEncoding) throws IllegalArgumentException {
        if (!TextEncoding.isValid(textEncoding)) {
            throw new IllegalArgumentException("parameter is invalid for datatype TextEncoding");
        }
        this.mTextEncoding = textEncoding;
    }

    public String toString() {
        return this.mTextEncoding;
    }

    public static TextEncoding valueOf(String stringValue) throws IllegalArgumentException {
        return new TextEncoding(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && textEncodingPattern.matcher(stringValue).matches();
    }
}

