/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Netscape Portable Runtime (NSPR).
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998-2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef prmon_h___
#define prmon_h___

#include "prtypes.h"

#ifdef VBOX
# include <iprt/types.h>
#endif

#ifdef VBOX_WITH_XPCOM_NAMESPACE_CLEANUP
#define PR_EnterMonitor VBoxNsprPR_EnterMonitor
#define PR_ExitMonitor VBoxNsprPR_ExitMonitor
#define PR_Notify VBoxNsprPR_Notify
#define PR_NotifyAll VBoxNsprPR_NotifyAll
#define PR_Wait VBoxNsprPR_Wait
#define PR_NewMonitor VBoxNsprPR_NewMonitor
#define PR_DestroyMonitor VBoxNsprPR_DestroyMonitor
#define PR_GetMonitorEntryCount VBoxNsprPR_GetMonitorEntryCount
#define PR_NewNamedMonitor VBoxNsprPR_NewNamedMonitor
#endif /* VBOX_WITH_XPCOM_NAMESPACE_CLEANUP */

PR_BEGIN_EXTERN_C

typedef struct PRMonitor PRMonitor;

#ifdef VBOX
/*
** Create a new monitor. Monitors are re-entrant locks with a single built-in
** condition variable.
**
** This may fail if memory is tight or if some operating system resource
** is low.
*/
NSPR_API(PRMonitor*) PR_NewMonitor(void);

/*
** Destroy a monitor. The caller is responsible for guaranteeing that the
** monitor is no longer in use. There must be no thread waiting on the monitor's
** condition variable and that the lock is not held.
**
*/
NSPR_API(void) PR_DestroyMonitor(PRMonitor *mon);

/*
** Enter the lock associated with the monitor. If the calling thread currently
** is in the monitor, the call to enter will silently succeed. In either case,
** it will increment the entry count by one.
*/
NSPR_API(void) PR_EnterMonitor(PRMonitor *mon);

/*
** Decrement the entry count associated with the monitor. If the decremented
** entry count is zero, the monitor is exited. Returns PR_FAILURE if the
** calling thread has not entered the monitor.
*/
NSPR_API(PRStatus) PR_ExitMonitor(PRMonitor *mon);

/*
** Wait for a notify on the monitor's condition variable. Sleep for "ticks"
** amount of time (if "ticks" is PR_INTERVAL_NO_TIMEOUT then the sleep is
** indefinite).
**
** While the thread is waiting it exits the monitor (as if it called
** PR_ExitMonitor as many times as it had called PR_EnterMonitor).  When
** the wait has finished the thread regains control of the monitors lock
** with the same entry count as before the wait began.
**
** The thread waiting on the monitor will be resumed when the monitor is
** notified (assuming the thread is the next in line to receive the
** notify) or when the "ticks" timeout elapses.
**
** Returns PR_FAILURE if the caller has not entered the monitor.
*/
NSPR_API(PRStatus) PR_Wait(PRMonitor *mon, RTMSINTERVAL msWait);

/*
** Notify a thread waiting on the monitor's condition variable. If a thread
** is waiting on the condition variable (using PR_Wait) then it is awakened
** and attempts to reenter the monitor.
*/
NSPR_API(PRStatus) PR_Notify(PRMonitor *mon);

/*
** Notify all of the threads waiting on the monitor's condition variable.
** All of threads waiting on the condition are scheduled to reenter the
** monitor.
*/
NSPR_API(PRStatus) PR_NotifyAll(PRMonitor *mon);

/*
** Return the number of times that the current thread has entered the
** mutex. Returns zero if the current thread has not entered the mutex.
*/
NSPR_API(uint32_t) PR_GetMonitorEntryCount(PRMonitor *mon);

NSPR_API(PRMonitor*) PR_NewNamedMonitor(const char* name);
#endif

PR_END_EXTERN_C

#endif /* prmon_h___ */
