# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.paloaltonetworksngfw.aio import PaloAltoNetworksNgfwMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPaloAltoNetworksNgfwMgmtGlobalRulestackOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PaloAltoNetworksNgfwMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_list(self, resource_group):
        response = self.client.global_rulestack.list(
            api_version="2025-10-08",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_get(self, resource_group):
        response = await self.client.global_rulestack.get(
            global_rulestack_name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.global_rulestack.begin_create_or_update(
                global_rulestack_name="str",
                resource={
                    "location": "str",
                    "associatedSubscriptions": ["str"],
                    "defaultMode": "str",
                    "description": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "minAppIdVersion": "str",
                    "name": "str",
                    "panEtag": "str",
                    "panLocation": "str",
                    "provisioningState": "str",
                    "scope": "str",
                    "securityServices": {
                        "antiSpywareProfile": "str",
                        "antiVirusProfile": "str",
                        "dnsSubscription": "str",
                        "fileBlockingProfile": "str",
                        "outboundTrustCertificate": "str",
                        "outboundUnTrustCertificate": "str",
                        "urlFilteringProfile": "str",
                        "vulnerabilityProfile": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2025-10-08",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_update(self, resource_group):
        response = await self.client.global_rulestack.update(
            global_rulestack_name="str",
            properties={
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "location": "str",
                "properties": {
                    "associatedSubscriptions": ["str"],
                    "defaultMode": "str",
                    "description": "str",
                    "minAppIdVersion": "str",
                    "panEtag": "str",
                    "panLocation": "str",
                    "scope": "str",
                    "securityServices": {
                        "antiSpywareProfile": "str",
                        "antiVirusProfile": "str",
                        "dnsSubscription": "str",
                        "fileBlockingProfile": "str",
                        "outboundTrustCertificate": "str",
                        "outboundUnTrustCertificate": "str",
                        "urlFilteringProfile": "str",
                        "vulnerabilityProfile": "str",
                    },
                },
            },
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_begin_delete(self, resource_group):
        response = await (
            await self.client.global_rulestack.begin_delete(
                global_rulestack_name="str",
                api_version="2025-10-08",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_begin_commit(self, resource_group):
        response = await (
            await self.client.global_rulestack.begin_commit(
                global_rulestack_name="str",
                api_version="2025-10-08",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_get_change_log(self, resource_group):
        response = await self.client.global_rulestack.get_change_log(
            global_rulestack_name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_list_advanced_security_objects(self, resource_group):
        response = await self.client.global_rulestack.list_advanced_security_objects(
            global_rulestack_name="str",
            type="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_list_app_ids(self, resource_group):
        response = await self.client.global_rulestack.list_app_ids(
            global_rulestack_name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_list_countries(self, resource_group):
        response = await self.client.global_rulestack.list_countries(
            global_rulestack_name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_list_firewalls(self, resource_group):
        response = await self.client.global_rulestack.list_firewalls(
            global_rulestack_name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_list_predefined_url_categories(self, resource_group):
        response = await self.client.global_rulestack.list_predefined_url_categories(
            global_rulestack_name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_list_security_services(self, resource_group):
        response = await self.client.global_rulestack.list_security_services(
            global_rulestack_name="str",
            type="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_global_rulestack_revert(self, resource_group):
        response = await self.client.global_rulestack.revert(
            global_rulestack_name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...
