# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterJitNetworkAccessPoliciesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_jit_network_access_policies_list(self, resource_group):
        response = self.client.jit_network_access_policies.list(
            api_version="2020-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_jit_network_access_policies_list_by_region(self, resource_group):
        response = self.client.jit_network_access_policies.list_by_region(
            asc_location="str",
            api_version="2020-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_jit_network_access_policies_list_by_resource_group(self, resource_group):
        response = self.client.jit_network_access_policies.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2020-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_jit_network_access_policies_list_by_resource_group_and_region(self, resource_group):
        response = self.client.jit_network_access_policies.list_by_resource_group_and_region(
            resource_group_name=resource_group.name,
            asc_location="str",
            api_version="2020-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_jit_network_access_policies_get(self, resource_group):
        response = await self.client.jit_network_access_policies.get(
            resource_group_name=resource_group.name,
            asc_location="str",
            jit_network_access_policy_name="str",
            api_version="2020-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_jit_network_access_policies_create_or_update(self, resource_group):
        response = await self.client.jit_network_access_policies.create_or_update(
            resource_group_name=resource_group.name,
            asc_location="str",
            jit_network_access_policy_name="str",
            body={
                "virtualMachines": [
                    {
                        "id": "str",
                        "ports": [
                            {
                                "maxRequestAccessDuration": "str",
                                "number": 0,
                                "protocol": "str",
                                "allowedSourceAddressPrefix": "str",
                                "allowedSourceAddressPrefixes": ["str"],
                            }
                        ],
                        "publicIpAddress": "str",
                    }
                ],
                "id": "str",
                "kind": "str",
                "location": "str",
                "name": "str",
                "provisioningState": "str",
                "requests": [
                    {
                        "requestor": "str",
                        "startTimeUtc": "2020-02-20 00:00:00",
                        "virtualMachines": [
                            {
                                "id": "str",
                                "ports": [
                                    {
                                        "endTimeUtc": "2020-02-20 00:00:00",
                                        "number": 0,
                                        "status": "str",
                                        "statusReason": "str",
                                        "allowedSourceAddressPrefix": "str",
                                        "allowedSourceAddressPrefixes": ["str"],
                                        "mappedPort": 0,
                                    }
                                ],
                            }
                        ],
                        "justification": "str",
                    }
                ],
                "type": "str",
            },
            api_version="2020-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_jit_network_access_policies_delete(self, resource_group):
        response = await self.client.jit_network_access_policies.delete(
            resource_group_name=resource_group.name,
            asc_location="str",
            jit_network_access_policy_name="str",
            api_version="2020-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_jit_network_access_policies_initiate(self, resource_group):
        response = await self.client.jit_network_access_policies.initiate(
            resource_group_name=resource_group.name,
            asc_location="str",
            jit_network_access_policy_name="str",
            body={
                "virtualMachines": [
                    {
                        "id": "str",
                        "ports": [
                            {"endTimeUtc": "2020-02-20 00:00:00", "number": 0, "allowedSourceAddressPrefix": "str"}
                        ],
                    }
                ],
                "justification": "str",
            },
            jit_network_access_policy_initiate_type="initiate",
            api_version="2020-01-01",
        )

        # please add some check logic here by yourself
        # ...
