% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-nudge.R
\name{position_nudge}
\alias{position_nudge}
\title{Nudge points a fixed distance}
\usage{
position_nudge(x = NULL, y = NULL)
}
\arguments{
\item{x, y}{Amount of vertical and horizontal distance to move.}
}
\description{
\code{position_nudge()} is generally useful for adjusting the position of
items on discrete scales by a small amount. Nudging is built in to
\code{\link[=geom_text]{geom_text()}} because it's so useful for moving labels a small
distance from what they're labelling.
}
\examples{
df <- data.frame(
  x = c(1,3,2,5),
  y = c("a","c","d","c")
)

ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y))

ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y), position = position_nudge(y = -0.1))

# Or, in brief
ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y), nudge_y = -0.1)

# For each text individually
ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y, nudge_y = c(-0.1, 0.1, -0.1, 0.1)))
}
\seealso{
Other position adjustments: 
\code{\link{position_dodge}()},
\code{\link{position_identity}()},
\code{\link{position_jitter}()},
\code{\link{position_jitterdodge}()},
\code{\link{position_stack}()}
}
\concept{position adjustments}
\section{Aesthetics}{

\code{position_nudge()} understands the following aesthetics. Required aesthetics are displayed in bold and defaults are displayed for optional aesthetics:
\tabular{rll}{
 • \tab \code{nudge_x} \tab → \code{0} \cr
 • \tab \code{nudge_y} \tab → \code{0} \cr
}

Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}
